/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.utils.LogContext;

public class ConsumerMetadata
extends Metadata {
    private final boolean includeInternalTopics;
    private final boolean allowAutoTopicCreation;
    private final SubscriptionState subscription;
    private final Set<String> transientTopics;

    public ConsumerMetadata(long refreshBackoffMs, long refreshBackoffMaxMs, long metadataExpireMs, boolean includeInternalTopics, boolean allowAutoTopicCreation, SubscriptionState subscription, LogContext logContext, ClusterResourceListeners clusterResourceListeners) {
        super(refreshBackoffMs, refreshBackoffMaxMs, metadataExpireMs, logContext, clusterResourceListeners);
        this.includeInternalTopics = includeInternalTopics;
        this.allowAutoTopicCreation = allowAutoTopicCreation;
        this.subscription = subscription;
        this.transientTopics = new HashSet<String>();
    }

    public ConsumerMetadata(ConsumerConfig config, SubscriptionState subscriptions, LogContext logContext, ClusterResourceListeners clusterResourceListeners) {
        this(config.getLong("retry.backoff.ms"), config.getLong("retry.backoff.max.ms"), config.getLong("metadata.max.age.ms"), config.getBoolean("exclude.internal.topics") == false, config.getBoolean("allow.auto.create.topics"), subscriptions, logContext, clusterResourceListeners);
    }

    public boolean allowAutoTopicCreation() {
        return this.allowAutoTopicCreation;
    }

    @Override
    public synchronized MetadataRequest.Builder newMetadataRequestBuilder() {
        if (this.subscription.hasPatternSubscription()) {
            return MetadataRequest.Builder.allTopics();
        }
        ArrayList<String> topics = new ArrayList<String>();
        topics.addAll(this.subscription.metadataTopics());
        topics.addAll(this.transientTopics);
        return new MetadataRequest.Builder(topics, this.allowAutoTopicCreation);
    }

    synchronized void addTransientTopics(Set<String> topics) {
        this.transientTopics.addAll(topics);
        if (!this.fetch().topics().containsAll(topics)) {
            this.requestUpdateForNewTopics();
        }
    }

    synchronized void clearTransientTopics() {
        this.transientTopics.clear();
    }

    @Override
    protected synchronized boolean retainTopic(String topic, boolean isInternal, long nowMs) {
        if (this.transientTopics.contains(topic) || this.subscription.needsMetadata(topic)) {
            return true;
        }
        if (isInternal && !this.includeInternalTopics) {
            return false;
        }
        return this.subscription.matchesSubscribedPattern(topic);
    }
}

