/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RateLimiter;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.FileListResponse;
import org.apache.solr.client.api.model.FileMetaData;
import org.apache.solr.client.api.model.IndexVersionResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplicationAPIBase
extends JerseyResource {
    public static final String CONF_FILE_SHORT = "cf";
    public static final String TLOG_FILE = "tlogFile";
    public static final String FILE_STREAM = "filestream";
    public static final String STATUS = "status";
    public static final int PACKET_SZ = 0x100000;
    public static final String GENERATION = "generation";
    public static final String OFFSET = "offset";
    public static final String LEN = "len";
    public static final String FILE = "file";
    public static final String MAX_WRITE_PER_SECOND = "maxWriteMBPerSec";
    public static final String CHECKSUM = "checksum";
    public static final String COMPRESSION = "compression";
    public static final String POLL_INTERVAL = "pollInterval";
    public static final String INTERVAL_ERR_MSG = "The pollInterval must be in this format 'HH:mm:ss'";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Pattern INTERVAL_PATTERN = Pattern.compile("(\\d*?):(\\d*?):(\\d*)");
    protected final SolrCore solrCore;
    protected final SolrQueryRequest solrQueryRequest;
    protected final SolrQueryResponse solrQueryResponse;

    public ReplicationAPIBase(SolrCore solrCore, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        this.solrCore = solrCore;
        this.solrQueryRequest = solrQueryRequest;
        this.solrQueryResponse = solrQueryResponse;
    }

    protected IndexVersionResponse doFetchIndexVersion() throws IOException {
        ReplicationHandler replicationHandler = (ReplicationHandler)this.solrCore.getRequestHandler("/replication");
        return replicationHandler.getIndexVersionResponse();
    }

    protected FileListResponse doFetchFileList(long generation) {
        ReplicationHandler replicationHandler = (ReplicationHandler)this.solrCore.getRequestHandler("/replication");
        return this.getFileList(generation, replicationHandler);
    }

    protected DirectoryFileStream doFetchFile(String filePath, String dirType, String offset, String len, boolean compression, boolean checksum, double maxWriteMBPerSec, Long gen) {
        DirectoryFileStream dfs = Objects.equals(dirType, CONF_FILE_SHORT) ? new LocalFsConfFileStream(filePath, dirType, offset, len, compression, checksum, maxWriteMBPerSec, gen) : (Objects.equals(dirType, TLOG_FILE) ? new LocalFsTlogFileStream(filePath, dirType, offset, len, compression, checksum, maxWriteMBPerSec, gen) : new DirectoryFileStream(filePath, dirType, offset, len, compression, checksum, maxWriteMBPerSec, gen));
        this.solrQueryResponse.add(FILE_STREAM, dfs);
        return dfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected FileListResponse getFileList(long generation, ReplicationHandler replicationHandler) {
        block50: {
            delPol = this.solrCore.getDeletionPolicy();
            filesResponse = new FileListResponse();
            commit = null;
            if (generation == -1L) {
                commit = delPol.getAndSaveLatestCommit();
                if (null == commit) {
                    filesResponse.fileList = Collections.emptyList();
                    var7_6 = filesResponse;
                    return var7_6;
                }
            } else {
                try {
                    commit = delPol.getAndSaveCommitPoint(generation);
                }
                catch (IllegalStateException var7_7) {
                    // empty catch block
                }
                if (null == commit) {
                    this.reportErrorOnResponse(filesResponse, "invalid index generation", null);
                    var7_8 = filesResponse;
                    return var7_8;
                }
            }
            if (!ReplicationAPIBase.$assertionsDisabled && null == commit) {
                throw new AssertionError();
            }
            result = new ArrayList<FileMetaData>();
            dir = null;
            try {
                dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getNewIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.solrCore.getSolrConfig().indexConfig.lockType);
                infos = SegmentInfos.readCommit((Directory)dir, (String)commit.getSegmentsFileName());
                for (SegmentCommitInfo commitInfo : infos) {
                    for (String file : commitInfo.files()) {
                        metaData = new FileMetaData();
                        metaData.name = file;
                        metaData.size = dir.fileLength(file);
                        in = dir.openInput(file, IOContext.READONCE);
                        try {
                            try {
                                metaData.checksum = checksum = CodecUtil.retrieveChecksum((IndexInput)in);
                            }
                            catch (Exception e) {
                                ReplicationAPIBase.log.warn("Could not read checksum from index file: {}", (Object)file, (Object)e);
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                        result.add(metaData);
                    }
                }
                fileMetaData = new FileMetaData();
                fileMetaData.name = infos.getSegmentsFileName();
                fileMetaData.size = dir.fileLength(infos.getSegmentsFileName());
                if (infos.getId() != null) {
                    in = dir.openInput(infos.getSegmentsFileName(), IOContext.READONCE);
                    try {
                        try {
                            fileMetaData.checksum = CodecUtil.retrieveChecksum((IndexInput)in);
                        }
                        catch (Exception e) {
                            ReplicationAPIBase.log.warn("Could not read checksum from index file: {}", (Object)infos.getSegmentsFileName(), (Object)e);
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                result.add(fileMetaData);
                ** if (dir == null) goto lbl-1000
            }
            catch (IOException e) {
                block49: {
                    try {
                        ReplicationAPIBase.log.error("Unable to get file names for indexCommit generation: {}", (Object)commit.getGeneration(), (Object)e);
                        this.reportErrorOnResponse(filesResponse, "unable to get file names for given index generation", e);
                        var10_15 = filesResponse;
                        if (dir == null) break block49;
                    }
                    catch (Throwable var18_29) {
                        if (dir != null) {
                            try {
                                this.solrCore.getDirectoryFactory().release(dir);
                            }
                            catch (IOException e) {
                                ReplicationAPIBase.log.error("Could not release directory after fetching file list", (Throwable)e);
                            }
                        }
                        throw var18_29;
                    }
                    try {
                        this.solrCore.getDirectoryFactory().release(dir);
                    }
                    catch (IOException e) {
                        ReplicationAPIBase.log.error("Could not release directory after fetching file list", (Throwable)e);
                    }
                }
                if (null != commit) {
                    delPol.setReserveDuration(commit.getGeneration(), replicationHandler.getReserveCommitDuration());
                    delPol.releaseCommitPoint(commit);
                }
                return var10_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.solrCore.getDirectoryFactory().release(dir);
                }
                catch (IOException e) {
                    ReplicationAPIBase.log.error("Could not release directory after fetching file list", (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
            }
            filesResponse.fileList = new ArrayList<E>(result);
            if (replicationHandler.getConfFileNameAlias().size() >= 1 && !this.solrCore.getCoreContainer().isZooKeeperAware()) ** GOTO lbl-1000
            e = filesResponse;
            return e;
lbl-1000:
            // 1 sources

            {
                includeConfFiles = replicationHandler.getIncludeConfFiles();
                ReplicationAPIBase.log.debug("Adding config files to list: {}", (Object)includeConfFiles);
                filesResponse.confFiles = new ArrayList<FileMetaData>(replicationHandler.getConfFileInfoFromCache(replicationHandler.getConfFileNameAlias(), replicationHandler.getConfFileInfoCache()));
                filesResponse.status = "OK";
                break block50;
            }
            finally {
                if (null != commit) {
                    delPol.setReserveDuration(commit.getGeneration(), replicationHandler.getReserveCommitDuration());
                    delPol.releaseCommitPoint(commit);
                }
            }
        }
        return filesResponse;
    }

    private void reportErrorOnResponse(FileListResponse fileListResponse, String message, Exception e) {
        fileListResponse.status = "ERROR";
        fileListResponse.message = message;
        if (e != null) {
            fileListResponse.exception = e;
        }
    }

    protected class LocalFsConfFileStream
    extends LocalFsFileStream {
        public LocalFsConfFileStream(String file, String dirType, String offset, String len, boolean compression, boolean useChecksum, double maxWriteMBPerSec, Long gen) {
            super(file, dirType, offset, len, compression, useChecksum, maxWriteMBPerSec, gen);
        }

        @Override
        protected Path initFile() {
            return ReplicationAPIBase.this.solrCore.getResourceLoader().getConfigPath().resolve(this.cfileName);
        }
    }

    protected class LocalFsTlogFileStream
    extends LocalFsFileStream {
        public LocalFsTlogFileStream(String file, String dirType, String offset, String len, boolean compression, boolean useChecksum, double maxWriteMBPerSec, Long gen) {
            super(file, dirType, offset, len, compression, useChecksum, maxWriteMBPerSec, gen);
        }

        @Override
        protected Path initFile() {
            return Path.of(ReplicationAPIBase.this.solrCore.getUpdateHandler().getUpdateLog().getTlogDir(), this.tlogFileName);
        }
    }

    protected abstract class LocalFsFileStream
    extends DirectoryFileStream {
        private Path file;

        public LocalFsFileStream(String file, String dirType, String offset, String len, boolean compression, boolean useChecksum, double maxWriteMBPerSec, Long gen) {
            super(file, dirType, offset, len, compression, useChecksum, maxWriteMBPerSec, gen);
            this.file = this.initFile();
        }

        protected abstract Path initFile();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream out) throws IOException {
            block16: {
                this.createOutputStream(out);
                try {
                    this.initWrite();
                    if (Files.isReadable(this.file)) {
                        try (SeekableByteChannel channel = Files.newByteChannel(this.file, new OpenOption[0]);){
                            if (this.offset != -1L) {
                                channel.position(this.offset);
                            }
                            ByteBuffer bb = ByteBuffer.wrap(this.buf);
                            while (true) {
                                bb.clear();
                                long bytesRead = channel.read(bb);
                                if (bytesRead <= 0L) {
                                    this.writeNothingAndFlush();
                                    this.fos.close();
                                    break block16;
                                }
                                this.fos.writeInt((int)bytesRead);
                                if (this.useChecksum) {
                                    this.checksum.reset();
                                    this.checksum.update(this.buf, 0, (int)bytesRead);
                                    this.fos.writeLong(this.checksum.getValue());
                                }
                                this.fos.write(this.buf, 0, (int)bytesRead);
                                this.fos.flush();
                            }
                        }
                    }
                    this.writeNothingAndFlush();
                }
                catch (IOException e) {
                    log.warn("Exception while writing response for params fileName={} cfileName={} tlogFileName={} offset={} len={} compression={} generation={} checksum={}", new Object[]{this.fileName, this.cfileName, this.tlogFileName, this.sOffset, this.sLen, this.compress, this.indexGen, this.useChecksum});
                }
                finally {
                    this.extendReserveAndReleaseCommitPoint();
                }
            }
        }
    }

    protected class DirectoryFileStream
    implements SolrCore.RawWriter,
    StreamingOutput {
        protected FastOutputStream fos;
        protected Long indexGen;
        protected IndexDeletionPolicyWrapper delPolicy;
        protected String fileName;
        protected String cfileName;
        protected String tlogFileName;
        protected String sOffset;
        protected String sLen;
        protected final boolean compress;
        protected boolean useChecksum;
        protected long offset = -1L;
        protected int len = -1;
        protected Checksum checksum;
        private RateLimiter rateLimiter;
        byte[] buf;

        public DirectoryFileStream(String file, String dirType, String offset, String len, boolean compression, boolean useChecksum, double maxWriteMBPerSec, Long gen) {
            this.delPolicy = ReplicationAPIBase.this.solrCore.getDeletionPolicy();
            this.fileName = this.validateFilenameOrError(file);
            switch (dirType) {
                case "cf": {
                    this.cfileName = file;
                    break;
                }
                case "tlogFile": {
                    this.tlogFileName = file;
                    break;
                }
                default: {
                    this.fileName = file;
                }
            }
            this.sOffset = offset;
            this.sLen = len;
            this.compress = compression;
            this.useChecksum = useChecksum;
            this.indexGen = gen;
            if (useChecksum) {
                this.checksum = new Adler32();
            }
            this.rateLimiter = maxWriteMBPerSec == 0.0 ? new RateLimiter.SimpleRateLimiter(Double.MAX_VALUE) : new RateLimiter.SimpleRateLimiter(maxWriteMBPerSec);
        }

        protected String validateFilenameOrError(String fileName) {
            if (fileName != null) {
                Path filePath = Paths.get(fileName, new String[0]);
                filePath.forEach(subpath -> {
                    if ("..".equals(subpath.toString())) {
                        throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "File name cannot contain ..");
                    }
                });
                if (filePath.isAbsolute()) {
                    throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "File name must be relative");
                }
                return fileName;
            }
            return null;
        }

        protected void initWrite() throws IOException {
            this.offset = this.sOffset != null ? Long.parseLong(this.sOffset) : -1L;
            int n = this.len = this.sLen != null ? Integer.parseInt(this.sLen) : -1;
            if (this.fileName == null && this.cfileName == null && this.tlogFileName == null) {
                this.writeNothingAndFlush();
            }
            this.buf = new byte[this.len == -1 || this.len > 0x100000 ? 0x100000 : this.len];
            if (this.indexGen != null) {
                this.delPolicy.saveCommitPoint(this.indexGen);
            }
        }

        protected void createOutputStream(OutputStream out) {
            out = new CloseShieldOutputStream(out);
            this.fos = this.compress ? new FastOutputStream((OutputStream)new DeflaterOutputStream(out)) : new FastOutputStream(out);
        }

        protected void extendReserveAndReleaseCommitPoint() {
            ReplicationHandler replicationHandler = (ReplicationHandler)ReplicationAPIBase.this.solrCore.getRequestHandler("/replication");
            if (this.indexGen != null) {
                this.delPolicy.setReserveDuration(this.indexGen, replicationHandler.getReserveCommitDuration());
                this.delPolicy.releaseCommitPoint(this.indexGen);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream out) throws IOException {
            this.createOutputStream(out);
            IndexInput in = null;
            try {
                this.initWrite();
                Directory dir = ReplicationAPIBase.this.solrCore.withSearcher(searcher -> searcher.getIndexReader().directory());
                in = dir.openInput(this.fileName, IOContext.READONCE);
                if (this.offset != -1L) {
                    in.seek(this.offset);
                }
                long filelen = dir.fileLength(this.fileName);
                long maxBytesBeforePause = 0L;
                while (true) {
                    this.offset = this.offset == -1L ? 0L : this.offset;
                    int read = (int)Math.min((long)this.buf.length, filelen - this.offset);
                    in.readBytes(this.buf, 0, read);
                    this.fos.writeInt(read);
                    if (this.useChecksum) {
                        this.checksum.reset();
                        this.checksum.update(this.buf, 0, read);
                        this.fos.writeLong(this.checksum.getValue());
                    }
                    this.fos.write(this.buf, 0, read);
                    this.fos.flush();
                    log.debug("Wrote {} bytes for file {}", (Object)(this.offset + (long)read), (Object)this.fileName);
                    if ((maxBytesBeforePause += (long)read) >= this.rateLimiter.getMinPauseCheckBytes()) {
                        this.rateLimiter.pause(maxBytesBeforePause);
                        maxBytesBeforePause = 0L;
                    }
                    if (read != this.buf.length) {
                        this.writeNothingAndFlush();
                        this.fos.close();
                        break;
                    }
                    this.offset += (long)read;
                    in.seek(this.offset);
                }
            }
            catch (IOException e) {
                log.warn("Exception while writing response for params fileName={} cfileName={} tlogFileName={} offset={} len={} compression={} generation={} checksum={}", new Object[]{this.fileName, this.cfileName, this.tlogFileName, this.sOffset, this.sLen, this.compress, this.indexGen, this.useChecksum});
            }
            finally {
                if (in != null) {
                    in.close();
                }
                this.extendReserveAndReleaseCommitPoint();
            }
        }

        protected void writeNothingAndFlush() throws IOException {
            this.fos.writeInt(0);
            this.fos.flush();
        }
    }
}

