# -*- warn-indent:false;  -*-
#
# THIS IS A GENERATED FILE, DO NOT EDIT DIRECTLY
#
# This file was generated from scanner.rl
# by running `bundle exec rake ragel:rb`


require_relative 'scanner/errors/scanner_error'
require_relative 'scanner/errors/premature_end_error'
require_relative 'scanner/errors/validation_error'

class Regexp::Scanner
  # Scans the given regular expression text, or Regexp object and collects the
  # emitted token into an array that gets returned at the end. If a block is
  # given, it gets called for each emitted token.
  #
  # This method may raise errors if a syntax error is encountered.
  # --------------------------------------------------------------------------
  def self.scan(input_object, options: nil, collect_tokens: true, &block)
    new.scan(input_object, options: options, collect_tokens: collect_tokens, &block)
  end

  def scan(input_object, options: nil, collect_tokens: true, &block)
    self.collect_tokens = collect_tokens
    self.literal_run = nil
    stack = []

    input = input_object.is_a?(Regexp) ? input_object.source : input_object
    self.free_spacing = free_spacing?(input_object, options)
    self.spacing_stack = [{:free_spacing => free_spacing, :depth => 0}]

    data  = input.unpack("c*")
    eof   = data.length

    self.tokens = []
    self.block  = block

    self.set_depth = 0
    self.group_depth = 0
    self.conditional_stack = []
    self.char_pos = 0

class << self
	attr_accessor :_re_scanner_trans_keys
	private :_re_scanner_trans_keys, :_re_scanner_trans_keys=
end
self._re_scanner_trans_keys = [
0,0,-128,-65,-128,-65,
-128,-65,41,41,-62,
57,-128,-65,-62,39,
-128,-65,-128,-65,-62,62,
-128,-65,-62,62,-128,
-65,-128,-65,39,60,
-62,57,-128,-65,-62,39,
-128,-65,-128,-65,48,
57,39,57,48,57,
39,57,-62,62,-128,-65,
-62,62,-128,-65,-128,
-65,48,57,43,62,
48,57,48,62,39,60,
-62,57,-128,-65,-62,
39,-128,-65,-128,-65,
48,57,39,57,48,57,
39,57,-62,62,-128,
-65,-62,62,-128,-65,
-128,-65,48,57,43,62,
48,57,48,62,48,
57,48,125,44,125,
123,123,9,122,9,125,
9,122,-128,-65,-128,
-65,-128,-65,38,38,
58,93,58,93,-128,-65,
-128,-65,-128,-65,45,
45,92,92,92,92,
45,45,92,92,92,92,
48,123,48,102,48,
102,48,102,48,102,
9,125,9,125,9,125,
9,125,9,125,9,
125,48,123,-128,-65,
-62,39,-128,-65,-128,-65,
41,41,41,57,-128,
-65,-62,62,-128,-65,
-128,-65,-62,127,-62,-12,
1,127,1,127,9,
32,33,126,10,10,
63,63,33,126,33,126,
43,63,43,63,43,
63,65,122,44,57,
68,119,80,112,-62,125,
38,38,38,93,58,
58,48,120,48,55,
48,55,-62,125,48,55,
48,55,48,57,77,
77,45,45,0,0,
67,99,45,45,0,0,
92,92,48,102,39,
60,-62,57,48,57,
41,57,-62,62,0
]

class << self
	attr_accessor :_re_scanner_key_spans
	private :_re_scanner_key_spans, :_re_scanner_key_spans=
end
self._re_scanner_key_spans = [
0,64,64,64,1,120,64,102,
64,64,125,64,125,64,64,22,
120,64,102,64,64,10,19,10,
19,125,64,125,64,64,10,20,
10,15,22,120,64,102,64,64,
10,19,10,19,125,64,125,64,
64,10,20,10,15,10,78,82,
1,114,117,114,64,64,64,1,
36,36,64,64,64,1,1,1,
1,1,1,76,55,55,55,55,
117,117,117,117,117,117,76,64,
102,64,64,1,17,64,125,64,
64,190,51,127,127,24,94,1,
1,94,94,21,21,21,58,14,
52,33,188,1,56,1,73,8,
8,188,8,8,10,1,1,0,
33,1,0,1,55,22,120,10,
17,125
]

class << self
	attr_accessor :_re_scanner_index_offsets
	private :_re_scanner_index_offsets, :_re_scanner_index_offsets=
end
self._re_scanner_index_offsets = [
0,0,65,130,195,197,318,383,
486,551,616,742,807,933,998,1063,
1086,1207,1272,1375,1440,1505,1516,1536,
1547,1567,1693,1758,1884,1949,2014,2025,
2046,2057,2073,2096,2217,2282,2385,2450,
2515,2526,2546,2557,2577,2703,2768,2894,
2959,3024,3035,3056,3067,3083,3094,3173,
3256,3258,3373,3491,3606,3671,3736,3801,
3803,3840,3877,3942,4007,4072,4074,4076,
4078,4080,4082,4084,4161,4217,4273,4329,
4385,4503,4621,4739,4857,4975,5093,5170,
5235,5338,5403,5468,5470,5488,5553,5679,
5744,5809,6000,6052,6180,6308,6333,6428,
6430,6432,6527,6622,6644,6666,6688,6747,
6762,6815,6849,7038,7040,7097,7099,7173,
7182,7191,7380,7389,7398,7409,7411,7413,
7414,7448,7450,7451,7453,7509,7532,7653,
7664,7682
]

class << self
	attr_accessor :_re_scanner_indicies
	private :_re_scanner_indicies, :_re_scanner_indicies=
end
self._re_scanner_indicies = [
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
0,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,0,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,0,6,5,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,8,8,8,8,8,
8,8,8,8,8,8,8,8,
8,8,8,9,9,9,9,9,
4,4,4,4,4,4,4,4,
4,4,4,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,11,10,10,10,10,10,
4,10,10,4,4,4,4,4,
4,4,4,4,4,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,4,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,8,8,8,
8,8,8,8,8,8,8,8,
8,8,8,8,8,9,9,9,
9,9,4,4,4,4,4,4,
4,4,4,4,4,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,
10,10,10,10,11,10,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,
7,7,7,7,7,7,4,8,
8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,4,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,13,13,
13,13,13,13,13,13,13,13,
13,13,13,13,13,13,14,14,
14,14,14,4,4,4,4,4,
4,4,4,4,4,4,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,16,
15,15,15,15,15,15,15,15,
15,15,15,4,15,15,4,4,
4,4,4,4,4,4,4,4,
15,15,15,16,11,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,4,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,13,13,13,
13,13,13,13,13,13,13,13,
13,13,13,13,13,14,14,14,
14,14,4,4,4,4,4,4,
4,4,4,4,4,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,15,15,15,15,15,
15,15,15,11,15,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,
12,12,12,12,12,4,13,13,
13,13,13,13,13,13,13,13,
13,13,13,13,13,13,13,13,
13,13,13,13,13,13,13,13,
13,13,13,13,13,13,13,13,
13,13,13,13,13,13,13,13,
13,13,13,13,13,13,13,13,
13,13,13,13,13,13,13,13,
13,13,13,13,13,13,4,18,
17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,
17,17,17,17,19,17,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,21,21,21,21,
21,21,21,21,21,21,21,21,
21,21,21,21,22,22,22,22,
22,17,17,17,17,17,17,17,
17,17,17,17,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,24,23,23,23,23,
23,25,23,23,26,26,26,26,
26,26,26,26,26,26,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,17,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,21,21,
21,21,21,21,21,21,21,21,
21,21,21,21,21,21,22,22,
22,22,22,17,17,17,17,17,
17,17,17,17,17,17,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,
23,23,23,23,23,24,23,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,17,
21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,
17,26,26,26,26,26,26,26,
26,26,26,17,24,17,17,17,
27,17,27,17,17,26,26,26,
26,26,26,26,26,26,26,17,
28,28,28,28,28,28,28,28,
28,28,17,24,17,17,17,17,
17,17,17,17,28,28,28,28,
28,28,28,28,28,28,17,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,30,30,30,
30,30,30,30,30,30,30,30,
30,30,30,30,30,31,31,31,
31,31,17,17,17,17,17,17,
17,17,17,17,17,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,17,32,
32,32,32,32,32,32,32,32,
32,32,33,32,32,34,34,34,
34,34,34,34,34,34,34,32,
32,32,17,24,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,17,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,30,30,30,30,
30,30,30,30,30,30,30,30,
30,30,30,30,31,31,31,31,
31,17,17,17,17,17,17,17,
17,17,17,17,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,
32,32,24,32,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,
29,29,29,29,17,30,30,30,
30,30,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,
30,30,30,30,30,17,34,34,
34,34,34,34,34,34,34,34,
17,35,17,35,17,17,34,34,
34,34,34,34,34,34,34,34,
17,17,17,17,24,17,36,36,
36,36,36,36,36,36,36,36,
17,36,36,36,36,36,36,36,
36,36,36,17,17,17,17,24,
17,37,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,
17,17,17,17,17,17,38,17,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,40,40,
40,40,40,40,40,40,40,40,
40,40,40,40,40,40,41,41,
41,41,41,17,17,17,17,17,
17,17,17,17,17,17,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,43,42,42,
42,42,42,44,42,42,45,45,
45,45,45,45,45,45,45,45,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,17,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,
41,41,41,41,41,17,17,17,
17,17,17,17,17,17,17,17,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,42,
42,42,42,42,42,42,42,43,
42,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,
39,17,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,
40,40,17,45,45,45,45,45,
45,45,45,45,45,17,43,17,
17,17,46,17,46,17,17,45,
45,45,45,45,45,45,45,45,
45,17,47,47,47,47,47,47,
47,47,47,47,17,43,17,17,
17,17,17,17,17,17,47,47,
47,47,47,47,47,47,47,47,
17,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,49,
49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,50,
50,50,50,50,17,17,17,17,
17,17,17,17,17,17,17,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
17,51,51,51,51,51,51,51,
51,51,51,51,52,51,51,53,
53,53,53,53,53,53,53,53,
53,51,51,51,17,43,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,17,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,49,49,
49,49,49,49,49,49,49,49,
49,49,49,49,49,49,50,50,
50,50,50,17,17,17,17,17,
17,17,17,17,17,17,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,51,51,51,51,
51,51,51,51,43,51,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,
48,48,48,48,48,48,17,49,
49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,17,
53,53,53,53,53,53,53,53,
53,53,17,54,17,54,17,17,
53,53,53,53,53,53,53,53,
53,53,17,17,17,17,43,17,
55,55,55,55,55,55,55,55,
55,55,17,55,55,55,55,55,
55,55,55,55,55,17,17,17,
17,43,17,57,57,57,57,57,
57,57,57,57,57,56,57,57,
57,57,57,57,57,57,57,57,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,58,56,57,56,56,
56,59,59,59,59,59,59,59,
59,59,59,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,
56,56,56,56,56,56,58,56,
60,61,62,62,62,62,62,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,62,61,61,61,61,61,61,
61,61,61,61,61,61,62,62,
61,62,62,62,62,62,62,62,
62,62,62,61,61,61,62,61,
61,61,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,61,61,61,63,
62,61,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,61,62,62,62,
62,62,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,62,61,61,61,
61,61,61,61,61,61,61,61,
61,62,62,61,62,62,62,62,
62,62,62,62,62,62,61,61,
61,62,61,61,61,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,61,
61,61,61,62,61,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,61,
61,64,61,62,62,62,62,62,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,62,61,61,61,61,61,
61,61,61,61,61,61,61,62,
62,61,62,62,62,62,62,62,
62,62,62,62,61,61,61,62,
61,61,61,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,61,61,61,
61,62,61,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,
62,62,62,62,62,61,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,61,66,
66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,61,
67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,67,
61,69,68,72,71,71,71,71,
71,71,71,71,71,71,71,71,
71,71,71,71,71,71,71,71,
71,71,71,71,71,71,71,71,
71,71,71,71,73,71,73,71,
72,71,71,71,71,71,71,71,
71,71,71,71,71,71,71,71,
71,71,71,71,71,71,71,71,
71,71,71,71,71,71,71,71,
71,73,71,74,71,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,61,76,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,76,61,77,
77,77,77,77,77,77,77,77,
77,77,77,77,77,77,77,77,
77,77,77,77,77,77,77,77,
77,77,77,77,77,77,77,77,
77,77,77,77,77,77,77,77,
77,77,77,77,77,77,77,77,
77,77,77,77,77,77,77,77,
77,77,77,77,77,77,77,61,
78,61,80,79,82,79,83,61,
85,84,87,84,88,88,88,88,
88,88,88,88,88,88,61,61,
61,61,61,61,61,88,88,88,
88,88,88,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,88,88,88,
88,88,88,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,89,
61,90,90,90,90,90,90,90,
90,90,90,61,61,61,61,61,
61,61,90,90,90,90,90,90,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,90,90,90,90,90,90,
61,91,91,91,91,91,91,91,
91,91,91,61,61,61,61,61,
61,61,91,91,91,91,91,91,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,91,91,91,91,91,91,
61,92,92,92,92,92,92,92,
92,92,92,61,61,61,61,61,
61,61,92,92,92,92,92,92,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,92,92,92,92,92,92,
61,93,93,93,93,93,93,93,
93,93,93,61,61,61,61,61,
61,61,93,93,93,93,93,93,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,93,93,93,93,93,93,
61,89,89,89,89,89,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
89,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
94,94,94,94,94,94,94,94,
94,94,61,61,61,61,61,61,
61,94,94,94,94,94,94,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,94,94,94,94,94,94,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,92,61,89,
89,89,89,89,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,89,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,95,95,
95,95,95,95,95,95,95,95,
61,61,61,61,61,61,61,95,
95,95,95,95,95,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,95,
95,95,95,95,95,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,92,61,89,89,89,
89,89,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,89,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,96,96,96,96,
96,96,96,96,96,96,61,61,
61,61,61,61,61,96,96,96,
96,96,96,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,96,96,96,
96,96,96,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,92,61,89,89,89,89,89,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,89,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,97,97,97,97,97,97,
97,97,97,97,61,61,61,61,
61,61,61,97,97,97,97,97,
97,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,97,97,97,97,97,
97,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,92,
61,89,89,89,89,89,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
89,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
98,98,98,98,98,98,98,98,
98,98,61,61,61,61,61,61,
61,98,98,98,98,98,98,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,98,98,98,98,98,98,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,92,61,89,
89,89,89,89,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,89,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,92,61,100,100,100,
100,100,100,100,100,100,100,99,
99,99,99,99,99,99,100,100,
100,100,100,100,99,99,99,99,
99,99,99,99,99,99,99,99,
99,99,99,99,99,99,99,99,
99,99,99,99,99,99,100,100,
100,100,100,100,99,99,99,99,
99,99,99,99,99,99,99,99,
99,99,99,99,99,99,99,99,
61,99,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,101,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,
104,105,105,105,105,105,101,101,
101,101,101,101,101,101,101,101,
101,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
106,102,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,101,104,104,104,104,104,
104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,
104,104,104,101,107,101,107,101,
101,101,101,101,101,108,108,108,
108,108,108,108,108,108,108,101,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
101,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,111,
111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,112,
112,112,112,112,101,101,101,101,
101,101,101,101,101,101,101,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,106,109,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,101,
111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,
101,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,113,
113,113,113,113,61,61,61,61,
61,61,61,61,61,61,61,61,
114,114,114,114,114,114,114,114,
115,115,115,115,115,114,114,114,
114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,116,
117,117,118,119,117,117,117,120,
121,122,123,117,117,124,117,117,
117,117,117,117,117,117,117,117,
117,117,117,117,117,117,125,117,
117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,
117,117,126,127,128,129,117,117,
117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,
117,117,130,131,128,117,114,61,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,
2,2,2,2,2,2,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,113,113,
113,113,113,132,114,114,114,114,
114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,
114,114,114,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,
132,132,114,132,114,114,114,114,
114,114,114,114,115,115,115,115,
115,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,
114,114,114,116,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,114,133,116,116,116,116,
116,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,
133,133,133,116,133,117,117,132,
132,117,117,117,132,132,132,132,
117,117,132,117,117,117,117,117,
117,117,117,117,117,117,117,117,
117,117,117,132,117,117,117,117,
117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,132,
132,132,132,117,117,117,117,117,
117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,132,
132,132,117,132,135,118,137,136,
16,139,5,139,139,139,140,141,
138,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,11,139,142,16,11,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,11,139,138,
139,138,139,139,139,138,138,138,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
143,139,138,138,138,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,139,139,139,139,
139,139,139,139,138,139,145,144,
144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,
144,144,145,144,147,146,146,146,
146,146,146,146,146,146,146,146,
146,146,146,146,146,146,146,146,
147,146,149,148,148,148,148,148,
148,148,148,148,148,148,148,148,
148,148,148,148,148,148,149,148,
151,151,150,150,150,150,151,150,
150,150,152,150,150,150,150,150,
150,150,150,150,150,150,150,150,
150,151,150,150,150,150,150,150,
150,151,150,150,150,150,153,150,
150,150,154,150,150,150,150,150,
150,150,150,150,150,150,150,150,
150,151,150,156,155,155,155,59,
59,59,59,59,59,59,59,59,
59,155,157,61,61,61,157,61,
61,61,61,61,61,61,61,61,
157,157,61,61,61,157,157,61,
61,61,61,61,61,61,61,61,
61,61,157,61,61,61,157,61,
61,61,61,61,61,61,61,61,
61,157,61,61,61,157,61,158,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,158,
61,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,67,
67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,159,
159,159,159,159,61,61,61,61,
61,61,61,61,61,61,61,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,160,65,161,65,160,
160,160,160,65,162,160,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,160,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,163,164,165,166,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,
65,65,160,160,160,65,168,167,
170,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,171,
169,71,173,175,175,175,175,175,
175,175,175,174,174,174,174,174,
174,174,174,174,174,174,176,176,
174,174,174,176,174,174,174,174,
176,174,174,176,174,174,176,174,
174,174,176,174,174,174,176,176,
176,174,174,174,176,176,176,176,
176,176,174,176,174,174,174,174,
174,176,174,176,174,176,176,176,
176,176,176,176,174,178,178,178,
178,178,178,178,178,177,179,179,
179,179,179,179,179,179,177,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,
76,76,76,76,76,77,77,77,
77,77,77,77,77,77,77,77,
77,77,77,77,77,180,180,180,
180,180,61,61,61,61,61,61,
61,61,61,61,61,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,
75,181,75,75,75,181,181,181,
181,75,75,181,75,182,183,183,
183,183,183,183,183,184,184,75,
75,75,75,75,181,75,61,61,
185,186,75,75,61,186,75,75,
61,75,187,75,75,188,75,186,
186,75,75,75,186,186,75,61,
181,181,181,181,75,75,189,189,
78,186,189,189,75,186,75,75,
75,75,75,189,75,188,75,189,
186,189,190,189,186,191,75,61,
181,181,181,75,193,193,193,193,
193,193,193,193,192,195,195,195,
195,195,195,195,195,194,197,197,
197,197,197,197,197,197,197,197,
196,199,79,201,200,79,203,84,
84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,
84,84,84,84,84,84,204,84,
206,205,84,87,84,208,208,208,
208,208,208,208,208,208,208,207,
207,207,207,207,207,207,208,208,
208,208,208,208,207,207,207,207,
207,207,207,207,207,207,207,207,
207,207,207,207,207,207,207,207,
207,207,207,207,207,207,208,208,
208,208,208,208,207,210,209,209,
209,209,209,211,209,209,212,212,
212,212,212,212,212,212,212,212,
209,209,213,209,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,
103,103,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,
104,104,105,105,105,105,105,214,
214,214,214,214,214,214,214,214,
214,214,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,
102,106,102,102,102,102,102,214,
102,102,214,214,214,214,214,214,
214,214,214,214,102,108,108,108,
108,108,108,108,108,108,108,214,
107,214,214,214,214,214,214,108,
108,108,108,108,108,108,108,108,
108,214,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,
111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,
112,112,112,112,112,214,214,214,
214,214,214,214,214,214,214,214,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,
109,214,109,109,109,109,109,109,
109,109,109,109,109,214,109,109,
214,214,214,214,214,214,214,214,
214,214,109,109,109,214,106,109,
0
]

class << self
	attr_accessor :_re_scanner_trans_targs
	private :_re_scanner_trans_targs, :_re_scanner_trans_targs=
end
self._re_scanner_trans_targs = [
97,98,1,2,97,4,97,6,
8,9,7,97,11,13,14,12,
97,97,16,25,17,19,20,18,
97,21,22,23,24,26,28,29,
27,30,31,32,33,35,44,36,
38,39,37,97,40,41,42,43,
45,47,48,46,49,50,51,52,
97,54,97,55,57,0,58,59,
113,114,60,61,114,114,114,64,
65,114,114,121,66,67,70,121,
125,121,127,73,121,128,121,130,
76,79,77,78,121,80,81,82,
83,84,85,121,132,133,88,87,
89,90,91,133,92,94,93,95,
96,3,99,100,101,102,103,97,
104,97,107,108,97,109,97,110,
97,97,111,97,97,97,97,97,
97,105,97,106,5,97,10,97,
97,97,97,97,97,97,97,97,
97,15,34,97,53,112,56,62,
114,115,116,117,114,114,114,114,
114,114,63,114,114,114,118,119,
118,118,120,118,68,121,122,122,
124,69,121,72,121,121,75,86,
121,123,121,121,121,121,121,126,
121,71,121,129,131,121,74,121,
121,133,134,135,136,137,133
]

class << self
	attr_accessor :_re_scanner_trans_actions
	private :_re_scanner_trans_actions, :_re_scanner_trans_actions=
end
self._re_scanner_trans_actions = [
1,2,0,0,3,0,4,0,
0,0,0,5,0,0,0,0,
6,7,0,0,0,0,0,0,
8,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,9,0,0,0,0,
0,0,0,0,0,0,0,0,
10,0,11,0,0,0,0,0,
13,14,0,0,15,16,17,0,
0,18,19,20,0,0,0,22,
0,23,0,0,24,0,25,0,
0,0,0,0,26,0,0,0,
0,0,0,27,0,28,0,0,
0,0,0,29,0,0,0,0,
0,0,0,0,0,0,0,32,
33,34,0,0,35,0,36,37,
38,39,37,40,41,42,43,44,
45,37,46,0,0,47,0,48,
49,50,51,52,53,54,55,56,
57,0,0,58,0,60,0,0,
61,0,37,62,63,64,65,66,
67,68,0,69,70,71,72,0,
73,74,0,75,0,76,77,78,
0,0,79,0,80,81,0,0,
82,0,83,84,85,86,87,37,
88,0,89,37,0,90,0,91,
92,93,37,37,37,37,94
]

class << self
	attr_accessor :_re_scanner_to_state_actions
	private :_re_scanner_to_state_actions, :_re_scanner_to_state_actions=
end
self._re_scanner_to_state_actions = [
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,30,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
59,59,59,0,0,0,59,0,
0,59,0,0,0,0,0,0,
0,0,0,0,0,59,0,0,
0,0
]

class << self
	attr_accessor :_re_scanner_from_state_actions
	private :_re_scanner_from_state_actions, :_re_scanner_from_state_actions=
end
self._re_scanner_from_state_actions = [
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,31,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
31,31,31,0,0,0,31,0,
0,31,0,0,0,0,0,0,
0,0,0,0,0,31,0,0,
0,0
]

class << self
	attr_accessor :_re_scanner_eof_actions
	private :_re_scanner_eof_actions, :_re_scanner_eof_actions=
end
self._re_scanner_eof_actions = [
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
12,12,12,12,0,0,0,0,
0,0,0,0,0,21,21,0,
21,21,0,21,21,21,21,21,
21,21,21,21,21,21,21,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,21,0,0,0,0,0,
0,21,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0
]

class << self
	attr_accessor :_re_scanner_eof_trans
	private :_re_scanner_eof_trans, :_re_scanner_eof_trans=
end
self._re_scanner_eof_trans = [
0,1,1,1,5,5,5,5,
5,5,5,5,5,5,5,18,
18,18,18,18,18,18,18,18,
18,18,18,18,18,18,18,18,
18,18,18,18,18,18,18,18,
18,18,18,18,18,18,18,18,
18,18,18,18,18,57,57,57,
0,0,0,0,0,0,0,69,
71,71,0,0,0,0,0,82,
0,0,87,0,0,0,0,0,
0,0,0,0,0,0,0,102,
102,102,102,102,102,102,102,102,
102,0,133,133,134,134,133,135,
137,139,139,145,147,149,151,156,
0,0,0,168,170,173,0,178,
178,0,193,195,197,199,199,199,
203,203,203,203,208,0,215,215,
215,215
]

class << self
	attr_accessor :re_scanner_start
end
self.re_scanner_start = 97;
class << self
	attr_accessor :re_scanner_first_final
end
self.re_scanner_first_final = 97;
class << self
	attr_accessor :re_scanner_error
end
self.re_scanner_error = 0;

class << self
	attr_accessor :re_scanner_en_char_type
end
self.re_scanner_en_char_type = 112;
class << self
	attr_accessor :re_scanner_en_unicode_property
end
self.re_scanner_en_unicode_property = 113;
class << self
	attr_accessor :re_scanner_en_character_set
end
self.re_scanner_en_character_set = 114;
class << self
	attr_accessor :re_scanner_en_set_escape_sequence
end
self.re_scanner_en_set_escape_sequence = 118;
class << self
	attr_accessor :re_scanner_en_escape_sequence
end
self.re_scanner_en_escape_sequence = 121;
class << self
	attr_accessor :re_scanner_en_conditional_expression
end
self.re_scanner_en_conditional_expression = 133;
class << self
	attr_accessor :re_scanner_en_main
end
self.re_scanner_en_main = 97;

begin
	p ||= 0
	pe ||= data.length
	cs = re_scanner_start
	top = 0
	ts = nil
	te = nil
	act = 0
end

begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _re_scanner_from_state_actions[cs]
	when 31 then
		begin
ts = p
		end
	end
	_keys = cs << 1
	_inds = _re_scanner_index_offsets[cs]
	_slen = _re_scanner_key_spans[cs]
	_wide = data[p].ord
	_trans = if (   _slen > 0 &&
			_re_scanner_trans_keys[_keys] <= _wide &&
			_wide <= _re_scanner_trans_keys[_keys + 1]
		    ) then
			_re_scanner_indicies[ _inds + _wide - _re_scanner_trans_keys[_keys] ]
		 else
			_re_scanner_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	cs = _re_scanner_trans_targs[_trans]
	if _re_scanner_trans_actions[_trans] != 0
	case _re_scanner_trans_actions[_trans]
	when 33 then
		begin
 self.group_depth = group_depth + 1 		end
	when 37 then
		begin
te = p+1
		end
	when 60 then
		begin
te = p+1
 begin
      case text = copy(data, ts-1,te)
      when '\d'; emit(:type, :digit,      text)
      when '\D'; emit(:type, :nondigit,   text)
      when '\h'; emit(:type, :hex,        text)
      when '\H'; emit(:type, :nonhex,     text)
      when '\s'; emit(:type, :space,      text)
      when '\S'; emit(:type, :nonspace,   text)
      when '\w'; emit(:type, :word,       text)
      when '\W'; emit(:type, :nonword,    text)
      when '\R'; emit(:type, :linebreak,  text)
      when '\X'; emit(:type, :xgrapheme,  text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 13 then
		begin
te = p+1
 begin
      text = copy(data, ts-1,te)
      type = (text[1] == 'P') ^ (text[3] == '^') ? :nonproperty : :property

      name = text[3..-2].gsub(/[\^\s_\-]/, '').downcase

      token = self.class.short_prop_map[name] || self.class.long_prop_map[name]
      raise ValidationError.for(:property, name) unless token

      self.emit(type, token.to_sym, text)

      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 16 then
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, '-')
      emit(:set, :intersection, '&&')
     end
		end
	when 65 then
		begin
te = p+1
 begin
      if prev_token[1] == :open
        emit(:set, :negate, '^')
      else
        emit(:literal, :literal, '^')
      end
     end
		end
	when 67 then
		begin
te = p+1
 begin
      emit(:set, :intersection, '&&')
     end
		end
	when 63 then
		begin
te = p+1
 begin
      	begin
		stack[top] = cs
		top+= 1
		cs = 118
		_goto_level = _again
		next
	end

     end
		end
	when 61 then
		begin
te = p+1
 begin
      emit(:literal, :literal, copy(data, ts, te))
     end
		end
	when 14 then
		begin
te = p+1
 begin
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 68 then
		begin
te = p
p = p - 1; begin
      # ranges cant start with the opening bracket, a subset, or
      # intersection/negation/range operators
      if prev_token[0] == :set
        emit(:literal, :literal, '-')
      else
        emit(:set, :range, '-')
      end
     end
		end
	when 71 then
		begin
te = p
p = p - 1; begin
      emit(:set, :open, '[')
      	begin
		stack[top] = cs
		top+= 1
		cs = 114
		_goto_level = _again
		next
	end

     end
		end
	when 66 then
		begin
te = p
p = p - 1; begin
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 15 then
		begin
 begin p = ((te))-1; end
 begin
      # ranges cant start with the opening bracket, a subset, or
      # intersection/negation/range operators
      if prev_token[0] == :set
        emit(:literal, :literal, '-')
      else
        emit(:set, :range, '-')
      end
     end
		end
	when 18 then
		begin
 begin p = ((te))-1; end
 begin
      emit(:set, :open, '[')
      	begin
		stack[top] = cs
		top+= 1
		cs = 114
		_goto_level = _again
		next
	end

     end
		end
	when 75 then
		begin
te = p+1
 begin
      emit(:escape, :octal, copy(data, ts-1,te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 73 then
		begin
te = p+1
 begin
      p = p - 1;
      cs = 114;
      	begin
		stack[top] = cs
		top+= 1
		cs = 121
		_goto_level = _again
		next
	end

     end
		end
	when 72 then
		begin
te = p+1
 begin
      emit(:escape, :literal, copy(data, ts-1,te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 74 then
		begin
te = p
p = p - 1; begin
      emit(:escape, :octal, copy(data, ts-1,te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 84 then
		begin
te = p+1
 begin
      emit(:escape, :octal, copy(data, ts-1,te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 86 then
		begin
te = p+1
 begin  # special case, emits two tokens
      text = copy(data, ts-1,te)
      emit(:escape, :literal, text[0,2])
      emit(:literal, :literal, text[2])
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 76 then
		begin
te = p+1
 begin
      case text = copy(data, ts-1,te)
      when '\.';  emit(:escape, :dot,               text)
      when '\|';  emit(:escape, :alternation,       text)
      when '\^';  emit(:escape, :bol,               text)
      when '\$';  emit(:escape, :eol,               text)
      when '\?';  emit(:escape, :zero_or_one,       text)
      when '\*';  emit(:escape, :zero_or_more,      text)
      when '\+';  emit(:escape, :one_or_more,       text)
      when '\(';  emit(:escape, :group_open,        text)
      when '\)';  emit(:escape, :group_close,       text)
      when '\{';  emit(:escape, :interval_open,     text)
      when '\}';  emit(:escape, :interval_close,    text)
      when '\[';  emit(:escape, :set_open,          text)
      when '\]';  emit(:escape, :set_close,         text)
      when "\\\\";
        emit(:escape, :backslash, text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 81 then
		begin
te = p+1
 begin
      # \b is emitted as backspace only when inside a character set, otherwise
      # it is a word boundary anchor. A syntax might "normalize" it if needed.
      case text = copy(data, ts-1,te)
      when '\a'; emit(:escape, :bell,           text)
      when '\b'; emit(:escape, :backspace,      text)
      when '\e'; emit(:escape, :escape,         text)
      when '\f'; emit(:escape, :form_feed,      text)
      when '\n'; emit(:escape, :newline,        text)
      when '\r'; emit(:escape, :carriage,       text)
      when '\t'; emit(:escape, :tab,            text)
      when '\v'; emit(:escape, :vertical_tab,   text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 26 then
		begin
te = p+1
 begin
      text = copy(data, ts-1,te)
      if text[2] == '{'
        emit(:escape, :codepoint_list, text)
      else
        emit(:escape, :codepoint,      text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 92 then
		begin
te = p+1
 begin
      emit(:escape, :hex, copy(data, ts-1,te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 22 then
		begin
te = p+1
 begin
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 24 then
		begin
te = p+1
 begin
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 79 then
		begin
te = p+1
 begin
      p = p - 1;
      cs = ((in_set? ? 114 : 97));
      	begin
		stack[top] = cs
		top+= 1
		cs = 112
		_goto_level = _again
		next
	end

     end
		end
	when 80 then
		begin
te = p+1
 begin
      p = p - 1;
      cs = ((in_set? ? 114 : 97));
      	begin
		stack[top] = cs
		top+= 1
		cs = 113
		_goto_level = _again
		next
	end

     end
		end
	when 20 then
		begin
te = p+1
 begin
      emit(:escape, :literal, copy(data, ts-1,te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 85 then
		begin
te = p
p = p - 1; begin
      text = copy(data, ts-1,te)
      emit(:backref, :number, text)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 83 then
		begin
te = p
p = p - 1; begin
      emit(:escape, :octal, copy(data, ts-1,te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 91 then
		begin
te = p
p = p - 1; begin
      emit(:escape, :hex, copy(data, ts-1,te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 88 then
		begin
te = p
p = p - 1; begin
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 90 then
		begin
te = p
p = p - 1; begin
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 82 then
		begin
	case act
	when 17 then
	begin begin p = ((te))-1; end

      text = copy(data, ts-1,te)
      emit(:backref, :number, text)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
	when 18 then
	begin begin p = ((te))-1; end

      emit(:escape, :octal, copy(data, ts-1,te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
end
			end
	when 29 then
		begin
te = p+1
 begin
      text = copy(data, ts, te-1)
      text =~ /[^0]/ or raise ValidationError.for(:backref, 'condition', 'invalid ref ID')
      emit(:conditional, :condition, text)
      emit(:conditional, :condition_close, ')')
     end
		end
	when 93 then
		begin
te = p+1
 begin
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 97
		_goto_level = _again
		next
	end

     end
		end
	when 94 then
		begin
te = p
p = p - 1; begin
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 97
		_goto_level = _again
		next
	end

     end
		end
	when 28 then
		begin
 begin p = ((te))-1; end
 begin
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 97
		_goto_level = _again
		next
	end

     end
		end
	when 35 then
		begin
te = p+1
 begin
      emit(:meta, :dot, copy(data, ts, te))
     end
		end
	when 40 then
		begin
te = p+1
 begin
      if conditional_stack.last == group_depth
        emit(:conditional, :separator, copy(data, ts, te))
      else
        emit(:meta, :alternation, copy(data, ts, te))
      end
     end
		end
	when 39 then
		begin
te = p+1
 begin
      emit(:anchor, :bol, copy(data, ts, te))
     end
		end
	when 32 then
		begin
te = p+1
 begin
      emit(:anchor, :eol, copy(data, ts, te))
     end
		end
	when 57 then
		begin
te = p+1
 begin
      emit(:keep, :mark, copy(data, ts, te))
     end
		end
	when 56 then
		begin
te = p+1
 begin
      case text = copy(data, ts, te)
      when '\A';  emit(:anchor, :bos,                text)
      when '\z';  emit(:anchor, :eos,                text)
      when '\Z';  emit(:anchor, :eos_ob_eol,         text)
      when '\b';  emit(:anchor, :word_boundary,      text)
      when '\B';  emit(:anchor, :nonword_boundary,   text)
      when '\G';  emit(:anchor, :match_start,        text)
      end
     end
		end
	when 38 then
		begin
te = p+1
 begin
      append_literal(data, ts, te)
     end
		end
	when 47 then
		begin
te = p+1
 begin
      text = copy(data, ts, te)

      conditional_stack << group_depth

      emit(:conditional, :open, text[0..-2])
      emit(:conditional, :condition_open, '(')
      	begin
		stack[top] = cs
		top+= 1
		cs = 133
		_goto_level = _again
		next
	end

     end
		end
	when 48 then
		begin
te = p+1
 begin
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        raise ValidationError.for(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 6 then
		begin
te = p+1
 begin
      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
     end
		end
	when 5 then
		begin
te = p+1
 begin
      case text = copy(data, ts, te)
      when '(?:';  emit(:group, :passive,      text)
      when '(?>';  emit(:group, :atomic,       text)
      when '(?~';  emit(:group, :absence,      text)

      when /^\(\?(?:<>|'')/
        raise ValidationError.for(:group, 'named group', 'name is empty')

      when /^\(\?<[^>]+>/
        emit(:group, :named_ab,  text)

      when /^\(\?'[^']+'/
        emit(:group, :named_sq,  text)

      end
     end
		end
	when 9 then
		begin
te = p+1
 begin
      case text = copy(data, ts, te)
      when /^\\k(.)[^0-9\-][^+\-]*['>]$/
        emit(:backref, $1 == '<' ? :name_ref_ab : :name_ref_sq, text)
      when /^\\k(.)0*[1-9]\d*['>]$/
        emit(:backref, $1 == '<' ? :number_ref_ab : :number_ref_sq, text)
      when /^\\k(.)-0*[1-9]\d*['>]$/
        emit(:backref, $1 == '<' ? :number_rel_ref_ab : :number_rel_ref_sq, text)
      when /^\\k(.)[^0-9\-].*[+\-]\d+['>]$/
        emit(:backref, $1 == '<' ? :name_recursion_ref_ab : :name_recursion_ref_sq, text)
      when /^\\k(.)-?0*[1-9]\d*[+\-]\d+['>]$/
        emit(:backref, $1 == '<' ? :number_recursion_ref_ab : :number_recursion_ref_sq, text)
      else
        raise ValidationError.for(:backref, 'backreference', 'invalid ref ID')
      end
     end
		end
	when 8 then
		begin
te = p+1
 begin
      case text = copy(data, ts, te)
      when /^\\g(.)[^0-9+\-].*['>]$/
        emit(:backref, $1 == '<' ? :name_call_ab : :name_call_sq, text)
      when /^\\g(.)(?:0|0*[1-9]\d*)['>]$/
        emit(:backref, $1 == '<' ? :number_call_ab : :number_call_sq, text)
      when /^\\g(.)[+-]0*[1-9]\d*/
        emit(:backref, $1 == '<' ? :number_rel_call_ab : :number_rel_call_sq, text)
      else
        raise ValidationError.for(:backref, 'subexpression call', 'invalid ref ID')
      end
     end
		end
	when 54 then
		begin
te = p+1
 begin
      case text = copy(data, ts, te)
      when '?' ;  emit(:quantifier, :zero_or_one,            text)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text)
      end
     end
		end
	when 50 then
		begin
te = p+1
 begin
      case text = copy(data, ts, te)
      when '*' ;  emit(:quantifier, :zero_or_more,            text)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text)
      end
     end
		end
	when 52 then
		begin
te = p+1
 begin
      case text = copy(data, ts, te)
      when '+' ;  emit(:quantifier, :one_or_more,            text)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text)
      when '++';  emit(:quantifier, :one_or_more_possessive, text)
      end
     end
		end
	when 11 then
		begin
te = p+1
 begin
      emit(:quantifier, :interval, copy(data, ts, te))
     end
		end
	when 44 then
		begin
te = p+1
 begin
      if free_spacing
        emit(:free_space, :comment, copy(data, ts, te))
      else
        # consume only the pound sign (#) and backtrack to do regular scanning
        append_literal(data, ts, ts + 1)
         begin p = (( ts + 1))-1; end

      end
     end
		end
	when 46 then
		begin
te = p
p = p - 1; begin
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        raise ValidationError.for(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 45 then
		begin
te = p
p = p - 1; begin
      text = copy(data, ts, te)
      emit(:group, :capture, text)
     end
		end
	when 53 then
		begin
te = p
p = p - 1; begin
      case text = copy(data, ts, te)
      when '?' ;  emit(:quantifier, :zero_or_one,            text)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text)
      end
     end
		end
	when 49 then
		begin
te = p
p = p - 1; begin
      case text = copy(data, ts, te)
      when '*' ;  emit(:quantifier, :zero_or_more,            text)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text)
      end
     end
		end
	when 51 then
		begin
te = p
p = p - 1; begin
      case text = copy(data, ts, te)
      when '+' ;  emit(:quantifier, :one_or_more,            text)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text)
      when '++';  emit(:quantifier, :one_or_more_possessive, text)
      end
     end
		end
	when 58 then
		begin
te = p
p = p - 1; begin
      append_literal(data, ts, te)
     end
		end
	when 55 then
		begin
te = p
p = p - 1; begin
      	begin
		stack[top] = cs
		top+= 1
		cs = 121
		_goto_level = _again
		next
	end

     end
		end
	when 43 then
		begin
te = p
p = p - 1; begin
      if free_spacing
        emit(:free_space, :comment, copy(data, ts, te))
      else
        # consume only the pound sign (#) and backtrack to do regular scanning
        append_literal(data, ts, ts + 1)
         begin p = (( ts + 1))-1; end

      end
     end
		end
	when 42 then
		begin
te = p
p = p - 1; begin
      if free_spacing
        emit(:free_space, :whitespace, copy(data, ts, te))
      else
        append_literal(data, ts, te)
      end
     end
		end
	when 41 then
		begin
te = p
p = p - 1; begin
      append_literal(data, ts, te)
     end
		end
	when 3 then
		begin
 begin p = ((te))-1; end
 begin
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        raise ValidationError.for(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 10 then
		begin
 begin p = ((te))-1; end
 begin
      append_literal(data, ts, te)
     end
		end
	when 7 then
		begin
 begin p = ((te))-1; end
 begin
      	begin
		stack[top] = cs
		top+= 1
		cs = 121
		_goto_level = _again
		next
	end

     end
		end
	when 1 then
		begin
	case act
	when 0 then
	begin	begin
		cs = 0
		_goto_level = _again
		next
	end
end
	when 57 then
	begin begin p = ((te))-1; end

      append_literal(data, ts, te)
    end
end
			end
	when 70 then
		begin

    text = copy(data, ts ? ts-1 : 0,-1)
    raise PrematureEndError.new(text)
  		end
		begin
te = p
p = p - 1; begin
      emit(:set, :open, '[')
      	begin
		stack[top] = cs
		top+= 1
		cs = 114
		_goto_level = _again
		next
	end

     end
		end
	when 17 then
		begin

    text = copy(data, ts ? ts-1 : 0,-1)
    raise PrematureEndError.new(text)
  		end
		begin
 begin p = ((te))-1; end
 begin
      emit(:set, :open, '[')
      	begin
		stack[top] = cs
		top+= 1
		cs = 114
		_goto_level = _again
		next
	end

     end
		end
	when 87 then
		begin

    text = copy(data, ts ? ts-1 : 0,-1)
    raise PrematureEndError.new(text)
  		end
		begin
te = p
p = p - 1; begin
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 89 then
		begin

    text = copy(data, ts ? ts-1 : 0,-1)
    raise PrematureEndError.new(text)
  		end
		begin
te = p
p = p - 1; begin
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 23 then
		begin

    text = copy(data, ts ? ts-1 : 0,-1)
    raise PrematureEndError.new(text)
  		end
		begin
 begin p = ((te))-1; end
 begin
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 25 then
		begin

    text = copy(data, ts ? ts-1 : 0,-1)
    raise PrematureEndError.new(text)
  		end
		begin
 begin p = ((te))-1; end
 begin
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 27 then
		begin

    text = copy(data, ts ? ts-1 : 0,-1)
    raise ValidationError.for(:sequence, 'sequence', text)
  		end
		begin
te = p+1
 begin
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 4 then
		begin
 self.group_depth = group_depth - 1 		end
		begin
te = p+1
 begin
      emit(:group, :comment, copy(data, ts, te))
     end
		end
	when 34 then
		begin
 self.group_depth = group_depth - 1 		end
		begin
te = p+1
 begin
      if conditional_stack.last == group_depth + 1
        conditional_stack.pop
        emit(:conditional, :close, ')')
      elsif group_depth >= 0
        if spacing_stack.length > 1 &&
           spacing_stack.last[:depth] == group_depth + 1
          spacing_stack.pop
          self.free_spacing = spacing_stack.last[:free_spacing]
        end

        emit(:group, :close, ')')
      else
        raise ValidationError.for(:group, 'group', 'unmatched close parenthesis')
      end
     end
		end
	when 36 then
		begin
 self.set_depth   = set_depth   + 1 		end
		begin
te = p+1
 begin
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 114
		_goto_level = _again
		next
	end

     end
		end
	when 64 then
		begin
 self.set_depth   = set_depth   - 1 		end
		begin
te = p+1
 begin
      emit(:set, :close, copy(data, ts, te))
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 97
		_goto_level = _again
		next
	end

      end
     end
		end
	when 69 then
		begin
 self.set_depth   = set_depth   - 1 		end
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, '-')
      emit(:set, :close, ']')
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 97
		_goto_level = _again
		next
	end

      end
     end
		end
	when 19 then
		begin
 self.set_depth   = set_depth   - 1 		end
		begin
te = p+1
 begin
      text = copy(data, ts, te)

      type = :posixclass
      class_name = text[2..-3]
      if class_name[0] == '^'
        class_name = class_name[1..-1]
        type = :nonposixclass
      end

      unless self.class.posix_classes.include?(class_name)
        raise ValidationError.for(:posix_class, text)
      end

      emit(type, class_name.to_sym, text)
     end
		end
	when 62 then
		begin
te = p+1
		end
		begin
 self.set_depth   = set_depth   + 1 		end
	when 78 then
		begin
te = p+1
		end
		begin
act = 17;		end
	when 77 then
		begin
te = p+1
		end
		begin
act = 18;		end
	when 2 then
		begin
te = p+1
		end
		begin
act = 57;		end
	end
	end
	end
	if _goto_level <= _again
	case _re_scanner_to_state_actions[cs]
	when 59 then
		begin
ts = nil;		end
	when 30 then
		begin
ts = nil;		end
		begin
act = 0
		end
	end

	if cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _re_scanner_eof_trans[cs] > 0
		_trans = _re_scanner_eof_trans[cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	  case _re_scanner_eof_actions[cs]
	when 12 then
		begin

    raise PrematureEndError.new('unicode property')
  		end
	when 21 then
		begin

    text = copy(data, ts ? ts-1 : 0,-1)
    raise PrematureEndError.new(text)
  		end
	  end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

    # to avoid "warning: assigned but unused variable - testEof"
    testEof = testEof

    if cs == re_scanner_error
      text = copy(data, ts ? ts-1 : 0,-1)
      raise ScannerError.new("Scan error at '#{text}'")
    end

    raise PrematureEndError.new("(missing group closing paranthesis) "+
          "[#{group_depth}]") if in_group?
    raise PrematureEndError.new("(missing set closing bracket) "+
          "[#{set_depth}]") if in_set?

    # when the entire expression is a literal run
    emit_literal if literal_run

    tokens
  end

  # lazy-load property maps when first needed
  def self.short_prop_map
    @short_prop_map ||= parse_prop_map('short')
  end

  def self.long_prop_map
    @long_prop_map ||= parse_prop_map('long')
  end

  def self.parse_prop_map(name)
    File.read("#{__dir__}/scanner/properties/#{name}.csv").scan(/(.+),(.+)/).to_h
  end

  def self.posix_classes
    %w[alnum alpha ascii blank cntrl digit graph
       lower print punct space upper word xdigit]
  end

  # Emits an array with the details of the scanned pattern
  def emit(type, token, text)
    #puts "EMIT: type: #{type}, token: #{token}, text: #{text}, ts: #{ts}, te: #{te}"

    emit_literal if literal_run

    # Ragel runs with byte-based indices (ts, te). These are of little value to
    # end-users, so we keep track of char-based indices and emit those instead.
    ts_char_pos = char_pos
    te_char_pos = char_pos + text.length

    tok = [type, token, text, ts_char_pos, te_char_pos]

    self.prev_token = tok

    self.char_pos = te_char_pos

    if block
      block.call type, token, text, ts_char_pos, te_char_pos
      # TODO: in v3.0.0,remove `collect_tokens:` kwarg and only collect if no block given
      tokens << tok if collect_tokens
    elsif collect_tokens
      tokens << tok
    end
  end

  attr_accessor :literal_run # only public for #||= to work on ruby <= 2.5

  private

  attr_accessor :block,
                :collect_tokens, :tokens, :prev_token,
                :free_spacing, :spacing_stack,
                :group_depth, :set_depth, :conditional_stack,
                :char_pos

  def free_spacing?(input_object, options)
    if options && !input_object.is_a?(String)
      raise ArgumentError, 'options cannot be supplied unless scanning a String'
    end

    options = input_object.options if input_object.is_a?(::Regexp)

    return false unless options

    options & Regexp::EXTENDED != 0
  end

  def in_group?
    group_depth > 0
  end

  def in_set?
    set_depth > 0
  end

  # Copy from ts to te from data as text
  def copy(data, ts, te)
    data[ts...te].pack('c*').force_encoding('utf-8')
  end

  # Appends one or more characters to the literal buffer, to be emitted later
  # by a call to emit_literal.
  def append_literal(data, ts, te)
    (self.literal_run ||= []) << copy(data, ts, te)
  end

  # Emits the literal run collected by calls to the append_literal method.
  def emit_literal
    text = literal_run.join
    self.literal_run = nil
    emit(:literal, :literal, text)
  end

  def emit_options(text)
    token = nil

    # Ruby allows things like '(?-xxxx)' or '(?xx-xx--xx-:abc)'.
    text =~ /\(\?([mixdau]*)(-(?:[mix]*))*(:)?/
    positive, negative, group_local = $1,$2,$3

    if positive.include?('x')
      self.free_spacing = true
    end

    # If the x appears in both, treat it like ruby does, the second cancels
    # the first.
    if negative && negative.include?('x')
      self.free_spacing = false
    end

    if group_local
      spacing_stack << {:free_spacing => free_spacing, :depth => group_depth}
      token = :options
    else
      # switch for parent group level
      spacing_stack.last[:free_spacing] = free_spacing
      token = :options_switch
    end

    emit(:group, token, text)
  end

  def emit_meta_control_sequence(data, ts, te, token)
    if data.last < 0x00 || data.last > 0x7F
      raise ValidationError.for(:sequence, 'escape', token.to_s)
    end
    emit(:escape, token, copy(data, ts-1,te))
  end
end # module Regexp::Scanner
