'''OpenGL extension ARB.derivative_control

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.derivative_control to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides control over the spacial granularity at which the
	underlying implementation computes derivatives.  
	
	For example, for the coarse-granularity derivative, a single x derivative
	could be computed for each 2x2 group of pixels, using that same derivative
	value for all 4 pixels.  For the fine-granularity derivative, two
	derivatives could be computed for each 2x2 group of pixels; one for the top
	row and one for the bottom row.  Implementations vary somewhat on how this
	is done.
	
	To select the coarse derivative, use:
	
	    dFdxCoarse(p)
	    dFdyCoarse(p)
	    fwidthCoarse(p)
	
	To select the fine derivative, use:
	
	    dFdxFine(p)
	    dFdyFine(p)
	    fwidthFine(p)
	
	To select which ever is "better" (based on performance, API hints, or other
	factors), use:
	
	    dFdx(p)
	    dFdy(p)
	    fwidth(p)
	
	This last set is the set of previously existing built-ins for derivatives,
	and continues to work in a backward compatible way.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/derivative_control.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.derivative_control import *
from OpenGL.raw.GL.ARB.derivative_control import _EXTENSION_NAME

def glInitDerivativeControlARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION