# coding: utf-8

"""
    NetHSM
    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.   # noqa: E501
    The version of the OpenAPI document: v1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from nethsm.client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

SoftwareVersion: typing_extensions.TypeAlias = schemas.StrSchema
SoftwareBuild: typing_extensions.TypeAlias = schemas.StrSchema
FirmwareVersion: typing_extensions.TypeAlias = schemas.StrSchema
HardwareVersion: typing_extensions.TypeAlias = schemas.StrSchema
DeviceId: typing_extensions.TypeAlias = schemas.StrSchema

from nethsm.client.components.schema import ak_pub
from nethsm.client.components.schema import pcr
Properties = typing.TypedDict(
    'Properties',
    {
        "softwareVersion": typing.Type[SoftwareVersion],
        "softwareBuild": typing.Type[SoftwareBuild],
        "firmwareVersion": typing.Type[FirmwareVersion],
        "hardwareVersion": typing.Type[HardwareVersion],
        "deviceId": typing.Type[DeviceId],
        "akPub": typing.Type[ak_pub.AkPub],
        "pcr": typing.Type[pcr.Pcr],
    }
)


class SystemInfoDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
        "akPub",
        "deviceId",
        "firmwareVersion",
        "hardwareVersion",
        "pcr",
        "softwareBuild",
        "softwareVersion",
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
    })
    
    def __new__(
        cls,
        *,
        akPub: typing.Union[
            ak_pub.AkPubDictInput,
            ak_pub.AkPubDict,
        ],
        deviceId: str,
        firmwareVersion: str,
        hardwareVersion: str,
        pcr: typing.Union[
            pcr.PcrDictInput,
            pcr.PcrDict,
        ],
        softwareBuild: str,
        softwareVersion: str,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {
            "akPub": akPub,
            "deviceId": deviceId,
            "firmwareVersion": firmwareVersion,
            "hardwareVersion": hardwareVersion,
            "pcr": pcr,
            "softwareBuild": softwareBuild,
            "softwareVersion": softwareVersion,
        }
        arg_.update(kwargs)
        used_arg_ = typing.cast(SystemInfoDictInput, arg_)
        return SystemInfo.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            SystemInfoDictInput,
            SystemInfoDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> SystemInfoDict:
        return SystemInfo.validate(arg, configuration=configuration)
    
    @property
    def akPub(self) -> ak_pub.AkPubDict:
        return typing.cast(
            ak_pub.AkPubDict,
            self.__getitem__("akPub")
        )
    
    @property
    def deviceId(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("deviceId")
        )
    
    @property
    def firmwareVersion(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("firmwareVersion")
        )
    
    @property
    def hardwareVersion(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("hardwareVersion")
        )
    
    @property
    def pcr(self) -> pcr.PcrDict:
        return typing.cast(
            pcr.PcrDict,
            self.__getitem__("pcr")
        )
    
    @property
    def softwareBuild(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("softwareBuild")
        )
    
    @property
    def softwareVersion(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("softwareVersion")
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
SystemInfoDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class SystemInfo(
    schemas.Schema[SystemInfoDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    required: typing.FrozenSet[str] = frozenset({
        "akPub",
        "deviceId",
        "firmwareVersion",
        "hardwareVersion",
        "pcr",
        "softwareBuild",
        "softwareVersion",
    })
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: SystemInfoDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            SystemInfoDictInput,
            SystemInfoDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> SystemInfoDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

