/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.rest;

import io.netty.handler.ssl.OpenSsl;
import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.filter.SecurityRequestFactory;
import org.opensearch.security.ssl.SslConfiguration;
import org.opensearch.security.ssl.SslSettingsManager;
import org.opensearch.security.ssl.config.CertType;
import org.opensearch.security.ssl.config.SslParameters;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.util.SSLRequestHelper;

public class SecuritySSLInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/_security/sslinfo"));
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final SslSettingsManager sslSettingsManager;
    final PrincipalExtractor principalExtractor;
    private final Path configPath;
    private final Settings settings;

    public SecuritySSLInfoAction(Settings settings, Path configPath, SslSettingsManager sslSettingsManager, PrincipalExtractor principalExtractor) {
        this.settings = settings;
        this.sslSettingsManager = sslSettingsManager;
        this.principalExtractor = principalExtractor;
        this.configPath = configPath;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final Boolean showDn;
            {
                this.showDn = request.paramAsBoolean("show_dn", Boolean.FALSE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(SecuritySSLInfoAction.this.settings, SecuritySSLInfoAction.this.configPath, SecurityRequestFactory.from(request), SecuritySSLInfoAction.this.principalExtractor);
                    X509Certificate[] certs = sslInfo == null ? null : sslInfo.getX509Certs();
                    X509Certificate[] localCerts = sslInfo == null ? null : sslInfo.getLocalCertificates();
                    builder.startObject();
                    builder.field("principal", sslInfo == null ? null : sslInfo.getPrincipal());
                    builder.field("peer_certificates", (String)(certs != null && certs.length > 0 ? "" + certs.length : "0"));
                    if (this.showDn == Boolean.TRUE) {
                        builder.field("peer_certificates_list", certs == null ? null : (Iterable)Arrays.stream(certs).map(c -> c.getSubjectX500Principal().getName()).collect(Collectors.toList()));
                        builder.field("local_certificates_list", localCerts == null ? null : (Iterable)Arrays.stream(localCerts).map(c -> c.getSubjectX500Principal().getName()).collect(Collectors.toList()));
                    }
                    builder.field("ssl_protocol", sslInfo == null ? null : sslInfo.getProtocol());
                    builder.field("ssl_cipher", sslInfo == null ? null : sslInfo.getCipher());
                    builder.field("ssl_openssl_available", OpenSsl.isAvailable());
                    builder.field("ssl_openssl_version", OpenSsl.version());
                    builder.field("ssl_openssl_version_string", OpenSsl.versionString());
                    Throwable openSslUnavailCause = OpenSsl.unavailabilityCause();
                    builder.field("ssl_openssl_non_available_cause", openSslUnavailCause == null ? "" : openSslUnavailCause.toString());
                    builder.field("ssl_openssl_supports_key_manager_factory", OpenSsl.supportsKeyManagerFactory());
                    builder.field("ssl_openssl_supports_hostname_validation", OpenSsl.supportsHostnameValidation());
                    builder.field("ssl_provider_http", SecuritySSLInfoAction.this.sslSettingsManager.sslConfiguration(CertType.HTTP).map(SslConfiguration::sslParameters).map(SslParameters::provider).orElse(null));
                    builder.field("ssl_provider_transport_server", SecuritySSLInfoAction.this.sslSettingsManager.sslConfiguration(CertType.TRANSPORT).map(SslConfiguration::sslParameters).map(SslParameters::provider).orElse(null));
                    builder.field("ssl_provider_transport_client", SecuritySSLInfoAction.this.sslSettingsManager.sslConfiguration(CertType.TRANSPORT_CLIENT).map(SslConfiguration::sslParameters).map(SslParameters::provider).orElse(null));
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "OpenSearch Security SSL Info";
    }
}

