/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.config.setting.handler;

import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.config.setting.ClusterSettingListener;
import org.opensearch.performanceanalyzer.config.setting.ClusterSettingsManager;
import org.opensearch.performanceanalyzer.config.setting.PerformanceAnalyzerClusterSettings;

public class NodeStatsSettingHandler
implements ClusterSettingListener<Integer> {
    private final PerformanceAnalyzerController controller;
    private final ClusterSettingsManager clusterSettingsManager;
    private Integer currentClusterSetting = 0;

    public NodeStatsSettingHandler(PerformanceAnalyzerController controller, ClusterSettingsManager clusterSettingsManager) {
        this.controller = controller;
        this.clusterSettingsManager = clusterSettingsManager;
    }

    public void updateNodeStatsSetting(int value) {
        this.clusterSettingsManager.updateSetting(PerformanceAnalyzerClusterSettings.PA_NODE_STATS_SETTING, value);
    }

    @Override
    public void onSettingUpdate(Integer newSettingValue) {
        if (newSettingValue != null) {
            this.currentClusterSetting = newSettingValue;
            this.controller.updateNodeStatsShardsPerCollection(newSettingValue);
        }
    }

    public int getNodeStatsSetting() {
        return this.currentClusterSetting;
    }
}

