/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.conversation.ConversationMeta;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.GetConversationRequest;
import org.opensearch.ml.memory.action.conversation.GetConversationResponse;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class GetConversationTransportAction
extends HandledTransportAction<GetConversationRequest, GetConversationResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetConversationTransportAction.class);
    private final Client client;
    private final ConversationalMemoryHandler cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public GetConversationTransportAction(TransportService transportService, ActionFilters actionFilters, OpenSearchConversationalMemoryHandler cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/memory/conversation/get", transportService, actionFilters, GetConversationRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    public void doExecute(Task task, GetConversationRequest request, ActionListener<GetConversationResponse> actionListener) {
        if (!this.featureIsEnabled) {
            actionListener.onFailure((Exception)new OpenSearchException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        String conversationId = request.getConversationId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener al = ActionListener.wrap(conversationMeta -> internalListener.onResponse((Object)new GetConversationResponse((ConversationMeta)conversationMeta)), arg_0 -> ((ActionListener)internalListener).onFailure(arg_0));
            this.cmHandler.getConversation(conversationId, (ActionListener<ConversationMeta>)al);
        }
        catch (Exception e) {
            log.error("Failed to get memory {}", (Object)conversationId, (Object)e);
            actionListener.onFailure(e);
        }
    }
}

