/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.DSAOutputVerifier;
import org.bouncycastle.crypto.fips.FipsOutputValidator;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;

class DSAOutputValidator<T extends Parameters>
extends FipsOutputValidator<T> {
    private final DSA dsa;
    private final Digest digest;
    private final BigInteger[] rs;
    private final T parameter;

    DSAOutputValidator(DSA dSA, Digest digest, T t, byte[] byArray) throws InvalidSignatureException {
        this.dsa = dSA;
        this.digest = digest;
        this.parameter = t;
        try {
            this.rs = DSAOutputVerifier.decode(byArray);
        }
        catch (Exception exception) {
            throw new InvalidSignatureException("Unable to process signature: " + exception.getMessage(), exception);
        }
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getValidatingStream() {
        return new DigestOutputStream(this.digest);
    }

    @Override
    public boolean isValidated() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return this.dsa.verifySignature(byArray, this.rs[0], this.rs[1]);
    }
}

