/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.ndarray.BytesSupplier;
import ai.djl.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public interface JsonSerializable
extends Serializable,
BytesSupplier {
    default public String toJson() {
        return JsonUtils.GSON_COMPACT.toJson(this.serialize());
    }

    @Override
    default public String getAsString() {
        return this.toJson();
    }

    @Override
    default public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toJson().getBytes(StandardCharsets.UTF_8));
    }

    public JsonElement serialize();

    public static final class Serializer
    implements JsonSerializer<JsonSerializable> {
        public JsonElement serialize(JsonSerializable src, Type type, JsonSerializationContext ctx) {
            return src.serialize();
        }
    }
}

