/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.tasks;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.search.MLSearchActionRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class SearchTaskTransportAction
extends HandledTransportAction<MLSearchActionRequest, SearchResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchTaskTransportAction.class);
    private Client client;
    private final SdkClient sdkClient;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public SearchTaskTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/tasks/search", transportService, actionFilters, MLSearchActionRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, MLSearchActionRequest mlSearchActionRequest, ActionListener<SearchResponse> actionListener) {
        String tenantId = mlSearchActionRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.wrap(arg_0 -> actionListener.onResponse(arg_0), e -> RestActionUtils.wrapListenerToHandleSearchIndexNotFound(e, actionListener));
            SearchDataObjectRequest searchDataObjectRequest = SearchDataObjectRequest.builder().indices(mlSearchActionRequest.indices()).searchSourceBuilder(mlSearchActionRequest.source()).tenantId(tenantId).build();
            this.sdkClient.searchDataObjectAsync(searchDataObjectRequest).whenComplete(SdkClientUtils.wrapSearchCompletion((ActionListener)wrappedListener, (Class[])new Class[0]));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

