/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN9120Codec;

import lombok.Generated;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.codec.KNN9120Codec.DerivedSourceStoredFieldsFormat;
import org.opensearch.knn.index.codec.KNNCodecVersion;
import org.opensearch.knn.index.codec.KNNFormatFacade;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReadersSupplier;

public class KNN9120Codec
extends FilterCodec {
    private static final KNNCodecVersion VERSION = KNNCodecVersion.V_9_12_0;
    private final KNNFormatFacade knnFormatFacade;
    private final PerFieldKnnVectorsFormat perFieldKnnVectorsFormat;
    private final StoredFieldsFormat storedFieldsFormat;
    private final MapperService mapperService;

    public KNN9120Codec() {
        this(VERSION.getDefaultCodecDelegate(), VERSION.getPerFieldKnnVectorsFormat(), null);
    }

    protected KNN9120Codec(Codec delegate, PerFieldKnnVectorsFormat knnVectorsFormat, MapperService mapperService) {
        super(VERSION.getCodecName(), delegate);
        this.knnFormatFacade = VERSION.getKnnFormatFacadeSupplier().apply(delegate);
        this.perFieldKnnVectorsFormat = knnVectorsFormat;
        this.mapperService = mapperService;
        this.storedFieldsFormat = this.getStoredFieldsFormat();
    }

    public DocValuesFormat docValuesFormat() {
        return this.knnFormatFacade.docValuesFormat();
    }

    public CompoundFormat compoundFormat() {
        return this.knnFormatFacade.compoundFormat();
    }

    public KnnVectorsFormat knnVectorsFormat() {
        return this.perFieldKnnVectorsFormat;
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    private StoredFieldsFormat getStoredFieldsFormat() {
        DerivedSourceReadersSupplier derivedSourceReadersSupplier = new DerivedSourceReadersSupplier(segmentReadState -> {
            if (segmentReadState.fieldInfos.hasVectorValues()) {
                return this.knnVectorsFormat().fieldsReader(segmentReadState);
            }
            return null;
        }, segmentReadState -> {
            if (segmentReadState.fieldInfos.hasDocValues()) {
                return this.docValuesFormat().fieldsProducer(segmentReadState);
            }
            return null;
        }, segmentReadState -> {
            if (segmentReadState.fieldInfos.hasPostings()) {
                return this.postingsFormat().fieldsProducer(segmentReadState);
            }
            return null;
        }, segmentReadState -> {
            if (segmentReadState.fieldInfos.hasNorms()) {
                return this.normsFormat().normsProducer(segmentReadState);
            }
            return null;
        });
        return new DerivedSourceStoredFieldsFormat(this.delegate.storedFieldsFormat(), derivedSourceReadersSupplier, this.mapperService);
    }

    @Generated
    public static KNN9120CodecBuilder builder() {
        return new KNN9120CodecBuilder();
    }

    @Generated
    public static class KNN9120CodecBuilder {
        @Generated
        private Codec delegate;
        @Generated
        private PerFieldKnnVectorsFormat knnVectorsFormat;
        @Generated
        private MapperService mapperService;

        @Generated
        KNN9120CodecBuilder() {
        }

        @Generated
        public KNN9120CodecBuilder delegate(Codec delegate) {
            this.delegate = delegate;
            return this;
        }

        @Generated
        public KNN9120CodecBuilder knnVectorsFormat(PerFieldKnnVectorsFormat knnVectorsFormat) {
            this.knnVectorsFormat = knnVectorsFormat;
            return this;
        }

        @Generated
        public KNN9120CodecBuilder mapperService(MapperService mapperService) {
            this.mapperService = mapperService;
            return this;
        }

        @Generated
        public KNN9120Codec build() {
            return new KNN9120Codec(this.delegate, this.knnVectorsFormat, this.mapperService);
        }

        @Generated
        public String toString() {
            return "KNN9120Codec.KNN9120CodecBuilder(delegate=" + String.valueOf(this.delegate) + ", knnVectorsFormat=" + String.valueOf(this.knnVectorsFormat) + ", mapperService=" + String.valueOf(this.mapperService) + ")";
        }
    }
}

