/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.CompactID;
import org.apache.tika.parser.microsoft.onenote.FileChunkReference;
import org.apache.tika.parser.microsoft.onenote.FileNodePtr;
import org.apache.tika.parser.microsoft.onenote.IndentUtil;
import org.apache.tika.parser.microsoft.onenote.OneNoteDocument;
import org.apache.tika.parser.microsoft.onenote.OneNotePropertyId;
import org.apache.tika.parser.microsoft.onenote.OneNotePtr;
import org.apache.tika.parser.microsoft.onenote.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyValue {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyValue.class);
    OneNotePropertyId propertyId = new OneNotePropertyId();
    long scalar;
    List<CompactID> compactIDs = new ArrayList<CompactID>();
    PropertySet propertySet = new PropertySet();
    FileChunkReference rawData = new FileChunkReference();

    PropertyValue() {
    }

    public void print(OneNoteDocument document, OneNotePtr pointer, int indentLevel) throws IOException, TikaException {
        boolean isRawText = true;
        long type = this.propertyId.type;
        if (isRawText) {
            LOG.debug("{}<{}", (Object)IndentUtil.getIndent(indentLevel + 1), (Object)this.propertyId);
        }
        if (type > 0L && type <= 6L) {
            if (isRawText) {
                LOG.debug("(%d)", (Object)this.scalar);
            }
        } else if (type == 7L) {
            OneNotePtr content = new OneNotePtr(pointer);
            content.reposition(this.rawData);
            if (isRawText) {
                LOG.debug(" [");
                content.dumpHex();
                LOG.debug("]");
            }
        } else if (type == 9L || type == 8L || type == 11L || type == 12L || type == 10L || type == 13L) {
            String xtype = "contextID";
            if (type == 8L || type == 9L) {
                xtype = "OIDs";
            }
            if (type == 10L || type == 11L) {
                xtype = "OSIDS";
            }
            if (isRawText) {
                if (!this.compactIDs.isEmpty()) {
                    LOG.debug("");
                }
                for (CompactID compactID : this.compactIDs) {
                    LOG.debug("{}{}[{}]", new Object[]{IndentUtil.getIndent(indentLevel + 1), xtype, compactID});
                    FileNodePtr where = document.guidToObject.get(compactID.guid);
                    if (where == null) continue;
                    where.dereference(document).print(document, pointer, indentLevel + 1);
                }
            }
        } else if (type == 16L || type == 17L) {
            if (isRawText) {
                LOG.debug("SubProperty");
            }
            this.propertySet.print(document, pointer, indentLevel + 1);
        }
        if (isRawText) {
            LOG.debug(">");
        }
    }

    public OneNotePropertyId getPropertyId() {
        return this.propertyId;
    }

    public PropertyValue setPropertyId(OneNotePropertyId propertyId) {
        this.propertyId = propertyId;
        return this;
    }

    public long getScalar() {
        return this.scalar;
    }

    public PropertyValue setScalar(long scalar) {
        this.scalar = scalar;
        return this;
    }

    public List<CompactID> getCompactIDs() {
        return this.compactIDs;
    }

    public PropertyValue setCompactIDs(List<CompactID> compactIDs) {
        this.compactIDs = compactIDs;
        return this;
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public PropertyValue setPropertySet(PropertySet propertySet) {
        this.propertySet = propertySet;
        return this;
    }

    public FileChunkReference getRawData() {
        return this.rawData;
    }

    public PropertyValue setRawData(FileChunkReference rawData) {
        this.rawData = rawData;
        return this;
    }

    public String toString() {
        return "PropertyValue{propertyId=" + this.propertyId + ", scalar=" + this.scalar + ", compactIDs=" + this.compactIDs + ", propertySet=" + this.propertySet + ", rawData=" + this.rawData + '}';
    }
}

