"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    monitorService
  } = services;
  const fieldValidations = {
    from: _configSchema.schema.number(),
    size: _configSchema.schema.number(),
    search: _configSchema.schema.string(),
    sortField: _configSchema.schema.string(),
    sortDirection: _configSchema.schema.string(),
    state: _configSchema.schema.string(),
    monitorIds: _configSchema.schema.maybe(_configSchema.schema.any())
  };
  router.get({
    path: '/api/alerting/monitors',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, monitorService.getMonitors);
  router.post({
    path: '/api/alerting/monitors/_search',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.searchMonitors);
  router.post({
    path: '/api/alerting/monitors',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.createMonitor);
  router.post({
    path: '/api/alerting/workflows',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.createWorkflow);
  router.post({
    path: '/api/alerting/monitors/_execute',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, {
        dryrun: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, monitorService.executeMonitor);
  router.get({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.getWorkflow);
  router.get({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.getMonitor);
  const fieldValidationForMonitors = {
    ifSeqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
    ifPrimaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
  };
  router.put({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidationForMonitors)
    }
  }, monitorService.updateMonitor);
  router.put({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidationForMonitors),
      body: _configSchema.schema.any()
    }
  }, monitorService.updateMonitor);
  router.delete({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, {
        version: _configSchema.schema.number()
      })
    }
  }, monitorService.deleteMonitor);
  router.delete({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, {
        version: _configSchema.schema.number()
      })
    }
  }, monitorService.deleteWorkflow);
  router.post({
    path: '/api/alerting/monitors/{id}/_acknowledge/alerts',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.acknowledgeAlerts);
  router.post({
    path: '/api/alerting/workflows/{id}/_acknowledge/alerts',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, monitorService.acknowledgeChainedAlerts);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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