/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADResultProcessor;
import org.opensearch.ad.transport.AnomalyResultAction;
import org.opensearch.ad.transport.AnomalyResultRequest;
import org.opensearch.ad.transport.AnomalyResultResponse;
import org.opensearch.ad.transport.EntityADResultAction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.cluster.HashRing;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.feature.FeatureManager;
import org.opensearch.timeseries.stats.StatNames;
import org.opensearch.timeseries.transport.ResultProcessor;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class AnomalyResultTransportAction
extends HandledTransportAction<ActionRequest, AnomalyResultResponse> {
    private static final Logger LOG = LogManager.getLogger(AnomalyResultTransportAction.class);
    private ADResultProcessor resultProcessor;
    private final Client client;
    private CircuitBreakerService adCircuitBreakerService;
    private final Set<String> hcDetectors;
    private final ADStats adStats;
    private final NodeStateManager nodeStateManager;

    @Inject
    public AnomalyResultTransportAction(ActionFilters actionFilters, TransportService transportService, Settings settings, Client client, SecurityClientUtil clientUtil, NodeStateManager nodeStateManager, FeatureManager featureManager, HashRing hashRing, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, CircuitBreakerService adCircuitBreakerService, ADStats adStats, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, ADTaskManager realTimeTaskManager) {
        super(AnomalyResultAction.NAME, transportService, actionFilters, AnomalyResultRequest::new);
        this.resultProcessor = new ADResultProcessor(AnomalyDetectorSettings.AD_REQUEST_TIMEOUT, EntityADResultAction.NAME, StatNames.AD_HC_EXECUTE_REQUEST_COUNT, settings, clusterService, threadPool, hashRing, nodeStateManager, transportService, adStats, realTimeTaskManager, xContentRegistry, client, clientUtil, indexNameExpressionResolver, AnomalyResultResponse.class, featureManager);
        this.client = client;
        this.adCircuitBreakerService = adCircuitBreakerService;
        this.hcDetectors = new HashSet<String>();
        this.adStats = adStats;
        this.nodeStateManager = nodeStateManager;
    }

    protected void doExecute(Task task, ActionRequest actionRequest, ActionListener<AnomalyResultResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            AnomalyResultRequest request = AnomalyResultRequest.fromActionRequest(actionRequest);
            String adID = request.getConfigId();
            ActionListener original = listener;
            listener = ActionListener.wrap(r -> {
                this.hcDetectors.remove(adID);
                original.onResponse((Object)r);
            }, e -> {
                if (!(e instanceof TimeSeriesException) || ((TimeSeriesException)e).isCountedInStats()) {
                    this.adStats.getStat(StatNames.AD_EXECUTE_FAIL_COUNT.getName()).increment();
                    if (this.hcDetectors.contains(adID)) {
                        this.adStats.getStat(StatNames.AD_HC_EXECUTE_FAIL_COUNT.getName()).increment();
                    }
                }
                this.hcDetectors.remove(adID);
                original.onFailure(e);
            });
            if (!ADEnabledSetting.isADEnabled()) {
                throw new EndRunException(adID, "AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true", true).countedInStats(false);
            }
            this.adStats.getStat(StatNames.AD_EXECUTE_REQUEST_COUNT.getName()).increment();
            if (this.adCircuitBreakerService.isOpen().booleanValue()) {
                listener.onFailure((Exception)new LimitExceededException(adID, "The total OpenSearch memory usage exceeds our threshold, opening the memory circuit.", false));
                return;
            }
            try {
                this.nodeStateManager.getConfig(adID, AnalysisType.AD, true, this.resultProcessor.onGetConfig(listener, adID, request, Optional.of(this.hcDetectors)));
            }
            catch (Exception ex) {
                ResultProcessor.handleExecuteException(ex, (ActionListener<? extends ActionResponse>)listener, adID);
            }
        }
        catch (Exception e2) {
            LOG.error((Object)e2);
            listener.onFailure(e2);
        }
    }
}

