/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.utils.cache.stats;

import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.index.store.remote.utils.cache.stats.IRefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.RefCountedCacheStats;

@PublicApi(since="2.7.0")
public final class AggregateRefCountedCacheStats
implements IRefCountedCacheStats {
    private final RefCountedCacheStats overallCacheStats;
    private final RefCountedCacheStats fullFileCacheStats;
    private final RefCountedCacheStats blockFileCacheStats;
    private final RefCountedCacheStats pinnedFileCacheStats;

    public AggregateRefCountedCacheStats(RefCountedCacheStats overallCacheStats, RefCountedCacheStats fullFileCacheStats, RefCountedCacheStats blockFileCacheStats, RefCountedCacheStats pinnedFileCacheStats) {
        this.overallCacheStats = overallCacheStats;
        this.fullFileCacheStats = fullFileCacheStats;
        this.blockFileCacheStats = blockFileCacheStats;
        this.pinnedFileCacheStats = pinnedFileCacheStats;
    }

    public RefCountedCacheStats getOverallCacheStats() {
        return this.overallCacheStats;
    }

    public RefCountedCacheStats getBlockFileCacheStats() {
        return this.blockFileCacheStats;
    }

    public RefCountedCacheStats getPinnedFileCacheStats() {
        return this.pinnedFileCacheStats;
    }

    public RefCountedCacheStats getFullFileCacheStats() {
        return this.fullFileCacheStats;
    }

    @Override
    public long requestCount() {
        return this.overallCacheStats.requestCount();
    }

    @Override
    public long hitCount() {
        return this.overallCacheStats.hitCount();
    }

    @Override
    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount() / (double)requestCount;
    }

    @Override
    public long missCount() {
        return this.overallCacheStats.missCount();
    }

    @Override
    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount() / (double)requestCount;
    }

    @Override
    public long removeCount() {
        return this.overallCacheStats.removeCount();
    }

    @Override
    public long removeWeight() {
        return this.overallCacheStats.removeWeight();
    }

    @Override
    public long replaceCount() {
        return this.overallCacheStats.replaceCount();
    }

    @Override
    public long evictionCount() {
        return this.overallCacheStats.evictionCount();
    }

    @Override
    public long evictionWeight() {
        return this.overallCacheStats.evictionWeight();
    }

    @Override
    public long usage() {
        return this.overallCacheStats.usage();
    }

    @Override
    public long activeUsage() {
        return this.overallCacheStats.activeUsage();
    }

    @Override
    public long pinnedUsage() {
        return this.pinnedFileCacheStats.pinnedUsage();
    }

    @Override
    public IRefCountedCacheStats accumulate(IRefCountedCacheStats other) {
        if (!(other instanceof AggregateRefCountedCacheStats)) {
            throw new IllegalArgumentException("Invalid Argument passed for Accumulating AggregateRefCountedCacheStats");
        }
        AggregateRefCountedCacheStats otherStats = (AggregateRefCountedCacheStats)other;
        this.overallCacheStats.accumulate(otherStats.overallCacheStats);
        this.fullFileCacheStats.accumulate(otherStats.fullFileCacheStats);
        this.blockFileCacheStats.accumulate(otherStats.blockFileCacheStats);
        this.pinnedFileCacheStats.accumulate(otherStats.pinnedFileCacheStats);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.overallCacheStats, this.fullFileCacheStats, this.blockFileCacheStats);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateRefCountedCacheStats)) {
            return false;
        }
        AggregateRefCountedCacheStats other = (AggregateRefCountedCacheStats)o;
        return this.overallCacheStats.equals(other.overallCacheStats) && this.fullFileCacheStats.equals(other.fullFileCacheStats) && this.blockFileCacheStats.equals(other.blockFileCacheStats) && this.pinnedFileCacheStats.equals(other.pinnedFileCacheStats);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{overallRefCountedCacheStats=" + this.overallCacheStats.toString() + ", fullRefCountedCacheStats=" + this.fullFileCacheStats.toString() + ", blockRefCountedCacheStats=" + this.blockFileCacheStats.toString() + ", pinnedRefCountedCacheStats=" + this.pinnedFileCacheStats.toString() + "}";
    }
}

