/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import java.util.regex.Matcher;
import org.objectweb.asm.Type;
import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.Operation;
import org.opensearch.painless.WriterConstants;
import org.opensearch.painless.api.Augmentation;
import org.opensearch.painless.ir.BinaryNode;
import org.opensearch.painless.lookup.PainlessLookupUtility;
import org.opensearch.painless.lookup.def;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;

public class BinaryMathNode
extends BinaryNode {
    private Operation operation;
    private Class<?> binaryType;
    private Class<?> shiftType;
    private int flags;
    private int regexLimit;

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setBinaryType(Class<?> binaryType) {
        this.binaryType = binaryType;
    }

    public Class<?> getBinaryType() {
        return this.binaryType;
    }

    public String getBinaryCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.binaryType);
    }

    public void setShiftType(Class<?> shiftType) {
        this.shiftType = shiftType;
    }

    public Class<?> getShiftType() {
        return this.shiftType;
    }

    public String getShiftCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.shiftType);
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setRegexLimit(int regexLimit) {
        this.regexLimit = regexLimit;
    }

    public int getRegexLimit() {
        return this.regexLimit;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitBinaryMath(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getLeftNode().visit(irTreeVisitor, scope);
        this.getRightNode().visit(irTreeVisitor, scope);
    }

    public BinaryMathNode(Location location) {
        super(location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        if (this.operation == Operation.FIND || this.operation == Operation.MATCH) {
            this.getRightNode().write(classWriter, methodWriter, writeScope);
            methodWriter.push(this.regexLimit);
            this.getLeftNode().write(classWriter, methodWriter, writeScope);
            methodWriter.invokeStatic(Type.getType(Augmentation.class), WriterConstants.PATTERN_MATCHER);
            if (this.operation == Operation.FIND) {
                methodWriter.invokeVirtual(Type.getType(Matcher.class), WriterConstants.MATCHER_FIND);
                return;
            } else {
                if (this.operation != Operation.MATCH) throw new IllegalStateException("unexpected binary math operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                methodWriter.invokeVirtual(Type.getType(Matcher.class), WriterConstants.MATCHER_MATCHES);
            }
            return;
        } else {
            this.getLeftNode().write(classWriter, methodWriter, writeScope);
            this.getRightNode().write(classWriter, methodWriter, writeScope);
            if (this.binaryType == def.class || this.shiftType != null && this.shiftType == def.class) {
                methodWriter.writeDynamicBinaryInstruction(this.getLocation(), this.getExpressionType(), this.getLeftNode().getExpressionType(), this.getRightNode().getExpressionType(), this.operation, this.flags);
                return;
            } else {
                methodWriter.writeBinaryInstruction(this.getLocation(), this.getExpressionType(), this.operation);
            }
        }
    }
}

