import { LogLevel } from 'matrix-appservice-bridge';
import { IrcConnectionPoolCommandIn, InCommandType } from './types';
declare const Config: {
    redisUri: string;
    metricsHost: string | false;
    metricsPort: number;
    loggingLevel: LogLevel;
};
export declare class IrcConnectionPool {
    private readonly config;
    private readonly cmdWriter;
    /**
     * Track all the connections expecting a pong response.
     */
    private readonly connectionPongTimeouts;
    private readonly cmdReader;
    private readonly connections;
    private commandStreamId;
    private metricsServer?;
    private shouldRun;
    private heartbeatTimer?;
    private readonly commandReader;
    constructor(config: typeof Config);
    private sendCommandOut;
    private createConnectionForOpts;
    private handleConnectCommand;
    private handleDestroyCommand;
    private handleEndCommand;
    private handleSetTimeoutCommand;
    private handleWriteCommand;
    private handleCommand;
    private handleStreamCommand;
    handleInternalPing({ info }: IrcConnectionPoolCommandIn<InCommandType.ConnectionPing>): Promise<void>;
    sendHeartbeat(): Promise<void | "OK">;
    private trimCommandStream;
    start(): Promise<void>;
    close(): Promise<void>;
}
export {};
