#include "quad_edges.h"
#include "unique_simplices.h"

template <
  typename DerivedQ,
  typename DerivedE >
IGL_INLINE void igl::quad_edges(
  const Eigen::MatrixBase<DerivedQ> & Q,
  Eigen::PlainObjectBase<DerivedE> & E)
{
  E.resize(4*Q.rows(),2);
  E <<
    Q.col(0), Q.col(1),
    Q.col(1), Q.col(2),
    Q.col(2), Q.col(3),
    Q.col(3), Q.col(0);
  igl::unique_simplices(Eigen::MatrixXi(E),E);
}

#ifdef IGL_STATIC_LIBRARY
// Explicit template instantiation
// generated by autoexplicit.sh
template void igl::quad_edges<Eigen::Matrix<int, -1, -1, 0, -1, -1>, Eigen::Matrix<int, -1, -1, 0, -1, -1> >(Eigen::MatrixBase<Eigen::Matrix<int, -1, -1, 0, -1, -1> > const&, Eigen::PlainObjectBase<Eigen::Matrix<int, -1, -1, 0, -1, -1> >&);
#endif
