/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.date.DateUtils;

public class DateEditorWithSlider
extends JPanel {
    private final JSpinner spinner;
    private final JSlider slider;
    private Instant dateMin;
    private Instant dateMax;
    private static final int MAX_SLIDER = 300;
    private boolean watchSlider = true;
    private final transient List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public DateEditorWithSlider(String labelText) {
        super(new GridBagLayout());
        this.spinner = new JSpinner(new SpinnerDateModel());
        String pattern = ((SimpleDateFormat)DateUtils.getDateFormat(2)).toPattern();
        JSpinner.DateEditor timeEditor = new JSpinner.DateEditor(this.spinner, pattern);
        this.spinner.setEditor(timeEditor);
        this.spinner.setPreferredSize(new Dimension(this.spinner.getPreferredSize().width + 5, this.spinner.getPreferredSize().height));
        this.slider = new JSlider(0, 300);
        this.spinner.addChangeListener(e -> {
            Date d;
            int j;
            int i = this.slider.getValue();
            if (i != (j = this.intFromDate(d = (Date)this.spinner.getValue()))) {
                this.watchSlider = false;
                this.slider.setValue(j);
                this.watchSlider = true;
            }
            for (ChangeListener l : this.listeners) {
                l.stateChanged(e);
            }
        });
        this.slider.addChangeListener(e -> {
            Date d1;
            if (!this.watchSlider) {
                return;
            }
            Date d = (Date)this.spinner.getValue();
            if (!d.equals(d1 = this.dateFromInt(this.slider.getValue()))) {
                this.spinner.setValue(d1);
            }
        });
        this.add((Component)new JLabel(labelText), GBC.std());
        this.add((Component)this.spinner, GBC.std().insets(10, 0, 0, 0));
        this.add((Component)this.slider, GBC.eol().insets(10, 0, 0, 0).fill(2));
        this.dateMin = Instant.EPOCH;
        this.dateMax = Instant.now();
    }

    protected Date dateFromInt(int value) {
        double k = 1.0 * (double)value / 300.0;
        return new Date((long)((double)this.dateMax.toEpochMilli() * k + (double)this.dateMin.toEpochMilli() * (1.0 - k)));
    }

    protected int intFromDate(Date date) {
        return (int)(300.0 * (double)(date.getTime() - this.dateMin.getEpochSecond()) / (double)(this.dateMax.getEpochSecond() - this.dateMin.getEpochSecond()));
    }

    public void setRange(Instant dateMin, Instant dateMax) {
        this.dateMin = dateMin;
        this.dateMax = dateMax;
    }

    public void setDate(Instant date) {
        this.spinner.setValue(Date.from(date));
    }

    public Instant getDate() {
        return ((Date)this.spinner.getValue()).toInstant();
    }

    public void addDateListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeDateListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }
}

