/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;

public class LayerTransferable
implements Transferable {
    public static final DataFlavor LAYER_DATA = ClipboardUtils.newDataFlavor(Data.class, "Layers");
    private final Data data;

    public LayerTransferable(LayerManager manager, List<Layer> layers) {
        this.data = new Data(manager, layers);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{LAYER_DATA};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return LAYER_DATA.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.data;
    }

    public static class Data {
        private final LayerManager manager;
        private final List<Layer> layers;

        public Data(LayerManager manager, List<Layer> layers) {
            this.manager = manager;
            this.layers = new ArrayList<Layer>(layers);
        }

        public LayerManager getManager() {
            return this.manager;
        }

        public List<Layer> getLayers() {
            return Collections.unmodifiableList(this.layers);
        }

        public String toString() {
            return "Data [layers=" + this.layers + "]";
        }
    }
}

