/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.sources;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.sources.ISourceCategory;
import org.openstreetmap.josm.data.sources.ISourceType;
import org.openstreetmap.josm.data.sources.SourceBounds;
import org.openstreetmap.josm.data.sources.SourcePreferenceEntry;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class SourceInfo<T extends ISourceCategory<?>, U extends ISourceType<?>, V extends SourceBounds, W extends SourcePreferenceEntry<?>>
extends TileSourceInfo
implements Comparable<SourceInfo<T, U, V, W>>,
Attributed {
    protected String origName;
    protected String langName;
    protected boolean defaultEntry;
    protected String eulaAcceptanceRequired;
    protected U sourceType;
    protected V bounds;
    protected String description;
    protected String langDescription;
    protected String attributionText;
    protected String privacyPolicyURL;
    protected String permissionReferenceURL;
    protected String attributionLinkURL;
    protected String attributionImage;
    protected String attributionImageURL;
    protected String termsOfUseText;
    protected String termsOfUseURL;
    protected String countryCode = "";
    protected String date;
    protected Collection<String> oldIds;
    protected String icon;
    protected List<DefaultLayer> defaultLayers = Collections.emptyList();
    protected Map<String, String> customHttpHeaders = Collections.emptyMap();
    protected T category;
    protected String categoryOriginalString;
    private static final Map<String, String> localizedCountriesCache = new HashMap<String, String>();

    public SourceInfo() {
    }

    public SourceInfo(String name) {
        super(name);
    }

    public SourceInfo(String name, String url, String id) {
        super(name, url, id);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.sourceType);
    }

    public boolean equalsPref(SourceInfo<T, U, V, W> other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals(this.url, other.url) && this.modTileFeatures == other.modTileFeatures && Objects.equals(this.cookies, other.cookies) && Objects.equals(this.eulaAcceptanceRequired, other.eulaAcceptanceRequired) && Objects.equals(this.sourceType, other.sourceType) && Objects.equals(this.bounds, other.bounds) && Objects.equals(this.attributionText, other.attributionText) && Objects.equals(this.attributionLinkURL, other.attributionLinkURL) && Objects.equals(this.permissionReferenceURL, other.permissionReferenceURL) && Objects.equals(this.attributionImageURL, other.attributionImageURL) && Objects.equals(this.attributionImage, other.attributionImage) && Objects.equals(this.termsOfUseText, other.termsOfUseText) && Objects.equals(this.termsOfUseURL, other.termsOfUseURL) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.date, other.date) && Objects.equals(this.icon, other.icon) && Objects.equals(this.description, other.description) && Objects.equals(this.noTileHeaders, other.noTileHeaders) && Objects.equals(this.noTileChecksums, other.noTileChecksums) && Objects.equals(this.metadataHeaders, other.metadataHeaders) && Objects.equals(this.defaultLayers, other.defaultLayers) && Objects.equals(this.customHttpHeaders, other.customHttpHeaders) && Objects.equals(this.category, other.category);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceInfo that = (SourceInfo)o;
        return this.sourceType == that.sourceType && Objects.equals(this.url, that.url);
    }

    public static String getLocalizedCountry(String countryCode) {
        return localizedCountriesCache.computeIfAbsent(countryCode, code -> new Locale("en", (String)code).getDisplayCountry());
    }

    public String toString() {
        return this.name + "[" + this.countryCode + "] ('" + SourceInfo.getLocalizedCountry(this.countryCode) + ") - " + this.url + " - " + this.sourceType;
    }

    @Override
    public int compareTo(SourceInfo<T, U, V, W> in) {
        int i = this.countryCode.compareTo(in.countryCode);
        if (i == 0) {
            i = this.name.toLowerCase(Locale.ENGLISH).compareTo(in.name.toLowerCase(Locale.ENGLISH));
        }
        if (i == 0) {
            i = this.url.compareTo(in.url);
        }
        return i;
    }

    public boolean equalsBaseValues(SourceInfo<T, U, V, W> in) {
        return this.url.equals(in.url);
    }

    public void setBounds(V b) {
        this.bounds = b;
    }

    public V getBounds() {
        return this.bounds;
    }

    @Override
    public boolean requiresAttribution() {
        return this.attributionText != null || this.attributionLinkURL != null || this.attributionImage != null || this.termsOfUseText != null || this.termsOfUseURL != null;
    }

    @Override
    public String getAttributionText(int zoom, ICoordinate topLeft, ICoordinate botRight) {
        return this.attributionText;
    }

    @Override
    public String getAttributionLinkURL() {
        return this.attributionLinkURL;
    }

    public String getPermissionReferenceURL() {
        return this.permissionReferenceURL;
    }

    public String getPrivacyPolicyURL() {
        return this.privacyPolicyURL;
    }

    @Override
    public Image getAttributionImage() {
        ImageIcon i = ImageProvider.getIfAvailable(this.attributionImage);
        if (i != null) {
            return i.getImage();
        }
        return null;
    }

    public String getAttributionImageRaw() {
        return this.attributionImage;
    }

    @Override
    public String getAttributionImageURL() {
        return this.attributionImageURL;
    }

    @Override
    public String getTermsOfUseText() {
        return this.termsOfUseText;
    }

    @Override
    public String getTermsOfUseURL() {
        return this.termsOfUseURL;
    }

    public void setAttributionText(String text) {
        this.attributionText = Utils.intern(text);
    }

    public void setAttributionImageURL(String url) {
        this.attributionImageURL = url;
    }

    public void setAttributionImage(String res) {
        this.attributionImage = res;
    }

    public void setAttributionLinkURL(String url) {
        this.attributionLinkURL = url;
    }

    public void setPermissionReferenceURL(String url) {
        this.permissionReferenceURL = url;
    }

    public void setPrivacyPolicyURL(String url) {
        this.privacyPolicyURL = url;
    }

    public void setTermsOfUseText(String text) {
        this.termsOfUseText = text;
    }

    public void setTermsOfUseURL(String text) {
        this.termsOfUseURL = text;
    }

    public String getOriginalName() {
        return this.origName != null ? this.origName : this.name;
    }

    public void setName(String language, String name) {
        boolean isdefault = LanguageInfo.getJOSMLocaleCode(null).equals(language);
        if (LanguageInfo.isBetterLanguage(this.langName, language)) {
            this.name = isdefault ? I18n.tr(name, new Object[0]) : name;
            this.langName = language;
        }
        if (this.origName == null || isdefault) {
            this.origName = name;
        }
    }

    public void clearId() {
        if (this.id != null) {
            TreeSet<String> newAddedIds = new TreeSet<String>(Config.getPref().getList("imagery.layers.addedIds"));
            newAddedIds.add(this.id);
            Config.getPref().putList("imagery.layers.addedIds", new ArrayList<String>(newAddedIds));
        }
        this.setId(null);
    }

    public boolean isDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(boolean defaultEntry) {
        this.defaultEntry = defaultEntry;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String language, String description) {
        boolean isdefault = LanguageInfo.getJOSMLocaleCode(null).equals(language);
        if (LanguageInfo.isBetterLanguage(this.langDescription, language)) {
            this.description = isdefault ? I18n.tr(description, new Object[0]) : description;
            this.langDescription = Utils.intern(language);
        }
    }

    public static <W extends SourceInfo<?, ?, ?, ?>> Collection<String> getActiveIds(Class<W> clazz) {
        IPreferences pref = Config.getPref();
        if (pref == null) {
            return Collections.emptyList();
        }
        List<ImageryInfo.ImageryPreferenceEntry> entries = StructUtils.getListOfStructs(pref, "imagery.entries", null, ImageryInfo.ImageryPreferenceEntry.class);
        if (entries == null) {
            return Collections.emptyList();
        }
        return entries.stream().filter(prefEntry -> !Utils.isEmpty(prefEntry.id)).map(prefEntry -> prefEntry.id).sorted().collect(Collectors.toList());
    }

    public String getToolTipText() {
        String desc;
        StringBuilder res = new StringBuilder(this.getName());
        boolean html = false;
        String dateStr = this.getDate();
        if (!Utils.isEmpty(dateStr)) {
            res.append("<br>").append(I18n.tr("Date of imagery: {0}", dateStr));
            html = true;
        }
        if (this.category != null && this.category.getDescription() != null) {
            res.append("<br>").append(I18n.tr("Imagery category: {0}", this.category.getDescription()));
            html = true;
        }
        if (!Utils.isEmpty(desc = this.getDescription())) {
            res.append("<br>").append(Utils.escapeReservedCharactersHTML(desc));
            html = true;
        }
        if (html) {
            res.insert(0, "<html>").append("</html>");
        }
        return res.toString();
    }

    public String getEulaAcceptanceRequired() {
        return this.eulaAcceptanceRequired;
    }

    public void setEulaAcceptanceRequired(String eulaAcceptanceRequired) {
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = Utils.intern(countryCode);
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = Utils.intern(icon);
    }

    public boolean hasAttribution() {
        return this.attributionText != null;
    }

    public void copyAttribution(SourceInfo<T, U, V, W> i) {
        this.attributionImage = i.attributionImage;
        this.attributionImageURL = i.attributionImageURL;
        this.attributionText = i.attributionText;
        this.attributionLinkURL = i.attributionLinkURL;
        this.termsOfUseText = i.termsOfUseText;
        this.termsOfUseURL = i.termsOfUseURL;
    }

    public void setAttribution(AbstractTileSource s) {
        ImageIcon i;
        if (this.attributionText != null) {
            if ("osm".equals(this.attributionText)) {
                s.setAttributionText(new OsmTileSource.Mapnik().getAttributionText(0, null, null));
            } else {
                s.setAttributionText(this.attributionText);
            }
        }
        if (this.attributionLinkURL != null) {
            if ("osm".equals(this.attributionLinkURL)) {
                s.setAttributionLinkURL(new OsmTileSource.Mapnik().getAttributionLinkURL());
            } else {
                s.setAttributionLinkURL(this.attributionLinkURL);
            }
        }
        if (this.attributionImage != null && (i = ImageProvider.getIfAvailable(null, this.attributionImage)) != null) {
            s.setAttributionImage(i.getImage());
        }
        if (this.attributionImageURL != null) {
            s.setAttributionImageURL(this.attributionImageURL);
        }
        if (this.termsOfUseText != null) {
            s.setTermsOfUseText(this.termsOfUseText);
        }
        if (this.termsOfUseURL != null) {
            if ("osm".equals(this.termsOfUseURL)) {
                s.setTermsOfUseURL(new OsmTileSource.Mapnik().getTermsOfUseURL());
            } else {
                s.setTermsOfUseURL(this.termsOfUseURL);
            }
        }
    }

    public U getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(U imageryType) {
        this.sourceType = imageryType;
    }

    public T getSourceCategory() {
        return this.category;
    }

    public void setSourceCategory(T category) {
        this.category = category;
    }

    public String getSourceCategoryOriginalString() {
        return this.categoryOriginalString;
    }

    public void setSourceCategoryOriginalString(String categoryOriginalString) {
        this.categoryOriginalString = Utils.intern(categoryOriginalString);
    }

    public boolean isBlacklisted() {
        Capabilities capabilities = OsmApi.getOsmApi().getCapabilities();
        return capabilities != null && capabilities.isOnImageryBlacklist(this.url);
    }

    public void setNoTileHeaders(MultiMap<String, String> noTileHeaders) {
        this.noTileHeaders = Utils.isEmpty(noTileHeaders) ? null : noTileHeaders.toMap();
    }

    @Override
    public Map<String, Set<String>> getNoTileHeaders() {
        return this.noTileHeaders;
    }

    public void setNoTileChecksums(MultiMap<String, String> noTileChecksums) {
        this.noTileChecksums = Utils.isEmpty(noTileChecksums) ? null : noTileChecksums.toMap();
    }

    @Override
    public Map<String, Set<String>> getNoTileChecksums() {
        return this.noTileChecksums;
    }

    public void setMetadataHeaders(Map<String, String> metadataHeaders) {
        this.metadataHeaders = Utils.isEmpty(metadataHeaders) ? null : metadataHeaders;
    }

    public void addOldId(String id) {
        if (this.oldIds == null) {
            this.oldIds = new ArrayList<String>();
        }
        this.oldIds.add(id);
    }

    public Collection<String> getOldIds() {
        return this.oldIds;
    }

    public List<DefaultLayer> getDefaultLayers() {
        return this.defaultLayers;
    }

    public void setDefaultLayers(List<DefaultLayer> layers) {
        this.defaultLayers = Utils.toUnmodifiableList(layers);
    }

    public Map<String, String> getCustomHttpHeaders() {
        return this.customHttpHeaders;
    }

    public void setCustomHttpHeaders(Map<String, String> customHttpHeaders) {
        this.customHttpHeaders = Utils.toUnmodifiableMap(customHttpHeaders);
    }

    static {
        localizedCountriesCache.put("", I18n.tr("Worldwide", new Object[0]));
    }
}

