# This file is part of Gajim.
#
# SPDX-License-Identifier: GPL-3.0-only

from gi.repository import GLib
from gi.repository import Gtk

from gajim.common.const import AvatarSize
from gajim.common.util.datetime import utc_now
from gajim.common.util.text import process_non_spacing_marks

from gajim.gtk.conversation.rows.base import BaseRow
from gajim.gtk.conversation.rows.widgets import DateTimeLabel
from gajim.gtk.conversation.rows.widgets import SimpleLabel


class CommandOutputRow(BaseRow):
    def __init__(self, account: str, text: str, is_error: bool) -> None:
        BaseRow.__init__(self, account)

        self.type = "command_output"
        now = utc_now()
        self.timestamp = now.astimezone()
        self.db_timestamp = now.timestamp()

        self.add_css_class("conversation-command-row")

        avatar_placeholder = Gtk.Box()
        avatar_placeholder.set_size_request(AvatarSize.ROSTER, -1)
        icon = Gtk.Image.new_from_icon_name("utilities-terminal-symbolic")
        icon.set_pixel_size(32)
        icon.add_css_class("dimmed")
        avatar_placeholder.append(icon)
        self.grid.attach(avatar_placeholder, 0, 0, 1, 1)

        timestamp_widget = DateTimeLabel(self.timestamp)
        timestamp_widget.set_valign(Gtk.Align.START)
        timestamp_widget.set_margin_start(0)
        self.grid.attach(timestamp_widget, 1, 0, 1, 1)

        text = GLib.markup_escape_text(text)
        markup = f"<tt>{text}</tt>"
        self._label = SimpleLabel()
        if is_error:
            self._label.add_css_class("gajim-command-error")
        else:
            self._label.add_css_class("gajim-command-output")
        self._label.set_markup(process_non_spacing_marks(markup))
        self.grid.attach(self._label, 1, 1, 1, 1)

    def do_unroot(self) -> None:
        BaseRow.do_unroot(self)
