# Community Crypto Release Notes

**Topics**

- <a href="#v2-26-5">v2\.26\.5</a>
    - <a href="#release-summary">Release Summary</a>
    - <a href="#bugfixes">Bugfixes</a>
- <a href="#v2-26-4">v2\.26\.4</a>
    - <a href="#release-summary-1">Release Summary</a>
    - <a href="#bugfixes-1">Bugfixes</a>
- <a href="#v2-26-3">v2\.26\.3</a>
    - <a href="#release-summary-2">Release Summary</a>
    - <a href="#bugfixes-2">Bugfixes</a>
- <a href="#v2-26-2">v2\.26\.2</a>
    - <a href="#release-summary-3">Release Summary</a>
    - <a href="#deprecated-features">Deprecated Features</a>
- <a href="#v2-26-1">v2\.26\.1</a>
    - <a href="#release-summary-4">Release Summary</a>
    - <a href="#bugfixes-3">Bugfixes</a>
- <a href="#v2-26-0">v2\.26\.0</a>
    - <a href="#release-summary-5">Release Summary</a>
    - <a href="#minor-changes">Minor Changes</a>
- <a href="#v2-25-0">v2\.25\.0</a>
    - <a href="#release-summary-6">Release Summary</a>
    - <a href="#minor-changes-1">Minor Changes</a>
- <a href="#v2-24-0">v2\.24\.0</a>
    - <a href="#release-summary-7">Release Summary</a>
    - <a href="#minor-changes-2">Minor Changes</a>
    - <a href="#deprecated-features-1">Deprecated Features</a>
    - <a href="#bugfixes-4">Bugfixes</a>
    - <a href="#new-modules">New Modules</a>
- <a href="#v2-23-0">v2\.23\.0</a>
    - <a href="#release-summary-8">Release Summary</a>
    - <a href="#minor-changes-3">Minor Changes</a>
    - <a href="#deprecated-features-2">Deprecated Features</a>
- <a href="#v2-22-3">v2\.22\.3</a>
    - <a href="#release-summary-9">Release Summary</a>
    - <a href="#bugfixes-5">Bugfixes</a>
- <a href="#v2-22-2">v2\.22\.2</a>
    - <a href="#release-summary-10">Release Summary</a>
    - <a href="#bugfixes-6">Bugfixes</a>
- <a href="#v2-22-1">v2\.22\.1</a>
    - <a href="#release-summary-11">Release Summary</a>
    - <a href="#bugfixes-7">Bugfixes</a>
- <a href="#v2-22-0">v2\.22\.0</a>
    - <a href="#release-summary-12">Release Summary</a>
    - <a href="#minor-changes-4">Minor Changes</a>
- <a href="#v2-21-1">v2\.21\.1</a>
    - <a href="#release-summary-13">Release Summary</a>
    - <a href="#bugfixes-8">Bugfixes</a>
- <a href="#v2-21-0">v2\.21\.0</a>
    - <a href="#release-summary-14">Release Summary</a>
    - <a href="#minor-changes-5">Minor Changes</a>
- <a href="#v2-20-0">v2\.20\.0</a>
    - <a href="#release-summary-15">Release Summary</a>
    - <a href="#minor-changes-6">Minor Changes</a>
    - <a href="#deprecated-features-3">Deprecated Features</a>
    - <a href="#bugfixes-9">Bugfixes</a>
    - <a href="#new-modules-1">New Modules</a>
- <a href="#v2-19-1">v2\.19\.1</a>
    - <a href="#release-summary-16">Release Summary</a>
    - <a href="#bugfixes-10">Bugfixes</a>
- <a href="#v2-19-0">v2\.19\.0</a>
    - <a href="#release-summary-17">Release Summary</a>
    - <a href="#minor-changes-7">Minor Changes</a>
    - <a href="#deprecated-features-4">Deprecated Features</a>
    - <a href="#bugfixes-11">Bugfixes</a>
    - <a href="#new-modules-2">New Modules</a>
- <a href="#v2-18-0">v2\.18\.0</a>
    - <a href="#release-summary-18">Release Summary</a>
    - <a href="#minor-changes-8">Minor Changes</a>
    - <a href="#deprecated-features-5">Deprecated Features</a>
    - <a href="#bugfixes-12">Bugfixes</a>
    - <a href="#new-plugins">New Plugins</a>
        - <a href="#filter">Filter</a>
- <a href="#v2-17-1">v2\.17\.1</a>
    - <a href="#release-summary-19">Release Summary</a>
    - <a href="#bugfixes-13">Bugfixes</a>
- <a href="#v2-17-0">v2\.17\.0</a>
    - <a href="#release-summary-20">Release Summary</a>
    - <a href="#minor-changes-9">Minor Changes</a>
- <a href="#v2-16-2">v2\.16\.2</a>
    - <a href="#release-summary-21">Release Summary</a>
    - <a href="#bugfixes-14">Bugfixes</a>
- <a href="#v2-16-1">v2\.16\.1</a>
    - <a href="#release-summary-22">Release Summary</a>
    - <a href="#bugfixes-15">Bugfixes</a>
- <a href="#v2-16-0">v2\.16\.0</a>
    - <a href="#release-summary-23">Release Summary</a>
    - <a href="#minor-changes-10">Minor Changes</a>
    - <a href="#bugfixes-16">Bugfixes</a>
- <a href="#v2-15-1">v2\.15\.1</a>
    - <a href="#release-summary-24">Release Summary</a>
    - <a href="#bugfixes-17">Bugfixes</a>
- <a href="#v2-15-0">v2\.15\.0</a>
    - <a href="#release-summary-25">Release Summary</a>
    - <a href="#minor-changes-11">Minor Changes</a>
    - <a href="#deprecated-features-6">Deprecated Features</a>
    - <a href="#bugfixes-18">Bugfixes</a>
    - <a href="#new-plugins-1">New Plugins</a>
        - <a href="#filter-1">Filter</a>
        - <a href="#lookup">Lookup</a>
- <a href="#v2-14-1">v2\.14\.1</a>
    - <a href="#release-summary-26">Release Summary</a>
    - <a href="#bugfixes-19">Bugfixes</a>
    - <a href="#known-issues">Known Issues</a>
- <a href="#v2-14-0">v2\.14\.0</a>
    - <a href="#release-summary-27">Release Summary</a>
    - <a href="#minor-changes-12">Minor Changes</a>
- <a href="#v2-13-1">v2\.13\.1</a>
    - <a href="#release-summary-28">Release Summary</a>
    - <a href="#bugfixes-20">Bugfixes</a>
- <a href="#v2-13-0">v2\.13\.0</a>
    - <a href="#release-summary-29">Release Summary</a>
    - <a href="#minor-changes-13">Minor Changes</a>
    - <a href="#deprecated-features-7">Deprecated Features</a>
    - <a href="#bugfixes-21">Bugfixes</a>
- <a href="#v2-12-0">v2\.12\.0</a>
    - <a href="#release-summary-30">Release Summary</a>
    - <a href="#minor-changes-14">Minor Changes</a>
- <a href="#v2-11-1">v2\.11\.1</a>
    - <a href="#release-summary-31">Release Summary</a>
- <a href="#v2-11-0">v2\.11\.0</a>
    - <a href="#release-summary-32">Release Summary</a>
    - <a href="#minor-changes-15">Minor Changes</a>
    - <a href="#bugfixes-22">Bugfixes</a>
- <a href="#v2-10-0">v2\.10\.0</a>
    - <a href="#release-summary-33">Release Summary</a>
    - <a href="#bugfixes-23">Bugfixes</a>
    - <a href="#new-plugins-2">New Plugins</a>
        - <a href="#filter-2">Filter</a>
- <a href="#v2-9-0">v2\.9\.0</a>
    - <a href="#release-summary-34">Release Summary</a>
    - <a href="#minor-changes-16">Minor Changes</a>
- <a href="#v2-8-1">v2\.8\.1</a>
    - <a href="#release-summary-35">Release Summary</a>
- <a href="#v2-8-0">v2\.8\.0</a>
    - <a href="#release-summary-36">Release Summary</a>
    - <a href="#minor-changes-17">Minor Changes</a>
- <a href="#v2-7-1">v2\.7\.1</a>
    - <a href="#release-summary-37">Release Summary</a>
    - <a href="#bugfixes-24">Bugfixes</a>
- <a href="#v2-7-0">v2\.7\.0</a>
    - <a href="#release-summary-38">Release Summary</a>
    - <a href="#minor-changes-18">Minor Changes</a>
    - <a href="#bugfixes-25">Bugfixes</a>
- <a href="#v2-6-0">v2\.6\.0</a>
    - <a href="#release-summary-39">Release Summary</a>
    - <a href="#minor-changes-19">Minor Changes</a>
- <a href="#v2-5-0">v2\.5\.0</a>
    - <a href="#release-summary-40">Release Summary</a>
    - <a href="#minor-changes-20">Minor Changes</a>
- <a href="#v2-4-0">v2\.4\.0</a>
    - <a href="#release-summary-41">Release Summary</a>
    - <a href="#deprecated-features-8">Deprecated Features</a>
    - <a href="#bugfixes-26">Bugfixes</a>
- <a href="#v2-3-4">v2\.3\.4</a>
    - <a href="#release-summary-42">Release Summary</a>
- <a href="#v2-3-3">v2\.3\.3</a>
    - <a href="#release-summary-43">Release Summary</a>
    - <a href="#bugfixes-27">Bugfixes</a>
- <a href="#v2-3-2">v2\.3\.2</a>
    - <a href="#release-summary-44">Release Summary</a>
    - <a href="#bugfixes-28">Bugfixes</a>
- <a href="#v2-3-1">v2\.3\.1</a>
    - <a href="#release-summary-45">Release Summary</a>
    - <a href="#bugfixes-29">Bugfixes</a>
- <a href="#v2-3-0">v2\.3\.0</a>
    - <a href="#release-summary-46">Release Summary</a>
    - <a href="#minor-changes-21">Minor Changes</a>
    - <a href="#bugfixes-30">Bugfixes</a>
- <a href="#v2-2-4">v2\.2\.4</a>
    - <a href="#release-summary-47">Release Summary</a>
    - <a href="#bugfixes-31">Bugfixes</a>
- <a href="#v2-2-3">v2\.2\.3</a>
    - <a href="#release-summary-48">Release Summary</a>
    - <a href="#bugfixes-32">Bugfixes</a>
- <a href="#v2-2-2">v2\.2\.2</a>
    - <a href="#release-summary-49">Release Summary</a>
    - <a href="#bugfixes-33">Bugfixes</a>
- <a href="#v2-2-1">v2\.2\.1</a>
    - <a href="#release-summary-50">Release Summary</a>
    - <a href="#bugfixes-34">Bugfixes</a>
- <a href="#v2-2-0">v2\.2\.0</a>
    - <a href="#release-summary-51">Release Summary</a>
    - <a href="#minor-changes-22">Minor Changes</a>
    - <a href="#bugfixes-35">Bugfixes</a>
- <a href="#v2-1-0">v2\.1\.0</a>
    - <a href="#release-summary-52">Release Summary</a>
    - <a href="#minor-changes-23">Minor Changes</a>
    - <a href="#bugfixes-36">Bugfixes</a>
    - <a href="#new-modules-3">New Modules</a>
- <a href="#v2-0-2">v2\.0\.2</a>
    - <a href="#release-summary-53">Release Summary</a>
- <a href="#v2-0-1">v2\.0\.1</a>
    - <a href="#release-summary-54">Release Summary</a>
    - <a href="#minor-changes-24">Minor Changes</a>
    - <a href="#bugfixes-37">Bugfixes</a>
- <a href="#v2-0-0">v2\.0\.0</a>
    - <a href="#release-summary-55">Release Summary</a>
    - <a href="#minor-changes-25">Minor Changes</a>
    - <a href="#breaking-changes--porting-guide">Breaking Changes / Porting Guide</a>
    - <a href="#deprecated-features-9">Deprecated Features</a>
    - <a href="#removed-features-previously-deprecated">Removed Features \(previously deprecated\)</a>
    - <a href="#bugfixes-38">Bugfixes</a>
- <a href="#v1-9-4">v1\.9\.4</a>
    - <a href="#release-summary-56">Release Summary</a>
    - <a href="#bugfixes-39">Bugfixes</a>
- <a href="#v1-9-3">v1\.9\.3</a>
    - <a href="#release-summary-57">Release Summary</a>
    - <a href="#bugfixes-40">Bugfixes</a>
- <a href="#v1-9-2">v1\.9\.2</a>
    - <a href="#release-summary-58">Release Summary</a>
- <a href="#v1-9-1">v1\.9\.1</a>
    - <a href="#release-summary-59">Release Summary</a>
- <a href="#v1-9-0">v1\.9\.0</a>
    - <a href="#release-summary-60">Release Summary</a>
    - <a href="#minor-changes-26">Minor Changes</a>
    - <a href="#bugfixes-41">Bugfixes</a>
- <a href="#v1-8-0">v1\.8\.0</a>
    - <a href="#release-summary-61">Release Summary</a>
    - <a href="#minor-changes-27">Minor Changes</a>
    - <a href="#bugfixes-42">Bugfixes</a>
- <a href="#v1-7-1">v1\.7\.1</a>
    - <a href="#release-summary-62">Release Summary</a>
    - <a href="#bugfixes-43">Bugfixes</a>
- <a href="#v1-7-0">v1\.7\.0</a>
    - <a href="#release-summary-63">Release Summary</a>
    - <a href="#minor-changes-28">Minor Changes</a>
    - <a href="#bugfixes-44">Bugfixes</a>
    - <a href="#new-modules-4">New Modules</a>
- <a href="#v1-6-2">v1\.6\.2</a>
    - <a href="#release-summary-64">Release Summary</a>
    - <a href="#bugfixes-45">Bugfixes</a>
- <a href="#v1-6-1">v1\.6\.1</a>
    - <a href="#release-summary-65">Release Summary</a>
    - <a href="#bugfixes-46">Bugfixes</a>
- <a href="#v1-6-0">v1\.6\.0</a>
    - <a href="#release-summary-66">Release Summary</a>
    - <a href="#minor-changes-29">Minor Changes</a>
    - <a href="#deprecated-features-10">Deprecated Features</a>
    - <a href="#bugfixes-47">Bugfixes</a>
- <a href="#v1-5-0">v1\.5\.0</a>
    - <a href="#release-summary-67">Release Summary</a>
    - <a href="#minor-changes-30">Minor Changes</a>
    - <a href="#deprecated-features-11">Deprecated Features</a>
    - <a href="#bugfixes-48">Bugfixes</a>
- <a href="#v1-4-0">v1\.4\.0</a>
    - <a href="#release-summary-68">Release Summary</a>
    - <a href="#minor-changes-31">Minor Changes</a>
    - <a href="#bugfixes-49">Bugfixes</a>
- <a href="#v1-3-0">v1\.3\.0</a>
    - <a href="#release-summary-69">Release Summary</a>
    - <a href="#minor-changes-32">Minor Changes</a>
    - <a href="#bugfixes-50">Bugfixes</a>
    - <a href="#new-modules-5">New Modules</a>
- <a href="#v1-2-0">v1\.2\.0</a>
    - <a href="#release-summary-70">Release Summary</a>
    - <a href="#minor-changes-33">Minor Changes</a>
    - <a href="#security-fixes">Security Fixes</a>
    - <a href="#bugfixes-51">Bugfixes</a>
- <a href="#v1-1-1">v1\.1\.1</a>
    - <a href="#release-summary-71">Release Summary</a>
    - <a href="#bugfixes-52">Bugfixes</a>
- <a href="#v1-1-0">v1\.1\.0</a>
    - <a href="#release-summary-72">Release Summary</a>
    - <a href="#minor-changes-34">Minor Changes</a>
    - <a href="#bugfixes-53">Bugfixes</a>
    - <a href="#new-modules-6">New Modules</a>
- <a href="#v1-0-0">v1\.0\.0</a>
    - <a href="#release-summary-73">Release Summary</a>
    - <a href="#minor-changes-35">Minor Changes</a>
    - <a href="#deprecated-features-12">Deprecated Features</a>
    - <a href="#removed-features-previously-deprecated-1">Removed Features \(previously deprecated\)</a>
    - <a href="#bugfixes-54">Bugfixes</a>
    - <a href="#new-modules-7">New Modules</a>

<a id="v2-26-5"></a>
## v2\.26\.5

<a id="release-summary"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes"></a>
### Bugfixes

* acme\_\* modules \- also retry on HTTP responses 502 Bad Gateway and 504 Gateway Timeout\. The latter is needed for ZeroSSL\, which seems to have a lot of 504s \([https\://github\.com/ansible\-collections/community\.crypto/issues/945](https\://github\.com/ansible\-collections/community\.crypto/issues/945)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/947](https\://github\.com/ansible\-collections/community\.crypto/pull/947)\)\.
* acme\_\* modules \- increase the maximum amount of retries from 10 to 20 to accomodate ZeroSSL\'s buggy implementation \([https\://github\.com/ansible\-collections/community\.crypto/pull/949](https\://github\.com/ansible\-collections/community\.crypto/pull/949)\)\.

<a id="v2-26-4"></a>
## v2\.26\.4

<a id="release-summary-1"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-1"></a>
### Bugfixes

* Improve error message when loading a private key fails due to correct private key files or wrong passwords\. Also include the original cryptography error since it likely contains more helpful information \([https\://github\.com/ansible\-collections/community\.crypto/issues/936](https\://github\.com/ansible\-collections/community\.crypto/issues/936)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/939](https\://github\.com/ansible\-collections/community\.crypto/pull/939)\)\.

<a id="v2-26-3"></a>
## v2\.26\.3

<a id="release-summary-2"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-2"></a>
### Bugfixes

* acme\_account \- make work with CAs that do not accept any account request without External Account Binding data \([https\://github\.com/ansible\-collections/community\.crypto/issues/918](https\://github\.com/ansible\-collections/community\.crypto/issues/918)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/919](https\://github\.com/ansible\-collections/community\.crypto/pull/919)\)\.

<a id="v2-26-2"></a>
## v2\.26\.2

<a id="release-summary-3"></a>
### Release Summary

Maintenance release announcing removal of the Entrust content from community\.crypto 3\.0\.0\.

<a id="deprecated-features"></a>
### Deprecated Features

* The Entrust service in currently being sunsetted after the sale of Entrust\'s Public Certificates Business to Sectigo\; see [the announcement with key dates](https\://www\.entrust\.com/tls\-certificate\-information\-center) and [the migration brief for customers](https\://www\.sectigo\.com/uploads/resources/EOL\_Migration\-Brief\-End\-Customer\.pdf) for details \([https\://github\.com/ansible\-collections/community\.crypto/issues/895](https\://github\.com/ansible\-collections/community\.crypto/issues/895)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/901](https\://github\.com/ansible\-collections/community\.crypto/pull/901)\)\.
* ecs\_certificate \- the module will be removed from community\.crypto 3\.0\.0 \([https\://github\.com/ansible\-collections/community\.crypto/issues/895](https\://github\.com/ansible\-collections/community\.crypto/issues/895)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/901](https\://github\.com/ansible\-collections/community\.crypto/pull/901)\)\.
* ecs\_domain \- the module will be removed from community\.crypto 3\.0\.0 \([https\://github\.com/ansible\-collections/community\.crypto/issues/895](https\://github\.com/ansible\-collections/community\.crypto/issues/895)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/901](https\://github\.com/ansible\-collections/community\.crypto/pull/901)\)\.
* x509\_certificate \- the <code>entrust</code> provider will be removed from community\.crypto 3\.0\.0 \([https\://github\.com/ansible\-collections/community\.crypto/issues/895](https\://github\.com/ansible\-collections/community\.crypto/issues/895)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/901](https\://github\.com/ansible\-collections/community\.crypto/pull/901)\)\.
* x509\_certificate\_pipe \- the <code>entrust</code> provider will be removed from community\.crypto 3\.0\.0 \([https\://github\.com/ansible\-collections/community\.crypto/issues/895](https\://github\.com/ansible\-collections/community\.crypto/issues/895)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/901](https\://github\.com/ansible\-collections/community\.crypto/pull/901)\)\.

<a id="v2-26-1"></a>
## v2\.26\.1

<a id="release-summary-4"></a>
### Release Summary

Bugfix and maintenance release with improved CI\.

<a id="bugfixes-3"></a>
### Bugfixes

* luks\_device \- mark parameter <code>passphrase\_encoding</code> as <code>no\_log\=False</code> to avoid confusing warning \([https\://github\.com/ansible\-collections/community\.crypto/pull/867](https\://github\.com/ansible\-collections/community\.crypto/pull/867)\)\.
* luks\_device \- removing a specific keyslot with <code>remove\_keyslot</code> caused the module to hang while cryptsetup was waiting for a passphrase from stdin\, while the module did not supply one\. Since a keyslot is not necessary\, do not provide one \([https\://github\.com/ansible\-collections/community\.crypto/issues/864](https\://github\.com/ansible\-collections/community\.crypto/issues/864)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/868](https\://github\.com/ansible\-collections/community\.crypto/pull/868)\)\.

<a id="v2-26-0"></a>
## v2\.26\.0

<a id="release-summary-5"></a>
### Release Summary

Feature release\.

<a id="minor-changes"></a>
### Minor Changes

* openssl\_pkcs12 \- the module now supports <code>certificate\_content</code>/<code>other\_certificates\_content</code> for cases where the data already exists in memory and not yet in a file \([https\://github\.com/ansible\-collections/community\.crypto/issues/847](https\://github\.com/ansible\-collections/community\.crypto/issues/847)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/848](https\://github\.com/ansible\-collections/community\.crypto/pull/848)\)\.

<a id="v2-25-0"></a>
## v2\.25\.0

<a id="release-summary-6"></a>
### Release Summary

Feature release\.

<a id="minor-changes-1"></a>
### Minor Changes

* luks\_device \- allow passphrases to contain newlines \([https\://github\.com/ansible\-collections/community\.crypto/pull/844](https\://github\.com/ansible\-collections/community\.crypto/pull/844)\)\.

<a id="v2-24-0"></a>
## v2\.24\.0

<a id="release-summary-7"></a>
### Release Summary

New feature and bugfix release with multiple new modules\. It also deprecates support for older ansible\-core and Python versions\.

<a id="minor-changes-2"></a>
### Minor Changes

* acme\_certificate \- add options <code>order\_creation\_error\_strategy</code> and <code>order\_creation\_max\_retries</code> which allow to configure the error handling behavior if creating a new ACME order fails\. This is particularly important when using the <code>include\_renewal\_cert\_id</code> option\, and the default value <code>auto</code> for <code>order\_creation\_error\_strategy</code> tries to gracefully handle related errors \([https\://github\.com/ansible\-collections/community\.crypto/pull/842](https\://github\.com/ansible\-collections/community\.crypto/pull/842)\)\.
* acme\_certificate \- allow to chose a profile for certificate generation\, in case the CA supports this using Internet\-Draft [draft\-aaron\-acme\-profiles](https\://datatracker\.ietf\.org/doc/draft\-aaron\-acme\-profiles/) \([https\://github\.com/ansible\-collections/community\.crypto/pull/835](https\://github\.com/ansible\-collections/community\.crypto/pull/835)\)\.
* acme\_certificate\_renewal\_info \- add <code>exists</code> and <code>parsable</code> return values and <code>treat\_parsing\_error\_as\_non\_existing</code> option \([https\://github\.com/ansible\-collections/community\.crypto/pull/838](https\://github\.com/ansible\-collections/community\.crypto/pull/838)\)\.

<a id="deprecated-features-1"></a>
### Deprecated Features

* Support for ansible\-core 2\.11\, 2\.12\, 2\.13\, 2\.14\, 2\.15\, and 2\.16 is deprecated\, and will be removed in the next major release \(community\.crypto 3\.0\.0\)\. Some modules might still work with some of these versions afterwards\, but we will no longer keep compatibility code that was needed to support them\. Note that this means that support for all Python versions before 3\.7 will be dropped\, also on the target side \([https\://github\.com/ansible\-collections/community\.crypto/issues/559](https\://github\.com/ansible\-collections/community\.crypto/issues/559)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/839](https\://github\.com/ansible\-collections/community\.crypto/pull/839)\)\.
* Support for cryptography \< 3\.4 is deprecated\, and will be removed in the next major release \(community\.crypto 3\.0\.0\)\. Some modules might still work with older versions of cryptography\, but we will no longer keep compatibility code that was needed to support them \([https\://github\.com/ansible\-collections/community\.crypto/issues/559](https\://github\.com/ansible\-collections/community\.crypto/issues/559)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/839](https\://github\.com/ansible\-collections/community\.crypto/pull/839)\)\.

<a id="bugfixes-4"></a>
### Bugfixes

* crypto\_info \- when running the module on Fedora 41 with <code>cryptography</code> installed from the package repository\, the module crashed apparently due to some elliptic curves being removed from libssl against which cryptography is running\, which cryptography did not expect \([https\://github\.com/ansible\-collections/community\.crypto/pull/834](https\://github\.com/ansible\-collections/community\.crypto/pull/834)\)\.

<a id="new-modules"></a>
### New Modules

* community\.crypto\.acme\_certificate\_order\_create \- Create an ACME v2 order\.
* community\.crypto\.acme\_certificate\_order\_finalize \- Finalize an ACME v2 order\.
* community\.crypto\.acme\_certificate\_order\_info \- Obtain information for an ACME v2 order\.
* community\.crypto\.acme\_certificate\_order\_validate \- Validate authorizations of an ACME v2 order\.

<a id="v2-23-0"></a>
## v2\.23\.0

<a id="release-summary-8"></a>
### Release Summary

Feature release\.

<a id="minor-changes-3"></a>
### Minor Changes

* acme\_certificate \- add compatibility for ACME CAs that are not fully RFC8555 compliant and do not provide <code>challenges</code> in authz objects \([https\://github\.com/ansible\-collections/community\.crypto/issues/824](https\://github\.com/ansible\-collections/community\.crypto/issues/824)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/832](https\://github\.com/ansible\-collections/community\.crypto/pull/832)\)\.
* luks\_device \- allow to provide passphrases base64\-encoded \([https\://github\.com/ansible\-collections/community\.crypto/issues/827](https\://github\.com/ansible\-collections/community\.crypto/issues/827)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/829](https\://github\.com/ansible\-collections/community\.crypto/pull/829)\)\.
* x509\_certificate\_convert \- add new option <code>verify\_cert\_parsable</code> which allows to check whether the certificate can actually be parsed \([https\://github\.com/ansible\-collections/community\.crypto/issues/809](https\://github\.com/ansible\-collections/community\.crypto/issues/809)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/830](https\://github\.com/ansible\-collections/community\.crypto/pull/830)\)\.

<a id="deprecated-features-2"></a>
### Deprecated Features

* openssl\_pkcs12 \- the PyOpenSSL based backend is deprecated and will be removed from community\.crypto 3\.0\.0\. From that point on you need cryptography 3\.0 or newer to use this module \([https\://github\.com/ansible\-collections/community\.crypto/issues/667](https\://github\.com/ansible\-collections/community\.crypto/issues/667)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/831](https\://github\.com/ansible\-collections/community\.crypto/pull/831)\)\.

<a id="v2-22-3"></a>
## v2\.22\.3

<a id="release-summary-9"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-5"></a>
### Bugfixes

* acme\_\* modules \- when using the OpenSSL backend\, explicitly use the UTC timezone in Python code \([https\://github\.com/ansible\-collections/community\.crypto/pull/811](https\://github\.com/ansible\-collections/community\.crypto/pull/811)\)\.
* time module utils \- fix conversion of naive <code>datetime</code> objects to UNIX timestamps for Python 3 \([https\://github\.com/ansible\-collections/community\.crypto/issues/808](https\://github\.com/ansible\-collections/community\.crypto/issues/808)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/810](https\://github\.com/ansible\-collections/community\.crypto/pull/810)\)\.

<a id="v2-22-2"></a>
## v2\.22\.2

<a id="release-summary-10"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-6"></a>
### Bugfixes

* acme\_certificate \- fix authorization failure when CSR contains SANs with mixed case \([https\://github\.com/ansible\-collections/community\.crypto/pull/803](https\://github\.com/ansible\-collections/community\.crypto/pull/803)\)\.

<a id="v2-22-1"></a>
## v2\.22\.1

<a id="release-summary-11"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-7"></a>
### Bugfixes

* acme\_\* modules \- when querying renewal information\, make sure to insert a slash between the base URL and the certificate identifier \([https\://github\.com/ansible\-collections/community\.crypto/issues/801](https\://github\.com/ansible\-collections/community\.crypto/issues/801)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/802](https\://github\.com/ansible\-collections/community\.crypto/pull/802)\)\.
* various modules \- pass absolute paths to <code>module\.atomic\_move\(\)</code> \([https\://github\.com/ansible/ansible/issues/83950](https\://github\.com/ansible/ansible/issues/83950)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/799](https\://github\.com/ansible\-collections/community\.crypto/pull/799)\)\.

<a id="v2-22-0"></a>
## v2\.22\.0

<a id="release-summary-12"></a>
### Release Summary

Feature release\.

<a id="minor-changes-4"></a>
### Minor Changes

* openssl\_privatekey\, openssl\_privatekey\_pipe \- add default value <code>auto</code> for <code>cipher</code> option\, which happens to be the only supported value for this option anyway\. Therefore it is no longer necessary to specify <code>cipher\=auto</code> when providing <code>passphrase</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/793](https\://github\.com/ansible\-collections/community\.crypto/issues/793)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/794](https\://github\.com/ansible\-collections/community\.crypto/pull/794)\)\.

<a id="v2-21-1"></a>
## v2\.21\.1

<a id="release-summary-13"></a>
### Release Summary

Maintenance release\.

<a id="bugfixes-8"></a>
### Bugfixes

* When using cryptography \>\= 43\.0\.0\, use offset\-aware <code>datetime\.datetime</code> objects \(with timezone UTC\) instead of offset\-naive UTC timestamps for the <code>InvalidityDate</code> X\.509 CRL extension \([https\://github\.com/ansible\-collections/community\.crypto/issues/726](https\://github\.com/ansible\-collections/community\.crypto/issues/726)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/730](https\://github\.com/ansible\-collections/community\.crypto/pull/730)\)\.

<a id="v2-21-0"></a>
## v2\.21\.0

<a id="release-summary-14"></a>
### Release Summary

Feature release\.

<a id="minor-changes-5"></a>
### Minor Changes

* certificate\_complete\_chain \- add ability to identify Ed25519 and Ed448 complete chains \([https\://github\.com/ansible\-collections/community\.crypto/pull/777](https\://github\.com/ansible\-collections/community\.crypto/pull/777)\)\.
* get\_certificate \- adds <code>tls\_ctx\_options</code> option for specifying SSL CTX options \([https\://github\.com/ansible\-collections/community\.crypto/pull/779](https\://github\.com/ansible\-collections/community\.crypto/pull/779)\)\.
* get\_certificate \- allow to obtain the certificate chain sent by the server\, and the one used for validation\, with the new <code>get\_certificate\_chain</code> option\. Note that this option only works if the module is run with Python 3\.10 or newer \([https\://github\.com/ansible\-collections/community\.crypto/issues/568](https\://github\.com/ansible\-collections/community\.crypto/issues/568)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/784](https\://github\.com/ansible\-collections/community\.crypto/pull/784)\)\.

<a id="v2-20-0"></a>
## v2\.20\.0

<a id="release-summary-15"></a>
### Release Summary

Feature and bugfix release\.

The deprecations in this release are only relevant for collections that use shared
code or docs fragments from this collection\.

<a id="minor-changes-6"></a>
### Minor Changes

* acme\_certificate \- add <code>include\_renewal\_cert\_id</code> option to allow requesting renewal of a specific certificate according to the current ACME Renewal Information specification draft \([https\://github\.com/ansible\-collections/community\.crypto/pull/739](https\://github\.com/ansible\-collections/community\.crypto/pull/739)\)\.

<a id="deprecated-features-3"></a>
### Deprecated Features

* acme documentation fragment \- the default <code>community\.crypto\.acme\[\.documentation\]</code> docs fragment is deprecated and will be removed from community\.crypto 3\.0\.0\. Replace it with both the new <code>community\.crypto\.acme\.basic</code> and <code>community\.crypto\.acme\.account</code> fragments \([https\://github\.com/ansible\-collections/community\.crypto/pull/735](https\://github\.com/ansible\-collections/community\.crypto/pull/735)\)\.
* acme\.backends module utils \- the <code>get\_cert\_information\(\)</code> method for a ACME crypto backend must be implemented from community\.crypto 3\.0\.0 on \([https\://github\.com/ansible\-collections/community\.crypto/pull/736](https\://github\.com/ansible\-collections/community\.crypto/pull/736)\)\.
* crypto\.module\_backends\.common module utils \- the <code>crypto\.module\_backends\.common</code> module utils is deprecated and will be removed from community\.crypto 3\.0\.0\. Use the improved <code>argspec</code> module util instead \([https\://github\.com/ansible\-collections/community\.crypto/pull/749](https\://github\.com/ansible\-collections/community\.crypto/pull/749)\)\.

<a id="bugfixes-9"></a>
### Bugfixes

* x509\_crl\, x509\_certificate\, x509\_certificate\_info \- when parsing absolute timestamps which omitted the second count\, the first digit of the minutes was used as a one\-digit minutes count\, and the second digit of the minutes as a one\-digit second count \([https\://github\.com/ansible\-collections/community\.crypto/pull/745](https\://github\.com/ansible\-collections/community\.crypto/pull/745)\)\.

<a id="new-modules-1"></a>
### New Modules

* community\.crypto\.acme\_ari\_info \- Retrieves ACME Renewal Information \(ARI\) for a certificate\.
* community\.crypto\.acme\_certificate\_deactivate\_authz \- Deactivate all authz for an ACME v2 order\.
* community\.crypto\.acme\_certificate\_renewal\_info \- Determine whether a certificate should be renewed or not\.

<a id="v2-19-1"></a>
## v2\.19\.1

<a id="release-summary-16"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-10"></a>
### Bugfixes

* crypto\.math module utils \- change return values for <code>quick\_is\_not\_prime\(\)</code> and <code>convert\_int\_to\_bytes\(0\, 0\)</code> for special cases that do not appear when using the collection \([https\://github\.com/ansible\-collections/community\.crypto/pull/733](https\://github\.com/ansible\-collections/community\.crypto/pull/733)\)\.
* ecs\_certificate \- fixed <code>csr</code> option to be empty and allow renewal of a specific certificate according to the Renewal Information specification \([https\://github\.com/ansible\-collections/community\.crypto/pull/740](https\://github\.com/ansible\-collections/community\.crypto/pull/740)\)\.
* x509\_certificate \- since community\.crypto 2\.19\.0 the module was no longer idempotent with respect to <code>not\_before</code> and <code>not\_after</code> times\. This is now fixed \([https\://github\.com/ansible\-collections/community\.crypto/issues/753](https\://github\.com/ansible\-collections/community\.crypto/issues/753)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/754](https\://github\.com/ansible\-collections/community\.crypto/pull/754)\)\.

<a id="v2-19-0"></a>
## v2\.19\.0

<a id="release-summary-17"></a>
### Release Summary

Bugfix and feature release\.

<a id="minor-changes-7"></a>
### Minor Changes

* When using cryptography \>\= 42\.0\.0\, use offset\-aware <code>datetime\.datetime</code> objects \(with timezone UTC\) instead of offset\-naive UTC timestamps \([https\://github\.com/ansible\-collections/community\.crypto/issues/726](https\://github\.com/ansible\-collections/community\.crypto/issues/726)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/727](https\://github\.com/ansible\-collections/community\.crypto/pull/727)\)\.
* openssh\_cert \- avoid UTC functions deprecated in Python 3\.12 when using Python 3 \([https\://github\.com/ansible\-collections/community\.crypto/pull/727](https\://github\.com/ansible\-collections/community\.crypto/pull/727)\)\.

<a id="deprecated-features-4"></a>
### Deprecated Features

* acme\.backends module utils \- from community\.crypto on\, all implementations of <code>CryptoBackend</code> must override <code>get\_ordered\_csr\_identifiers\(\)</code>\. The current default implementation\, which simply sorts the result of <code>get\_csr\_identifiers\(\)</code>\, will then be removed \([https\://github\.com/ansible\-collections/community\.crypto/pull/725](https\://github\.com/ansible\-collections/community\.crypto/pull/725)\)\.

<a id="bugfixes-11"></a>
### Bugfixes

* acme\_certificate \- respect the order of the CNAME and SAN identifiers that are passed on when creating an ACME order \([https\://github\.com/ansible\-collections/community\.crypto/issues/723](https\://github\.com/ansible\-collections/community\.crypto/issues/723)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/725](https\://github\.com/ansible\-collections/community\.crypto/pull/725)\)\.

<a id="new-modules-2"></a>
### New Modules

* community\.crypto\.x509\_certificate\_convert \- Convert X\.509 certificates

<a id="v2-18-0"></a>
## v2\.18\.0

<a id="release-summary-18"></a>
### Release Summary

Bugfix and feature release\.

<a id="minor-changes-8"></a>
### Minor Changes

* x509\_crl \- the new option <code>serial\_numbers</code> allow to configure in which format serial numbers can be provided to <code>revoked\_certificates\[\]\.serial\_number</code>\. The default is as integers \(<code>serial\_numbers\=integer</code>\) for backwards compatibility\; setting <code>serial\_numbers\=hex\-octets</code> allows to specify colon\-separated hex octet strings like <code>00\:11\:22\:FF</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/687](https\://github\.com/ansible\-collections/community\.crypto/issues/687)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/715](https\://github\.com/ansible\-collections/community\.crypto/pull/715)\)\.

<a id="deprecated-features-5"></a>
### Deprecated Features

* openssl\_csr\_pipe\, openssl\_privatekey\_pipe\, x509\_certificate\_pipe \- the current behavior of check mode is deprecated and will change in community\.crypto 3\.0\.0\. The current behavior is similar to the modules without <code>\_pipe</code>\: if the object needs to be \(re\-\)generated\, only the <code>changed</code> status is set\, but the object is not updated\. From community\.crypto 3\.0\.0 on\, the modules will ignore check mode and always act as if check mode is not active\. This behavior can already achieved now by adding <code>check\_mode\: false</code> to the task\. If you think this breaks your use\-case of this module\, please [create an issue in the community\.crypto repository](https\://github\.com/ansible\-collections/community\.crypto/issues/new/choose) \([https\://github\.com/ansible\-collections/community\.crypto/issues/712](https\://github\.com/ansible\-collections/community\.crypto/issues/712)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/714](https\://github\.com/ansible\-collections/community\.crypto/pull/714)\)\.

<a id="bugfixes-12"></a>
### Bugfixes

* luks\_device \- fixed module a bug that prevented using <code>remove\_keyslot</code> with the value <code>0</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/710](https\://github\.com/ansible\-collections/community\.crypto/pull/710)\)\.
* luks\_device \- fixed module falsely outputting <code>changed\=false</code> when trying to add a new slot with a key that is already present in another slot\. The module now rejects adding keys that are already present in another slot \([https\://github\.com/ansible\-collections/community\.crypto/pull/710](https\://github\.com/ansible\-collections/community\.crypto/pull/710)\)\.
* luks\_device \- fixed testing of LUKS passphrases in when specifying a keyslot for cryptsetup version 2\.0\.3\. The output of this cryptsetup version slightly differs from later versions \([https\://github\.com/ansible\-collections/community\.crypto/pull/710](https\://github\.com/ansible\-collections/community\.crypto/pull/710)\)\.

<a id="new-plugins"></a>
### New Plugins

<a id="filter"></a>
#### Filter

* community\.crypto\.parse\_serial \- Convert a serial number as a colon\-separated list of hex numbers to an integer
* community\.crypto\.to\_serial \- Convert an integer to a colon\-separated list of hex numbers

<a id="v2-17-1"></a>
## v2\.17\.1

<a id="release-summary-19"></a>
### Release Summary

Bugfix release for compatibility with cryptography 42\.0\.0\.

<a id="bugfixes-13"></a>
### Bugfixes

* openssl\_dhparam \- was using an internal function instead of the public API to load DH param files when using the <code>cryptography</code> backend\. The internal function was removed in cryptography 42\.0\.0\. The module now uses the public API\, which has been available since support for DH params was added to cryptography \([https\://github\.com/ansible\-collections/community\.crypto/pull/698](https\://github\.com/ansible\-collections/community\.crypto/pull/698)\)\.
* openssl\_privatekey\_info \- <code>check\_consistency\=true</code> no longer works for RSA keys with cryptography 42\.0\.0\+ \([https\://github\.com/ansible\-collections/community\.crypto/pull/701](https\://github\.com/ansible\-collections/community\.crypto/pull/701)\)\.
* openssl\_privatekey\_info \- <code>check\_consistency\=true</code> now reports a warning if it cannot determine consistency \([https\://github\.com/ansible\-collections/community\.crypto/pull/705](https\://github\.com/ansible\-collections/community\.crypto/pull/705)\)\.

<a id="v2-17-0"></a>
## v2\.17\.0

<a id="release-summary-20"></a>
### Release Summary

Feature release\.

<a id="minor-changes-9"></a>
### Minor Changes

* luks\_device \- add allow discards option \([https\://github\.com/ansible\-collections/community\.crypto/pull/693](https\://github\.com/ansible\-collections/community\.crypto/pull/693)\)\.

<a id="v2-16-2"></a>
## v2\.16\.2

<a id="release-summary-21"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-14"></a>
### Bugfixes

* acme\_\* modules \- directly react on bad return data for account creation/retrieval/updating requests \([https\://github\.com/ansible\-collections/community\.crypto/pull/682](https\://github\.com/ansible\-collections/community\.crypto/pull/682)\)\.
* acme\_\* modules \- fix improved error reporting in case of socket errors\, bad status lines\, and unknown connection errors \([https\://github\.com/ansible\-collections/community\.crypto/pull/684](https\://github\.com/ansible\-collections/community\.crypto/pull/684)\)\.
* acme\_\* modules \- increase number of retries from 5 to 10 to increase stability with unstable ACME endpoints \([https\://github\.com/ansible\-collections/community\.crypto/pull/685](https\://github\.com/ansible\-collections/community\.crypto/pull/685)\)\.
* acme\_\* modules \- make account registration handling more flexible to accept 404 instead of 400 send by DigiCert\'s ACME endpoint when an account does not exist \([https\://github\.com/ansible\-collections/community\.crypto/pull/681](https\://github\.com/ansible\-collections/community\.crypto/pull/681)\)\.

<a id="v2-16-1"></a>
## v2\.16\.1

<a id="release-summary-22"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-15"></a>
### Bugfixes

* acme\_\* modules \- also retry requests in case of socket errors\, bad status lines\, and unknown connection errors\; improve error messages in these cases \([https\://github\.com/ansible\-collections/community\.crypto/issues/680](https\://github\.com/ansible\-collections/community\.crypto/issues/680)\)\.

<a id="v2-16-0"></a>
## v2\.16\.0

<a id="release-summary-23"></a>
### Release Summary

Bugfix release\.

<a id="minor-changes-10"></a>
### Minor Changes

* luks\_devices \- add new options <code>keyslot</code>\, <code>new\_keyslot</code>\, and <code>remove\_keyslot</code> to allow adding/removing keys to/from specific keyslots \([https\://github\.com/ansible\-collections/community\.crypto/pull/664](https\://github\.com/ansible\-collections/community\.crypto/pull/664)\)\.

<a id="bugfixes-16"></a>
### Bugfixes

* openssl\_pkcs12 \- modify autodetect to not detect pyOpenSSL \>\= 23\.3\.0\, which removed PKCS\#12 support \([https\://github\.com/ansible\-collections/community\.crypto/pull/666](https\://github\.com/ansible\-collections/community\.crypto/pull/666)\)\.

<a id="v2-15-1"></a>
## v2\.15\.1

<a id="release-summary-24"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-17"></a>
### Bugfixes

* acme\_\* modules \- correctly handle error documents without <code>type</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/651](https\://github\.com/ansible\-collections/community\.crypto/issues/651)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/652](https\://github\.com/ansible\-collections/community\.crypto/pull/652)\)\.

<a id="v2-15-0"></a>
## v2\.15\.0

<a id="release-summary-25"></a>
### Release Summary

Bugfix and feature release\.

<a id="minor-changes-11"></a>
### Minor Changes

* openssh\_keypair \- fail when comment cannot be updated \([https\://github\.com/ansible\-collections/community\.crypto/pull/646](https\://github\.com/ansible\-collections/community\.crypto/pull/646)\)\.

<a id="deprecated-features-6"></a>
### Deprecated Features

* get\_certificate \- the default <code>false</code> of the <code>asn1\_base64</code> option is deprecated and will change to <code>true</code> in community\.crypto 3\.0\.0 \([https\://github\.com/ansible\-collections/community\.crypto/pull/600](https\://github\.com/ansible\-collections/community\.crypto/pull/600)\)\.

<a id="bugfixes-18"></a>
### Bugfixes

* openssh\_cert\, openssh\_keypair \- the modules ignored return codes of <code>ssh</code> and <code>ssh\-keygen</code> in some cases \([https\://github\.com/ansible\-collections/community\.crypto/issues/645](https\://github\.com/ansible\-collections/community\.crypto/issues/645)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/646](https\://github\.com/ansible\-collections/community\.crypto/pull/646)\)\.
* openssh\_keypair \- fix comment updating for OpenSSH before 6\.5 \([https\://github\.com/ansible\-collections/community\.crypto/pull/646](https\://github\.com/ansible\-collections/community\.crypto/pull/646)\)\.

<a id="new-plugins-1"></a>
### New Plugins

<a id="filter-1"></a>
#### Filter

* community\.crypto\.gpg\_fingerprint \- Retrieve a GPG fingerprint from a GPG public or private key

<a id="lookup"></a>
#### Lookup

* community\.crypto\.gpg\_fingerprint \- Retrieve a GPG fingerprint from a GPG public or private key file

<a id="v2-14-1"></a>
## v2\.14\.1

<a id="release-summary-26"></a>
### Release Summary

Bugfix and maintenance release with updated documentation\.

From this version on\, community\.crypto is using the new [Ansible semantic markup](https\://docs\.ansible\.com/ansible/devel/dev\_guide/developing\_modules\_documenting\.html\#semantic\-markup\-within\-module\-documentation)
in its documentation\. If you look at documentation with the ansible\-doc CLI tool
from ansible\-core before 2\.15\, please note that it does not render the markup
correctly\. You should be still able to read it in most cases\, but you need
ansible\-core 2\.15 or later to see it as it is intended\. Alternatively you can
look at [the devel docsite](https\://docs\.ansible\.com/ansible/devel/collections/community/crypto/)
for the rendered HTML version of the documentation of the latest release\.

<a id="bugfixes-19"></a>
### Bugfixes

* Fix PEM detection/identification to also accept random other lines before the line starting with <code>\-\-\-\-\-BEGIN</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/627](https\://github\.com/ansible\-collections/community\.crypto/issues/627)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/628](https\://github\.com/ansible\-collections/community\.crypto/pull/628)\)\.

<a id="known-issues"></a>
### Known Issues

* Ansible markup will show up in raw form on ansible\-doc text output for ansible\-core before 2\.15\. If you have trouble deciphering the documentation markup\, please upgrade to ansible\-core 2\.15 \(or newer\)\, or read the HTML documentation on [https\://docs\.ansible\.com/ansible/devel/collections/community/crypto/](https\://docs\.ansible\.com/ansible/devel/collections/community/crypto/)\.

<a id="v2-14-0"></a>
## v2\.14\.0

<a id="release-summary-27"></a>
### Release Summary

Feature release\.

<a id="minor-changes-12"></a>
### Minor Changes

* acme\_certificate \- allow to use no challenge by providing <code>no challenge</code> for the <code>challenge</code> option\. This is needed for ACME servers where validation is done without challenges \([https\://github\.com/ansible\-collections/community\.crypto/issues/613](https\://github\.com/ansible\-collections/community\.crypto/issues/613)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/615](https\://github\.com/ansible\-collections/community\.crypto/pull/615)\)\.
* acme\_certificate \- validate and wait for challenges in parallel instead handling them one after another \([https\://github\.com/ansible\-collections/community\.crypto/pull/617](https\://github\.com/ansible\-collections/community\.crypto/pull/617)\)\.
* x509\_certificate\_info \- added support for certificates in DER format when using <code>path</code> parameter \([https\://github\.com/ansible\-collections/community\.crypto/issues/603](https\://github\.com/ansible\-collections/community\.crypto/issues/603)\)\.

<a id="v2-13-1"></a>
## v2\.13\.1

<a id="release-summary-28"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-20"></a>
### Bugfixes

* execution environment definition \- fix installation of <code>python3\-pyOpenSSL</code> package on CentOS and RHEL \([https\://github\.com/ansible\-collections/community\.crypto/pull/606](https\://github\.com/ansible\-collections/community\.crypto/pull/606)\)\.
* execution environment definition \- fix source of <code>python3\-pyOpenSSL</code> package for Rocky Linux 9\+ \([https\://github\.com/ansible\-collections/community\.crypto/pull/606](https\://github\.com/ansible\-collections/community\.crypto/pull/606)\)\.

<a id="v2-13-0"></a>
## v2\.13\.0

<a id="release-summary-29"></a>
### Release Summary

Bugfix and maintenance release\.

<a id="minor-changes-13"></a>
### Minor Changes

* x509\_crl \- the <code>crl\_mode</code> option has been added to replace the existing <code>mode</code> option \([https\://github\.com/ansible\-collections/community\.crypto/issues/596](https\://github\.com/ansible\-collections/community\.crypto/issues/596)\)\.

<a id="deprecated-features-7"></a>
### Deprecated Features

* x509\_crl \- the <code>mode</code> option is deprecated\; use <code>crl\_mode</code> instead\. The <code>mode</code> option will change its meaning in community\.crypto 3\.0\.0\, and will refer to the CRL file\'s mode instead \([https\://github\.com/ansible\-collections/community\.crypto/issues/596](https\://github\.com/ansible\-collections/community\.crypto/issues/596)\)\.

<a id="bugfixes-21"></a>
### Bugfixes

* openssh\_keypair \- always generate a new key pair if the private key does not exist\. Previously\, the module would fail when <code>regenerate\=fail</code> without an existing key\, contradicting the documentation \([https\://github\.com/ansible\-collections/community\.crypto/pull/598](https\://github\.com/ansible\-collections/community\.crypto/pull/598)\)\.
* x509\_crl \- remove problem with ansible\-core 2\.16 due to <code>AnsibleModule</code> is now validating the <code>mode</code> parameter\'s values \([https\://github\.com/ansible\-collections/community\.crypto/issues/596](https\://github\.com/ansible\-collections/community\.crypto/issues/596)\)\.

<a id="v2-12-0"></a>
## v2\.12\.0

<a id="release-summary-30"></a>
### Release Summary

Feature release\.

<a id="minor-changes-14"></a>
### Minor Changes

* get\_certificate \- add <code>asn1\_base64</code> option to control whether the ASN\.1 included in the <code>extensions</code> return value is binary data or Base64 encoded \([https\://github\.com/ansible\-collections/community\.crypto/pull/592](https\://github\.com/ansible\-collections/community\.crypto/pull/592)\)\.

<a id="v2-11-1"></a>
## v2\.11\.1

<a id="release-summary-31"></a>
### Release Summary

Maintenance release with improved documentation\.

<a id="v2-11-0"></a>
## v2\.11\.0

<a id="release-summary-32"></a>
### Release Summary

Feature and bugfix release\.

<a id="minor-changes-15"></a>
### Minor Changes

* get\_certificate \- adds <code>ciphers</code> option for custom cipher selection \([https\://github\.com/ansible\-collections/community\.crypto/pull/571](https\://github\.com/ansible\-collections/community\.crypto/pull/571)\)\.

<a id="bugfixes-22"></a>
### Bugfixes

* action plugin helper \- fix handling of deprecations for ansible\-core 2\.14\.2 \([https\://github\.com/ansible\-collections/community\.crypto/pull/572](https\://github\.com/ansible\-collections/community\.crypto/pull/572)\)\.
* execution environment binary dependencies \(bindep\.txt\) \- fix <code>python3\-pyOpenSSL</code> dependency resolution on RHEL 9\+ / CentOS Stream 9\+ platforms \([https\://github\.com/ansible\-collections/community\.crypto/pull/575](https\://github\.com/ansible\-collections/community\.crypto/pull/575)\)\.
* various plugins \- remove unnecessary imports \([https\://github\.com/ansible\-collections/community\.crypto/pull/569](https\://github\.com/ansible\-collections/community\.crypto/pull/569)\)\.

<a id="v2-10-0"></a>
## v2\.10\.0

<a id="release-summary-33"></a>
### Release Summary

Bugfix and feature release\.

<a id="bugfixes-23"></a>
### Bugfixes

* openssl\_csr\, openssl\_csr\_pipe \- prevent invalid values for <code>crl\_distribution\_points</code> that do not have one of <code>full\_name</code>\, <code>relative\_name</code>\, and <code>crl\_issuer</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/560](https\://github\.com/ansible\-collections/community\.crypto/pull/560)\)\.
* openssl\_publickey\_info \- do not crash with internal error when public key cannot be parsed \([https\://github\.com/ansible\-collections/community\.crypto/pull/551](https\://github\.com/ansible\-collections/community\.crypto/pull/551)\)\.

<a id="new-plugins-2"></a>
### New Plugins

<a id="filter-2"></a>
#### Filter

* community\.crypto\.openssl\_csr\_info \- Retrieve information from OpenSSL Certificate Signing Requests \(CSR\)
* community\.crypto\.openssl\_privatekey\_info \- Retrieve information from OpenSSL private keys
* community\.crypto\.openssl\_publickey\_info \- Retrieve information from OpenSSL public keys in PEM format
* community\.crypto\.split\_pem \- Split PEM file contents into multiple objects
* community\.crypto\.x509\_certificate\_info \- Retrieve information from X\.509 certificates in PEM format
* community\.crypto\.x509\_crl\_info \- Retrieve information from X\.509 CRLs in PEM format

<a id="v2-9-0"></a>
## v2\.9\.0

<a id="release-summary-34"></a>
### Release Summary

Regular feature release\.

<a id="minor-changes-16"></a>
### Minor Changes

* x509\_certificate\_info \- adds <code>issuer\_uri</code> field in return value based on Authority Information Access data \([https\://github\.com/ansible\-collections/community\.crypto/pull/530](https\://github\.com/ansible\-collections/community\.crypto/pull/530)\)\.

<a id="v2-8-1"></a>
## v2\.8\.1

<a id="release-summary-35"></a>
### Release Summary

Maintenance release with improved documentation\.

<a id="v2-8-0"></a>
## v2\.8\.0

<a id="release-summary-36"></a>
### Release Summary

Feature release\.

<a id="minor-changes-17"></a>
### Minor Changes

* acme\_\* modules \- handle more gracefully if CA\'s new nonce call does not return a nonce \([https\://github\.com/ansible\-collections/community\.crypto/pull/525](https\://github\.com/ansible\-collections/community\.crypto/pull/525)\)\.
* acme\_\* modules \- include symbolic HTTP status codes in error and log messages when available \([https\://github\.com/ansible\-collections/community\.crypto/pull/524](https\://github\.com/ansible\-collections/community\.crypto/pull/524)\)\.
* openssl\_pkcs12 \- add option <code>encryption\_level</code> which allows to chose <code>compatibility2022</code> when cryptography \>\= 38\.0\.0 is used to enable a more backwards compatible encryption algorithm\. If cryptography uses OpenSSL 3\.0\.0 or newer\, the default algorithm is not compatible with older software \([https\://github\.com/ansible\-collections/community\.crypto/pull/523](https\://github\.com/ansible\-collections/community\.crypto/pull/523)\)\.

<a id="v2-7-1"></a>
## v2\.7\.1

<a id="release-summary-37"></a>
### Release Summary

Maintenance release\.

<a id="bugfixes-24"></a>
### Bugfixes

* acme\_\* modules \- improve feedback when importing <code>cryptography</code> does not work \([https\://github\.com/ansible\-collections/community\.crypto/issues/518](https\://github\.com/ansible\-collections/community\.crypto/issues/518)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/519](https\://github\.com/ansible\-collections/community\.crypto/pull/519)\)\.

<a id="v2-7-0"></a>
## v2\.7\.0

<a id="release-summary-38"></a>
### Release Summary

Feature release\.

<a id="minor-changes-18"></a>
### Minor Changes

* acme\* modules \- also support the HTTP 503 Service Unavailable and 408 Request Timeout response status for automatic retries \([https\://github\.com/ansible\-collections/community\.crypto/pull/513](https\://github\.com/ansible\-collections/community\.crypto/pull/513)\)\.

<a id="bugfixes-25"></a>
### Bugfixes

* openssl\_privatekey\_pipe \- ensure compatibility with newer versions of ansible\-core \([https\://github\.com/ansible\-collections/community\.crypto/pull/515](https\://github\.com/ansible\-collections/community\.crypto/pull/515)\)\.

<a id="v2-6-0"></a>
## v2\.6\.0

<a id="release-summary-39"></a>
### Release Summary

Feature release\.

<a id="minor-changes-19"></a>
### Minor Changes

* acme\* modules \- support the HTTP 429 Too Many Requests response status \([https\://github\.com/ansible\-collections/community\.crypto/pull/508](https\://github\.com/ansible\-collections/community\.crypto/pull/508)\)\.
* openssh\_keypair \- added <code>pkcs1</code>\, <code>pkcs8</code>\, and <code>ssh</code> to the available choices for the <code>private\_key\_format</code> option \([https\://github\.com/ansible\-collections/community\.crypto/pull/511](https\://github\.com/ansible\-collections/community\.crypto/pull/511)\)\.

<a id="v2-5-0"></a>
## v2\.5\.0

<a id="release-summary-40"></a>
### Release Summary

Maintenance release with improved licensing declaration and documentation fixes\.

<a id="minor-changes-20"></a>
### Minor Changes

* All software licenses are now in the <code>LICENSES/</code> directory of the collection root\. Moreover\, <code>SPDX\-License\-Identifier\:</code> is used to declare the applicable license for every file that is not automatically generated \([https\://github\.com/ansible\-collections/community\.crypto/pull/491](https\://github\.com/ansible\-collections/community\.crypto/pull/491)\)\.

<a id="v2-4-0"></a>
## v2\.4\.0

<a id="release-summary-41"></a>
### Release Summary

Deprecation and bugfix release\. No new features this time\.

<a id="deprecated-features-8"></a>
### Deprecated Features

* Support for Ansible 2\.9 and ansible\-base 2\.10 is deprecated\, and will be removed in the next major release \(community\.crypto 3\.0\.0\)\. Some modules might still work with these versions afterwards\, but we will no longer keep compatibility code that was needed to support them \([https\://github\.com/ansible\-collections/community\.crypto/pull/460](https\://github\.com/ansible\-collections/community\.crypto/pull/460)\)\.

<a id="bugfixes-26"></a>
### Bugfixes

* openssl\_pkcs12 \- when using the pyOpenSSL backend\, do not crash when trying to read non\-existing other certificates \([https\://github\.com/ansible\-collections/community\.crypto/issues/486](https\://github\.com/ansible\-collections/community\.crypto/issues/486)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/487](https\://github\.com/ansible\-collections/community\.crypto/pull/487)\)\.

<a id="v2-3-4"></a>
## v2\.3\.4

<a id="release-summary-42"></a>
### Release Summary

Re\-release of what was intended to be 2\.3\.3\.

A mistake during the release process caused the 2\.3\.3 tag to end up on the
commit for 1\.9\.17\, which caused the release pipeline to re\-publish 1\.9\.17
as 2\.3\.3\.

This release is identical to what should have been 2\.3\.3\, except that the
version number has been bumped to 2\.3\.4 and this changelog entry for 2\.3\.4
has been added\.

<a id="v2-3-3"></a>
## v2\.3\.3

<a id="release-summary-43"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-27"></a>
### Bugfixes

* Include <code>Apache\-2\.0\.txt</code> file for <code>plugins/module\_utils/crypto/\_obj2txt\.py</code> and <code>plugins/module\_utils/crypto/\_objects\_data\.py</code>\.
* openssl\_csr \- the module no longer crashes with \'permitted\_subtrees/excluded\_subtrees must be a non\-empty list or None\' if only one of <code>name\_constraints\_permitted</code> and <code>name\_constraints\_excluded</code> is provided \([https\://github\.com/ansible\-collections/community\.crypto/issues/481](https\://github\.com/ansible\-collections/community\.crypto/issues/481)\)\.
* x509\_crl \- do not crash when signing CRL with Ed25519 or Ed448 keys \([https\://github\.com/ansible\-collections/community\.crypto/issues/473](https\://github\.com/ansible\-collections/community\.crypto/issues/473)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/474](https\://github\.com/ansible\-collections/community\.crypto/pull/474)\)\.

<a id="v2-3-2"></a>
## v2\.3\.2

<a id="release-summary-44"></a>
### Release Summary

Maintenance and bugfix release\.

<a id="bugfixes-28"></a>
### Bugfixes

* Include <code>simplified\_bsd\.txt</code> license file for the ECS module utils\.
* certificate\_complete\_chain \- do not stop execution if an unsupported signature algorithm is encountered\; warn instead \([https\://github\.com/ansible\-collections/community\.crypto/pull/457](https\://github\.com/ansible\-collections/community\.crypto/pull/457)\)\.

<a id="v2-3-1"></a>
## v2\.3\.1

<a id="release-summary-45"></a>
### Release Summary

Maintenance release\.

<a id="bugfixes-29"></a>
### Bugfixes

* Include <code>PSF\-license\.txt</code> file for <code>plugins/module\_utils/\_version\.py</code>\.

<a id="v2-3-0"></a>
## v2\.3\.0

<a id="release-summary-46"></a>
### Release Summary

Feature and bugfix release\.

<a id="minor-changes-21"></a>
### Minor Changes

* Prepare collection for inclusion in an Execution Environment by declaring its dependencies\. Please note that system packages are used for cryptography and PyOpenSSL\, which can be rather limited\. If you need features from newer cryptography versions\, you will have to manually force a newer version to be installed by pip by specifying something like <code>cryptography \>\= 37\.0\.0</code> in your Execution Environment\'s Python dependencies file \([https\://github\.com/ansible\-collections/community\.crypto/pull/440](https\://github\.com/ansible\-collections/community\.crypto/pull/440)\)\.
* Support automatic conversion for Internalionalized Domain Names \(IDNs\)\. When passing general names\, for example Subject Alternative Names to <code>community\.crypto\.openssl\_csr</code>\, these will automatically be converted to IDNA\. Conversion will be done per label to IDNA2008 if possible\, and IDNA2003 if IDNA2008 conversion fails for that label\. Note that IDNA conversion requires [the Python idna library](https\://pypi\.org/project/idna/) to be installed\. Please note that depending on which versions of the cryptography library are used\, it could try to process the converted IDNA another time with the Python <code>idna</code> library and reject IDNA2003 encoded values\. Using a new enough <code>cryptography</code> version avoids this \([https\://github\.com/ansible\-collections/community\.crypto/issues/426](https\://github\.com/ansible\-collections/community\.crypto/issues/426)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/436](https\://github\.com/ansible\-collections/community\.crypto/pull/436)\)\.
* acme\_\* modules \- add parameter <code>request\_timeout</code> to manage HTTP\(S\) request timeout \([https\://github\.com/ansible\-collections/community\.crypto/issues/447](https\://github\.com/ansible\-collections/community\.crypto/issues/447)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/448](https\://github\.com/ansible\-collections/community\.crypto/pull/448)\)\.
* luks\_devices \- added <code>perf\_same\_cpu\_crypt</code>\, <code>perf\_submit\_from\_crypt\_cpus</code>\, <code>perf\_no\_read\_workqueue</code>\, <code>perf\_no\_write\_workqueue</code> for performance tuning when opening LUKS2 containers \([https\://github\.com/ansible\-collections/community\.crypto/issues/427](https\://github\.com/ansible\-collections/community\.crypto/issues/427)\)\.
* luks\_devices \- added <code>persistent</code> option when opening LUKS2 containers \([https\://github\.com/ansible\-collections/community\.crypto/pull/434](https\://github\.com/ansible\-collections/community\.crypto/pull/434)\)\.
* openssl\_csr\_info \- add <code>name\_encoding</code> option to control the encoding \(IDNA\, Unicode\) used to return domain names in general names \([https\://github\.com/ansible\-collections/community\.crypto/pull/436](https\://github\.com/ansible\-collections/community\.crypto/pull/436)\)\.
* openssl\_pkcs12 \- allow to provide the private key as text instead of having to read it from a file\. This allows to store the private key in an encrypted form\, for example in Ansible Vault \([https\://github\.com/ansible\-collections/community\.crypto/pull/452](https\://github\.com/ansible\-collections/community\.crypto/pull/452)\)\.
* x509\_certificate\_info \- add <code>name\_encoding</code> option to control the encoding \(IDNA\, Unicode\) used to return domain names in general names \([https\://github\.com/ansible\-collections/community\.crypto/pull/436](https\://github\.com/ansible\-collections/community\.crypto/pull/436)\)\.
* x509\_crl \- add <code>name\_encoding</code> option to control the encoding \(IDNA\, Unicode\) used to return domain names in general names \([https\://github\.com/ansible\-collections/community\.crypto/pull/436](https\://github\.com/ansible\-collections/community\.crypto/pull/436)\)\.
* x509\_crl\_info \- add <code>name\_encoding</code> option to control the encoding \(IDNA\, Unicode\) used to return domain names in general names \([https\://github\.com/ansible\-collections/community\.crypto/pull/436](https\://github\.com/ansible\-collections/community\.crypto/pull/436)\)\.

<a id="bugfixes-30"></a>
### Bugfixes

* Make collection more robust when PyOpenSSL is used with an incompatible cryptography version \([https\://github\.com/ansible\-collections/community\.crypto/pull/445](https\://github\.com/ansible\-collections/community\.crypto/pull/445)\)\.
* x509\_crl \- fix crash when <code>issuer</code> for a revoked certificate is specified \([https\://github\.com/ansible\-collections/community\.crypto/pull/441](https\://github\.com/ansible\-collections/community\.crypto/pull/441)\)\.

<a id="v2-2-4"></a>
## v2\.2\.4

<a id="release-summary-47"></a>
### Release Summary

Regular maintenance release\.

<a id="bugfixes-31"></a>
### Bugfixes

* openssh\_\* modules \- fix exception handling to report traceback to users for enhanced traceability \([https\://github\.com/ansible\-collections/community\.crypto/pull/417](https\://github\.com/ansible\-collections/community\.crypto/pull/417)\)\.

<a id="v2-2-3"></a>
## v2\.2\.3

<a id="release-summary-48"></a>
### Release Summary

Regular bugfix release\.

<a id="bugfixes-32"></a>
### Bugfixes

* luks\_device \- fix parsing of <code>lsblk</code> output when device name ends with <code>crypt</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/409](https\://github\.com/ansible\-collections/community\.crypto/issues/409)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/410](https\://github\.com/ansible\-collections/community\.crypto/pull/410)\)\.

<a id="v2-2-2"></a>
## v2\.2\.2

<a id="release-summary-49"></a>
### Release Summary

Regular bugfix release\.

In this release\, we extended the test matrix to include Alpine 3\, ArchLinux\, Debian Bullseye\, and CentOS Stream 8\. CentOS 8 was removed from the test matrix\.

<a id="bugfixes-33"></a>
### Bugfixes

* certificate\_complete\_chain \- allow multiple potential intermediate certificates to have the same subject \([https\://github\.com/ansible\-collections/community\.crypto/issues/399](https\://github\.com/ansible\-collections/community\.crypto/issues/399)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/403](https\://github\.com/ansible\-collections/community\.crypto/pull/403)\)\.
* x509\_certificate \- for the <code>ownca</code> provider\, check whether the CA private key actually belongs to the CA certificate \([https\://github\.com/ansible\-collections/community\.crypto/pull/407](https\://github\.com/ansible\-collections/community\.crypto/pull/407)\)\.
* x509\_certificate \- regenerate certificate when the CA\'s public key changes for <code>provider\=ownca</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/407](https\://github\.com/ansible\-collections/community\.crypto/pull/407)\)\.
* x509\_certificate \- regenerate certificate when the CA\'s subject changes for <code>provider\=ownca</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/400](https\://github\.com/ansible\-collections/community\.crypto/issues/400)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/402](https\://github\.com/ansible\-collections/community\.crypto/pull/402)\)\.
* x509\_certificate \- regenerate certificate when the private key changes for <code>provider\=selfsigned</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/407](https\://github\.com/ansible\-collections/community\.crypto/pull/407)\)\.

<a id="v2-2-1"></a>
## v2\.2\.1

<a id="release-summary-50"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-34"></a>
### Bugfixes

* openssh\_cert \- fixed false <code>changed</code> status for <code>host</code> certificates when using <code>full\_idempotence</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/395](https\://github\.com/ansible\-collections/community\.crypto/issues/395)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/396](https\://github\.com/ansible\-collections/community\.crypto/pull/396)\)\.

<a id="v2-2-0"></a>
## v2\.2\.0

<a id="release-summary-51"></a>
### Release Summary

Regular bugfix and feature release\.

<a id="minor-changes-22"></a>
### Minor Changes

* openssh\_cert \- added <code>ignore\_timestamps</code> parameter so it can be used semi\-idempotent with relative timestamps in <code>valid\_to</code>/<code>valid\_from</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/379](https\://github\.com/ansible\-collections/community\.crypto/issues/379)\)\.

<a id="bugfixes-35"></a>
### Bugfixes

* luks\_devices \- set <code>LANG</code> and similar environment variables to avoid translated output\, which can break some of the module\'s functionality like key management \([https\://github\.com/ansible\-collections/community\.crypto/pull/388](https\://github\.com/ansible\-collections/community\.crypto/pull/388)\, [https\://github\.com/ansible\-collections/community\.crypto/issues/385](https\://github\.com/ansible\-collections/community\.crypto/issues/385)\)\.

<a id="v2-1-0"></a>
## v2\.1\.0

<a id="release-summary-52"></a>
### Release Summary

Feature and bugfix release\.

<a id="minor-changes-23"></a>
### Minor Changes

* Adjust error messages that indicate <code>cryptography</code> is not installed from <code>Can\'t</code> to <code>Cannot</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/374](https\://github\.com/ansible\-collections/community\.crypto/pull/374)\)\.

<a id="bugfixes-36"></a>
### Bugfixes

* Various modules and plugins \- use vendored version of <code>distutils\.version</code> instead of the deprecated Python standard library <code>distutils</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/353](https\://github\.com/ansible\-collections/community\.crypto/pull/353)\)\.
* certificate\_complete\_chain \- do not append root twice if the chain already ends with a root certificate \([https\://github\.com/ansible\-collections/community\.crypto/pull/360](https\://github\.com/ansible\-collections/community\.crypto/pull/360)\)\.
* certificate\_complete\_chain \- do not hang when infinite loop is found \([https\://github\.com/ansible\-collections/community\.crypto/issues/355](https\://github\.com/ansible\-collections/community\.crypto/issues/355)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/360](https\://github\.com/ansible\-collections/community\.crypto/pull/360)\)\.

<a id="new-modules-3"></a>
### New Modules

* community\.crypto\.crypto\_info \- Retrieve cryptographic capabilities
* community\.crypto\.openssl\_privatekey\_convert \- Convert OpenSSL private keys

<a id="v2-0-2"></a>
## v2\.0\.2

<a id="release-summary-53"></a>
### Release Summary

Documentation fix release\. No actual code changes\.

<a id="v2-0-1"></a>
## v2\.0\.1

<a id="release-summary-54"></a>
### Release Summary

Bugfix release with extra forward compatibility for newer versions of cryptography\.

<a id="minor-changes-24"></a>
### Minor Changes

* acme\_\* modules \- fix usage of <code>fetch\_url</code> with changes in latest ansible\-core <code>devel</code> branch \([https\://github\.com/ansible\-collections/community\.crypto/pull/339](https\://github\.com/ansible\-collections/community\.crypto/pull/339)\)\.

<a id="bugfixes-37"></a>
### Bugfixes

* acme\_certificate \- avoid passing multiple certificates to <code>cryptography</code>\'s X\.509 certificate loader when <code>fullchain\_dest</code> is used \([https\://github\.com/ansible\-collections/community\.crypto/pull/324](https\://github\.com/ansible\-collections/community\.crypto/pull/324)\)\.
* get\_certificate\, openssl\_csr\_info\, x509\_certificate\_info \- add fallback code for extension parsing that works with cryptography 36\.0\.0 and newer\. This code re\-serializes de\-serialized extensions and thus can return slightly different values if the extension in the original CSR resp\. certificate was not canonicalized correctly\. This code is currently used as a fallback if the existing code stops working\, but we will switch it to be the main code in a future release \([https\://github\.com/ansible\-collections/community\.crypto/pull/331](https\://github\.com/ansible\-collections/community\.crypto/pull/331)\)\.
* luks\_device \- now also runs a built\-in LUKS signature cleaner on <code>state\=absent</code> to make sure that also the secondary LUKS2 header is wiped when older versions of wipefs are used \([https\://github\.com/ansible\-collections/community\.crypto/issues/326](https\://github\.com/ansible\-collections/community\.crypto/issues/326)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/327](https\://github\.com/ansible\-collections/community\.crypto/pull/327)\)\.
* openssl\_pkcs12 \- use new PKCS\#12 deserialization infrastructure from cryptography 36\.0\.0 if available \([https\://github\.com/ansible\-collections/community\.crypto/pull/302](https\://github\.com/ansible\-collections/community\.crypto/pull/302)\)\.

<a id="v2-0-0"></a>
## v2\.0\.0

<a id="release-summary-55"></a>
### Release Summary

A new major release of the <code>community\.crypto</code> collection\. The main changes are removal of the PyOpenSSL backends for almost all modules \(<code>openssl\_pkcs12</code> being the only exception\)\, and removal of the <code>assertonly</code> provider in the <code>x509\_certificate</code> provider\. There are also some other breaking changes which should improve the user interface/experience of this collection long\-term\.

<a id="minor-changes-25"></a>
### Minor Changes

* acme\_certificate \- the <code>subject</code> and <code>issuer</code> fields in in the <code>select\_chain</code> entries are now more strictly validated \([https\://github\.com/ansible\-collections/community\.crypto/pull/316](https\://github\.com/ansible\-collections/community\.crypto/pull/316)\)\.
* openssl\_csr\, openssl\_csr\_pipe \- provide a new <code>subject\_ordered</code> option if the order of the components in the subject is of importance \([https\://github\.com/ansible\-collections/community\.crypto/issues/291](https\://github\.com/ansible\-collections/community\.crypto/issues/291)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/316](https\://github\.com/ansible\-collections/community\.crypto/pull/316)\)\.
* openssl\_csr\, openssl\_csr\_pipe \- there is now stricter validation of the values of the <code>subject</code> option \([https\://github\.com/ansible\-collections/community\.crypto/pull/316](https\://github\.com/ansible\-collections/community\.crypto/pull/316)\)\.
* openssl\_privatekey\_info \- add <code>check\_consistency</code> option to request private key consistency checks to be done \([https\://github\.com/ansible\-collections/community\.crypto/pull/309](https\://github\.com/ansible\-collections/community\.crypto/pull/309)\)\.
* x509\_certificate\, x509\_certificate\_pipe \- add <code>ignore\_timestamps</code> option which allows to enable idempotency for \'not before\' and \'not after\' options \([https\://github\.com/ansible\-collections/community\.crypto/issues/295](https\://github\.com/ansible\-collections/community\.crypto/issues/295)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/317](https\://github\.com/ansible\-collections/community\.crypto/pull/317)\)\.
* x509\_crl \- provide a new <code>issuer\_ordered</code> option if the order of the components in the issuer is of importance \([https\://github\.com/ansible\-collections/community\.crypto/issues/291](https\://github\.com/ansible\-collections/community\.crypto/issues/291)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/316](https\://github\.com/ansible\-collections/community\.crypto/pull/316)\)\.
* x509\_crl \- there is now stricter validation of the values of the <code>issuer</code> option \([https\://github\.com/ansible\-collections/community\.crypto/pull/316](https\://github\.com/ansible\-collections/community\.crypto/pull/316)\)\.

<a id="breaking-changes--porting-guide"></a>
### Breaking Changes / Porting Guide

* Adjust <code>dirName</code> text parsing and to text converting code to conform to [Sections 2 and 3 of RFC 4514](https\://datatracker\.ietf\.org/doc/html/rfc4514\.html)\. This is similar to how [cryptography handles this](https\://cryptography\.io/en/latest/x509/reference/\#cryptography\.x509\.Name\.rfc4514\_string) \([https\://github\.com/ansible\-collections/community\.crypto/pull/274](https\://github\.com/ansible\-collections/community\.crypto/pull/274)\)\.
* acme module utils \- removing compatibility code \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* acme\_\* modules \- removed vendored copy of the Python library <code>ipaddress</code>\. If you are using Python 2\.x\, please make sure to install the library \([https\://github\.com/ansible\-collections/community\.crypto/pull/287](https\://github\.com/ansible\-collections/community\.crypto/pull/287)\)\.
* compatibility module\_utils \- removed vendored copy of the Python library <code>ipaddress</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/287](https\://github\.com/ansible\-collections/community\.crypto/pull/287)\)\.
* crypto module utils \- removing compatibility code \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* get\_certificate\, openssl\_csr\_info\, x509\_certificate\_info \- depending on the <code>cryptography</code> version used\, the modules might not return the ASN\.1 value for an extension as contained in the certificate respectively CSR\, but a re\-encoded version of it\. This should usually be identical to the value contained in the source file\, unless the value was malformed\. For extensions not handled by C\(cryptography\) the value contained in the source file is always returned unaltered \([https\://github\.com/ansible\-collections/community\.crypto/pull/318](https\://github\.com/ansible\-collections/community\.crypto/pull/318)\)\.
* module\_utils \- removed various PyOpenSSL support functions and default backend values that are not needed for the openssl\_pkcs12 module \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_csr\, openssl\_csr\_pipe\, x509\_crl \- the <code>subject</code> respectively <code>issuer</code> fields no longer ignore empty values\, but instead fail when encountering them \([https\://github\.com/ansible\-collections/community\.crypto/pull/316](https\://github\.com/ansible\-collections/community\.crypto/pull/316)\)\.
* openssl\_privatekey\_info \- by default consistency checks are not run\; they need to be explicitly requested by passing <code>check\_consistency\=true</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/309](https\://github\.com/ansible\-collections/community\.crypto/pull/309)\)\.
* x509\_crl \- for idempotency checks\, the <code>issuer</code> order is ignored\. If order is important\, use the new <code>issuer\_ordered</code> option \([https\://github\.com/ansible\-collections/community\.crypto/pull/316](https\://github\.com/ansible\-collections/community\.crypto/pull/316)\)\.

<a id="deprecated-features-9"></a>
### Deprecated Features

* acme\_\* modules \- ACME version 1 is now deprecated and support for it will be removed in community\.crypto 2\.0\.0 \([https\://github\.com/ansible\-collections/community\.crypto/pull/288](https\://github\.com/ansible\-collections/community\.crypto/pull/288)\)\.

<a id="removed-features-previously-deprecated"></a>
### Removed Features \(previously deprecated\)

* acme\_\* modules \- the <code>acme\_directory</code> option is now required \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* acme\_\* modules \- the <code>acme\_version</code> option is now required \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* acme\_account\_facts \- the deprecated redirect has been removed\. Use community\.crypto\.acme\_account\_info instead \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* acme\_account\_info \- <code>retrieve\_orders\=url\_list</code> no longer returns the return value <code>orders</code>\. Use the <code>order\_uris</code> return value instead \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* crypto\.info module utils \- the deprecated redirect has been removed\. Use <code>crypto\.pem</code> instead \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* get\_certificate \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_certificate \- the deprecated redirect has been removed\. Use community\.crypto\.x509\_certificate instead \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* openssl\_certificate\_info \- the deprecated redirect has been removed\. Use community\.crypto\.x509\_certificate\_info instead \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* openssl\_csr \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_csr and openssl\_csr\_pipe \- <code>version</code> now only accepts the \(default\) value 1 \([https\://github\.com/ansible\-collections/community\.crypto/pull/290](https\://github\.com/ansible\-collections/community\.crypto/pull/290)\)\.
* openssl\_csr\_info \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_csr\_pipe \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_privatekey \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_privatekey\_info \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_privatekey\_pipe \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_publickey \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_publickey\_info \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_signature \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* openssl\_signature\_info \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* x509\_certificate \- remove <code>assertonly</code> provider \([https\://github\.com/ansible\-collections/community\.crypto/pull/289](https\://github\.com/ansible\-collections/community\.crypto/pull/289)\)\.
* x509\_certificate \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* x509\_certificate\_info \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.
* x509\_certificate\_pipe \- removed the <code>pyopenssl</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/273](https\://github\.com/ansible\-collections/community\.crypto/pull/273)\)\.

<a id="bugfixes-38"></a>
### Bugfixes

* cryptography backend \- improve Unicode handling for Python 2 \([https\://github\.com/ansible\-collections/community\.crypto/pull/313](https\://github\.com/ansible\-collections/community\.crypto/pull/313)\)\.
* get\_certificate \- fix compatibility with the cryptography 35\.0\.0 release \([https\://github\.com/ansible\-collections/community\.crypto/pull/294](https\://github\.com/ansible\-collections/community\.crypto/pull/294)\)\.
* openssl\_csr\_info \- fix compatibility with the cryptography 35\.0\.0 release \([https\://github\.com/ansible\-collections/community\.crypto/pull/294](https\://github\.com/ansible\-collections/community\.crypto/pull/294)\)\.
* openssl\_pkcs12 \- fix compatibility with the cryptography 35\.0\.0 release \([https\://github\.com/ansible\-collections/community\.crypto/pull/296](https\://github\.com/ansible\-collections/community\.crypto/pull/296)\)\.
* x509\_certificate\_info \- fix compatibility with the cryptography 35\.0\.0 release \([https\://github\.com/ansible\-collections/community\.crypto/pull/294](https\://github\.com/ansible\-collections/community\.crypto/pull/294)\)\.

<a id="v1-9-4"></a>
## v1\.9\.4

<a id="release-summary-56"></a>
### Release Summary

Regular bugfix release\.

<a id="bugfixes-39"></a>
### Bugfixes

* acme\_\* modules \- fix commands composed for OpenSSL backend to retrieve information on CSRs and certificates from stdin to use <code>/dev/stdin</code> instead of <code>\-</code>\. This is needed for OpenSSL 1\.0\.1 and 1\.0\.2\, apparently \([https\://github\.com/ansible\-collections/community\.crypto/pull/279](https\://github\.com/ansible\-collections/community\.crypto/pull/279)\)\.
* acme\_challenge\_cert\_helper \- only return exception when cryptography is not installed\, not when a too old version of it is installed\. This prevents Ansible\'s callback to crash \([https\://github\.com/ansible\-collections/community\.crypto/pull/281](https\://github\.com/ansible\-collections/community\.crypto/pull/281)\)\.

<a id="v1-9-3"></a>
## v1\.9\.3

<a id="release-summary-57"></a>
### Release Summary

Regular bugfix release\.

<a id="bugfixes-40"></a>
### Bugfixes

* openssl\_csr and openssl\_csr\_pipe \- make sure that Unicode strings are used to compare strings with the cryptography backend\. This fixes idempotency problems with non\-ASCII letters on Python 2 \([https\://github\.com/ansible\-collections/community\.crypto/issues/270](https\://github\.com/ansible\-collections/community\.crypto/issues/270)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/271](https\://github\.com/ansible\-collections/community\.crypto/pull/271)\)\.

<a id="v1-9-2"></a>
## v1\.9\.2

<a id="release-summary-58"></a>
### Release Summary

Bugfix release to fix the changelog\. No other change compared to 1\.9\.0\.

<a id="v1-9-1"></a>
## v1\.9\.1

<a id="release-summary-59"></a>
### Release Summary

Accidental 1\.9\.1 release\. Identical to 1\.9\.0\.

<a id="v1-9-0"></a>
## v1\.9\.0

<a id="release-summary-60"></a>
### Release Summary

Regular feature release\.

<a id="minor-changes-26"></a>
### Minor Changes

* get\_certificate \- added <code>starttls</code> option to retrieve certificates from servers which require clients to request an encrypted connection \([https\://github\.com/ansible\-collections/community\.crypto/pull/264](https\://github\.com/ansible\-collections/community\.crypto/pull/264)\)\.
* openssh\_keypair \- added <code>diff</code> support \([https\://github\.com/ansible\-collections/community\.crypto/pull/260](https\://github\.com/ansible\-collections/community\.crypto/pull/260)\)\.

<a id="bugfixes-41"></a>
### Bugfixes

* keypair\_backend module utils \- simplify code to pass sanity tests \([https\://github\.com/ansible\-collections/community\.crypto/pull/263](https\://github\.com/ansible\-collections/community\.crypto/pull/263)\)\.
* openssh\_keypair \- fixed <code>cryptography</code> backend to preserve original file permissions when regenerating a keypair requires existing files to be overwritten \([https\://github\.com/ansible\-collections/community\.crypto/pull/260](https\://github\.com/ansible\-collections/community\.crypto/pull/260)\)\.
* openssh\_keypair \- fixed error handling to restore original keypair if regeneration fails \([https\://github\.com/ansible\-collections/community\.crypto/pull/260](https\://github\.com/ansible\-collections/community\.crypto/pull/260)\)\.
* x509\_crl \- restore inherited function signature to pass sanity tests \([https\://github\.com/ansible\-collections/community\.crypto/pull/263](https\://github\.com/ansible\-collections/community\.crypto/pull/263)\)\.

<a id="v1-8-0"></a>
## v1\.8\.0

<a id="release-summary-61"></a>
### Release Summary

Regular bugfix and feature release\.

<a id="minor-changes-27"></a>
### Minor Changes

* Avoid internal ansible\-core module\_utils in favor of equivalent public API available since at least Ansible 2\.9 \([https\://github\.com/ansible\-collections/community\.crypto/pull/253](https\://github\.com/ansible\-collections/community\.crypto/pull/253)\)\.
* openssh certificate module utils \- new module\_utils for parsing OpenSSH certificates \([https\://github\.com/ansible\-collections/community\.crypto/pull/246](https\://github\.com/ansible\-collections/community\.crypto/pull/246)\)\.
* openssh\_cert \- added <code>regenerate</code> option to validate additional certificate parameters which trigger regeneration of an existing certificate \([https\://github\.com/ansible\-collections/community\.crypto/pull/256](https\://github\.com/ansible\-collections/community\.crypto/pull/256)\)\.
* openssh\_cert \- adding <code>diff</code> support \([https\://github\.com/ansible\-collections/community\.crypto/pull/255](https\://github\.com/ansible\-collections/community\.crypto/pull/255)\)\.

<a id="bugfixes-42"></a>
### Bugfixes

* openssh\_cert \- fixed certificate generation to restore original certificate if an error is encountered \([https\://github\.com/ansible\-collections/community\.crypto/pull/255](https\://github\.com/ansible\-collections/community\.crypto/pull/255)\)\.
* openssh\_keypair \- fixed a bug that prevented custom file attributes being applied to public keys \([https\://github\.com/ansible\-collections/community\.crypto/pull/257](https\://github\.com/ansible\-collections/community\.crypto/pull/257)\)\.

<a id="v1-7-1"></a>
## v1\.7\.1

<a id="release-summary-62"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-43"></a>
### Bugfixes

* openssl\_pkcs12 \- fix crash when loading passphrase\-protected PKCS\#12 files with <code>cryptography</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/issues/247](https\://github\.com/ansible\-collections/community\.crypto/issues/247)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/248](https\://github\.com/ansible\-collections/community\.crypto/pull/248)\)\.

<a id="v1-7-0"></a>
## v1\.7\.0

<a id="release-summary-63"></a>
### Release Summary

Regular feature and bugfix release\.

<a id="minor-changes-28"></a>
### Minor Changes

* cryptography\_openssh module utils \- new module\_utils for managing asymmetric keypairs and OpenSSH formatted/encoded asymmetric keypairs \([https\://github\.com/ansible\-collections/community\.crypto/pull/213](https\://github\.com/ansible\-collections/community\.crypto/pull/213)\)\.
* openssh\_keypair \- added <code>backend</code> parameter for selecting between the cryptography library or the OpenSSH binary for the execution of actions performed by <code>openssh\_keypair</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/236](https\://github\.com/ansible\-collections/community\.crypto/pull/236)\)\.
* openssh\_keypair \- added <code>passphrase</code> parameter for encrypting/decrypting OpenSSH private keys \([https\://github\.com/ansible\-collections/community\.crypto/pull/225](https\://github\.com/ansible\-collections/community\.crypto/pull/225)\)\.
* openssl\_csr \- add diff mode \([https\://github\.com/ansible\-collections/community\.crypto/issues/38](https\://github\.com/ansible\-collections/community\.crypto/issues/38)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/150](https\://github\.com/ansible\-collections/community\.crypto/pull/150)\)\.
* openssl\_csr\_info \- now returns <code>public\_key\_type</code> and <code>public\_key\_data</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/233](https\://github\.com/ansible\-collections/community\.crypto/pull/233)\)\.
* openssl\_csr\_info \- refactor module to allow code reuse for diff mode \([https\://github\.com/ansible\-collections/community\.crypto/pull/204](https\://github\.com/ansible\-collections/community\.crypto/pull/204)\)\.
* openssl\_csr\_pipe \- add diff mode \([https\://github\.com/ansible\-collections/community\.crypto/issues/38](https\://github\.com/ansible\-collections/community\.crypto/issues/38)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/150](https\://github\.com/ansible\-collections/community\.crypto/pull/150)\)\.
* openssl\_pkcs12 \- added option <code>select\_crypto\_backend</code> and a <code>cryptography</code> backend\. This requires cryptography 3\.0 or newer\, and does not support the <code>iter\_size</code> and <code>maciter\_size</code> options \([https\://github\.com/ansible\-collections/community\.crypto/pull/234](https\://github\.com/ansible\-collections/community\.crypto/pull/234)\)\.
* openssl\_privatekey \- add diff mode \([https\://github\.com/ansible\-collections/community\.crypto/issues/38](https\://github\.com/ansible\-collections/community\.crypto/issues/38)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/150](https\://github\.com/ansible\-collections/community\.crypto/pull/150)\)\.
* openssl\_privatekey\_info \- refactor module to allow code reuse for diff mode \([https\://github\.com/ansible\-collections/community\.crypto/pull/205](https\://github\.com/ansible\-collections/community\.crypto/pull/205)\)\.
* openssl\_privatekey\_pipe \- add diff mode \([https\://github\.com/ansible\-collections/community\.crypto/issues/38](https\://github\.com/ansible\-collections/community\.crypto/issues/38)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/150](https\://github\.com/ansible\-collections/community\.crypto/pull/150)\)\.
* openssl\_publickey \- add diff mode \([https\://github\.com/ansible\-collections/community\.crypto/issues/38](https\://github\.com/ansible\-collections/community\.crypto/issues/38)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/150](https\://github\.com/ansible\-collections/community\.crypto/pull/150)\)\.
* x509\_certificate \- add diff mode \([https\://github\.com/ansible\-collections/community\.crypto/issues/38](https\://github\.com/ansible\-collections/community\.crypto/issues/38)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/150](https\://github\.com/ansible\-collections/community\.crypto/pull/150)\)\.
* x509\_certificate\_info \- now returns <code>public\_key\_type</code> and <code>public\_key\_data</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/233](https\://github\.com/ansible\-collections/community\.crypto/pull/233)\)\.
* x509\_certificate\_info \- refactor module to allow code reuse for diff mode \([https\://github\.com/ansible\-collections/community\.crypto/pull/206](https\://github\.com/ansible\-collections/community\.crypto/pull/206)\)\.
* x509\_certificate\_pipe \- add diff mode \([https\://github\.com/ansible\-collections/community\.crypto/issues/38](https\://github\.com/ansible\-collections/community\.crypto/issues/38)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/150](https\://github\.com/ansible\-collections/community\.crypto/pull/150)\)\.
* x509\_crl \- add diff mode \([https\://github\.com/ansible\-collections/community\.crypto/issues/38](https\://github\.com/ansible\-collections/community\.crypto/issues/38)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/150](https\://github\.com/ansible\-collections/community\.crypto/pull/150)\)\.
* x509\_crl\_info \- add <code>list\_revoked\_certificates</code> option to avoid enumerating all revoked certificates \([https\://github\.com/ansible\-collections/community\.crypto/pull/232](https\://github\.com/ansible\-collections/community\.crypto/pull/232)\)\.
* x509\_crl\_info \- refactor module to allow code reuse for diff mode \([https\://github\.com/ansible\-collections/community\.crypto/pull/203](https\://github\.com/ansible\-collections/community\.crypto/pull/203)\)\.

<a id="bugfixes-44"></a>
### Bugfixes

* openssh\_keypair \- fix <code>check\_mode</code> to populate return values for existing keypairs \([https\://github\.com/ansible\-collections/community\.crypto/issues/113](https\://github\.com/ansible\-collections/community\.crypto/issues/113)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/230](https\://github\.com/ansible\-collections/community\.crypto/pull/230)\)\.
* various modules \- prevent crashes when modules try to set attributes on not yet existing files in check mode\. This will be fixed in ansible\-core 2\.12\, but it is not backported to every Ansible version we support \([https\://github\.com/ansible\-collections/community\.crypto/issue/242](https\://github\.com/ansible\-collections/community\.crypto/issue/242)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/243](https\://github\.com/ansible\-collections/community\.crypto/pull/243)\)\.
* x509\_certificate \- fix crash when <code>assertonly</code> provider is used and some error conditions should be reported \([https\://github\.com/ansible\-collections/community\.crypto/issues/240](https\://github\.com/ansible\-collections/community\.crypto/issues/240)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/241](https\://github\.com/ansible\-collections/community\.crypto/pull/241)\)\.

<a id="new-modules-4"></a>
### New Modules

* community\.crypto\.openssl\_publickey\_info \- Provide information for OpenSSL public keys

<a id="v1-6-2"></a>
## v1\.6\.2

<a id="release-summary-64"></a>
### Release Summary

Bugfix release\. Fixes compatibility issue of ACME modules with step\-ca\.

<a id="bugfixes-45"></a>
### Bugfixes

* acme\_\* modules \- avoid crashing for ACME servers where the <code>meta</code> directory key is not present \([https\://github\.com/ansible\-collections/community\.crypto/issues/220](https\://github\.com/ansible\-collections/community\.crypto/issues/220)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/221](https\://github\.com/ansible\-collections/community\.crypto/pull/221)\)\.

<a id="v1-6-1"></a>
## v1\.6\.1

<a id="release-summary-65"></a>
### Release Summary

Bugfix release\.

<a id="bugfixes-46"></a>
### Bugfixes

* acme\_\* modules \- fix wrong usages of <code>ACMEProtocolException</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/216](https\://github\.com/ansible\-collections/community\.crypto/pull/216)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/217](https\://github\.com/ansible\-collections/community\.crypto/pull/217)\)\.

<a id="v1-6-0"></a>
## v1\.6\.0

<a id="release-summary-66"></a>
### Release Summary

Fixes compatibility issues with the latest ansible\-core 2\.11 beta\, and contains a lot of internal refactoring for the ACME modules and support for private key passphrases for them\.

<a id="minor-changes-29"></a>
### Minor Changes

* acme module\_utils \- the <code>acme</code> module\_utils has been split up into several Python modules \([https\://github\.com/ansible\-collections/community\.crypto/pull/184](https\://github\.com/ansible\-collections/community\.crypto/pull/184)\)\.
* acme\_\* modules \- codebase refactor which should not be visible to end\-users \([https\://github\.com/ansible\-collections/community\.crypto/pull/184](https\://github\.com/ansible\-collections/community\.crypto/pull/184)\)\.
* acme\_\* modules \- support account key passphrases for <code>cryptography</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/issues/197](https\://github\.com/ansible\-collections/community\.crypto/issues/197)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/207](https\://github\.com/ansible\-collections/community\.crypto/pull/207)\)\.
* acme\_certificate\_revoke \- support revoking by private keys that are passphrase protected for <code>cryptography</code> backend \([https\://github\.com/ansible\-collections/community\.crypto/pull/207](https\://github\.com/ansible\-collections/community\.crypto/pull/207)\)\.
* acme\_challenge\_cert\_helper \- add <code>private\_key\_passphrase</code> parameter \([https\://github\.com/ansible\-collections/community\.crypto/pull/207](https\://github\.com/ansible\-collections/community\.crypto/pull/207)\)\.

<a id="deprecated-features-10"></a>
### Deprecated Features

* acme module\_utils \- the <code>acme</code> module\_utils \(<code>ansible\_collections\.community\.crypto\.plugins\.module\_utils\.acme</code>\) is deprecated and will be removed in community\.crypto 2\.0\.0\. Use the new Python modules in the <code>acme</code> package instead \(<code>ansible\_collections\.community\.crypto\.plugins\.module\_utils\.acme\.xxx</code>\) \([https\://github\.com/ansible\-collections/community\.crypto/pull/184](https\://github\.com/ansible\-collections/community\.crypto/pull/184)\)\.

<a id="bugfixes-47"></a>
### Bugfixes

* action\_module plugin helper \- make compatible with latest changes in ansible\-core 2\.11\.0b3 \([https\://github\.com/ansible\-collections/community\.crypto/pull/202](https\://github\.com/ansible\-collections/community\.crypto/pull/202)\)\.
* openssl\_privatekey\_pipe \- make compatible with latest changes in ansible\-core 2\.11\.0b3 \([https\://github\.com/ansible\-collections/community\.crypto/pull/202](https\://github\.com/ansible\-collections/community\.crypto/pull/202)\)\.

<a id="v1-5-0"></a>
## v1\.5\.0

<a id="release-summary-67"></a>
### Release Summary

Regular feature and bugfix release\. Deprecates a return value\.

<a id="minor-changes-30"></a>
### Minor Changes

* acme\_account\_info \- when <code>retrieve\_orders</code> is not <code>ignore</code> and the ACME server allows to query orders\, the new return value <code>order\_uris</code> is always populated with a list of URIs \([https\://github\.com/ansible\-collections/community\.crypto/pull/178](https\://github\.com/ansible\-collections/community\.crypto/pull/178)\)\.
* luks\_device \- allow to specify sector size for LUKS2 containers with new <code>sector\_size</code> parameter \([https\://github\.com/ansible\-collections/community\.crypto/pull/193](https\://github\.com/ansible\-collections/community\.crypto/pull/193)\)\.

<a id="deprecated-features-11"></a>
### Deprecated Features

* acme\_account\_info \- when <code>retrieve\_orders\=url\_list</code>\, <code>orders</code> will no longer be returned in community\.crypto 2\.0\.0\. Use <code>order\_uris</code> instead \([https\://github\.com/ansible\-collections/community\.crypto/pull/178](https\://github\.com/ansible\-collections/community\.crypto/pull/178)\)\.

<a id="bugfixes-48"></a>
### Bugfixes

* openssl\_csr \- no longer fails when comparing CSR without basic constraint when <code>basic\_constraints</code> is specified \([https\://github\.com/ansible\-collections/community\.crypto/issues/179](https\://github\.com/ansible\-collections/community\.crypto/issues/179)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/180](https\://github\.com/ansible\-collections/community\.crypto/pull/180)\)\.

<a id="v1-4-0"></a>
## v1\.4\.0

<a id="release-summary-68"></a>
### Release Summary

Release with several new features and bugfixes\.

<a id="minor-changes-31"></a>
### Minor Changes

* The ACME module\_utils has been relicensed back from the Simplified BSD License \([https\://opensource\.org/licenses/BSD\-2\-Clause](https\://opensource\.org/licenses/BSD\-2\-Clause)\) to the GPLv3\+ \(same license used by most other code in this collection\)\. This undoes a licensing change when the original GPLv3\+ licensed code was moved to module\_utils in [https\://github\.com/ansible/ansible/pull/40697](https\://github\.com/ansible/ansible/pull/40697) \([https\://github\.com/ansible\-collections/community\.crypto/pull/165](https\://github\.com/ansible\-collections/community\.crypto/pull/165)\)\.
* The <code>crypto/identify\.py</code> module\_utils has been renamed to <code>crypto/pem\.py</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/166](https\://github\.com/ansible\-collections/community\.crypto/pull/166)\)\.
* luks\_device \- <code>new\_keyfile</code>\, <code>new\_passphrase</code>\, <code>remove\_keyfile</code> and <code>remove\_passphrase</code> are now idempotent \([https\://github\.com/ansible\-collections/community\.crypto/issues/19](https\://github\.com/ansible\-collections/community\.crypto/issues/19)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/168](https\://github\.com/ansible\-collections/community\.crypto/pull/168)\)\.
* luks\_device \- allow to configure PBKDF \([https\://github\.com/ansible\-collections/community\.crypto/pull/163](https\://github\.com/ansible\-collections/community\.crypto/pull/163)\)\.
* openssl\_csr\, openssl\_csr\_pipe \- allow to specify CRL distribution endpoints with <code>crl\_distribution\_points</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/147](https\://github\.com/ansible\-collections/community\.crypto/issues/147)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/167](https\://github\.com/ansible\-collections/community\.crypto/pull/167)\)\.
* openssl\_pkcs12 \- allow to specify certificate bundles in <code>other\_certificates</code> by using new option <code>other\_certificates\_parse\_all</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/149](https\://github\.com/ansible\-collections/community\.crypto/issues/149)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/166](https\://github\.com/ansible\-collections/community\.crypto/pull/166)\)\.

<a id="bugfixes-49"></a>
### Bugfixes

* acme\_certificate \- error when requested challenge type is not found for non\-valid challenges\, instead of hanging on step 2 \([https\://github\.com/ansible\-collections/community\.crypto/issues/171](https\://github\.com/ansible\-collections/community\.crypto/issues/171)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/173](https\://github\.com/ansible\-collections/community\.crypto/pull/173)\)\.

<a id="v1-3-0"></a>
## v1\.3\.0

<a id="release-summary-69"></a>
### Release Summary

Contains new modules <code>openssl\_privatekey\_pipe</code>\, <code>openssl\_csr\_pipe</code> and <code>x509\_certificate\_pipe</code> which allow to create or update private keys\, CSRs and X\.509 certificates without having to write them to disk\.

<a id="minor-changes-32"></a>
### Minor Changes

* openssh\_cert \- add module parameter <code>use\_agent</code> to enable using signing keys stored in ssh\-agent \([https\://github\.com/ansible\-collections/community\.crypto/issues/116](https\://github\.com/ansible\-collections/community\.crypto/issues/116)\)\.
* openssl\_csr \- refactor module to allow code reuse by openssl\_csr\_pipe \([https\://github\.com/ansible\-collections/community\.crypto/pull/123](https\://github\.com/ansible\-collections/community\.crypto/pull/123)\)\.
* openssl\_privatekey \- refactor module to allow code reuse by openssl\_privatekey\_pipe \([https\://github\.com/ansible\-collections/community\.crypto/pull/119](https\://github\.com/ansible\-collections/community\.crypto/pull/119)\)\.
* openssl\_privatekey \- the elliptic curve <code>secp192r1</code> now triggers a security warning\. Elliptic curves of at least 224 bits should be used for new keys\; see [here](https\://cryptography\.io/en/latest/hazmat/primitives/asymmetric/ec\.html\#elliptic\-curves) \([https\://github\.com/ansible\-collections/community\.crypto/pull/132](https\://github\.com/ansible\-collections/community\.crypto/pull/132)\)\.
* x509\_certificate \- for the <code>selfsigned</code> provider\, a CSR is not required anymore\. If no CSR is provided\, the module behaves as if a minimal CSR which only contains the public key has been provided \([https\://github\.com/ansible\-collections/community\.crypto/issues/32](https\://github\.com/ansible\-collections/community\.crypto/issues/32)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/129](https\://github\.com/ansible\-collections/community\.crypto/pull/129)\)\.
* x509\_certificate \- refactor module to allow code reuse by x509\_certificate\_pipe \([https\://github\.com/ansible\-collections/community\.crypto/pull/135](https\://github\.com/ansible\-collections/community\.crypto/pull/135)\)\.

<a id="bugfixes-50"></a>
### Bugfixes

* openssl\_pkcs12 \- report the correct state when <code>action</code> is <code>parse</code> \([https\://github\.com/ansible\-collections/community\.crypto/issues/143](https\://github\.com/ansible\-collections/community\.crypto/issues/143)\)\.
* support code \- improve handling of certificate and certificate signing request \(CSR\) loading with the <code>cryptography</code> backend when errors occur \([https\://github\.com/ansible\-collections/community\.crypto/issues/138](https\://github\.com/ansible\-collections/community\.crypto/issues/138)\, [https\://github\.com/ansible\-collections/community\.crypto/pull/139](https\://github\.com/ansible\-collections/community\.crypto/pull/139)\)\.
* x509\_certificate \- fix <code>entrust</code> provider\, which was broken since community\.crypto 0\.1\.0 due to a feature added before the collection move \([https\://github\.com/ansible\-collections/community\.crypto/pull/135](https\://github\.com/ansible\-collections/community\.crypto/pull/135)\)\.

<a id="new-modules-5"></a>
### New Modules

* community\.crypto\.openssl\_csr\_pipe \- Generate OpenSSL Certificate Signing Request \(CSR\)
* community\.crypto\.openssl\_privatekey\_pipe \- Generate OpenSSL private keys without disk access
* community\.crypto\.x509\_certificate\_pipe \- Generate and/or check OpenSSL certificates

<a id="v1-2-0"></a>
## v1\.2\.0

<a id="release-summary-70"></a>
### Release Summary

Please note that this release fixes a security issue \(CVE\-2020\-25646\)\.

<a id="minor-changes-33"></a>
### Minor Changes

* acme\_certificate \- allow to pass CSR file as content with new option <code>csr\_content</code> \([https\://github\.com/ansible\-collections/community\.crypto/pull/115](https\://github\.com/ansible\-collections/community\.crypto/pull/115)\)\.
* x509\_certificate\_info \- add <code>fingerprints</code> return value which returns certificate fingerprints \([https\://github\.com/ansible\-collections/community\.crypto/pull/121](https\://github\.com/ansible\-collections/community\.crypto/pull/121)\)\.

<a id="security-fixes"></a>
### Security Fixes

* openssl\_csr \- the option <code>privatekey\_content</code> was not marked as <code>no\_log</code>\, resulting in it being dumped into the system log by default\, and returned in the registered results in the <code>invocation</code> field \(CVE\-2020\-25646\, [https\://github\.com/ansible\-collections/community\.crypto/pull/125](https\://github\.com/ansible\-collections/community\.crypto/pull/125)\)\.
* openssl\_privatekey\_info \- the option <code>content</code> was not marked as <code>no\_log</code>\, resulting in it being dumped into the system log by default\, and returned in the registered results in the <code>invocation</code> field \(CVE\-2020\-25646\, [https\://github\.com/ansible\-collections/community\.crypto/pull/125](https\://github\.com/ansible\-collections/community\.crypto/pull/125)\)\.
* openssl\_publickey \- the option <code>privatekey\_content</code> was not marked as <code>no\_log</code>\, resulting in it being dumped into the system log by default\, and returned in the registered results in the <code>invocation</code> field \(CVE\-2020\-25646\, [https\://github\.com/ansible\-collections/community\.crypto/pull/125](https\://github\.com/ansible\-collections/community\.crypto/pull/125)\)\.
* openssl\_signature \- the option <code>privatekey\_content</code> was not marked as <code>no\_log</code>\, resulting in it being dumped into the system log by default\, and returned in the registered results in the <code>invocation</code> field \(CVE\-2020\-25646\, [https\://github\.com/ansible\-collections/community\.crypto/pull/125](https\://github\.com/ansible\-collections/community\.crypto/pull/125)\)\.
* x509\_certificate \- the options <code>privatekey\_content</code> and <code>ownca\_privatekey\_content</code> were not marked as <code>no\_log</code>\, resulting in it being dumped into the system log by default\, and returned in the registered results in the <code>invocation</code> field \(CVE\-2020\-25646\, [https\://github\.com/ansible\-collections/community\.crypto/pull/125](https\://github\.com/ansible\-collections/community\.crypto/pull/125)\)\.
* x509\_crl \- the option <code>privatekey\_content</code> was not marked as <code>no\_log</code>\, resulting in it being dumped into the system log by default\, and returned in the registered results in the <code>invocation</code> field \(CVE\-2020\-25646\, [https\://github\.com/ansible\-collections/community\.crypto/pull/125](https\://github\.com/ansible\-collections/community\.crypto/pull/125)\)\.

<a id="bugfixes-51"></a>
### Bugfixes

* openssl\_pkcs12 \- do not crash when reading PKCS\#12 file which has no private key and/or no main certificate \([https\://github\.com/ansible\-collections/community\.crypto/issues/103](https\://github\.com/ansible\-collections/community\.crypto/issues/103)\)\.

<a id="v1-1-1"></a>
## v1\.1\.1

<a id="release-summary-71"></a>
### Release Summary

Bugfixes for Ansible 2\.10\.0\.

<a id="bugfixes-52"></a>
### Bugfixes

* meta/runtime\.yml \- convert Ansible version numbers for old names of modules to collection version numbers \([https\://github\.com/ansible\-collections/community\.crypto/pull/108](https\://github\.com/ansible\-collections/community\.crypto/pull/108)\)\.
* openssl\_csr \- improve handling of IDNA errors \([https\://github\.com/ansible\-collections/community\.crypto/issues/105](https\://github\.com/ansible\-collections/community\.crypto/issues/105)\)\.

<a id="v1-1-0"></a>
## v1\.1\.0

<a id="release-summary-72"></a>
### Release Summary

Release for Ansible 2\.10\.0\.

<a id="minor-changes-34"></a>
### Minor Changes

* acme\_account \- add <code>external\_account\_binding</code> option to allow creation of ACME accounts with External Account Binding \([https\://github\.com/ansible\-collections/community\.crypto/issues/89](https\://github\.com/ansible\-collections/community\.crypto/issues/89)\)\.
* acme\_certificate \- allow new selector <code>test\_certificates\: first</code> for <code>select\_chain</code> parameter \([https\://github\.com/ansible\-collections/community\.crypto/pull/102](https\://github\.com/ansible\-collections/community\.crypto/pull/102)\)\.
* cryptography backends \- support arbitrary dotted OIDs \([https\://github\.com/ansible\-collections/community\.crypto/issues/39](https\://github\.com/ansible\-collections/community\.crypto/issues/39)\)\.
* get\_certificate \- add support for SNI \([https\://github\.com/ansible\-collections/community\.crypto/issues/69](https\://github\.com/ansible\-collections/community\.crypto/issues/69)\)\.
* luks\_device \- add support for encryption options on container creation \([https\://github\.com/ansible\-collections/community\.crypto/pull/97](https\://github\.com/ansible\-collections/community\.crypto/pull/97)\)\.
* openssh\_cert \- add support for PKCS\#11 tokens \([https\://github\.com/ansible\-collections/community\.crypto/pull/95](https\://github\.com/ansible\-collections/community\.crypto/pull/95)\)\.
* openssl\_certificate \- the PyOpenSSL backend now uses 160 bits of randomness for serial numbers\, instead of a random number between 1000 and 99999\. Please note that this is not a high quality random number \([https\://github\.com/ansible\-collections/community\.crypto/issues/76](https\://github\.com/ansible\-collections/community\.crypto/issues/76)\)\.
* openssl\_csr \- add support for name constraints extension \([https\://github\.com/ansible\-collections/community\.crypto/issues/46](https\://github\.com/ansible\-collections/community\.crypto/issues/46)\)\.
* openssl\_csr\_info \- add support for name constraints extension \([https\://github\.com/ansible\-collections/community\.crypto/issues/46](https\://github\.com/ansible\-collections/community\.crypto/issues/46)\)\.

<a id="bugfixes-53"></a>
### Bugfixes

* acme\_inspect \- fix problem with Python 3\.5 that JSON was not decoded \([https\://github\.com/ansible\-collections/community\.crypto/issues/86](https\://github\.com/ansible\-collections/community\.crypto/issues/86)\)\.
* get\_certificate \- fix <code>ca\_cert</code> option handling when <code>proxy\_host</code> is used \([https\://github\.com/ansible\-collections/community\.crypto/pull/84](https\://github\.com/ansible\-collections/community\.crypto/pull/84)\)\.
* openssl\_\*\, x509\_\* modules \- fix handling of general names which refer to IP networks and not IP addresses \([https\://github\.com/ansible\-collections/community\.crypto/pull/92](https\://github\.com/ansible\-collections/community\.crypto/pull/92)\)\.

<a id="new-modules-6"></a>
### New Modules

* community\.crypto\.openssl\_signature \- Sign data with openssl
* community\.crypto\.openssl\_signature\_info \- Verify signatures with openssl

<a id="v1-0-0"></a>
## v1\.0\.0

<a id="release-summary-73"></a>
### Release Summary

This is the first proper release of the <code>community\.crypto</code> collection\. This changelog contains all changes to the modules in this collection that were added after the release of Ansible 2\.9\.0\.

<a id="minor-changes-35"></a>
### Minor Changes

* luks\_device \- accept <code>passphrase</code>\, <code>new\_passphrase</code> and <code>remove\_passphrase</code>\.
* luks\_device \- add <code>keysize</code> parameter to set key size at LUKS container creation
* luks\_device \- added support to use UUIDs\, and labels with LUKS2 containers
* luks\_device \- added the <code>type</code> option that allows user explicit define the LUKS container format version
* openssh\_keypair \- instead of regenerating some broken or password protected keys\, fail the module\. Keys can still be regenerated by calling the module with <code>force\=yes</code>\.
* openssh\_keypair \- the <code>regenerate</code> option allows to configure the module\'s behavior when it should or needs to regenerate private keys\.
* openssl\_\* modules \- the cryptography backend now properly supports <code>dirName</code>\, <code>otherName</code> and <code>RID</code> \(Registered ID\) names\.
* openssl\_certificate \- Add option for changing which ACME directory to use with acme\-tiny\. Set the default ACME directory to Let\'s Encrypt instead of using acme\-tiny\'s default\. \(acme\-tiny also uses Let\'s Encrypt at the time being\, so no action should be necessary\.\)
* openssl\_certificate \- Change the required version of acme\-tiny to \>\= 4\.0\.0
* openssl\_certificate \- allow to provide content of some input files via the <code>csr\_content</code>\, <code>privatekey\_content</code>\, <code>ownca\_privatekey\_content</code> and <code>ownca\_content</code> options\.
* openssl\_certificate \- allow to return the existing/generated certificate directly as <code>certificate</code> by setting <code>return\_content</code> to <code>yes</code>\.
* openssl\_certificate\_info \- allow to provide certificate content via <code>content</code> option \([https\://github\.com/ansible/ansible/issues/64776](https\://github\.com/ansible/ansible/issues/64776)\)\.
* openssl\_csr \- Add support for specifying the SAN <code>otherName</code> value in the OpenSSL ASN\.1 UTF8 string format\, <code>otherName\:\<OID\>\;UTF8\:string value</code>\.
* openssl\_csr \- allow to provide private key content via <code>private\_key\_content</code> option\.
* openssl\_csr \- allow to return the existing/generated CSR directly as <code>csr</code> by setting <code>return\_content</code> to <code>yes</code>\.
* openssl\_csr\_info \- allow to provide CSR content via <code>content</code> option\.
* openssl\_dhparam \- allow to return the existing/generated DH params directly as <code>dhparams</code> by setting <code>return\_content</code> to <code>yes</code>\.
* openssl\_dhparam \- now supports a <code>cryptography</code>\-based backend\. Auto\-detection can be overwritten with the <code>select\_crypto\_backend</code> option\.
* openssl\_pkcs12 \- allow to return the existing/generated PKCS\#12 directly as <code>pkcs12</code> by setting <code>return\_content</code> to <code>yes</code>\.
* openssl\_privatekey \- add <code>format</code> and <code>format\_mismatch</code> options\.
* openssl\_privatekey \- allow to return the existing/generated private key directly as <code>privatekey</code> by setting <code>return\_content</code> to <code>yes</code>\.
* openssl\_privatekey \- the <code>regenerate</code> option allows to configure the module\'s behavior when it should or needs to regenerate private keys\.
* openssl\_privatekey\_info \- allow to provide private key content via <code>content</code> option\.
* openssl\_publickey \- allow to provide private key content via <code>private\_key\_content</code> option\.
* openssl\_publickey \- allow to return the existing/generated public key directly as <code>publickey</code> by setting <code>return\_content</code> to <code>yes</code>\.

<a id="deprecated-features-12"></a>
### Deprecated Features

* openssl\_csr \- all values for the <code>version</code> option except <code>1</code> are deprecated\. The value 1 denotes the current only standardized CSR version\.

<a id="removed-features-previously-deprecated-1"></a>
### Removed Features \(previously deprecated\)

* The <code>letsencrypt</code> module has been removed\. Use <code>acme\_certificate</code> instead\.

<a id="bugfixes-54"></a>
### Bugfixes

* ACME modules\: fix bug in ACME v1 account update code
* ACME modules\: make sure some connection errors are handled properly
* ACME modules\: support Buypass\' ACME v1 endpoint
* acme\_certificate \- fix crash when module is used with Python 2\.x\.
* acme\_certificate \- fix misbehavior when ACME v1 is used with <code>modify\_account</code> set to <code>false</code>\.
* ecs\_certificate \- Always specify header <code>connection\: keep\-alive</code> for ECS API connections\.
* ecs\_certificate \- Fix formatting of contents of <code>full\_chain\_path</code>\.
* get\_certificate \- Fix cryptography backend when pyopenssl is unavailable \([https\://github\.com/ansible/ansible/issues/67900](https\://github\.com/ansible/ansible/issues/67900)\)
* openssh\_keypair \- add logic to avoid breaking password protected keys\.
* openssh\_keypair \- fixes idempotence issue with public key \([https\://github\.com/ansible/ansible/issues/64969](https\://github\.com/ansible/ansible/issues/64969)\)\.
* openssh\_keypair \- public key\'s file attributes \(permissions\, owner\, group\, etc\.\) are now set to the same values as the private key\.
* openssl\_\* modules \- prevent crash on fingerprint determination in FIPS mode \([https\://github\.com/ansible/ansible/issues/67213](https\://github\.com/ansible/ansible/issues/67213)\)\.
* openssl\_certificate \- When provider is <code>entrust</code>\, use a <code>connection\: keep\-alive</code> header for ECS API connections\.
* openssl\_certificate \- <code>provider</code> option was documented as required\, but it was not checked whether it was provided\. It is now only required when <code>state</code> is <code>present</code>\.
* openssl\_certificate \- fix <code>assertonly</code> provider certificate verification\, causing \'private key mismatch\' and \'subject mismatch\' errors\.
* openssl\_certificate and openssl\_csr \- fix Ed25519 and Ed448 private key support for <code>cryptography</code> backend\. This probably needs at least cryptography 2\.8\, since older versions have problems with signing certificates or CSRs with such keys\. \([https\://github\.com/ansible/ansible/issues/59039](https\://github\.com/ansible/ansible/issues/59039)\, PR [https\://github\.com/ansible/ansible/pull/63984](https\://github\.com/ansible/ansible/pull/63984)\)
* openssl\_csr \- a warning is issued if an unsupported value for <code>version</code> is used for the <code>cryptography</code> backend\.
* openssl\_csr \- the module will now enforce that <code>privatekey\_path</code> is specified when <code>state\=present</code>\.
* openssl\_publickey \- fix a module crash caused when pyOpenSSL is not installed \([https\://github\.com/ansible/ansible/issues/67035](https\://github\.com/ansible/ansible/issues/67035)\)\.

<a id="new-modules-7"></a>
### New Modules

* community\.crypto\.ecs\_domain \- Request validation of a domain with the Entrust Certificate Services \(ECS\) API
* community\.crypto\.x509\_crl \- Generate Certificate Revocation Lists \(CRLs\)
* community\.crypto\.x509\_crl\_info \- Retrieve information on Certificate Revocation Lists \(CRLs\)
