"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/**
* converter
*/
const fs_1 = tslib_1.__importDefault(require("fs"));
const mustache_1 = tslib_1.__importDefault(require("mustache"));
const rehype_document_1 = tslib_1.__importDefault(require("rehype-document"));
const rehype_format_1 = tslib_1.__importDefault(require("rehype-format"));
const rehype_stringify_1 = tslib_1.__importDefault(require("rehype-stringify"));
const remark_man_1 = tslib_1.__importDefault(require("remark-man"));
const remark_parse_1 = tslib_1.__importDefault(require("remark-parse"));
const remark_rehype_1 = tslib_1.__importDefault(require("remark-rehype"));
const to_vfile_1 = require("to-vfile");
const unified_1 = tslib_1.__importDefault(require("unified"));
const utils_1 = require("../lib/utils");
const utils_2 = tslib_1.__importDefault(require("./utils"));
/**
 * class Man
 */
class Converter {
    readmeName = '';
    constructor(readmeName = './README.md') {
        this.readmeName = readmeName;
    }
    /**
     * md2html
     */
    async md2html(destDir, packageName, packageVersion, manName, verbose = false) {
        const echo = utils_2.default.setEcho(verbose);
        if (verbose) {
            console.log('Converter.md2html()');
        }
        const source = destDir + '/DEBIAN/' + manName + '.md';
        const dirname = destDir + '/usr/lib/' + packageName + '/manpages/doc/man/';
        const basename = manName;
        const extname = '.html';
        const file = await (0, unified_1.default)()
            .use(remark_parse_1.default)
            .use(remark_rehype_1.default)
            .use(rehype_document_1.default)
            .use(rehype_format_1.default)
            .use(rehype_stringify_1.default)
            .process(await (0, to_vfile_1.read)(source));
        file.dirname = dirname;
        file.basename = basename;
        file.extname = extname;
        await (0, to_vfile_1.write)(file);
    }
    /**
     * md2man
     */
    async md2man(destDir, packageName, packageVersion, manName, verbose = false) {
        const echo = utils_2.default.setEcho(verbose);
        if (verbose) {
            console.log('Converter.md2man()');
        }
        const source = destDir + '/DEBIAN/' + manName + '.md';
        const dirname = destDir + '/DEBIAN/';
        const basename = manName;
        const extname = '.roll';
        const file = await (0, unified_1.default)()
            .use(remark_parse_1.default)
            .use(remark_man_1.default)
            .process(await (0, to_vfile_1.read)(source));
        file.dirname = dirname;
        file.basename = basename;
        file.extname = extname;
        await (0, to_vfile_1.write)(file);
        const man = dirname + basename + extname;
        const manCompressed = dirname + basename + '.roll.gz';
        await (0, utils_1.exec)('gzip -9 ' + man, echo);
        await (0, utils_1.exec)(`cp ${manCompressed} ${destDir}/usr/lib/${packageName}/manpages/doc/man/${basename}.1.gz`, echo);
    }
    /**
     * readme2md
     */
    async readme2md(destDir, packageName, packageVersion, manName, packageNameVersioned, verbose = false) {
        if (verbose) {
            console.log('Converter.readme2md()');
        }
        const readme = fs_1.default.readFileSync(this.readmeName, 'utf8').split('\n');
        /**
         * Sezioni: toc, usage, commands
         */
        let toc = '';
        const tocStart = '<!-- toc -->';
        let isToc = false;
        const tocStop = '<!-- tocstop -->';
        let usage = '';
        const usageStart = '<!-- usage -->';
        let isUsage = false;
        const usageStop = '<!-- usagestop -->';
        let commands = '';
        const commandsStart = '<!-- commands -->';
        let isCommands = false;
        const commandsStop = '<!-- commandsstop -->';
        for (const element of readme) {
            let isComment = false;
            if (element.includes('<!--')) {
                isComment = false;
                if (element.includes(tocStart)) {
                    isToc = true;
                }
                if (element.includes(tocStop)) {
                    isToc = false;
                }
                if (element.includes(usageStart)) {
                    isUsage = true;
                }
                if (element.includes(usageStop)) {
                    isUsage = false;
                }
                if (element.includes(commandsStart)) {
                    isCommands = true;
                }
                if (element.includes(commandsStop)) {
                    isCommands = false;
                }
            }
            // Aggiunge la linea alla sezione
            if (isToc && !isComment) {
                toc += element + '\n';
            }
            if (isUsage && !isComment) {
                usage += element + '\n';
            }
            if (isCommands && !isComment && !element.includes('See code:')) {
                commands += element + '\n';
            }
        }
        toc = '';
        usage = usage.toString();
        /**
        * Creazione della versione markdown
        */
        const template = fs_1.default.readFileSync('perrisbrewery/template/man.template.md', 'utf8');
        const sourceVersion = packageVersion;
        const linuxVersion = '';
        const view = {
            commands,
            linuxVersion,
            packageNameVersioned,
            packageVersion,
            toc,
            usage,
        };
        const tempMd = destDir + '/DEBIAN/' + manName + '.md';
        fs_1.default.writeFileSync(tempMd, mustache_1.default.render(template, view), 'utf8');
        console.log('File ' + tempMd + ' created');
    }
}
exports.default = Converter;
