/**
 * Krill Installer - Simplified Refactoring
 * ./src/krill/prepare.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IKrillConfig } from '../interfaces/i_krill_config.js';
import Keyboards from '../../classes/keyboards.js';
import Locales from '../../classes/locales.js';
import { welcome } from './prepare.d/welcome.js';
import { location } from './prepare.d/location.js';
import { keyboard } from './prepare.d/keyboard.js';
import { partitions } from './prepare.d/partitions.js';
import { users } from './prepare.d/users.js';
import { network } from './prepare.d/network.js';
import { summary } from './prepare.d/summary.js';
/**
 * Main Krill installer class - Simplified refactoring
 */
export default class Krill {
    welcome: typeof welcome;
    location: typeof location;
    keyboard: typeof keyboard;
    partitions: typeof partitions;
    users: typeof users;
    network: typeof network;
    summary: typeof summary;
    krillConfig: IKrillConfig;
    locales: Locales;
    keyboards: Keyboards;
    unattended: boolean;
    nointeractive: boolean;
    chroot: boolean;
    halt: boolean;
    /**
     * Constructor
     */
    constructor(unattended?: boolean, nointeractive?: boolean, halt?: boolean, chroot?: boolean);
    /**
     * Main prepare method - Simplified and cleaner
     */
    prepare(krillConfig?: IKrillConfig, ip?: boolean, random?: boolean, domain?: string, suspend?: boolean, small?: boolean, none?: boolean, crypted?: boolean, pve?: boolean, btrfs?: boolean, testing?: boolean, verbose?: boolean): Promise<void>;
    /**
     * Check system requirements (disks, LVM)
     */
    private checkSystemRequirements;
    /**
     * Setup configuration files and auto-configure timezone
     */
    private setupConfiguration;
    /**
     * Auto-configure timezone from internet
     */
    private autoConfigureTimezone;
    /**
     * Stop system services
     */
    private stopSystemServices;
    /**
     * Build default configurations
     */
    private buildConfigurations;
    /**
     * Generate hostname based on options
     */
    private generateHostname;
    /**
     * Apply options for unattended installation
     */
    private applyUnattendedOptions;
    /**
     * Run interactive mode with UI
     */
    private runInteractiveMode;
    /**
     * Perform installation or testing
     */
    private performInstallation;
    /**
     * Create script to remove LVM partitions
     */
    private createLvmRemovalScript;
    /**
     * Check if Physical Volumes exist
     */
    private pvExist;
}
