/**
 * penguins-eggs
 *
 * Kernel management utilities
 * Handle vmlinuz and initramfs detection across different distributions
 */
/**
 * Kernel utilities for managing vmlinuz and initramfs paths
 */
export default class Kernel {
    /**
     * Ricava path per vmlinuz
     *
     * @returns Path al file vmlinuz
     */
    static vmlinuz(kernel?: string): string;
    /**
     * Ricava path per initramfs/initrd
     *
     * @param kernel - Versione del kernel
     * @returns Path al file initramfs
     */
    static initramfs(kernel?: string): string;
    /**
     * ALL PRIVATE
     */
    /**
     * most of the distros:
     * debian, fedora, opensuse, rasberry
     */
    private static vmlinuxFromUname;
    /**
     * vmlinuxFromCmdline
     * raspbery /proc/cmdline dont contain it
     */
    private static vmlinuxFromCmdline;
}
