/* utils.c generated by valac 0.56.18, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#define VERSION "11.7.3"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

VALA_EXTERN gchar* get_os_id (void);
VALA_EXTERN gchar* get_user_agent (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gchar*
get_os_id (void)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_file_new_for_path ("/etc/os-release");
	file = _tmp0_;
	_tmp1_ = file;
	if (g_file_query_exists (_tmp1_, NULL)) {
		{
			GFileInputStream* _tmp2_ = NULL;
			GFile* _tmp3_;
			GFileInputStream* _tmp4_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp5_;
			gchar* line = NULL;
			_tmp3_ = file;
			_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
			dis = _tmp5_;
			while (TRUE) {
				gchar* _tmp6_ = NULL;
				GDataInputStream* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp7_ = dis;
				_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error0_);
				_tmp6_ = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp2_);
					goto __catch0_g_error;
				}
				_tmp9_ = _tmp6_;
				_tmp6_ = NULL;
				_g_free0 (line);
				line = _tmp9_;
				_tmp10_ = line;
				if (!(_tmp10_ != NULL)) {
					_g_free0 (_tmp6_);
					break;
				}
				_tmp11_ = line;
				if (g_str_has_prefix (_tmp11_, "ID=")) {
					const gchar* _tmp12_;
					gchar** _tmp13_;
					gchar** _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp12_ = line;
					_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, "ID=", 2);
					_tmp15_ = _tmp14_;
					_tmp15__length1 = _vala_array_length (_tmp13_);
					_tmp16_ = _tmp15_[1];
					_tmp15_[1] = NULL;
					_tmp17_ = _tmp16_;
					_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
					result = _tmp17_;
					_g_free0 (_tmp6_);
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp2_);
					_g_object_unref0 (file);
					return result;
				}
				_g_free0 (_tmp6_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = NULL;
	_g_object_unref0 (file);
	return result;
}

gchar*
get_user_agent (void)
{
	gchar* id = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	_tmp0_ = get_os_id ();
	id = _tmp0_;
	_tmp1_ = id;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf ("Pamac/%s", VERSION);
		result = _tmp2_;
		_g_free0 (id);
		return result;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = id;
		_tmp4_ = g_strdup_printf ("Pamac/%s_%s", VERSION, _tmp3_);
		result = _tmp4_;
		_g_free0 (id);
		return result;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

