/**
 * Copyright (C) 2007-2014 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_CLUSTER_EUCLIDEANDISTANCE_HPP
#define INDII_CLUSTER_EUCLIDEANDISTANCE_HPP

namespace indii {
/**
 * Euclidean distance.
 *
 * @tparam T Element type.
 * @tparam N Vector size.
 */
template<class T1 = float, class T2 = float>
class EuclideanDistance {
public:
  typedef T1 value_type;
  typedef T2 distance_type;

  /**
   * Preprocess point.
   *
   * @param x Point.
   */
  static void prepare(T1& x) {
    //
  }

  /**
   * Calculate distance.
   *
   * @param x1 First point.
   * @param x2 Second point.
   *
   * @return %Distance between the two points.
   */
  static T2 distance(const T1 x1, const T1 x2) {
    return std::fabs(x2 - x1);
  }
};
}

#endif
