'\"
'\" Generated from file 'mkzip\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Pat Thoyts
'\"
.TH "zipfile::mkzip" n 1\&.2 tcllib "Zip archive creation"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
zipfile::mkzip \- Build a zip archive
.SH SYNOPSIS
package require \fBTcl  8\&.6\fR
.sp
package require \fBzipfile::mkzip  ?1\&.2?\fR
.sp
\fB::zipfile::mkzip::mkzip\fR \fIzipfile\fR ?\fB-zipkit\fR? ?\fB-runtime\fR \fIprefix\fR? ?\fB-comment\fR \fIstring\fR? ?\fB-directory\fR \fIrootpath\fR? ?\fB-exclude\fR \fIexclude\fR? ?\fB--\fR? ?\fIpath\fR\&.\&.\&.?
.sp
.BE
.SH DESCRIPTION
.PP
This package utilizes the zlib functions in Tcl 8\&.6 to build zip
archives\&.
.SH API
.TP
\fB::zipfile::mkzip::mkzip\fR \fIzipfile\fR ?\fB-zipkit\fR? ?\fB-runtime\fR \fIprefix\fR? ?\fB-comment\fR \fIstring\fR? ?\fB-directory\fR \fIrootpath\fR? ?\fB-exclude\fR \fIexclude\fR? ?\fB--\fR? ?\fIpath\fR\&.\&.\&.?
From \fIhttp://wiki\&.tcl\&.tk/15158\fR
.sp
This command constructs a zip archive from a directory tree
using nothing but Tcl 8\&.6 core features\&. The resulting zip file should
be compatible with other \fBzip\fR programs - with the possible
exception of unicode support\&. The files generated by this command use
utf-8 encoding for all filenames and comments and it has been noticed
particularly on Windows the \fBinfo-zip\fR and the Windows built-in
zip view have rather poor support for this part of the ZIP file
specification\&. The \fB7-Zip\fR program does correctly display utf8
filenames however and the \fBvfs::zip\fR package will use these of
course\&.
.sp
If you use
.CS

\fB::mkzip::mkzip\fR mystuff\&.tm -zipkit -directory mystuff\&.vfs
.CE
.IP
it will pack your "\fImystuff\&.vfs/\fR" virtual filesystem tree into a
zip archive with a suitable header such that on unix you may mark it
executable and it should run with tclkit\&. Or you can run it with
\fBtclsh\fR or \fBwish\fR 8\&.6 if you like\&.
.sp
To change the executable header, specify the \fB-runtime\fR
"\fIpreface\fR" where preface is a file containing code you want
prefixed\&. For instance, on Windows you can create a self-extracting
zip archive using
.CS


mkzip mystuff\&.exe -directory mystuff\&.vfs -runtime unzipsfx\&.exe

.CE
.IP
The "\fIunzipsfx\&.exe\fR" is the Info-Zip self-extracting stub\&.
.sp
Accepted options:
.RS
.TP
\fB-runtime\fR path
This option specifies a file to use as prefix to the actual zip
archive\&. If specified \fB-zipkit\fR will be ignored\&.
.TP
\fB-zipkit\fR
Instructs the command to generate a prefix which makes the archive a
zip-based starkit\&. Ignored if \fB-runtime\fR is present\&.
.TP
\fB-comment\fR string
This options specifies a global comment to place into the generated
archive\&.
.TP
\fB-directory\fR path
This option specifies the directory to place into the generated
archive\&. If specified any argument \fIpath\fRs are \fIignored\fR\&.
.TP
\fB-exclude\fR list
This option specifies a list of glob patterns\&. All paths matching at
least one of the patterns are not placed into the generated archive\&.
This option defaults to
.CS


    CVS/* */CVS/* *~ "\&.#*" "*/\&.#*"

.CE
.TP
\fB--\fR
This option signals the end of the options, forcing processing of all
further words as arguments, even if they begin with a dash character\&.
.RE
.sp
Accepted arguments:
.RS
.TP
path \fIpath\fR
Each path is a directory or file to place into the generated archive\&.
Note however that these will be ignored when option \fB-directory\fR
is specified\&.
.RE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIzipfile\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
decompression, zip
.SH CATEGORY
File
.SH COPYRIGHT
.nf
Copyright (c) 2009 Pat Thoyts

.fi