5.2 Itérations et Boucles

# Itérations et Boucles

Jusqu'à maintenant nous avons passé beaucoup de temps à rechercher les 
différents sons que vous pouvez faire avec des blocs de `play` et de 
`sample`. Nous avons aussi appris comment déclencher ces sons dans le 
temps en utilisant `sleep`.

Comme vous vous en êtes probablement rendu compte, il y a *beaucoup* de 
plaisir à avoir avec la construction de ces blocs de base. Toutefois, 
une dimension totalement nouvelle de plaisir se découvre quand vous 
commencez à utiliser la puissance du code pour structurer votre musique 
et vos compositions. Dans les quelques sections suivantes, nous allons 
explorer quelques uns de ces nouveaux outils puissants. En premier, 
découvrons l'itération et les boucles.

## Répétition

Avez-vous écrit du code que vous aimeriez répéter quelques fois ?
Par exemple, vous pourriez avoir quelque chose comme ceci :

```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

Que faire si nous voulions répéter ceci 3 fois ? Eh bien, nous 
pourrions faire simple et juste le copier et le coller trois fois :
```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

Maintenant, c'est beaucoup de code ! Que se passe-t-il si nous voulions 
changer l'échantillon en `:elec_plip` ? Vous aller devoir trouver tous 
les endroits avec l'original `:elec_blup` et les modifier un par un. 
De façon plus importante, que faire si vous voulez répéter le bout de 
code original 50 fois ou 1000 fois ? Ça ferait alors beaucoup de code, 
et beaucoup de lignes de code à modifier si vous vouliez faire un 
changement.

## Itération

En fait, répéter le code devrait être aussi facile que de dire *fais 
ceci trois fois*. Eh bien, c'est presque cela. Souvenez-vous de notre 
vieil ami le bloc de code. Nous pouvons l'utiliser pour marquer le 
début et la fin du code que nous aimerions répéter trois fois. Nous 
utilisons alors le code spécial `3.times`. Ainsi, à la place d'écrire 
*fais cela trois fois*, nous écrivons `3.times do` - Ce n'est pas trop 
dur. Rappelez-vous juste d'écrire `end` à la fin du code que vous 
devez répéter :

```
3.times do
  play 50
  sleep 0.5
  sample :elec_blup
  sleep 0.5
  play 62
  sleep 0.25
end
```

Alors, est-ce que ce n'est pas plus propre que de copier-coller ! 
Nous pouvons l'utiliser pour créér beaucoup de chouettes structures 
répétitives. 

```
4.times do
  play 50
  sleep 0.5
end

8.times do
  play 55, release: 0.2
  sleep 0.25
end

4.times do
  play 50
  sleep 0.5
end
```

## Imbrication d'itérations

Nous pouvons mettre des itérations à l'intérieur d'autres itérations 
pour créér des motifs intéressants. Par exemple :

```
4.times do
  sample :drum_heavy_kick
  2.times do
    sample :elec_blip2, rate: 2
    sleep 0.25
  end
  sample :elec_snare
  4.times do
    sample :drum_tom_mid_soft
    sleep 0.125
  end
end
```

## Bouclage

Si vous voulez répéter quelque chose un grand nombre de fois, vous 
pourriez vous trouvez en situation d'utiliser des nombres vraiment 
grands comme `1000.times do`. Dans ce cas, vous feriez probablement 
mieux de demander à Sonic Pi de répéter à jamais (au moins jusqu'à 
ce que vous pressiez le bouton stop !). Bouclons l'échantillon amen à 
jamais :

```
loop do
  sample :loop_amen
  sleep sample_duration :loop_amen
end
```

La chose importante à savoir à propos des boucles est qu'elles se 
comportent comme des trous noirs pour le code. Une fois que le code est 
entré dans une boucle, il ne peut pas en sortir tant que vous n'avez pas 
pressé stop -  il va juste tourner en rond dans la boucle à jamais. 
Ce qui signifie que si vous avez du code après la boucle, vous ne 
l'entendrez *jamais*. Par exemple, la cymbale suivant cette boucle ne 
sera jamais jouée :

```
loop do
  play 50
  sleep 1
end

sample :drum_cymbal_open
```

Maintenant, structurez votre code avec des itérations et des boucles !
