# Voice Notes|deepin-voice-note|

## Overview

Voice Notes is a note-taking software that integrates voice and text, commonly used to record daily life or work matters.

## Getting Started

Run, close Voice Notes, or create shortcuts through the following methods.

### Run Voice Notes

1. Click the Launcher icon ![deepin_launcher](../common/deepin_launcher.svg) on the taskbar to enter the Launcher interface.
2. Scroll the mouse wheel or search to find the Voice Notes icon ![deepin_voice_note](../common/deepin_voice_note.svg), then click to run.
3. Right-click ![deepin_voice_note](../common/deepin_voice_note.svg) to:
   - Click **Send to Desktop** to create a desktop shortcut.
   - Click **Pin to Taskbar** to pin the application to the taskbar.
   - Click **Startup Automatically** to add the application to startup items, automatically running it when the computer boots.

### Close Voice Notes

- Click ![close_icon](../common/close_icon.svg) in the Voice Notes interface to exit.
- Right-click ![deepin_voice_note](../common/deepin_voice_note.svg) on the taskbar and select **Close All**.
- Click ![icon_menu](../common/icon_menu.svg) in the Voice Notes interface and select **Exit**.

### View Shortcuts

Use the shortcut **Ctrl + Shift + ?** to open the shortcut preview. Mastering shortcuts will significantly improve efficiency.

![hotkey](fig/hotkey.png)

## Notebook Management

### Create Notebook

- When no notebooks exist, click **New Notebook** to create one.
- Below the notebook list, click **New Notebook** to create a new notebook.

> ![tips](../common/tips.svg) Tip: Drag notebooks to reorder; click ![icon](../common/view.svg) to hide/show the notebook list.

### Rename Notebook

1. Double-click a notebook or right-click and select **Rename**.
2. Enter a new name in the text box.
3. Click a blank area or press **Enter** to confirm.

![0|rename](fig/rename.png)

### Delete Notebook

1. Select a notebook in the notebook list.
2. Right-click and select **Delete** or press **Delete**.
3. Confirm deletion in the dialog.

## Note Management

### Create Note

- After creating your first notebook, a default note is created. Click ![add](../common/circlebutton_add2.svg) to add more notes.
- Right-click a notebook/note and select **New Note**.

![0|new](fig/new_notes.png)

#### Add Text to Note

1. Select a note in the note list.
2. Click the detail area and enter text.
3. Select text to access formatting tools: font, size, color, bold, etc.

![0|txtinput](fig/txtinput.png)

#### Add Voice to Note

1. Select a note in the note list.
2. Click the record button ![record_normal](../common/record_normal.svg).
3. Click ![finish](../common/finish_normal.svg) to finish recording (max 60 minutes).
   
   > ![notes](../common/notes.svg) Note: Click ![pause](../common/pause_red_normal.svg) to pause; ![record_normal](../common/continue.svg) to resume.
4. Click ![play_blue_normal](../common/play_blue_normal.svg) to playback.

![0|Recorder](fig/recorder.png)

#### Add Image to Note

Add images via:
- Click ![icon](../common/pic.svg) > select image.
- Drag image to detail area.
- Copy-paste image.

![pic](fig/picture.png)

### Rename Note

1. Double-click a note or right-click and select **Rename**.
2. Enter a new name.
3. Click a blank area or press **Enter**.

### Search Notes

1. Click ![search](../common/search.svg) in the search box.
2. Enter keywords and press **Enter**.
3. Click ![0|three_dots](../common/close_icon.svg) to clear/cancel search.

### Move Notes

Select one/multiple notes (Ctrl/Shift), then:
- Drag to another notebook.
- Right-click > **Move** > select target notebook.

![0|move](fig/move.png)

### Pin Notes

1. Right-click a note.
2. Select **Pin to Top**.

   Right-click pinned note > **Unpin**.

### Save Notes

1. Select one/multiple notes.
2. Right-click > **Save Note** > **Save as HTML** or **Save as TXT**.

   >![notes](../common/notes.svg) Note:
   >- TXT: Saves text/voice metadata (no audio/images).
   >- HTML: Saves text/images (no audio).

![pic](fig/save_notes.png)

### Save Voice

1. Select one/multiple voice notes.
2. Right-click > **Save Voice** (saves as MP3).

> ![tips](../common/tips.svg) Tip: Right-click a single voice file > **Save as MP3**.

### Voice to Text

1. Select a voice file.
2. Right-click > **Voice to Text** (converts to text).

![0|save](fig/tovoice.png)

### Text to Speech

1. Select text > right-click > **Text to Speech**.
2. Click close button ![close](../common/close_icon.svg) to stop.

>![notes](../common/notes.svg) Note:
>- Grayed out if no text selected.
>- Works only on converted text (not raw audio).

![0|speech](fig/speech.png)

### Voice Dictation

1. Place cursor > right-click > **Voice Dictation** (speech-to-text).
2. Click close button ![close](../common/close_icon.svg) to stop.

>![tips](../common/tips.svg) Tip: Can be used while recording.

### Delete Note

1. Select one/multiple notes.
2. Right-click > **Delete** or press **Delete**.
3. Confirm deletion.

### Delete Voice

1. Select a voice file.
2. Right-click > **Delete** or press **Delete**.

## Main Menu

Set audio source, view privacy policy, switch themes, view help, etc.

### Settings

Set audio source:
- **System Sound**: Records internal audio only.
- **Microphone**: Records mic input only.

1. Click ![icon_menu](../common/icon_menu.svg).
2. Select audio source.

### Privacy Policy

1. Click ![icon_menu](../common/icon_menu.svg).
2. Select **Privacy Policy** to view.

### Theme

Switch themes (Light/Dark/System):
1. Click ![icon_menu](../common/icon_menu.svg).
2. Select **Theme**.

### Help

View help manual:
1. Click ![icon_menu](../common/icon_menu.svg).
2. Select **Help**.

### About

View version/info:
1. Click ![icon_menu](../common/icon_menu.svg).
2. Select **About**.

### Exit

Quit Voice Notes:
1. Click ![icon_menu](../common/icon_menu.svg).
2. Select **Exit**.