/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegexMatchHandler;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntToIntHashMap;

public class ARegexIterator
implements RegexIterator,
LastPositionFinder {
    private final UnicodeString theString;
    private final UnicodeString _regex;
    private final REMatcher _matcher;
    private UnicodeString current;
    private UnicodeString nextSubstring;
    private int prevEnd = 0;
    private IntToIntHashMap nestingTable = null;
    private boolean skip = false;

    public ARegexIterator(UnicodeString str, UnicodeString regex, REMatcher matcher) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(regex);
        Objects.requireNonNull(matcher);
        this.theString = str;
        this._regex = regex;
        this._matcher = matcher;
        this.nextSubstring = null;
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        ARegexIterator another = new ARegexIterator(this.theString, this._regex, new REMatcher(this._matcher.getProgram()));
        int n = 0;
        while (another.next() != null) {
            ++n;
        }
        return n;
    }

    @Override
    public StringValue next() {
        try {
            if (this.nextSubstring == null && this.prevEnd >= 0) {
                int searchStart = this.prevEnd;
                if (this.skip && (long)(++searchStart) >= this.theString.length()) {
                    if ((long)this.prevEnd < this.theString.length()) {
                        this.current = this.theString.substring(this.prevEnd);
                        this.nextSubstring = null;
                    } else {
                        this.current = null;
                        this.prevEnd = -1;
                        return null;
                    }
                }
                if (this._matcher.match(this.theString, searchStart)) {
                    int end;
                    int start = this._matcher.getParenStart(0);
                    boolean bl = this.skip = start == (end = this._matcher.getParenEnd(0));
                    if (this.prevEnd == start) {
                        this.nextSubstring = null;
                        this.current = this.theString.substring(start, end);
                        this.prevEnd = end;
                    } else {
                        this.current = this.theString.substring(this.prevEnd, start);
                        this.nextSubstring = this.theString.substring(start, end);
                    }
                } else {
                    if ((long)this.prevEnd >= this.theString.length()) {
                        this.current = null;
                        this.prevEnd = -1;
                        return null;
                    }
                    this.current = this.theString.substring(this.prevEnd);
                    this.nextSubstring = null;
                    this.prevEnd = -1;
                }
            } else if (this.prevEnd >= 0) {
                this.current = this.nextSubstring;
                this.nextSubstring = null;
                this.prevEnd = this._matcher.getParenEnd(0);
            } else {
                this.current = null;
                return null;
            }
            return this.currentStringValue();
        }
        catch (StackOverflowError e) {
            XPathException.StackOverflow err = new XPathException.StackOverflow("Stack overflow (excessive recursion) during regular expression evaluation", "SXRE0001", Loc.NONE);
            throw new UncheckedXPathException(err);
        }
    }

    private StringValue currentStringValue() {
        return new StringValue(this.current);
    }

    @Override
    public boolean isMatching() {
        return this.nextSubstring == null && this.prevEnd >= 0;
    }

    @Override
    public UnicodeString getRegexGroup(int number) {
        if (!this.isMatching()) {
            return null;
        }
        if (number >= this._matcher.getParenCount() || number < 0) {
            return EmptyUnicodeString.getInstance();
        }
        UnicodeString us = this._matcher.getParen(number);
        return us == null ? EmptyUnicodeString.getInstance() : us;
    }

    @Override
    public int getNumberOfGroups() {
        return this._matcher.getParenCount();
    }

    @Override
    public void processMatchingSubstring(RegexMatchHandler action) throws XPathException {
        int c = this._matcher.getParenCount() - 1;
        if (c == 0) {
            action.characters(this.current);
        } else {
            IntHashMap actions = new IntHashMap(c);
            for (int i = 1; i <= c; ++i) {
                int start = this._matcher.getParenStart(i) - this._matcher.getParenStart(0);
                if (start == -1) continue;
                int end = this._matcher.getParenEnd(i) - this._matcher.getParenStart(0);
                if (start < end) {
                    ArrayList<Integer> s2 = (ArrayList<Integer>)actions.get(start);
                    if (s2 == null) {
                        s2 = new ArrayList<Integer>(4);
                        actions.put(start, s2);
                    }
                    s2.add(i);
                    ArrayList<Integer> e = (ArrayList<Integer>)actions.get(end);
                    if (e == null) {
                        e = new ArrayList<Integer>(4);
                        actions.put(end, e);
                    }
                    e.add(0, -i);
                    continue;
                }
                if (this.nestingTable == null) {
                    this.nestingTable = ARegexIterator.computeNestingTable(this._regex);
                }
                int parentGroup = this.nestingTable.get(i);
                ArrayList<Integer> s3 = (ArrayList<Integer>)actions.get(start);
                if (s3 == null) {
                    s3 = new ArrayList<Integer>(4);
                    actions.put(start, s3);
                    s3.add(i);
                    s3.add(-i);
                    continue;
                }
                int pos = s3.size();
                for (int e = 0; e < s3.size(); ++e) {
                    if ((Integer)s3.get(e) != -parentGroup) continue;
                    pos = e;
                    break;
                }
                s3.add(pos, -i);
                s3.add(pos, i);
            }
            UnicodeBuilder buff = new UnicodeBuilder();
            int i = 0;
            while ((long)i < this.current.length() + 1L) {
                List events = (List)actions.get(i);
                if (events != null) {
                    if (!buff.isEmpty()) {
                        action.characters(buff.toUnicodeString());
                        buff.clear();
                    }
                    for (Integer group : events) {
                        if (group > 0) {
                            action.onGroupStart(group);
                            continue;
                        }
                        action.onGroupEnd(-group.intValue());
                    }
                }
                if ((long)i < this.current.length()) {
                    buff.append(this.current.codePointAt(i));
                }
                ++i;
            }
            if (!buff.isEmpty()) {
                action.characters(buff.toUnicodeString());
            }
        }
    }

    public static IntToIntHashMap computeNestingTable(UnicodeString regex) {
        IntToIntHashMap nestingTable = new IntToIntHashMap(16);
        int[] stack = new int[regex.length32()];
        int tos = 0;
        boolean[] captureStack = new boolean[regex.length32()];
        int captureTos = 0;
        int group = 1;
        int inBrackets = 0;
        stack[tos++] = 0;
        int i = 0;
        while ((long)i < regex.length()) {
            boolean capture;
            int ch = regex.codePointAt(i);
            if (ch == 92) {
                ++i;
            } else if (ch == 91) {
                ++inBrackets;
            } else if (ch == 93) {
                --inBrackets;
            } else if (ch == 40 && inBrackets == 0) {
                capture = regex.codePointAt(i + 1) != 63;
                captureStack[captureTos++] = capture;
                if (capture) {
                    nestingTable.put(group, stack[tos - 1]);
                    stack[tos++] = group++;
                }
            } else if (ch == 41 && inBrackets == 0 && (capture = captureStack[--captureTos])) {
                --tos;
            }
            ++i;
        }
        return nestingTable;
    }
}

