// Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co., Ltd.
// SPDX-FileCopyrightText: 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include <QtTest>
#include <QCoreApplication>
#include <QTest>

#include <gtest/gtest.h>
#include <gmock/gmock-matchers.h>
#ifndef __mips__
#include <sanitizer/asan_interface.h>
#endif


class QTestMain : public QObject
{
    Q_OBJECT

public:
    QTestMain(int &argc, char **argv);

private slots:
    void initTestCase();
    void cleanupTestCase();

    void testGTest();

private:
    int m_argc;
    char **m_argv;
};

QTestMain::QTestMain(int &argc, char **argv)
{
    m_argc = argc;
    m_argv = argv;
}

void QTestMain::initTestCase()
{
    qDebug() << "=====start test=====";
}

void QTestMain::cleanupTestCase()
{
    qDebug() << "=====stop test=====";
    exit(0);
}

void QTestMain::testGTest()
{
    testing::GTEST_FLAG(output) = "xml:./report/report_deepin-movie-test.xml";
    testing::InitGoogleTest(&m_argc,m_argv);
    int ret = RUN_ALL_TESTS();
#ifndef __mips__
    __sanitizer_set_report_path("asan.log");
#endif
    Q_UNUSED(ret)
}


int main(int argc, char *argv[])
{
    QTestMain testMain(argc, argv);
    QTest::qExec(&testMain, argc, argv);
    return 0;
}


#include "test_main.moc"
