/**
 * Deepin官网
 * deepin的官方网站后台接口
 *
 * The version of the OpenAPI document: 1.0
 * Contact: wurongjie@deepin.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/**
 * Based on http://www.creativepulse.gr/en/blog/2014/restful-api-requests-using-qt-cpp-for-linux-mac-osx-ms-windows
 * By Alex Stylianos
 *
 **/

#ifndef DH_HTTPREQUESTWORKER_H
#define DH_HTTPREQUESTWORKER_H

#include <QMap>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QObject>
#include <QString>
#include <QTimer>
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    #include <QRandomGenerator>
#endif

#include "DHHttpFileElement.h"

namespace DeepinHomeAPI {

enum DHHttpRequestVarLayout {
    NOT_SET,
    ADDRESS,
    URL_ENCODED,
    MULTIPART
};

class DHHttpRequestInput {

public:
    QString url_str;
    QString http_method;
    DHHttpRequestVarLayout var_layout;
    QMap<QString, QString> vars;
    QMap<QString, QString> headers;
    QList<DHHttpFileElement> files;
    QByteArray request_body;

    DHHttpRequestInput();
    DHHttpRequestInput(QString v_url_str, QString v_http_method);
    void initialize();
    void add_var(QString key, QString value);
    void add_file(QString variable_name, QString local_filename, QString request_filename, QString mime_type);
};

class DHHttpRequestWorker : public QObject {
    Q_OBJECT

public:
    explicit DHHttpRequestWorker(QObject *parent = nullptr, QNetworkAccessManager *manager = nullptr);
    virtual ~DHHttpRequestWorker();

    QByteArray response;
    QNetworkReply::NetworkError error_type;
    QString error_str;

    QMap<QString, QString> getResponseHeaders() const;
    QString http_attribute_encode(QString attribute_name, QString input);
    void execute(DHHttpRequestInput *input);
    static QSslConfiguration *sslDefaultConfiguration;
    void setTimeOut(int timeOutMs);
    void setWorkingDirectory(const QString &path);
    DHHttpFileElement getHttpFileElement(const QString &fieldname = QString());
    QByteArray *getMultiPartField(const QString &fieldname = QString());
    void setResponseCompressionEnabled(bool enable);
    void setRequestCompressionEnabled(bool enable);
    int  getHttpResponseCode() const;

signals:
    void on_execution_finished(DHHttpRequestWorker *worker);

private:
    enum DHCompressionType{
        Zlib,
        Gzip
    };
    QNetworkAccessManager *manager;
    QMap<QString, QString> headers;
    QMap<QString, DHHttpFileElement> files;
    QMap<QString, QByteArray *> multiPartFields;
    QString workingDirectory;
    QTimer timeOutTimer;
    bool isResponseCompressionEnabled;
    bool isRequestCompressionEnabled;
    int  httpResponseCode;
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    QRandomGenerator randomGenerator;
#endif

    void on_reply_timeout(QNetworkReply *reply);
    void on_reply_finished(QNetworkReply *reply);
    void process_response(QNetworkReply *reply);
    QByteArray decompress(const QByteArray& data);
    QByteArray compress(const QByteArray& input, int level, DHCompressionType compressType);
};

} // namespace DeepinHomeAPI

#endif // DH_HTTPREQUESTWORKER_H
