# 文件管理器|dde-file-manager|

## 概述

文件管理器是一款功能强大、简单易用的文件管理工具。它沿用了一般文件管理器的经典功能和布局，并在此基础上简化了用户操作，增加了很多特色功能。文件管理器拥有一目了然的导航栏、智能识别的搜索框、多样化的视图和排序，这些特点让文件管理不再复杂。

![1|overview](fig/p_overview.png)

## 使用入门

通过以下方式运行或关闭文件管理器，或者创建文件管理器的快捷方式。

### 运行文件管理器

1. 单击任务栏上的启动器图标 ![deepin_launcher ](../common/deepin_launcher.svg)，进入启动器界面。
2. 上下滚动鼠标滚轮浏览或通过搜索，找到文件管理器图标 ![deepin_file_manager](../common/deepin_file_manager.svg)，单击运行。
3. 右键单击 ![deepin_file_manager](../common/deepin_file_manager.svg)，您可以：
 - 单击 **发送到桌面**，在桌面创建快捷方式。
 - 单击 **发送到任务栏**，将应用程序固定到任务栏。
 - 单击 **开机自动启动**，将应用程序添加到开机启动项，在电脑开机时自动运行该应用。

> ![tips](../common/tips.svg) 窍门：您也可以使用快捷键 **Super + E** 启动文件管理器。

### 关闭文件管理器

- 在文件管理器界面，单击 ![close_icon](../common/close_icon.svg)，退出文件管理器。
- 在任务栏右键单击 ![deepin_file_manager](../common/deepin_file_manager.svg)，选择 **关闭所有** ，退出文件管理器。
- 在文件管理器界面，单击 ![icon_menu](../common/icon_menu.svg)，选择 **退出**，退出文件管理器。

### 查看快捷键

在文件管理器界面，使用快捷键 **Ctrl + Shift + /** 打开快捷键预览界面。熟练地使用快捷键，将大大提升您的操作效率。

![1|hotkey](fig/hotkey.png)

## 主界面

文件管理器的主界面简单易用、功能全面，熟练地使用界面功能将使文件管理更加简单高效。

![1|main_interface](fig/p_main_interface.png)


| 标号 | 名称           | 描述                                                         |
| ---- | -------------- | ------------------------------------------------------------ |
| 1    | 导航栏         | 单击导航图标，快速访问本地文件、磁盘、网络邻居、书签、标记等。 |
| 2    | 标签页栏       | 在标签页栏可以新建、移除标签页，移动标签页顺序。             |
| 3    | 地址栏         | 通过地址栏，您可以快速切换访问历史、在上下级目录间切换、输入地址访问。 |
| 4    | 视图和视图选项 | 单击 ![icon_view](../common/icon_view.svg) , ![list_view](../common/list_view.svg), ![treelist_view](../common/treelist_view.svg)图标，以图标、列表或树形列表形式查看文件（夹)。单击![](../common/view_options.svg)图标，展开视图选项下拉菜单调节图标、网格、显示预览。 |
| 5    | 排序方式       | 单击![](../common/sorting.svg)图标调整文件排序，切换排序方式。 |
| 6    | 搜索           | 通过搜索框搜索当前目录的文件。                               |
| 7    | 菜单栏         | 通过主菜单，您可以新建窗口、切换窗口主题、设置共享密码、设置文件管理器、查看帮助文档和关于信息、退出文件管理器。 |
| 8    | 状态栏         | 显示文件数量或者已选中文件的数量。                           |


> ![tips](../common/tips.svg) 窍门：可拖动左侧导航栏右边的分隔线来改变其宽度。

## 基本功能

文件管理器具备基本的文件管理功能，对文件（夹）进行新建、复制、重命名、删除等操作都非常简单。

### 新建文件

#### 新建文档

1. 在文件管理器空白区域，单击鼠标右键。
2. 选择 **新建文档**。
3. 在下拉菜单中选择新建文件的类型。
4. 输入新建文件的名称。

![0|newdo](fig/p_newdo.png)

#### 新建文件夹

1. 在文件管理器空白区域，单击鼠标右键。
2. 选择 **新建文件夹**。
3. 输入新建文件夹的名称。

### 重命名文件

1. 在文件管理器界面，右键单击文件。
2. 选择 **重命名**。
3. 输入文件名称，按 **Enter** 键或者单击界面空白区域。

### 批量重命名

1. 在文件管理器界面，选中多个文件。
2. 右击文件，并选择 **重命名**。
   - **替换文本** 查找需要替换的文本，并输入替换后的文本，文件名中的关键字将被统一替换。
   - **添加文本** 输入需要添加的文本，并选择位置是名称之前还是之后，文件名将统一加入被添加的文本。
   - **自定义文本** 输入文件名，并输入序列的递进数字，文件名将统一改成新文件名+递进数字。
4. 单击 **重命名** 来完成操作。

![1|rename](fig/p_batch_rename.png)

### 查看文件

单击菜单栏上的图标 ![icon_view](../common/icon_view.svg)  , ![list_view](../common/list_view.svg)  ,  ![list_view](../common/treelist_view.svg)或者使用快捷键  **Ctrl + 1**  、  **Ctrl + 2**  和  **Ctrl + 3** 来切换图标视图、列表视图和树形列表视图。

- 图标视图：平铺显示文件的名称、图标或缩略图。

![1|icon_view](fig/p_iconview.png)

- 列表视图：列表显示文件图标或缩略图、名称、修改时间、大小、类型等信息。

![1|list_view](fig/p_listview.png)

* 树形列表视图：树形展开文件目录，显示文件图标或缩略图、名称、修改时间、大小、类型等信息。

![1|list_view](fig/p_treelistview.png)

单击![](../common/view_options.svg)图标，在视图选项下拉菜单中可以调节视图样式。勾选显示预览可以预览文件详细信息。

* 图标视图支持调节图标大小和网格密度。

![1|list_view](fig/view_options_1.png)

* 列表视图和树形视图支持调节列表高度。

![1|list_view](fig/view_options_2.png)

> ![tips](../common/tips.svg) 窍门：在列表视图中，把光标置于两列之间的分隔线上，拖动它来改变列的宽度；双击分隔线可将当前列自动调整为本列内容最宽的宽度。

### 排序文件

1. 在文件管理器界面，单击鼠标右键选择 **排序方式**。或在标题栏单击![](../common/sorting.svg)图标选择排序方式。
3. 在子菜单中选择以名称、修改时间、创建时间、大小或类型来排序文件。

您可以在 **主菜单** > **设置 > 基础设置> 文件和目录** 中，勾选 **文件和文件夹混合排序**，将文件和文件夹按照所选的类型进行混合排序。

> ![tips](../common/tips.svg) 窍门：在列表视图中，单击表头栏的列标签来切换升序、降序。

### 打开文件

1. 在文件管理器界面，右键单击文件。
2. 选择 **打开方式** > **选择默认程序**。
3. 在程序列表中选择应用程序。

> ![notes](../common/notes.svg) 说明：直接双击文件会使用默认程序打开。您可以选择相同类型的多个文件，右键选择 **打开方式** 选项，同时打开多个文件。

![0|open](fig/p_open.png)


### 隐藏文件

1. 在文件管理器界面，右键单击文件。
2. 选择 **属性**，勾选 **隐藏此文件**。

### 复制文件

1. 在文件管理器界面，右键单击文件。
2. 单击 **复制**。
3. 选择一个目标存储位置。
4. 单击鼠标右键，然后选择 **粘贴**。

### 压缩文件

1. 在文件管理器界面，右键单击文件（夹）。
2. 选择 **压缩**。
3. 弹出归档管理器压缩界面，可以设置压缩包格式、名称、存储路径等，单击 **压缩**。

> ![tips](../common/tips.svg) 窍门：您也可以直接在右键菜单中选择 **添加到xxx.7z** 或 **添加到xxx.zip**，快速将文件（夹）压缩成7z或zip格式。

### 删除文件

1. 在文件管理器界面，右键单击文件。
2. 选择 **删除** 。
   - 被删除的文件可以在回收站中找到，右键单击回收站中的文件可以进行 **还原** 或 **删除** 操作。外接设备删除文件会将文件彻底删除，无法从回收站找回。
   - 被删除的文件的快捷方式将会失效。

> ![notes](../common/notes.svg) 说明：您可以在 **主菜单 > 设置 > 高级设置** 中勾选 **开启普通删除提示**，每次删除文件时会弹出确认删除的提示框。

### 撤销操作

在文件管理器中，可以用 **Ctrl + Z** 来撤销上一步操作，包括：

- 删除新建的文件。
- 恢复重命名（包括重命名文件后缀）之前的名字。
- 从回收站还原刚删除的文件。
- 恢复文件到移动（剪切移动、鼠标移动）前的原始路径。
- 删除复制粘贴的文件。

>![attention](../common/attention.svg) 注意：撤销动作最多只能返回两步；如果操作中有覆盖某个同名文件和彻底删除文件，则撤销只能返回到这一步。

### 文件属性

文件属性会显示文件的基本信息，打开方式和权限设置。文件夹属性会显示文件夹的基本信息，共享信息和权限设置。

1. 在文件管理器界面，右键单击文件。
2. 选择 **属性**，查看文件属性。

![2|info](fig/info.png)

> ![notes](../common/notes.svg) 说明：查看多个文件属性会显示文件总大小和数量；查看快捷方式的属性将会额外显示源文件地址。您还可以使用 **Ctrl + I** 组合键查看文件属性。


### 

## 常用操作

文件管理器具备很多特色功能，这些功能都让文件管理更加简单、高效。

### 切换地址栏

地址栏由历史导航、面包屑和输入框共同组成，通常情况下地址栏显示面包屑。

![0|addressbar](fig/addressbar1.png)

- 单击历史导航按钮，可以快速在历史浏览记录间切换，查看前一个地址或者后一个地址。
- 文件所在位置的每一个层级都会形成一个面包屑，通过来回单击面包屑可以快速在不同文件层级间切换。
- 鼠标悬停在其中一个面包屑上，点击下箭头展开路径层级，单击某一级路径跳转到对应文件目录。

![](fig/addressbar2.png)

单击地址栏空白处，地址栏会切换为输入框状态。在输入框外单击时，地址栏会自动恢复到面包屑状态。

<img src="fig/addressbar3.png" alt="0|addressbar" style="zoom: 67%;" />



### 搜索文件

使用快捷键  **Ctrl + F** 或在地址栏中单击搜索按钮进入搜索状态，输入关键词后将立即开始文件搜索，搜索相关文件。

![](fig/search_button.png)

文件管理器支持多种检索方式，既支持通过文件名称、文件内容进行普通搜索，也支持通过文件类型、创建时间等进行高级搜索，提高工作效率，便于文件管理。

- 指定目录搜索时，请先进入该目录，然后再进行搜索。
- 如果您想搜索多个关键词，可以在搜索框中输入多个词语并用空格分隔。

> ![notes](../common/notes.svg) 说明：在文件管理器的 **设置** 中，默认勾选了“自动索引内置磁盘”，您可以选择勾选“连接电脑后索引外部存储设备”，加快在外部设备的搜索速度。

#### 全文搜索

您可以通过文件内容关键字来搜索文件。

![](fig/search1.png)

功能关闭时，您可以在设置中开启。

1. 在文件管理器中，单击 ![icon_menu](../common/icon_menu.svg) > **设置**。
2. 在“高级设置->搜索”中勾选“全文搜索”来开启此功能。

![](fig/search2.png)

#### 高级搜索

当文件较多，搜索较慢时，启用高级搜索缩小搜索范围，提高搜索效率。
1. 在搜索状态下，输入关键字后按 **Enter** 键，当搜索到结果时，搜索框右侧显示图标 ![filter](../common/filter.svg)，单击该图标可进行高级搜索的操作。
2. 选择搜索范围、文件大小、文件类型、修改时间、访问时间和创建时间，进行更精准的搜索。

![0|filter](fig/p_filter.png)


### 最近使用

在左侧导航栏上默认有 **最近使用** 入口，单击可以查看最近使用的文件。文件默认按照访问时间倒序排列。

> ![notes](../common/notes.svg) 说明：若想隐藏“最近使用”，可在 **设置** > **基本设置** > **隐藏文件**，取消勾选“显示最近使用文件”。若要隐藏某一个文件的访问记录，右键单击该文件选择 **移除**，该操作不会删除文件。

### 多标签页

文件管理器支持多标签页显示。

* 在标签页栏单添加按钮 + ，添加新标签页。
* 将鼠标指针置于标签页上，单击关闭按钮 × 或单击鼠标中键，关闭标签页。

![1|tab](fig/tab1.png)

您也可以将工作区的文件夹在新标签页中打开。

1. 在文件管理器界面，右键单击文件夹。
2. 选择 **在新标签中打开**。

![1|tab](fig/p_tab.png)

### 书签管理

为常用文件（夹）添加书签，以便从左侧导航栏快速访问。

- 添加书签：右键单击文件夹，选择 **添加到快捷访问** 在导航栏创建书签。
- 移动书签：在导航栏上下拖动书签调整排序。
- 删除书签：右键单击书签，选择 **从快捷访问移除** 来删除书签。

### 标记信息

通过给文件（夹）添加标记，可以更好地分类管理您的文件。

> ![notes](../common/notes.svg) 说明：仅x86平台支持标记信息功能。

#### 添加标记

您可以为一个文件（夹）添加多个标记，也可以同时为多个文件（夹）添加标记；添加成功的标记会出现在左侧导航栏内。

##### 通过编辑框添加标记

1. 右键单击文件（夹），选择 **标记信息**。
2. 输入标记名称，若要添加多个标记，可用逗号分隔。
3. 单击界面空白区域保存设置。

>![notes](../common/notes.svg) 说明：标记颜色从8种默认颜色中随机分配。

![1|tag_info](fig/p_tag_info.png)


##### 通过颜色按钮添加标记

右键单击文件（夹），选择颜色按钮，直接生成这个颜色的标记。

![1|color_tag](fig/p_color_tag.png)

##### 通过右侧信息栏添加标记

选择文件（夹）后，在标题栏视图选项中勾选显示预览，在右侧信息栏中也可以添加标记。

![1|info_tag](fig/p_info_tag.png)

>![notes](../common/notes.svg) 说明：如果文件有标记，则复制或剪切该文件产生的文件仍然具有同样的标记。


#### 重命名标记

在侧边导航栏中，右键单击某个标记，选择 **重命名**，修改当前标记的名称。

![1|rename_tag](fig/rename_tag.png)

#### 修改标记颜色

在左侧导航栏中，右键单击某个标记，选择颜色按钮，即可修改当前标记的颜色。

#### 排序标记

上下拖动标记即可调整标记排序。

#### 删除标记

右键单击某个标记，选择 **移除**，删除当前标记。


### 文件预览

文件管理器支持空格键预览功能，选中文件并按下键盘上的空格键可以快速预览文件。在预览窗口中可以查看图片分辨率、文档大小、文本内容等，还支持gif、音频、视频播放。

#### 预览视频

1. 选择您要预览的视频文件，按下空格键，即可开始预览。
2. 单击视频任意地方可暂停播放。
3. 播放过程中，可以拖动进度条来快进快退。
4. 单击底部 **打开** 按扭，在默认程序中打开该视频文件。

![1|video_preview](fig/video_preview.png)

> ![notes](../common/notes.svg) 说明：您也可以同时选择多个文件，按下空格键进行预览。


### 权限管理

选择对应文件（夹），单击右键，选择属性，单击 **权限管理**， 为所有者、群组和其他用户设置文件权限。

![2|permission](fig/permission.png)

### 我的共享

当设置了共享文件时，“我的共享”会出现在左侧导航栏上。

#### 共享本地文件

共享本地文件，方便局域网中的用户进行信息互动及资源共享等操作，提升办公效率。

共享文件需要启动smb服务，首次使用文件共享功能时，系统会弹出“启动smb服务认证”窗口，输入登录密码完成认证即可开启smb服务。

1. 在文件管理器界面，右键单击文件夹，选择 **共享文件夹**。
2. 弹出文件夹属性窗口，在共享管理区域中勾选 **共享此文件夹**。
3. 设置文件共享名、权限和是否允许匿名访问。
4. 单击 **设置密码**。
4. 弹出“输入共享密码”窗口，输入密码，单击 **确定**。

当设置了共享密码后，界面会显示“修改密码”，您可以在此修改共享密码，或者在文件管理器主菜单中单击 **设置共享密码** ，修改共享密码。


> ![tips](../common/tips.svg) 窍门：单击网络路径和用户名右侧的复制按钮 ![icon](../common/copy.svg)， 将访问路径和用户名复制到剪贴板，便于您将信息分享给访问者。

![2|share](fig/share1.png)


#### 访问共享文件

局域网中的用户可以通过共享者提供的网络路径访问共享文件。

1. 通过以下方法之一，连接服务器地址。
   - 直接在地址栏中输入服务器地址（例如：smb://10.0.2.15），按下键盘上的 **Enter** 键。
   - 单击 ![icon_menu](../common/icon_menu.svg) > **连接到服务器**，输入服务器地址，单击 **连接**。
2. 选择需要访问的共享文件夹，弹出“要分享10.0.2.15上的XX需要密码”的窗口。
   - 如果文件夹不允许匿名访问，在“注册用户”页签中输入共享者的系统用户名和共享密码。
   - 如果文件夹允许匿名访问，在"注册用户"页签中输入共享者的系统用户名和共享密码；在“匿名”页签中则不需要输入用户名和密码。
3. 勾选是否记住密码，单击 **连接**。

![1|visitshareshare](fig/visitshare.png)


#### 取消共享文件

当取消了所有共享文件后，左侧导航栏上“我的共享”则会移除，您可以通过以下方法之一取消本地共享文件。

- 右键单击已共享的文件夹，选择 **取消共享**。
- 右键单击已共享的文件夹，选择 **属性**，在属性窗口共享管理区域中取消勾选 **共享此文件夹**。

### 以管理员身份打开

前提条件：“控制中心”>“通用”中开发者模式已打开。

1. 在文件管理器中，右键单击文件夹。
2. 选择 **以管理员身份打开**，在弹窗中输入用户登录密码，单击 **确定**。
3. 该文件夹会以新窗口打开，在此窗口中可以进行高级权限的操作，关闭窗口后，终止管理员权限。

### 在终端中打开

1. 在文件管理器中，单击鼠标右键。
2. 选择 **在终端中打开**，会启动终端应用程序，终端的路径为当前目录。

![0|open_terminal](fig/open_terminal.png)

### 刻录光盘

您可以通过刻录功能将音乐、视频、图片或镜像文件等刻录至CD或DVD光盘中。请准备一张CD或DVD光盘和一台具备刻录功能的设备，才能执行如下操作。

<table class=block1>
<tr>
   <th align=left>类型</th>
   <th align=left>光盘格式</th>
   <th align=left>ISO9660</th>
   <th align=left>UDF</th>
</tr>
<tr>
   <td rowspan="2">空盘</td>
   <td>DVD-R、DVD+R、CD-R、CD-RW</td>
   <td>支持</td>
   <td>支持</td>
</tr>
<tr>
   <td>非DVD-R、DVD+R、CD-R、CD-RW</td>
   <td>支持</td>
   <td>不支持</td>
</tr>
<tr>
   <td rowspan="2">非空盘</td>
   <td>DVD-R、DVD+R、CD-R、CD-RW</td>
   <td>支持追加文件</td>
   <td>仅支持Windows原生工具刻录的格式</td>
</tr>
<tr>
   <td>非DVD-R、DVD+R、CD-R、CD-RW</td>
   <td>支持追加文件</td>
   <td>不支持追加文件</td>
</tr>   
</table>


#### 刻录本地文件

1. 在文件管理器界面，单击导航栏中的光盘图标，进入光盘刻录界面。

2. 将需要刻录的文件（夹）拖拽至光盘刻录界面，或右键单击 文件（夹），选择 **添加至光盘刻录**。
3. 单击界面右上角 **刻录** 按钮。
4. 弹出“光盘名称”窗口，输入光盘名称。您也可以单击 **高级设置** 进入高级设置界面，设置文件系统、写入速度，或勾选“允许追加数据”、“核验数据”等，单击 **刻录**。

5. 弹出“刻录完成”提示框，单击 **确定** 完成刻录。

#### 擦除光盘

1. 在文件管理器界面，右键单击导航栏中的光盘图标。
2. 选择 **卸载**，再次右键单击该光盘图标并选择 **擦除**。
3. 弹出“确定擦除光盘内容”提示框，单击 **擦除**。

#### 存为镜像文件

1. 在文件管理器界面，单击导航栏中的光盘图标，进入光盘刻录界面。

2. 单击界面右上角 **存为镜像文件** 按钮，弹出“存为镜像文件”窗口。

3. 您可以选择指定路径后单击 **创建镜像**，完成光盘镜像文件的保存。

### 创建快捷方式

1. 在文件管理器界面，右键单击文件（夹）。
2. 选择 **创建链接**。
3. 在弹窗中选择创建位置、链接名称。
4. 单击 **保存**，在目标位置会生成该文件（夹）的快捷方式。

> ![tips](../common/tips.svg) 窍门：选择 **发送到桌面** 可以直接在桌面上生成该文件（夹）的快捷方式。

### 发送文件（夹）到外接磁盘

当有外接磁盘接入时，您可以将文件或文件夹发送到外接磁盘。

1. 在文件管理器界面，右键单击需要发送的文件（夹）。
2. 选择 **发送到** > 外接磁盘。
3. 文件（夹）将会被发送到移动外接磁盘。

### 发送文件到蓝牙

如果您的电脑配置了蓝牙模块，便可通过蓝牙进行短距离文件传输的操作。

前提条件：发送端与接收端蓝牙设备已配对并成功连接。具体连接方法请参阅 [连接蓝牙设备](dman:///dde#连接蓝牙设备)。

1. 在文件管理器界面，右键单击需要发送的文件或文件压缩包。
2. 选择 **发送到** > **发送到蓝牙**。
3. 在蓝牙文件传输窗口中勾选接收设备，单击 **下一步**。
4. 此时接收端会收到文件接收的请求，待接收端同意请求后，发送端开始传输文件。



## 文件角标

您可以通过命令行，将图标文件指定给一个文件或文件夹作为角标显示出来。

>![icon](../common/notes.svg) 说明：
>- 角标文件支持svg、jpg、png、bmp、gif格式，且大小不超过100KB。
>- U盘及光盘下的文件，不支持添加角标。

### 添加单个角标

1. 在终端输入命令 **gio set xxx(文件路径)  -t stringv metadata::emblems "xxx(图标路径)"** ，该命令默认在文件（夹）右下角添加角标。

   >![icon](../common/attention.svg) 注意：系统已定义的特殊角标，不支持被替换。

2. 您也可以在上述命令中加入位置参数，将角标添加在文件（夹）的左上角（lu）、左下角（ld）、右上角（ru）或右下角（rd）。

   例如：在文件（夹）左上角添加角标

   **gio set xxx(文件路径)  -t stringv metadata::emblems "xxx(图标路径);lu"**



### 添加多个角标

在命令行中加入“**|**”符号将角标文件路径链接起来，为文件（夹）添加2~4个角标。文件（夹）同一个位置不支持叠加角标，仅支持替换。

例如：在文件（夹）四个角都添加角标

**gio set xxx(文件路径)  -t stringv metadata::emblems "xxx(图标路径);lu|xxx(图标路径);ld|xxx(图标路径);ru|xxx(图标路径);rd"**



### 撤销角标

在终端中输入命令 **gio set xxx(文件路径) -t stringv metadata::emblems ""** 撤销文件（夹）上所有的角标。



## 文件保险箱

文件保险箱旨在为您打造专属的安全空间，为您的隐私保驾护航。

### 加密保险箱

保险箱现提供两种加密方式，分别为 **密钥加密** 和 **透明加密**，新增的 **透明加密** 提供了无需输入保险箱密码，即可访问保险箱的便捷加密方式，该加密方式同样确保了保险箱内文件的安全。

#### 透明加密

1. 单击导航栏中的保险箱图标 ![file_vault](../common/file_vault.svg)，或者在计算机界面双击 “我的保险箱”，在弹出的对话框中单击 **开启**。 
2. 在“加密方式”下，选择 **透明加密** 后单击 **下一步**，直接加密保险箱。

![encrypt](fig/transparent_encryption.png)

#### 密钥加密

1. 单击导航栏中的保险箱图标 ![file_vault](../common/file_vault.svg)，或者在计算机界面双击 “我的保险箱”，在弹出的对话框中单击 **开启**。 
2. 加密方式默认为 **密钥加密**，可设置保险箱密码和密码提示信息，单击 **下一步**。

![encrypt](fig/key_encryption.png)

   > ![notes](../common/notes.svg) 说明: 密码必须同时包含大写字母、小写字母、数字和符号，且字符不小于8位，否则无法进入下一步。

3. 在保存密钥文件窗口中，设置密钥文件的存储位置，单击 **下一步**。如果您忘记了保险箱密码，可使用密钥文件找回密码。

![encrypt](fig/save.png)

4. 单击 **加密保险箱**，弹出认证窗口，输入用户登录密码后单击 **确定**。

![encrypt](fig/encrypt.png)

5. 在加密完成窗口中单击 **确定**， 完成保险箱密码设置。

![encrypt](fig/finish.png)

### 锁定保险箱

将文件放入保险箱后，右键单击 ![file_vault](../common/file_vault.svg) 或者在计算机界面右键单击 **我的保险箱**。
- 选择 **立即上锁**，立即将文件保险箱锁上。
- 选择 **自动上锁**，在其下拉选项中：
  + 选择“从不”，计算机在锁屏或关机前一直保持未上锁状态。
  + 选择“5分钟”、“10分钟”或者“20分钟”后自动上锁保险箱。

![0|right](fig/right.png)


### 解锁保险箱

1. 单击 ![file_vault](../common/file_vault.svg) 或者在计算机界面双击 **我的保险箱**。
2. 在解锁保险箱窗口中，输入保险箱密码，单击 **解锁**。
3. 如果忘记了保险箱密码，单击 **忘记密码**，选择密钥文件的存储位置后，单击 **验证密钥** 找回密码。

![encrypt](fig/unlock.png)


>![0|tips](../common/tips.svg) 窍门：您也可以右键单击 ![file_vault](../common/file_vault.svg) 或者 **我的保险箱**，选择 **解锁**，解锁保险箱。


### 删除保险箱

删除保险箱需要提前解锁保险箱。
1. 右键单击 ![file_vault](../common/file_vault.svg) 或者 **我的保险箱**，选择 **删除保险箱**。
2. 弹出删除保险箱窗口，输入保险箱密码，单击 **删除**。
3. 在认证窗口中输入用户登录密码，单击 **确定** 完成操作。
> ![attention](../common/attention.svg) 注意：删除保险箱会将里面的文件永久删除，在进行删除操作前，请将保险箱中的文件备份。

## 磁盘管理

文件管理器管理本地磁盘和外接磁盘。本地磁盘显示在文件管理器的左侧导航栏上或计算机界面；挂载外接磁盘或者插入其他移动存储设备时，也会在导航栏看到相应的磁盘图标。

<table class=block1>
    <caption></caption>
    <tbody>
        <tr>
            <td>本地磁盘</td>
            <td>本地硬盘分区的所有磁盘</td>
        </tr>
        <tr>
            <td>外接磁盘</td>
            <td>包括移动硬盘、U盘、光盘</td>
        </tr>
    	<tr>
            <td>移动设备</td>
            <td>手机内存、存储卡、SD卡等</td>
        </tr>
    </tbody>
</table>



> ![notes](../common/notes.svg) 说明：如果磁盘或磁盘中的文件夹已加密，请输入密码后查看文件。

### 本地磁盘

#### 隐藏内置磁盘

1. 在文件管理器界面，单击 ![icon_menu](../common/icon_menu.svg) > **设置**。
2. 在高级设置选项中勾选 **计算机工作区隐藏内置磁盘** 。在高级设置 > 侧边栏显示项目 中取消勾选 **内置磁盘** 。

#### 重命名本地磁盘

1. 在左侧导航栏或计算机界面，右键单击本地磁盘。
2. 选择 **重命名**。
3. 输入新名称，按下键盘上的 **Enter** 键或单击空白处保存修改。

> ![tips](../common/tips.svg) 窍门：在计算机界面，慢速双击本地磁盘，呈现编辑框后便可进行重命名操作。

![0|disk](fig/p_rename_disk.png)

### 外接磁盘

#### 弹出外接磁盘

1. 在左侧导航栏或计算机界面，右键单击需要移除的磁盘。
2. 选择 **安全移除**。
3. 磁盘将从磁盘列表中删除，一并弹出该磁盘的所有分区。

![0|disk](fig/disk1.png)

> ![tips](../common/tips.svg) 窍门：如果要弹出光盘，请选择 **弹出** 来移除光盘。单击导航栏中磁盘右边的按钮 ![unmount](../common/unmount_normal.svg) 同样可以弹出磁盘或光盘。

#### 重命名外接磁盘

1. 在左侧导航栏或计算机界面，右键单击需要重命名的磁盘。
2. 选择 **卸载**后，再次单击右键选择 **重命名**。
3. 输入新的卷标名称，按下键盘上的 **Enter** 键或单击空白处保存修改。



#### 格式化外接磁盘

1. 在左侧导航栏或计算机界面，右键单击需要格式化的磁盘。
2. 选择 **卸载** 后，再次单击右键选择 **格式化**。
3. 设置格式化之后的文件类型和卷标。
4. 单击 **格式化**。

![0|disk](fig/disk2.png)

> ![notes](../common/notes.svg) 说明：快速格式化速度快，但是数据仍然可能通过工具被恢复，如果想要格式化后的数据无法被恢复，可以取消勾选“快速格式化”，然后执行格式化操作。



## 主菜单

在主菜单中，您可以新建窗口、切换窗口主题、连接到服务器、[设置共享密码](#共享本地文件)、设置文件管理器、查看帮助手册和版本介绍。

### 新建窗口

1. 在文件管理器界面，单击 ![icon_menu](../common/icon_menu.svg)。
2. 选择 **新建窗口**，打开一个新的文件管理器窗口。

### 连接到服务器

通过连接服务器 [访问共享文件](#访问共享文件)。

1. 在文件管理器界面，单击 ![icon_menu](../common/icon_menu.svg)> **连接到服务器**。
2. 弹出“连接到服务器”窗口，在协议下拉框中，选择一种连接协议；在地址栏输入服务器IP地址。
   
   >![0|tips](../common/tips.svg) 窍门：您可以单击 ![icon](../common/collect.svg) ，将常用服务器地址添加到“我收藏的服务器”列表中。
   
3. 单击 **连接**。

![connect](fig/connect_to_server.png)


### 设置
在文件管理器界面，单击 ![icon_menu](../common/icon_menu.svg)> **设置**，可以进行基础设置和高级设置。

#### 基础设置

**打开行为**

设置是否 **总是在新窗口打开文件夹**、**双击 **或 **单击** 打开文件。设置打开重复文件夹时，是否激活已打开的窗口。

**新窗口和新标签**

设置 **从默认窗口打开**、**从新标签打开** 某个目录。

**文件和目录**

勾选 **显示隐藏文件**，文件管理器中被隐藏的文件会显示出来。

勾选 **显示文件扩展名**，显示文件后缀名。

勾选 **文件和文件夹混合排序**，同一个目录下文件和文件夹将混合在一起排序。

![setting](fig/basic_setting.png)

#### 侧边栏

**侧边栏显示项目**

设置侧边栏快捷访问、分区、网络、标记4个分组下显示的项目，勾选后在侧边栏显示，取消勾选则在侧边栏隐藏。



#### 工作区

**视图**

设置文件图标 **默认大小** 、**默认视图**、是否将 **文件或文件夹混合排序**。

**缩略图预览**

设置预览文件类型。

**计算机显示项目**

设置计算机目录显示的分区目录和标签。




#### 高级设置

**搜索**

- 勾选 **全文搜索**，通过文件中的内容来索引。文件索引自动更新，单击 **立即更新索引** 可以手动刷新。

**挂载**

- 勾选 **自动挂载**，接入外接磁盘时自动挂载。
- 勾选 **自动挂载后打开**，接入外接磁盘时自动挂载并打开该磁盘。
- 勾选 **Samba共享端常驻显示挂载入口**，远程挂载链接常驻显示在导航栏中。
- 勾选 **合并显示Samba共享目录入口**，侧边栏将聚合显示同一IP下的smb目录。

**对话框**

- 勾选 **使用文件管理器的文件选择对话框**，选择文件时打开文件管理器窗口；
- 勾选 **开启普通删除提示**，删除文件时弹出提示对话框。

**文件投送**

- 点击 **文件投送设置**，设置投送权限和文件保存位置。



### 主题

窗口主题包含浅色主题、深色主题和跟随系统主题。

1. 在文件管理器界面，单击 ![icon_menu](../common/icon_menu.svg)。
2. 选择 **主题**，选择一个主题。

### 帮助

查看帮助手册，进一步了解和使用文件管理器。

1. 在文件管理器界面，单击 ![icon_menu](../common/icon_menu.svg)。
2. 选择 **帮助**。
3. 查看文件管理器的帮助手册。


### 关于

1. 在文件管理器界面，单击 ![icon_menu](../common/icon_menu.svg)。
2. 选择 **关于**。
3. 查看文件管理器的版本和介绍。


### 退出

1. 在文件管理器界面，单击 ![icon_menu](../common/icon_menu.svg)。
2. 选择 **退出**。
