;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: wasm-opt %s -all --precompute -S -o - | filecheck %s

(module

  ;; CHECK:      (type $shared-func (shared (func (result (ref null (shared func))))))
  (type $shared-func (shared (func (result (ref null (shared func))))))

  ;; CHECK:      (type $func (func (result funcref)))
  (type $func (func (result funcref)))

  ;; CHECK:      (type $2 (func (result (ref $shared-func))))

  ;; CHECK:      (elem declare func $test $test-shared)

  ;; CHECK:      (func $test (type $func) (result funcref)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (ref.func $test)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test (type $func) (result funcref)
    (block
      (return
        (ref.func $test)
      )
    )
  )

  ;; CHECK:      (func $test-shared (type $shared-func) (result (ref null (shared func)))
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (ref.func $test-shared)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test-shared (type $shared-func)
    (block
      (return
        (ref.func $test-shared)
      )
    )
  )

  ;; CHECK:      (func $precompute-nested-brs (type $2) (result (ref $shared-func))
  ;; CHECK-NEXT:  (ref.func $test-shared)
  ;; CHECK-NEXT: )
  (func $precompute-nested-brs (result (ref $shared-func))
    ;; We have two nested brs here, and we can precompute it all. While doing so
    ;; we must not get confused between the targets and values: one sends a
    ;; shared func, the other a normal func, so the types are different, and any
    ;; mistake there will fail validation (say, if we reused the ref.func from
    ;; the inner br when generating the outer one).
    (block $shared (result (ref $shared-func))
      (drop
        (block $func (result (ref $func))
          (br_if $func
            (ref.func $test)
            (br $shared
              (ref.func $test-shared)
            )
          )
        )
      )
      (ref.func $test-shared)
    )
  )
)
