.\"
.\" Copyright (c) 2015 Svyatoslav Mishyn <juef@openmailbox.org>
.\"
.\" Permission to use, copy, modify, and/or distribute this software for
.\" any purpose with or without fee is hereby granted, provided that the
.\" above copyright notice and this permission notice appear in all
.\" copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
.\" AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
.\" DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
.\" PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.Dd September 11, 2015
.Dt TCLSOLDOUT n
.Os
.Sh NAME
.Nm TclSoldout
.Nd Markdown parser
.Sh SYNOPSIS
.Cm package require TclSoldout Op 0.1.1
.Pp
.Cm ::soldout::escape_html
.Ar string
.Pp
.Cm ::soldout::mkd2html
.Op Fl discount | natext
.Ar markdown
.Pp
.Cm ::soldout::mkd2xhtml
.Op Fl discount | natext
.Ar markdown
.Sh DESCRIPTION
The
.Nm
extension is a Tcl binding to libsoldout, a lightweight C library that can parse
Markdown.
.Pp
The
.Cm ::soldout::escape_html
command replace '<', '>', '&' and '"' in the
.Ar string
with their HTML entities and return the modified text.
.Pp
The
.Cm ::soldout::mkd2html
command parse
.Ar markdown
text and return HTML (self-closing tags are rendered like this: <br>).
.Pp
The
.Cm ::soldout::mkd2xhtml
command parse
.Ar markdown
text and return XHTML (self-closing tags like: <br />).
.Pp
The options are as follows:
.Bl -tag -width Ds
.It Fl discount
enable Discount extensions:
.Bl -bullet -width 1m
.It
image size specification, by appending "=(width)x(height)" to the link
.It
pseudo-protocols in links:
.Bl -bullet -width 1m
.It
abbr:description for <abbr title="description">...</abbr>
.It
class:name for <span class="name">...</span>
.It
id:name for <span id="name">...</span>
.It
raw:text for verbatim unprocessed text inclusion
.El
.It
class blocks: blockquotes beginning with %class% will be rendered as a div of
the given class(es)
.El
.Pp
and PHP-Markdown-like tables.
.It Fl natext
enable Discount extensions and Natasha's own extensions:
.Bl -bullet -width 1m
.It
id attribute for headers, using the syntax id#Header text
.It
class attribute for paragraphs, by putting class name(s) between parenthesis
at the very beginning of the paragraph
.It
<ins> and <del> spans, using respectively ++ and -- as delimiters (with
emphasis-like restrictions, i.e. an opening delimiter cannot be followed by a
whitespace, and a closing delimiter cannot be preceded by a whitespace)
.It
plain <span> without attribute, using emphasis-like delimiter |
.El
.El
.Sh SEE ALSO
.Lk https://github.com/faelys/libsoldout libsoldout
.Sh AUTHORS
.Nm
was written by
.An Svyatoslav Mishyn Aq Mt juef@openmailbox.org .
