# settle

`settle` is a CLI tool that helps you manage your digital Zettelkasten.

## Getting started

### Requirements

* cargo/rust toolchain (for building)
* SQLite (for running)

### Installation

There's a Rust crate available, so you can simply run:

```
cargo install settle
```

### Overview

- [full usage manual](./doc/SETTLE_MANUAL.md), with technical descriptions of
    every command
    - includes [instructions on setting up shell command
        autocompletion](./doc/SETTLE_MANUAL.md#shell-autocompletion)
- [project motivation](./doc/history.md)
- [design principles](./doc/design-principles.md)
- [configuration](./doc/configuration.md)
- [tags and subtags](./doc/tags-and-subtags.md)
- [links and backlinks](./doc/links-and-backlinks.md)
- [creating new notes (with templates as well)](./doc/creating-notes.md)
- [keeping the database up to date](./doc/keeping-the-database-up-to-date.md)
- [projects](./doc/projects.md)
    - [moving notes between projects](./doc/moving-notes-between-projects.md)
- [renaming notes](./doc/renaming-notes.md)
- [query, search and filter](./doc/query-search-and-filter.md)
    - [interactively visualise your Zettelkasten](./doc/vizk.md), inspired by
        [Obsidian MD's Graph View](https://help.obsidian.md/Plugins/Graph+view)
    - [exporting your Zettelkasten to a graph format](./doc/graphs.md)

## Contributing

Pull requests are welcome. For any minor or major changes, you can open an issue
to discuss what you would like to change.

<!--
Please make sure to update tests as appropriate.
-->

## License

[MIT](LICENSE)
