/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2016  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_PRONUNCIATION_RULE_H
#define NJD_SET_PRONUNCIATION_RULE_H

#ifdef __cplusplus
#define NJD_SET_PRONUNCIATION_RULE_H_START extern "C" {
#define NJD_SET_PRONUNCIATION_RULE_H_END   }
#else
#define NJD_SET_PRONUNCIATION_RULE_H_START
#define NJD_SET_PRONUNCIATION_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_PRONUNCIATION_RULE_H_START;

static const char *njd_set_pronunciation_list[] = {
   "ヴョ", "ヴョ", "1",
   "ヴュ", "ヴュ", "1",
   "ヴャ", "ヴャ", "1",
   "ヴォ", "ヴォ", "1",
   "ヴェ", "ヴェ", "1",
   "ヴィ", "ヴィ", "1",
   "ヴァ", "ヴァ", "1",
   "ヴ", "ヴ", "1",
   "ン", "ン", "1",
   "ヲ", "ヲ", "1",
   "ヱ", "ヱ", "1",
   "ヰ", "ヰ", "1",
   "ワ", "ワ", "1",
   "ロ", "ロ", "1",
   "レ", "レ", "1",
   "ル", "ル", "1",
   "リョ", "リョ", "1",
   "リュ", "リュ", "1",
   "リャ", "リャ", "1",
   "リェ", "リェ", "1",
   "リ", "リ", "1",
   "ラ", "ラ", "1",
   "ヨ", "ヨ", "1",
   "ョ", "ョ", "1",
   "ユ", "ユ", "1",
   "ュ", "ュ", "1",
   "ヤ", "ヤ", "1",
   "ャ", "ャ", "1",
   "モ", "モ", "1",
   "メ", "メ", "1",
   "ム", "ム", "1",
   "ミョ", "ミョ", "1",
   "ミュ", "ミュ", "1",
   "ミャ", "ミャ", "1",
   "ミェ", "ミェ", "1",
   "ミ", "ミ", "1",
   "マ", "マ", "1",
   "ポ", "ポ", "1",
   "ボ", "ボ", "1",
   "ホ", "ホ", "1",
   "ペ", "ペ", "1",
   "ベ", "ベ", "1",
   "ヘ", "ヘ", "1",
   "プ", "プ", "1",
   "ブ", "ブ", "1",
   "フォ", "フォ", "1",
   "フェ", "フェ", "1",
   "フィ", "フィ", "1",
   "ファ", "ファ", "1",
   "フ", "フ", "1",
   "ピョ", "ピョ", "1",
   "ピュ", "ピュ", "1",
   "ピャ", "ピャ", "1",
   "ピェ", "ピェ", "1",
   "ピ", "ピ", "1",
   "ビョ", "ビョ", "1",
   "ビュ", "ビュ", "1",
   "ビャ", "ビャ", "1",
   "ビェ", "ビェ", "1",
   "ビ", "ビ", "1",
   "ヒョ", "ヒョ", "1",
   "ヒュ", "ヒュ", "1",
   "ヒャ", "ヒャ", "1",
   "ヒェ", "ヒェ", "1",
   "ヒ", "ヒ", "1",
   "パ", "パ", "1",
   "バ", "バ", "1",
   "ハ", "ハ", "1",
   "ノ", "ノ", "1",
   "ネ", "ネ", "1",
   "ヌ", "ヌ", "1",
   "ニョ", "ニョ", "1",
   "ニュ", "ニュ", "1",
   "ニャ", "ニャ", "1",
   "ニェ", "ニェ", "1",
   "ニ", "ニ", "1",
   "ナ", "ナ", "1",
   "ドゥ", "ドゥ", "1",
   "ド", "ド", "1",
   "トゥ", "トゥ", "1",
   "ト", "ト", "1",
   "デョ", "デョ", "1",
   "デュ", "デュ", "1",
   "デャ", "デャ", "1",
   "ディ", "ディ", "1",
   "デ", "デ", "1",
   "テョ", "テョ", "1",
   "テュ", "テュ", "1",
   "テャ", "テャ", "1",
   "ティ", "ティ", "1",
   "テ", "テ", "1",
   "ヅ", "ヅ", "1",
   "ツォ", "ツォ", "1",
   "ツェ", "ツェ", "1",
   "ツィ", "ツィ", "1",
   "ツァ", "ツァ", "1",
   "ツ", "ツ", "1",
   "ッ", "ッ", "1",
   "ヂ", "ヂ", "1",
   "チョ", "チョ", "1",
   "チュ", "チュ", "1",
   "チャ", "チャ", "1",
   "チェ", "チェ", "1",
   "チ", "チ", "1",
   "ダ", "ダ", "1",
   "タ", "タ", "1",
   "ゾ", "ゾ", "1",
   "ソ", "ソ", "1",
   "ゼ", "ゼ", "1",
   "セ", "セ", "1",
   "ズィ", "ズィ", "1",
   "ズ", "ズ", "1",
   "スィ", "スィ", "1",
   "ス", "ス", "1",
   "ジョ", "ジョ", "1",
   "ジュ", "ジュ", "1",
   "ジャ", "ジャ", "1",
   "ジェ", "ジェ", "1",
   "ジ", "ジ", "1",
   "ショ", "ショ", "1",
   "シュ", "シュ", "1",
   "シャ", "シャ", "1",
   "シェ", "シェ", "1",
   "シ", "シ", "1",
   "ザ", "ザ", "1",
   "サ", "サ", "1",
   "ゴ", "ゴ", "1",
   "コ", "コ", "1",
   "ゲ", "ゲ", "1",
   "ケ", "ケ", "1",
   "グ", "グ", "1",
   "ク", "ク", "1",
   "ギョ", "ギョ", "1",
   "ギュ", "ギュ", "1",
   "ギャ", "ギャ", "1",
   "ギェ", "ギェ", "1",
   "ギ", "ギ", "1",
   "キョ", "キョ", "1",
   "キュ", "キュ", "1",
   "キャ", "キャ", "1",
   "キェ", "キェ", "1",
   "キ", "キ", "1",
   "ガ", "ガ", "1",
   "カ", "カ", "1",
   "オ", "オ", "1",
   "ォ", "ォ", "1",
   "エ", "エ", "1",
   "ェ", "ェ", "1",
   "ウォ", "ウォ", "1",
   "ウェ", "ウェ", "1",
   "ウィ", "ウィ", "1",
   "ウ", "ウ", "1",
   "ゥ", "ゥ", "1",
   "イェ", "イェ", "1",
   "イ", "イ", "1",
   "ィ", "ィ", "1",
   "ア", "ア", "1",
   "ァ", "ァ", "1",
   "ゔょ", "ヴョ", "1",
   "ゔゅ", "ヴュ", "1",
   "ゔゃ", "ヴャ", "1",
   "ゔぉ", "ヴォ", "1",
   "ゔぇ", "ヴェ", "1",
   "ゔぃ", "ヴィ", "1",
   "ゔぁ", "ヴァ", "1",
   "ゔ", "ヴ", "1",
   "ん", "ン", "1",
   "を", "ヲ", "1",
   "ゑ", "ヱ", "1",
   "ゐ", "ヰ", "1",
   "わ", "ワ", "1",
   "ろ", "ロ", "1",
   "れ", "レ", "1",
   "る", "ル", "1",
   "りょ", "リョ", "1",
   "りゅ", "リュ", "1",
   "りゃ", "リャ", "1",
   "りぇ", "リェ", "1",
   "り", "リ", "1",
   "ら", "ラ", "1",
   "よ", "ヨ", "1",
   "ょ", "ョ", "1",
   "ゆ", "ユ", "1",
   "ゅ", "ュ", "1",
   "や", "ヤ", "1",
   "ゃ", "ャ", "1",
   "も", "モ", "1",
   "め", "メ", "1",
   "む", "ム", "1",
   "みょ", "ミョ", "1",
   "みゅ", "ミュ", "1",
   "みゃ", "ミャ", "1",
   "みぇ", "ミェ", "1",
   "み", "ミ", "1",
   "ま", "マ", "1",
   "ぽ", "ポ", "1",
   "ぼ", "ボ", "1",
   "ほ", "ホ", "1",
   "ぺ", "ペ", "1",
   "べ", "ベ", "1",
   "へ", "ヘ", "1",
   "ぷ", "プ", "1",
   "ぶ", "ブ", "1",
   "ふぉ", "フォ", "1",
   "ふぇ", "フェ", "1",
   "ふぃ", "フィ", "1",
   "ふぁ", "ファ", "1",
   "ふ", "フ", "1",
   "ぴょ", "ピョ", "1",
   "ぴゅ", "ピュ", "1",
   "ぴゃ", "ピャ", "1",
   "ぴぇ", "ピェ", "1",
   "ぴ", "ピ", "1",
   "びょ", "ビョ", "1",
   "びゅ", "ビュ", "1",
   "びゃ", "ビャ", "1",
   "びぇ", "ビェ", "1",
   "び", "ビ", "1",
   "ひょ", "ヒョ", "1",
   "ひゅ", "ヒュ", "1",
   "ひゃ", "ヒャ", "1",
   "ひぇ", "ヒェ", "1",
   "ひ", "ヒ", "1",
   "ぱ", "パ", "1",
   "ば", "バ", "1",
   "は", "ハ", "1",
   "の", "ノ", "1",
   "ね", "ネ", "1",
   "ぬ", "ヌ", "1",
   "にょ", "ニョ", "1",
   "にゅ", "ニュ", "1",
   "にゃ", "ニャ", "1",
   "にぇ", "ニェ", "1",
   "に", "ニ", "1",
   "な", "ナ", "1",
   "どぅ", "ドゥ", "1",
   "ど", "ド", "1",
   "とぅ", "トゥ", "1",
   "と", "ト", "1",
   "でょ", "デョ", "1",
   "でゅ", "デュ", "1",
   "でゃ", "デャ", "1",
   "でぃ", "ディ", "1",
   "で", "デ", "1",
   "てょ", "テョ", "1",
   "てゅ", "テュ", "1",
   "てゃ", "テャ", "1",
   "てぃ", "ティ", "1",
   "て", "テ", "1",
   "づ", "ヅ", "1",
   "つぉ", "ツォ", "1",
   "つぇ", "ツェ", "1",
   "つぃ", "ツィ", "1",
   "つぁ", "ツァ", "1",
   "つ", "ツ", "1",
   "っ", "ッ", "1",
   "ぢ", "ヂ", "1",
   "ちょ", "チョ", "1",
   "ちゅ", "チュ", "1",
   "ちゃ", "チャ", "1",
   "ちぇ", "チェ", "1",
   "ち", "チ", "1",
   "だ", "ダ", "1",
   "た", "タ", "1",
   "ぞ", "ゾ", "1",
   "そ", "ソ", "1",
   "ぜ", "ゼ", "1",
   "せ", "セ", "1",
   "ずぃ", "ズィ", "1",
   "ず", "ズ", "1",
   "すぃ", "スィ", "1",
   "す", "ス", "1",
   "じょ", "ジョ", "1",
   "じゅ", "ジュ", "1",
   "じゃ", "ジャ", "1",
   "じぇ", "ジェ", "1",
   "じ", "ジ", "1",
   "しょ", "ショ", "1",
   "しゅ", "シュ", "1",
   "しゃ", "シャ", "1",
   "しぇ", "シェ", "1",
   "し", "シ", "1",
   "ざ", "ザ", "1",
   "さ", "サ", "1",
   "ご", "ゴ", "1",
   "こ", "コ", "1",
   "げ", "ゲ", "1",
   "け", "ケ", "1",
   "ぐ", "グ", "1",
   "く", "ク", "1",
   "ぎょ", "ギョ", "1",
   "ぎゅ", "ギュ", "1",
   "ぎゃ", "ギャ", "1",
   "ぎぇ", "ギェ", "1",
   "ぎ", "ギ", "1",
   "きょ", "キョ", "1",
   "きゅ", "キュ", "1",
   "きゃ", "キャ", "1",
   "きぇ", "キェ", "1",
   "き", "キ", "1",
   "が", "ガ", "1",
   "か", "カ", "1",
   "お", "オ", "1",
   "ぉ", "ォ", "1",
   "え", "エ", "1",
   "ぇ", "ェ", "1",
   "うぉ", "ウォ", "1",
   "うぇ", "ウェ", "1",
   "うぃ", "ウィ", "1",
   "う", "ウ", "1",
   "ぅ", "ゥ", "1",
   "いぇ", "イェ", "1",
   "い", "イ", "1",
   "ぃ", "ィ", "1",
   "あ", "ア", "1",
   "ぁ", "ァ", "1",
   "ｚ", "ズィー", "2",
   "ｙ", "ワイ", "2",
   "ｘ", "エックス", "4",
   "ｗ", "ダブリュー", "4",
   "ｖ", "ブイ", "2",
   "ｕ", "ユー", "2",
   "ｔ", "ティー", "2",
   "ｓ", "エス", "2",
   "ｒ", "アール", "3",
   "ｑ", "キュー", "2",
   "ｐ", "ピー", "2",
   "ｏ", "オー", "2",
   "ｎ", "エヌ", "2",
   "ｍ", "エム", "2",
   "ｌ", "エル", "2",
   "ｋ", "ケー", "2",
   "ｊ", "ジェー", "2",
   "ｉ", "アイ", "2",
   "ｈ", "エイチ", "3",
   "ｇ", "ジー", "2",
   "ｆ", "エフ", "2",
   "ｅ", "イー", "2",
   "ｄ", "ディー", "2",
   "ｃ", "シー", "2",
   "ｂ", "ビー", "2",
   "ａ", "エー", "2",
   "Ｚ", "ズィー", "2",
   "Ｙ", "ワイ", "2",
   "Ｘ", "エックス", "4",
   "Ｗ", "ダブリュー", "4",
   "Ｖ", "ブイ", "2",
   "Ｕ", "ユー", "2",
   "Ｔ", "ティー", "2",
   "Ｓ", "エス", "2",
   "Ｒ", "アール", "3",
   "Ｑ", "キュー", "2",
   "Ｐ", "ピー", "2",
   "Ｏ", "オー", "2",
   "Ｎ", "エヌ", "2",
   "Ｍ", "エム", "2",
   "Ｌ", "エル", "2",
   "Ｋ", "ケー", "2",
   "Ｊ", "ジェー", "2",
   "Ｉ", "アイ", "2",
   "Ｈ", "エイチ", "3",
   "Ｇ", "ジー", "2",
   "Ｆ", "エフ", "2",
   "Ｅ", "イー", "2",
   "Ｄ", "ディー", "2",
   "Ｃ", "シー", "2",
   "Ｂ", "ビー", "2",
   "Ａ", "エー", "2",
   "ー", "ー", "1",
   NULL, NULL, NULL
};

#define NJD_SET_PRONUNCIATION_KIGOU "記号"
#define NJD_SET_PRONUNCIATION_KAZU "数"

static const char *njd_set_pronunciation_symbol_list[] = {
   "？", "？",
   NULL, NULL
};

#define NJD_SET_PRONUNCIATION_FILLER "フィラー"

#define NJD_SET_PRONUNCIATION_U        "ウ"
#define NJD_SET_PRONUNCIATION_DOUSHI   "動詞"
#define NJD_SET_PRONUNCIATION_JODOUSHI "助動詞"
#define NJD_SET_PRONUNCIATION_CHOUON   "ー"

#define NJD_SET_PRONUNCIATION_QUESTION  "？"
#define NJD_SET_PRONUNCIATION_DESU_STR  "です"
#define NJD_SET_PRONUNCIATION_MASU_STR  "ます"
#define NJD_SET_PRONUNCIATION_DESU_PRON "デス"
#define NJD_SET_PRONUNCIATION_MASU_PRON "マス"

#define NJD_SET_PRONUNCIATION_TOUTEN "、"

NJD_SET_PRONUNCIATION_RULE_H_END;

#endif                          /* !NJD_SET_PRONUNCIATION_RULE_H */
