/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateHelper {
    public static void subDaysFromDate(Calendar cal, int days) {
        if (cal == null) {
            return;
        }
        while (days > 0) {
            int day_of_year = cal.get(6);
            if (day_of_year == 1) {
                cal.roll(1, false);
            }
            cal.roll(6, false);
            --days;
        }
    }

    public static void addDaysToDate(Calendar cal, int days) {
        if (cal == null) {
            return;
        }
        while (days > 0) {
            int day_of_year = cal.get(6);
            int days_in_year = 365;
            if (DateHelper.isLeapYear(cal.get(1))) {
                days_in_year = 366;
            }
            if (day_of_year == days_in_year) {
                cal.roll(1, true);
            }
            cal.roll(6, true);
            --days;
        }
    }

    public static boolean isLeapYear(int year) {
        boolean isLeapYear = false;
        if (year > 0 && year % 4 == 0) {
            isLeapYear = true;
            if (year % 1000 == 0 && year % 400 != 0) {
                isLeapYear = false;
            }
        }
        return isLeapYear;
    }

    public static Date parseDate(String myDate, String pattern) throws ParseException {
        if (myDate == null || pattern == null) {
            throw new ParseException("Null arguments!", 0);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date uDate = simpleDateFormat.parse(myDate);
        return uDate;
    }

    public static String dateToString(Date uDate, String pattern) {
        if (uDate == null || pattern == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        String myDate = simpleDateFormat.format(uDate);
        return myDate;
    }

    public static boolean isDateValid(String dateToCheck, String pattern) {
        if (dateToCheck == null || pattern == null) {
            return false;
        }
        boolean result = false;
        try {
            Date in = DateHelper.parseDate(dateToCheck, pattern);
            String out = DateHelper.dateToString(in, pattern);
            if (dateToCheck.compareTo(out) == 0) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static int getYearForDate(String dateToCheck, String pattern) {
        if (DateHelper.isDateValid(dateToCheck, pattern) && dateToCheck.length() == pattern.length()) {
            int index = pattern.indexOf("yyyy");
            if (index == -1) {
                return -1;
            }
            String year_str = dateToCheck.substring(index, index + 4);
            int year = -1;
            try {
                Integer i = new Integer(year_str);
                year = i;
            }
            catch (Exception e) {
                // empty catch block
            }
            return year;
        }
        return -1;
    }

    public static int getMonthForDate(String dateToCheck, String pattern) {
        if (DateHelper.isDateValid(dateToCheck, pattern) && dateToCheck.length() == pattern.length()) {
            int index = pattern.indexOf("MM");
            if (index == -1) {
                return -1;
            }
            String month_str = dateToCheck.substring(index, index + 2);
            int month = -1;
            try {
                Integer i = new Integer(month_str);
                month = i;
                --month;
            }
            catch (Exception e) {
                // empty catch block
            }
            return month;
        }
        return -1;
    }

    public static int getDayForDate(String dateToCheck, String pattern) {
        if (DateHelper.isDateValid(dateToCheck, pattern) && dateToCheck.length() == pattern.length()) {
            int index = pattern.indexOf("dd");
            if (index == -1) {
                return -1;
            }
            String day_str = dateToCheck.substring(index, index + 2);
            int day = -1;
            try {
                Integer i = new Integer(day_str);
                day = i;
            }
            catch (Exception e) {
                // empty catch block
            }
            return day;
        }
        return -1;
    }

    public static String getDayNameForDate(Date dt, boolean fullname) {
        String fullFormat = "EEEE";
        String smallFormat = "EEE";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(fullname ? fullFormat : smallFormat);
        String dayName = simpleDateFormat.format(dt);
        return dayName;
    }
}

