/*************************************************************************
* Copyright (C) 2002 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#ifndef IFMA_ECPRECOMP7_P256_H
#define IFMA_ECPRECOMP7_P256_H

#include <internal/ecnist/ifma_ecpoint_p256.h>

#define MUL_BASEPOINT_WIN_SIZE (7)

#define BP_WIN_SIZE  MUL_BASEPOINT_WIN_SIZE
#define BP_N_SLOTS  NUMBER_OF_DIGITS(P256_BITSIZE,BP_WIN_SIZE)
#define BP_N_ENTRY (1<<(BP_WIN_SIZE-1))

__ALIGN64 static SINGLE_P256_POINT_AFFINE ifma_ec_nistp256_bp_precomp[][BP_N_ENTRY] = {
{/* digit=0 [{1,2,3,..,}]*([2^0]*G)  */
   {{0x00030d418a9143c1,0x000c4fedb60179e7,0x00062251075ba95f,0x0005c669fb732b77,0x00008905f76b5375}, {0x0005357ce95560a8,0x00043a19e45cddf2,0x00021f3258b4ab8e,0x000d8552e88688dd,0x0000571ff18a5885}},
   {{0x00046d410ddd64df,0x0000b433827d8500,0x0001490d9aa6ae3c,0x000a3a832205038d,0x00006bb32e52dcf3}, {0x00048d361bee1a57,0x000b7b236ff82f36,0x000042dbe152cd7c,0x000a3aa9a8fb0e92,0x00008c577517a5b8}},
   {{0x0003f904eebc1272,0x0009e87d81fbffac,0x000cbbc98b027f84,0x00047e46ad77dd87,0x00006936a3fd6ff7}, {0x0005c1fc983a7ebd,0x000c3861fe1ab04c,0x0002ee98e583e47a,0x000c06a88208311a,0x00005f06a2ab587c}},
   {{0x000b50d46918dcc5,0x000d7623c17374b0,0x000100af24650a6e,0x00076abcdaacace8,0x000077362f591b01}, {0x000f24ce4cbaba68,0x00017ad6f4472d96,0x000ddd22e1762847,0x000862eb6c36dee5,0x00004b14c39cc5ab}},
   {{0x0008aaec45c61f5c,0x0009d4b9537dbe1b,0x00076c20c90ec649,0x0003c7d41cb5aad0,0x0000907960649052}, {0x0009b4ae7ba4f107,0x000f75eb882beb30,0x0007a1f6873c568e,0x000915c540a9877e,0x00003a076bb9dd1e}},
   {{0x00047373e77664a1,0x000f246cee3e4039,0x00017a3ad55ae744,0x000673c50a961a5b,0x00003074b5964213}, {0x0006220d377e44ba,0x00030dff14b593d3,0x000639f11299c2b5,0x00075f5424d44cef,0x00004c9916dea07f}},
   {{0x000354ea0173b4f1,0x0003c23c00f70746,0x00023bb082bd2021,0x000e03e43eaab50c,0x00003ba5119d3123}, {0x000d0303f5b9d4de,0x00017da67bdd2847,0x000c941956742f2f,0x0008670f933bdc77,0x0000aedd9164e240}},
   {{0x0004cd19499a78fb,0x0004bf9b345527f1,0x0002cfc6b462ab5c,0x00030cdf90f02af0,0x0000763891f62652}, {0x000a3a9532d49775,0x000d7f9eba15f59d,0x00060bbf021e3327,0x000f75c23c7b84be,0x00006ec12f2c706d}},
   {{0x0006e8f264e20e8e,0x000c79a7a84175c9,0x000c8eb00abe6bfe,0x00016a4cc09c0444,0x000005b3081d0c4e}, {0x000777aa45f33140,0x000dce5d45e31eb7,0x000b12f1a56af7be,0x000f9b2b6e019a88,0x000086659cdfd835}},
   {{0x000dbd19dc21ec8c,0x00094fcf81392c18,0x000250b4998f9868,0x00028eb37d2cd648,0x0000c61c947e4b34}, {0x000407880dd9e767,0x0000c83fbe080c2b,0x0009be5d2c43a899,0x000ab4ef7d2d6577,0x00008719a555b3b4}},
   {{0x000260a6245e4043,0x00053e7fdfe0ea7d,0x000ac1ab59de4079,0x000072eff3a4158d,0x0000e7090f1949c9}, {0x00085612b944e886,0x000e857f61c81a76,0x000ad643d250f939,0x00088dac0daa891e,0x000089300244125b}},
   {{0x0001aa7d26977684,0x00058a345a3304b7,0x00037385eabdedef,0x000155e409d29dee,0x0000ee1df780b83e}, {0x00012d91cbb5b437,0x00065a8956370cac,0x000de6d66170ed2f,0x000ac9b8228cfa8a,0x0000ff57c95c3238}},
   {{0x00025634b2ed7097,0x0009156fd30dccc4,0x0009e98110e35676,0x0007594cbcd43f55,0x000038477acc395b}, {0x0002b90c00ee17ff,0x000f842ed2e33575,0x0001f5bc16874838,0x0007968cd06422bd,0x0000bc0876ab9e7b}},
   {{0x000a35bb0cf664af,0x00068f9707e3a242,0x000832660126e48f,0x00072d2717bf54c6,0x0000aae7333ed12c}, {0x0002db7995d586b1,0x000e732237c227b5,0x00065e7dbbe29569,0x000bbbd8e4193e2a,0x000052706dc3eaa1}},
   {{0x000d8b7bc60055be,0x000d76e27e4b72bc,0x00081937003cc23e,0x000a090e337424e4,0x00002aa0e43ead3d}, {0x000524f6383c45d2,0x000422a41b2540b8,0x0008a4797d766355,0x000df444efa6de77,0x0000042170a9079a}},
   {{0x0000b650bc6fb805,0x0004effe2e6b808b,0x00083f5495882e07,0x00072385ef2f7c2c,0x00004d63c80e103b}, {0x0001bd652a23f9b6,0x0008eb0b6587f2f1,0x000580e9e3670c31,0x00021ff5c4623bb1,0x00004edf7b261efe}},
   {{0x0001dcbd53c5c9dc,0x0005ec0a177b9709,0x000fe2dfff17624b,0x00074df0f139752c,0x00001a35c0b2c7a5}, {0x000314693e79987e,0x0000089cb80e227d,0x0001883bb0575bf3,0x0003cf4f4e247f0d,0x0000bd512271274c}},
   {{0x00051c856ada97a6,0x000d2f8b403e5f3e,0x0002e29794afc964,0x000bda46f247ab41,0x000075abd1bcf80e}, {0x000bd725e485a1d6,0x000f2f4f0b3c66a2,0x000847bba4b2a5ca,0x00094cc626927f1b,0x0000c6fc7d965023}},
   {{0x00012baa5659ae8f,0x000935e1a16efea9,0x0002c41ac68363ab,0x0003fbc884227775,0x0000e545c291897c}, {0x000e9e7dc4c696bf,0x000a0ba977c52d36,0x0009508c15806244,0x00097a95665e9be3,0x0000720ee265d125}},
   {{0x0009129d2337a31e,0x000e2f862bdc8a97,0x000d283ba5916868,0x000b4d248099d95d,0x00002d1eeb7de5bf}, {0x0001c417884005d5,0x0007afffcbae82ef,0x000a95e66a2d4ec1,0x0000d04161c53f8a,0x0000ee104e215fee}},
   {{0x0004cecc135b208e,0x00046783f47d562e,0x0003f3b3074e1b26,0x0002fb8d2a506c5a,0x0000cead9f5a1676}, {0x000d4b2e286e5b9c,0x000fc3bb3c61f29d,0x000ac29a41b0fadb,0x000fa2ba75023e7f,0x0000086d5f289477}},
   {{0x00011352f6f3076f,0x0002f3912a9a0fc6,0x000f8ba3dc99ffa2,0x0008a37a0b0685d2,0x0000dc777e9d9335}, {0x00087bb35415f047,0x0009dd23fea494a7,0x0003a35b5640c2d6,0x0000742de917da15,0x000093e8d07cd5cd}},
   {{0x00076532de45068a,0x0007fe2e1f6ef4f8,0x00058406937c7a7e,0x000f4230825fa2a3,0x0000f2cea7cb727b}, {0x000a4fb9e4785a98,0x000ba7299f4a0360,0x000ac2f71e5fda49,0x00066ec8068e1371,0x00003d0687c10776}},
   {{0x00083b215d02819f,0x000f50dd9a356d38,0x0002b469f6d0d754,0x00011471d7cbf91d,0x000097b23301efc3}, {0x000d750b24bcbc75,0x000938a1e356a551,0x000cb750111ea494,0x000b8a2669f03193,0x000095dc55f1a737}},
   {{0x00019acd837879f9,0x000e5d6b67b0a4a3,0x000f1f3af6fc1b49,0x000a2e5395993332,0x000066742ebf5432}, {0x000c9feb49662287,0x0001d3f439504b8d,0x000b731ee96cc631,0x000967a2068859c9,0x0000b948dc3c6f79}},
   {{0x000ad32ed1f80089,0x000a48b1753861e4,0x0007ff6fbe6c9267,0x000b0f8ac7c5eb85,0x000094baaa8e5f2f}, {0x00014e11d248018e,0x000a828ac50884cf,0x000a944f55a39898,0x000ac634fde97b5f,0x0000d178031b12e5}},
   {{0x0002af497e2feb49,0x00071ebf7313042c,0x0004ffdd7d36a42d,0x000769b9d2c9eb08,0x0000f8aa54bbef7c}, {0x000b7ba09895e702,0x000fbdb7fb589200,0x000eb4cbb3bd0c66,0x000e310d97d10878,0x0000d431068f84bd}},
   {{0x0003eb7172ccd1fe,0x000750a6a8924b52,0x000e153eb7323cb2,0x000b96b7082ec0cf,0x000097f6b6bd2aad}, {0x000393ed1a83da1a,0x0006e04b2a681d3d,0x0000cb71ea6a7f9c,0x000277aa688b482d,0x00009b4cc5fe0585}},
   {{0x000b46acb66e132e,0x00092d9258805e5d,0x00017b9e2f1be963,0x000d47b44a702703,0x0000266f95a28603}, {0x00066735c2088993,0x000772fb18a398db,0x0007c619f9047244,0x00021b5a96693977,0x0000798142a5a3be}},
   {{0x0001cb13298b343d,0x0008e44f65a1b424,0x000c77acda3a14e4,0x000c3bf5f4d6cd3a,0x00000288cb622b6f}, {0x0008c2f1c040abc4,0x000dc6bf9b4ad5cc,0x0003aa441b675511,0x000f729667da379b,0x000060d45ce91601}},
   {{0x0003c696755ff899,0x0006b73017e6e2f7,0x000f7600ddd3cf7e,0x0007b3fef5689d3c,0x000048dc4f941fc8}, {0x000fe814ea53299f,0x0001a8eb6028d9e9,0x0009803fc2d921ca,0x0007450aecedfd0c,0x000038ae8923d7b4}},
   {{0x000fccfc5e3a3d83,0x000c1079dfbfd8c5,0x000ad0197befd904,0x0002a48c6d6a58fe,0x0000922707799553}, {0x0003e6ddbef42f56,0x0003e80a990809e2,0x0009a2e407e449b6,0x0002a41b969c1aad,0x0000231d792f591c}},
   {{0x00014560f6645343,0x000c1b68f1038715,0x000578ab985ceae7,0x00010c7c09c4ae65,0x00003ec68692044b}, {0x000832b3a8ec1f1b,0x0007a847d5ef6ac4,0x0003f15745509d12,0x0003c44909604f76,0x000016c4304732f6}},
   {{0x00020147ca23cd3c,0x0005e391849db6ab,0x000678d94caa7a5c,0x000e639b0673a375,0x0000982ddd59d303}, {0x000000b5db6f971a,0x000ecf876f92fd7b,0x000569426bba2cb1,0x0004f8277332a33c,0x0000159100cf70d7}},
   {{0x000847fdec67ef5c,0x0003633e76b7fd16,0x000c2b4c8742ee46,0x0005204b8e4134ef,0x0000a640b8702a3e}, {0x00001908ceb6aa92,0x000c347852d5653a,0x000237af7313c300,0x000af804e4ab126b,0x0000ba90162abb47}},
   {{0x00058d6a8219bb73,0x000ceb06c57f3d5e,0x00057576ec691d0b,0x000dc2dae4cb10d2,0x0000569656d054a3}, {0x000aebd94cda03a4,0x0002d62bfe13e5eb,0x00051a0c6934e82d,0x000526050ac0bae2,0x000080b9e121d6da}},
   {{0x0007bc58cce08b52,0x000c5f178d550046,0x00077d806b636458,0x0004eba5748baea6,0x0000763a387ffa39}, {0x000448a7d3cebb65,0x000e1f20d850a12b,0x00058462ce7adda3,0x0008a8a63ebce515,0x00008b36143b2008}},
   {{0x000c3ca4d63c0eea,0x00066fe948ce8a2c,0x0002ef33b5123311,0x000d6bd463fd8522,0x0000df0c7dd1c603}, {0x0002d3bfe7765e5d,0x0008ef3804090ec3,0x00059319cccaab35,0x00034cedaa84d68e,0x00009a4c2816c80c}},
   {{0x0009488a059c1425,0x0004af0b9346a9d8,0x000fb36646f5ae71,0x0006abb68f237d16,0x0000853e4c486318}, {0x0007d2363c52f980,0x000681828876e2d8,0x0004e7b1c2ec4a76,0x00040847b864fae1,0x0000c0bc0e569192}},
   {{0x000681db82e9f3e4,0x000b9f25e13ce4d7,0x000f2728083200f0,0x0002274909984c66,0x000062d7b00b5f73}, {0x000a188f26517980,0x000c36ab1c34d90b,0x000f5435974c6e18,0x00002fab256ea35e,0x00003466612d1aa7}},
   {{0x00060492ed22e919,0x0004df072822624d,0x000ce22716fdfe0b,0x00014f5eca111539,0x00008100a506b016}, {0x000daa2a35c628ff,0x000dd87e9a47b6b0,0x00057d9ceb6f94d2,0x000a7ad67732591d,0x000070bfeecf3884}},
   {{0x0005ccfed2bad016,0x0002bda6a5c75fb3,0x000a92f8fa155cbe,0x000e4362e2594c30,0x000049c89cebbfaf}, {0x000667de9ff257af,0x0001032c50aed158,0x0006014cf9b35961,0x000d3c5b00b20b90,0x00003a8cfe479bc7}},
   {{0x0003ffd248a7d061,0x0004778873fa4ff2,0x00074598180c5bfb,0x000994a7d9ad9005,0x000079c85db4db01}, {0x000b06261a6966c4,0x0002aadce5a8ba41,0x000e6a3184d82d05,0x000da05e91cd3ba5,0x00007795f4fd5b2d}},
   {{0x0007c1fd55a897c5,0x000b629110fbecfd,0x00081d3b0009194a,0x0002910f0e2046e3,0x0000f3425f6f98dd}, {0x0006687730d50dae,0x000b6b083b7fbfa0,0x0009d34170423446,0x000429597a247dd6,0x0000b629f91187ba}},
   {{0x00026ccd5cd79bfe,0x000ab46c6e181ee4,0x000477f580032940,0x0002773b1e8ae057,0x000094f7d354d823}, {0x000cb96782ba21ad,0x0009272b33a5c747,0x000f80c81c525446,0x0006b4a72ef6dec7,0x000073acbfefcd9e}},
   {{0x000b5b149ee90d9c,0x0009e06e9eba4075,0x000f825e0785c339,0x0001dbe1030d5bab,0x0000ec684c464293}, {0x00062c9c1586e630,0x00065ab43f2b42ab,0x000f7835d45431d6,0x00086557c8b2c055,0x000033da338c1b7f}},
   {{0x0007513caa760974,0x0008f6c83906283c,0x0005af2c70a624fa,0x000bfd2b20afec71,0x0000b9699752ba78}, {0x00055ccd921d60e9,0x000febaeca132207,0x000ed93d49b944e0,0x000d2674819d515d,0x0000bbff86efdddf}},
   {{0x000413077adc612c,0x0008fbd803a06b34,0x0008805bda749652,0x0003ac5a1baaa76d,0x0000840390307034}, {0x0009f66175adff18,0x000b37d8c5b739f5,0x0009d75e30b26d7f,0x000cc22875f5ce52,0x00005efc7e9c1325}},
   {{0x0000b421ff6acd3a,0x0003b3dc69092195,0x000766127ffe7048,0x000b2b5f4cd0b228,0x0000bdbe608efb7d}, {0x00092285e1109e8d,0x000724645b5a837c,0x000818ed826147d2,0x000a357d78f592f7,0x0000394077fc247f}},
   {{0x000c2d0488c171a0,0x000a136852780fb9,0x000b1fa6aa78bfba,0x000ba7edfbe268d5,0x0000dceb8db2b7ea}, {0x00080899ae2b710d,0x0005d4449c96bf9e,0x000143a46efde7ae,0x000c1273b7716bcc,0x00007d3419593628}},
   {{0x000ec1c3b3f64c9d,0x00094e5edf3f508c,0x0004318d4e20bc0b,0x0004430a1deb852f,0x000020ebe0e2c3fa}, {0x0004ea773241ea3d,0x000b8e1a5f65370b,0x000681c6261f1511,0x000c2cc9a5e23d82,0x0000731e38472f54}},
   {{0x000f36e834459048,0x00092f45f9c02692,0x0007528b72e0ec46,0x000542105a3201c6,0x00008f77f3550e5e}, {0x0008d295864687c7,0x000db2df3562f67a,0x000bec39e23b92ea,0x000f8cec27014b9b,0x0000ef2f2270c0f0}},
   {{0x0009638546c4d8de,0x0003b2f246799735,0x000c8acd95f9c3fc,0x0004afb12e8beda8,0x0000c3a318e10663}, {0x0007f41c31cb264f,0x000e622113f28016,0x000afe1973db82f6,0x000282c155bcd2dc,0x0000ba1da5a33465}},
   {{0x0005b8eb212cf53b,0x000e48557c5fa042,0x000c4d56c4f2e512,0x00085111286ff925,0x0000b8a0feb9e26c}, {0x00070d2e7d6107e1,0x0004d76265aac28f,0x0001936b17ee0c44,0x0005eb2df277a41d,0x0000a556e3ffa959}},
   {{0x000bbf9e73056835,0x000eb7ef5be6258b,0x000c814c131eea5b,0x0000dcbdeb0e4a46,0x0000cee8449f7b73}, {0x00095c5a0182bde2,0x00077e27a6b4eab4,0x000e518caee759f8,0x0003f4a2cf6a6880,0x00005e80140114cf}},
   {{0x00041407e8d7a14b,0x0009e556f36a8fc4,0x000600044bb1ff3c,0x000e62ba84438514,0x0000a3f0c4b2451a}, {0x000c25b1f9af32a8,0x000631f2214bdfca,0x000b596ac01e0db8,0x000c07ce9a5bc2a4,0x00003927681826c2}},
   {{0x00032e77acaca28c,0x000707385b293ec8,0x0001eaf381bfeea5,0x000ccb468212e3fd,0x000013298312acf8}, {0x000f2db2aac9e59d,0x000ce661782ab909,0x0009b7a015748060,0x000625f5ab2632c7,0x0000a44c6c6d0017}},
   {{0x00000e8a7ea82f03,0x000db4299aaff26c,0x000d78be199cac80,0x0002cda66fe3b67e,0x000005f725f948d0}, {0x0001bc4623fb21b0,0x000e7a6319ad33ed,0x0005ffb3efa70533,0x00074117ab562dbe,0x0000637499456674}},
   {{0x0004ed65c46aa8e4,0x000368d063d169d4,0x000d17c362100d5d,0x0003b78b9727eaa2,0x0000c2bab1bcadd5}, {0x000e90c15426704a,0x00030837ebeaa084,0x000e477f8778afcd,0x000a8ac651f7017c,0x00000624998e6fb7}},
   {{0x0006828ed8a6e19d,0x00057189d9c7dc1e,0x0001c39bc33fc233,0x000914326f8fe267,0x000040c4cce8c6f9}, {0x00035bbf80e75ca0,0x000022adff2cafa1,0x00051ad9612c651a,0x000832c40a04bd4f,0x00004820109bbe4e}},
   {{0x000eb1a7f4c04cc9,0x000119404f843667,0x000ceb50a5955662,0x0005f9e1cdf6537e,0x000094a44a72b833}, {0x000f819dbeb9b690,0x0000eed4350dd7fa,0x00044bba2473c568,0x000bf3b6658466da,0x0000d1bc780872bd}},
   {{0x000f175a1962f910,0x0001ed58f5a7e535,0x00089a2336ed7e06,0x000413177aa4c020,0x0000dbcb03ae539b}, {0x000424ebb32e38e6,0x000f0806701ee3dc,0x0004be9ee6472e5e,0x0000097d47ff9881,0x0000b60cfff95ace}},
   {{0x000d9319ff91fe50,0x0000f0518eedb8d3,0x00082cb26039c480,0x00068d95c3763291,0x0000763a43482fc5}, {0x00004d5383e76ba9,0x000ff24e8197707c,0x000230de0ac98b92,0x000b7002bf7c8f91,0x00000876a01d0959}},
   {{0x00096f305968b809,0x0002789f73b9db6d,0x000c61e01380a091,0x0008c6eda70b83c2,0x00005fb8394e69b3}, {0x000651280edfe2f2,0x00096faeaf829a3c,0x000424bf88f726bb,0x0009706010a4a078,0x000096720442e844}},
},
{/* digit=1 [{1,2,3,..,}]*([2^7]*G)  */
   {{0x000cb817a2ad62aa,0x00090c62ff5463c5,0x000ad9db57ef2b6b,0x0006169749bba4b3,0x0000d311f2ce6d5a}, {0x0008087c2ff3b6df,0x0002467834ffb77a,0x000d6b138b46feaf,0x00018808aa266d75,0x0000a38d321dc008}},
   {{0x0008ffa696946fc7,0x000849cba56d486d,0x000f35a1550fbc6d,0x00062c0e3d423e90,0x0000c3da19630dd9}, {0x000fdb03cfd5d8b3,0x0002589dfca5e673,0x0002305aa0704b7c,0x000e53c6ce581ff5,0x000099d49ebc14d5}},
   {{0x000496d6ec293cde,0x0006ae7051f5380a,0x00049140a733dbda,0x000bf5237e388db8,0x0000e4b32b13946d}, {0x000fda9cae368d14,0x0000bdb0b2f3b1c4,0x0003ac46e5001a7b,0x0006562df593742e,0x0000af675f279b3e}},
   {{0x0008110399492969,0x000aa61db1b544e3,0x0006eaff55b63827,0x00028fae5323ed20,0x000042370d3521f4}, {0x000af2ee0d985a17,0x000b0239846df2ca,0x0006312f8192cc64,0x0001080c0b8f47ae,0x0000dc61f9206620}},
   {{0x000fb5bc2da7de94,0x000ecff8d3beb830,0x0008a9641d0e643d,0x000501f1ee77ba18,0x0000e8aa3aafcf6d}, {0x00065329a49110f0,0x00062dd6b220f9fb,0x000c3ea5ad18317f,0x000c4a7e3ced4152,0x0000d296a147d579}},
   {{0x000a53eed4c37174,0x000efd0ed2a335d6,0x000543aa59f8240c,0x0004b44c0d4d05e5,0x00005d5bbfc1d33b}, {0x000cc73137fd28e3,0x000f973b3ffdfa04,0x000f51ef2862ac6e,0x0005a2103ff9f531,0x00004d5e0fcec73f}},
   {{0x000682008913f4f8,0x00016ac93d95f252,0x000a6b26cea20ed6,0x0007afd1ed38b46c,0x0000662dcbd6a432}, {0x000295c725d2aaaa,0x000eee52dcda6daf,0x00017daccbad2752,0x0002318210e7210b,0x000037f7913751e8}},
   {{0x00081e144cc3adda,0x0005e7be82cf4f70,0x000dd6472d5ffa1d,0x000862e9890b6c0e,0x0000da26e1aded17}, {0x000271563483caaf,0x00083f6077fd276f,0x000466e3ce6924cd,0x000d1e15a7fe980a,0x00001c794b1a1902}},
   {{0x000368882a8042c0,0x000fcd278298e521,0x00097a740d931cfa,0x00007c069a0ae0f5,0x0000adbb3f3eb591}, {0x000951e5eaa8eb87,0x0004a1b48e78983e,0x00003f2c5e663a8b,0x0001e1a631cc0d8a,0x0000577c11e81e27}},
   {{0x000385c08369a907,0x000aa90eb4f833b2,0x0008eac802990c59,0x000014119a6145c6,0x0000a786d629ec4a}, {0x000adbe20ac3a8dd,0x00008aba2d3033fa,0x000a4f56531a2178,0x000fba509d2742db,0x0000b2ce9e425aa0}},
   {{0x000334b168984df5,0x0006e38796388cef,0x0003720f0e81dce1,0x000beca6e6949c26,0x0000c56feb04593c}, {0x0005601fde58c84a,0x00068eccb3148bff,0x0009a8a7874e2411,0x0008681cf01b614c,0x0000233e35ef44c9}},
   {{0x0006bf38bd7aff18,0x000a9d81b146b315,0x00028a9151b5ee4c,0x00099dfba1ac41d6,0x0000f3a8f9d7d896}, {0x000b9c9a0748be7d,0x0004d92e621f7329,0x00010a8371d391c9,0x000435151e6b214d,0x0000255f53b1947b}},
   {{0x0009e04f1788ee3f,0x000eb86938a20766,0x0003a01c0c14f27a,0x0008079b47a334e9,0x0000f627439c9366}, {0x00085d8ca2a59655,0x000286e9b9b37a09,0x000f972e83d9a554,0x0002fd723eb80b4c,0x0000c1c33bb9fdf7}},
   {{0x00058d474a861082,0x000fce4c5d900c4a,0x0006d4c80f8048a8,0x000e60c3c7c924e8,0x00008c889de256a1}, {0x000662eb214a040f,0x000747e1034757e2,0x000ac748ae8c48e9,0x0006f19774286280,0x00001c24023086b0}},
   {{0x000d4c35f74040ab,0x00014ceac957ac2d,0x000c4ec23409aeb7,0x0006eb9fbad78255,0x0000359ed623a7b7}, {0x0004926ed6f4a607,0x000edb912de31274,0x000705a59e21e8d7,0x000c0e72575a59fc,0x00002f1d4df5d2db}},
   {{0x00024b9eb7926b83,0x00039dbe55093d2b,0x000dd640bbff88cb,0x000d45a0f399afe4,0x0000c5fe1305f76e}, {0x00062f43764fb3df,0x00074151b62d6f35,0x0009ce5f37b5af31,0x00090ee5bd0bc7d7,0x0000daf6b21dc668}},
   {{0x00067ec6063540cf,0x0001f5f9cb8f735c,0x00099c6ab50b259c,0x000c84c8734f9a3f,0x00008cc13d693a7b}, {0x000b305c52176597,0x0003dec12a5480c1,0x0001345fefe5364d,0x00097f4d87045e68,0x0000f8efeb1c82f8}},
   {{0x000f1e5d59233595,0x000d039b9fb0e8cb,0x000859b98db0cea9,0x000cc5bc5b34cf49,0x0000e583c56f4403}, {0x0001a2dd48185b77,0x000dfe52178711fc,0x000105b8bc93fbc7,0x0000c7d7e7a05805,0x0000b4d4d594b826}},
   {{0x00030b046eb842ab,0x0009cbdae56de339,0x000f7fdfc8e844a9,0x00017584ef3a9e13,0x00003768f83136ca}, {0x000f4e04e09e61c1,0x000190c7cddc2821,0x000945fcd414dc3a,0x000ff1c537943754,0x000051b6eefc3555}},
   {{0x000d6136339c0831,0x0005cfb64701b31b,0x0009604ab39ff815,0x0004426c3388d2e2,0x0000e19084bb6b10}, {0x00054c0eccd47ef9,0x0004ba5dfb3017cf,0x000daf9f68969338,0x000958d9d023fb47,0x0000222840c0d91d}},
   {{0x00008f5803bac625,0x000ce79bd45f4391,0x00063c5810b7dd91,0x00004f8651e827ca,0x0000c5d75f6a09c1}, {0x000c7381f2dc308f,0x000ee98454be7d5f,0x00017b03120faa7b,0x0002aba5374beea5,0x0000036b9b254269}},
   {{0x000610939842194e,0x000d69d05295c510,0x000b42ee0b7e2353,0x00011c1c8c1d5cef,0x000004884ebe8ce8}, {0x0005d817419f40e7,0x00023995c241f1f7,0x000c556465b0ac16,0x000f96a20921bbc4,0x000013520c2fd33c}},
   {{0x0005a5ce98c51002,0x000d0ddd0f5ab4a6,0x000a2e78b6cec871,0x000a5f051f0b7f9b,0x000024a8434ee3a2}, {0x0007f6125f5c46fd,0x000b78545ec02682,0x000bb5cdc6a22bed,0x00098e55ae5fa0b1,0x00006936830ccb9b}},
   {{0x0007fe891e5d7d3f,0x000683a076783202,0x000dfdd61f14b7d1,0x000f48088497b3c0,0x00007c2eec11a8c4}, {0x00073f43756e621a,0x000f7825b948aa55,0x000878572c013a23,0x0001837c03b34563,0x00000472beb053a4}},
   {{0x0002e270ac69a804,0x0005b51e54f6f422,0x000ffa59134096d2,0x00027ec0a648cb8f,0x0000e87acdca9b65}, {0x000e037e285ccb47,0x0003e0ddcf520575,0x0000ff719188089e,0x0003693a96c9a887,0x00004a56cd88fc7e}},
   {{0x0004ee21726931ae,0x00075660ecfd41d0,0x000818e180bbbb2c,0x000886c6ef6de524,0x0000421cc52c7d57}, {0x000d208bea87be65,0x000361cdd682f127,0x0009b63f716a475d,0x0003b64db1b68443,0x0000359b3dc40f11}},
   {{0x000f1de8bf06e31d,0x00040d383901dfcc,0x00017e7d21fdf8f4,0x000eee40775cad50,0x0000fc3a59828d11}, {0x000c8a0b1ecff106,0x000bc84005496ec9,0x0004f8d73ee6ed6c,0x000ab955ad7bae1b,0x00001b4f11e400aa}},
   {{0x000d69bd4eff2d71,0x00013288b60f7b32,0x000a1e72388ae677,0x000e8c059461b437,0x0000f3d4789670aa}, {0x00018c07f9871da6,0x00089635e2788691,0x000541dac35fbda7,0x00045f138f3641e1,0x0000794b13b20dae}},
   {{0x00064ac09cc0917d,0x0008f68540fd0650,0x00022767127c5372,0x000a033d2d4c8eef,0x000023a9f8171785}, {0x000952852650359a,0x0000d4a1acad98c5,0x00055bf5cfa09ad0,0x000083682d5a290b,0x000040f1c67e19b8}},
   {{0x000752edcc18770a,0x000ee825c3a53a5c,0x000b153ed4baf1f2,0x0007234bd63f7421,0x00002383e4852f64}, {0x000620a2646d19a8,0x000b83c83ffde7bf,0x0006be9f156cb44e,0x0005e92f7267c94f,0x0000b2dfd7c406bb}},
   {{0x00072f2a672c5c73,0x0007dd53c5e2b870,0x000435932eacb11c,0x00093bf2dac29dff,0x00007bdb99d74086}, {0x0002fb62899c20f7,0x0001d47ece24f6e6,0x000577ce33535d51,0x0005f28bdc6b88ff,0x000026693bd89057}},
   {{0x000b0e5ab4b35a24,0x0001b5eeaacf6772,0x0005b95801d8b600,0x0001da328f7ce479,0x0000a20ed2a81fb8}, {0x0005cd44fec01e63,0x000c77ff50ad9f68,0x0002d97fd3ed7ddc,0x0004f9160fd2640c,0x0000a2414271b82f}},
   {{0x000df2c6a8ea8208,0x000b722cc25417d1,0x000291426b2b50d3,0x000e3883856cbab7,0x00007fd26ae84f5e}, {0x00096cc02bee4ba6,0x0003a6820fd69cb6,0x00012e9855312180,0x000a0945dfc26902,0x000066f7ffa760f9}},
   {{0x000cd33bccd9617a,0x00041a7730a3c503,0x000db0786365dede,0x0003bbd98c63555d,0x00006c3200f9c9cd}, {0x000fb2ce5e35efd0,0x000b5555a1c1060f,0x0000b375199a4e25,0x000bf611d95375f7,0x0000a57354a160e1}},
   {{0x000ae4bf8e4b0651,0x00041e53022becb3,0x00092ed9607a834c,0x0004ec0cd300b386,0x00006a6f79271ee1}, {0x00063c66a8649edc,0x000dc69f3e148f10,0x000a7b3ecfbcdfcf,0x0002f06cfb97c100,0x0000ea49b3d3130c}},
   {{0x000044fe9d964888,0x000e0182a0c1462d,0x00091e9e94b53d52,0x000a0904b6ddd303,0x00000ab7b4931741}, {0x00015d427d3317fc,0x000a5a64671eec0e,0x0009c5b928dfc1dd,0x000330d3cc5d5fd4,0x0000995d53df674a}},
   {{0x00041ec090090ae0,0x000cedb06830302e,0x000c996902278a0c,0x0008da1d025932fb,0x0000c32fbd2b80d6}, {0x00046daf341a6c11,0x00090bef68a0d791,0x000774b3aae0ba13,0x0004d7b6b8a5638d,0x0000cf307bd980ba}},
   {{0x000bdc719803511c,0x000ac888c3bec033,0x000c6d05ea9f97b3,0x0009ea7d68aebc85,0x00003b88a9dd9391}, {0x0000748c48b0ee35,0x000bb7a746c12d30,0x0006d57f37506bc7,0x00091aac48437c6e,0x0000bd715881feaa}},
   {{0x0000408c1bc52257,0x000ab719226da4ed,0x0008d2d43d0b946d,0x00059aa09ecd6275,0x00005c8485a97517}, {0x0005f499ce4177a4,0x000e39c10c3db0b7,0x00067fcd74fa61a1,0x000fa88062d300a1,0x0000df3874cb50f0}},
   {{0x0002cf983dfedc91,0x00047d87631a29ae,0x00029c8d2f843713,0x0002729f57171174,0x00008d15867246d9}, {0x0003ecf69769bb7a,0x00062479ab828305,0x000b0f4b2c55eb85,0x000524bef7791c21,0x0000a5956badd491}},
   {{0x00096c29fe20ebae,0x000b052a5ad3407a,0x0001d9d89f27168b,0x00027963b60ab3bf,0x000045c51f0510e7}, {0x0005276099b42210,0x000c2557a159dfca,0x0000358958dc6407,0x000c320ead833591,0x0000a9db9579c55d}},
   {{0x00036d3df61bc767,0x000fcf778cdbe407,0x0006ea28f13a619b,0x0007b3fdd921a4c5,0x00006a524339fa64}, {0x0001891ac5bdc5d3,0x00028ac7dc012359,0x000df8453ff4a1a7,0x00065f6905e26162,0x0000ac045e0163b2}},
   {{0x000341bad53dba78,0x000c037b625a8a3f,0x000e311898ec269c,0x000120571a27823a,0x0000fb4f9a3d5e96}, {0x000f823ff9875cf9,0x0006cd442a9b804a,0x000c6267923224f5,0x000db08c4d3b9eec,0x00001da22fc30e7d}},
   {{0x000324d6c04a661c,0x00059e376d17a370,0x00044e3579710d3b,0x00001c2d8c98f030,0x0000364ebbf24227}, {0x0005d517733d61c0,0x0009cea826c3347f,0x000a25548d55644b,0x0000a780c6e0ad55,0x0000aa7641d84422}},
   {{0x000ec81318106601,0x0007ce4b40431438,0x0003e02739dfa650,0x000fb200b515d8cc,0x0000b6066dd38d8c}, {0x00045919c9efebdb,0x000ef21c1ff4d3b0,0x0007607d3425d4bd,0x000083afe5af19d5,0x0000bf773f804481}},
   {{0x000bd6994b03ed1e,0x0002834cc5468435,0x000e420cad9ad1de,0x0006dc4cf423fc00,0x0000ed26d8180309}, {0x0000be7a4db09d2e,0x000cb60622f7d7f6,0x00096c729f47f569,0x00071505925fd772,0x0000ff2db2706ca2}},
   {{0x000d014b913e759b,0x0005dff4de93a6fc,0x0002068e153da478,0x00052d64616d79c3,0x0000187d6657cdf3}, {0x000b6501dc90b596,0x00031daa1b26f7af,0x0000c0a848170e94,0x000dfa68e3bdd870,0x0000e8d345fc482b}},
   {{0x000bfa1c5c5ea50e,0x000b8796068184cf,0x000d50942d3baf14,0x000662463984030d,0x00004b7839d2716a}, {0x000f794e7de6dc08,0x0003e22aa7ced5f1,0x000acfeec5cd0f4d,0x000606d295f3f159,0x0000d933553153e0}},
   {{0x0008ec5776c57224,0x0001eb5f290cc7db,0x000f425a9dc467e6,0x000b7294297e704f,0x0000be924c14cf7b}, {0x000c5aea18921310,0x0003a705c9920d5d,0x000305ac58bf8a8e,0x0007a873a0b0647a,0x00000c9ca4e9a8c7}},
   {{0x000e80f83774bdde,0x0001a57344855dfe,0x0004a69a96313160,0x0000d6c1b524ae91,0x0000bc2ffb0b4e30}, {0x0003db77cfa46a5c,0x000e61653b5052c9,0x000bc580a71e6161,0x0002527574fc57a4,0x000009015dea1bc1}},
   {{0x00047b2d174d7aa6,0x000893a15d044b7b,0x000fa07ed4072d8e,0x000fb18eb7d47fd6,0x0000f2b9ffa4dbda}, {0x00016153760fe8aa,0x000f506c6c1318c5,0x000a2d0717a96e6b,0x0005cdad7a04100e,0x00001914e9babe2a}},
   {{0x000e357d8a3c5cf1,0x00031abb2b135726,0x000ae88dd1197ecc,0x000efe5c0d7f7f31,0x00005b20d1b0dbb3}, {0x000aa26705840398,0x000927dc9747cd06,0x00055d8152277c96,0x00032a3ca6958778,0x000099ea238d188b}},
   {{0x000228b760c1c9d4,0x00015b5c18da37d9,0x000f6dbc5c7efbb1,0x00005b3f0d1bc819,0x0000875384b47e69}, {0x0000baa3ba8cd86a,0x000b22905de0c7c5,0x000231952b0ce40f,0x000e25d08406737a,0x0000912a2636f43d}},
   {{0x000ddcceb5b76c16,0x0004c6fc0ab49c38,0x0002c269f746f528,0x000620f2a63a50d6,0x00000049c55f9458}, {0x0008f823c2f7c9eb,0x0002e17d5cf3e7f4,0x00001f4696bd9904,0x000fe03b1317a887,0x0000d3fe2ee4a449}},
   {{0x00079ca12ef3d36a,0x000b9e7ea5de421e,0x000ff36f79ee3c36,0x000228448198b5cd,0x0000ff4f96866b82}, {0x0009dd0c47adb7e5,0x0002b32e7dfa15e1,0x000ae026a45699b2,0x000f4cf0680c8b1f,0x0000a347a48a50db}},
   {{0x000533b3cef0d7d8,0x0007abbb4381e652,0x00080f500d94f7b1,0x000bfb038752be0e,0x0000e6e24891e9c9}, {0x000169716caca6a2,0x000818531ad9c975,0x00051ade1866c49d,0x000407a917e23971,0x0000d016ec18037c}},
   {{0x000ccc900eac3f90,0x0000e2ed4748a407,0x000c98e0d835f628,0x0002ebcc54c3471c,0x0000e969937dcb57}, {0x000c8e88f30c9cbf,0x0004473c46611b16,0x000502caba606ae7,0x00064e57aa689b35,0x000089014af3d9bb}},
   {{0x0006a9c31c71f7be,0x0002496ffe5c202f,0x000cec3a301f95aa,0x000a447fc0601453,0x0000b9912383f498}, {0x000935e5d91ba877,0x00009b564a19ae9a,0x000d44e69c6ac628,0x000d451a8fe81c3b,0x0000c8b46800dd11}},
   {{0x000251fea5b8e69b,0x000d15b75fbcf772,0x0007ff0e5aeecb3b,0x0001306aca333188,0x0000e5d49ffc9f0a}, {0x00013aae5c8646f1,0x000810e19980582c,0x000abbd94dbaa12e,0x0006637f40f31af7,0x0000f13f5a82dfc7}},
   {{0x000f1eeaceb4fc02,0x00023e6f0f425d81,0x0001370c83625600,0x0005892b67d6d775,0x0000608b69823e80}, {0x000d2fc05268301b,0x000890309212cfc0,0x000d0e1c2a6943d3,0x000c75692a90c21f,0x0000209f113e7f1d}},
   {{0x0005e0697bf1298a,0x000f819d639eefcc,0x0001e8c6fcbdb672,0x0002e53009c116b8,0x00003ffdde3ba7ce}, {0x000baaaa914d3ba5,0x000f38df85eec53f,0x000ee0751836d500,0x0006fd898dc71b66,0x0000a3d7005c1451}},
   {{0x000634d39eedbbab,0x00075455a46d21d3,0x000d7eb0c35cd2e6,0x000b3e18cafe65f9,0x0000da3ce9eb0cef}, {0x0007a602c9cf7a47,0x00040bcb8773ddc1,0x0007548df01572ee,0x0000e3392b2b018c,0x000032fd30a18460}},
   {{0x00009c716543a402,0x0006dede3c6ce221,0x00024e6149acafd3,0x000ca0db20685268,0x0000a4544a9fa25d}, {0x000526291d60b063,0x0008f87535452598,0x000f13b27281b7be,0x000eb4bc667b1a90,0x00003a83affc40e2}},
   {{0x0009862d5d721d5b,0x0002abd3a1828000,0x000a2cda40c3357a,0x00008477f3a83b7a,0x000058ae74fa6f83}, {0x0001a812e6dad6be,0x0001143d6c5b2a91,0x00096c4d8de28605,0x00024d6bdccc41f9,0x00007312ec0eae1e}},
},
{/* digit=2 [{1,2,3,..,}]*([2^14]*G)  */
   {{0x00012e76e6485b37,0x000b071c52f8f8d1,0x0004a2f6d4d3e24d,0x000550d8e3ee4168,0x0000161957d91d95}, {0x0001283cdb12a6c3,0x0001fe50e1641963,0x00066cc73bf3fa88,0x000c38c6254b6331,0x0000aefa7aedee8c}},
   {{0x000fe623b36f9fd2,0x0003dde19fc079b0,0x0008482ef26543b2,0x000824f36e64a095,0x00003f63771bb095}, {0x000d596b6a1142e5,0x0005e35aac0b14cf,0x000081dd55ea6aac,0x00012a36a0e8bdf3,0x0000fb89d79503dc}},
   {{0x000c33af72e34d46,0x000fb10eec35f615,0x000dea34e0bd9ea3,0x000698bc12bc5bc1,0x000086584c9a9ae4}, {0x00095d38c97b942f,0x00095e5c756213ad,0x000737f894609561,0x0008b5ae94a4aef2,0x000057594c7271c7}},
   {{0x00065fce3779ee34,0x000d7d495d9e0f01,0x000284e7ae00e7f9,0x000218dfa4efa220,0x0000564bade87ac6}, {0x000312ac4708e8e4,0x000b671e9adf90e6,0x000684b9f4f5725f,0x000415a95f55ae3d,0x00007f7ccb15e94b}},
   {{0x000851b8d9465810,0x0003bdf4a0127322,0x00084dae0f0d1313,0x000c6da3510f6965,0x00003a7c1713c9f6}, {0x0007f38e475381a1,0x0002758233345be9,0x000e17ddaca1ba42,0x000c0fe83cc5c70b,0x000058b14941b918}},
   {{0x00077e5522e6b693,0x00038bcd6c18da3a,0x00024fd5669c908c,0x0003f6ef1b9e48d9,0x00007c64e36da4bb}, {0x000dbdfee478d7d1,0x000bf193f7a05a4f,0x000cd16dfba75c8b,0x00015174bc1e8456,0x0000fb08f0856fad}},
   {{0x000abf9842e9f302,0x000f3eab83af8a7c,0x0007f2a6aa331d4b,0x0000e3b272cfba01,0x00007560abca3aba}, {0x00033870e3a6b750,0x00026b9f50f594b8,0x000fdf6d025c6aea,0x000514803d691db5,0x00003b77509e6333}},
   {{0x000890361a341c13,0x000fdcfd61423617,0x00033316c3604dc5,0x000921d22295eb85,0x0000dbde4ac74af2}, {0x000fc5d1c7eef696,0x0005714f4fa1898a,0x0003c21ca5889680,0x00030aa500216020,0x0000f0d1f30a0ef7}},
   {{0x00044d4196224f85,0x0004e74d079d8e8c,0x00048f12375a4ab9,0x000ad829085ecc7d,0x00006f04d316bf65}, {0x000bf1cbda602b24,0x0002b9612c69e220,0x0004fd06b73ee174,0x0000d136008fc808,0x0000000efa031138}},
   {{0x0001b4b12cfe2978,0x000ba92f74e54820,0x000e874e83eee129,0x000c4161fe114ec9,0x000099b055d12c5f}, {0x0007a643a39c8cf8,0x000df8963cc94e47,0x00033f86382f09ef,0x000c62efd3fd8fd3,0x00005132b2b5c949}},
   {{0x000a3ab516eb17bb,0x000f22c7372b7e06,0x000896da673bec06,0x00040f34f74f55ba,0x0000b4afef93e9eb}, {0x000bec8e61d66b0f,0x0003ff29300b2d75,0x0006baa5a02bda4b,0x00043f9bbaa8de02,0x0000f54befe907f4}},
   {{0x0008b1dbe7a2af37,0x0008dfb74a72bd9b,0x000879697ec51caa,0x0007d549937a4b63,0x0000c9a9d215c268}, {0x000e44f6ef5f0145,0x0002990c69001773,0x00042161e8abcf41,0x000f29e87bd02281,0x000003937564cb6f}},
   {{0x000fd56ed6def63f,0x00018d53106c9813,0x0001f7ac153cf648,0x000faea91a35bd43,0x00001e274de53e65}, {0x000fa3c44cc78808,0x000afc256981f63f,0x000a420e0411a426,0x0008fe3698b9fd93,0x00009fdddc12e53f}},
   {{0x000072232398baaa,0x0001bcfca031766e,0x000029cf2205fee4,0x00090d049f53417a,0x000088c68b8e0238}, {0x00050417337aaa82,0x000ceeb384f4bc27,0x000aba92f9ed364a,0x000a88c0816f8529,0x0000e9e194124e38}},
   {{0x000f44a3dafd2d50,0x000597ed98d857ee,0x00007f9b135d1fae,0x0005c650628c0923,0x00009d84aaed6cba}, {0x0001bc788aaa6917,0x00093fe6cb036707,0x00078ac012dea57a,0x000a516fe11bb43d,0x0000286418cefd7a}},
   {{0x000770977f7195ad,0x0006ddeb838ffabf,0x0004f012d8ec8616,0x000b3f1a1285a8bb,0x000068835046a3ea}, {0x00024f8309004c28,0x000593ffe95eee5d,0x000223ea4a96e4b7,0x000a528cdffe12bd,0x0000f5c2ee636739}},
   {{0x000aaa5dd968198b,0x0001c2413a6c5cb4,0x00036d903fa131c5,0x000d8da3d46a9095,0x0000270f0d3f8606}, {0x0007564a053a3bc5,0x0006ca86caef518c,0x000b5efd0088254b,0x00045d63ba8cb40a,0x0000c59900e96059}},
   {{0x000e1dda1887395c,0x0005d32a65deecac,0x000a9552940960f3,0x000a35d611ff5c3a,0x000058215b13c1e5}, {0x0009b58f0e1a5240,0x000bf590dfb8d48c,0x000d95662b406856,0x000f82c7605e049c,0x0000dd036eea33ec}},
   {{0x00071acc33156b3e,0x00096a80172ea501,0x000dc8eeff09d24e,0x0004ed6e1f72c676,0x000060caadd3e3d4}, {0x000f8a6979b1d8f6,0x000c37788d26006e,0x0006feec060908a1,0x00094e0e08f95b26,0x000018427c282e8c}},
   {{0x000333959145a65f,0x00080a4063373d61,0x0008a52a0cd9bc36,0x00058f92d11be32d,0x00006877b2887a1c}, {0x000819bf5cbdb258,0x00085e090249837a,0x000990e5f2a4fd1d,0x00011ae22a7de774,0x000040fa5a0f9455}},
   {{0x00074be6558842d7,0x0003a7f3d0a630b9,0x00042e46d70df8c6,0x0008230c80352075,0x0000251fe8054ecc}, {0x00034cb5e9aac9a8,0x000470045d71e591,0x000cb1d4e11bb093,0x000c90d3e5d9b5db,0x0000d97a90612def}},
   {{0x00093277946d3f97,0x000397472273fe28,0x000b6ae86e132bd2,0x0000677eeb510c1e,0x000077708c660595}, {0x000c8cd1297029e8,0x000c3bf9305e18e2,0x00085d6d92c61095,0x0005306466c2586b,0x0000ac06c375a1ea}},
   {{0x000dc39a13046683,0x0004d7f89606a365,0x000c7228de4a9c88,0x00030335a4898fac,0x0000e2347ffb4ca8}, {0x000fb77ea7d23a38,0x000ce72a71cda5f6,0x0006a44d32fac257,0x000d79e908bef87e,0x0000ff87567091d3}},
   {{0x00090b36b0cf82eb,0x00057615b5e7e58e,0x0009c145a6438d24,0x0001ca57b1f8fc66,0x00000d8b2dae6f1e}, {0x000dadbd9184c4d2,0x0005d93d997654d5,0x000147d473dbb18d,0x000608ea3e0f56d1,0x0000afa8c8dc0a48}},
   {{0x00053e8bc36742c8,0x000e6ea0ed902753,0x000477b00898f427,0x0001e2a6f4947e3e,0x0000ad8848ab0874}, {0x0003c38d74a2a464,0x00095ba17ba26c70,0x000b9a9e45e3e05a,0x0006ec81fa6f664a,0x000074a2d9a7841d}},
   {{0x00039ad653ae3263,0x000a774cbb438712,0x000d4c08314bcf72,0x0004af5737650e20,0x0000df86536410ed}, {0x0006fe7b53ca5557,0x000d3bd5d538d2d8,0x000d38468688cb00,0x0007b65f81bda31a,0x0000ccfe3cd60116}},
   {{0x00047e06c4c1fe61,0x000a198bbb79cf4f,0x000d45a14557e1f1,0x0007c4e93b974f30,0x000074a1d2d1baf9}, {0x0003b30c51fbf539,0x00015e68b2257a00,0x0000f4173d894099,0x000152cb0aa7b71c,0x000075797ca320a7}},
   {{0x0008c07e3533d77b,0x00097e341c9926e0,0x0002dc4edd7222e6,0x000cf7ed60ec3d8d,0x0000dfe0d902c476}, {0x0009ab61d056605f,0x000596a8551f1fe5,0x000fb8d8ca9ea9df,0x000b0f9489941e47,0x0000eb874ec3a7f1}},
   {{0x000ea867ee0d98fd,0x000b0bf61864fe5f,0x000c031d4201ad34,0x00082175d8fe4737,0x00005f49faf495f0}, {0x000b291c7f4a40c8,0x0000f30ddd92db0f,0x000d769872e69d9c,0x000b86f54e105449,0x0000a24911df662d}},
   {{0x000181060a716760,0x0008f66a8ad161fc,0x00017231ee852d1a,0x00011f172bbd6564,0x0000d6de7bd3babb}, {0x0006f88c8e347f89,0x00070bd99cc36fde,0x0000769501c58754,0x0003b9e8e54ed034,0x00007f0f335096e8}},
   {{0x000e1ce4924867ad,0x000f90b84917e4db,0x000b09a79bd5f51a,0x0003d7675300403c,0x0000b3fe0f9cf174}, {0x00094d8556fa9db6,0x0008c3412fbfed78,0x0007b9291fa26216,0x000233f63be0dbba,0x0000ca8b8c06c9fb}},
   {{0x0006aa9bd7638026,0x000005303da1ed40,0x000e62ec4c21486a,0x00033e01ae291ec7,0x000022a04933f993}, {0x0000c9dbb7a8ee0d,0x000b9c01aedb7fd8,0x000be74ecdc2ed3b,0x00071e65c35a1208,0x0000540cb1b169f6}},
   {{0x000ed4ecf84f6c7a,0x000b8d090f43d16c,0x000239db48561fb9,0x000d93de693d796f,0x0000736f92917bd0}, {0x000d9292c1950ee1,0x000346dc11b307b4,0x0006a878eda17754,0x00008a95dfbbaa7a,0x0000c70cb295decb}},
   {{0x0008c8b6f0f7c500,0x0008854dcc6dfba2,0x000b78642a8eba2b,0x000adf5ff8e89a36,0x000070c1c8ef6873}, {0x000c3716484d2e49,0x000e7d414129bbd3,0x000d93b0bfb78318,0x0007f69621a39c6a,0x000079d74c339e91}},
   {{0x000564761fb04286,0x000a5ee624d4fc19,0x000ae86fd4d78954,0x000b13594896e0b8,0x0000667ac0d291c8}, {0x000051243bcf832f,0x0006b00101379f18,0x000ba8aa7fbadf8b,0x000e84d69b4089b3,0x0000ac4baced687c}},
   {{0x000088d977eab403,0x0005f760b3909164,0x0000dd55351f4c5b,0x0001c9a238238f34,0x000058566c40b1d3}, {0x000d69e5068f5ff5,0x000c8aff6b063a5a,0x000debff0f31435f,0x0003315e549a5bd6,0x00009e5f0b7c5e01}},
   {{0x0002fb898559acf1,0x000e3db79b505d49,0x0009f66aa96018c2,0x00014f45f4a48f60,0x0000943b3af5900a}, {0x00096df15a40d39b,0x00039c20f7c5c224,0x00098404cb2a4468,0x000b76c6a35afa3b,0x0000ec75726af5d1}},
   {{0x000a163bea064441,0x0002e724b6f2b67a,0x00038c8ab27e95bb,0x000e172c20e3e9d2,0x0000213754eedd6a}, {0x0001020716e0f742,0x000edfc095c28c43,0x000ac29326679c82,0x000a760eb3adf4d0,0x0000cc970d321bb7}},
   {{0x0001f2f740f0e66f,0x000a3b6b23cc70c7,0x0000a8bd7545c616,0x0007215528cfcbb4,0x0000f8396341ab27}, {0x00027d9025ac99a0,0x00002b63e33b0491,0x000d84519d314d4a,0x0004bac8c310e728,0x0000fcb8983b3bc8}},
   {{0x000226138634818c,0x0003f44c2e0b2cc5,0x000dfdba3501814f,0x00018c37e181aa54,0x0000fd58ff1a7597}, {0x000db14d3b507a84,0x000e850bdad8f90c,0x000e5f9aa57bd478,0x000854e9c197e250,0x0000db6eef9240bc}},
   {{0x000f21ad1fc0654d,0x0002b1269d732cc8,0x0007f49f9c71cc96,0x0007931cfbb20407,0x0000de925729a56b}, {0x000d6a3f97ad8f78,0x000f124de3bd9abe,0x00040a800e6c19d3,0x000f070dce92f4a1,0x00005f44d1e9337a}},
   {{0x000c08b09d64c52b,0x000f45df97495953,0x000735f7da1b5e49,0x00076a836a8fb852,0x0000332b6dc4add6}, {0x00088a0b4511aa47,0x00026bd5cc55558b,0x000cd52bd0978875,0x00096aa6b43b9cd8,0x0000f0bc5a132a26}},
   {{0x00012d4c11f61ef0,0x00043a83e79e146e,0x000bfca159ce1075,0x00053f08ec73d96c,0x00009ff29ad5b496}, {0x00072bde7da946e1,0x000bde80a4f2e31b,0x000598ce4ebf9eb3,0x000e80c1aabd0817,0x00008b5fef463f37}},
   {{0x000cdd35958cd79a,0x00047d373114d5d5,0x0009357263580a1b,0x000760036e4c91fa,0x000038c534e8f20d}, {0x000e40a2ff5845be,0x000cdd78177f7088,0x0007f9920e5bb40b,0x00005c6f06a7a885,0x00003cc3e51c968f}},
   {{0x000b7fee5682d265,0x000f5ec7f87c1d68,0x0001951ab5206f76,0x000719f111053004,0x00008ec52c224b5a}, {0x0008f990f75cf9ae,0x000eda82d0d5f348,0x0008895abf411951,0x000b1347ee75be61,0x0000ae060d54d8aa}},
   {{0x000df737fb54dc25,0x000ad59636499ae1,0x0000550811f3e391,0x0009bcd42ec32afe,0x0000bd450efd491c}, {0x000fc67981eb389e,0x00075a0550d5367e,0x0003ce75ced7e192,0x000522562e776bab,0x0000890e308ff24c}},
   {{0x000b682feccef760,0x00058bba6d92b961,0x0002375c48b8e11f,0x000cfa8f2ccc4c2b,0x0000d7f7a52e2f86}, {0x000d30a9efe5633d,0x000a8451f934fd94,0x0004e6a002d8d246,0x000c4f5234c6e324,0x0000e2b5b0eadec8}},
   {{0x0003c5abf776f5b8,0x0000e0357b052ce5,0x000bf3f7a6f72407,0x000a9f3259371771,0x00007d2501cc40c4}, {0x00052e187b053405,0x0007d1624c324405,0x000facddbb7bf7cc,0x0007eef155a6ce22,0x0000a4228cbd8983}},
   {{0x000d6d6fd4fd6717,0x000e52daa10eef87,0x000c0eb96a233687,0x000be60562224403,0x0000632d184fbf19}, {0x000f8e940735ff4f,0x0002d00931f105d0,0x000fe3f183a3e6e1,0x00020641ccde6ada,0x0000381366bbfe51}},
   {{0x00022a960167d923,0x00084529f18c24c2,0x00053b11462f9d6f,0x000043112397c003,0x000034d89dd1f808}, {0x00063ba2a4383ce6,0x0006fcf92ba0d9ec,0x000be74c0cec8e93,0x0003919b8b4288c8,0x00007d6912f705d4}},
   {{0x0006c461b9131492,0x000f1a4e02da7b99,0x0002de59436aae2e,0x000545968aa00397,0x000084ec70d6ec6d}, {0x000b2d061391d54e,0x00061e114e92f3d2,0x000482dff69c5d5d,0x0003c4de0f00b5b4,0x00001596fa6d5bf3}},
   {{0x0005b5696a71cba9,0x00026dcadeb71059,0x000cd8471944938b,0x000fe11282da4cfc,0x00008ec05f39d37b}, {0x000ce1b0698304a7,0x0003b1bdf79be171,0x00021dec12d69144,0x000f7160cd3b741b,0x000012ecd8b86a15}},
   {{0x00000a700fd56e19,0x000269527c188d4c,0x0003e42e102ec969,0x000e0991c449374a,0x0000176fbaba392a}, {0x000f1ba44b7b6187,0x000981de491c8726,0x000b582c0b4d7aae,0x000a3a891df7b907,0x0000e116c315f60a}},
   {{0x0000f81466265d74,0x00020df7adf09927,0x000738f7fb15b6fe,0x000f95be33b2d3f9,0x00008553aba16d70}, {0x0002ac8c21e94db8,0x000d3dc0bbee2cc7,0x00040478f795ac38,0x000e548a1be4492e,0x00001bd3394852bd}},
   {{0x000dbe956b3c4f2a,0x000ef04177cc63c8,0x000010fc1017a99c,0x000b20f47bbddb4d,0x0000cf9b00c5b2c9}, {0x000bc8d47173611a,0x00080c7d756f2970,0x000d541a21a4cbe0,0x000f4366d9f4aa67,0x00003e8b689f9c2c}},
   {{0x00066da4d88f1dda,0x0004dad35deaaad0,0x00078ca67c604f16,0x000e05dedc072044,0x000010dfae15a02c}, {0x0001c76af36f4e47,0x00023f3f8f48eceb,0x000c8a68c994b229,0x000c9d4f9ed77b77,0x00004f544eac1744}},
   {{0x0005bb98113a7572,0x00046a9885e482d0,0x000a7865f4ef2d2b,0x000a51fe332be51a,0x00002b76b18490d1}, {0x0002310443516830,0x0006a3f22840308a,0x0001ed9479d86189,0x0003bf5959ddcd84,0x0000def0c94154b7}},
   {{0x00054174c7c15e09,0x0001aa277c32f010,0x000dccf5f539bfb0,0x0003bd5699268ef9,0x0000f5796a59247a}, {0x0009de84f157269f,0x00048a30196b8b83,0x0008a5a91c825c1e,0x000fe57ef0aabcdc,0x00004a8ce6d398b7}},
   {{0x00035a770cbac78d,0x000b26b239581cce,0x0006cb01183488e9,0x0006573341a070d7,0x0000a6c9d077e1b2}, {0x000fb30dd648c523,0x000c22fb9fd1b701,0x000563086994ca02,0x000baad69331176f,0x0000d2b810047856}},
   {{0x00048c85963a46e3,0x0005799e61c7e89f,0x0008517b4658ab87,0x0006563e296f874b,0x00006c4fcdd2c1bc}, {0x00027a1a3906def5,0x000712418945de52,0x000d96cde9fe95f5,0x0000ddd0c91e81fd,0x0000adbe47f2a448}},
   {{0x000370f396de2b60,0x000bf0ecc7bda009,0x0001d067298583d4,0x000984f44f6b57e5,0x00003d6b078556b1}, {0x000dd93b0b64912e,0x000335687b0927db,0x000ec20a99b3a343,0x00087b2dba646151,0x0000c93db80df281}},
   {{0x0008c2466e48bdd8,0x000891ccd78e00ff,0x0002506032514f2f,0x0001566ba11f4fe1,0x0000a22cd41a43fa}, {0x0008df4b283e4c6c,0x0008cb39783fa4e5,0x00025980978c2985,0x0007dc9235aee2a5,0x000016284b5ce022}},
   {{0x00079161338830dc,0x000b12123fcaa5f5,0x000c546f86d4b8a6,0x000d35636ea68af9,0x00001d36874ba608}, {0x000e4958d436d13c,0x0000cfb080afcd76,0x000ad3fb5d4d9c22,0x0002dfa65c1728e8,0x0000f1ebe4e73d57}},
   {{0x000746a584c5e205,0x000169dc7035a7a8,0x000548c9b267e4ea,0x0002f3093a15cfb9,0x0000e6e21359bd01}, {0x000cc6a8c8f936e6,0x000455c241dcdf31,0x0005efb868af84d0,0x0002cb03990a6f34,0x0000fef4e6219b96}},
},
{/* digit=3 [{1,2,3,..,}]*([2^21]*G)  */
   {{0x0008f09257226088,0x000a931cf5c6f636,0x000b4f7ac131260d,0x000828c0eb353bfa,0x00005c78880b7eee}, {0x00081ffc3bdf24eb,0x000b45c3c5a84c15,0x0004e6f405bff75c,0x0000c985e8c83fa1,0x000081d1c0fb295e}},
   {{0x0007cc8f43a730f8,0x000bb3ab590efcde,0x00003240be89b6f3,0x0005db4823f529ad,0x00002b79aff18bea}, {0x0002856962fe5de3,0x000b30c591f3568f,0x00028a8580c590ad,0x000f4befc74a144a,0x0000b662498e3203}},
   {{0x000cf0d6c39765a2,0x000d8c3cca0b91e3,0x000953b50a2db3ac,0x000f1a088f2f08cb,0x0000414582cef43c}, {0x0008bbc60eee9a8a,0x0001d29aa0428dec,0x00032f5d554c79f0,0x00015f381cd5ec65,0x0000672303b6f82e}},
   {{0x000afa8719c05631,0x000cac5fc79f376a,0x000750cd3cd8ad2d,0x00008e203fdb9fcb,0x00004ff052f5418b}, {0x00084cf3e2d65208,0x0007944ed509f750,0x000f25b987ebdf0f,0x000837743bf0f2d3,0x00006ad71d02354d}},
   {{0x000fe9226f435728,0x000add824758b827,0x0009094c1dfd3ab5,0x000d67b15dd23a53,0x00005c0e37ae6623}, {0x00079727be19ae06,0x00067f0d36b5575c,0x000b1ff7e616a339,0x00045341ebb3c826,0x000035b9485740ad}},
   {{0x0003cdada430c0b9,0x000daa96dac692bf,0x000ac326a4702850,0x0005e4391cf0a515,0x00005de4f4a3b8c2}, {0x000ad09e265c17ce,0x0003287b3881b01b,0x000fac5ca24e4546,0x0007a5f43e583ce1,0x000017cb3194ead9}},
   {{0x000924374dcec468,0x000cd4c2b73f6cc3,0x0006cd99c33cfc02,0x000f8902917844f2,0x0000819dd9651773}, {0x0002aa60871f4274,0x0005b6f01c340957,0x000f1f5af8e0cf36,0x000e503fa52988bf,0x0000eb357eb275e8}},
   {{0x000c8c4868af75df,0x000e55c8c7ead9d0,0x00081ecb0d7325cf,0x0004ecbb471996cc,0x0000f5d55f451182}, {0x00045411977a0ee8,0x0004f22038c6be31,0x0004bb4955085c4c,0x000081ad5335bff9,0x000094ad8a748e2a}},
   {{0x0002341ada354383,0x0008d49b8c4e5c3e,0x00017cf34f4a9fc8,0x000e108eeb355a9f,0x0000f311e0e9c91f}, {0x000003892ab98919,0x0000ae8ce9a9c2d2,0x000c53bee257bdcc,0x0004398b2d978988,0x000027ce89b5dba1}},
   {{0x0002cca523db2808,0x0009d0d43783b0a3,0x00097d16f5c889f8,0x0002e7d03e04b348,0x0000cdb6e7888f5f}, {0x0001cf0179c8e744,0x000208211d606ab9,0x000851200d8874e5,0x00040ab948d4d5ea,0x0000076d41f26f98}},
   {{0x000263c47b517ea8,0x000cb0685e5ec20e,0x0000631a079a448f,0x000346655f6f78f9,0x00008a790b2279e6}, {0x0000c7d80969fe8f,0x000351491bb96216,0x00095752654f92fd,0x000e7ab6645c235c,0x000044cc5afaea3c}},
   {{0x00083278b1e68b79,0x0009a03f29d3f762,0x000d03ecbc731ad7,0x0007a76e5a9ca957,0x00006c0d50cd1bc9}, {0x0009fe79b4f7f248,0x0007bd9967efc466,0x0002c208dfdd781d,0x000cb2f892c7c35d,0x0000bf64f7d2e545}},
   {{0x000862c467be912a,0x0009273d30ccc01f,0x000b83ec7f4c85ee,0x000cf87fa6f4be6a,0x000007a3c1cee3e3}, {0x000ef450c00beb33,0x0002d00d4c3e87f8,0x00008bf5b30e2c2b,0x000f51eaa00b94fe,0x00002c133aac224e}},
   {{0x00016bb32e5685df,0x000868e6f54438df,0x000c5ebc668a9e06,0x00035e595aaff7cd,0x0000894a646278b1}, {0x000350a09e27ecf4,0x000e18f7179df316,0x0007861baeced201,0x000e2deeec273ce9,0x00007ec2caf1693b}},
   {{0x00097c4f68367ced,0x000aee5a5755fa4c,0x00098a979e4f47d0,0x000c7c47de815db2,0x00007eca65a9177d}, {0x000bb7149ded0a33,0x0004cb34d3c520fd,0x000858a334cb2aad,0x00040efcf31d2860,0x0000b6873efd24aa}},
   {{0x00034b22c11bb373,0x000dbd4c74a35402,0x000c5f25d2d0366d,0x000142c9a968daee,0x0000660106897b63}, {0x0006d2c68d7b6d44,0x0008cc84294207cd,0x00068b1eea8f74f0,0x000ee4a275140477,0x0000b5f7e8a3e62a}},
   {{0x000717789070d267,0x000e6d1c8bc7c6a7,0x0009e1f17a1f28e4,0x0008e07a5f4f0646,0x00008fc242b6bdb7}, {0x000c5928b0588f1b,0x000c6535921ec9c7,0x000e5ae35b6b7a0f,0x0008641c5bdb91bd,0x000042c485ec2ff1}},
   {{0x0003e13dbab98aa3,0x000b717b1024a111,0x000462d3ade9d469,0x00078cf3f48b37c0,0x0000752e537ac5c0}, {0x0006add15544eb9e,0x0006a0fba279e3a8,0x0002001b5f013aea,0x0001aaab5bb76cf2,0x0000617ba15d0289}},
   {{0x00082a6936219d36,0x00044e51cb19d391,0x00007a74c5ce1f19,0x0001bc678f8598bf,0x0000d7158f282cbf}, {0x0006b21e300ce18d,0x000f5d11275d3b84,0x000239b9b35fba62,0x00093f8fe25c36a0,0x00008beb35eaf05d}},
   {{0x0002bb01f7e320d9,0x0003dda320ea4db0,0x0001389a30641c36,0x000e3cdd95fa5d82,0x000026997491fcd8}, {0x000ef17ceb6c1434,0x00019933762b316f,0x0008b17f867fcb84,0x0008217b837e3511,0x0000b92552fdfd24}},
   {{0x000c70e46aca7930,0x0004e579311bae6b,0x00002f7161cf0b0e,0x000e4d8dc631be58,0x000099bdc6fbddbe}, {0x0002bb20caf8b051,0x000a62d63df2cc35,0x000c4f408f74d505,0x000b2da9876d4b91,0x0000ce18473ae229}},
   {{0x000759783abdb4a0,0x0006dee84b184950,0x0009e67dc850fbcb,0x0006d86325236e60,0x00004d831d99336c}, {0x000ae3bfa12d45da,0x000da746e2468dea,0x000f5f31ee425f8c,0x0003b6e004c17524,0x0000ca16d904d62c}},
   {{0x0005a6a9152f9347,0x000d7d0e12c10dc1,0x000477dacf1235e5,0x000006533c06ecda,0x00006be873322ea0}, {0x00078310c0cd3130,0x0003a614260dcf3f,0x000b22d153c52455,0x000a2031a756f8ca,0x00003ee10d177827}},
   {{0x00059b21994ef202,0x0009438ae318d1e0,0x0006990102a653b6,0x00084a50d5eb582f,0x000079739f729f5f}, {0x000663c8b799336a,0x000c803c37eb5da4,0x000dbfb2dfdfdf14,0x000f9a92d8a9dca1,0x0000b40cff117d48}},
   {{0x000b383d20b42d5b,0x000eef78845fc018,0x000ba9df0f9a810e,0x000df890af3753bd,0x000090bdcfcc31df}, {0x0000591f01ab782d,0x00009af12a881872,0x000c14401c823f21,0x000be2d51b80f30d,0x0000e248f78cb2df}},
   {{0x00044e50cafe751d,0x000c04dcd221ef5a,0x00085402473997c9,0x0004ba62fd86d1de,0x00005b53add709b8}, {0x0007a11dcedd8d12,0x000854b32c84008d,0x000dde8b1406bd1c,0x00032f3d4472ff05,0x0000e25f2ce1ce2b}},
   {{0x000dd5e29dfc254e,0x00054b98b267bec0,0x0002df2ad4455fcf,0x0003962b4d43a5c7,0x0000a70e6bf28a75}, {0x00061695820f3bf6,0x000d3e37f68f2aad,0x000e5ac83f410d2d,0x000eec10fb7dba7b,0x000036bb64596ec3}},
   {{0x0004ea39754e21c0,0x00068d63c3732710,0x00009db9abc87a3e,0x000da7483351d741,0x0000fa724e360134}, {0x0004c29b0720b169,0x000276aceead9ff4,0x0006929a62dd0cf1,0x00092ac942758ce2,0x00006c5db934766a}},
   {{0x000d4c05f18395e0,0x00041f80d032cec7,0x00086075bd3f2274,0x0002db7a68b37acb,0x000074764ddafef9}, {0x000e9507bc7f3893,0x000089756460ded1,0x000a48157c580c85,0x0007b37eeec2a47d,0x0000f0b4e7fb2c58}},
   {{0x0006de8a9f19c539,0x0002d974e34e231c,0x000508fa95717bd7,0x00012449e1d216f1,0x0000f1123626adaa}, {0x0005e31823b73482,0x00058c6340698014,0x00097c2584dd8f0d,0x000431c3d82fc722,0x000076fcfeebcee7}},
   {{0x0001b5e2bc0aea9e,0x0004fe3294318eb6,0x000e4b87e4f668fd,0x000f0a23a32ab138,0x0000137451853d0e}, {0x000f7e6853ac983a,0x000dc8e78a571a46,0x000a96dd1c3bdf42,0x0004600cf207852e,0x000010649ba91638}},
   {{0x0009f0b879fbbed4,0x00069a9d1869f236,0x000766f450ff0ae8,0x0000fc1251d75956,0x0000984d8c06be8d}, {0x00095a6d21008f03,0x00000a1a1c497ecc,0x0006c50f329bd54a,0x0002517b9828c5d2,0x00002c0087c81d0d}},
   {{0x0003ce60c1cdb260,0x0007557ca2059bac,0x000b1fdcdcd94d94,0x0001491b1bd5989d,0x0000eda0108a3d8b}, {0x000661056152fcc1,0x0006d7192b339506,0x0002e05a4c2f037e,0x00062eceffb41ac9,0x0000105f6c2d2f6c}},
   {{0x00035008733913cd,0x00026f3adc4068e7,0x000a278e9cce8616,0x0002922407a94238,0x000013c1b9dfab21}, {0x0007ec71c74cf5c3,0x0008c1a4c1b493ed,0x0003a11f18887dc4,0x000cb60830ff304b,0x000058c5a3c88937}},
   {{0x000c404890228299,0x0006ab798f79027d,0x000be6ead40e9397,0x000a5d00ad333738,0x0000c23f6bd834c0}, {0x0001a35fbffd8bb2,0x0008f949d3ddd171,0x00025d93a60fcfb4,0x000967e9c8ef4b78,0x00004233cffc0a8c}},
   {{0x000e46ce6d982af4,0x000ea7544d7c67ad,0x0008bd087ebb6bf3,0x00028096b9ba763d,0x00006fe382d8dc61}, {0x000a7e8b5bdbd756,0x000158f228febd39,0x0001c4300ab38133,0x000eaba709a77cce,0x0000a247e575337c}},
   {{0x000f21b636288bec,0x000408a7c3058f34,0x000919e049dfdca7,0x0001f7adecfd1bea,0x0000df2688e4e199}, {0x000df44d0f8a67ee,0x000a2b58d010e607,0x00024f8f4d985df4,0x0001ad77f834c50c,0x0000976ef5780bf0}},
   {{0x00095aca1c323732,0x000a534c0a135363,0x0006bd5bc351027a,0x000bedb2f1b5d65e,0x0000b539e24423de}, {0x0004cec0eaa1d710,0x000d661dcf65d499,0x00054c7402a83381,0x0005ee5f1aed2f7b,0x0000bea3fa5d6dda}},
   {{0x000b68436cc61347,0x000350a443dd9d4f,0x0003b7d2a8eb9bbf,0x0002578c500e2e38,0x0000aad621ccb775}, {0x0004d740a8f7cc07,0x000d97562d656928,0x0009758eee820c2c,0x000c2d4f9531b949,0x00003e95ca5dee0c}},
   {{0x00090abfbaf50a55,0x000b184e0750f617,0x00076b005df55e76,0x000dc79c516da7f1,0x000075553bbca2dd}, {0x0007ca3553afa736,0x000bed55c25137c8,0x0003e5d35315f3ff,0x000f288846442aaf,0x00001b91149c495f}},
   {{0x00095d3fa326dc3b,0x000e68fc2cea23cc,0x000a37d591df4da1,0x000e1d74bf9adcd0,0x00006710053e20d6}, {0x000667e618344d14,0x0002606445af96f9,0x0008dbc3acc7ce04,0x000a5b602d8514d6,0x0000ea109e4680b5}},
   {{0x000a7acb40961bf5,0x00071aa56bfa5741,0x000b765d14ada593,0x0005822feb914502,0x000061e97bf36ad1}, {0x000a5b6da3982f5d,0x000ce546f468bbc4,0x000612d200c2659e,0x0008dfe8e7e6aa59,0x000083dfe217c19e}},
   {{0x000c45fb835398c3,0x000f838a41c28530,0x000f5dcdb6106a8b,0x0008ecf1e8f9a635,0x00009707137fae49}, {0x0003834d8249f00d,0x000edb2537a070c2,0x00061c0c29f14b58,0x0004a70043c3655f,0x0000c5926d6d9a19}},
   {{0x00003398e77738ae,0x000f1ba46426ddec,0x0007f6e86d07a63e,0x0002404e58e79cee,0x000059b045adf32d}, {0x00084e520fa03389,0x00085aff5acec5ec,0x000a3831397939ac,0x0008847310a4e3b4,0x0000115fba31f9d9}},
   {{0x00010c25fadf8c35,0x00027e19c0e28dd7,0x000fe502266be38a,0x0001b8842a279c4c,0x000097bb5305e24e}, {0x00086b7c153ca7f9,0x0002e07d63bd3cde,0x00060d21ea8d30fb,0x0004ab1c905f92bd,0x00008e7ffb70b9a5}},
   {{0x0007df8e9726a306,0x000f4fce3533d714,0x000f1ec40b5e216f,0x0003fd5550b7992f,0x0000b613b8801e95}, {0x0008dba792d56100,0x000aa190fbe187b8,0x000f581da2ee1270,0x000a9502f4e2dc2e,0x000016530e4eff82}},
   {{0x0003dfd8fd6ee891,0x000636848fffcbb9,0x000a47adf16d3d98,0x000a71500eff241d,0x0000b9754a01ad47}, {0x00066df70c33b988,0x000e5f34186e8f92,0x000d24132aadc87a,0x000eb98d2ce8e14a,0x0000a47cbfc99946}},
   {{0x000eb6662b5f3af3,0x0000dabb373447fe,0x000f35cb1cefab56,0x000eb9149de60e19,0x00009f8db14457f0}, {0x000cc5b3c61bfd60,0x000d41216703ffae,0x0004e1cc2a5a4d41,0x0009537f8fabed22,0x0000d5a8186871ad}},
   {{0x00074f7d22da9a9b,0x00081c8a9b0df107,0x000c32cff45b8a67,0x0002a529c2e722bd,0x0000f71b5f5e3720}, {0x0007f2f69fc4db96,0x000c165d01e195c5,0x000904635b6dad34,0x00088c1e0bd13fcb,0x00001751253d63a5}},
   {{0x000299781af2c2d1,0x000471b9d7dad85c,0x000533e8dc0f7d9c,0x000311738a34ae08,0x00005c4cb08411d8}, {0x00032858e121e14e,0x000da5000a5f97f8,0x000256274eea7dc1,0x0005bf2c6059b65d,0x0000c9beacf99507}},
   {{0x000aad71df978283,0x000578937877173d,0x000646f3cbf851cb,0x0003528083c59401,0x0000bad30cf80c6d}, {0x000b202496bbcea3,0x000ee8a1e8bafeb2,0x0000660293cf9fd4,0x0004f8a26de7ff1c,0x00009c81e9e7e9ed}},
   {{0x0000cb97b390d355,0x000d464aab27d8be,0x000ef64f801df2bb,0x0001dcee8c1a65c3,0x000067291d1c16ed}, {0x0009c6c5f5406d3b,0x0008aba8e23f9549,0x000096ece71fdda3,0x000d161feb320ed5,0x0000e7ba92c7a66d}},
   {{0x000d36bc6fb5a7df,0x00097d2dd0e04608,0x00097a36ae3eea15,0x000e1d85b0a3eb8f,0x000059814cd0c83d}, {0x000c5b01c33c23f3,0x00043faa413656c9,0x000316551a96c1da,0x000c8f16bf2074de,0x0000b866e7b4f756}},
   {{0x00027d81495ed6bc,0x0002f682dce77277,0x0008610f3b239424,0x0002a3cab8454e75,0x0000243ce85457d7}, {0x0000d71dbbf370fb,0x0006c8e0f7ca7b32,0x0007b523fff9afa3,0x000d415119d1e0ea,0x0000997f8cbb58c7}},
   {{0x000cd2a37bbb1840,0x0009a45d1fa6285b,0x0009634cb51dcec4,0x000ef16ade3b64e2,0x000080c94a726b86}, {0x0003db12283fbe37,0x0007ea9315edba58,0x000964bec902bddc,0x00030097c1ccb386,0x00008f4ead026258}},
   {{0x0003a4956f908239,0x000fe41d777b4bdf,0x0008bf760ba0f507,0x000b01791d71c3f3,0x0000633d5102b625}, {0x000b743b8c9de617,0x0003ede7472003ec,0x000ce1cb2b475125,0x0002ef2f9defc974,0x000074a4f6a70bd3}},
   {{0x00085f773848f22f,0x000603f8558eaca3,0x000c471f953dad71,0x000bc6bb7b34b093,0x0000530e06a09644}, {0x000b1ffdd59d31ae,0x000e28daa7953d9f,0x000cc88d74382e0d,0x0008ff365c6f4bd5,0x0000aa392d62a18c}},
   {{0x0003c67648024ee6,0x00022c2fabcd9420,0x000aec835188763f,0x000d54480f87acbb,0x000032c96e1529d8}, {0x000a60e4c00a95ea,0x00004011e9fa29b0,0x000b772232ef17f4,0x000e3256c0e1d115,0x0000aec2c62b4b04}},
   {{0x00088d83d84e58c4,0x000c558571dbd356,0x0000682a62af5094,0x00007c0fff7e1976,0x0000cb27078239a4}, {0x000c5474ff0e321a,0x00057b34c8ff0f59,0x000bc1ba7169f34a,0x0005438bff109652,0x000025423b823583}},
   {{0x000d5d50ac8b7823,0x000bfdb3c8925d55,0x0008bb642ff6622e,0x0003dc18fce7416b,0x00001d6998c99d7e}, {0x0008004cadcaed01,0x0002c81d053cdbaf,0x000630ec6801b014,0x000c8e84b189fc59,0x000020e9934bf762}},
   {{0x0009aa4fdc6a4043,0x000e7190994853a2,0x000e8968119d8e01,0x000d370cfcabf1d7,0x0000321a50d7e132}, {0x0006863e9a861112,0x0000e6a3bc65d049,0x0009f8eef8c0cde6,0x0001418f866c49fc,0x0000066350f1f7f5}},
   {{0x0004689e56ddfbd6,0x00079e32983a4f8a,0x0003cb8cbea1b0c0,0x00029ecb31746287,0x000058deddc8d932}, {0x000af4d0f64ef589,0x000ce30cc7a865ef,0x000047d70fe43287,0x0006c91ebc0c723d,0x00002efa53a692d2}},
   {{0x000845794b565268,0x000e8961002d06e7,0x000dcb10f415cb80,0x0009fe09e5c56576,0x0000bbb69837f925}, {0x000795b9abc26689,0x00038e678fb14fe8,0x0007da2b9b5d4f53,0x000804d601f3be7b,0x00008da59e3313d6}},
   {{0x0008ea601799a527,0x0001486d2952190d,0x000ff2a7ca20cec4,0x000d36c062ffb27f,0x000041b32e5e9f19}, {0x00081814eb57d471,0x000406aef06bf80d,0x000ecb5887a2d0ed,0x000f5af9735fb01c,0x0000641caaad6061}},
},
{/* digit=4 [{1,2,3,..,}]*([2^28]*G)  */
   {{0x000824f20151427a,0x0005f24302067f99,0x000112357206828b,0x0004ec0a9097d7e1,0x0000cf9a2f2a9e41}, {0x000c9da279153564,0x0006c01efee3dbda,0x000b288e27e0734b,0x00009c14fab5bbd2,0x0000c630fc5362dd}},
   {{0x000107a1ac2703b2,0x00084bc857b58537,0x000daccd1b49258d,0x00052937df14debc,0x00004ab68d7e4ae8}, {0x000b5d4734e59d08,0x00084495cc807ed8,0x0001db9b35f8740c,0x0005be04aedd5a29,0x00000b360f8cfb99}},
   {{0x0005f5d5fa067d1d,0x000ec668960cae91,0x0008edaac4134b57,0x000435ed3656d6a4,0x0000ac1e3e5cc1d7}, {0x000f869d81fbb26c,0x000bf26c33d4674f,0x0004203e8449ed3e,0x000f49c5138705d9,0x0000cde538c7eeb6}},
   {{0x000c68da61a76fa3,0x000d9a1554dc55d5,0x0003b279c598b441,0x000efca39923b977,0x00003331d3c66bf9}, {0x000848e298de399d,0x0006d1a27f562d4c,0x000b8ab70cfdb8e7,0x0009b9c4c855ea57,0x0000cdb9daf3f787}},
   {{0x000f8c2019f2a596,0x00036b4fbc747bdf,0x0009173ddb3ce5bb,0x0004398a907f688a,0x0000cd3d0d3f5a75}, {0x000c4d6efed021c1,0x00005a77339a92ec,0x00088c64a09a9f9b,0x00015877ca6b1571,0x00000c2996854899}},
   {{0x000a229ed6e82ef1,0x000355ebaf4e5859,0x000ad67ae16f338e,0x000bb3fcd313875e,0x0000c73d22864ef0}, {0x000513174a5c8c7d,0x000faf69ad6a4cb5,0x00066f87e01cd296,0x000320d04d00dde9,0x000096fe447db7b0}},
   {{0x000c06e88fbd3813,0x00042c35a493342a,0x000f1bbcd02cd4a8,0x000d4cb8fa89de54,0x000041d63675575e}, {0x00057fbd238202b9,0x000a1984ead9ebe3,0x000436ea0600b4d1,0x00051b335c9f4452,0x00006fe0a3a33707}},
   {{0x00007367f636a38c,0x00064e76d5cb4c4f,0x000b68b8b9f943fb,0x000a1ef03510baa8,0x0000246780b5ed07}, {0x00014156d549fc2b,0x0000b07781ca3c05,0x000d95413c2953f3,0x0002e2e55e2c69d8,0x0000300fadd2bd28}},
   {{0x0007b5087e9189fa,0x000c542dda2781fe,0x0000a5904db17375,0x0008e582f7d896cf,0x00000e57c5b8be34}, {0x00011d3f40e3c80d,0x0000bdb705c5a610,0x000fedec3b118932,0x000c1c7ed9309e50,0x0000cf14a111d6d5}},
   {{0x000265b556913429,0x000401049dc7056c,0x000bae20ae8e0850,0x000db3831329f5c9,0x00006c8b3e969dcc}, {0x000f838fb4ee6b40,0x000b41e8ccf08c5f,0x000e050c6fc5a9ae,0x0000807417b764fa,0x0000953c3d700452}},
   {{0x000268238dfe7e82,0x00050bb79d4b2137,0x000e7cf2dea417e1,0x000fcc39641f1c76,0x000071e305a0a0bc}, {0x0007dfd7253ecbd7,0x0004dfca6186624c,0x000866e9c2f552e2,0x0006105bf84ecd4d,0x0000396770a668d4}},
   {{0x0001163c27901b4b,0x000fd99b8bf3a14b,0x000c6da0afd9236d,0x00029692b091eccb,0x0000b1dac700ad1d}, {0x0001d53a91cf76e1,0x0002c31f1ee780e6,0x000efcf774110a41,0x000d761d87c3ba13,0x0000f374bb4ef450}},
   {{0x000e2f20d188dab3,0x0000c4b885ef5e78,0x00014570fe3968ed,0x00052116c0568e73,0x0000161633831170}, {0x000e7e24f0c8afe3,0x000faeea78da18e1,0x0005d8a514caa75f,0x00037052db67f27c,0x00006a44d869f505}},
   {{0x0005bda0333974fb,0x000d77a70146d72c,0x0000ef9215db516a,0x0008e48470528121,0x0000ff17a8fbc9c3}, {0x000814e12476da14,0x0002f3c1698078f4,0x0004d4bcac1e1661,0x0000de5e5b386f42,0x0000c274e8808574}},
   {{0x000b88d6c2f5226c,0x0003950d7ca8b6a9,0x000c4170914d1b94,0x000518980c85fc1f,0x00001da368c14c6d}, {0x00085ced5113cf71,0x00034a34708f2b07,0x000cc3f880670f63,0x000c8f36e2376715,0x0000b480cfa60c72}},
   {{0x00086024147519ad,0x000b56b372f02028,0x00085ebc8d0981ea,0x0008e8d9d4a7caa7,0x0000953c50eabdf5}, {0x00061ccfd590f8f8,0x000ac4e6c9179d63,0x000eb64cf72e9626,0x0008f2ffd9611022,0x000063ebb7f1eb28}},
   {{0x000b7616aca8ee7c,0x000917b403586e6a,0x0005feb0d97d10b3,0x0002795687d3771e,0x000083e50e54265a}, {0x000a9fec954b3132,0x0007110d1f618f75,0x00057d0e0cc2e8f4,0x000207d5ba81c565,0x00005f9680c5eaf6}},
   {{0x00066094354080b3,0x00054bf2fe1cf95c,0x0007d98fa5225bfa,0x000f6095c004e25c,0x0000561bf1c319aa}, {0x0009f17ba1514741,0x0004a04f6eca5e6f,0x0009acb1edec2f93,0x00049354e368a126,0x0000332d9e41cdda}},
   {{0x000cf69df23de05b,0x0001509339a060d6,0x00069392366d17da,0x000a6cefcac9850a,0x0000cf057fd9d7c6}, {0x000c8c5f0b5662c7,0x00086cba4f24c3c5,0x0002b69ff25318dd,0x000c00f0e8cb7508,0x0000c23b3ee8e728}},
   {{0x0000a0a097e4403b,0x00056985466515e1,0x0007d4826cb3d0a8,0x000838d8d8e211d6,0x000039af66ebb9d2}, {0x0004588bd475ca8d,0x0005f077b80ba5f9,0x00027c26ce06b796,0x0005e02edb1485da,0x0000290d33bce0fd}},
   {{0x000cc47f34fb0fa1,0x00080fb1ab09a40b,0x00073bfe3b4760cc,0x00013c7fca0993a2,0x00003e4fe08070b2}, {0x000b992fdb05163c,0x00004c2b19b63bcd,0x000f2e3e28c484b1,0x0001b35acb815faa,0x00006905936789ff}},
   {{0x0006f9d586e74e18,0x000ce7b80484b2ad,0x0009c3ddb488883a,0x000d30f58aa2c736,0x0000ab74e6a1f9af}, {0x0002d285e21beb19,0x0009a18c42f910fc,0x000cf40c33484518,0x0001d8a77427dc53,0x0000de0781ac91bc}},
   {{0x000e858693807e1b,0x00069e81ccc78fae,0x000835b84a386532,0x0008d352c30ff26f,0x0000604437bbd3d3}, {0x0008a985ca1823d5,0x0008b3be0324b3fc,0x000684a33b82f7ec,0x000f7d9e36d761cf,0x0000a01df0eef29b}},
   {{0x00002f31306583d2,0x0000237c622e6862,0x0006a7bc805b10da,0x000e439f9aaa0f07,0x00005e94efbaf8f4}, {0x000c9b7fa3dc26dc,0x0002d6ff03c58a35,0x000c394cee0e5fb9,0x000e5fe77e3843eb,0x0000ede65964361d}},
   {{0x00022f6a19935459,0x000594d671bad27c,0x00069c28eab01cc3,0x000375d3fa2877a1,0x000025ef904beb08}, {0x000a3cf53aa0b32d,0x000aa1c49d7a3b2f,0x00005e27fb27beb5,0x00070ce60e1834d1,0x000060897891f685}},
   {{0x0004ce0d6fbc2acd,0x0000b15ff5512309,0x000ef119c738037a,0x0006ba0a73b1bb6b,0x0000cf6c431bef50}, {0x000fe7be3ef104a2,0x000bea06562800e4,0x00092043eebdd9a2,0x000108653a81c387,0x00002ad6eced3b59}},
   {{0x00013c039cd297dc,0x000d45bda5d99fb8,0x000104b968ec7e16,0x00050f6834797c0d,0x0000c11a2e83c511}, {0x0005a5396ee63809,0x00053ea3874296ca,0x0004dfa7d054c865,0x00020725946852d5,0x00007c422e7af4ab}},
   {{0x00075090c22b5403,0x000a87c267d4bf90,0x000b0d6932cde42a,0x0000d98a18f9ed5a,0x0000ba62aa69e466}, {0x000f97bab9ea96a6,0x000283b60e32b24b,0x0004d9bd55d03964,0x0006a3ee6a45067c,0x000066c5b9eded4a}},
   {{0x000dcd98edbd7cc8,0x000746ccd753fa3f,0x000e6b64f4660bb8,0x000b3f1ae9082021,0x0000a56a714336bf}, {0x000e0965726d47f7,0x00019b1a9a7fabfc,0x000b74a379eed01b,0x00066cc0e9cad44e,0x0000b2524ccc3e96}},
   {{0x000683b8f4b002f6,0x0009e1f4fc206a29,0x000338accc2200d7,0x0009756f3af47a3a,0x0000539a4fc47128}, {0x0001c14c33c7fcf7,0x000b57be322bcec3,0x00046f6237eb6799,0x00099aa19ef4e966,0x0000b7a26a5c4d72}},
   {{0x000f08d403f46f2f,0x00022a0ec0c7cb37,0x00032142f94b8fc4,0x000a79cb8514e3c3,0x00003ed2c34d80d2}, {0x00080afb639126c8,0x000063553ade8d20,0x0007e2b09f7b6be6,0x00002ab950aa9f1c,0x000047ff958e410f}},
   {{0x0007cf5678a31b0f,0x000d4998b620877b,0x0000fb396d50301a,0x0002a5834257c5c0,0x00009fb18a0f4e67}, {0x000d8ebe8758851b,0x0005ad99ba44ff8b,0x000fd93b71e64e4c,0x000b8b9b8eaedf7d,0x0000a2f2a98b4e76}},
   {{0x0000cbae8053433d,0x000f6d2c95857d79,0x000d8f5edc8e7259,0x000e1c88c5c476cd,0x0000106b953bfa9f}, {0x000775b0eff13a96,0x000a8057b9303c5c,0x000b70cbd242442b,0x00089a89f458d4c9,0x00009b7144903cdb}},
   {{0x00046f60e2ed7422,0x00052006749341ee,0x00054c304573f104,0x00050291e154ff9d,0x0000ad0436aad3a7}, {0x000aa2d431a8121d,0x000ab86f11edee4a,0x0004a0eb7cd38b3a,0x000e5787d49ea603,0x00002b773bec7e85}},
   {{0x0009ac49b5c1f14c,0x00097e54df2b4a55,0x000a41891c444be1,0x00078753aad704ed,0x0000d927bed1eb5c}, {0x0008516e48c8a348,0x0001cb546669eb3c,0x0004df8ec1b7ac81,0x0008649815f89659,0x00007c6a79cf9227}},
   {{0x000a2f09b56ddbdb,0x000bda2f1cf3ae02,0x0009dff0d1339b5a,0x00043d42b569c783,0x00000b9e865aee9a}, {0x000ca4177bb064e9,0x00026d249f634ff8,0x0006f689a145a281,0x000f5daab7beacf8,0x0000bafec2791d35}},
   {{0x0004c654265aa91f,0x0003135efe422805,0x00039dec7a4b1830,0x000ea47887b0e696,0x00004b8f6ae2d52a}, {0x00093cc971a8a130,0x000d4c934d07fb92,0x000acbc293f159e5,0x0001292c50e9b109,0x00008eb65e67154d}},
   {{0x000f58930b75c3ed,0x0001c4491c934fef,0x000af62bb0bb82fe,0x00049f08ac377a89,0x00007b514916685e}, {0x0009a7b04497f19d,0x00094a7ad13fabca,0x000c86ed61b35ed0,0x0006f09b601e213e,0x0000a91fcba9e0c7}},
   {{0x000507bd7ab27e14,0x000523945b7b9e28,0x000fc98277c19a55,0x000b912b43f0a1aa,0x000043b4fbd7aa55}, {0x0002e656962c88f7,0x00045e0db0ca962b,0x0008d6c4f139da8d,0x000824493f05dd1b,0x000079cdff7880b9}},
   {{0x0003fddae57c7b7a,0x00017b932522bba2,0x0006d4aa3345342f,0x000b615d9c80fe55,0x000003907bb0525b}, {0x00010e1ff2189336,0x00044a52117b38b0,0x000f2e6eac066b65,0x0002b22e14192094,0x00006a27dca6d32f}},
   {{0x000f993048b37172,0x000a9178ae1c69c7,0x0004f1d6bbf5a989,0x000e4e29fa905856,0x00007ec6e15f31fd}, {0x00003737276e7fc9,0x0008f9d6bf024cce,0x000cdd97964086d7,0x000630ca72f0464c,0x000009c3566d7775}},
   {{0x000bc6b75dd7125f,0x000697a0428d1c07,0x000eb6b9db4c6bc9,0x000431607ece52fd,0x0000ca56513a2c95}, {0x0007181d0e8bd06b,0x000716bb46ea15d9,0x00052b624384dd31,0x0002faa441ea2039,0x0000cf70deefe7dc}},
   {{0x000016e6628e8c30,0x0007b60a7522372b,0x000344ee207a0d66,0x000eeccf05751b0a,0x0000ec09a48118bd}, {0x0003d4ed83dce467,0x000d29d2fc6e6e4b,0x000cf044c43a6316,0x000fb7399d898956,0x0000c7f44551e3e5}},
   {{0x000b121fbabbe926,0x000b81330076b2e6,0x000890015281850f,0x0007f4a93581ec97,0x00009b1ddedd5ff7}, {0x000b18fab1051053,0x0001789ccfef7cf0,0x000914009953ced3,0x0008ad0151f85feb,0x0000c9f1b87b8ed4}},
   {{0x000a1a14a7eadcb4,0x0001122e71cfc9ab,0x0002e4f83928e750,0x000bd3aaede7273a,0x000067e10d15ce3b}, {0x0002ac3b955dcf05,0x000d83d5e527f344,0x00077f474ba96307,0x000ff0a763a10efd,0x0000d744bd0ba6e1}},
   {{0x000282aa777899e0,0x000fd03f3cded287,0x000b07d31e20eda8,0x000de46a7e75bb50,0x0000b7e2a946f379}, {0x00064ad19f593cf4,0x000ede76ef1d31cb,0x0002d609c7b1a9e4,0x000650a18c9c9db6,0x000039bad6e2779a}},
   {{0x0009066e032f1445,0x000898b2ec6a219d,0x000a12f781db632b,0x000265af0d0fd4fd,0x00006fb4c2d7a25d}, {0x0002ee1255a03f19,0x0002596af1765f4e,0x00068bc9761cd6af,0x00088e50317ba8d0,0x000027d6babb64b9}},
   {{0x00007e0e90fb21e5,0x00006ba7fca1a18f,0x000cd67b500fd2b8,0x0007f6d0387f2795,0x0000b89a4e823970}, {0x000ad3f894407ce5,0x00041c2261328f83,0x00006c13ba0025b9,0x000025779563c7f9,0x0000f548f319e7bb}},
   {{0x0006b8feac6d1135,0x000bbe813c762b4c,0x000e1f4b9a67e3f9,0x00050de982717c3f,0x0000886581976d80}, {0x000640cf7f06f200,0x00062a66ebc299f3,0x0007a1e08dc61021,0x00071b52f2c17576,0x00005660e1a59998}},
   {{0x00017626d3c46934,0x0006f7ed7bea6b0f,0x0005b226df0e7d62,0x00013b851758c7b7,0x00000a886285f916}, {0x000baa7bbb38ce0f,0x0004cddcad81889d,0x000c9671fe0404b6,0x0003750ebccd3a8b,0x0000bf9a358de1f5}},
   {{0x00069b028f33398d,0x000ca2e90f655dc1,0x000ab1eb1b07ec11,0x000389de7f3b4afa,0x0000970195f2f175}, {0x0005cbe0181e6402,0x00020643313d52b0,0x000f31f82f5debd6,0x0003c5561481545d,0x00003e03b335a9e1}},
   {{0x00089494fde0c1fc,0x000e25b6ec20ff75,0x000e1db6cbf8a1ab,0x00058eb02278fb87,0x0000447ad7af5ed6}, {0x000aa3803d0ccf24,0x0008419a7c0348d4,0x00017cecc80acb33,0x000d825bc7c89e6e,0x00006736b8b43be1}},
   {{0x0007b60c0432f963,0x0003aeb5442fd65d,0x000ff69a2ddebe7a,0x00012249a253077d,0x00007a56d9432cf3}, {0x0008aedf2350d0a8,0x0005837b0d9a8bab,0x000c65cae13c3f27,0x000a884664957c44,0x00008b4408a42e71}},
   {{0x000e5a35cb026649,0x0000f686c72edb88,0x00082d53e5d4c0bf,0x0004315a3d9b62a6,0x0000b605ef49b2ad}, {0x000c202c69645d0f,0x00097a1b66e771ba,0x0008f4dc4a115f03,0x00078c0e2c563a15,0x0000715b3a13d12a}},
   {{0x0000a48d413213a4,0x000d804becdb8f7f,0x0008587f52035806,0x000a71acd34a995d,0x0000d8c3079df6d3}, {0x0002a678d95a8f6a,0x000d52110d0d1b2a,0x0008fba3fc58c9d7,0x000f683eee81d5cf,0x000042be3c0ac7cd}},
   {{0x000f742d43b5eaaa,0x00063fa59b852126,0x0006bfd45054a076,0x000a8efd0d5e3612,0x00001f8fbd7d84f8}, {0x00080f5d563fccc1,0x0005e280a9283176,0x000b578cf48ca505,0x000514d00b81b227,0x00000aad9183994a}},
   {{0x0007b62b7bdc9534,0x00021bc086ddd9e0,0x0005eee779f0f6ff,0x000df0c9d1ccff65,0x00005475f799bef7}, {0x00028fa86f702ccb,0x00045f021f073faa,0x0008fa8c692e6090,0x000a2c39e629687f,0x0000d71419ba036e}},
   {{0x000e1cc6028da9ad,0x0009f251f573171e,0x000a997f45352fe1,0x000d5f28ff236e3f,0x0000831b6ca75749}, {0x0002e1de350e2c27,0x0008ae0ce4037c87,0x00074f5cbc56240d,0x00072889deb07769,0x0000d50ba88061c3}},
   {{0x00094265a3a2518a,0x000926303d43d6f8,0x0009e5696cf81779,0x00007ab10a047161,0x0000b049ff6da5e3}, {0x000f9b0feb13ec70,0x00079d8ff90ce4cd,0x000fa96afd5e9711,0x0002a2f6f64d069a,0x00000d0bf5e9d201}},
   {{0x000301f358bcdc04,0x0008ca9d47f8e63f,0x00043d43a07689e9,0x000903df689e2f4f,0x0000d542a16d0920}, {0x00093d59ca0a7072,0x00056ac68065aea2,0x00090008cd061fe4,0x000db5f033bf1b00,0x00009749558e08a6}},
   {{0x000fc59c1d5d0340,0x000667e215e074b5,0x0000200e6f712e9f,0x000588fd520cbd86,0x0000229acb43ea22}, {0x000e14cfff0c82e2,0x000239c69e739cd1,0x000ccb98987684b6,0x000493ba85e61c96,0x0000d5dbb02c3d06}},
   {{0x000d33ae86b173c3,0x0005779ff0e3f22a,0x0000d0c10e8e41ea,0x0008f8d1d2d725dd,0x00001f39088332d2}, {0x00071e17829839ea,0x0003a502ae587b3f,0x000fc61150cf691b,0x0003144f658dbdbe,0x00005cd6ee653ab5}},
   {{0x0008d7b5f1d23474,0x000a0cc2253a206c,0x000389e08794645b,0x0002889517d8ff58,0x0000fa20deedf847}, {0x00072d8d797770a6,0x000d5f429e26eba0,0x000af82797360c91,0x000ce31200a3b380,0x0000a1c9150e2dad}},
   {{0x000d3a7c35d87949,0x00077356bae50ee6,0x0003322fd042e655,0x0009670f59698d64,0x0000379ae15e0a61}, {0x000ae62fcc9981ea,0x0000cd2934c664b9,0x0004e65ebaed3d63,0x0004278454b3025e,0x0000b09f64899950}},
},
{/* digit=5 [{1,2,3,..,}]*([2^35]*G)  */
   {{0x0003a1222248acc7,0x000ec264e366b208,0x000fdee281f6ec0e,0x000bb4e659b7045a,0x0000a823a4156430}, {0x0002a04e1900a791,0x000ab9ee65762459,0x0005ea54acde09d4,0x0005a742b6463f4b,0x0000efe9ed3e3ca6}},
   {{0x0006dbe305406dd9,0x000f4d5d1957e27a,0x0007d4d8f8eb7dc7,0x000de4654a687638,0x0000c47940a57762}, {0x0005b5d99b307781,0x00065e793682be4d,0x000c740e325380c5,0x0004ae502d37f3da,0x000040deabe2566e}},
   {{0x000d067afd32acfd,0x000a11f71ccf4481,0x00096f2dad8f0fcc,0x0003f90208dd0cb5,0x0000049d7316aad9}, {0x000263d42ab580e7,0x0000b3f707b4c79f,0x0005e0eda09411bb,0x0004021cfde1ff83,0x0000270749100f03}},
   {{0x0006126c49a861ec,0x0005214f0d06eaee,0x0009bfc17024f3b6,0x00038091a3f1e8c6,0x00003c3a8ea67686}, {0x000752cb103d4c8d,0x0002c218b36b3400,0x00051504a02bc461,0x000bf9f67f75eb76,0x00006848b57a02ae}},
   {{0x00002e6c30fa92bf,0x000caa552784bd98,0x00083169b5a70d96,0x000227a085c4ea3f,0x0000a9423bbf6908}, {0x000be12fe97a5b9f,0x000881b991182ffe,0x00017884685da604,0x00018dacbc2f7f63,0x0000d96bc7181532}},
   {{0x00081db1782269b6,0x0008c597e5509583,0x000385153ae34bf7,0x0000485b5c60645f,0x0000f0e96b043088}, {0x000021577884456e,0x000b89310ea7bf6a,0x000fad2deb3b5688,0x000d4c37c9429504,0x0000020f0e5f7896}},
   {{0x000a0ab0976505f7,0x0002995e2ec5730b,0x00031ab71567f681,0x000b9ed706201063,0x00002cfa977b1d22}, {0x0005ead8a2373da8,0x0003fba45a6833e5,0x000029d15a8d0d5f,0x0009f33a1d8f9c03,0x0000f34f1cd7c55b}},
   {{0x000428dbbe5a1a9a,0x000e9126bd67cca4,0x0001058268187fd5,0x00019f6036973a48,0x000039b666458bd6}, {0x000deef2d65a8087,0x000f24636b196d42,0x0005d564c4969044,0x0000778611ee47dd,0x0000b2f3a4a42873}},
   {{0x0007d45300eb294a,0x000d769c14949415,0x000a47aa92b2a656,0x000ea42000dd76d3,0x00002864e5046243}, {0x0006c47db89842e4,0x000721479fb78271,0x000b2f6dc12dfd7d,0x000d66fb9a2c56e0,0x00006be862b17f85}},
   {{0x000d8dd0f82b2148,0x00097103cbc603b0,0x000d79e19460c34f,0x0007f8732e5c0318,0x0000b8888bb28411}, {0x00037dcc07226779,0x00088c1c0f278f3c,0x000f7a0c610d21be,0x0000e0447c8468e0,0x0000bf022143decc}},
   {{0x0007d1242b48b998,0x000cc84240960baa,0x000fb5cfb1bcb665,0x00010d0b847cd6eb,0x00007c2ae571ad4d}, {0x000b1220de367261,0x00082fdfbd21f1cb,0x00079d460e7043c6,0x0002cb3bd0826a4e,0x00001f5e5985bd1a}},
   {{0x0004160b7fe7b6e0,0x000a400a3fb29755,0x00028ca1e7d16189,0x0008ccd73e9beae3,0x0000dd04b97e793d}, {0x0003c9b506db8cc0,0x000ecf38814ca9c8,0x0004b45e65cd47aa,0x000a8426fc430db6,0x000079b5499d818e}},
   {{0x0001102c1c24a3b9,0x00078c161c1aebb0,0x000f00a4aca24e56,0x000c7a803eea6936,0x0000ad76ee906176}, {0x0001fc2538e0ff72,0x00094604b3b09745,0x00049cfd794f8980,0x000f694311436e32,0x00007b4a7bd61224}},
   {{0x000d21ae0ac29416,0x000462d3193703b5,0x000c992d0279b025,0x0001f2d307c052ca,0x0000aa7cb934fa8b}, {0x00025800d37c7a50,0x0007342d54225a18,0x000d2ef9213380c3,0x0003c692ac2d66d5,0x000035a70c9030c6}},
   {{0x00025dd4ce4f152f,0x000109df7c06c160,0x000e4bb141f419a7,0x0004cd7d5b221491,0x0000c43c6cd739fb}, {0x0006591925d6b2de,0x00028218659849f0,0x0001b16294b37d9d,0x000e04ac54a971d0,0x00001a9c2a031d50}},
   {{0x000b78571ba18615,0x000c80c8f93d5109,0x00033bb9348b22d5,0x000d0898fa84a786,0x00003fba6baaaebb}, {0x0007df3e5eea7d82,0x000648ca71587ff2,0x0006f1a05521c879,0x000ee499d5133bce,0x0000d50cd541d0eb}},
   {{0x00015d6c5a3ef169,0x000d2a079221c821,0x0005da81c993eff9,0x000d8554da2c5e4b,0x0000a89dbdc1033f}, {0x0009ebf2b892891c,0x00009d14a4d56081,0x000fda42153902b2,0x000283aac35051d7,0x0000c6ab88621c83}},
   {{0x000a133f74cff170,0x0003ecb813f214eb,0x000665bee240aaa0,0x000d73cfbb65406f,0x000084b1fe4a425a}, {0x0005d16d081f6a60,0x0008eef82c90009d,0x0009eaa2235304fe,0x0001e3f20346d5aa,0x0000ada9f07ac1c9}},
   {{0x0001678968a61446,0x000ba7b31a1ea6e2,0x00081fbe154c1f77,0x000c4a76bb787e57,0x00001bd2ee1431f1}, {0x000a1e9781105fc0,0x000f7b2f8e80f25a,0x000ff919b9cf2971,0x00096e26d15412cd,0x00001db4ebe34bc8}},
   {{0x0003e23b40df1cf8,0x000314e971b47d9b,0x0009cf9215933737,0x0000643f57bd1466,0x000065daedf8c1a1}, {0x0000bd3832791254,0x000ef4ecdaab3eb7,0x000755cafbc3d5b9,0x000f0251e3ed7e5f,0x00009699f55141e6}},
   {{0x00070e1d4a7a15b6,0x000a8aac87e71857,0x0003133ea08f3587,0x0000fbd52018db47,0x000074ce71964fd3}, {0x0009835088b3e0e6,0x0008fd0d47a17b8d,0x00074a3c47a0356a,0x00066c3d9e765964,0x00001ea48a85f669}},
   {{0x00077580f3e48342,0x0001f7a9afcb3041,0x0009a67b3fdbb21c,0x0001a8556fa17f2f,0x0000a6b2421c245c}, {0x00027944af02291c,0x00056a5804fe64be,0x000f08fd7ade465c,0x00003acdffbd39a6,0x00004efa84d6a144}},
   {{0x0001b2a442b0f5c9,0x00073f997736a1b9,0x000e90e16b748e31,0x0008bffd1b62bfce,0x000007ae2719b207}, {0x000534b0c9bcddd6,0x0003d9adce83df31,0x00026846a043fb05,0x00039339031043d8,0x00001a9c0d71144f}},
   {{0x0008046477184276,0x000b0e830f8bdab4,0x0009a1347df17ff9,0x0004ade08d7ee8e4,0x0000ac71e23f1c1d}, {0x000b9fd1defd73c7,0x00074bbbfec5c8cb,0x0007ef8ea1984065,0x000f2fc9db1cb59e,0x00008aa8296d4105}},
   {{0x000b7f0a3738c290,0x000abc3250a3a3d9,0x0005e4caf0a2f235,0x000f7a55e506f644,0x0000974f73d33475}, {0x000bba35ba2f5a80,0x00036af40066d37d,0x000d73e2c542c6e6,0x00033e26d99b53c5,0x00006060d7d6c3ca}},
   {{0x000f1c2065fef4a2,0x000ddd5b92e3cdbe,0x00070835077e60f7,0x0001bfb7c549f026,0x000001b3ad054f12}, {0x000c2a10334fc145,0x0008e44552f65fca,0x0006530828a9a9e0,0x0002892dd8a1d397,0x0000fc0738fc9d4f}},
   {{0x000244d17d2d8c38,0x0004f0830684787d,0x000f73ae5effc634,0x0009a4dddb96dde4,0x0000efb14b197254}, {0x0003eee2245ae7aa,0x000e4a11f13e6eb7,0x000b01f5dbca4061,0x00052c1577421d30,0x0000a688b25182e1}},
   {{0x0008e71bd3502bad,0x0003e4de75a06760,0x0006125e54ef41f2,0x00043ee08dde5efd,0x0000e48482674095}, {0x0008d9865cc22950,0x00016e0edfa21f19,0x000f35fc7428a377,0x0003c74f9697a2ad,0x00001a43c79f7cac}},
   {{0x00070590fd3659a3,0x000c8b7f2d9ab05d,0x000f984d38927f30,0x000a451023d1ac8c,0x00002125ed332897}, {0x0002dad3d4142055,0x000293fa82a9fb57,0x0000a558173000ef,0x000ca4fc0868e9f1,0x0000b61fc67bb0b3}},
   {{0x0008d5b7cae440c3,0x0001102b7531c125,0x00093232121c08b4,0x0008afc61a8955de,0x0000568faf85d140}, {0x0005e999ecf965b6,0x00088917276f71b1,0x0000cf9e2f14ed24,0x000c7e66f4caa182,0x000081b20b278d83}},
   {{0x000738dc6c011203,0x00037e70e0db6cde,0x000afe18c71db081,0x000be765fc064474,0x00004619053429e2}, {0x0005ceadb2a3b15d,0x000e0b4c70738061,0x000d2d3670a49a19,0x0008a93e1b84c88f,0x000074bf462d33fb}},
   {{0x0006d65533ef2177,0x000453ca2e87889f,0x0002b41677158c7e,0x00057f8b670dfbdc,0x00005910a01f44c2}, {0x000bf07cf88577d2,0x0000c45e2acef336,0x000a23d852224525,0x000f580ed92e8d7c,0x00009f8be4c4b812}},
   {{0x000baa7076fe12bc,0x000aee1537f9dd9e,0x000bdfb463f2400c,0x000b405aa9352817,0x00000f9843127883}, {0x000ede10170911db,0x000a84d4b17f5590,0x00026b8d27562f5b,0x000d5931fa1df218,0x000040b796b1bd80}},
   {{0x000f1973467ba92a,0x000b570954b0d65b,0x00078f15d8c9b46d,0x000960f7c8a0f30e,0x00008f3a69b25a4c}, {0x000660f61e4ce9b9,0x0002dea6790c4242,0x000986416bf06aab,0x00022536706f8eec,0x0000e56dec22a9fc}},
   {{0x00046f49a9898d9a,0x000ab633cdef527c,0x0009e4297d799e77,0x00073384eacc167d,0x0000bb61ceb0b1cb}, {0x000e8a7f778443cd,0x000059de2fe6bee2,0x00003bb6f3bb42bf,0x000df5fbed86a130,0x00003918e6da781c}},
   {{0x00032719a5103f11,0x0006e50eac064bee,0x000dcc1195243efc,0x000a08a8e122cb6a,0x0000b7faa84d0b80}, {0x000d1bd6dfcd08ca,0x000d6be427de32c3,0x000263c83129dec4,0x000efef8ab679c1d,0x0000fc83cb86ef64}},
   {{0x00060882fa6be76c,0x000a5328cbfe85eb,0x000618dda892585f,0x00026e0154d3edcf,0x000044f601bfabaf}, {0x0007d0b2be1fdfdc,0x000c61137fee7bf5,0x000b591a8a833bd2,0x000055d353af362d,0x000076f26dd1562a}},
   {{0x000e47d3fdf5a517,0x0002e5c9cab01d87,0x000e0586e7afb5f9,0x00070921bbf58f89,0x0000c72c0187d843}, {0x000aafb99b5c3dc4,0x000cf844aeb0a9a5,0x00067e482a48a0f1,0x00059a3178b7ddb6,0x000053985e9ae23a}},
   {{0x000c86001b25dd8c,0x00083b897c8a4a54,0x000a90cd90dd37f4,0x00030c9f8aa6100e,0x00008892c68d6d58}, {0x000efc0ef514ca5f,0x0008f72c9ee6eb4b,0x000c40d5f478eb67,0x000649abca20dadb,0x0000015de22cde4f}},
   {{0x0004de0eaf4b8a5d,0x00097bc60e32aa6a,0x000d15e7068cfd9c,0x00009c968a4b017f,0x00009f0694bc27dc}, {0x000cad5ba708bcd2,0x00093bb95c2af6c3,0x000c0a58f5cd2ba6,0x0008708a28c1d333,0x00003e274e3cbc77}},
   {{0x000692ddfd20a4a9,0x0002f1a6665344c3,0x000a0757d091c5fd,0x0003e9dc0bb69109,0x0000072e8b9f6734}, {0x0000eb080848beca,0x0009d9fd36cc31d4,0x000ed43f595bd480,0x0000be61a77c6165,0x0000fccd127ce0d4}},
   {{0x000c82d1cc1884bc,0x00009d4753b4eccf,0x0008e099fc85ac20,0x00039007a6caac65,0x0000f46369ec4b27}, {0x000d049506467ea2,0x000217cdeccce2e7,0x00080143a481b63a,0x000b882029abd8ed,0x00008bfe3c7dcb00}},
   {{0x00010090643d84a3,0x00087bd110413bec,0x0003a34d6885f366,0x000ebeab02432cf8,0x00002f7b360a19ce}, {0x0007837dad1fe7ac,0x00089441a0b0f06c,0x000d4755060a157a,0x00001fb04970e9e2,0x0000d2bd553e71b9}},
   {{0x000f82f33e24a0b2,0x000fd2565079ff57,0x0005f58259cbee23,0x000661f6353427eb,0x000076feec50948d}, {0x0002bc6da10032b9,0x000d60e72a53d1b6,0x00020e7ba718351d,0x00018d0345207624,0x00006368fffca001}},
   {{0x0002d26150a49e46,0x0005df04706b00ce,0x000b196d00c28b63,0x000b7c5ad65a4658,0x0000c8455fd4c9f8}, {0x000895f2d71867e2,0x000bcdf9f38ce90c,0x000f6ec045c0be31,0x0002510a37a15ed8,0x000039639e7acd85}},
   {{0x00053159c7c4c6b6,0x000077409af7d897,0x0007132fb603aa3c,0x00023858d53d0c00,0x00008d12af806849}, {0x00007e7bf5d92796,0x00054ada74cebe06,0x0007e8ccb9aa5005,0x000f5e881079cbba,0x000010c71d205f4f}},
   {{0x000e1a75aa07093f,0x000ab75da47c9e2e,0x000e75401ca84004,0x000591174d39513d,0x0000938f757ab311}, {0x000761800a43421b,0x000157bc78c89619,0x00017127639a2536,0x000f07778f710a0a,0x000028446eb3d1a8}},
   {{0x00081bfe3b6a6611,0x000dd6d279f71847,0x0009eb6627751cb1,0x000ea7e8ff95d6c5,0x000086d90b768d3d}, {0x000b6c1dfb4f754b,0x000a7b2801dc0e4b,0x00054564d5c5cf56,0x000f131561e4521f,0x00004fb8c61a0dd7}},
   {{0x000963033ff98c71,0x000abf17769cf884,0x000fdd80a9619fff,0x000e63e8090bf61b,0x00004d9a149522cf}, {0x000c3606f6df9ea2,0x000d018f17eab354,0x000eb3480dbcf770,0x000a26007db7c879,0x000013dbda8759b6}},
   {{0x000200b29fc81b30,0x000f171d87c1ac4c,0x00081aa9eebc3e09,0x0004fa9179953014,0x000051b92e192e11}, {0x00092e9ecb5537f9,0x000b990c7483df8f,0x000deb01644b1b2c,0x000c2c1711455a2a,0x000064b685711a10}},
   {{0x0009d99cec036235,0x00059f3271ea4f15,0x000ee48490553222,0x0001036231bea3c5,0x00007a54f50c094f}, {0x000421d9598b3525,0x000c17412ab43e2d,0x000c3a912e865a49,0x00065d82998a251c,0x0000d0928085c74d}},
   {{0x00059084088567a3,0x000def214a6173f4,0x000f0c13deb6b280,0x000b805c9adc34ca,0x00009d129392561f}, {0x0003a5ebc6edfb49,0x00016e4d210eb2dc,0x00086ae727485b1b,0x000b87762e0400e1,0x00001e32d5cfeeb3}},
   {{0x00074d74be59224c,0x000bb16d55f36df5,0x000d6ed33ebc88cc,0x000b0f66c2e6d0ca,0x00006e21e7dcd3e8}, {0x000840e5bcc36bb3,0x000e4da74f692cc5,0x0005193a89292445,0x0004135be8d3214e,0x0000ec23629bdf06}},
   {{0x000ae85b134defa9,0x000f8bb2d475c7e9,0x00063c00d6073b1c,0x000ac429ad615e28,0x0000e29493de25f4}, {0x0001dea4e9acf4f7,0x0008350db88dc32b,0x000da916c3e1f01c,0x00003e405d70ea04,0x000014b0d0b48658}},
   {{0x00093fc9920cb5e5,0x000742c7a3ac4bd4,0x000ec92355b44b1f,0x00055352a77293bc,0x0000ee06e881d378}, {0x0008173da621607b,0x000be9f5d290ceff,0x000f734ac2bb03e4,0x0007317945106aa6,0x00005056605825c4}},
   {{0x000920ce079afee3,0x00003789831f5945,0x0004a5ae5686e17a,0x000d462966bee8b7,0x00008a673a24e258}, {0x000c1f283141c954,0x000ece96e486bd1c,0x000e5fc783b2ecf4,0x000a7a8d3aa89674,0x000015ec10c6482f}},
   {{0x0004419805033800,0x000ad314b3921523,0x000caecae513d917,0x00080bb0b52f4e63,0x00007bf22ad2dc77}, {0x000e8a1e4306839f,0x00016dd7feaae761,0x000c778f11b3be96,0x0000f55fe728de74,0x00001fa0bdb4e007}},
   {{0x0005a316ec3f510d,0x0004029804758520,0x00030ebfd2c7e4a1,0x0006440e3c19c06f,0x0000b1c1f39a4b7e}, {0x0001a755dce364a2,0x000be58f5be3fe29,0x000fea38cb7b22a3,0x000e170cd2c30237,0x0000930967a4e17b}},
   {{0x00009de0c061c658,0x000c6dc6ed4487f0,0x000afb1ebcb014aa,0x000687c9bd1cb43b,0x00001bd8b5ca82d3}, {0x000b87ef01a17aff,0x0003f710063b1cda,0x000fc819321f37ac,0x00015b6a6c567642,0x00004753e7146a60}},
   {{0x000795ea15b0a44b,0x0006d958a958020f,0x000b675b58f37c8d,0x000ae9b3b7e89ba4,0x00004fb0c0cbfc31}, {0x000e639a7ff1f2e5,0x0003119614fbed95,0x0007151ab9880f5a,0x000cdb8eb6ff0294,0x0000bc5118cf868d}},
   {{0x00020554c20cea5a,0x000d74c4d69ad8da,0x0002d599bcac2776,0x000b502ccb22c162,0x00004ddb65408a9b}, {0x000f1511b4941b44,0x00042efba5882c4f,0x0008345e0e1ff19b,0x000fc3f5034363c4,0x00005542e3d5e29d}},
   {{0x000cb91349f7aed5,0x00003fca8420f197,0x000aaf6d83b2b5a0,0x0002b62c175ee823,0x00004dcf42185af3}, {0x000430727d6561e7,0x00046175b1e20ba1,0x000807db5879d5ee,0x000bcd57c4367399,0x00007a544560cd55}},
   {{0x000ff130105c0720,0x000f8dda7da4e6c2,0x0002d35c118f7a99,0x000c824c3018200e,0x00006a53ca0d9cc6}, {0x000cc1ef1aa1d9e1,0x00043a75b1e8aa21,0x000be9fdc3241433,0x00055a1a6d13280e,0x00006bd173fa8a47}},
   {{0x000b2452133ffd9d,0x0000b30f1a20fbb9,0x000a1f52a39a8b2f,0x000df7784bc97dd5,0x00006aebf57740ed}, {0x0007acb76ccdac60,0x000c1586ff273225,0x000de7dd1af4d36e,0x000c168eaa8863f8,0x0000045d5cf88647}},
},
{/* digit=6 [{1,2,3,..,}]*([2^42]*G)  */
   {{0x000d574c005979da,0x0001ca40e350a6f3,0x000e2ecf9c2072b4,0x00044e5ca5c1568d,0x00008c8bf5c45153}, {0x000e555114df14a7,0x000d8dc5ec6b97ae,0x000a85418d4374a4,0x000f78054cc28f2c,0x00001cb9e2843c41}},
   {{0x000507903605c397,0x000e3142c96c8910,0x000923684f0843d9,0x0008938374493416,0x000032caa306a0a2}, {0x000c27061160170e,0x000b637fbaa3b2e8,0x000eda3acc32788c,0x000e0659cd818ea6,0x00002e9423a7e2b2}},
   {{0x000d39b0260e52a4,0x000c506533256967,0x000ca7954d42585c,0x0007b2cd9bd60521,0x0000fa20877c1ed5}, {0x000eff8e34a0bbeb,0x000bd4f6ef6460c1,0x000af848356b0040,0x00061378be2b24b1,0x00002278164a5531}},
   {{0x00075455922ac1c3,0x000c752b3f638df2,0x000de57c4a7b3ef5,0x00008b5e77b21471,0x00001682c10b34c0}, {0x00024f04bd55d319,0x000587b61c71c768,0x000a5089db6d1c08,0x000d3ea1db0903c2,0x0000c092172a84e5}},
   {{0x000ed5bc00cc638c,0x000aa1278fc2dd7c,0x00037f8d61a2015e,0x0003ac6e8e52886a,0x00004577870a7993}, {0x0004cce2c51211a6,0x0001c4c20498b3fe,0x0008db5e5ad9b10b,0x000fc330d87a4fd2,0x000098cd1059aca2}},
   {{0x0002d07e91b536de,0x0001beba09d64f11,0x0007c396fceb982f,0x000b235c157b2c19,0x000023c2d425b66e}, {0x00057d93f330d370,0x000179108deb480c,0x000199ce5b3a4c8a,0x0008d4702388decb,0x0000b019211b944a}},
   {{0x000a692840bb3366,0x000c4669fa7b24f2,0x000c9c3007c353bd,0x000f177a20d6fcde,0x000025fbe30013a4}, {0x000b61adbc173281,0x000f99515621a2b1,0x00020ff46008965b,0x00091c39690939c6,0x000082dd27d9717e}},
   {{0x0005035ea6c39976,0x000a62610bef5ace,0x00080dd3954259aa,0x000a398f18bb3f3c,0x0000910b95bbfc3f}, {0x000f51043e09aee6,0x000f47675665fce2,0x00072db61ced56c9,0x000e68b0e265acd8,0x0000982812f0e9fc}},
   {{0x00011c6ce8009982,0x0002990360d929be,0x0004ad59072bb175,0x000bc00c1931975a,0x0000ba2f548bfc1d}, {0x000eebbe490ebe0c,0x000cbfae11c07fe4,0x00003ba3712a0a4c,0x000dd7b197cf81e9,0x0000f7d4aa99e1c6}},
   {{0x0006bf43fd5684c4,0x000f40360aa192af,0x000546a822b26eec,0x0008fe7d960f3000,0x000007b3c44359ad}, {0x000e5fe249c82ba0,0x00072463744c86ca,0x0009162729e0faec,0x00061587f551e894,0x000033f93446ceb0}},
   {{0x000b0d18be82e84d,0x000daa582fef1e5e,0x000e921fa89967f0,0x0009b9ecf687d5a6,0x0000fee4cf4a37a0}, {0x0006965b493c465c,0x000bb635c03094f0,0x000f05e9f638b9a1,0x000724b666786466,0x0000caf6809804da}},
   {{0x000b690768fccfce,0x000cd835b362ca2e,0x000fdfccef402d37,0x00098f2efac0d0e2,0x0000fc9cdf09638d}, {0x0002b72d1669a8bc,0x000b9774ccbd2af1,0x00034870e33c536b,0x000ac970b21909fb,0x000038fa2f83df25}},
   {{0x000f02bbf81f3f5e,0x000dcf7e458174c5,0x0003c54ae0525a5a,0x0006c4a8d2aaba43,0x0000d9775dc606a5}, {0x000738ac0edb37d9,0x000dd6cc1f51d320,0x000600d7625fdb6e,0x000d761c661d1710,0x000031ec1f44dd1e}},
   {{0x0001d6219ee43f1f,0x000d70829d9765c1,0x0004be6e85cd57c3,0x0003bce26c91a398,0x000008d930a7b0c5}, {0x0009e5bc016e4eae,0x000831d43d2b94bc,0x000701155d391683,0x000714a86c5ad773,0x0000037762700b00}},
   {{0x000c9ecaa80ba596,0x000a08538e517f01,0x0008128af3083411,0x00014b370370f1e8,0x000025cc3dbf1dec}, {0x000666c01ac3107f,0x0006e5057ac3fef9,0x000be5df7b2a8d57,0x000923c0f2629992,0x0000579c8e5f0353}},
   {{0x0003d931341ed7a4,0x000c67b59d49b8fa,0x000b8c4a44223272,0x0002e3fdcb194783,0x0000e413c022d130}, {0x0009127e17e44ceb,0x000483b3adfb6d99,0x000aa96caee86bf7,0x00047d46902fe625,0x000073540e595aae}},
   {{0x0001d7b1b4a158cc,0x000d67e2a3693280,0x000d9f197e571c99,0x0000ad80cb76c010,0x0000308c289f167c}, {0x0009dd3eb7958f24,0x000bf00879b1a6ef,0x000df0636a7226df,0x000eed2cd0b3627e,0x0000efbce6cbbc37}},
   {{0x0002a058d6990216,0x0009172566e375f9,0x0001ad23a586d4c7,0x0008abd78ca5f176,0x000050d86fc7465a}, {0x000d457842ba251a,0x0005a22349337a4e,0x000aad6576b65e3e,0x0003690f1543b731,0x00004cefe996bfec}},
   {{0x000da909f47befbc,0x000a81312d13b587,0x000f1cefe6562e9f,0x000cf5e691ea59ef,0x0000c30477ac5fc4}, {0x00024610b0ffd3dd,0x000a8b355956a163,0x00024ec24a1f16f3,0x0001298b148d5342,0x0000c834e7cc9770}},
   {{0x0005e75b2c69dbcc,0x000843c3da6c7bfc,0x0009102713aa77a2,0x000c551e0df03cca,0x0000bd5ca4b3806d}, {0x00058076db476cb9,0x0001cf37a31ee1ca,0x0001af416fde15d6,0x000db5649af520f4,0x00006c5c5b20d342}},
   {{0x00043b7eb4ceb9be,0x000f6e77371a155c,0x0005d43af2e99300,0x000d713d2987da67,0x0000f2bc1c16599f}, {0x0004b7b9342f6b2e,0x00019c8e71f09689,0x0001f3efc201eadf,0x00070413479d9f4a,0x00000f8a743502a9}},
   {{0x00044b6b3eba40cc,0x000901c1e0d0eafd,0x0009d505ef9739f2,0x00063d4091471a61,0x000015f9c975d7c2}, {0x000728583afbe332,0x000ee4f1e0925be4,0x0001a9d11a3b6d6a,0x0004d2c76526b975,0x0000ec5b26dba4ae}},
   {{0x000f4d902f6fb8d2,0x000176912164eb66,0x000ef30004063c56,0x0003f0cb7050c180,0x000088d1c340aa5b}, {0x00068d607806fd8f,0x00045bbbf50fe87c,0x0008d6627b2f7f9d,0x00013a35972f3aac,0x0000854777500e8c}},
   {{0x000ef6c872b4a606,0x0003e613521bcc50,0x0003e15d1ab2a34a,0x000511d9c5c19098,0x00001dde5dfb9905}, {0x000f6219f2275f33,0x0006151d894be417,0x000b0bdaa0750c8b,0x0009bd45b04ab978,0x0000bfd9fd475858}},
   {{0x0003e30ee9120b67,0x0002b3a4743ef101,0x000d14d9e2b51af9,0x000d327a96ffae48,0x00001dc0dbed98a1}, {0x00062d20180cca4c,0x0007035689639149,0x0007bc4441ae6067,0x000c79ccf227b143,0x0000650c83c89962}},
   {{0x000c7ddfe7ccfc4a,0x000c7b929d4823c2,0x000783c33f925c89,0x000759a460f74b06,0x0000c2c8d4a45904}, {0x000b407b807bba06,0x000d09ff8f3afb40,0x000ef64a49d1e362,0x0004b2433e9681cb,0x00007ece5fa932fb}},
   {{0x000a99b739f10e3a,0x00095f5259256900,0x000e2d041c3341ca,0x000ddd4e18a626a9,0x00005a83685c9580}, {0x0000c819d7de3cd3,0x0005f062cf9cf347,0x00010edb0edf0258,0x0001aec43522fac0,0x0000031413543a4b}},
   {{0x000e02adb22b94b8,0x000921eaa45bc792,0x0001e1c63993d8ae,0x00088a0aad6cd3cd,0x00009529ca845ce6}, {0x000e3aae572a2530,0x000802a21efb2cce,0x000430358e02b643,0x000504a7091b6ec9,0x00006d1b1fa9d7db}},
   {{0x0006d32c47447335,0x0000e79f9e345884,0x0000ef6ca40517c7,0x00003edf65655f13,0x000026e448941f35}, {0x000bd177ee4a9765,0x0003421363d18467,0x00069e0411d9dc91,0x000f5188d24c33b0,0x0000eb5da0a7cdf7}},
   {{0x0003cb1197b994f7,0x0004b843eae91c0f,0x000097ea53c95a6c,0x0008670766ffc9a6,0x0000bea40944723b}, {0x0001f734db378f9b,0x0000337b77acb48e,0x00024ad4670025b0,0x000a84e43dc8e7af,0x000098a15acc6d00}},
   {{0x00038ba2743b0043,0x0007034415ee3adc,0x00062d05ab1c7f4f,0x0003b6ba43df8f1e,0x00002618905cd76a}, {0x0000bb5a23a0f46b,0x000aba01918c2fbd,0x000743f945bc971d,0x00022ac801d94ab4,0x000094df65f176ae}},
   {{0x000bfabaf95894c5,0x0006d76b2241aafc,0x000dda48b7b9bdc0,0x0004df9af983625b,0x0000977faf2f3fcb}, {0x00042ef052c4b5b7,0x0000967591f0bed0,0x000f24ec79fe87f7,0x000f1b589c73ca22,0x0000d37fa9f564a9}},
   {{0x000841a15562627c,0x00030243b0342710,0x000c686092c01a61,0x0001f55d135c562b,0x00002ca17164b03f}, {0x0006c2d3eb81d82a,0x0009ef6df13ec996,0x00072b43bc02abf4,0x0002afd7b34bd78f,0x0000ff6218fd60c8}},
   {{0x000726c8d55b9d21,0x000989e9bffb0aa5,0x000b9e72adc0adbe,0x0001118097549cef,0x00006755712adfb3}, {0x000f984f26847f99,0x00074fb30cb7dd8b,0x00071ef9cbcb8e38,0x00063f31fd32a751,0x000077f3fc7c89b3}},
   {{0x000af2bf4babda01,0x000de7113c8e116e,0x000def526feab68b,0x000a02c1e3f064b7,0x0000ac30885f0b3f}, {0x0006e7b40142d9d3,0x000300921c0b1c5a,0x000a116a3839b560,0x000e6d18f301fa36,0x000080e1107ffd9e}},
   {{0x000ead858854be16,0x000e6bd4d49d7945,0x00029c2ef4111c12,0x0006f58ce3b1ec3a,0x0000356d404ed361}, {0x0006a8f594d320e9,0x000d6651ccd29f0d,0x0008fdde40989316,0x000bbbdc32117a0f,0x0000abe5cc6326a9}},
   {{0x00060fb9723f6711,0x000d6f3d593ccff5,0x000ba069621b2a12,0x000384d4cb18da24,0x000086e2220d3543}, {0x00064e088312c29f,0x000827dc7752722f,0x00085ee8994282a9,0x00069f72467bbf5a,0x0000435c651e1007}},
   {{0x000153943b3a50bb,0x000b6a53efbcc9ff,0x000b0c5b77132130,0x0004cb81bfe063f7,0x00000179a7dfea99}, {0x00064b3c85f455b2,0x00086f6e006212d0,0x00075d6d94725932,0x000cc7d64e590bb8,0x00002dd6225cd92b}},
   {{0x000038eb9c3bd6dd,0x00062bba27c8b658,0x00062c45d00cdb0d,0x00007c3c68133710,0x00008515b8cfd334}, {0x000699e8cbb5ecf2,0x0008a608d7d8cb8f,0x0003e00db8c4347f,0x000d190c11850abb,0x00000a8dafe0cb49}},
   {{0x000148045ee2f40e,0x000e616b60cfbd78,0x00049a8c475e354a,0x000535fe0b58a18d,0x000040e94e3da359}, {0x000a59f62accd765,0x000a3c762837bd4f,0x0008c277b05cf466,0x00074065abda9944,0x0000a9e01bf98b13}},
   {{0x0007798326aad8d2,0x0004a396f7e79d45,0x00053e292bdef495,0x0003e74fb274a2c2,0x0000800bf0a3cfe5}, {0x0006d3144438fd49,0x0002ce259f9a2242,0x000f66264ef23392,0x000faab188503c03,0x0000e5e7f140f9fd}},
   {{0x000b76c5fcc1aba9,0x0007c9b5bff8565e,0x000b6d3faea63254,0x000c1ac587c087aa,0x00002b639eafce39}, {0x000e782953b135c8,0x000dc25268ef0706,0x0000e74697308912,0x000e74d99e92c709,0x00003b90f531bc35}},
   {{0x000b3d0244975b3f,0x000721965d724750,0x0008dc751f3a4435,0x000fef279c67749c,0x0000f18cdffc23d9}, {0x00038332028e2472,0x0002d3bfbc79c401,0x000880a8496e280e,0x000151d60417bdd0,0x000063c9f3d4a568}},
   {{0x00015b32d2ce8114,0x0002b8291d2136be,0x0009fcfdb846dc0c,0x000b9a1cfa0ecb78,0x00005a0beee17535}, {0x0009f0796d69af13,0x0008299ab6dcec8e,0x000e2e09f31a7c5b,0x00054ba36d45eff9,0x0000cf49ef20cee9}},
   {{0x0004cf3086cff9bc,0x000079a3360f6be3,0x000bfbd1d88dbd49,0x0005515e96b8cc0d,0x00001e5f7c08b7e2}, {0x000b21428819d98c,0x000bbaea9dcb0547,0x0001d68c8c770dd9,0x000ba7eef0d4c704,0x0000c2b9818d3cb9}},
   {{0x000bc76fe86c6072,0x0007302a9a957fc7,0x0004dab636b7b933,0x0007bdf948dc27d1,0x000049dd198fae04}, {0x0006584a981a2029,0x0007aa893387e835,0x0005c72093531dd1,0x000b598be11f90c8,0x00003d2fe1f72a52}},
   {{0x000bfe2ec6d6b975,0x00046d0aa5de8225,0x000779f5f9cf6d6f,0x0001f3411459cb54,0x0000649cddbd6aeb}, {0x00035793f26ce5a8,0x0001d50f431e3213,0x000b84c6fc289a10,0x0004d6d59dcfda73,0x0000497381a6e3ac}},
   {{0x00055e6f2606a828,0x000110f2fb57b51e,0x000a4e37ce25f706,0x0007062cef6c2ab1,0x000064e359dddcf2}, {0x0006b187ce573162,0x00001a96b23d479e,0x000f16df72cab250,0x0008b5cd4898628e,0x0000056538d0f375}},
   {{0x000865ef15d31016,0x000a01b553d7a7df,0x000d1429480c5533,0x000cd5d66e19974e,0x0000620742013c0b}, {0x000d9c4edc454181,0x000eb1cc4a9d21d1,0x000c462f0005b859,0x0000c7cf01f630a1,0x00005d06cf402682}},
   {{0x00024ee3484be472,0x00062a0c902f9f7f,0x0000bc4532ff33e9,0x0008dae0bdf4575a,0x0000378dfaf3aa23}, {0x00020ec856720f22,0x000b767972912724,0x0008a15582ad9d95,0x000aa8b1242cc676,0x0000e287f8b7cc86}},
   {{0x00073d0990cecaa7,0x0000f75d40807968,0x000f0cd84ade55f8,0x000d01b645eea321,0x0000a1efa1024e17}, {0x0008420037cc0618,0x000055d43e12f685,0x000218710682e05f,0x0002fbd9c3699427,0x00005cbba4dbf7cd}},
   {{0x00097297a3cd22af,0x000b5a628397726f,0x0003165ed9f8cd5d,0x0003d327b93ab9c2,0x0000f5f5dc002282}, {0x000e4b5654a446d2,0x000f477257bac1e4,0x000766a56d1a9496,0x00074a4387ba94de,0x00003608bc8721ec}},
   {{0x00022d76688c4d4f,0x000117373abd16a5,0x0002efaa39d6b428,0x00017fb62f07acb4,0x000073e00f8d3b90}, {0x0005fec49421c3e1,0x000b2dcf26783617,0x00020f09fc4e44f9,0x0006cf66df436b72,0x000072755fb4aa8b}},
   {{0x0009d57446139cc3,0x00022fe0208fbab8,0x000e5d3990a0a6e0,0x000f0b9dbb63e211,0x00003ecaa12d8977}, {0x0008b21f7c426641,0x00029b65d08a5959,0x000502526b3e91b3,0x0002a8f35822eef4,0x0000dcf0176820a8}},
   {{0x000598f3d589e023,0x000f81d63d2c50f8,0x00071cd07df0478f,0x0000cd5b8068bd15,0x00000c3aa5007967}, {0x000fd4b941ade7f2,0x000c1279001125e8,0x0003f9ff03d1debd,0x00069c45b6dcbd3a,0x000082736a4993de}},
   {{0x000a0c3d41d3bd3d,0x000837a26bdeef69,0x0002edf9fb533b8c,0x000af012801d97db,0x0000c4a826ab1877}, {0x00058513d590dbeb,0x000b3e4e93576c1c,0x000b3337484632f6,0x0002e6236d36b779,0x000046833e44bbca}},
   {{0x0003913f7fc0586d,0x000696bf47193789,0x0001855dc385315f,0x0001fda2c56293b3,0x00001416d4f54906}, {0x000ab7851047213e,0x00011040c996beb3,0x0008b1d0c447f6e6,0x00022df06d310d63,0x000028a41409ad15}},
   {{0x00076cb82003f867,0x00069bcdbca3685a,0x000a4c455610d07f,0x000eebfff660219c,0x0000df39b883ea10}, {0x0005f96e22db2188,0x000a88a34c44b925,0x0009f92768cc6d9e,0x0003354d4ffb8685,0x0000fa15eb2d0d07}},
   {{0x0003845cf2c24b5a,0x000eb2f9c3badf55,0x000a7ceb389f66a9,0x000685ef22b5b9e4,0x0000ffef809ae134}, {0x000e1c68eb8fac22,0x000b08aec98e3e53,0x000a43bcb93c1e4e,0x000a5196b91ec532,0x0000dbfa947d2d74}},
   {{0x000d190ca84bad76,0x000f4d58e65ce065,0x000cb6e31fb13919,0x000c3edc41718bf1,0x000088969f066d05}, {0x0004ce721264d452,0x00095367532bd4f9,0x00045a39dfdfb65e,0x000f3b3b1be8b109,0x000029f789c4b8ba}},
   {{0x0001f3e6f49f15d1,0x0008807f0792d8f4,0x000a6e867678ce82,0x000c89b69ace82fc,0x000006451aee01dc}, {0x000f7f019fc32d29,0x000c200c52d21bb4,0x0009ea44564633df,0x000704ff13549aad,0x00009a3bf518b323}},
   {{0x00025a2534d4dbc4,0x000182a2fea30c96,0x00030fc1a45b8f1d,0x00073436ec21a1a5,0x0000bac9c2ade5bd}, {0x000d76a7b4e35876,0x000db182d9e35996,0x00007f13d0045cde,0x000a40baee24b912,0x00006452e97f7345}},
   {{0x000b0549f950cd0d,0x000107fdd07516e5,0x0002496639cc72fb,0x000cca9edd61e766,0x0000e4caa4ec043c}, {0x000f57a55c7ac17f,0x00032a85e24d11b1,0x0006081e7779cbd4,0x00064288030f86e4,0x0000d4a60337e20f}},
   {{0x00064880a750c0f3,0x00031e548e83cc7a,0x000110f0539bacfe,0x0005880d418c760c,0x0000e4daa4ce1f11}, {0x000e7b55ffc69ff6,0x000c320531272733,0x00022df9446f147b,0x000b7c285b2434d7,0x0000a444f6646fc6}},
},
{/* digit=7 [{1,2,3,..,}]*([2^49]*G)  */
   {{0x000465ac3f16ea83,0x000d82f1d11c7a1a,0x00068a172115a461,0x0006981767dd956c,0x0000392f2ec013a4}, {0x0009ccde526cdc7f,0x000b32292b81c7a9,0x000d391988e537fd,0x00052c86d8cf69a6,0x0000fc5ff4414468}},
   {{0x0004f7ea90567e6d,0x0006e6ae5cb797b1,0x00010903d513257b,0x000723b5454a3c9f,0x00008d2c9ae39bc3}, {0x00093246b29cb44f,0x000c87c8cbac38da,0x000918e42b540a21,0x00014dabbfe43501,0x0000ffa707b46c36}},
   {{0x000e3f1d4e353b7b,0x00043f46b0a00ce4,0x0004b73fd062d8a1,0x000ffcb408d5ab57,0x0000c41d1ca83273}, {0x000e1e76be77800a,0x0007256550313538,0x0009b331a71fe8b3,0x000f727cd916216b,0x0000d825d0c5b388}},
   {{0x000e05b1cb76219d,0x0000a1567e7e56c2,0x000c4c9100ec0bf9,0x0004d917076f8661,0x000067b085c8abc0}, {0x00004595e93a96a9,0x000a6bdc249a9fb9,0x000dd0bb77526c1e,0x0006947d44d367ec,0x000053999182dc0d}},
   {{0x0000ee99e240d181,0x000ca4b944666136,0x000e5325c057cdca,0x000e3bd7667cd12f,0x0000fa297b531974}, {0x00081e7db083d762,0x0006d206bd15fa40,0x000c19f8c31993be,0x0003576949269b14,0x00001468d72c9d92}},
   {{0x000c583a4c506ece,0x0007f1acfe972ccb,0x000f1aea2957ed18,0x00062cabaed83312,0x0000f2a6cb563253}, {0x000de428e195c43b,0x00095e6050c6130d,0x000686a5dc842025,0x0004a77da972a708,0x000052999a29508b}},
   {{0x00090b910a5a8bda,0x0008696864dad9f0,0x00067dbc1ca91d24,0x00064bee6a93be3f,0x0000cae6fbb95f47}, {0x000c6e0d21411a01,0x000fca0a4ad81563,0x0008c803028fa787,0x000f07c524491c90,0x0000257ba0e5c795}},
   {{0x0009167ceca9754a,0x0005ab7939a083f4,0x0003fd0bf426d2cf,0x0004e18555e35572,0x000096e6d0764f14}, {0x000a8dd87880e616,0x00058508e4d54768,0x000b65e151554381,0x000f9fa9d7e772b1,0x00003439dd70c302}},
   {{0x000802fc14e35c23,0x000c1341333cb93f,0x000d4f36271735b7,0x000c8dd3a2510416,0x0000f4d069bef433}, {0x000ae01f78f5a7c7,0x000e0c4eed070d83,0x000e10f8350a8ffb,0x0008e1574f890676,0x0000d0809670ddaf}},
   {{0x000f8e1698e04cc2,0x0002f69005c8b11d,0x0003c6179877be20,0x000c0512749e8c4f,0x0000dbc9d0a9853f}, {0x0004f939454d9370,0x000db4800e1b187d,0x0005e68e8e682ce9,0x00085ba9129ad816,0x0000fe29735be7f7}},
   {{0x000f40c5b9e02b75,0x0001e5ee04e85303,0x000d6632ba37c969,0x00045b0f46cc2034,0x00005ef72b2e6ac5}, {0x0005c1f7b91b0620,0x0007bb33e821abec,0x0009f41170a79e1c,0x00075abb04b4283a,0x0000de1f28ffd2a4}},
   {{0x0009ccf3a4434b4b,0x00006a7954dc3101,0x0004972a7a345811,0x0008dcf9dac80de3,0x0000043d05524f6b}, {0x000319e11137b1a0,0x000eed5cc03f021c,0x000ea5ad400a754c,0x0005b60aa2c794cb,0x000093e67f470c01}},
   {{0x000fee9c97e3f6b8,0x000436da746172cd,0x0009806b9c10bcab,0x000f46bb02d2fcb5,0x00005185e8a21de6}, {0x000931f0eb6c4d46,0x000d74fa5b0439e6,0x000be7eb84d4440b,0x0009bbf418786e34,0x0000380e521fd725}},
   {{0x0000351d598d7107,0x00065b3a4da420ac,0x00071de1f272c416,0x000b0f6b82fe1aca,0x000046e79f348f54}, {0x000c7364b573e9b5,0x0006ad4b50406e7f,0x00098d87b75d03f4,0x000da10c1cc36d0b,0x000013ba3f16f472}},
   {{0x000af26abb177dde,0x00079891d56479d0,0x000232173f82ab56,0x0006184b6768a972,0x0000fbb3bb16c1f6}, {0x00011dba6d183586,0x000750916d3ab29c,0x00088e290519e279,0x000a7f74dc18f091,0x000048e86e3f8b0c}},
   {{0x0003145983c38b5e,0x000b837abc8b859d,0x000ff7be6b14f176,0x000a594793fb9dca,0x0000be5a56015a66}, {0x0001dcd9f87dc596,0x00039bdbf5607cec,0x000eb32577c595cd,0x0005fcfb543b2226,0x0000908064724c93}},
   {{0x000440381e9ede3c,0x00040af6df0a7f2e,0x000073b11243c389,0x000a61bc605bb11c,0x0000d06a5427a6a4}, {0x000894949d4e2e5b,0x00069af668802916,0x000a8503533649d0,0x000f4b0fc0c885e9,0x00004e52114ac410}},
   {{0x000b70678a6513b9,0x000a0edb1943dca3,0x0006e2dd892ea4a2,0x00089372642216db,0x0000b45d0b52fd57}, {0x00070dbc69d11ae9,0x0008bc57595f114e,0x00077c2721477dd1,0x00059c2c2208b4ec,0x00005c5b4d86b68f}},
   {{0x000fc6342e532b72,0x00027ae35290b8c4,0x00001ecbc386ba42,0x000fd6db5dda42d2,0x0000353dc8bc0e38}, {0x00085ea68f7e978d,0x00015ad6d11f9a0b,0x000f6886d96ec568,0x00014c8e279d6ce5,0x00003fe03ce0cb19}},
   {{0x0001fa47ea67c77a,0x000f43ea810cfe54,0x00001d374952bd2a,0x00036dd91fef568d,0x00003a1c621af113}, {0x000d5a9c7ec6d792,0x000f1225c3425ad0,0x00069601bff7038a,0x00047ce03c6689bc,0x00005059bc765e87}},
   {{0x00065b2f2086fbfe,0x0005a6916078fa49,0x000081d6cf6840ea,0x000644f7ac762070,0x0000600da3295328}, {0x0006f63529b8a80f,0x00073d7d6f3e0191,0x00064ca7ce80e485,0x000b0b39eb0fe8d6,0x0000017637cd7b43}},
   {{0x000c80676cb25661,0x0001a24892d99a75,0x00008fe458f76acb,0x0007d86ae7b9cc1f,0x00009ef73297a490}, {0x000ab715f228bf03,0x0009517032d72db4,0x000abe3c0f3cdea3,0x00025bdb1f482edc,0x0000baf76b4eb863}},
   {{0x00065e010089465d,0x0008be77c596d490,0x0003dbd953bab5d2,0x000498a636c3a619,0x0000ef5d2958246e}, {0x00058b9286b24756,0x00096d80862bb22c,0x000992388a0b9393,0x00014bd002c83af0,0x0000de01f9c4acbe}},
   {{0x000688eadd70482e,0x00099b4a4e8a6aac,0x0008a6eef708de92,0x000c4295b6dd7375,0x0000a4bf353525b3}, {0x0001f2c87912868c,0x00052f09297a1004,0x000f3860ab1b1be9,0x000f4a59ae23c5a9,0x00004f0f83a115dc}},
   {{0x000cca397f6306a7,0x000df8a3a4b03c7e,0x000a1d8a2744c44a,0x000577f9cd13a0b3,0x0000cad0a1ec256b}, {0x0003fcd33791d9ed,0x000ca4b2e05fea65,0x0007affa29cc2a05,0x000441a3b391dcfd,0x0000db7091f86b05}},
   {{0x00027bf8538a5c69,0x000cf9abff17c71e,0x00071e3da195c63d,0x000fa06d3152851b,0x0000cbdfda88a680}, {0x00076ca849d7eab8,0x000abc2732719db8,0x00008dceaebe2764,0x000b6fe63357e3f2,0x0000c5bd833d65b1}},
   {{0x000b4f59837fc0d8,0x0008279cf00fccc3,0x000df39909b641ba,0x0006b0f428243ddf,0x00003a594c482078}, {0x000451a526c45028,0x000deadb3f93b712,0x000ff0ccd9d39438,0x0004c37db261e3e9,0x00000344e3d607af}},
   {{0x0000d7c2fa4f1264,0x00051c99a2327590,0x00025e0c308a3b86,0x000edee478b6bfdb,0x000082cc2c2b1db2}, {0x0007e645f321bb80,0x000b9a8005b437df,0x0008c19588a93821,0x000d0a3fa2f10ccc,0x0000d3322182c269}},
   {{0x0008119e246b0e64,0x00049349fd1720ab,0x0001aa100b39781e,0x0001689293231eb3,0x0000b779c97fb032}, {0x00019e1c84705003,0x0008dc4c869d4b3f,0x000a6bbcc45b7efe,0x000bc1ab84f38aa1,0x0000b59cb15e2fdd}},
   {{0x00014df3fd165e81,0x0008f61f8811ba55,0x000ef9f00499fd6a,0x000e8a62cd1fe0bf,0x000020a4bb989ad7}, {0x000d0955f4a5ac5d,0x0000c5a7a2f0f2ff,0x00017baf1cfd174f,0x000089042301ba9d,0x00002fa487b47f22}},
   {{0x0009efeb1dc77e1f,0x000831c996829cb0,0x0006067bbe956693,0x0004559c5469016c,0x0000d37857551c24}, {0x0006cbe81796b334,0x000618e87f8b2b6a,0x0001b01b462d550f,0x000e11db763e1c7f,0x0000b93cfea5b1b5}},
   {{0x00052381d531696e,0x000fa8cdde69b934,0x00086afc757201bf,0x000ea7fde922519a,0x000030438969d35c}, {0x000c1e18555970de,0x00084535935e7608,0x0002ea38b8267dfa,0x0008b4f4c60a5732,0x00000bf7978604ef}},
   {{0x000ab28c06fece4c,0x000dd4e7b49d1a0d,0x0006dab28d405991,0x0008fb0542b6d270,0x0000b228da469161}, {0x0004164107d1cea6,0x000370f5d8f1224e,0x0006e41cdeb9fdab,0x000146602ba3860d,0x000076a72c5fb1f7}},
   {{0x000dd984d6cb00b1,0x000ace2e8d7cffd6,0x0001c7936cef9c5c,0x00072e91bbf5d764,0x0000b95b230fe8f7}, {0x000a92ee8ac25b1c,0x000b7a18b7c6f765,0x000cc8966ceb04cf,0x00000367944cef0a,0x0000bb3c958034c1}},
   {{0x00071a1a43ff93c7,0x000731e358a99c99,0x000d9bc825bc2db1,0x000051d5b4862ea8,0x00000ebfbfb9201e}, {0x00064c792871591c,0x0005f42d0219afdf,0x000d8f03cea5bcae,0x00033c1e536c552a,0x0000d6c3f4e676aa}},
   {{0x000f6230bca6de32,0x000991e706fdbeb5,0x0009059d4dd20dd9,0x000c4e70b3ff9dac,0x0000d7b29029cccc}, {0x0000a59ce98840f7,0x00001410680a8a09,0x0003379a5a5d947e,0x000155d9ae346a92,0x0000dbc84fa228a3}},
   {{0x000d91654a1aff29,0x0009aa78fb9bfd40,0x00029f95eabf318b,0x0007f9c0152ed830,0x0000fc1dd78558ad}, {0x000791513595c172,0x00086f62b3a95fa5,0x0003055b0b950466,0x000125707b5b24ff,0x0000e995e35ba84f}},
   {{0x000cf697e9bbcfb2,0x0006c86d96e387da,0x00095a75c95d0c1d,0x000f2145726e3c2d,0x0000c3c9001ccd27}, {0x000b5616c973f57b,0x000bf52216431dea,0x000ef79d4108b7e2,0x0008c5afee9859c4,0x0000d62b88af0d4b}},
   {{0x00029c4197c75d61,0x0002a7076febb4dd,0x000f2df11266a6df,0x0009ec8512d0ea4b,0x0000320c24f7b0cc}, {0x000e0e101a595966,0x000b8ff9aaac6bb1,0x0005aa6c98317c5b,0x00088f05bb405e38,0x000013439c1ef079}},
   {{0x000049f16a66e918,0x00007a1b0e0dd730,0x0004c28eae97f282,0x000c61c131e00330,0x000020ab732d26ba}, {0x0009ef9287144234,0x000a6db10cb2b2ac,0x00086a4cc54ecfff,0x000d494781476ef8,0x0000b2c87b61b2f8}},
   {{0x000cd200a44295d8,0x0000d8c6b044e857,0x00096757c707d7d2,0x0007142e8521f9f5,0x00007448f03e7b2b}, {0x000bc455ebcd58d0,0x00099122d3c113a9,0x00007664279bcced,0x00067d3c6442479e,0x0000cf227782df47}},
   {{0x000aee471d444b66,0x000f65084a1d5e61,0x000d3eaf6211236b,0x000bf51e15bc9a4f,0x00008df2c350b622}, {0x0004f0f59bf4f363,0x000ba7f34d739e67,0x000497b1df883669,0x00003b948ac1b831,0x000023b925d81067}},
   {{0x0006f4274082008c,0x000a08482bcb2215,0x000173479effc521,0x00048f9c6831bf12,0x0000aa2529084739}, {0x000102a8f1b3c4d1,0x00011d9bec0d84d2,0x000a546efcf64dfc,0x000ef1333febad78,0x0000f621ec38b73c}},
   {{0x000d627373386156,0x000aa1d8edf66aec,0x000e86b66162082a,0x0005db233a811919,0x0000023a2523299b}, {0x0000c3abbf04b89f,0x0008be749a44f5bb,0x00013de3b6735eb6,0x000ccce0e058c547,0x0000df2593f1c3d4}},
   {{0x000414efdd236675,0x000aaa2015ee1b8f,0x0009625ffdd52aac,0x00018bee31b517bd,0x0000ec9322dddb59}, {0x000ac85a96f5294d,0x000291a0666abc73,0x00008ac4282aa5bf,0x000dfb79755810bf,0x000021cdfd6591ce}},
   {{0x000b57b67f8be10c,0x000b96ffa726918c,0x00032de93365d1a7,0x000d016435c50465,0x00000fc5e10e674c}, {0x000fcf89cbbb1423,0x000a7fc506926e51,0x000bcae221d436e5,0x0003b8466bffff3f,0x0000148c2fe2d55d}},
   {{0x000fdc9233222fa2,0x0002c419fb6b52c7,0x00025497789ff109,0x000ca71cd6db9925,0x0000e85a1613cf12}, {0x000547cdc810bc9e,0x000ebd257c22add2,0x000d6b19bea3f458,0x0001a5842c1fbe27,0x0000d07e6b5f4048}},
   {{0x0001d4286d2e0f86,0x0001ae8a9fd56ada,0x0008c1b49e592012,0x000afea2c936af70,0x00000f30fee8b4bf}, {0x000ad06858e6a61a,0x00069fd374d06637,0x00088defbce4c776,0x000b6599d54b2d71,0x00008c9d251956a6}},
   {{0x0000f5eb24fe1dcd,0x000d9b73f24c58fc,0x0006507059eaf9de,0x000728d90d588b33,0x0000e5b62c67f2ec}, {0x000cfaed3c2b36ea,0x0004634435da5c72,0x0007ee145868c19d,0x0005b0e8605f93e1,0x0000a60c4ef17a5d}},
   {{0x000bfd23b60c472f,0x000bfb1d3049bcf5,0x0003895c9af4ef13,0x000821473f44fce1,0x000029b382ffcbc9}, {0x000b85373efaef69,0x000c18c96f401bfc,0x000191e24cf56ac9,0x000dc247adf1097a,0x00008035f454f8a8}},
   {{0x00071b91e750c846,0x000bfdc6c469f40a,0x000bc19c1c57f7b0,0x000db7e9a0e79c6f,0x0000b0f588a048eb}, {0x000d084a07c4e9ff,0x0000bb27de145d3f,0x000e08dccc383011,0x0003a21e4929fe33,0x00004a5ad2530bb7}},
   {{0x000c2bf490f97ca7,0x0005f7a1ce18de86,0x00044478d288f09c,0x00003fc64bb88618,0x0000840fa433eedb}, {0x000fdd25a631b378,0x000e247c8b7d1269,0x0001c626694761f1,0x000fa77c0c2e1748,0x00005e16ea2bdaa5}},
   {{0x0006033924910480,0x0003f4d402d7ccd8,0x0006a865c0c2f696,0x000a876336f7dfdf,0x0000a2a463cb5c02}, {0x0009be7bf2f12ee2,0x000246bad988b0e2,0x00023c1d7f0a2200,0x000c9807f87e0391,0x00001669c55528a8}},
   {{0x000980392f145296,0x000c03954df3186b,0x0005a46f6d3d056c,0x000557cf03fd5817,0x00003e34ebe71558}, {0x000edee5b80cfa5b,0x00002401dbd1e13f,0x000a9d667e872a12,0x000692a2657616e8,0x0000c8da4b7908d6}},
   {{0x000b9bb1b703e75a,0x000634338363370f,0x000ef7bff6773b18,0x0007d978dad378ec,0x0000ac787ee39567}, {0x000ea8b0437164b0,0x000073fe795e4801,0x000e5eb73f430ad2,0x000c0eb164154d8e,0x0000884ecd8108f7}},
   {{0x000c0965f5206989,0x000db4f7b8d90e6e,0x0005a68b9640631f,0x000f4e02fd34fca3,0x0000c5a4b66dd40c}, {0x00054bf80b6783d1,0x000e2a320a109494,0x0000a39b280e701f,0x0007db7d1a564a1a,0x0000436d53d42058}},
   {{0x0006e6d6556c3629,0x000052455d7ef509,0x0007230f9bc23a3c,0x0002fcaa7aee5480,0x0000ba1cfa6b2ae8}, {0x000057a99c5d7062,0x000b642315c9833a,0x000a72f128be85f4,0x0003cdb083179a66,0x0000fc77d5dedcc7}},
   {{0x0008a805616ee306,0x000f87ab108322b8,0x0001270cdfb09548,0x0009ab2ad6ab0d51,0x00001f6c57ac924d}, {0x000bf7290aecb08b,0x00085df784a4a0f7,0x000af1d03849f87c,0x000acd77c79c15cf,0x0000bf9f6767463f}},
   {{0x0002c65765ba5436,0x000be2ea60dd9150,0x00043ecb318ce3ca,0x000eeb85cee6ac6e,0x00003e4e910c8f2a}, {0x0004fa3c85932eeb,0x000a9c90c44d2623,0x0008a50f696883e8,0x0000de79b9e738a1,0x0000fc62b2aef042}},
   {{0x0007d906d3e1fa9c,0x00083e05b8a3d22a,0x0002b9c011711561,0x0006a16a0c9926bb,0x0000739fcc7a07e7}, {0x0009157165e439a0,0x00026a9063d8540e,0x000e927a306353a6,0x000e7f84d9559461,0x000013b9b26e2e0b}},
   {{0x000ec3b973497f10,0x000e093ebc2d4fea,0x000af058315c0f94,0x0003406af5f22733,0x0000c2af206c61f3}, {0x000bdf14457397cb,0x00071abcbae0d25d,0x0008153062e8ed01,0x000d6833010938c2,0x0000aa9933898c6c}},
   {{0x00031823b0ec7de9,0x000ac8df05df0851,0x000c3b6831e1b822,0x0004cdcc14842fa5,0x00008fe977eceba3}, {0x00016c20d5e88732,0x000a9d0d427dfd23,0x0003fc961e48d839,0x000a5e295b221862,0x00004ee56e7d46fb}},
   {{0x000a55b91e4de589,0x00054fdea2889184,0x000dcc943a7488ca,0x0000fc1723862ea8,0x00002d762b3149dc}, {0x0004a12091ff4a95,0x0009bcada2743c44,0x000d8eae2581113f,0x0001ea69de0a4530,0x0000e0fcd862f6b4}},
   {{0x000ea68c094dbb56,0x000e7968d4106233,0x000b3002db77d062,0x000d57de719bbc58,0x00008e7dd3d9dc49}, {0x0005740013a5e585,0x0006ec9e3c1b8d82,0x00099b6ab2131174,0x0008f1bcb0a2a77c,0x0000c48a3b412f88}},
},
{/* digit=8 [{1,2,3,..,}]*([2^56]*G)  */
   {{0x0003e91991724f36,0x000bd9cbd686c791,0x000d4fc1e5eda799,0x000d547db595c763,0x0000b63b80c0c4fe}, {0x000fc697e5fb5166,0x000a70f1c9646ea0,0x000a92ca5737708b,0x00067a3628745f11,0x00001f37958fa869}},
   {{0x0009b2caa6650728,0x00046fd324ef9af3,0x00027bd3178322fa,0x000aafbd153394c3,0x00001d5f271b129d}, {0x0000c42f48027f5b,0x000bd536e717c72e,0x000369d0faa40cdb,0x0004e6445a657a2d,0x000003bbfc59a7f7}},
   {{0x000c4180d738ded3,0x0000b0de572946a8,0x000a816756f1a5bb,0x0003d4c10230b98b,0x00002c6f30c412b3}, {0x000129dd8fffb620,0x0007b459bf057559,0x0003b67766a281b4,0x00073a77c1bd3afa,0x0000709b38078299}},
   {{0x000b232a3326505c,0x00022e1d41bf8c26,0x000e32afa38d6927,0x000a864459453eff,0x0000e8143ae3cb3e}, {0x000c1fa7e6ab6665,0x000fd2286264932e,0x00036f8ed6cd2d22,0x0005baf59a46fe67,0x00000bf0d00eeca8}},
   {{0x0005852877a21ec5,0x0006bf537a940b82,0x000a9a6a2300414a,0x000bffef1cba4021,0x00000824eeec6943}, {0x000fcecf83cba5d5,0x000843b4f3c0a0db,0x000f24dd7f953814,0x0009dd1174416248,0x0000322d64e34fb0}},
   {{0x00073843d9325f3b,0x00004371cb845744,0x0001e36c5a9bef2d,0x000f71c7d2188ba6,0x0000bd6a7d87602d}, {0x000a9028f61bc0b8,0x000ceed0b6a1ba3a,0x0006e8298f49085e,0x00001d0bc625d6ae,0x000032b0b1e22e9c}},
   {{0x000c447f1f0ced18,0x00031492dd2ba337,0x000a08efa800cc79,0x00041dcb93151dbe,0x000020cf3f95e0a7}, {0x00082dc1c0f7d133,0x000054dde6caff19,0x000f96ee3ef92196,0x0000c6ead7d97245,0x000019c8dbe59dea}},
   {{0x00038717b82b99b6,0x000ce70eb624d3ea,0x00095d46675922d4,0x0003462f66ec543b,0x00006e673cd1ee1e}, {0x00067c4b5f2b89a4,0x0005e90e5cd36afe,0x0000a2ada3de9c1e,0x00023b4c278bb631,0x000020fa3844bdb3}},
   {{0x000d63b0eb919b03,0x000d774b96200ae1,0x00074290cd74ee51,0x000510095458d0a6,0x000024c930f7620a}, {0x0004d19fbac27d45,0x000a4bedeeac2d1f,0x000679ab84086e8c,0x000ec3bcdd211b9b,0x0000970167dc090f}},
   {{0x000f2c9faf1fc639,0x0009a28c8bb43420,0x000f1fe4a616d333,0x000739ed65364c57,0x0000343e877e5e5c}, {0x000176be970e78cb,0x000eb05336275795,0x000cdfc1ba36cceb,0x0003264c7c738009,0x000039a2aff63fec}},
   {{0x0001ba16224408a4,0x0001e47cfc5eb7ff,0x0008bc493cc856e9,0x000726c1f102e7c1,0x0000613ab746091c}, {0x000e89cc420bf2b3,0x000660337ec2aa25,0x000025fc700a5317,0x0003dca2be9f437d,0x0000316fb859e6fe}},
   {{0x0000af59ac50814f,0x0007aa8e42232752,0x000bec5a0fdf95e7,0x000e5cc7e7df2a56,0x00007022f7ecf159}, {0x000eab1cac1fe8ff,0x000b4745116893ee,0x00067dce68040188,0x0002988ee8aa8ad9,0x0000a0e79e82abc9}},
   {{0x0002cfc2064cfd1e,0x000dd06519346733,0x0003bcbea339c31d,0x0005c5919b28d52a,0x0000e74c82c7d6ae}, {0x000d05ebaf28ee6f,0x000bad7190280927,0x000b3028982cecf2,0x000e281b0d353edd,0x0000e4bb978eddb2}},
   {{0x000b990640bfd9e7,0x000712f62108bb5b,0x000ffdd56d226e27,0x0001b4dbf0098502,0x0000756758a9ca1b}, {0x00062a35285fe91b,0x0009dc9cd140c32b,0x0005cb008edbc546,0x0008f16e47a013af,0x0000ca7e720b73ce}},
   {{0x0002ab817a91cae1,0x0004f8e27f63e10b,0x000a3ddf9b89aab6,0x0009726b3074a7db,0x0000c20ce09430c2}, {0x00017b45fcf7e33a,0x0002f45ceb426b99,0x000633d19e679374,0x00047378fc22155c,0x0000d1adb3d67485}},
   {{0x00096796424c49b9,0x0007d7c241c9646f,0x000f68b49f888dfe,0x000f20512d4b9324,0x0000a6b62d93571d}, {0x000b26d179483cb7,0x00022511fae281b4,0x0003aa51f666f963,0x000d166281b3e4d5,0x0000f96a765ef3db}},
   {{0x000b5bf074a30ce2,0x0006e05a32e6a7f8,0x000237ed4d7f5210,0x000a2b4f9e090750,0x0000f21da47a096f}, {0x0009cb4eec863a09,0x000d0527620af3e1,0x0007c1cf8d18f77f,0x0002840505c81c40,0x0000998db4eab6ec}},
   {{0x00089e5c247d44d3,0x00010f4f3d807e33,0x00078a6c71250714,0x0000bea4ba01104a,0x000012874a0a6772}, {0x00059a6759443709,0x000fab2c0bddded0,0x000c108e3d6123d8,0x0003e9156b717b51,0x0000bb7940e97062}},
   {{0x0002d5984ac066c6,0x0002868c69a0794e,0x000d99dccf5954a9,0x000516c8c524584f,0x00000e639fd11012}, {0x00001257de792488,0x0004712fc6d7c2e6,0x0003b5d32e9ef640,0x000b89cc4f28082a,0x000065ad32f4768e}},
   {{0x000331b13fb70b6a,0x0000f5599b27ac02,0x000bd082c037b44c,0x000d007a860fc460,0x00002e257466980c}, {0x00087a81da0263ef,0x00043d10f3d6ee33,0x000f24a32931bfb9,0x000b856b687270a1,0x0000140e65eba494}},
   {{0x000df91b2f1ac7a0,0x000b760fee274f4d,0x000c228e5f99eaab,0x0003bb57f4008a49,0x000090be4401cf71}, {0x000fbe45004f022a,0x0001b69e1af6ac91,0x0001daaa5d838c2c,0x0002c036c7d20b0f,0x0000a063ac1bbbb0}},
   {{0x000a42259558a787,0x00091435da2f0938,0x0004410dc5343c66,0x00080426f67b1803,0x0000cc1e424f4510}, {0x000543f16dfbb7d8,0x0001db5bd59286a1,0x0003dd03c921fa94,0x00051e1dcccb6eb3,0x0000581ddda3843f}},
   {{0x0005fcb81d73c9e1,0x0008fa5e97ab5493,0x0003a6bab6d07e97,0x000e113dc7b30acf,0x000047ab1f3270be}, {0x0008e3d9fafdee4f,0x000a638a8b950aaf,0x000f13871fab3dbc,0x000a48505df4b36e,0x00001f4e9cbf88d5}},
   {{0x00024d366b33f1dd,0x000f8ce445c09bcd,0x00093ff613b97b81,0x00061612926549ba,0x00009c341cf1dafe}, {0x000a76e16efb6f3b,0x0009b05b953cfb30,0x000fffb9fdf24b8c,0x000b95dbd52afec2,0x0000bac5ff8919d0}},
   {{0x0001b87459afccd8,0x00033743265243c0,0x000b5d78e6bd4514,0x000a7d0473453055,0x00001088fdb9554b}, {0x000a52c1e269375c,0x00036dc5ec10ada0,0x000bfbc11f9f037c,0x000d2f0066060794,0x00000a630bc89c40}},
   {{0x000797eab64c31ee,0x000a945071445efc,0x000a6790cffdb1da,0x0001bf161242871c,0x00009609d82c69bf}, {0x000859500d24fc90,0x0003e51fb417db89,0x000f7bbde9c75033,0x00085c51830a91fe,0x0000ce67dc8945f5}},
   {{0x0000ed44763eb501,0x0001b1ab0d669a73,0x0008748f324a0e22,0x000291543b639364,0x0000982daa17d3c6}, {0x000a9f78bbc55499,0x0000ef36384e6f00,0x000977f507a1783e,0x00002a58346323de,0x00001ab688e42455}},
   {{0x000b6b56d0bdd662,0x000e44b71229331a,0x0007c352f0a6ef32,0x0009d2f028150efe,0x00007e04350ee7b3}, {0x0008acdc1070c828,0x000300c9feef2a3c,0x0009f3729fb2034d,0x000548ad72962170,0x0000df290bfe2cb4}},
   {{0x0009f33fc2e43263,0x000d2eddf03202f9,0x000652fb53b30076,0x000f7b8b21f8cf0c,0x000014fb49f1d91c}, {0x000eca52f7007501,0x0003612a4575a013,0x00030fbb02b9e3c2,0x000771d5355557af,0x0000ada35168c77e}},
   {{0x000ecb27b1356705,0x000f2cfc202e45f6,0x000d1be9fe85d19d,0x000343bf1b50c758,0x0000ebf2c0b3ad2e}, {0x000fe4eabc199c90,0x000256bab0ae1531,0x0001fec54c703259,0x00018816ab2e486c,0x0000f87fda804280}},
   {{0x00046fc609e4a74a,0x00031a667f91dc9f,0x000d834362a44a14,0x0009581c3d8b95b4,0x000001e4bd167bd2}, {0x000293273483c908,0x000127c7b5987b18,0x000aac07ea79c6aa,0x0004e63f3983c6ea,0x0000f18181f16e0d}},
   {{0x000d37c051af62b9,0x000a7bf944968553,0x000d59aa1e9a998e,0x00081350844f9fb0,0x000083fd55976afb}, {0x000c0ca65d698049,0x000ddea5ff2d9670,0x000d8623b732b22d,0x00078247640ba95f,0x0000f61916436351}},
   {{0x00027eeacee50437,0x0002beb10f020bfc,0x00043fb05ae419e7,0x000a29a9c028d189,0x00001f01cf86f13a}, {0x000737e8887a132f,0x0008763184107790,0x000db795e6751330,0x0000b1a819e8a37d,0x0000ecb8ef6cad10}},
   {{0x0004a223021926a4,0x00092f9b4c1c59f7,0x0002ad0abb7c28a4,0x00059cad1a733f91,0x00002a910af41a56}, {0x000c6e07bd68cab6,0x000816d70ac83842,0x00053aaeb2b57fa3,0x000b182a6707a83c,0x00002c1c510c5b4d}},
   {{0x000c1fbb2d09dc72,0x0002066bd23b8de2,0x000b27db6c3dfed1,0x0003da727d039bd5,0x0000fb2f0f130324}, {0x000a07b80be73992,0x000dff9f27a8f855,0x0009bdef7ed9327c,0x000d8880bd99c772,0x0000b67125e48250}},
   {{0x00026e88670ced73,0x000f931bd3b4784b,0x000c85cbce3dfe41,0x000a9d6e353a06bc,0x000002e290990178}, {0x000bf11a6eac16e3,0x00007a2b3aac860a,0x0000afdab7644700,0x0004c116ff9d1985,0x00005bdd6a62db2d}},
   {{0x00094b07e5c9ce97,0x0002b0af346ee825,0x00065ad4a0f379e5,0x000825f08b31e3bc,0x000010c6b12967c4}, {0x00066f971954cf1a,0x00026d0aa21551c9,0x000bd23a8b1cec79,0x000e857f15598986,0x0000e2ff99d99452}},
   {{0x000953c340ceaa2d,0x00045e2e9333d8dd,0x00086f06d2635527,0x00054545d4e5f985,0x00006bf94a9c7cab}, {0x0009a0ab76a9af0c,0x0002fa095af733c5,0x000389ca052740ab,0x0000cb0444de8a24,0x0000c6f9864306da}},
   {{0x00041a76b2515cf3,0x00016585c749b5a7,0x00083de9771c4160,0x0005f548350d4fe6,0x00001d6152493d0b}, {0x000c5e1fbce090b8,0x000d7bcb2a5b7a0c,0x000d84c35aac927e,0x000e266920de4920,0x0000c06a0b6a2b4d}},
   {{0x000d58bafe7ddf39,0x000d31e6e55bd34d,0x0000696e755851fe,0x00005f4139561696,0x000040304b2ef227}, {0x000f861b0a2a8600,0x00020e7cc9816f43,0x000b64a96cf12128,0x00083c121862120a,0x00009215b9ab7893}},
   {{0x000b30537387c09e,0x000e103ee760311e,0x000f7ea19c5832fc,0x00055050358f5832,0x000001d3c3571d53}, {0x000ee41da48ea80e,0x000def4fa4c11ca5,0x000f1e1c734e71e8,0x0004a4512abd257a,0x00003afcdec0153f}},
   {{0x00084d700235e9a6,0x00042c4c836f9d5c,0x000332de50308d3f,0x0006ef60a66b0489,0x000010dd399e9e56}, {0x000a460d1ac16352,0x000b00a2c0dff8ee,0x0004a48c584cbb3f,0x00015020afb488e7,0x00009738198f326b}},
   {{0x000747fa6d74081e,0x000475a262142a17,0x00088c5fe60ea4c0,0x00026b73514bb41f,0x0000dd645685e834}, {0x000cbec96460b259,0x000dd8dc115ed5d6,0x0007840eaa12fd0c,0x000e3135bc3ed269,0x000069876a936331}},
   {{0x0006217472ff5805,0x0004fad4139360c3,0x0003b8b92f422970,0x0004f5fbd99ef0a0,0x000001c73181144f}, {0x00009b318464945d,0x000ba4c5c6be1590,0x0001a36606d5e594,0x0000215d58701132,0x00001e184b20898d}},
   {{0x00047524c6a7e046,0x000ae5550b655ba0,0x000c0a9a547fa1e2,0x0002363419daf048,0x00006362953dc243}, {0x00044b15cb12a88b,0x00097b646188cd07,0x000c2c0c0561b6f9,0x000099a99415a566,0x0000e3f0859bf83f}},
   {{0x000c5beb92041b8f,0x000636477d0d9141,0x0002c7a9401ae38c,0x0000dada8b71f3d1,0x0000ab5b320665c7}, {0x0007492487443e97,0x0000290d134976ae,0x000460a378595a31,0x00038f88dbeda87d,0x0000f7ad0828e45a}},
   {{0x0004db61059705ab,0x000a36b9c697ed1d,0x000b38bd5a3dd492,0x000bb69b92ee3a6e,0x0000ab2609e17cc0}, {0x000fe896e70ee822,0x000df3e6b7e37fc4,0x000d26fcaeff2c56,0x000b457b18959e34,0x0000517ab66a89d6}},
   {{0x000b4e0bdefdd4f1,0x0005e366e401f167,0x0003bbec06995846,0x000c214aa368aba7,0x000021487098b240}, {0x000323318969006d,0x000e11fe53d1378c,0x0000c4361cb4d73c,0x00012a8f50a80e13,0x000067f59524ef52}},
   {{0x000e21e9e70c72e5,0x00090566d2fbf145,0x0002397f5b2e52e2,0x0007ddf4eaba4a03,0x0000e56937bce31a}, {0x000f517456c61e10,0x000aa8b0a38868dc,0x000a8b755bc2e954,0x000cdee3552fa760,0x00003442dae73ad0}},
   {{0x000e747ceb26210c,0x0007b87baef937ff,0x000a3de31983545e,0x0006dacb8c853586,0x0000621dbccbacd4}, {0x00042e959266fbbf,0x0006439d471c82e4,0x000cdad96a3514c3,0x000def4a11b77162,0x00000cb3b3ddcf9b}},
   {{0x000dbce478e2135c,0x000efda353423fcb,0x000677af67547b5c,0x000986e97e81f18a,0x00008c2bf83e8817}, {0x000eaaf455809854,0x0005893b45cbdf07,0x0007b4cacc68d1f0,0x000e85d06aa2fec7,0x0000c1d8afc44a7a}},
   {{0x000c3fd9eb45ab26,0x000b74b22e74db41,0x00015958a5b234b5,0x000fa07a253decf2,0x00007e0606f004ed}, {0x000f070ef751b115,0x0005a6f06dceabbb,0x00039f6b4f352f17,0x00048e8fc4b6af68,0x00003ddf9a8e9598}},
   {{0x000c379c21520b0e,0x000ffbd5d1b6da49,0x00049c7f790864fe,0x0002d74f055d235f,0x000051e4e6b8796b}, {0x000a67f5c9dc340a,0x00071ca7c620c361,0x000c756d05ad53c3,0x000e133a1d658832,0x0000d60d9122bb67}},
   {{0x0007bdf0eeec8c68,0x0000878a1821d6c4,0x0000995244a27fec,0x00005f881f7415c3,0x0000effdf0c02cd8}, {0x000ec1c65842df85,0x00088319a901db70,0x00042b5298821b35,0x00028622ee56eede,0x0000bb39592736e4}},
   {{0x0003316fd6f7140f,0x000acd8e81f7d118,0x00002d962f9fadb5,0x000323801d5e0c5a,0x0000dee4dc00b601}, {0x000740735d7620e5,0x0003a48c0012bed1,0x00055449a04e3c2c,0x0006c44ee29da734,0x000062cdef4e1a83}},
   {{0x0002a5f477010973,0x0008cf88d0c28f68,0x000bb86dd617125d,0x000286648fda2457,0x000048abb8f589f7}, {0x000eab599d94bbd6,0x000de684d160eb10,0x000c8f41ad51ba28,0x000f4a4be0e51c30,0x00006588b4573254}},
   {{0x000bf01fad097a5a,0x0007c10e815d147e,0x00011de5649883ea,0x000a6d444d60ba8a,0x0000970de6f227a7}, {0x00014245e17fc196,0x0006a12140572be4,0x0003e723fd833c65,0x000e9ab375813b36,0x0000820bb8946a52}},
   {{0x0006970d875d56ae,0x000b71fbf6bf7e7f,0x000083c12d6a0a9a,0x000b6374ba8790a3,0x0000baeb23e4ae7e}, {0x0005c3ab99a907a9,0x000f726bf40ba868,0x00002cd9ef1e7454,0x000634eb73a027c8,0x0000a8a927cdfef4}},
   {{0x000f60c08191224d,0x000b0e4ec091e1b6,0x000e38d84c4126eb,0x00098511dff4dc4a,0x0000e3f57dc1f2ef}, {0x0004337d446a1dda,0x000fe59e77f63496,0x0001d13f57bf2179,0x000e26eff105278e,0x0000304ef0414eea}},
   {{0x0005e47d19dfa5a2,0x00035fad982bfc6f,0x0003715f5db007de,0x00029e08205ad161,0x000051e672998895}, {0x00051841ae98e78c,0x000c671cac327270,0x000f410f5f818537,0x00039308a15b7eb7,0x0000474357041f62}},
   {{0x000dc5ac242316b4,0x000c9bf4aff592db,0x0009a8ec6abe060a,0x000b942e8c38fe90,0x00003e514e5a116c}, {0x000fa3807d784f90,0x0000f4b5b3572078,0x000adea3d1161a88,0x00010b5283ce7913,0x0000756c3e6cc6a9}},
   {{0x000fe01aaa79697b,0x0008a6391db160bc,0x0009b45a004a73b2,0x0008d92d8dad4718,0x0000fac0dd0f8d5b}, {0x0003af57d3d2ec27,0x000cb07bd3af34ab,0x000550ded6fa2fc2,0x0009132ff4009266,0x000019b3e878fd5b}},
   {{0x000a4966d17fbc7e,0x000993d2b24ea573,0x0006769370cd1a70,0x000f2054e2c5cab2,0x00007050b079f669}, {0x00048b61ede9046d,0x0000c7662659fbe9,0x0000124c5a053005,0x0006c788cbd4edf1,0x0000e2646e5ad6c0}},
   {{0x00081088cad38c0b,0x000fbbd68ae2332f,0x0008e27a3471b7e8,0x000b0ca6ac3fb20d,0x000054660dbc36b4}, {0x0001e11a6fd8de44,0x000a637799ef123a,0x0006ac17c44dbffe,0x000cef0540b977ce,0x000095173a8ef60a}},
},
{/* digit=9 [{1,2,3,..,}]*([2^63]*G)  */
   {{0x000284d391c2a82a,0x0002758308e89ebb,0x000f1edcabcdd486,0x0006c7606f16ec83,0x000013e2c38095dc}, {0x00056f04a057a87a,0x000006b48f982ab7,0x000651c44a876550,0x000e01a252face68,0x000052b540c81765}},
   {{0x0002fc516a0d2bb2,0x000bfa6234994f92,0x000c62c8b0d5cc16,0x00067f7241cf3a57,0x0000f5e69621d1b6}, {0x000c70bf5a01797f,0x000c709561925c15,0x0001fdb523d20b44,0x000f7a14911b3707,0x0000648f9177d6f0}},
   {{0x000acafe60b7cf78,0x000004a9d8696dc1,0x000ba8ac425860a5,0x00029dd6fc6f09e7,0x000028c5bd0e148d}, {0x000435edc55ae5f2,0x000ca0117411ac6b,0x00024342ca527f56,0x000c0d74d5045efd,0x0000c4c0a3590b67}},
   {{0x000c8b8fac61d9a1,0x0002d3c6fe8a027c,0x000bff5037d25e06,0x0002f7d08805bfe5,0x00003271e6c7ff63}, {0x000a6c0232f76a55,0x000d201ef42655dc,0x0000a51788957c32,0x0001739e728bcba1,0x0000ea60412062c5}},
   {{0x000964ed0b8892be,0x0002b301bb74fc4e,0x000c486269ea1768,0x0001018265c5aefc,0x000060cf82f9b3e9}, {0x000f797d4df55311,0x00017deeefe257ad,0x000306eb1235b59a,0x00092d50adcf583f,0x000005c27534d094}},
   {{0x000914bb5def9961,0x0003133dd1e74090,0x0003d5e761cb69c8,0x000012b1e9c1d39b,0x0000f3338ee0ccf6}, {0x0005d0d2f5378a8d,0x00065f00cd21b1e9,0x0005fe290acf4c2c,0x0008ad9e984240eb,0x000066c038df4808}},
   {{0x000264af94d70cf7,0x000f0314bf7e804d,0x00033ed02bdb802e,0x0005d91fb54de243,0x000040461e098563}, {0x000b2c8365e9383a,0x00029fdef6524113,0x000b956c1ea762c8,0x000fa3aeec6e2e47,0x00003d814bf05620}},
   {{0x000462bb4d8bc50a,0x0006091957709ad5,0x000412a68181c0b1,0x00048c4bd4fe1c78,0x0000e0341bd60dff}, {0x00045cf7003e8666,0x000a2a24a41bb6bc,0x0004c24c2f11a6de,0x000b67f407151ad0,0x00002c9d27e3a5b7}},
   {{0x000423588cceff67,0x000f1b07ed692e96,0x0004d0d0d8594c54,0x000867a578e73cc8,0x0000b4e10566f532}, {0x000c0d5b5ec995a1,0x000504289a54a348,0x000fbd777bf4b9d5,0x00091d8ba155a658,0x000086ed7a82a844}},
   {{0x0002b30614c09004,0x00017d00c24bd499,0x000c4bfa1da98d12,0x0004bc3f534dc87e,0x0000a5ff67477dc3}, {0x00096b81d7ea1d7e,0x0002a0a6d20868c1,0x000cbbd6e38cf289,0x0005b61d56cd09e3,0x0000c72e27f2205a}},
   {{0x00068f5a44f77f7a,0x000d143c52bc15ea,0x000f0e6097aa5f9f,0x00032ae6ff676f94,0x00004cde963ce2d4}, {0x000a0c0eee470afa,0x000dea3f5ec88caf,0x000a3123184137d0,0x000ccf4bb40411fa,0x0000239c1400f7f7}},
   {{0x0005719a8afd30bb,0x0007da826dce3286,0x000a8fbe08679832,0x000ad32f04e891c4,0x0000b6b6e1c9bf56}, {0x0005b11471f1ff0f,0x0008ce15baf00a69,0x00096c43ed76c338,0x000157118edb95be,0x00002beaaf580794}},
   {{0x000b09ec3076a27d,0x000e1416545d152d,0x0006d6f2e5e82908,0x0004e0d2c4127235,0x0000c9c964301fd7}, {0x000b88d519bf6156,0x0005a5a2274e66ce,0x0005e2fa0e29ecd7,0x000e66da0473c4bf,0x0000b6eb671c4284}},
   {{0x0007932b88756ddc,0x0002317e3e61e8b9,0x000e1c4a4ed4e865,0x000c0e02dd14993e,0x00000aaee18197f8}, {0x000edb96c168af3a,0x000f139ae87515c4,0x000adb4366563c7b,0x000ac00dfadb6f20,0x0000d55e8ca3a042}},
   {{0x0001ed8b76da1f56,0x0006458acb94975a,0x00006028210dfa46,0x00051e2dd7f7e3ac,0x0000813e66ab72a0}, {0x000ae1e350cb901c,0x000590cb7822b4cc,0x000ab3b87b653d65,0x000fcf82484710df,0x0000d7ee5385b670}},
   {{0x000b12e523b8bf60,0x000b8f910c1b0a50,0x0001675888009eb5,0x000abdf535af824a,0x0000f835f9cfb2a2}, {0x00029312afceb620,0x000a169d383ff59b,0x000ac02b0c797df2,0x0000caeb3f5fb066,0x000029d4c6fdaa2d}},
   {{0x0009bc1afab4bc58,0x000ed6783247d405,0x0002d3605833f5c6,0x000433353466308d,0x00003387892534d8}, {0x000b30fadd9419a0,0x0009afe3fce8d973,0x00009aac6bcca109,0x000f110817831508,0x00001b7f21a540f0}},
   {{0x0009219909523c8b,0x000ef3a1c74165c2,0x000c9e55aa62f648,0x000479d8598d4f60,0x0000ce9141bbe4f3}, {0x0007d8435f9b9887,0x0001c20475b69af9,0x00091476c0210da6,0x000833cc076e2291,0x0000520dbd9b4fc7}},
   {{0x0002cfec1ab1bbdd,0x000e0c6509386a6b,0x0005d7bc4ef8a65b,0x000dfca285554080,0x0000a389397bd11f}, {0x000bd3674660876b,0x0004045dff35a9d5,0x000f5da9411d67c5,0x000b30baf7d148a4,0x0000b8d4c4070bbe}},
   {{0x000ebd1e0a1b12ac,0x000cb70ba95f87a7,0x0002ae9cb1e4ef88,0x000402cc33345cdc,0x0000ecf1276c1cc8}, {0x000012e1b39b80f3,0x000d05c33ba4687c,0x0009661c2fd90d0a,0x00029e73ef5a675c,0x000068fc88f10174}},
   {{0x0006761196a2fa2a,0x00071d5b312ed30c,0x000f54a31931b981,0x0005411a01000c72,0x0000203d2c906eaa}, {0x000dee098939db32,0x000c1e606c02f2ab,0x0001ff643e37d6c2,0x000ca3d292157452,0x0000781b3c4f7e2f}},
   {{0x00000b07850ec06e,0x00089d3a10cf6643,0x0004ab39dac5a38b,0x000bb8b233188de3,0x000077057e53072c}, {0x000c042b59e78df5,0x0007cd97de52bcf0,0x000e0ca4a4cfc91e,0x0007bbf661a26c3e,0x0000620a4c24b850}},
   {{0x000d4aa049f842cb,0x00046540e82b4b44,0x000c6f156ceabc5d,0x000d71806710fd15,0x0000e5ae52c13db1}, {0x000e7e6334957f10,0x000031144a7006f1,0x00096447b57e388f,0x000a12fb69bb2fdf,0x0000f78ebd373e38}},
   {{0x00026052b7ce5421,0x00096472bde1b822,0x000d2f4dae6d4ce9,0x000b2e43e16ebe09,0x000080ff42e63b92}, {0x000cc022c34a1c65,0x0008f22c46c2c59b,0x00014a8a23803d6f,0x000b27c8aff74f5c,0x00005aebf8060a08}},
   {{0x0007d587135593fc,0x00066be570cd6609,0x0008c860d32e6eff,0x000162984e6a102a,0x0000d18589162eb4}, {0x000e99d6d97e1340,0x0000dd8447ce7cea,0x000c50273d42c6b7,0x000e1e59ddbb4ab8,0x00003c612df3cf34}},
   {{0x000ca1504b6c5a08,0x000898f0e3a384b9,0x000986c0035216f3,0x0008fdbec2d2bcbd,0x0000bf546da51922}, {0x00055a44cd623c3e,0x0007702b8e5ad1c6,0x000a0bfe7366ce71,0x000e8d4cfc84b4ee,0x000001d5cefaf443}},
   {{0x00045d9036520f83,0x000162d40e988ec0,0x000559a04dfb3c3d,0x0006b0dbac4ccecc,0x00005eccae5540ea}, {0x00032dbf8a5a0ac5,0x00059b699700180b,0x00026bca0547972a,0x00025a53765801ca,0x00007e09d0ef647f}},
   {{0x000970e2fdd23cc0,0x000c5682e971b956,0x000e86ebcb80288b,0x000939e6e6d91e9a,0x0000564c83f8c9f1}, {0x00032a239560368e,0x000a249c28e25519,0x000a158c3e893752,0x0002622b03cee5a6,0x000012d656be4964}},
   {{0x000554e63e3bc1da,0x0001a5044ff74b47,0x0008daa07c719b6a,0x000dc2af24d30ae4,0x00003f3755768c1e}, {0x000bf760700d3607,0x0004122ae4e29a47,0x000f1fb4cbb1a182,0x0005f4b2e275a389,0x00002b1aa240968c}},
   {{0x000eacabe063f644,0x00037ce47a09a75f,0x000d07aca9b392f4,0x000d0f942415091a,0x0000b0c591bcd26c}, {0x000ddfd92f1169ae,0x000b6cbf23922d42,0x00091a2af63aeb1a,0x0001d93de9e87706,0x0000be79af8b9802}},
   {{0x0002a4e40e50acf6,0x00074f01d665cfdf,0x00031be1ff0a98ad,0x000da08fb640bf18,0x0000fe8bd2fe0e9a}, {0x00003a16cafbc916,0x00092308e08c94c1,0x00080ff4f170f875,0x0001f1fde2d2ab97,0x000066466bca5b20}},
   {{0x0002010f5b343bcf,0x000a02f142fe58af,0x0005f4bdf0f2e400,0x000aa84483bfdea8,0x00000b1d093f3bfe}, {0x0001b95c70816030,0x00093dba10972ea0,0x00038f3a6e943e4c,0x00063647be92adb4,0x00000bb7742e5bf6}},
   {{0x0007083824297b45,0x00000584455f136b,0x000c7d69e9d0e558,0x000e765b48cedcf1,0x00003a9e4817a256}, {0x000b0e065eb24132,0x00046fc407a70402,0x0007f5492dadbbb8,0x000294865cd5a48d,0x00001d4429394bae}},
   {{0x0007ce63b5f1cc41,0x000abe872e626691,0x00005f24437ae52e,0x00074fab087b7229,0x000020770862e6af}, {0x0004e491058edeaf,0x0002c638ca1d4b64,0x00038591c827510e,0x0000629cf2b70460,0x0000fc8b47bee635}},
   {{0x00020e61b4d5e634,0x00025d961b4b3ae2,0x000d16bedbd86474,0x00047b210c107e9b,0x0000270352a51271}, {0x000ffe664cfc50e9,0x00098e36cb427d17,0x000dc5f9a50dee01,0x00062b768a762235,0x0000a08d5376f53f}},
   {{0x00014576be5f7de2,0x0008a2263c9e4ed7,0x000cacb36d93006f,0x0008abc073694cca,0x0000ff7a5b45ae11}, {0x00053f1cd871236b,0x000d12aa6d523cce,0x00098d76df156a39,0x000d38ecc5f271b1,0x0000c615b7031383}},
   {{0x00038e8de3eee6b3,0x00087b910d91a545,0x000d278bd58c7753,0x000cae01e5bdbc58,0x0000cde4adfe963a}, {0x0001fd25302169cc,0x000fe989ed8bb188,0x00096a0ee8ca60f9,0x00083ce1999458ff,0x00001141f046c6c2}},
   {{0x000408d6dfafed30,0x0003396615887677,0x000726fa033a0165,0x0006da3c9c15ec0b,0x000090cfd936c9b5}, {0x0004baea3c40af51,0x000bc21129f1e34f,0x000207ce83469ead,0x000ef9bc51674a1e,0x0000e293b24d83b1}},
   {{0x0003d131e6c0bb48,0x000510776d351717,0x000e6f9221900469,0x000a2267980e346d,0x000073554cc74dd9}, {0x000c627cbf18a512,0x000b1032c0810316,0x00046834d4d93651,0x000f80007f277139,0x0000c08d7b450cdb}},
   {{0x0004fb486df2a61b,0x00073cf7b4a2137a,0x000d042ffa1ed9c0,0x0005ec02e460e27b,0x00007f5e2fb0f62f}, {0x000ec6bcc2423b79,0x000f2a63eea77aa6,0x00050a6e175ce0a7,0x000c9ed7a45fb1f2,0x00003bc919d753cd}},
   {{0x000f56f871942dfe,0x000e9859ad669271,0x000cb1a782372ff6,0x000a827f4c2b9633,0x00003e291023838a}, {0x0001611e4e8110ce,0x0004530198cea7ed,0x00020efe02a2d70d,0x0001beddf132e867,0x000061a896346a47}},
   {{0x0003a85825808bd3,0x00070fd6e902796d,0x0006219d151dc3cb,0x000d32343c768a91,0x00006cd7685d2ad7}, {0x0009d05b22922a44,0x000e9ba29660e3db,0x000d2ebc76494c87,0x000f8db0ac91dfbc,0x0000deb57a085107}},
   {{0x0001f59c3d12a732,0x000c85c2c51d4227,0x000797bcb5f71687,0x000eb0ab1f50c605,0x00009ed0ed9f6d34}, {0x0005b474683c2eb9,0x000507447c46e5fe,0x0002071674956eeb,0x0005eecb163a4371,0x00003fa2fed9248c}},
   {{0x0000af231f63950e,0x000034caa2c96793,0x000ac7e62a77797c,0x000aeb726e80ee27,0x00001e6e62738b28}, {0x00078b0b3c9fef02,0x00004d5f90be6361,0x000ce51cfaf7752e,0x000e1f74ecaf18ee,0x0000864d0edea806}},
   {{0x000e38397c69134a,0x00064b2912936de2,0x00060bae05a42c31,0x0009d1277792196a,0x000024de3470b759}, {0x00074aab75d49411,0x00061d501ff049d3,0x0007974cf9890058,0x0001158f16d40eeb,0x0000033860bddd8c}},
   {{0x0009ac82094cec3b,0x0007903b770cb6c6,0x00059590d9976fb8,0x0001fc6dea026c48,0x00006acbb473562d}, {0x000c46144569d857,0x000627f0891d7cd6,0x000d5a17dc3190a3,0x000bc856f5319548,0x0000d9199674749a}},
   {{0x0004837dd1c8a206,0x0007cf6834196510,0x00094022e7e5410c,0x000ac2358c3ca8be,0x000005c3197c145d}, {0x000750101683d546,0x0004f95b12343fc0,0x00081277f1d7127c,0x000adab0b8f87c94,0x000077db2a9465a1}},
   {{0x000ccaaddce33450,0x0007012a4350ec2f,0x000598bdc2a6811b,0x00012896760ff1ac,0x000054d652ad1bf4}, {0x00051d492a210056,0x0000d3110fdf0a11,0x00060100fad7f397,0x0003622c95928c19,0x0000c91c825dbf03}},
   {{0x000b2a2ce309f06b,0x00091a27204bc8c8,0x00048e32efdb27b5,0x000f1e2223eaa508,0x000093e4b2f97bfa}, {0x0008ae644aa3dedf,0x0009d015d573c530,0x000979707317a666,0x000957d888ce231a,0x0000141c1e6fd5c4}},
   {{0x0007de5619063736,0x000e8b999595b53b,0x0009e5c36858dbad,0x0008422cbb47b2a5,0x000060318b43cf4e}, {0x0001ccd12ba4b7aa,0x000b58c8282abd16,0x000b2130df399daa,0x000d7c7587633aee,0x0000465311b7a38d}},
   {{0x000eec864d3779b8,0x00062d64c1715f75,0x0009144283c5d047,0x000c29074103712a,0x0000096a89210e2f}, {0x000ae9d23b3ebc2e,0x000ac580cfd6d3d2,0x000b01f6c90bdd6d,0x0002db72dbb7f3c5,0x000068eded5c102a}},
   {{0x0005b7799eb6df0e,0x00009386b7791778,0x00017a48e26c3cc5,0x000f30545ed98864,0x0000990b4e4e7d6e}, {0x0006b7e2586abba3,0x000529c96e9a0f45,0x000eb4206239ca6a,0x00090ab327459ce2,0x0000a4c3313d002b}},
   {{0x0004806f6a3f6fbe,0x000ea5c251dd2a11,0x000a784d3ad5cad2,0x0006d4b2c1f613f5,0x0000c7bfad014976}, {0x000cd333e23cb3ba,0x000425a64b2d04b3,0x0005891063979fe8,0x00027e792e27207e,0x000060c43d2415b5}},
   {{0x0009082be7cf3a64,0x00027c9672742dae,0x000a0a8a9cc86ba9,0x0008b3b28a2ce8ae,0x000004ca6d9aee98}, {0x0009c5d005921b83,0x000114e79bf9fd7e,0x00075ddc2f56297f,0x000e877163b4600d,0x00000b23616d1f2b}},
   {{0x0000d21bfe50e2b2,0x0000c1bfede14b07,0x000ac4ae07ef8cfd,0x0000338dba00112a,0x0000a3e7d01d9ebd}, {0x00077ece38d9d1cc,0x000ddc5d2de39952,0x0003ca8c9b500249,0x0003aec912b820f1,0x0000879811547779}},
   {{0x000125dec3f1dec5,0x0000411178da19e6,0x0004a673807b1f04,0x000dcd893ededa90,0x00005187a5a5bebe}, {0x0004722eb329d415,0x000ea170b391f7d0,0x00099f828f449099,0x00076dad317a69ca,0x00000c3db2b84a49}},
   {{0x00077843757b3927,0x000d3a3ca05ae9ba,0x000e593d4326caef,0x000d1308e5293bf1,0x0000842a9377d98f}, {0x000bf965f96b10d1,0x0005f6a8cd05e694,0x000f0c7fc373a9df,0x00072e897d1e51e8,0x0000d01979073fd9}},
   {{0x000d8585499fb325,0x000927a8aeb70064,0x00008eec57b67bad,0x000e1ccd3eb9772d,0x0000fc047a71baba}, {0x000d159e54a64bb8,0x000b443497e40577,0x000e0608d8862201,0x000aac2d6b4e282c,0x0000b687b7d8b167}},
   {{0x000d3678b2ecfa91,0x000d990c3c386ed4,0x000e5c42b24dfe62,0x000a9f91862e103f,0x0000ca73dcae5732}, {0x00038b776bb87ad6,0x000b9242b81f35f0,0x000fd90cd674976a,0x000091ef2bde7eb0,0x0000efc172f07fdf}},
   {{0x000b69b92222f1f5,0x000a1cf7ae703806,0x0005217ee5a2459c,0x0005ac1789f69ca8,0x0000f232b5f33dc8}, {0x0003ec548e9e5167,0x0006c197eb31660e,0x000fcca23124b4e4,0x00024ea0a0cb13aa,0x0000bd63ba4f2132}},
   {{0x000d7cc290a7f4fc,0x000d4286b461affa,0x000a407af6b409c9,0x00007298ab809fff,0x00003122eee868ac}, {0x0009e504ef24d7e7,0x0003ce2a581117bf,0x000902e015d92979,0x000850e19bc86702,0x00006bba5daa9c8a}},
   {{0x000669cda94951ec,0x000ca6b8d418e9f9,0x000d426a44b6af58,0x0000273a32107417,0x000078e66aa5dde6}, {0x000c0834a53b9649,0x00086f6023300516,0x000c5c897fc659d3,0x0005de7ab55e5c58,0x000085099b3138bc}},
   {{0x0009efcc52fc2384,0x00082ac1da3f061d,0x00083fe08712b272,0x0002f7bb65814992,0x0000954ac94f8aaa}, {0x000ada47fb2e74f1,0x000ea89926b085c0,0x000d1af5bee8ba98,0x00015ed4f9d37d23,0x00004ccdbf9ca9b0}},
   {{0x000481b7bfe71786,0x000e05405868b674,0x0008c867d4e1deba,0x0000e9a61b2821c4,0x00009c15b35b13b3}, {0x0001666368710884,0x000cd220b1ff3b4a,0x0003d9f4de5e29f5,0x0006750b82bb3523,0x0000e07633358cdc}},
},
{/* digit=10 [{1,2,3,..,}]*([2^70]*G)  */
   {{0x000f5c7a3e6fced0,0x0005f45fbdeb0d53,0x000339a70e8cbbdd,0x000b81f85c01df13,0x0000ff71880142ce}, {0x0008774bd70437a2,0x00019a0bda6a4c4e,0x0008bd26e5fb3289,0x000521fcdbebd2f1,0x0000f9526f123a9d}},
   {{0x000305192c4d6840,0x00057612efcd40ce,0x0009cae208b04d72,0x00056cb9dcda366f,0x0000edc4d24f0588}, {0x000e6bf854279005,0x00058c09dfea64f2,0x0009bf26c3de8129,0x0005a9841b448737,0x00000b62c6dbdf13}},
   {{0x000e3b4c72dfe67a,0x0005f0e19fdfd4f8,0x00013bd35c416b0f,0x000b9d78b9098d4c,0x0000c11118ab5b8c}, {0x000a318f00628413,0x000f59f356f4f598,0x000177a0cbfe0602,0x0005374ae3637e30,0x0000409774791136}},
   {{0x000fb5ed005832ae,0x000ab1042e4f0db2,0x00070f8ca5f5efd3,0x0009cbac4ffdc6ed,0x00004645d0c952da}, {0x000f58bc9001d1f8,0x000bce1172059596,0x00098a08452c8f0b,0x0009de7d4aa0d2e3,0x000015bfe3a904f4}},
   {{0x000443f23885e5fd,0x000918433aab97e5,0x000d4e604f72f8f9,0x0003feed00b154e4,0x00000b35e6bb5e17}, {0x000a0489164722d3,0x000b58761ec857b2,0x000a838323e3c665,0x000e3b3bdd13973d,0x0000c8b1a1ea3daf}},
   {{0x000ace654317cac3,0x0009221771b34497,0x000dfe8b8be600ab,0x00010f842e409eb0,0x000086a67d769423}, {0x0008d8d4431cc288,0x0002185dc5242554,0x000c4be32a7cff14,0x0006e0cd60f5a193,0x00003ebd5c95071c}},
   {{0x00080a7b1fd2b0bc,0x00059bec33e8ba3a,0x000743fb39b3ad39,0x0002f9f3868d6179,0x0000fd169fdbdb46}, {0x00099d79ce0a6af4,0x0001a42d3ff8d3b4,0x000c3e1b255dc1cf,0x000473c4fb9e6cc6,0x00007e6961daf69a}},
   {{0x0003acce548b37b2,0x000264d4054954eb,0x000341b4fb38e754,0x0007fa6c3daa517b,0x0000f6928ec890bf}, {0x000b32386ce6c413,0x0004e0adadcd0496,0x000b5faf901be1c5,0x000985904e67e74b,0x0000cbaf679115c9}},
   {{0x000214550ca42470,0x000ae7dd30aa8cd1,0x0008fee24ba1aa47,0x0000e82f81ddf1e5,0x00003452936eec9b}, {0x0003b81243aea965,0x000ec5c3d0e58bdc,0x0009483619a2919a,0x000ccf4ea640ec10,0x0000ac86d5bbe0bc}},
   {{0x000d918c36cf4406,0x00076939719cf892,0x000218b64aed3e83,0x0000dd507b08d2c0,0x0000f1bcbbb2e979}, {0x000d6ed60919b8eb,0x0000dac1f9eb4a84,0x000d5daefd890079,0x0002c5484941aa0d,0x000022fe40b17fd6}},
   {{0x0005ba2157f2db33,0x000f5e28ca9c97e1,0x000b9f454bda2fc8,0x00072e2d050da437,0x0000d57eb575379d}, {0x000eba2fb5ee9973,0x0002b11538cae9b5,0x00032797401648ca,0x000bb702bb76f6f6,0x000038f14b92f3f4}},
   {{0x000226ad7ab9a2d8,0x000cfdfae958524d,0x00051d8c29c00090,0x00062c8ba5f53987,0x0000afcbcddbab82}, {0x0002729e99d043b6,0x000b4ebc943a5739,0x000862935ef51263,0x00017b3feace9320,0x000039efc04106c8}},
   {{0x00054b366b4be7ad,0x000db4a37a1e1fe0,0x000d75cd93f25a9d,0x0001b5239ef1ad78,0x00007b58f4a2062c}, {0x000f9a9ff563436b,0x000938af51e76f74,0x000e97fecf718ff2,0x000c09a234d31315,0x00006a8e2b1d92f1}},
   {{0x0003aa8327720c15,0x00026a092cc8a7f5,0x000746c4d956ca32,0x0003923f03d64a28,0x00001fe1782b6d0d}, {0x00034db3c832c80a,0x000bcda2e3b4d19b,0x000104ccc60dccc5,0x0001fc845dd62e0a,0x00007ab1de2020b2}},
   {{0x000ae0b3893d123d,0x0002e15ee71cb293,0x000a9468bf7b7578,0x0007438aa3c61442,0x0000686123dab15d}, {0x0006891a7ab4116f,0x0007b4e6a4598c61,0x000e5fad76fcd72c,0x00046abc21911077,0x0000b6a20e8604fa}},
   {{0x000be7d341d81dcf,0x000842148379e839,0x000026eadcddb688,0x000c5dea6211a1f7,0x00003b25760e4d1c}, {0x000c8f6a7a73ae65,0x000e11d5b48340cf,0x000a50ebc83879a5,0x0008fa75acb1ed41,0x00009a60cc88c07d}},
   {{0x000bdceb18762621,0x000002af4ee91b73,0x0006e1d072b0d79f,0x00052f7bcf3b0bd4,0x00007d6af9df45d1}, {0x00004616d7364517,0x0006e6b0bf5a7352,0x000999b9d43cbbd9,0x00039840833a5bd5,0x000002614f15b72e}},
   {{0x000f01a59c3e9f87,0x00075e6b3d160aad,0x000ddafad40200e7,0x0002e16a22bdd3de,0x00006dedaf4a10d7}, {0x000807c4bc2e88f8,0x0000946dd5a549ef,0x0008d59e96ba8129,0x00034921a4077a7d,0x00007b6a2e8002db}},
   {{0x00099971b4e598eb,0x000e56fe4b1dd567,0x000b267c5f499ef1,0x0006cf8978d3aefc,0x0000582b557d3578}, {0x000b2ca1715cb07e,0x0001a480241d32b3,0x000571ecd4c3de6a,0x0009a883b5ffedcb,0x0000af53901cd2fe}},
   {{0x0008d4ac3b819900,0x00029e0cc8fedec9,0x000b427b91cb8372,0x00066cfe0b0491d2,0x0000f2386ace983a}, {0x0004d1eb32912137,0x000de9a62ae4930c,0x0003e89e3a2f82b2,0x000c7f07233853f9,0x0000f8063ac81777}},
   {{0x000b56759ad2877c,0x0001d865c754ff0e,0x0006e9a846f45464,0x000fc326fe701a23,0x0000586ef16c6e40}, {0x000b6e024bafad93,0x000234da906a3f62,0x0003276a0c8b42bd,0x000852998e1eb4da,0x00000d0e5fc36cbf}},
   {{0x0002ae1e8b4dfd4f,0x00069301cbac1b6b,0x0002a39acd754d5c,0x000ab87609762911,0x000086b599a83ba4}, {0x000dea799f9d5812,0x0008a2fafeaa26c9,0x0002505a50473b1a,0x000322f469af553b,0x000027d16d7f6a43}},
   {{0x000f73cad3d97f9a,0x00047f1374553316,0x000954e7c52bf3bb,0x000410f53eafeb09,0x0000721dfee7d732}, {0x0009821141d4579b,0x000bfa3bd435b492,0x000fa60153411321,0x000f0dffb355aa17,0x00004e7ef4ac8e42}},
   {{0x000c97c593710000,0x00007f759c18604a,0x000db6b65e1c48c7,0x0004953f62ecc5a5,0x0000a78b17338a21}, {0x000819dbcc8ad945,0x0006889c34006be1,0x000b4840a70dc04f,0x0001bff62557b4a6,0x000044c6adeb0bd2}},
   {{0x000f24e907a544b9,0x000aa13da2106a00,0x000e4994ba7520dc,0x000d706e939b7511,0x000018b6ba74c275}, {0x000e0fc644be8924,0x0006bdaf6c42d3e5,0x0005c13fe707a981,0x00054a20145567f1,0x0000818ebab2130a}},
   {{0x000d3ad58d2f767a,0x000d37e7c77328aa,0x000afcc98dc5267f,0x000d4aa919cc88c3,0x0000a2e6ab0cdb8c}, {0x000ec04d0c63eaaf,0x000429ffa832d46f,0x0003a631fa1cb92c,0x0008b2778dd178e4,0x0000b5ae1ce2dc78}},
   {{0x000fb906e77de048,0x0000706dbb9768b4,0x00017c01d7992bcf,0x000e01096e6a13c4,0x0000d96332d3956b}, {0x000c93a413aa2b94,0x0005bc98c8a5902f,0x0005f113799a4d91,0x00028112c2940756,0x0000072690f61e4f}},
   {{0x00007cf02ff6072b,0x0008dad98cdc36e6,0x000f56609a47d2ca,0x000da00f471d1ef5,0x0000cf86624a264a}, {0x0000687aa9e5cb6d,0x000147401c6cb70c,0x000a61435c98124f,0x000ea5b189635fd4,0x000028fb8b079d98}},
   {{0x0007c2a40c251f81,0x000792da44beb9a6,0x0009b542388cd5d8,0x000dc1337deb96e0,0x000050467db74287}, {0x000debbcdabb8397,0x000281839a3ee161,0x0002d202ba79e974,0x000d964b8dd3c265,0x0000b3e67f859f97}},
   {{0x000d78fb1cb6ac9d,0x000dfa1d0d455aa5,0x000a5bf95ffa13e8,0x00005d669295dd2b,0x000068bd1f909aff}, {0x00086f926d783f2c,0x00033c3aafc1af0d,0x0007da97c543a59b,0x000e457fcf81d27b,0x0000990a057925de}},
   {{0x00075b8519cce2c4,0x000f6e13d8633e67,0x000c1605cfc9af71,0x0005e8374a4a6f47,0x00006ba42456fd20}, {0x000eea4d3fd524d4,0x00012de1acc2a06f,0x0004e2b421e72464,0x000024b53816f133,0x00009e5918ed22f0}},
   {{0x00030b665c7322db,0x000103c1b3fb4395,0x00072f685cf12cc0,0x00091d170b018601,0x0000915ee22cb583}, {0x000f03ba317db248,0x000897b8ffc49afd,0x000d3d05087dec65,0x0000e6ff46597be4,0x00000a1c1ed80650}},
   {{0x0002a9678bf030ed,0x0009805601488490,0x000362426fb5e9c9,0x000c3f9dae0a9263,0x0000caeecf579e30}, {0x00087bb518d0c6b1,0x0002bb985b9dc0d8,0x0007bc3819918115,0x0002019d186898ef,0x00008168ffbaee46}},
   {{0x000cdaa2502753c1,0x000641407c419a04,0x0003564e5bb279e2,0x000016dacb03aaf2,0x0000833658281e61}, {0x000b8c4eb8098772,0x000dca0e672e8684,0x000ee5867b336e18,0x000fd1cfb601f034,0x0000733edbe3341c}},
   {{0x000809a26025c3c4,0x00065350df88b15e,0x00002fd8ee6e981a,0x000e9b5237623785,0x0000791f2164c12b}, {0x000678925f02425c,0x0003ba974443b725,0x00041cc52ec86319,0x0007f1bc0ce882fb,0x0000266ff7fb25c0}},
   {{0x000a8c3017025f39,0x000c6b9579b43d4d,0x0003716ecefcf628,0x00016dcc4d00161f,0x0000c27ebc4f8011}, {0x0000ea11da1767e7,0x0001d7004c575eba,0x0002373b7fe15145,0x0007abcace6df68c,0x00005c3dffecdbc3}},
   {{0x0002a73ddc925fcd,0x00005f65ee0b3dc3,0x0001cbfebb679c84,0x000a28a15a329545,0x00009889769c76e9}, {0x000ce7fb28ad2470,0x000400894d79ec20,0x0005e3ea7e99146c,0x00003171457d7c9f,0x000097b266238030}},
   {{0x0006ae6cf9f82a81,0x0009338f473adb7f,0x0003856c3319decb,0x00061b963ab38628,0x00003e3172fc06a3}, {0x000f8dc7d5a006c0,0x000675fba7522959,0x000c22c9e2dbc27c,0x0008b2c1227ab287,0x00006f61f7571a26}},
   {{0x000b97104779ce2a,0x00016aadcb1d1b6b,0x000aab2d5aca8381,0x000f12897ae0bcae,0x00005c14ee7fbfb9}, {0x000c583f17a62c70,0x000c173759f6aa00,0x000c9a88f39eb962,0x000c5e1eeba1d486,0x0000ab6c37adf016}},
   {{0x00047dba28a0749b,0x00063e519165a2a1,0x000810715246c20d,0x0000b8a068d1b1d3,0x00001e7018d24816}, {0x000b1faf380ff628,0x000d73cb2c1e03f5,0x00091a7daef7fb1d,0x0005616ab539a8fc,0x00003ddb70873f9b}},
   {{0x000e211fe7df7a4b,0x0001563f6f40c550,0x00076879ca7cd07f,0x0001da00de363529,0x00005f83f8695574}, {0x000d25ef3d8ac3d1,0x000f52819f024ea9,0x000f4a5646fe2066,0x000de33ab2b9c2ce,0x0000e155d966ffa2}},
   {{0x000a19bc3a72d004,0x000b4513c31b0eb0,0x000c646374037665,0x000638efb2b6bf04,0x00005c34d6e48cdc}, {0x000e10ff01fd7967,0x00018e3667b856f1,0x00021d0c04dfb810,0x0006ab70eda25390,0x0000a94e9fffa06c}},
   {{0x000b0d9bb9aa8822,0x0005cc05fd102d3b,0x0001ca64eea20e4e,0x000cbdcd7eeb5f1a,0x0000fa6b43ce6327}, {0x000e3cf3aa91121f,0x00094a34079bb577,0x000e02fc08c6bd5e,0x000bf7e7e5ba3960,0x000016dd2c480141}},
   {{0x00076d980101b980,0x000db82f0f66b572,0x000c3eff3760883f,0x000b4089d7de754b,0x00003b606435dc2a}, {0x00053dfe05beeac9,0x00022c3325cdcd6e,0x0004f03c3f2f1e86,0x000c1b4d0f792177,0x00007ca7221d552c}},
   {{0x0006afe1cd19f723,0x000cc183fbeb5a0d,0x0002c403ca20915d,0x0004426fda4b4083,0x00002738eddee425}, {0x0001df6b5eccf1aa,0x000188bbe1f0469a,0x0000dfc934b5aff4,0x00062791359d7f57,0x000018be23690088}},
   {{0x0000fbab00ed3a95,0x000423cdf8bea5b3,0x000c5679734c6137,0x000ae1dc5c5f46ab,0x0000cecf93e082a8}, {0x000be41a968fbf0c,0x00025a5c7f3d7d3d,0x00087a9c7d23d458,0x0001ca328f69a0c0,0x00002d7547207447}},
   {{0x0009f4a4eb732ec8,0x000d31ca6bed36ec,0x0004578926c943bb,0x000c06564535e1f2,0x0000b84a8eb77e2a}, {0x0006cd32499dd5f3,0x000dded04e57e093,0x000305d9d12053d7,0x0000a21bdd0076e4,0x00004a527b94f67f}},
   {{0x0004af09cec46eaa,0x0000c58b9bc7e79a,0x000af2f75b15347a,0x000434cbd2796f35,0x0000c957990e051c}, {0x000dda3c33a655d3,0x000e58514aa32669,0x00053dd415d503c2,0x000f78afa1133737,0x0000f0546733b754}},
   {{0x0005677496125bd4,0x0007f775006cbf18,0x000037899fb0023c,0x000a57ba0f072f3a,0x0000222b6eb4e4ae}, {0x0005e767866d25a6,0x0007e837aa6f3dde,0x000f1cdb8b6eb04f,0x00083bf315591a2c,0x0000dfb4f418d4e6}},
   {{0x0003ea448ee1f3a5,0x0006b5a2afd57e92,0x000ea49489604d9f,0x000d2f6e1d4a3340,0x0000b45f1f5044cb}, {0x00083764acc757ed,0x000793d68ff75faf,0x0000e404ba7cf9ab,0x000fdebad62f69df,0x000065f33c2e2bda}},
   {{0x000de15a377b14ed,0x000abe39f60cc365,0x000e681486bf5463,0x0003a792030d2d2c,0x000095867f0b6f84}, {0x0000244ef5ab0172,0x00012ab55d12d39a,0x0006391690bd2d8c,0x000c8aa9503db341,0x0000d4e25b117660}},
   {{0x000b3b5e224c5d71,0x000c58616919760c,0x000142552fa3baf8,0x000bf58fbca1138d,0x0000ab18bf18669e}, {0x000f53e9bdf25ddf,0x0002db6cd15455e6,0x000e8908004cc0bf,0x000ac0695bef4995,0x0000e9459a9004a9}},
   {{0x00089cacce9bb324,0x0001b7de8285ad2d,0x00051bd4bddea65e,0x0009a722ed8c35b3,0x0000150ff364c0e1}, {0x000c801345f4e475,0x0000d03a266c86e3,0x0005b1f133bf21f7,0x0005172ae110d485,0x0000d6aaf6a57262}},
   {{0x00012e1813d28f11,0x000d6ad7a5231e0f,0x00044a17b6000e11,0x000a00b7d8deefc7,0x0000e990b4824c05}, {0x000daee93e976d58,0x0000c6610d6368fd,0x0003dda88696241d,0x0009463204e7c389,0x0000bccfa65ea3a6}},
   {{0x00025b4c5cd14112,0x0002df3658b1b594,0x00084cf93701b404,0x000d60c3e56bca47,0x00007de5f15afe68}, {0x000cfcef8d53f19f,0x0000b40a730d4ab9,0x000ee0a8addb1031,0x00019c7fa73cd14e,0x0000d54874942497}},
   {{0x0006316a8123ef0f,0x0003f7f9543849d6,0x0009e785473c32db,0x0005063e2ed2090d,0x000098a932a8d9f0}, {0x0003cf60c6aa20a6,0x000415279bb2c5d3,0x0004a73079a32ba1,0x000dbd1e3202cb77,0x00004ed4bc548c42}},
   {{0x0001a06d4caed0d9,0x0006871d22b3c20f,0x0003268d7b802140,0x0001264426ca04d1,0x00002377007b5f4d}, {0x000cbc371f21a855,0x000aa82369ba4204,0x000c858f918461b7,0x00056970c07d313f,0x0000deb5a5132bab}},
   {{0x0009d46d5eea89e7,0x000398437f4bd595,0x000fe254ffdff842,0x000321821071e43c,0x0000241769705468}, {0x00088b9102cae3e6,0x000d91965dff5d82,0x00078d8472d143e3,0x000730a0c9a376a0,0x0000fc0da3186028}},
   {{0x000eadfe45083a2c,0x00079e5b4bcda2ba,0x0004b8e7f66bc721,0x00086a6c826442d0,0x000019f54522c4b5}, {0x0002c495b7eeed57,0x000d0aa9dfa16018,0x0003884add9954ec,0x0000413403a8ecc7,0x0000fb17de30bb39}},
   {{0x00064c5abb020e8c,0x000359c4eec7694b,0x0004793e53d18c18,0x0002e5dc4673ef1c,0x00007b8aeb5c5609}, {0x000ca43f0f8c16bb,0x000c2679b2f63aa1,0x000a205c9224ed5e,0x00028a5d56eeaf55,0x0000fe115bafb8e0}},
   {{0x00008493927f4fec,0x0003b59aa7c597e6,0x000e90a51f91fbf9,0x000822d85af7696b,0x00001277b7938ccb}, {0x000656ee7a759524,0x0000528da5f5395b,0x000a4454f00df7de,0x0003c0c9c231754c,0x0000ec971f4baa2d}},
   {{0x000c507e75d9ccc5,0x0009edc9030645c3,0x000b44bdc63b7be8,0x0006a1e7e09c665d,0x00000d60da1b841c}, {0x00065ee08df1b120,0x00097ff089df6f9b,0x000e8013d3873487,0x000cc89c331a663f,0x000017f5de95f42f}},
   {{0x0007866e8e575672,0x000ed9fcdb184307,0x00012e174c9f781c,0x00052a18131dda9b,0x00005d84aa3aa037}, {0x0009e094d0c0ce2b,0x000ae2bebba545e0,0x0007284c71564008,0x000baa47e8ad31a8,0x00007c4b46d47e7b}},
   {{0x000a7b397acf4ec2,0x00003ea8b6403e22,0x0009692850426c40,0x0006703e3295a64e,0x00002aabc59c6a45}, {0x000714c5f5942bc4,0x000dba3182edb929,0x0004152ba9a6168b,0x000367e216a66510,0x00006908d03f6926}},
},
{/* digit=11 [{1,2,3,..,}]*([2^77]*G)  */
   {{0x000d8745a1251fb6,0x0008672725c7a9f5,0x000ffe89e967747a,0x00035db95c33e531,0x000009d211049649}, {0x0006ca82fe122271,0x0005f426469dcafd,0x00093183caf9b5b9,0x000fef1e9ee04c56,0x0000084a333d8146}},
   {{0x0009933aed1d1f71,0x0003405630909664,0x0002e39cf566eaff,0x000124245057f0ad,0x000048ff65b2f832}, {0x00089d4cf94cf0dc,0x0003920c58b3042e,0x00061aa0d319bec8,0x0007ac6a26762653,0x000086fa3034fbc8}},
   {{0x000d2ab5c8b06d5c,0x00023e4eac46fc83,0x0006f7779b1a785a,0x000504f99315bc84,0x0000f31d817af9ea}, {0x000fe6a15d7dc85d,0x0003e4016b332391,0x0001cb4c72f132b0,0x0005a059547fe318,0x0000b66d8a735015}},
   {{0x000d7e1adc1696fc,0x00024acd72d06b66,0x0001b743598ebe59,0x0005eba5f24550cc,0x0000e23139474b9a}, {0x00022d4db067df91,0x0005baff9b00234a,0x00000c9c198dda09,0x0006950bbc75a061,0x0000560a9c8a39cf}},
   {{0x0006d3e99e0925f5,0x00061322375acf00,0x0006af5ba2dd74a9,0x0004f1758b446ab5,0x0000029268430b9b}, {0x0004cb41aeaffa32,0x000f7b9587c1e2c3,0x000d1350c8b17203,0x0006044d559207ea,0x0000b66a2161b7f9}},
   {{0x000325efe51bf748,0x000dde4600940850,0x000da2f259c4f579,0x000f32dc87b92a76,0x000089de4e0efebe}, {0x000ec06646083ce7,0x00054fe127736900,0x000344110be2a033,0x000d203dd1da35c5,0x000057568b82802c}},
   {{0x000977900f7e6c85,0x000ebfacd2f07555,0x000fde37538e8b94,0x000dfcaea1f3af03,0x0000e11a1d8c5881}, {0x000b02ec1e2f2ef2,0x000ba605a6c5b3a6,0x0009a0b2d193d2bb,0x000846125ffeee33,0x00007b6a724be0c8}},
   {{0x0000f1cf1c367cab,0x000b190fbc7de405,0x000a110329bc85a9,0x0003a8f373c4a2e1,0x000064232b85d039}, {0x0007eb0167dad297,0x000124b78ab2f557,0x00029348b1604f30,0x0003419baa94afe8,0x00007fbd8ddb1654}},
   {{0x0000ea5b964e39a7,0x000c60d3c76edab5,0x000d11964d4c29e3,0x000c2f10dae67c56,0x0000307a8c055ffc}, {0x000c1aa91708c3b5,0x000bd8bf0eeb65bb,0x000a34db7a151e62,0x0003a81cb533816f,0x0000139e05cf2940}},
   {{0x00051b494a7cd2e1,0x0000f699336c6ff6,0x0009a896a5671ffd,0x000cef5f5fd2cc97,0x00001e893a8e8148}, {0x00006a165cf7b104,0x0008850d84859889,0x00035b3de81b6717,0x0007993c0deb358a,0x000023ac85601d29}},
   {{0x0000d87dac50b74b,0x000ea869734caf58,0x0004e28fb28b2b89,0x000739e9a3b93687,0x0000b2c9190d5f3f}, {0x000691884a9d5b7c,0x0004be770374199f,0x00038efe27ebe232,0x0002d23442e10707,0x0000f9f3f578f908}},
   {{0x00069e1096187086,0x00046183f9b1719f,0x0006a21afcc9e836,0x00041f8c203a9536,0x0000aec5d6d668b1}, {0x000f78a994f04e95,0x0007d71245b0ee2d,0x000e43f4fb39ccae,0x000a986875a4a997,0x000007dfe122b2ce}},
   {{0x00081cb489b03e9c,0x000aaec414fa4fbf,0x0001b3ae5db86ec5,0x0003fe3ad444f9f5,0x0000a7d33d6d914e}, {0x0002f5c0ae6c4d0e,0x000d93969568a9c3,0x000a7467ea9ca1d1,0x000ac5b8043c311a,0x0000832e75dc21b5}},
   {{0x0007aea5232123db,0x000bb5ae86db314b,0x0004668ed08307c8,0x000c3856e7165caa,0x0000170458c64d3e}, {0x0003ec6c19bb9866,0x00064e0304ed4d2e,0x0009f9722c5f3484,0x000c0a317695a06c,0x0000c7f7317acab1}},
   {{0x000940e9d6d2e8b4,0x0001149f7c976295,0x000713885d318b8c,0x0000fde245320497,0x000068d834be8a44}, {0x000e5b2bfba796e0,0x000b6d71f116d81f,0x000b66e53152364d,0x000192bb8c7c59b5,0x0000b12c61b2641a}},
   {{0x0004802fcf0a7fd8,0x0008d488b01e31f1,0x00052b49842fd078,0x000200f1d78d6d99,0x0000eb572d987ac5}, {0x000a44c4d194a88b,0x00090a017e66e0a2,0x00088aefcd2b63fd,0x000a10c8efc6c8f8,0x000076f6bdafa881}},
   {{0x000314bb46c2397b,0x0005aded2819187f,0x000764d34004cf56,0x000708f9ea570438,0x0000ba4521828084}, {0x00045711171121e1,0x0001d7c9b6710647,0x0000f7507ad7b7eb,0x000bd1cacfbc4073,0x000078cd8c6d7ad7}},
   {{0x000e101b2a672385,0x00075f9c14f2bf0b,0x0006620753556d36,0x000609c04b7831a5,0x00008ca59bbc9d9e}, {0x0005392a569a73b1,0x00084698f6c94bc4,0x000add755517a52e,0x000b8475643da5ae,0x0000aed0cd53a581}},
   {{0x000ff8480af13722,0x0003d1ba5d1fb9b4,0x000f98d31244c311,0x000c2a0a5dacbef5,0x0000c3323e86375b}, {0x000ab4a5594b1dd8,0x000b4eb4797e17a3,0x000886a19a1928bf,0x00074a683af245e4,0x0000979d546f2b5a}},
   {{0x00026bc19f9e9676,0x000288fbbf4ea0f7,0x000707d40d9d0315,0x0006e06fd6f51db7,0x000033084d9c3f6e}, {0x0009cdc55667eaf7,0x000abe44d56fedcd,0x000962b1473b7f92,0x000cbf8b2e39b64e,0x0000d408f6f6671f}},
   {{0x0004ddc164a89bb6,0x0001def3bd05cc63,0x0008decbb74a42bb,0x000595b280dbb242,0x0000103f6bba02c8}, {0x000f581355a5752f,0x000710946674fa2b,0x000a0223b562f96a,0x000a245e4ca16d6d,0x0000e4781a018d3a}},
   {{0x0003075f8dfcf8a2,0x000a756698259eea,0x0007d3fd8a284f0a,0x00091e93fca25086,0x00000757b5f469d6}, {0x000402093b8a5ded,0x00091bc06da6f2c2,0x000739c33d3f9335,0x0006e44178293eb2,0x00002a3e7718cd68}},
   {{0x00049f4cd941534e,0x000b03c71c0ea76f,0x00097f7e30d37406,0x0000dd372d93973b,0x0000c17e23a9d7fd}, {0x00005516f496ba27,0x0001c6ad50e7e329,0x000e7eff56a69317,0x0004cf54e539a283,0x000052737e788e1b}},
   {{0x000932c68af43eec,0x000db03d00bda2f7,0x000b061f55502468,0x0005ad25dc978f2f,0x00009a1904ae8c81}, {0x000538d470c56a4f,0x000e293d8cedd3af,0x000108ef3159abc5,0x0001773a37245f20,0x0000a17081f123f7}},
   {{0x000fb2b10c8c0f59,0x0009b065054727b0,0x000c3bfa72102c3e,0x000d95c94564df8a,0x00008102033e09da}, {0x000643ff1d18a13b,0x000127fc5af06989,0x000eaafd835eebd9,0x000e97578d096afa,0x00007a893428ef3d}},
   {{0x0006e8decf2a73a0,0x00078e5519942a20,0x0008d53a2066a639,0x0004aa3a6a088ab9,0x0000ce7c67c2d112}, {0x000c671759a113ce,0x00026f6f67fa48ce,0x00036727be3b373d,0x000d807455d479fd,0x00005a428ef813c0}},
   {{0x000dbc81c86682bd,0x0006e8d02b2ab853,0x000bc329ab78d272,0x000147daf69bed8e,0x0000b6b40b3f93b2}, {0x000a77db8c4961f6,0x000bc0e5e0abe42e,0x000e8b05eb1a12f7,0x000a8040ec527479,0x000080273925ab60}},
   {{0x000ea5f16b1bd5e5,0x000ffde30ad36bfe,0x000353b9ef957e41,0x000feb7baf664e6a,0x0000c87331276d14}, {0x000f98cb65f57cb1,0x00014e0cdd414e87,0x000881440db60a62,0x0002aa57c16865a6,0x0000093ef1a56ab5}},
   {{0x000afb53f4ece64e,0x000d9604551ac095,0x00026b8cd6a6bb02,0x00068975d44b4e0b,0x00005f9a99ad9712}, {0x000c42511a7de841,0x0005eda469ddc08e,0x0006c90a28356809,0x000831637bfba16c,0x0000cb9c4a0ce229}},
   {{0x000cbbabb2eec644,0x00049a03adbe93bc,0x000e86ac4a0c23b6,0x0001e61f7aa00ae0,0x000070b941f3c140}, {0x000d6799df435742,0x0008ef65d8105ad8,0x0007fbd814ccfb8a,0x000209fbce80e3aa,0x000073291adb508d}},
   {{0x000b46b42a92806b,0x000bf86ab44af5c4,0x0000bc9f8810684e,0x0000539591640bca,0x00005efcdfd0c4b6}, {0x00089076e9edd128,0x000054d792f916fc,0x00003116de29d0b5,0x0005a4245fd01c9b,0x0000503523648176}},
   {{0x000a9b2b4b4b67c8,0x0000680206041fe2,0x0008058d8c1d10df,0x000fbb1d64abfcbc,0x0000943b9b2f12a0}, {0x000d9143b3def048,0x0001cce775ff90ee,0x000bc904085ab3aa,0x000dfae05fd4ca7b,0x0000b34a56562c75}},
   {{0x000c94a10358560e,0x0001be5c28aa41ff,0x000c7eb152d8a507,0x000f5d0915a0fc4c,0x00009efab066f6d0}, {0x00047a9d19e9b915,0x0004b276154cdbab,0x000fede0d8cfed74,0x0004eec54357ae2c,0x000020630df69f5a}},
   {{0x0009f7ce382360f1,0x000978bf58572575,0x00058d46cb6db05c,0x000b7a1917d61d6c,0x00004f8e4920d20c}, {0x000727a11c203407,0x000f3f7ccbb6b68a,0x000e09a200386f86,0x000a34ec8bc6ccfe,0x0000d76ff4b2b7ee}},
   {{0x000ebe7db15be7ac,0x0004189f0302a7bd,0x00019336467a0805,0x000ebd96bf0ea9c1,0x0000824446822837}, {0x0008e8b20d841b88,0x00085bb8a54f32bd,0x000b20236127a054,0x0001fa03dd4ca663,0x00007714718a0349}},
   {{0x000caaaaa8a5288b,0x0009ff23a1c94dab,0x000220e0c91cc0c8,0x00044984c72c6a3f,0x0000cc20bdfc2321}, {0x00042daa20ede1b5,0x000c24a005156e2f,0x0004b8c4bc441f00,0x0009a46f46a5b673,0x00007409503cb56c}},
   {{0x0005261e4585d453,0x000d3734e6429f73,0x00070ee6c9231fae,0x0001bee158a176be,0x00005f1068dac350}, {0x000f900a2d261155,0x00029f0afee36bee,0x0002420a1649406f,0x0004abef43a60abc,0x000009002a825aee}},
   {{0x00036a53ff3571bf,0x0007937927c1b468,0x00033c71624f98b7,0x0001957254256a45,0x000027abb0cc07ee}, {0x00064fc5c6d5bfd7,0x000180cd7a77d7cf,0x00098f5346915c75,0x000b5f69f5901287,0x000072b0da9681d8}},
   {{0x000260c2e03fa69a,0x00099be1a3741244,0x00006b96036cf0e3,0x0000f5ce7c1633ef,0x000071a4c56071f9}, {0x000125133c673db2,0x000053e8c1317a94,0x000f6c734c0bea51,0x00000141a8a699d4,0x00005e78c88541ed}},
   {{0x000acf88e2f7d902,0x000757be32cd5c18,0x000eb5ee9fdbf33d,0x000114ea085cd7d2,0x0000d702cfbd3201}, {0x000ebdb85c88ce89,0x000b8e01d617b6e0,0x0007333ac23a3ce3,0x000b6aa041618e56,0x0000dd0fd8fa57ed}},
   {{0x0004702b57872b88,0x000ee57d5fe127f7,0x000cf3d402ef26b4,0x00067a15426f0a57,0x000047e2ad1e5a60}, {0x000d9a009996a74c,0x000c6a26115cd474,0x0006f4d4316a56ac,0x0005b642a615c3d1,0x0000c3fc9666adb8}},
   {{0x000da73ce07d1b0c,0x000198ad4178386b,0x0002617f4d82910c,0x00076f524f82cfcd,0x0000c2f5e8eaf691}, {0x0002550b8c30ccc0,0x000a1a8e575a8270,0x000ab94597b856ae,0x00038ebb822fefb1,0x000085928bcec24e}},
   {{0x00002ecba8f4b4d6,0x0009a0b4d58b5d04,0x000227e7ac07cd4b,0x00086efd8dffd529,0x00001d44d0c91bf3}, {0x000dc2b135e6f4d6,0x000b879410efe486,0x0000088b5680962e,0x000686461bd343f1,0x0000aa7607742e28}},
   {{0x0003d118fb98871c,0x0002fbc76aff8046,0x000e03614cb26f5c,0x000dee14ab8eddfb,0x00008eb579c80cf2}, {0x0004c15c93bae41a,0x000c9aeca3b2cc00,0x0001e9ab146fbae5,0x0005c0c71235cf0f,0x0000dfba9353ec28}},
   {{0x000d013f216c980b,0x0008479e0bc188de,0x00097a237c8ac4fb,0x0008e6f29b89c6fb,0x0000697b7814922d}, {0x000c639ddb945b56,0x00078094c3a93142,0x000266c90447b06c,0x0000466dcb364272,0x000033aad0909385}},
   {{0x000936bb57c64779,0x0004594dbcc6a36c,0x00091a67b871f8b6,0x0006f498d0fb62a5,0x0000d40e08251d92}, {0x000eaf6f2d84b5af,0x0008b565b6443111,0x00083188b228993f,0x0001961ccbf5922c,0x000087b30ac2df3e}},
   {{0x0008b317642bca8e,0x000e72800f17b865,0x000bf94451a032d7,0x000252251dcae579,0x0000ba6b8ef34a2e}, {0x0009cadd44856928,0x000e0986e9be5c8b,0x0000db44884bda40,0x000188516d16a42f,0x0000ec80051214d4}},
   {{0x000610798fa7aaac,0x00043073aa4eb2b2,0x000d6b19b41209ee,0x000caf31570359f2,0x0000be6868dbc577}, {0x0004bdc32c04dd3e,0x000defeee397186c,0x00086c0cfa6c35fa,0x000fe1d4a1b312f0,0x00000a5ccc7b9461}},
   {{0x00078aa1536189f8,0x000f3a6df571c322,0x00094560e1126c55,0x0006e08f71a602b1,0x0000b2d7405b24bd}, {0x000939e3738be712,0x0009fa4d97a98481,0x0005ba915b5090b1,0x0008a9f16c65a3f0,0x00001863ad3cae44}},
   {{0x0002679a7aae5d37,0x000c9de5c1c4d24e,0x00005b6297076013,0x000fbabd50f8babb,0x00003c1abe2de66e}, {0x000b422f2488af76,0x0002063ba575efd4,0x000a69457e4105d0,0x00073b1eb60a8b53,0x0000221000929459}},
   {{0x000547877a50ec69,0x00067a37a72cfb25,0x000e18e7abf0392f,0x0000af10a7a19c4b,0x00000d8ea16b5b1e}, {0x000a293ef953f575,0x00056dc5465a7582,0x00051071790a64d0,0x00041f7a79c497e2,0x000060dbb7c68cb6}},
   {{0x00032864b66abfb6,0x0004f90309001d8e,0x00084941ad26f52e,0x000957bee3f64355,0x0000d3b3730b69f5}, {0x000a62f4789dba54,0x000532b5c9b79ff2,0x0008f9a0e91fcb81,0x000cb5b446cb7d6c,0x00008f625c179b7e}},
   {{0x000e8011c6219b80,0x000928ac2f23baba,0x000e20588e7a562d,0x000051e1b4873226,0x00006ee1cad775af}, {0x000ae43faff79f72,0x0002452ee9e0da29,0x0005f4bd0c141a41,0x0004f7fe127f6f19,0x00009c6ab4f272f3}},
   {{0x000147730448112c,0x000124a386567b7c,0x00031501082b51af,0x000cd36bf2028a2f,0x00009a4a0202ea88}, {0x00095d8257e5818e,0x000fd4519b16f63e,0x000a910bfdd8efa0,0x0004a90d8973e00d,0x0000d49d0783c0fe}},
   {{0x000ac5eb7caee1e4,0x000d67f4da57ac3a,0x0006669b91033898,0x000aa002145c0e5c,0x00002daa68901aa2}, {0x000c15c1a1d885a8,0x000074b76817629c,0x0008f8f2825572ec,0x0004900312e4359c,0x0000107f8ce01965}},
   {{0x000f3a36fa6110cc,0x00013b93561f516f,0x00057522b74fb1eb,0x000dc5ac0c904784,0x0000fd321052bb8b}, {0x00084a2cc80ad571,0x000576a9b6372d68,0x000f4e8cd7c27fc3,0x0002f02461baedad,0x0000d56251a71724}},
   {{0x000d209c955bef4d,0x000136adb0470b80,0x000c74feedf02cad,0x000a4420d7cb915e,0x00002503375e111b}, {0x000755edf53cb366,0x0001d368551b9671,0x000a025a454dcb61,0x00044506d69aacc8,0x0000be946c7477ef}},
   {{0x00046d1a995e0941,0x0006d51e04d87199,0x0001e311365e848f,0x000503d62f33006a,0x0000541c7c1601de}, {0x000c9faf4acfade6,0x0006e4cd0b714daa,0x00051cd770e58589,0x00016cf44fd8690a,0x00000fc20ed60310}},
   {{0x00004eca42768678,0x000bb4f3499358b4,0x00036e5bd46f6c3c,0x000b46c77ca007c6,0x0000018f5e5fc458}, {0x0002270e47b668f5,0x000d9e14f203a120,0x000ff9b4dcef48cc,0x000ddcd3f98bae62,0x00005acc0361589e}},
   {{0x00012af64db44442,0x00049ecdd4803fe7,0x00030978a19e9d63,0x000733c08bc047a9,0x0000dbf24ecc1280}, {0x000e38c2cd706b27,0x000ac59017b93c0a,0x000e0f5ae5b012a5,0x000fa2c943c38c72,0x000086167eac7176}},
   {{0x000897d594881dc3,0x00089fb820c1e5f9,0x0005018de6b5efad,0x0006ce82179093d5,0x00009ad7d323bac5}, {0x00022e02cfc0e816,0x000196d89daab551,0x00064fa09117c466,0x000ddcd62d01e1cb,0x0000a309b4e9e9c4}},
   {{0x0009fb7abea49b1e,0x000c30e2c6c5fa97,0x000afde7ab4b1d27,0x000357dd61c2c423,0x0000b6614f97786d}, {0x000816b7f6f7459c,0x000e49360e7b4a5d,0x00009914ce431a44,0x0003d7cc27a032c3,0x0000ea5d68b8aede}},
   {{0x000f6653a0a3f957,0x00060ceba27b3668,0x000728fe98936941,0x00056219981fade4,0x0000102c8a0fa093}, {0x000310e235d21c8d,0x0000eefb7f7bbb80,0x000958a67505e55d,0x000feed0a9081112,0x000067e106b1d851}},
   {{0x00011a9431dd80e8,0x0009f3306cd9b840,0x000b3b730eb7c7cc,0x0003d2a0fadd29d1,0x00003858b5c7e37b}, {0x000d193b6251d5c7,0x0002a352d952bf4c,0x000fbc0511cca1fd,0x000636566157a490,0x0000990a638f9b98}},
},
{/* digit=12 [{1,2,3,..,}]*([2^84]*G)  */
   {{0x000692a87dec0e16,0x000d97b39d00e5aa,0x000cfa0b5010ded8,0x000a281b1b80c854,0x00006beb87700f8e}, {0x000f5313476cd0e8,0x0005308d394950d7,0x000479fc6a63d0e6,0x0007419a09eea953,0x00002ae98927499e}},
   {{0x000b9105ca7d8669,0x0001aadb3b34ab58,0x000eac0bc582967e,0x000af4f9ae4447cc,0x000019c667d0bf56}, {0x00017b160f5dcd7b,0x000f2dcaadbc9aec,0x0003467f5ec697b9,0x00032e5b98f34146,0x0000187f1f859671}},
   {{0x0007a1d214aeb181,0x000c641432f790fe,0x00091a0c41506af3,0x000bc3ab5565f9e5,0x00000d41a77c44f1}, {0x00065e4a84bde96b,0x0008420a6a1ca09d,0x0007f9ce742f060d,0x00039eb52a3bfdf2,0x00006bdb65ceb3d7}},
   {{0x000dcb6ec7fae9f1,0x0004dfb66e5aeb5d,0x000445d52995f271,0x000620cee95d8e69,0x0000b6c2d4619e27}, {0x0001c318129d7161,0x0000f958c1aa3262,0x000f4af63b03909f,0x000df67c468ef91a,0x000062c42a00ba5c}},
   {{0x0002343753b9371c,0x00099f1f9cd72f68,0x00045db9629cab45,0x000998971623abb2,0x0000507db09ffd79}, {0x000f652af036c326,0x0007a5018e5c4e2e,0x0008be35086f0cc7,0x000327610a73d4ab,0x0000519b397de826}},
   {{0x0005eef9c053df72,0x00079300ea6fe8cb,0x00049cffb8de25b3,0x0009bbbb03fa92c8,0x000042e43a808416}, {0x00051f4dd6f958ec,0x000f34445a8de4fa,0x0000d89496925a77,0x00039026e72a50e9,0x000066648e3eb1f6}},
   {{0x0001957173e460c5,0x0004e0704590b2ab,0x0001c71621bbbce7,0x00065d70a90dbddb,0x000005e399e65cdd}, {0x0004dcb57797ab7b,0x0009ba2ca8e86843,0x0003336c160ad35b,0x0000149bfdb1e0de,0x0000bef99ec88b39}},
   {{0x00096f31711ebec8,0x000f4e98fdc46c3b,0x000b4411f2da40f1,0x000bb6399774d357,0x00007c8bdf495b65}, {0x00089e3c2eef12d5,0x000aec7471f3da3a,0x00012c594de95bb9,0x00056b100f225bd8,0x00004907c5d7b75a}},
   {{0x000c5f08db60e357,0x00068a833319a93c,0x0001683c9743e3cd,0x00007e0dad5c41f8,0x00000c1e7da0c341}, {0x0004a39a6be09070,0x000586d0b7d30edc,0x0002bfa6036d4703,0x0004148c76da0327,0x0000b4a07ea0f08a}},
   {{0x0004d2945c1dd539,0x0007931debb5699e,0x0007f00e0cadc589,0x000a0e4f49fcc7a7,0x00003057bc0373e5}, {0x0007ecd027a4cd18,0x00034614011a2f8b,0x000677c68114734b,0x000f4f67a01db767,0x00009d9be5efe273}},
   {{0x000cb2e089808ef0,0x000dd59e4107d225,0x00011b9c9f1f7a27,0x00015953afc76182,0x0000361bc67e6819}, {0x0005d0b7f071426a,0x0000470725672a86,0x0006bcabd6a3c181,0x0001bb9e3bca1e0d,0x00001b02bc1e0859}},
   {{0x000ee5931fba2393,0x000368bd91d1e0de,0x0001a3c1df47424d,0x00033adf8886f407,0x0000f7d41e8d8192}, {0x00023c2cf6eb9980,0x000f609a287f7086,0x000c9076286bb49a,0x00054b942bb24963,0x0000ef6eea555a96}},
   {{0x0002d7236f5defe7,0x000be6f991765f6d,0x0008ce0c7fa9922d,0x00055dfc8c5ecef7,0x0000b44589e2e09b}, {0x0003bca9ea837700,0x000f2ab71547e11b,0x0001ddcc0d7fa2c7,0x0007072a3dd6fa2a,0x00009acb4305a7b7}},
   {{0x0004a2e649d4e574,0x000fd917526e4add,0x000b44ac4cd53a2a,0x00031d8526233020,0x0000028746afaa2c}, {0x000839064291d4c7,0x00017e5ad9095131,0x000185681bf48f15,0x0004425ce57f597b,0x0000c3ac1b0b854d}},
   {{0x0007dc3c093c171c,0x000364f42b656558,0x0005996cbae7acb2,0x00091a9a338adb95,0x00008e656762051f}, {0x0001fba28b8d0b1c,0x0006f6c10a906671,0x000232a8015d7413,0x000d23b0cdd7eb3a,0x00009e2f0802191e}},
   {{0x0001db6f79588c00,0x0009b55768cca80d,0x00054438afa52fc6,0x000a4f0b4df1ae7f,0x0000cadd1a7f9b46}, {0x000a6b31803dd6fc,0x000495eaae35b40e,0x0002e4e16488e4fa,0x000c97df047d5538,0x00009b5b7e0ef6e0}},
   {{0x000d2d3957626499,0x000737aea3f66b1b,0x000c6f896a9604ee,0x000ad0a646ff276d,0x0000bf0e7f5b860b}, {0x000c8217cb44b924,0x00036ea9c1822d92,0x00054a5fda2f5ce6,0x000da690a2afb191,0x000082e474cd5801}},
   {{0x00072d0b611c24be,0x000480a8f351c199,0x000cf64211d468e6,0x0004910b7580697b,0x0000c9dd0ef68fbc}, {0x000d2bf956c2e32a,0x00043cddf94e5b59,0x000ee766573dc686,0x0006c45d5e2321bc,0x00007b4f8effe9a0}},
   {{0x00018dd7280f8553,0x00005baec688fba9,0x000400f42bbaac26,0x0006e473b3f00f33,0x0000d2dba2996f2e}, {0x0001a94985093755,0x000f7ea423ccb6f7,0x00007e6fb8f33031,0x00054bb09b8dd048,0x0000163cfe5acdb9}},
   {{0x0008f17cf41c6e88,0x0009837b925c03cc,0x000d2427cf1f03c2,0x0008e4439c19cc66,0x000023d24bafb6c1}, {0x0009013901f0b4f7,0x000188941c2e32ef,0x00028092e684360f,0x00032e9ebaff522c,0x0000891e4e3956c9}},
   {{0x0004319ac445e3d2,0x00076ea743815126,0x000e9c50a553432e,0x0008c7c6eeaa6967,0x00007ced28482e62}, {0x000d3757a4afa571,0x0003d484c1503f96,0x000bd9923de0a14c,0x000422264a24eb38,0x0000df18da0f5177}},
   {{0x0008f82d8d38a9b9,0x000057de1391174e,0x000c175dd2e97c60,0x00003535709850a1,0x000069041a0c2ae5}, {0x000533b76a2086b3,0x000ba7c2e8fecbfd,0x0009dfb67d6bba71,0x0005d982d58ee609,0x0000a8b342d364a8}},
   {{0x0007649522f9be32,0x000bbf1f49a83bc0,0x00054ec42690c075,0x000dc760e1aee838,0x0000a7dbf4437689}, {0x000fc0e3faf40783,0x000eaf11862cc004,0x000a1b7b3b2f02e9,0x000c80c10a5e0fa0,0x00000aca623b936e}},
   {{0x000bf0502f40d9ab,0x00077c318a4df83c,0x0009c26744681c46,0x00092de85756180e,0x0000e79d046c8470}, {0x000480a78bd01e0c,0x0003b2a51db9af1e,0x000afbab66dd359e,0x000198a2ce3821e3,0x00005cee5b6d7733}},
   {{0x00030d46ffd9fbbc,0x000876c610b7e08b,0x000e262cf6e5bc69,0x0004c13343cff29c,0x0000a2e4e3628b91}, {0x00064c016de36c5e,0x000c62e2b829011d,0x00085aaf8e0b10fd,0x000e969894298166,0x00007511709030ed}},
   {{0x000d8fc3b922bf8a,0x000fac29b133671e,0x0006e99c4e4d8c09,0x000eb9e7eb12393b,0x0000ff3974d2793b}, {0x00094052c18df9b0,0x0003910071390374,0x0007a0b95c5c3a29,0x00096b6a77234fe3,0x00002c29a21b661c}},
   {{0x000f1d6141ecf611,0x000e2bb22f53c3aa,0x000d513579195509,0x000d601959740422,0x0000b083822637be}, {0x0006e35e07289f09,0x000bddd86effcd7d,0x0000f9cfa1f94c48,0x00097d38bb1f82eb,0x0000ee0b7e6ab2eb}},
   {{0x000fe2e34d74e31b,0x000f8bf79ab65a52,0x000feeb8fa352c30,0x000304e7ff6c5aab,0x0000fbe8ff0a5c97}, {0x0001ce6a79046089,0x000a34fca249d608,0x000e5e2001f812f3,0x000ee80b24bc9ab9,0x00001022c67c8012}},
   {{0x0009c5d30a713a1e,0x000fa4ef0f93e83d,0x000fbf9284876e3e,0x0002a3e9777029c1,0x0000f7a6bb49ce7d}, {0x0007228dfa2a659d,0x00080877a48fb806,0x0005d0f3fd5cd339,0x000c2aeea4fd8f02,0x000067d2e35feae7}},
   {{0x000e7d7cc5f43941,0x000c3536e142184d,0x0004aa60ab5551b5,0x0001d51e89b212d3,0x00004a96feb05005}, {0x000ef740d12bb0b3,0x000030b9677e4e21,0x000f7731dc522f02,0x000d315b12e4672d,0x00009f80382ab326}},
   {{0x000630c39024a940,0x000897319452dfb8,0x000a3867caacb96a,0x000fcad68a3961ed,0x0000c58e2b077c4f}, {0x0005d634da919fac,0x000a315e22893d54,0x0008bab10ef79b69,0x000c3694bc3d3d80,0x00008ab300805f82}},
   {{0x00038b67c4a658ad,0x000870e72182c127,0x00098e44fb3c4763,0x00085e6b77be4687,0x0000c047df2e7a7f}, {0x000d4c55e59d92d3,0x0005b8e64d8d2439,0x000ca9b16cedca47,0x000dfe7724cd0d87,0x00005e4fd59d5540}},
   {{0x000ff18e4bcf6b1a,0x0004895018faf8c1,0x00063c949856d628,0x000408a33f665c32,0x00006a76dd741f21}, {0x0002334cc7b4f79f,0x000116720e4a17d3,0x000d9bed5a1d0312,0x0005d0bdb6661d81,0x00000d6fb0301db1}},
   {{0x0001ad51fb747d2c,0x00087033762b7fd1,0x000efaf5aab50f95,0x000bbe6a7e711bfb,0x00007393278ffef2}, {0x000a2440df6f9be3,0x000b41efd215e29f,0x0003d6fd99092757,0x00078bbe60e3114f,0x000038542d43acfb}},
   {{0x0003f0838961a0f4,0x000e586987ca44a2,0x000863cc61426ead,0x000b78f6e6ee2e4a,0x00008059420a28b8}, {0x0003ad87396e1dea,0x000798c5aad13030,0x0008f50665c8bdc4,0x000bbc9e40e11f5c,0x0000bd6e7692d246}},
   {{0x00040bb23330a011,0x0004b34eafa068aa,0x000e02c21d23f5ee,0x000d062bbee3155d,0x00008dd4397e1d8d}, {0x000939a122d7b44f,0x0009b33870d63ba1,0x0004fe3f8e6d3b40,0x000cbe9e620f701c,0x00006bba1a6c3a50}},
   {{0x000bde5cfc0aee0c,0x0006008c50bd4a78,0x00063c9b2847edc4,0x000acafaa2439cad,0x0000eb4a728d0fc2}, {0x000e40e26da033d0,0x000d03e02683a419,0x000ccf7256cc3889,0x0002081cd28559fd,0x0000fd7e0f18d13d}},
   {{0x000733b1f0df9d48,0x000322b5e4f301b9,0x000304fd48cc2c5f,0x000aa6c3053bfa3a,0x0000e87665c8a9f1}, {0x00029ecd73dc965f,0x00044e9023db087f,0x000ce28b415ace45,0x0008493370e3092b,0x00009723443a6b1e}},
   {{0x000662eb72d9f264,0x000eb0e47109beee,0x0003289d0b19396d,0x000e3245b1fa73e1,0x000036cf77e94e58}, {0x00033b3e990ef77c,0x000c5b11fc250ec8,0x000c332ce7373e3e,0x000855fe0eda870f,0x0000ed049714d7ea}},
   {{0x000f7857e977ca05,0x000a8fdd5d2bf85f,0x0005af461b66ee8d,0x00087ca5e3795090,0x000087b9090e66d4}, {0x0008a1b32ba0127e,0x0006341615ac6a19,0x0006ef2f2a7720e0,0x000b3cc23f349999,0x0000f5f64b5270bc}},
   {{0x000a96292b8c5599,0x000fd9740a0fa526,0x000bdc0a50c14aab,0x000ef37d41a9e3a6,0x00007d521072c48a}, {0x000bd303e7c253b2,0x000a27fdedc1cf16,0x0003aab2ecc834b1,0x0000ff5362c6e537,0x000064ed85ee5f59}},
   {{0x000d9c066d41870b,0x00009787ba097a46,0x000d44635a50c20b,0x0008db685e7e51e3,0x00003b3e080e1e2d}, {0x000e558a179e9d94,0x000934a76781bed1,0x00040864f2daa3f7,0x000cb50372baf23a,0x00006900c548fe75}},
   {{0x000171ef76765d05,0x000245c87502b95f,0x0007c99bd4ad726d,0x000fa7dec769da4d,0x0000e2ddd1a136cd}, {0x00017fca93e6dea4,0x000b53771123c221,0x00008a3a2e8a2583,0x0001127e2f6089fa,0x0000809d5edcf0e1}},
   {{0x0004aa3da7a095ed,0x000056f5aadd3b41,0x000e8b84a9049acf,0x0009b2a8d46a4d6b,0x000066b19648732b}, {0x000c2a0de6e95555,0x000865bd87705c2a,0x000d28921cf52d09,0x00036cc5a15fa60f,0x00006ccb81edb275}},
   {{0x0008ab89f4ccbb8c,0x00021b2217290f0d,0x000bed10ced5f44d,0x000b8a8314198800,0x000094348a4dd735}, {0x000e9c429ef8479b,0x0002b14c693f79f3,0x000143a144c13a4e,0x0005c382c9af568e,0x0000c51779a929ac}},
   {{0x00079922774856f7,0x0004fc1bf55f05e1,0x000f19e166e52fb0,0x000b263eda4225e4,0x00000f4728b1f5cc}, {0x00018d1b2947f224,0x0005e81d6fb95d21,0x000f0eabdc827ea1,0x000dcf4412328d8c,0x00005ee9fb243ef9}},
   {{0x0000421bb937d636,0x00056c4b37a68e70,0x000ed7b68df8ff2d,0x000f5944c0d5b25c,0x0000537c1f027308}, {0x0006a263b37f8e84,0x000b9eebc6ce25ce,0x00028d72c170e9a9,0x0004bc9d03795287,0x000045b0e55c5015}},
   {{0x0000e0683a7337bd,0x00042fecf2494b7d,0x000a2b71f1e3416d,0x00026c54840eff66,0x00000d9a50b837cc}, {0x00081506fe28ef7e,0x000543324c7fe219,0x0009b52633cc5ef1,0x000474420f345576,0x00002ade2f2810bf}},
   {{0x00020fa458d36710,0x000c2dc4847b28cd,0x0001941e31549722,0x000ccb6dd01e5559,0x0000e6fbcea27128}, {0x0001e6b3bef0262d,0x000bbf54e103ae1a,0x000c052ecfa8c472,0x0000e8a539c0a872,0x00007b2736a2a349}},
   {{0x000e1f1716843491,0x000e22e19b97143f,0x000980aff36b4722,0x000674cc05922790,0x000075c9c88ae13d}, {0x0005b226e6bfdb1f,0x0001cedb4b46a7de,0x0004a6e445ea5b7b,0x0007e5e5570191d3,0x0000cf60d2f924ff}},
   {{0x000392d677819e1a,0x000e0a5a29e8614a,0x000c85f3f7be74c7,0x0003370b50fece63,0x0000ca2e2a9e6cab}, {0x0000388122a6fe3d,0x0002b82a04a87f70,0x0007aed57db69f70,0x00086eca77935dcf,0x0000f16207d5d91c}},
   {{0x00049ab63ed9998a,0x0004077ddf962fca,0x000344072a3125c4,0x000b5565dd8a8624,0x0000023dda39ec3f}, {0x00041fc0c743032b,0x0000ae438639421b,0x0003c1b074f2120c,0x00071a4b7cae51c8,0x00002370cab7ac21}},
   {{0x000d9626cc820fb6,0x000c585a44bf2eb2,0x0006598f059feee5,0x00005134620fca5b,0x0000b922caede314}, {0x00045ad106bed4e9,0x00054fa1e9abff87,0x000c29487546e71f,0x000530035c1e481e,0x0000509216cdd936}},
   {{0x000306785c9a2dbc,0x0001abe8606fc7ca,0x0004c651dd6ae515,0x000f9549dbcae6e1,0x00009536e245bc32}, {0x00035a934521b032,0x000c678756ffa905,0x000edf03cf39c526,0x000034183172ec8a,0x00000a8075f0fe0c}},
   {{0x0009c62640264225,0x000fd4b9d076f22f,0x000ef29508dd1077,0x00000b444c742a3b,0x00005b9502ed8a2b}, {0x00014b486a098170,0x000c47bb4071a59e,0x000e0592fa39dd3a,0x000f5b55137f663b,0x00007fcafd4c9e63}},
   {{0x00052ee346eb2263,0x0005bc2facb79636,0x0001add267dfab08,0x000c43f73bf2b869,0x00000d7454122b46}, {0x000e73ef2c2d065e,0x000ff42eeac905e8,0x000209d22ff9b89f,0x000a2b4fcbd20597,0x0000b740ffbbe14e}},
   {{0x000f913a8aef5181,0x000beff4cfa2c71f,0x000b360487bfc74b,0x000af10716680cb6,0x000021b2cceaef79}, {0x000c836a01eb3d34,0x000a1f79077bbff3,0x00004bbcf50eb1c6,0x00061d648c32d6a0,0x00007a59316bd64f}},
   {{0x000147f931020167,0x000424d125766068,0x000bc6b9112c5f65,0x000a957fb071a7c9,0x0000c2da0c5de23e}, {0x00045b6d4a1dd5d1,0x00068122b13cf4fd,0x000f57a483e7ad9b,0x00088f242ca118e6,0x0000c2e94a716f82}},
   {{0x0008f075a97d231b,0x00069d83875899e6,0x0008727277c80de9,0x0000160ce0f5d005,0x0000e5d95c2c9c4d}, {0x0005cb19c2492eed,0x0000704d6fb3921d,0x000f988d342192dc,0x000e847c84dcd132,0x0000e26d620717b8}},
   {{0x000dcb6137c7408e,0x000556a266dac466,0x000bebf1b9a38d7b,0x0004e29ef5cb0683,0x00005cdcbbfefd01}, {0x000376df65965a08,0x00026bb3e95e30aa,0x000ee6f2060fe88c,0x00009fb3fd0b6166,0x0000827dcdbbf41f}},
   {{0x0009d240c56c6904,0x000d9db7641dbf8a,0x0006b662b40265da,0x000c9b122b05bf3a,0x000066d1dfef1478}, {0x00069621484469b5,0x0008b2df8f9faa61,0x000b8bf510db6054,0x000ce8737bca023c,0x0000effe34671371}},
   {{0x0005264ff112c32f,0x000c8b971fb2e8f6,0x00075080d8a9c736,0x00059ab4f194707b,0x0000c3f2c5b7839c}, {0x000777e5aeb49c20,0x000dda1addfe1d6c,0x00035affcf3db034,0x0001fdd76fee5a55,0x0000853ac70b9225}},
   {{0x000d5948b2a29d5d,0x00067de00ddb37e3,0x0002c328b28f1f45,0x00073ab083c1b5f4,0x00008ef1d90b493c}, {0x000626041dc61bde,0x000c47ee2f8a96fb,0x000946a5df74e8a9,0x000cfc9c605a802c,0x0000ed48d661839c}},
   {{0x000344f3a29467a3,0x0009951eba6d9894,0x000e5c2f2de81e94,0x0007b3aaea066ba5,0x0000fc8a61438c8c}, {0x000f88f06d0de9fa,0x00049b75ce0a7adf,0x000bc87d5bbc11cf,0x000de1ffbb7accfb,0x00001458e271badf}},
},
{/* digit=13 [{1,2,3,..,}]*([2^91]*G)  */
   {{0x0003668e039c2560,0x000b7c17fd5d1cb4,0x000aa062b5f26fb8,0x000f04eee426af79,0x000072002d0d78fb}, {0x000a237e84fb7e3e,0x00002c82133d4c9c,0x0007e4181b401d8a,0x000151caa525926d,0x0000943083453dbb}},
   {{0x000da31be24319a2,0x000bc095a8e7f92d,0x00078218503f7d28,0x000dbc852fe84098,0x000076ddafe49c24}, {0x00054961d7a64eb7,0x00090f1dbe4280cd,0x00038d2d5e436088,0x000035bf81a87784,0x0000e4d52a8f5169}},
   {{0x000d5b11d59715df,0x0001e788983e19e3,0x000f1f248c7eaa76,0x000d82f5a730b0ab,0x0000bab8085eae3f}, {0x0000d2153765b2f5,0x0003aa127f3d65e5,0x0007b1b10bdd4e08,0x000fd34cf3c07439,0x00009f8090d01b59}},
   {{0x000fd9d615faa8f2,0x0000768554ed7b15,0x000a448828fa1eb4,0x000f325bb4447e7a,0x0000bb2d0d1229ff}, {0x0002a646caa6d2f2,0x000e02e7351b075e,0x000506c628eb879d,0x0004dc9cd5624e9a,0x000018eaef0c87e2}},
   {{0x000684744ddfa350,0x0005dab3f74737e5,0x000e96cf49ccfc5c,0x000b8f9ac1df3f1e,0x0000c0571a13b480}, {0x000b3d54b3a7b3cd,0x00088dcdbb992fbe,0x000415b3a35c0366,0x000d9982a0f5dcb2,0x000057759b51413e}},
   {{0x00047d83d30a2c5c,0x000e378a81dc1fe6,0x0001a4a9b0857f77,0x0003f451d5a33413,0x00000a94af9e9d39}, {0x0005c0bdaa6ec1a9,0x0002f8d2d7edbc3a,0x000614797ba9fe49,0x0005332b4335b4bb,0x000091c4d6902f83}},
   {{0x0008c28d2f01cb3a,0x0003375db0b15325,0x0007d0db493d6eaa,0x000492a19a2b0de8,0x00001e48f0478fe8}, {0x000faf6c508b23ac,0x000975d53549f747,0x000f9b838f137571,0x000cf4df5e58e2fc,0x00007186cef67fd3}},
   {{0x00068cee978a1d35,0x00032ab92d0477b8,0x000a5b862e3a68b3,0x00041d0102979487,0x0000f0606c38a61d}, {0x000be276f9326f11,0x0004b6fe3c2e2814,0x000df73512f521c1,0x000e4407464d7dac,0x00000f5f9d3877f7}},
   {{0x000616b269fb37d5,0x00042de62de5ce8e,0x000dd4153aaf7380,0x00049b5ba111754f,0x000015759ba8770b}, {0x000ebf8aa423a61a,0x00012d41fb928b09,0x0004c8936592245a,0x00010d7cba8ec19b,0x000087e91e44f367}},
   {{0x0004ce43d34a2e3f,0x000dc43b5d611fd8,0x0009186c7ee3759c,0x000259995bc78c61,0x000019c380abbb97}, {0x00021aade744b1f6,0x000000f8056bc0be,0x0003efe11a7d222b,0x00025314be6157b2,0x0000fab2b4f6cd68}},
   {{0x000ea5f4bf1d7255,0x0001ff6c950fad33,0x00077af069c1d8ee,0x0003e1044ee78aa3,0x00004f489bbe4a11}, {0x000d634992fb7e89,0x000a12a443478f11,0x000020e000169a7a,0x00020a8d49d4af95,0x00005945723708e1}},
   {{0x0003878a4d32282f,0x000c58020ae7b6e3,0x000a9b750e36e029,0x000818f05847fb37,0x0000876812da29e3}, {0x000138ed23a17f08,0x000070b3950e84ad,0x000d67ae06d7b448,0x000af65fa8aef42f,0x0000d3eea24d2333}},
   {{0x0002075b15d5acc9,0x000f2d815bc40d05,0x000a36cf2c6d9c79,0x00006ffdcafd88df,0x000008ccbe2c8aa9}, {0x00022c4ba35afce8,0x00007d6abf0b6387,0x000c335c15a3da8b,0x00099aadce252cc9,0x00004e7f0dee5aa7}},
   {{0x000a522b99a72cb0,0x0007876180162101,0x000f3653e06de6e6,0x00054a5ff8c7cde6,0x0000a821ab5c7a67}, {0x000a52b7cb0b5a2b,0x000c190487907e3f,0x000ce053aa7fb121,0x0009af6a72502006,0x0000490a31fb4e92}},
   {{0x000e47d62dd61ad3,0x000c3be01371e17b,0x000e3cbba781a961,0x0009b9e063bfd3da,0x00005647406af73c}, {0x000957b2736a129c,0x00022d13f256f50e,0x00019fcc5a631370,0x0008b5d436ee653a,0x0000f2bdb2aa7a4c}},
   {{0x0001244c5f95cd80,0x0000f4ab95f4b06b,0x000e5836dda8c8af,0x000ffc1bae59c2b9,0x00007d51e7e3acff}, {0x0005e6ac2ccbcda6,0x000f2528c3e001e1,0x0009fead43bc1923,0x000710e3324577a4,0x00001a1b8848aa7a}},
   {{0x0006e08700230ef6,0x00015d19adf8f9a8,0x0005ad8f20af585a,0x00014c1645f361f5,0x0000e676223a6c36}, {0x000257c4e774d3fe,0x0002cc102d1b23cb,0x000126aa582a3851,0x000ee3bbcddd887b,0x0000716998ccefd3}},
   {{0x000d571fb1675839,0x0008416c8f8a4239,0x000a27519dd011c7,0x000b69971c289569,0x0000ce0a3b862d64}, {0x0007289d5ec67385,0x000a3840ef6b8c97,0x000453419a3b49f9,0x0002d5308c14c99a,0x0000c00295b5cf0a}},
   {{0x00014fb1d4bcc766,0x0001e59a88f15244,0x0000d110fb07691d,0x0009f317f43263f7,0x00004ada5e117abf}, {0x000f94e5b544cf50,0x0005fd2713feafd0,0x0000c74f4b4a13a1,0x000e45b99b7d6e25,0x000097f2f7320324}},
   {{0x00037d8affa8208d,0x000b0c29aafc994b,0x0003a607fc3c31b0,0x0005d56da746517a,0x00008e1b8c2ce695}, {0x0001815c8418682f,0x000e8dc91d97716e,0x000996982541d487,0x00002d58a04669c6,0x000039cab1673a65}},
   {{0x00001a0e68db0554,0x00087a3338d50258,0x0002afa84f356975,0x0002d170c8c0aaee,0x0000f6985d43b656}, {0x0001f15132ed17ab,0x0004104365fe351f,0x000b1f066510ed0b,0x0003dbf3f98138e5,0x0000c9d95d6e2df0}},
   {{0x000cf6e19abd09e2,0x00012ff17edba83c,0x0004a06ce0b4097c,0x0008fd38a5c478d6,0x0000ddcc3fd744a5}, {0x000503d9e8153b8e,0x00019774179bd449,0x000d9120c3324fd0,0x0004dacf5d47c8db,0x0000b86016314fa9}},
   {{0x000bdd1972f07f4b,0x000e227bbceb5817,0x00011e5a6e5579e2,0x000047d6847a1f5f,0x000039ed2562c3cf}, {0x0006417a2f62e55f,0x000e2bcf82a2e107,0x000eb29f96b9ab38,0x000a455bb7c3197a,0x00006d17da407227}},
   {{0x000ddbd0f968c006,0x000ba00c880bab53,0x0009ad24da03da7e,0x0000d01b2396246a,0x000012c040161ec6}, {0x0000493109f5df10,0x000080af755070d1,0x000b9a9b3fbda403,0x00041830b93f95c6,0x0000c74ec71007d9}},
   {{0x00055646edb951fb,0x0007cf22c2829417,0x0008d11965f4a9d7,0x000e7c07870895b3,0x0000c593df45228c}, {0x0005bd46af3641a8,0x000abd9b3dccc78c,0x000e333047802200,0x0007998dc73f328b,0x000047ed87de1ffb}},
   {{0x000974e6d6711921,0x000ace16f60ff85c,0x000c387971e14100,0x000da435cb0d5a95,0x00008923bbaab022}, {0x000e899bbe7e86e1,0x000e116067bfef2b,0x000d5ce3e4a1510e,0x000b90c98c815484,0x0000af777f1092a2}},
   {{0x000b4004ef657241,0x00092c0ca6fe9fbc,0x0000029943e04a4c,0x000cabeb3e2cb555,0x0000f3a93c56363e}, {0x0000efe3923555b8,0x00089e1751ea1fe0,0x000b69357744bedd,0x00018abfb2db596a,0x0000dbd736675e66}},
   {{0x0003099df1ea40e2,0x000b37d61e6499d5,0x0006eb812b3f24a0,0x00040bb088a19859,0x00002c8361b77629}, {0x0001f97f9c0d95c1,0x00027e43cdae66f0,0x0002b15c38846117,0x0005cc01599a7fb7,0x000035a7536520d9}},
   {{0x000f0f75f7ae2f68,0x000d57fa6da22dcd,0x000d441b615fc6e1,0x0006b601ca829ad1,0x00004c10cf884a10}, {0x0006c95a73fbbd0f,0x000a5d8f6ee8a9b2,0x00025a0437f24e0c,0x000dfd58b459371e,0x00008a74fcaf36f3}},
   {{0x0006585c9f842969,0x000aabc278b01ed4,0x0004fcbd07fbaa8f,0x000a5f18e96cd46c,0x000040a120303b60}, {0x000e12055a4aec84,0x00049bd742f034aa,0x0008c68ab550e9a7,0x000ec6394456d722,0x000092f8868e4e25}},
   {{0x00015adb2d8f3984,0x000c1b84c9536829,0x000b917d6f13b51c,0x000ee18da90ab85b,0x0000b6155608ea3d}, {0x0004e850a52c1c82,0x000500b75fc4578b,0x0000bb3c6eab1a69,0x00009440c14f3caa,0x000020f448ad8216}},
   {{0x000ee31b0e63d348,0x000229e54fab4fe7,0x000e7b5a4f460057,0x00083140493334d5,0x0000589fb9286d54}, {0x000f5cc6583553ae,0x000a025649e5aa70,0x0000446520879094,0x000c4eec90450710,0x0000bb0696de2541}},
   {{0x0001fdeb9718710f,0x00080374a9f55a17,0x00039bdc138f1bed,0x0000cdd8c582e1ba,0x0000c457b0b808cc}, {0x0007fd4883841e20,0x0009387253819a18,0x000f843958ec25b3,0x0008972553ed0596,0x000095c76616f6c6}},
   {{0x000c85c4bdc56104,0x0003d79eb301917a,0x00078bdccb2885fe,0x0006991fc655478b,0x0000a9fc894259e4}, {0x000f0cd3ce299af5,0x00035df38b20bb7f,0x0008ddb8f195be9b,0x0001b91a929c87d3,0x00005fcc99d021a5}},
   {{0x0005b4c721a4593f,0x0004868eaac22b69,0x00089f914ed1e9a1,0x0009100b63d71c74,0x000098ba31d68118}, {0x00013739b128eb4e,0x000df448af4a8029,0x000418dd37801214,0x000241fbd2e22b55,0x0000ffb3c0eb3998}},
   {{0x000077cc7bf3827e,0x000a67f8238fdfa6,0x00064d554f2165bc,0x000b981e37cf6885,0x00005f825c4ea81f}, {0x0004f67ffed4d6f5,0x0008650a34b043cc,0x00041faf1bc60957,0x0003b63aa8fcf950,0x0000659f053b5177}},
   {{0x00082c36044d63bf,0x00081cdb0ca0e875,0x000b2bcf6a608940,0x000cfb9c993e0fbf,0x0000c64a71a35985}, {0x000da8083dbedba1,0x00021be67df715c4,0x0003defde804ae11,0x0000d3ca4c9658a2,0x00002002ddd6156e}},
   {{0x000ae895dd21b96d,0x000aff44624de68e,0x000c8897a8b99f28,0x00076d3ae008081e,0x0000d0a93043712f}, {0x00075224e233de42,0x00010b36a8a59623,0x0003993d9192445b,0x000a8f8bf9ff7402,0x00001f37bf44aad4}},
   {{0x0004349f8bd2bbd7,0x0008d868195d340a,0x000fdb6f11d902cd,0x000f1bcd27bbf1e5,0x0000a5ab088824f9}, {0x000ab06f7a09e03c,0x000671f2c123c466,0x0001b66572f8a197,0x000a7c1a355dc704,0x0000b840d134ece2}},
   {{0x000ad9f7db326750,0x000307a06f1bb600,0x0001f609478fea13,0x0007aa5d032269b3,0x00007753ef583ec3}, {0x0005aed9c0bea786,0x00095c3f45240348,0x0007f726d41bb398,0x00081fa940376169,0x0000109beb43f394}},
   {{0x00011ea3b6d1145a,0x0009085826548041,0x000e66562b6271ea,0x000d9bc19615e624,0x0000255494677b6a}, {0x000985e99bfe35f8,0x000ffb51cdf6d9c4,0x0008818329770ccb,0x0006d0fc32701392,0x0000777d45fa86b2}},
   {{0x000da22d847999db,0x000613525d329bbe,0x000a959a103aa33b,0x0002339b7b96d428,0x0000b3786e5e1e5d}, {0x000d3ce6961f247b,0x000e52f93d3faeb5,0x000a7ae4f20aa85a,0x000aa7ecd1ad3dd7,0x0000f6688f1281ad}},
   {{0x0000e867469ceadb,0x0003809fca48b1b4,0x00054bbc71904c52,0x000fa1eb7312af4b,0x0000e24bf90093af}, {0x0000790bd98764be,0x0006c26e299ebe5e,0x0008fe4c7a0f45f1,0x0003e56af0d2c26b,0x0000f170db26ae8a}},
   {{0x00061a029e0ccc17,0x000df0ad36ca0e8d,0x000173822cd53e87,0x000e54c28c6623c8,0x0000ee1767e1496b}, {0x0003259648945af4,0x000ce5c8009c89f1,0x00061ab8c9e45a5f,0x0003856f2febd91f,0x00003f6bc86ca275}},
   {{0x0002348f2142e791,0x0009b6e6238a8779,0x000839d9b17d8925,0x000bdc6536d2f64a,0x0000f428fce86a1f}, {0x00096010db06dfe5,0x000100a3a3cc1c10,0x00030f41bbfc16bc,0x000ccea9cbd9ec9b,0x0000b5da0d650138}},
   {{0x0000a4856ef96a74,0x0008582bf842ec1d,0x0003f700db47eb84,0x0001e026deae32ec,0x0000e43c42cea118}, {0x0002a31d1a4aa2a8,0x00084004f3cea1d7,0x000fe8a7a440d466,0x0003648d6a2d3b45,0x000020e52e37b128}},
   {{0x0005fcf25e51b09f,0x000e3023d15929ac,0x000ebf90e180cd2b,0x000180b9892171a1,0x000097c4c886c132}, {0x000c724c03dbb7ea,0x0004618cbbe49f1d,0x00067d153ae04376,0x000aeb5b0b2a3607,0x00008e2f4d6c49cb}},
   {{0x0005247d95ea1682,0x000a0970764a172a,0x0009781691758fad,0x00001b8c803a511d,0x000099cfe2efe77e}, {0x0001e17b0a98927c,0x000060014495652a,0x00075b56a2e26e1d,0x000f94bae0af9f71,0x00002e22a81964b9}},
   {{0x000f9fbd90a060ab,0x000b0af380854d0f,0x000776bcf496a27d,0x00009d82305401da,0x00008cdcef7225f2}, {0x0000f37436a0bbaa,0x0007d686004961ba,0x0003542cf263fa10,0x000537f2beb98eda,0x00002d4d14b75849}},
   {{0x0009d6812e9a1bcd,0x000b8f6e3268989b,0x000ace63861d9075,0x0003fe652c6aa999,0x0000e4e4a56620f4}, {0x000144ad673c0175,0x000e1f6e05eae5e4,0x000d1bd56667417a,0x000711113416aedc,0x0000eb36201d6693}},
   {{0x000c5043a1aa9145,0x000926dc59752d7b,0x000c8125c175a129,0x0008759900e0f23f,0x000069ef68c61198}, {0x000db6363a113b4a,0x0005f88357669012,0x000412deae3bd3f5,0x000e5c05c94a5276,0x0000d9e2a0a4a735}},
   {{0x000984c508b65e9e,0x00008df1a0d1405a,0x000ba80dabde4a1d,0x000d2d3a9433a1df,0x00009192ffa7440a}, {0x00096965099fe925,0x000bbb27a54a9f64,0x00090da6125ddb65,0x000819c78279ddc5,0x0000479a99a4bde6}},
   {{0x0004e05013fe1620,0x0002632d471bd0e8,0x0000e089fbe11dc9,0x000025df0b0c45fc,0x00004fb15b04c144}, {0x0005fc213c999279,0x000fade2eb35a61d,0x000dacbb4a033e9d,0x00049d68185d5cb8,0x0000a88e26616445}},
   {{0x000af6254671ff6c,0x000a9fa58603f717,0x0007773c04bd4241,0x0007e846fba40be6,0x00001d933d32a284}, {0x000acf3689e2c70c,0x000686bafd31f4f5,0x00073f6e592aab0e,0x000933b98d76aa34,0x0000c6641dc53141}},
   {{0x0007757d31e535ec,0x0005c7c2ee11cae2,0x000029ffa04cc43b,0x000a2bcd1f96752e,0x00002150673a4cc7}, {0x000c1e08d68b0139,0x000f5df298f33b03,0x000804464a9d6816,0x0001248bfbb529a2,0x00005a52faeedb22}},
   {{0x00021600e1cb64eb,0x0005ce7fc9fe55b3,0x000b0fb93004828f,0x00091f63394b821b,0x00006293a2de5f1a}, {0x000ef21d145d2d9a,0x00031b8fa603de35,0x000cf252dbe6225b,0x0008c160fc8f6b32,0x000028e52e6b17cf}},
   {{0x000c89b4c371e6da,0x000496ef0f289d1d,0x000292f81cebe067,0x000082bde05d09a4,0x00008303593d53e3}, {0x0005b0a7e37a9bb0,0x000e2b8faec3a171,0x000c9b1028c56f61,0x0001f05250743133,0x0000130cefca4443}},
   {{0x0009fa0bd865cfbc,0x0007fc5f1dd75603,0x000be72244b03e57,0x0008f580edf2e4ba,0x0000752496dfa198}, {0x0002d3b564beb6b0,0x000039a1c608d157,0x000f601260db1d11,0x000f33568d193416,0x00005ae9668f354a}},
   {{0x0006d37c92544f2b,0x0002f35837d519de,0x000514ececc08435,0x0000661bb6869c1a,0x0000633e728de1d1}, {0x000d69f936c581cb,0x000dc439c4f9f15d,0x000448a5b96e7b8c,0x000bbaae676f482e,0x00002ca7d5cad916}},
   {{0x0002541f50240258,0x000964c2d937d55a,0x00062189f47bc576,0x0006f8fd31b92a03,0x00003f3086f6f781}, {0x0006d94b587579ab,0x000780e76c5ff9f4,0x00000ffcfec2d22d,0x000c2b77d57461b0,0x0000b7e65f9e64ff}},
   {{0x00094776652a220f,0x0008e696c9817c7c,0x000effff361618f8,0x0001626021701d89,0x00002c8ff8f6c314}, {0x00013ad8efb4d3e2,0x000fae176d952da4,0x00067d51c937b5ad,0x000ac902867d342a,0x000062b9b1038eb3}},
   {{0x0004fe4c43ff28b8,0x0006ea664e7a4e31,0x000a565c27647662,0x000830be90e40bb7,0x0000588993b41acf}, {0x00001d68f938829a,0x000d9edd7d4cd7b5,0x000cd34c7996627e,0x000e8c97d44a6290,0x0000832749a93833}},
   {{0x000917d4bf503533,0x000b256765fb2e18,0x000d5ab6685dd726,0x0005fe24fe65d693,0x0000ddbacedc15c2}, {0x000d9a412f22e85f,0x00067d06f6bca799,0x000ca1637e2a2486,0x00030a04f1ee5643,0x0000da2828c51ece}},
   {{0x0001a3ea2dee7a63,0x000c434b2284758c,0x000aba6addcde2f3,0x0000a77ba445d24e,0x00005aaf668a6cee}, {0x00004a9e5aa049a6,0x000d31103e847e0b,0x000afecc3e74083a,0x000f7a5eb183ce40,0x0000b89dea04a043}},
},
{/* digit=14 [{1,2,3,..,}]*([2^98]*G)  */
   {{0x0009d23fe67ba665,0x000043cf2f340e29,0x000fcf9139145076,0x000ddaa45b5ea997,0x0000be00843dbd7d}, {0x0003e05d53ff04d3,0x00032de91ef7358c,0x0009ec1a0bf7ccdc,0x0009977d684dbfb6,0x000067e7cf2b01fd}},
   {{0x000f3b7b0dc85957,0x00082f1d9f2e0ca1,0x000dd82a727de460,0x000447aaf3bf39ba,0x00009356a79d5862}, {0x0002345f5f9a0529,0x0008839a42f9c060,0x0004d40fc1a8b0f8,0x000368253eee4284,0x00003b0bfe5de5b6}},
   {{0x000dd02c024789cf,0x000951b57bfc5434,0x0003398df90dca9e,0x0004ba9aa898e224,0x0000607c835794a9}, {0x000be97c2c99b76f,0x000628c29302bb07,0x00003a88c6576ba6,0x0001054d79efcce7,0x0000259ced8a6a0d}},
   {{0x0003a5dc8de610b8,0x000ae7e223ce0f89,0x000ad6dc5e8c515f,0x00028ef774bfa64e,0x00009d20f96125c7}, {0x0000966098583ce0,0x000493f2a7d77a1e,0x000304d4aa2eedb9,0x00082d1b2820974c,0x0000842e3dac0772}},
   {{0x00072a33b9e2d7b5,0x0007748218ffe4d9,0x000149d917cc60b2,0x000ecc3fc7083884,0x0000c04346f7f461}, {0x000fdf2614650a98,0x000741f666acebe9,0x000babc835e35b53,0x00093de45613d188,0x00008cace3b45e1c}},
   {{0x000a3753de92e23f,0x00076fbbb6e3209c,0x000b1487eccb03cc,0x00041edcb90f03d7,0x0000a9c2a39b7109}, {0x00038236724ceedd,0x0007492d0323756c,0x0005e038e3a90225,0x000590e150e519ea,0x0000cba286697427}},
   {{0x000237f788907328,0x0008d3fcb4d9e549,0x0003480d6c443bef,0x0001861884d8a6eb,0x0000a35b6a1b048b}, {0x000471665e9a90a2,0x000d453006c0b4e4,0x000e9ae3b45bf380,0x000b716f3f820d4f,0x000044a35a0b79a3}},
   {{0x0000e9d74cd06ff8,0x000f2ca3eeaca101,0x00063aa2b9c17c7d,0x0004fef4c86cd380,0x0000595c4b3f3461}, {0x00000ca990f62ccd,0x0002fa0c3be5a3de,0x0008ce9f5d9bed21,0x000443a886078adf,0x0000db27ce42cd44}},
   {{0x0004a6658926ddd8,0x0009108015b8ed37,0x0001f7ab8138b2d4,0x000b7a086c6579de,0x000088b9aa143020}, {0x000034e3a96e3551,0x0008e30fbe9ad3ec,0x00021367aba65b0b,0x00046df64c8e50ff,0x0000f508ea41b04b}},
   {{0x0001a49747c866c7,0x000d9518a0629856,0x000dc3608bbb1e5f,0x000026b0ff4e8bec,0x0000f55cded90184}, {0x000ec95f38c85f0f,0x000e9bc3b8c38d73,0x00012b66f5b589fd,0x000e00ce95dd980f,0x00005bd1a09fe338}},
   {{0x0003ae55e915918c,0x0008c6f8a46b6516,0x000ebf99c6158d6d,0x0007eec466b538ee,0x0000a8761f77ca47}, {0x00049c29ebbc601e,0x000100c3ae2faf34,0x000e63752ef3b0f4,0x000a50ca6c577d5d,0x0000916660244682}},
   {{0x00097befc15aa1ee,0x0007d54b07455a30,0x0009a5f1240d1254,0x000ee57bad470651,0x0000d03f7188439d}, {0x000bb6c4a02c4997,0x000d5ffe71d20794,0x0003adcaff725083,0x00030fbcad75190f,0x0000f68ea1cb3729}},
   {{0x000c8c7b7ffd977f,0x000490761a22e747,0x0003ffb83ec104c3,0x000db69395ebaf5a,0x0000b3261f5d4b63}, {0x0004960d883e5448,0x00000cc2eeb85354,0x000d65f9913520d7,0x00095a88f6337bd3,0x00003997db2f81cf}},
   {{0x000f1060dbd2c016,0x000abf9ce934ce6f,0x0009939214f8eea6,0x000fc6f46f7c4b0e,0x0000236a324be753}, {0x0001f84a16022e9a,0x0007a3d1dbb265a4,0x0004cef9c0c18d87,0x000c73d3c556402d,0x0000042810910444}},
   {{0x000f15e9afdfb3cb,0x0002abdfb6df68e4,0x000823d9749a5614,0x000c29f9bc1bd45f,0x0000ceb59719a111}, {0x000455fb269bbc4a,0x000e49bc5d62366b,0x00018b0867cd85e1,0x000fb92743c41c4f,0x00004b4099135294}},
   {{0x000581d26ee83821,0x0005259d638e9c7c,0x00028ae3dcf17dcc,0x000047de8273abb7,0x0000d1129270821f}, {0x000847750491a746,0x00019de0dfb91149,0x000a435ab687fa76,0x000e3ecc2580227e,0x0000b8bdb94f1ce7}},
   {{0x0005dc93bf834aa0,0x00094f6c7e4b4c5b,0x00036bcad0437181,0x000f8dc284e00a37,0x0000d88111821ae8}, {0x0000f82f48c8e33c,0x0004e1bf40dbf9cf,0x0002733e5a11fd07,0x000bd71ceab0dedc,0x0000560a8b64e986}},
   {{0x0001fe23929d0979,0x000002f188f148dd,0x0006fcdac3885b29,0x00046b7f2ae613da,0x0000054303f4662a}, {0x0001e440738042ae,0x0006ddaf6449b687,0x000c9df1b98e6a97,0x0008f8f8bc0650d1,0x0000f3d645216e09}},
   {{0x000ae82b6d72d285,0x0001a5d8408003fb,0x0008efc1c77ca9db,0x000b4a3a112cffa5,0x000018d761d1564c}, {0x000740ef0d1b5ce8,0x000c69eb178569b5,0x000f53382717039c,0x00095bbfe29f9022,0x0000e54ba56ebc7c}},
   {{0x0006d8af7f91d0f2,0x0001882a57289c80,0x000d767543b61b0f,0x0004c62640032d94,0x000073eb5de67d83}, {0x000abf77b4e4d538,0x000f5e4017772988,0x0005071b3b7ce66b,0x000a981fba6b3271,0x00002413c252d3a1}},
   {{0x000c8c4e0e8ad934,0x000e1fab868d5b7f,0x0003946f3b5679ae,0x00050a71f9d2fa2b,0x000058897dc9685b}, {0x000c93089d0caf3f,0x000e88642e921e98,0x000bdaf1839564c5,0x0002e52b77729a0d,0x00009170723479e8}},
   {{0x0000317e4515fa57,0x00048b0c790f680c,0x0002e0765f85cff8,0x000b3257a82aab6d,0x0000446bca9a5c82}, {0x00007aa6d63184f9,0x0007962803a65de6,0x000be80357c1a46a,0x0001f84218313dae,0x00002113ffe573c5}},
   {{0x000e08312e7e46ca,0x0009b6126bd54b38,0x000c07e0469d0a37,0x0002675b3f324b73,0x00000c22f682fda7}, {0x00000514d2c7d8fb,0x00031be2cae58f2c,0x000f0f277bc45ced,0x000a9831c6cf07a8,0x0000c392312ceb99}},
   {{0x0007b7e3cc8ac855,0x00078d02753b7553,0x00037df2f8d725f5,0x00031dad05ff64b7,0x00005fe871346d25}, {0x00004a96ab6b01c8,0x0008fcd9372457ce,0x00086699b69a02a8,0x000231cf82ac35cf,0x0000242d3ae1cb4b}},
   {{0x0000f65d62105e5f,0x00093d29be61713d,0x000fbef09bb222bf,0x00082f02f9a79e6c,0x0000c24d8d4c5d67}, {0x0007085d41299673,0x000cac3c2a435db7,0x000d8d9a3db81c3c,0x0000266d655fc005,0x0000f5d057a84298}},
   {{0x000f56d88c546946,0x00053b09573e1157,0x000adffd1b26baba,0x000382ccab03b022,0x00000a412c93d69f}, {0x000e98b54b25039c,0x0002a87e714ded76,0x00000b594d4ee67d,0x00009ac77396487b,0x0000e41977689ef7}},
   {{0x0006f851c203a40e,0x00060afd8f9140f7,0x000578dd230d352d,0x000f3ccf196d3d95,0x0000a4bb3d857cc3}, {0x000bd03b98e782b8,0x000f8624920d42a5,0x00056fcc8ac958c3,0x000e5e3838134cfc,0x00006ec4cd009572}},
   {{0x00035269be47be0e,0x0007eb28fea169c4,0x0006c67e5323b7dd,0x000e461a5538ba3a,0x0000f921d70fd378}, {0x00061fc3c4b880ea,0x000df8940a67f929,0x000f0ff393f6f914,0x000f9c0990eb0afe,0x00006c2921090eef}},
   {{0x000416651b8d9a36,0x0008affb0db1ca80,0x00082e7ce42531bc,0x00074112ce4718aa,0x0000e1999143f574}, {0x000b13dd5d369463,0x0005c68f0194d5f1,0x00010d2308255dc6,0x000988ac9df4cd87,0x0000453c20f438c1}},
   {{0x0008dc089a6ef014,0x00005857df859af9,0x0001ad9244dbcc3f,0x000045f48056015c,0x00000448da610493}, {0x000926d4ee343e2f,0x000ca0e8a301f629,0x000815b3f6343f1b,0x0006faffc9349140,0x0000882a424ce8f6}},
   {{0x000d5f4e7db9f57e,0x00095c384c273a12,0x000c660b17dfba38,0x00021b9a904bfd6f,0x0000b6c5db40773b}, {0x000ee661cdfe0491,0x000e34540f29c350,0x000ec6aad9baac0c,0x000baaac57b6aba5,0x000067ce8c31a7c1}},
   {{0x00003a553fb2b560,0x00074e057f78b23a,0x000e490d96ce141e,0x000e75796525c389,0x0000bc95725a31a7}, {0x00067911220fd06a,0x000ba08b0bd61ec5,0x000ebeba9716e3a3,0x00066f91cd6bf7e8,0x00007326ca75ee6b}},
   {{0x000851ccd090c436,0x0003912c39883d9f,0x0004b7be4561e8f1,0x00037af0490b6a90,0x00001690ce164107}, {0x0009a370f009052d,0x00002026092e299e,0x000fcdc0f258758f,0x000cd1cfa255f3fd,0x0000bc9fb2090e1b}},
   {{0x000dd6e246518404,0x000465c59abc35f9,0x000ca4938dca45a8,0x000f28d03d396fec,0x0000532da0af97b3}, {0x0005ea51999a6bf9,0x0009ce6bf2eec413,0x0005be0933aa9505,0x00052e677cef063f,0x00007d1a0f939431}},
   {{0x000ebba2e1c21dd4,0x000bec6797c42cb0,0x00000101ff41b29f,0x000a8986e17321b3,0x0000422b0ea10d79}, {0x000901c92f1bfc4c,0x000f21e10ed949e4,0x0002926b806ab1f8,0x000ec1c4d35577db,0x0000a349d39f56e8}},
   {{0x0003d32343bf1a9e,0x000757d1a6b170b6,0x0006865b48fd3bd2,0x000fa12454879c31,0x0000e959ff7a458e}, {0x000dcf89706dc3f5,0x0001c64e4b2e0461,0x0008843c8737db0e,0x0006f5b92626802f,0x00004498bbcc745e}},
   {{0x00073faa29e24afb,0x0003c0aa87a13594,0x000573acefcc3c45,0x0009654d2c4bf500,0x000065b514ed8dd1}, {0x000e7cf2193e3934,0x0001b5444d97e46a,0x000ff38ed60e9a4e,0x000f02a7594e9600,0x00003d84d2f4a0e0}},
   {{0x000b141ee398a212,0x000ec3bcc5be8b6d,0x0003460eab88a56a,0x00019aea1aa52f37,0x00000da1a56360bb}, {0x000999d65bf0384d,0x00038d5a180efb54,0x000737b0471a14d2,0x000e91ec44db7b21,0x000084fcb18d1dd8}},
   {{0x000937bfa44b4794,0x00091c98fd4f80de,0x000f087275350549,0x000f52dedb12ab28,0x0000c58b582e5f3e}, {0x00036d88327f246f,0x00095d7df320bfb2,0x0006024f2c3a3bfa,0x000432fcd96c59b9,0x0000c293a546f4e0}},
   {{0x000352b5acf6e10e,0x000ccfe652c35341,0x000577a7fc50343f,0x00023c6af3792d18,0x00001a4c6188f168}, {0x000d0cd33425d0a3,0x000d6b7bc47f9b26,0x0006bb20b306399e,0x000054fa792f3370,0x00001219614c8111}},
   {{0x000c06487f5d28b0,0x0001962277fd864e,0x0006aed5f11392d9,0x0009d9b5aa7942bb,0x000080094dc47e79}, {0x000588c208ba19bd,0x000eb512f2844afa,0x000f5799ad3e7570,0x000491fbae64e602,0x0000eebe7f0214b9}},
   {{0x0000f98e5c298ff6,0x000dd678361f3030,0x000cb9a1617f561b,0x000490952ff31298,0x0000233c3bcb562d}, {0x00015a192e3a2cb7,0x0001763651197bfa,0x0008c53b1961bcfd,0x0004b9cbdd29bf2c,0x000039704dff2284}},
   {{0x000fb587e7b754b2,0x00018806c9b97dac,0x0005044522336079,0x000783c7eb88c923,0x0000983e996a52c1}, {0x000e529958d881dd,0x0002562c7b3cdd4a,0x0000b52d1026bae0,0x000cfa6a6f919396,0x00000980f9162696}},
   {{0x000428cd5f30851d,0x00065a4f66304c1f,0x0005d48a494dfed2,0x0000cd7df53772fc,0x0000d2d5a3063326}, {0x00015bdd44cc7a57,0x000d4d12533a5741,0x0003057c94ba6b20,0x00020dc0e93cb824,0x000094c486a84de3}},
   {{0x000d4cef21496e4d,0x00081c696331e925,0x0008d812ff951d19,0x0004aac810e2de3e,0x00000a4725a08929}, {0x000a2b50e3bab661,0x00059bad306f513b,0x00004c49e462caff,0x000b0bd2dc6d59af,0x0000aeb8750f0b84}},
   {{0x000f12f2f7d0ca2a,0x0008406acf2fc034,0x000facc2f6d2e812,0x000606e01f4f8321,0x00001170c04940ef}, {0x0001d4f7805a99ca,0x00062c26aba5fe0a,0x000531f40bde56a3,0x000107bb1629d035,0x0000c212c2c3afa6}},
   {{0x0006bf315697be5d,0x000b5c63c7c130a0,0x000cdadaf6f0545d,0x0005ba8d8cb8427c,0x000052e379c7c701}, {0x0006147f462c23e6,0x0007e6bc24b0c4f5,0x000856d4fd44a429,0x000cdf5c73d23ae2,0x00001cedd8c6832b}},
   {{0x000355699f241d77,0x0006901a349d6095,0x00089e491ee4adbd,0x0005459b35bf6aaa,0x0000f0076f4836f7}, {0x00018ba9264da3d1,0x000d52a7a28bd19a,0x00061c9716eb2d2c,0x000a5dbdba941f87,0x0000550518bb3be4}},
   {{0x000e2f057d0b70c4,0x000e8d133ba3d0e8,0x000416aeceea8612,0x000061414670f044,0x000024db6c370775}, {0x00039d116213fd1b,0x000468a3478fd960,0x0000c5021c61e7fa,0x0006dcf805bdcccb,0x0000dd6f3a8bcc61}},
   {{0x00096675d97f7e2b,0x0000ff0bf4b60600,0x00091627a31db0fc,0x000fb073680ed454,0x000099a3c672d741}, {0x0005f5536b1ff923,0x0007212b388de9bb,0x000fcf2632973857,0x000b47ab8a2ce750,0x000085346d49c4f7}},
   {{0x000c5ef31631f9e0,0x000103a57a29be86,0x00023f821bf91da2,0x000354c3b1f7967b,0x0000f7d00d2770db}, {0x0006c3bd8fe79da6,0x00007525c9968ffc,0x000ff632acc5e8c4,0x000527e640991dcf,0x00004d97e8cc7112}},
   {{0x000d97302f1cd1e1,0x000b0dd212a4c232,0x0009802f7ce87eac,0x000dbd5e4c8c73e6,0x00002ef02902fffd}, {0x000c74e1bcea6e23,0x00040cb92cbb941e,0x0008f9d05d0b5402,0x000aae509fb9d47e,0x0000bf1615a22992}},
   {{0x000f279f8a7a838e,0x000025615660ad40,0x0001f6fa111aea63,0x000ec8df52e6f1a0,0x0000f0469961dc2a}, {0x000bec9d8080711c,0x0009dfdedf76785d,0x00021c126e1aec60,0x0007322ce797b5fa,0x000066e898fc5e52}},
   {{0x00069c408811fdbf,0x00073fc7f08239bb,0x0004f41388bfe1ef,0x000f97d8e7a39317,0x0000ba8ad1ec58d1}, {0x000d0cebfd2fd5bb,0x0001bee60d61bc21,0x000d222530b839a8,0x0006b2facf7658af,0x0000526bed95ae39}},
   {{0x000bbc2385644641,0x00077c45bc73ccc1,0x000188a789e3ff94,0x0008f7bde9bca358,0x000038b8ee0e73bf}, {0x000234c4123c4899,0x00086a6432975c7e,0x000a15fa366e6936,0x0009267629eeee39,0x00005fab88239e2a}},
   {{0x0007007eafbb1e1a,0x0006475b7a93b249,0x000b68d78d75c9ce,0x0003959558352def,0x00002f26699c23f6}, {0x0001ecfe469b17ae,0x0009072d3ec2eb91,0x000cb113f6254577,0x00098caea47de782,0x0000be4b0872e1fa}},
   {{0x0005ed78cdfedb1f,0x00070e211a74ec2d,0x000d244c5a535c07,0x000a75a678109b11,0x000017c8bfcae299}, {0x000412efb11fbc42,0x000274ab3f65b651,0x000f78243ea0b548,0x0001d4b8dffd950c,0x0000e719e57ee036}},
   {{0x000f085304ddc5b8,0x000ccdaba2ea9007,0x0009d28a9095e8c6,0x000002da33cdb43f,0x00005b95cd962283}, {0x000c819b97447336,0x00089c7f5783bcd6,0x0009038e429c5f53,0x0000180c49b2fad5,0x00008349cc19bbe1}},
   {{0x0000c1d21830ee5a,0x000e49bfa297cc49,0x000de1a9436f9c4e,0x000cdbb8fd729448,0x0000adb13a8ee8f2}, {0x000aaa081313dbae,0x0007e2152dd8515e,0x00053dbf8c76bb46,0x000142557f8d75a6,0x00004d8c4d2914ac}},
   {{0x000e675b055cb405,0x000b477b5167bdb8,0x0002fb863898f8e7,0x00001f9cc65651b8,0x00006544814bd88f}, {0x0008e95263a75a91,0x000f0a22fcdab092,0x0003bd37ccfb6836,0x000664551d14db3f,0x0000d3837fbc6ad4}},
   {{0x000b538ff4f94ab1,0x00025d7fb8f27c5f,0x0005c52877243c71,0x000d1bdf13d60ca8,0x00008cfb7c75bb8d}, {0x000bfe6729082196,0x000b3d5144ab82f9,0x000f4b42f35c4592,0x000dc3f2734f379c,0x0000bac55e7ec60d}},
   {{0x000811e94dea0f66,0x0004818cc1a3b5cd,0x000e660f8259ecae,0x000ff20a0e836e15,0x0000c639ea66e02b}, {0x000b8cb7e1026fd1,0x000b532619428721,0x000f01da39e73b50,0x00057fa8c7097477,0x0000839e6a69268f}},
   {{0x00094155150b8057,0x000e892c7097571b,0x000084b951892389,0x00095c1d69c18e4a,0x0000014c5132e5b4}, {0x000db361b07523ca,0x000d8c1c64fa4780,0x0002c105a2f6219c,0x000360238b81b060,0x0000b4f4f20fdc8e}},
   {{0x000c982cf7d62d27,0x000cb3ba815020d3,0x000763f9e1f36e29,0x000006d8ae0bf092,0x0000a527e6b8d3a7}, {0x0009097581a85e38,0x000f5c158be5b4a8,0x0007d726e1f1a520,0x000862798db37d16,0x0000802786e9113e}},
},
{/* digit=15 [{1,2,3,..,}]*([2^105]*G)  */
   {{0x000149e36f09ab05,0x0009fa10bb5befb2,0x000e2099803f163c,0x000bab8029704506,0x00006f0af006b5a3}, {0x000cfec70880e0de,0x000ede3d913f7af4,0x000ceb4bd7332a66,0x000f5452e6c84a7e,0x0000dc4a79b7c228}},
   {{0x0007dd0c55c44969,0x000695bbabd2c37c,0x000d7f363a6a9635,0x0001decb7e63f2ad,0x0000dce3782be73f}, {0x000a16ab2b91f71a,0x0002bba0163ce1e5,0x000e515ade448982,0x000ecf52759c32f6,0x00005e2f1f92615e}},
   {{0x0009be7abded5516,0x000868b744107451,0x00010d9a903d358b,0x0002b6ed00b10b0e,0x0000392b0b188da5}, {0x000a2980b75c904f,0x000db8f7f96c6744,0x0002cf932c305b0a,0x0006c9142e421d18,0x00006fc5d518e463}},
   {{0x00047c9d64cc78c4,0x000b5b6cb27b7958,0x0008022ab6c50621,0x000a1cc7099bf8df,0x00008f862ec004ed}, {0x00032ede1603c166,0x000efc9a9450d127,0x00029b4fc19a80e0,0x00051582257f54b4,0x00006d3b2c6a5460}},
   {{0x000f87e822e37bef,0x0003353bda4e6ca4,0x000190aeb73f237b,0x0002840747f3a241,0x000006fa370704cf}, {0x000bb6efc621c127,0x0003d0b80ec60a6b,0x000a556f35d624b6,0x0000a7db0724257b,0x0000fa0c354ae2d2}},
   {{0x000fa31e3229d41f,0x0001a4531bd4e921,0x000d38209a929c65,0x0007bc94156027a6,0x00003d69f745bdb9}, {0x000d19a168336319,0x000d73d51be38906,0x000511cd868a34c2,0x0002a83b59583b0e,0x00009ce6bfe8dc13}},
   {{0x000daaaffcdb4631,0x000a24a38b083fac,0x000a9078d658bbc1,0x0005de02a801f8f1,0x0000567bcf97ab85}, {0x00098e03572359bb,0x0004d659e68be084,0x00023807ccf0353e,0x0008a20b86e9c87d,0x0000c08728dd198e}},
   {{0x000b7bc453cadd69,0x00072c0bc1f88de2,0x000abd3af203900a,0x000ffb2cd86e47a6,0x000011cac131502e}, {0x0000242ec965469f,0x000139e0017e2d55,0x0009798850e9f769,0x0001ee733f078f65,0x0000b87d44a3cf75}},
   {{0x0000e4bfc25419a6,0x0002ebff3cfde179,0x000b6e83f3646720,0x000fd268db638625,0x0000cc69f23ccad6}, {0x000e45a6bc68bb94,0x0005e97f73340219,0x0005dc97ce43d79b,0x00049a3d44536846,0x0000b9eea326a0b9}},
   {{0x000c6ba6102d0212,0x00080f4461ea1b96,0x0009f19a8eaafac7,0x000875b4b85c41c4,0x000075c28e4ef538}, {0x0001a9ddd2e54e03,0x0004d605618b3545,0x00036cd246991adb,0x0002162b8b4bcd7b,0x000072a4f8c86f37}},
   {{0x000bd73a6a5da60f,0x000fec4c9ff0c890,0x000536e576f083d9,0x00024304e14d94f0,0x00009ee1edb9aec8}, {0x00041ec8bdcf8e7c,0x00004b041e265712,0x000fff040a5db827,0x000201da0b9a99e3,0x0000aaf21de3c271}},
   {{0x000b2e14f0dd2e8f,0x000e1a377ac7b4e2,0x0007a2198e77e7c4,0x000eb779202c3f0d,0x0000759b80018200}, {0x00026eddcfe314e5,0x000403d5cf99c875,0x0005138b6eb84c52,0x0003f461b52ace51,0x0000aa7ff8c73fca}},
   {{0x00013c3b9791a263,0x000a9dd58b16ff0b,0x000aad2de960022d,0x000619abd55c9257,0x0000baaaaa4230fe}, {0x00023460d881efdb,0x000f96325e2a9a4b,0x0005c18d4506416b,0x0007afe1381e7603,0x00003bb68bfa2781}},
   {{0x000b8bf5116f9379,0x00063126894315bf,0x00019a2c87c64a58,0x000462e1e25cc384,0x0000fd6b0c51335f}, {0x000ba3ce8ee0e0e2,0x0000098c21fa4bf0,0x00066bee06f6fba6,0x00054437d57b39ae,0x000092d513042672}},
   {{0x000105dbab093b30,0x000902839986f451,0x00074a89c012f59b,0x000e978a91580234,0x000048c919c2de03}, {0x000a2b591071cd58,0x0009834970a5c476,0x000b7994b791ed89,0x000ffd09bd9042e1,0x0000eaf517a21057}},
   {{0x000e2a2d551ee106,0x0008127e09a66066,0x00001148d87a8f1d,0x0003fda0d08bab2c,0x0000da8e4f1a24f3}, {0x00017f0cf9a4e718,0x000fbbf5cb19466d,0x00062ecc0ff50200,0x000ac45ccf97d8d0,0x00000c0d9b001d80}},
   {{0x00071d8033f28764,0x00063d5cc3dbe877,0x000c9bc1db0186ec,0x00060e18e8bb803b,0x0000d1395ccaf6ef}, {0x00062d6186244a03,0x0002e10a5b53a73c,0x0001b7eab918e5f2,0x000e51bd4878ca74,0x0000038d71b0be03}},
   {{0x00004b7a93c32461,0x000990b9b4cd8402,0x000d6421821ab606,0x000191e5fa6e2bb1,0x0000de6ad0f03d56}, {0x000aa88ff1929c78,0x000ae40e87b5570a,0x0005f0cccc6df4c6,0x000c015e8a74f2c6,0x0000b972fd666f6c}},
   {{0x00036b60b846531f,0x000520a5e4753fff,0x00045b6c5ba7e45e,0x000d9c94a1d10e41,0x00001f7f91b4e046}, {0x000a69244de90d77,0x000a8199c15e0317,0x000d73deb951a1d4,0x00024f21f78046c9,0x00004c828296ab82}},
   {{0x00078fce7560b907,0x000137e824ceaa67,0x00042eba8b4073e6,0x000f388f0d693cd6,0x0000ce2e57acdcce}, {0x000c7891df1ad467,0x0001998346fd89c2,0x0002fc17783a0692,0x000f1cbd715d72da,0x0000b6dd71df5b6c}},
   {{0x0006d0a73fa9cb0d,0x000d628bf5a9c60a,0x0002c8c82edd3992,0x000f4ff380ddd083,0x0000182d41172a0b}, {0x0007438d9a528dba,0x00092af539947d9d,0x00019987ce8b1a0e,0x00059d3dd6e5fe0e,0x0000cb8df03b90b0}},
   {{0x0003a328300129f8,0x0001e8c43bfd5370,0x000e540511f63766,0x0008c53cbd191300,0x000012fcc62fbf5a}, {0x0009d5f29fb85da6,0x000a094759e83f96,0x0000726b772f4e00,0x000208e26b6e5279,0x000017bbc879bdbb}},
   {{0x0008bb997aee3170,0x0006e81536a8511f,0x000c09b9b812a409,0x000a7a137dfe593a,0x0000682238fba8c9}, {0x000ead6aeccb4bdf,0x0009792ba6337072,0x000ff9d336a34e9a,0x000b61d82eaec26f,0x0000b7535130d4d2}},
   {{0x00045ff1d7aadabe,0x000ff5f6a67c1a04,0x000cfb26f65d3825,0x0001d58e62fb0891,0x0000f1e0fa63c7d9}, {0x000c7ba33db72cdc,0x00093a7c74b247e7,0x0000a503c017cbc0,0x000a417c931590f5,0x0000ac54f61216ba}},
   {{0x000d380b2369f0f0,0x000d23c761519b6c,0x00062a9c697d3a70,0x000f515f9dd6fc98,0x000044c4ab212312}, {0x000a0fd834a2ddc6,0x00026c7b826d035e,0x000fce49049e6b86,0x0006e9503d688362,0x00002f2497b137e3}},
   {{0x00005b6c64582934,0x0006a8d10af704b0,0x000e617b836bb527,0x0003d46cf2dc138e,0x000070d2d35f004b}, {0x0000832feeb1b77f,0x000895657f9c0679,0x000f600042bb75c3,0x00018ae70bd4edc0,0x0000e797ecd119b0}},
   {{0x000ec2a753aebcc9,0x000c3939eca59b5b,0x00095ad09daf9f3d,0x0002fc46bc6833d0,0x00008abdd526aa4d}, {0x0000a318d168be52,0x00000325a23cd984,0x0006ecfafcf7c10e,0x000f1885c02aa07e,0x0000462e7e6d5bfd}},
   {{0x0008a8ba0cc3f125,0x000d6c672a29ab2d,0x0006f2cd368dd485,0x000d8d2203975259,0x0000d3eea67f0cf3}, {0x0001a81e6602671c,0x000f54026c0c810a,0x000b50f858f144a3,0x0004a3fc753a6d76,0x00004dc21e9245cd}},
   {{0x0002dea521d03782,0x000de5011c6fc526,0x0004c19ea802b8e0,0x000aebfba19cbb0b,0x00001db64b60bf0a}, {0x0004ee970342f9d6,0x000dbbc44a141f39,0x000fd0baa93a10ae,0x000e6547eed31b3e,0x0000e7c824e7d154}},
   {{0x000fa819966e7eef,0x000715b7920dee23,0x00090aad464ec4aa,0x000ad43d44462d2d,0x000044dd196cf277}, {0x00071f1bb46b6a1a,0x00035d8850908d64,0x000a977b41e65d31,0x0001ee93a800f513,0x0000ca9d721a797e}},
   {{0x00085a0fcff6a17e,0x00023eca7cee9a5a,0x000504be39970a3f,0x000ee1db9f0d6bc9,0x00000c504bf8dd24}, {0x000d95677fcc2f46,0x000705bb5fc47e09,0x0009286aaef1a522,0x00028ab45d4fb18b,0x00006fd0c5dc6490}},
   {{0x0007ceb1bf4581ca,0x00060ca7b1669885,0x0009722ace635e18,0x000006878ddd2265,0x00000903c4cbdb68}, {0x000458948f214029,0x0004296abda2366e,0x00040319031b49c1,0x0003fda29c4b09e0,0x00007197ca4629f4}},
   {{0x000dd1e274983d81,0x000e45717c8f8073,0x00061f9d1da1a3bd,0x0001ceed3d4da203,0x0000332d0815c7de}, {0x000f7a3aa6d0e10a,0x0003554f1c4a9b7e,0x000d3556717db2e7,0x000e710f3dffae4c,0x0000aa2f407856f4}},
   {{0x000759e7ace3fc7a,0x000ea5a8d8c68966,0x000834e0e9594eac,0x000420ede3bd8b91,0x0000fe4ca53f48c0}, {0x000e856e6ee81c69,0x000adb891a3afdd7,0x000e638298f671be,0x000c9f67a58f2bfa,0x0000ab186fc2c11a}},
   {{0x000b36910b5be761,0x0009eb040bcd8d6e,0x00073de88046b773,0x000e03bcb4529fcb,0x0000df0fefcdf26b}, {0x00057a6bcfcd0279,0x00052b3165caad77,0x00099a4d9a8786c7,0x00004b59db1e347e,0x00009ee86e0406c5}},
   {{0x0002dddc15c9f0ab,0x00039295989e5b7c,0x000d08fdadf87a73,0x000701a9ece47c03,0x0000074d3de5d5fc}, {0x000790351a03776e,0x000a4a6080072040,0x0001531852bb1f77,0x00044645c58f4fe1,0x00006df62f7566e6}},
   {{0x000d1beed51275ad,0x00065f0f483fefb3,0x000c2bedf5de47dc,0x0008a0a932d98e97,0x00005c11927d219f}, {0x0001200a73a294ea,0x0009fdc201729d75,0x0006f506a5f88434,0x000d48328d9fd3a2,0x0000890cd323d1dc}},
   {{0x000aec170f4d3b44,0x0008cffc8d000aeb,0x000d57838fd1a136,0x00036179d9c24057,0x00005929d26a8bac}, {0x000d06025b15ca6a,0x0000ce4744465a2c,0x0001e51344b3c83e,0x000f407aac7578ee,0x0000418f5d7691e2}},
   {{0x000fc8a213ed68b6,0x000cf10a52246936,0x000f09b53860ae7e,0x00098d03660335de,0x000041b28982d79c}, {0x00038e101110f35d,0x0001948b193729bd,0x0009164f479c26f4,0x00027294dae5199d,0x000085a2310d265c}},
   {{0x000dd5d4b07e2b19,0x000afd9ea2217173,0x00005ab14d144c4c,0x0008f158b04ea411,0x00002dda5438e80d}, {0x0002fa8cf03dce66,0x0004ba22cffce998,0x000ad88c48b5ea96,0x00095c97f4ea7f3f,0x00002db773eca5ba}},
   {{0x00002fb93f245674,0x0009f15257cad20f,0x000cab987fd46c69,0x0002f4cac74cc78b,0x00006f31c019ceca}, {0x000db59888b219e5,0x000791fccd0240ae,0x0001f816ce50ecc3,0x00000bcbcd9dad91,0x000083cc1ecddb9b}},
   {{0x0002e66a483bf119,0x000521b2c169f3cd,0x000e9fa28fa08a6f,0x00011f6375e2454b,0x00009a7ffeceb6d0}, {0x000bddbc4ae62da7,0x000dc74aef5d6a3e,0x0004d05bc6cea00a,0x0002523b5fb98d9d,0x0000cba14244560f}},
   {{0x000cc21208490def,0x0002ccfb287949b2,0x0006fb16f1ca66ec,0x000db28f1166b71b,0x0000ff63e0955fe5}, {0x0005abe8b2610bed,0x000f69de3df4b834,0x0001c32b4b732ed7,0x00027c3e24ed5021,0x000010d8a6a548ff}},
   {{0x0004398ed4de248b,0x000d60488927c107,0x000673e13d7cedac,0x0000aef4aa6bf885,0x000046bae921daf3}, {0x0008472fcef7ad8e,0x0007f4b35e970708,0x000e299866115160,0x000c78dcfe8f26dd,0x0000b84c4c8b5a34}},
   {{0x000c55c164e1214b,0x000cf147bb03c1ee,0x000a96835891be86,0x000e9eefab4d100b,0x0000f01e9b955c1a}, {0x000e139b186ebc0e,0x0005a5b91bca6b4d,0x000d93854d5c74c2,0x000fbb7086a99cc2,0x0000ed62a7c87a9d}},
   {{0x000ed6f76b7618a3,0x0004d3b660628778,0x0005186dbbff750a,0x000d131cb7be22b6,0x000069dfbf0fc3a6}, {0x000b26c7191a321c,0x000880ed718ec7da,0x000cfd1839edac3f,0x000692fc142b36d0,0x00008af82f73c991}},
   {{0x000e4d897ce0b2a0,0x000fc3a55cdfb3d1,0x000b81afee6d7c87,0x0009d835846b9568,0x000018d12afd3c23}, {0x000620801206e150,0x0003a3b882c62b2c,0x0000162d5e0e4245,0x00062a854470a3a5,0x000081574787017a}},
   {{0x0003fb4820357c72,0x000e4f1458ad18bd,0x000b44aa1992039a,0x0002817a1df3c525,0x0000d7803580d3d5}, {0x0007e4dc77ad4d4a,0x000859df4fc458cf,0x00071205ed49a799,0x0004a9a465a8b51d,0x00000ee0ea704925}},
   {{0x000eecfab7bd7712,0x000315c262b94b5e,0x0009d61e76c87307,0x0000d2bc5bd6483c,0x000033d6d5452146}, {0x0005626fc195bcc5,0x0007b4d78b63d20c,0x000ec8ef32544595,0x000781903fcb3d17,0x00004b690d196b8f}},
   {{0x0002c8a212306466,0x0008a84f418c82fa,0x00030ba43f51aabb,0x000df79f4fbec11a,0x0000a5acf73d43c9}, {0x000b357d635b4d5d,0x000d1cd5c1da1da2,0x0001af0ddc3de68d,0x000f98d689080bd6,0x0000ea5938ba665b}},
   {{0x000d71afe637294c,0x0005e5a81cd80231,0x0008e63b501968aa,0x0007e851252d5004,0x0000446bc532ca00}, {0x00050a696d6134bb,0x0004ee09a05cef8c,0x000a3291a9361fbf,0x000a21417f85a6dc,0x0000178d549af251}},
   {{0x000374ba4df39156,0x000ecfd5d60887f6,0x000e35102566ce1b,0x0005e1e25cba4d7d,0x0000b745f8fb8c5d}, {0x0002af663122edfe,0x000c5b989a898840,0x000ba31563190f9e,0x0009a46ad3d387eb,0x0000f385adaa7c46}},
   {{0x00081de3f642c293,0x0008610ffb88b082,0x00029254620be088,0x000262c353dd4ad5,0x0000f1627deb377a}, {0x000a013eefcd6385,0x000624cc77c3a5fa,0x00048f55e8f3bf62,0x000b9de2618f65a3,0x0000787c0dcefefe}},
   {{0x0003aa2d9a23e449,0x0002be10690df167,0x000f9110888dfa99,0x0006488ced1b362b,0x0000193cecacaf48}, {0x000327d2d738fc52,0x0007775fee6cfb34,0x0004079a56697b03,0x0001ac0f485da0c0,0x0000cdf57354feaa}},
   {{0x0004420bd55659e1,0x000b3376090c7694,0x0003b591a7973e32,0x0000ca76bb4fe116,0x00000441aedd196f}, {0x0001f4a045ad915b,0x0006f4afacb13b43,0x000fdbbd86c11b43,0x000acc80b0c7db71,0x000064293209da65}},
   {{0x000e6e89c92b2350,0x000e6b3993a14baa,0x0003dd031a73bbd0,0x00081cd06d60ec69,0x00003cab91b71568}, {0x000862f1db3574b2,0x000544bb061ad615,0x000181e06485b018,0x00075707434988a0,0x0000cd61ad4e1c0c}},
   {{0x000ed5a2ff9f403a,0x000ac22390293eff,0x00017b70d8dc98d8,0x0000148206021e1f,0x0000fbec0cb5f510}, {0x000716480130dfa7,0x00051a02dcf59fed,0x000b10fc0306dc2b,0x000f50d8f06620fe,0x00008d1e1d5ca57c}},
   {{0x0008c5a192ef7106,0x000adb7431f9adef,0x000250c9e88afbd4,0x000c071e1f740764,0x0000e31318e158be}, {0x000c4b824f89b4e2,0x000828c36a2afd4f,0x00024baa765a5dd8,0x0006502f1eccfff0,0x00002a21cf2eba94}},
   {{0x0009dee42a554f77,0x0004902ec4ba95d2,0x000adb73d828983a,0x0008391112a1f78b,0x00009ea8898127c1}, {0x000a5a7d065fd831,0x0001a262a0bc8969,0x0002b5127f49af79,0x000dbcecdea8b6af,0x00000e913e1664c2}},
   {{0x0009d14bc21ef518,0x000acce572925123,0x000bbcc3be51c3ce,0x0001e5f95ff06847,0x00006b46e1f3d7e1}, {0x000ba2380041ef4b,0x0004b262342e0ea6,0x000d294d4d72fe50,0x0002c8dabc6dfd31,0x0000be017a2c278c}},
   {{0x000fa09b389328ad,0x0002001771b5b1fc,0x000b045bf322fbc6,0x000d0034c0d06360,0x0000b652edce0e52}, {0x000932c03ec6627f,0x000cd1ee50e350ef,0x00037a90dde1b3b2,0x000a956ab7bdc5dc,0x0000ea6721421e33}},
   {{0x000b5cb4f2999aa1,0x0006a8cbf0dd6482,0x0003405bb38476cc,0x0009ec83ebfacb17,0x00005cdafe7f5236}, {0x0005ba4d935b7db4,0x0003dc99a4cdd42d,0x000b5545b648b600,0x000faf385101bda3,0x0000bf2c38addd67}},
   {{0x000dc634442449cd,0x000963ad4fb8b1aa,0x000686d82e0e9921,0x00066b8c552313aa,0x0000ee635fb165d8}, {0x000224a18ee6e8a7,0x00067d42e02fbc3c,0x00074cd08eed748a,0x000adf770f930ad4,0x000074ea6ed6ff24}},
   {{0x000de1cf3480d4af,0x0006cc8acf1a03e2,0x000295a9cf0d8edc,0x00097d023e330368,0x0000add5f69b546a}, {0x00097ad96f8acb1a,0x0004c71bdae28955,0x000dd43f4bddd49d,0x00041976fcd52821,0x00005a4541306191}},
},
{/* digit=16 [{1,2,3,..,}]*([2^112]*G)  */
   {{0x000b6bfc360e25a8,0x0004875a1a788ce9,0x0001732f4e642519,0x00057a1dc756a848,0x00003c0440fd432b}, {0x000b3f1d720281f6,0x000e7135e051c670,0x000052be72205910,0x000a397ed14b0edb,0x000097b3d282568e}},
   {{0x0009b9afb3ff9ed0,0x000b17f6515c2e59,0x0004da44928c2e0a,0x0004521cbee4fd47,0x000071279a44f364}, {0x000ff6601fbe8556,0x0007ffda51c497ab,0x000597c0b3ee394e,0x00034ab90385f667,0x0000e9fccc7027ee}},
   {{0x000de9314092ebb4,0x000d028e240c0b89,0x000d2f064f17256b,0x000b148f89a7f393,0x0000f57841f21ed3}, {0x0004405e708d8553,0x0001d3f1c3d04ee1,0x000d7eed5856aae7,0x00027098e5424fbd,0x0000333e4efa3ab4}},
   {{0x0007adedda492f81,0x000a682972053bc7,0x000931b4cc11a3ae,0x0004bb4e89a3e734,0x00007512e2eaf569}, {0x00049f3177bf8b6c,0x000948c7ff3e5dc3,0x00011145d232ea4b,0x0009c2dc4f9d16f5,0x0000cf109a3f3b37}},
   {{0x0007a88a1f258972,0x000f81b5d4d8e75e,0x000f3ed5c7ac6961,0x000dfbc3e1077308,0x000008a54ec2a892}, {0x0006e1978660710a,0x0006837df2c8be82,0x000704da50cf70a9,0x0003fca18a7340ed,0x00003eeb9a9a8ca3}},
   {{0x0006233169bca968,0x0003ada6aafb49d9,0x000c2fa9404d286d,0x000fb3409606eca0,0x0000869d0d5a3ff0}, {0x00037e5d0150d651,0x0003140c14c9a999,0x0008e2d49a92e250,0x000e2b556bf94510,0x000052a733ab2f59}},
   {{0x0003d588434a920a,0x0002c22103c5b432,0x0008dbf9ac0af8e9,0x000df1c67518ef93,0x0000184307423a9c}, {0x00094aa5447ab801,0x0005b75a3d61350a,0x000411a9ee5e5a32,0x0000c564ba507f68,0x00000581fc1694f7}},
   {{0x000857080eb24a90,0x000d488e0cfd60e2,0x00059cdb87bedfb4,0x0000a9721ebbd7c2,0x0000b0da855bc639}, {0x00004dbde314c709,0x000bdc32e8462b4d,0x00062fc9ecdbf1fb,0x000ab6a3833eabb1,0x0000939b48c40dd3}},
   {{0x00098a7cb0c9c8cb,0x000fd1c4375c5aaa,0x000f1c90f75105f2,0x0007bf1eee50575e,0x000031e0660723a1}, {0x000d275d4b6d45a8,0x000ce2ec89965364,0x00091c65bd363f3a,0x000b4735d2123943,0x000045647666bb41}},
   {{0x0008ecc37107c78e,0x000a770c2a6620d1,0x000d0d845acff3b6,0x000f9f42f975d99b,0x0000f0a0c479a178}, {0x000965176b6028e0,0x0004248612d41a41,0x00038af55c49ec67,0x000a365b6ac4f273,0x00006145e627bee5}},
   {{0x0005d07e75746b54,0x000d840c78be33e9,0x0002ff8e21c1e1f6,0x0000ad567833ef22,0x0000bedcf6af4918}, {0x000e9c13d7a4c8a9,0x000bdddfe7606b37,0x0003a5bbc2748887,0x000e7467055123aa,0x000054ff2260bbb8}},
   {{0x0008ab197c3dfb92,0x0000af168154c42b,0x000b5069255a549b,0x000bcb8d6748e7c1,0x0000775780f8fc5c}, {0x00080b8e1c9d7c80,0x00013fdbcd564eab,0x00069eace8c69dae,0x000b5a47e6b4fb99,0x000002f1085a705c}},
   {{0x000ca446d3fea556,0x0006948105684e23,0x00062f27db4ae9c8,0x00028be7bfb91b2a,0x00000deb4ca39bac}, {0x000d8947de6c34cb,0x00089494587da892,0x0003f8a5b4ee6825,0x000384e14ee14e1a,0x0000b113eaad8700}},
   {{0x00003b92115b4c9e,0x0007a908cad181ca,0x00018179a7c163d3,0x000080e912a118aa,0x000009ed751686e3}, {0x000e3fa26f516cac,0x0006ce732f91a676,0x0003da8b4753cacf,0x0008a991592aea83,0x0000626f4300cbea}},
   {{0x000c899a7b56eaf9,0x000ba4ef7316ef9d,0x000818a8600c0e52,0x000e46cb1e4e24fe,0x0000d31e20e5538b}, {0x000932d3ed689748,0x0007fc4e87c422eb,0x000de9aefe44bbc0,0x000344c121086e0d,0x0000e6b9cff934f4}},
   {{0x0002c1f711b0eb9e,0x0007980ab9549689,0x0000792dbb905f2c,0x000125cce26309a2,0x0000c8ac9b3e684e}, {0x000d8b6b40a24474,0x00015fe3fb24486a,0x0008e3b3f60121fc,0x0003941626fccf1a,0x0000e568622aad1f}},
   {{0x000ae0d196aa5a1c,0x00065041b5fbda7a,0x000b318b7e0df8c7,0x0006e8851465d926,0x000029b6e563ab13}, {0x000b48b711484633,0x000334454a762c2a,0x00003abe4b5738de,0x00058e24ccf9a05a,0x000077c02963427d}},
   {{0x000f0b92bb39c1fd,0x000c1608d8c573f5,0x000fbb80514373f2,0x000cfb0cbfd31400,0x0000f18fb2153afd}, {0x0007f4242b3523f1,0x000d77f650fb81a5,0x0000a7d7ce958532,0x0006be9a8dc8b68b,0x0000b75dfb725016}},
   {{0x000f7c92d7d1413a,0x0004f834f59790e4,0x00008c3e867e2d6b,0x000ec0afd4f4f9a8,0x0000f8237e175281}, {0x0005fdc84687cee2,0x000185b26c0925ab,0x000ea7650c5ded6b,0x00017f6e4a5aecc8,0x00003b73e5c34cc4}},
   {{0x00043183037bf522,0x000558c725d72bfb,0x000b3e5d7b61e6db,0x00088e6efd4060bb,0x0000e014701fbac4}, {0x000cf9a360aa449b,0x0004c9634d08ac75,0x000fb15efb70cfd0,0x00006bf591536dff,0x00002c37583807c1}},
   {{0x0003fdcf50225f97,0x000c40e12b03b429,0x000a8bf64c52e175,0x0003c68649c3bad0,0x000045a8ff05b8ae}, {0x000e5a358321bc3f,0x00061bc4df4830d7,0x000ea5058b1732be,0x0007442f217993e9,0x00007a71cdf2e4fd}},
   {{0x000533e894c5bbba,0x0008c9d8308286cc,0x00015c2446915c7d,0x000ce506aa2d0558,0x0000eeee592e9b22}, {0x0009d13781354864,0x000ed6b76f2f89e3,0x00036e8f53a275c1,0x0009f59b6bcc1be0,0x0000df69b219e470}},
   {{0x000b2502d0f39aaa,0x000a75a85947a188,0x000e0f4fa622118b,0x0005388ebf520ffd,0x000040e9f29e860e}, {0x00051eb22b57f0fd,0x0008ae80644a7b6a,0x000f095fe849a33b,0x00000180e5d16f1c,0x0000754b54fbc55f}},
   {{0x000bb22236f4a982,0x0008e66800bb5cfb,0x0009a77740b0c59e,0x0009482ac69a8f5a,0x0000b33f804f6bec}, {0x000929532e6c4662,0x000f2e599c73b372,0x0005c31cc68956d0,0x00084e847a249f15,0x00004d80f0e01ce2}},
   {{0x0001dfb988baf015,0x000d8bb16647cd82,0x0004cb960e6331a7,0x000ca4ceb8ad3309,0x000093cca39191bb}, {0x000ac8d265674566,0x0009604b6490384a,0x000b6c8f640fa030,0x00055f37834cd6da,0x00008a7318d9f91e}},
   {{0x000d04efc4d31579,0x00019bf3bdeaa00f,0x000a57172b56f8ab,0x000db2714f56484f,0x000048c5860d50ab}, {0x0005df00ebd4f086,0x000cae82938e342b,0x000df5dd03e5168c,0x0005161aedc1ceb0,0x0000bbbc6da45732}},
   {{0x000d486605daaa67,0x00074b9a6c9ec7bf,0x00024fb8946fd72b,0x000fbc74847fb1a1,0x00005959cbe12d8f}, {0x0009f65c8a588eea,0x0006180b499d4257,0x0009a5df1368c92e,0x0006044a4ef6cd99,0x0000a73bb80336fe}},
   {{0x000a70d6457d188b,0x000adb7a388bf347,0x000cd601386eda86,0x000fb207cdff060c,0x0000eb1b6c880053}, {0x000238799240a9f2,0x000f576189b20b02,0x00066193a1bbb384,0x000c7e6695e71e90,0x0000eb5009726ffa}},
   {{0x000a9c04a7d2caa5,0x000155aaa2900654,0x000476e8f6f3fb3d,0x0005e4335db041ff,0x000040b8b0c14229}, {0x0003ac905e214f55,0x000a06a0b638a5c7,0x0009e680b9a74075,0x000af9de4b1090ce,0x00007a5b479bb8d9}},
   {{0x00048e726bfe65cf,0x000b8290c3070dca,0x00069e72e097e391,0x0009ab783c462e66,0x0000505be1ef6255}, {0x0003ea1e3a3035a8,0x00061cd50da85fbe,0x0006407f26431ebf,0x0006b87d169d5c1f,0x0000d838a95e0fce}},
   {{0x000fa7f650006f01,0x000340c0fbb22a2b,0x000f9ad96dfd7dad,0x0005f982452495cc,0x000083bf494e9563}, {0x000df434a7bd989d,0x000bd543109502d5,0x00043f53e505385c,0x0004a90d98e67dfd,0x000061e1a6d200c3}},
   {{0x00046c64a8a3d626,0x000fc47743d25a4b,0x000f7e4338469c4c,0x000848cbb3a13d88,0x00002b23a1061be5}, {0x00096b4a63d1a4c4,0x000a3d183f3ee835,0x000afb01c454e7fe,0x000638243fce6117,0x0000e65e5e65c4c3}},
   {{0x0005ea1ef74c45bd,0x0005de32850641d8,0x000da7da92cfbfa6,0x000fbac8b078f53a,0x0000985fe38bc752}, {0x00068fe5a0148b4a,0x00068d78136deece,0x000b729ce6f9a55c,0x000bc3832dccc4d2,0x000027e0dfe30aaf}},
   {{0x000445212b4603ee,0x00008b706d149647,0x000a9d412a876c55,0x000c33ff145fcf69,0x00002ab75b80d479}, {0x0009a761a23ff976,0x0001fd359d1012df,0x000835f22c613899,0x0004d90e51c7aefa,0x00009a79cb220fcc}},
   {{0x000350d594cc7e13,0x00030350ab79f57f,0x000ff594a3079ca6,0x00062af26fb6149a,0x00005afec029d59a}, {0x00046f406ed2c6ed,0x0004ad939a579bee,0x000d1797e58da173,0x0006c974c504028f,0x00008853e7d2ccea}},
   {{0x000508da35fcd5fe,0x000b695ccaeb4065,0x000e1a9628965df8,0x000cc32f2da85012,0x0000e471b95a1cf1}, {0x0009bc80a08fb758,0x000501de3591cef1,0x000ef4f88704958f,0x000a5ea867f8b23a,0x0000d7493856a9f9}},
   {{0x00055378c9049f43,0x00034b92d8b61b38,0x000e2bd6b5be948f,0x00054da96f725db6,0x00007a222bcc58c4}, {0x0001abb8809bf618,0x000b9346f18de7c6,0x0007c0d1c46f07fb,0x00007a7b567a7ae8,0x00004a461c8fef3d}},
   {{0x000dce6d9278d982,0x00037dfc73e10a5a,0x0004321c324d9481,0x0007062f3528b605,0x0000e03fdde892ea}, {0x000061947b533c0b,0x000e7ca3c05510e6,0x000b62b8f1a8bc73,0x0004e2fe58d4b21b,0x00002045a74084a2}},
   {{0x000d5afbd76e195d,0x000c9938a8103ab3,0x000e3d5cb478dd1a,0x0001e39ffab3936e,0x0000fb693dbf2b36}, {0x000449651dbf1a78,0x000e88a2e762f969,0x0009bba9acab4b4e,0x000d9668c92f25d3,0x000050e61bd71464}},
   {{0x00030e3dc09508b4,0x000f34317655b7e8,0x000690355faf6d2c,0x000ed632606cebdf,0x00008bb92b410c3d}, {0x00054845c7cf8929,0x000945d5f01f65b7,0x000401d69f6cd7ac,0x00087832c30a5996,0x000012686517d921}},
   {{0x000f913b78c558ff,0x000ad8afdaa9380b,0x000f169d343c0bae,0x00020a477f61d554,0x00008da07e49e5ff}, {0x000c49da8a90ea83,0x000b53a29b21b676,0x000d8d27681c1ff2,0x000982083297ac2a,0x0000001122fea89f}},
   {{0x00094be6718e4488,0x0001fc3e6e13e1d7,0x00026b5ef246c148,0x000cdcd6646ef85d,0x00000f5091f08069}, {0x0002e2f724bdd38b,0x0003d471e8c7c599,0x0000ff2a902e915b,0x00019fe6ff320a0d,0x0000f886487f384d}},
   {{0x000e6a6c93f72d63,0x00029ad800eabbe1,0x000acf117d5f75d1,0x000355ca40a09fe7,0x00002c8cdd5a581a}, {0x00019927023c4994,0x0006f8ec39017422,0x0000e83f0a8afe5d,0x000eac1691afcba9,0x00001bcaa034b8f8}},
   {{0x0005ff98d2668d5c,0x0009bad81965e38b,0x000c6ce110715281,0x0004355bc8fc7c03,0x0000bbee6e34b650}, {0x0000fe80cdb9808a,0x00065e3ed31506b0,0x0000b501817d6e06,0x000aee8e9d38c64d,0x0000b8bfd57244dc}},
   {{0x0004a59513aed8bf,0x000c414bd07a4289,0x00042b582f77f3b6,0x000fe5cbdecb8f8e,0x000010e2fa9c2390}, {0x000502262a2f201c,0x000f90ee32b0efb9,0x000a789a84d59ea4,0x0002c4187f77286d,0x0000f98a2d0b7949}},
   {{0x0007239720943c28,0x0004b990b9d0f957,0x000f2884aba044cf,0x0000aedaa8e82395,0x000034de6ed8278a}, {0x000ee9a5f25bd125,0x000a1f7ab271c8e1,0x000d00b769259cea,0x00032a2e6d97a277,0x0000c0c6eeaf4378}},
   {{0x000c20f5606b81d7,0x00049d991ee55232,0x00032d951abd7b37,0x000363dd2bfe3586,0x00008f8514708ed9}, {0x00073f0f30c3282a,0x00000789230b9518,0x00098967f0da8ac8,0x000fb49ac7789c53,0x000069b8f805dda0}},
   {{0x00077176add85450,0x000672c49b66e5db,0x000421d771b71cb6,0x000fead856073968,0x00003840fe883e3a}, {0x000dad51ec699775,0x0008e07f6726b391,0x000ca160cae243fb,0x0005f4788ac87be8,0x0000174cced9ce35}},
   {{0x0005966e58ba37d6,0x00021817335d98a3,0x000fbc7bffdcc8da,0x000983fb75283083,0x00008e419d539c96}, {0x00039f402a403801,0x000f0fe977bc409a,0x0008edea688940fa,0x00047db640a94b8f,0x0000e22cd17fd115}},
   {{0x00068ce59ffc3e20,0x0005c1dee4e7e285,0x0007cb36360aa1b5,0x000bf2c67497c883,0x00006fb438a105a2}, {0x0007ec4500d8e20f,0x000c1670db103035,0x0003b7cfd1ad9095,0x000d278f589a05c7,0x0000544607e780d6}},
   {{0x00093b1a20ef103d,0x000f9ba6577b17ba,0x000a214a0ad85912,0x000da495c91cf66f,0x00007d49c6cf7990}, {0x000ec8d20bb569d7,0x00027effbc33ecd9,0x000ed0467bd4b250,0x00028bb056ca5a6b,0x0000916a1f7cb637}},
   {{0x000497d53a4f5668,0x000417b56810d4f9,0x00094a6218973466,0x000c6878e1da7404,0x00002546a940d011}, {0x000cb19c61ac1625,0x000c5bad0d3e1f3a,0x000b7ea4352f8fa9,0x000124c5356523b4,0x0000a16ad61fe608}},
   {{0x000b87f4faed184c,0x000c9029f45fb0bc,0x000c6b1fc5f236b1,0x000ce3142c76070b,0x0000644324f28aef}, {0x0001d595c5d84462,0x0006f3ae19798e19,0x000a59cc7c020807,0x0001ba8dcaee553b,0x00000ed6d6bc2cb8}},
   {{0x000ba19b6efcffc7,0x000827c0b87c0952,0x000aa30bc60f12d6,0x000f4ddee2c7c49c,0x000067238b807fbf}, {0x0003921501b5d92f,0x000ed2a37737ebc7,0x0001975433279e3d,0x000b4dafc12bc86d,0x0000a94dc6ffa40d}},
   {{0x000b41a530ccbbd2,0x0006ca8235257392,0x000d98d0c87c8214,0x00074c852f984c05,0x0000ae57d737ef69}, {0x000f7bf3042a6dd3,0x000fe9647a649377,0x000ca9767b1a007b,0x0002d5caa9079a0c,0x0000d81a25c268f7}},
   {{0x00067f8ff81578e1,0x00008045447d7520,0x00005aa6f7862215,0x000c77b0c22fcf05,0x0000030f0a67bed1}, {0x0009f151f0bd7390,0x0007e6debe8531f2,0x000677e982d7989c,0x000fd55c070e728e,0x0000a817bd306e81}},
   {{0x000d830b0f2ac952,0x000a8b20e64ec110,0x00029cd9a48d0995,0x000945ef3e00e177,0x0000a570c20fd556}, {0x000bcfd4e86214dc,0x00020f615498912d,0x00030d76e2d014ee,0x0006d095e2b1e635,0x00005135ae5bd0fd}},
   {{0x000273ad4f3049fd,0x0003170874770066,0x000c6e5fdbb8e989,0x000e6b5dba1ddb14,0x0000ba3788721f57}, {0x000e0a65a72f2cfd,0x000eabea56425aae,0x000872c371208bfb,0x00022425c6aa3b67,0x0000726e08413f93}},
   {{0x000daa5061f16587,0x00016f0cd2b31854,0x0003d50dec0016df,0x00001752a3f23e83,0x00003b681d32bbd3}, {0x0006dc43ac343c03,0x000d557164212f04,0x00017eed49c847e7,0x0009c6b1e13c9109,0x0000fc9eebd93a1b}},
   {{0x0006a727fe02299e,0x0001494f33190f81,0x00045c5be6335ccc,0x00066d5820179f47,0x0000647b783722f0}, {0x00049de02cafb8aa,0x000f5cc2ecccc22e,0x0000e8282299bc2f,0x000204fa8feea26e,0x0000627278c9e893}},
   {{0x00097337933e47b6,0x0002ce766402a7e1,0x000440d9ff4ff6b1,0x00080844d8be0a98,0x000058f5c2f98938}, {0x0005677c95b3b3ec,0x00087137b6ff90b7,0x000c47c29fa04426,0x0005b1477b039b43,0x0000ca95dd44a644}},
   {{0x0008ba42333fc4c2,0x0008d736a1b10b49,0x0001d4b2e274f8e6,0x0001994ca348fd5f,0x00004d3be78c8f10}, {0x000f858ca14f530f,0x00026b982e518535,0x000e1bf62a6e7f16,0x000417947c851236,0x00006a7c58ef3448}},
   {{0x0003703f9374ab69,0x0004de564145583f,0x000526d50864f919,0x000495a3bc3f4822,0x0000f323c80a262a}, {0x000a7ae3f046a9a9,0x000e4f8a039aaa97,0x000aa0ba670da183,0x000c2ccb68f71c52,0x0000be0fe51b1459}},
   {{0x0007eb6cbc613e57,0x0004d97ea61cc1e1,0x0007eded533131d5,0x00011abf69d39eaf,0x00003c2f4354e6af}, {0x0002493a4a375fa7,0x000c4833c5c24ca5,0x0006e71cf5f06787,0x000666114e091f3e,0x00006451f57fb746}},
},
{/* digit=17 [{1,2,3,..,}]*([2^119]*G)  */
   {{0x000bdef694db7e04,0x000779fcddc680f9,0x000b8dce1edca878,0x000ba111981c3403,0x0000274dcf1b0e10}, {0x00043b86def6d1a2,0x0000cbdb1866f727,0x0000c6f58d25b167,0x0007f5a4491e8c05,0x0000be2b2aba7fbd}},
   {{0x0005c9dd111f8ec7,0x000d47c4e7603e0e,0x000392a51bcc33f8,0x00092d002f9a91bd,0x0000da4a7963132e}, {0x0000ae30bb1151be,0x000722e322511a0b,0x0004e9e7854febac,0x0000b80a3a508269,0x000058ffec2c4fe4}},
   {{0x00092fcd1e0cf9e1,0x000db0e7b2e8f855,0x00035584edea75f0,0x00092ab04215cfc1,0x000074fc7273f570}, {0x0007877eb930beae,0x000a7eb02a5ae727,0x000241b9b504cacc,0x00095419fe08f7f5,0x00007fb62f56d5ca}},
   {{0x000349d29c4120ba,0x000f20d0d915fbb8,0x00010ba519f94391,0x00091124074fa754,0x000066adbf6b50a5}, {0x000543c34bfca38e,0x000fd9e1ccfcc164,0x00020219ce0f2755,0x000979b9da0f53e8,0x00008234499a6b49}},
   {{0x0008b769d4c54230,0x0000b0521c49cfb8,0x0008700a19e56eb1,0x00058a418e0b5ebe,0x00000cbaad6f93cb}, {0x000fbded92a5e67d,0x000b4f347f11e923,0x000c0585bca4979a,0x0000e2b9162d856b,0x0000d6254b07c3c7}},
   {{0x000c513516e19e45,0x000775c4d5937b23,0x000e71ef656e2e84,0x0004c54f727d735c,0x0000b6304a7479a4}, {0x000a7363ab7e433f,0x00000e742f836638,0x0007fc19f1adea47,0x000697f054b8545b,0x0000935381baa1d0}},
   {{0x000ab2d799e9a748,0x000e2949f729546e,0x00090055a96239e0,0x0009b04a274c6b70,0x000035142c41020c}, {0x000667aa2e8807fe,0x00043aa3d39ea405,0x000fc72f529f2c08,0x000b3bec555d6442,0x0000856e0e8dbeac}},
   {{0x0004f9d918e49366,0x000652513982b550,0x0004d9cb965035ef,0x000508a553a0c26f,0x0000cb10d571ea85}, {0x00057b7a242da112,0x000d472b726848d9,0x00002a96b16a4d3d,0x00063b1d7e637c85,0x00007c7032b930d4}},
   {{0x0002b18e4136a147,0x000cf78e32bfbdc0,0x0009c3c03bacf969,0x000c4f598d89a3dd,0x0000b92420a93bec}, {0x0001f78c64d565c0,0x000010f28295d4b4,0x0003d051a9f969d0,0x000585ec7f7f76b1,0x00008945e1ea92da}},
   {{0x0006b7d5846426f7,0x0008b47d441d5536,0x0006fbf48e7d09e8,0x000d7ce10b404d73,0x0000fa003d15784b}, {0x000614f17fd95965,0x0000e5cb98db25f7,0x00083a76a49e0e0a,0x0000f7dc65957b2e,0x0000d40da8e1ddbe}},
   {{0x000c405050bad247,0x000d52aa4823f2b8,0x0008365a78918426,0x00068fbaeab3dda3,0x00002031717ec91b}, {0x000d69960a94120d,0x000d199eaeec8b00,0x00060aafd478a255,0x0007b2ef656a5f6f,0x0000fd7cb762dee7}},
   {{0x0008bb4a595939dd,0x00085874021737f6,0x000ad76120355647,0x00095ebe740e7c84,0x000089bc84460446}, {0x000da5d85a9184d6,0x000b3fc0b074f7f3,0x0008a888e562563b,0x000e7ba6d2e6aaf8,0x000012d8643761fb}},
   {{0x000dba7f64085e79,0x000399aa8511465e,0x000a2d188b230f30,0x000648c3388426cd,0x00000885735db666}, {0x000ff9a652f54f6d,0x00038fae2bf06f02,0x000f5eee365c8229,0x000d6fa816ade062,0x0000cdbdf44ccc56}},
   {{0x000bba354530bb24,0x00078b0869ea9fb3,0x000431163bde3ef7,0x000a3549bc90460b,0x0000d03d7d324819}, {0x0004f9e43b6a782b,0x0006ec88a68633ae,0x000ffedd9216db30,0x00083fe1dd88e000,0x0000280da9fc2bd4}},
   {{0x000cb8a1635e7417,0x000a08be02a732a7,0x0007ae030fe14008,0x000ce8cfafb3341b,0x0000fd508e7cadd0}, {0x0003219d607ad51e,0x0009ad40964a72c8,0x000878da20f229c0,0x000b853be2c3361c,0x00000c96743cab2a}},
   {{0x00086913e538cd75,0x000c3e08ad53458f,0x0005d15ffa7001f6,0x0005dd02b8c6e6bf,0x000048234a451121}, {0x0009d2d3d5b40458,0x0005ca904190ff5a,0x000607f8bb0ffeeb,0x000729d5a3aca448,0x0000cbd665cb0a06}},
   {{0x00034e0425830687,0x000b83f6e68387f8,0x000c1224802da2ae,0x000efbfb763e5d05,0x0000230378fd5a8a}, {0x00080b571e8e5cae,0x000bd3b6252493bd,0x0009c552e53ab041,0x000e653b8605136c,0x000084d402db5524}},
   {{0x0003573f37f59371,0x000dc1e4fca5a37f,0x0008ab0fceb0f6c7,0x0006ac1965a554ac,0x00007fbf56c37467}, {0x0006bd9acf7d720d,0x0007402247662e2f,0x000d53bef41fc8f8,0x0007d0817a14b385,0x0000ae327a64d76a}},
   {{0x000a065c48182672,0x000b17c1bbc16ad0,0x000392a9233aa189,0x0005ea44970b5227,0x00001699a1c4d153}, {0x000779cc2d7a7fda,0x0008f9c83cf2cd20,0x000c0b8c7e318605,0x000e4cfb69440b72,0x000081497d81b9e0}},
   {{0x0005c891f5f82dce,0x00068361079e515d,0x000a353309a7f67d,0x000e1ac8da81e311,0x000044990c52b18b}, {0x000ed95af103e596,0x00072dac9261c7d5,0x00094b8d3ece8aba,0x000e835e82b09993,0x0000830f09a76adf}},
   {{0x00029b488172d014,0x00058aff9e02250a,0x000a6329a8b20bd6,0x00092078a7661ee8,0x0000520304e13fce}, {0x000da1f2b47f7ef2,0x00083bffc540ae45,0x00064f874e07f528,0x000f38d799700934,0x0000244c2cdc6fa1}},
   {{0x0001ac194d7d9b17,0x0002582e7f1743c4,0x000da0fca5bafdd8,0x0007ad6f0614c15f,0x00004b043a818ae3}, {0x000afa19e71734c5,0x000e4c450f2e3ba6,0x000e242b115d5437,0x0003c1fa5883fe67,0x0000143bdc27c195}},
   {{0x0008b53fc5e89202,0x00087a9cee08542b,0x000486e08363bf9a,0x0000d1e2375f10c3,0x0000037543bac5e7}, {0x000bccc625640b46,0x000e2bc62c3b7109,0x0003f26eacbc1051,0x00042498455fed80,0x0000badceac4b372}},
   {{0x000ce7c6b53f5f95,0x0004cb176d99a2a9,0x0005c081b6424659,0x000ee661298d36b9,0x00003505bb86d9a9}, {0x0009e61f2ba70b0d,0x0008bafad4533f6f,0x000eb4a6ad07e16c,0x000c8dcf1694bbe7,0x0000febceda0cb0b}},
   {{0x000dcdc53868c8b3,0x0002086107a692d3,0x0009b4e64174311a,0x000cb61109e07c68,0x00000e4587f5df3d}, {0x000ea310811b3b2d,0x000c3cce43ea841a,0x0009a78036144d41,0x00092f764c45812a,0x000003d37200e158}},
   {{0x000d7f2b1f3390b4,0x000c65b61272c676,0x000e127a99f7a1b8,0x0007bf0ebebfc9c2,0x0000602500c9dd99}, {0x000771c4711230f9,0x000b720f09c17f09,0x000e5e38b058eb37,0x000bc01b693d4bfe,0x0000289eb1fd653c}},
   {{0x00046abd51b9cf59,0x00020f0121afbecf,0x0000dc274d2aa9c0,0x000a3ba6aaf7d2e9,0x000009e4ea0d8b95}, {0x00004966f32dbdb8,0x00000b030b3ee6b7,0x000b617e2672188a,0x00009e6effe5b3cf,0x00007e947defc827}},
   {{0x0002b391770f5a7b,0x00005e44eb82a44d,0x00069712ae4d4d79,0x00020d92e69d1e3f,0x0000f11c4d75c6a8}, {0x000f3e542c4224c6,0x000be49d941cb5e7,0x00050e878d6b4e81,0x000c53fd72bd1654,0x0000a61e28b4e25a}},
   {{0x0002094e6f1cd952,0x000ced18673f3327,0x000fc14647512f30,0x00077b12f7a4ca5a,0x0000f0956568bbb9}, {0x00047caa82262004,0x000cdac07369586f,0x00013acbe02c868a,0x00054c0ef2b845c6,0x00003d7563e43860}},
   {{0x0009dc7ab952578a,0x000186e84d0b54da,0x000872042b5423df,0x0006df08b64eeb9b,0x0000c205782f990f}, {0x00096eb21f4c77af,0x0003bab273af4ff6,0x00036b3f11a79c3e,0x00027939bc922e94,0x0000f807ef9c6d9a}},
   {{0x000ea3d778f22a00,0x00085b5e746982ac,0x00018ee7dfb10b2e,0x000a2fc0b1698028,0x000011afff4c91c1}, {0x000d126ad124418d,0x0005172e295f95a6,0x000f4db7531c081a,0x00046166bb283af2,0x000011554104acef}},
   {{0x000a8f833f6746cb,0x00054ea990cac7f3,0x000ddb0a921e46f6,0x000554e15fd5c5ca,0x0000d41f01728614}, {0x0004434426ffb589,0x000584dbc204346f,0x000969b7f8055943,0x00039a63dd20fe5a,0x0000d59e9577899a}},
   {{0x000971c8ad4cf4b4,0x000feffb8fb8f1b0,0x000340ba40344885,0x000758b071ac3c65,0x000008d0596f27fd}, {0x0008ea498c364b09,0x0004751e8ab5e7c7,0x0005d9002a4aac4a,0x00045529e1d56048,0x0000acd518b18844}},
   {{0x000688fd06f56c0a,0x000d3f027972e4ca,0x0009a609da48af70,0x00070dc91f0f045e,0x00009dd82ce8e612}, {0x000ca63a0ef18d34,0x0004fd6ca3bd8903,0x000f47d039fb7ee3,0x000e8e67b4a09cab,0x0000cdada015c67d}},
   {{0x00037499355a244c,0x00058f2151a95200,0x000b4efcbe77fd2b,0x000e24a95d6cf666,0x00005a0cad09a2cf}, {0x000fe5cef8118650,0x00089ea5cc3d104e,0x000b58dbcf52813e,0x000b11855683dc40,0x0000338ecde175fc}},
   {{0x000563774921592b,0x000d09bb9d31f9a0,0x0009c5459b4f1261,0x000f52a51429b74e,0x0000e182e701ea71}, {0x000b07cdfc50573d,0x000992be8d44d3a3,0x000ab65d39ba1afd,0x000801cbcfd2cb52,0x0000f11d54879571}},
   {{0x00003ee02a2404ab,0x000371088a710994,0x00004ae71497406f,0x000361e947940950,0x0000db420795812c}, {0x000a30fd88284423,0x0007ccb5ed1c2b72,0x000a40015283add2,0x0005efc7c0e20066,0x0000e3be64138b29}},
   {{0x0007dc1e038a6759,0x0002fc5c6320ac12,0x0000d2c53729deff,0x000cd327df8fd4a9,0x0000b74b0ecf81e7}, {0x000a623dab407e5c,0x0004b6b340c65cb5,0x00028392ccdbd361,0x00082fe184415a7d,0x0000184c1d9a96f7}},
   {{0x0004f1981d3a80f5,0x000178e02432c320,0x00049e0c1fde0c84,0x000a7328203b3e81,0x0000904bdbb58053}, {0x0001dd1101b68053,0x000c19aa6d4930fc,0x00017408743c223b,0x0000086ed671417a,0x000011469a105997}},
   {{0x000b6845e43fc616,0x000580d3ab57b189,0x000181da8f328237,0x0002b7efa34b67b1,0x000021ed0b2f9ee5}, {0x0008de1ad9906763,0x000b26d540659b17,0x00038c201d51de67,0x000f5bfa2c27c475,0x00003856ec868a40}},
   {{0x000fc15be6cdcde0,0x00039f0c6f892522,0x0003e30a61e603f3,0x00053e7994edc310,0x000033a00db220c8}, {0x000a409f7bb7fd76,0x000de62d18f6d3cf,0x0007fe29570f8781,0x0009f35bd8298068,0x0000eef4c32b9566}},
   {{0x000303b2f7e85c33,0x000141988f9b86a9,0x00038acb55fce462,0x0002122b935bf6c1,0x00000ea7d6755661}, {0x000b5f4e51ab9a22,0x000a8e067c78ef1e,0x000ca9ca60587c98,0x00005793ce1b3c77,0x0000a553d4d74b5f}},
   {{0x00082364da29ec28,0x000339c57316c789,0x000d80d47dbdd5d1,0x000391457d6e6b2c,0x00000b460d07e9e7}, {0x0008cabf963c31e5,0x00037c4d32fd9864,0x000f7c68767f9f63,0x000ea6baf42a9dfd,0x00005f292a35b015}},
   {{0x00068b2cd21ab3de,0x0001e393d39289e4,0x000013af9e504f02,0x000acacb21e1d4a5,0x00003283f79a2c28}, {0x00035f6226bf99fc,0x00034e291e69f38b,0x0000c162de835427,0x000dbda1673a15b2,0x0000101dc76704fb}},
   {{0x000b4c2255bd6178,0x0002ec2a91548323,0x0006793876c96969,0x000e2346e6586062,0x0000e01db0d38c88}, {0x0002873893a55595,0x000af7a3e14933c4,0x000cf35f87630f04,0x00073265d80805dd,0x000082ca080c7dfe}},
   {{0x00056e10b1894a02,0x0001b81c68c02c71,0x000b115b59203400,0x0007f2cd225d00c8,0x000037f9c22a3b90}, {0x000f32f4470e2c05,0x000108be4e950ea2,0x000ae5463b725f7c,0x000c03bf1dcafab1,0x00009ed51876ba2f}},
   {{0x000f316d0115d4d7,0x000f63691599f6e0,0x0007f0a415180b12,0x000cbfa57e32c952,0x0000b0b081e18e0e}, {0x000aa8abf4f0dd06,0x0006ed2526966dba,0x000f864fe99b289c,0x0003ab19b7755edb,0x0000974e2b1d6cad}},
   {{0x000bee206ddd6572,0x00010ff3a96d35db,0x0006be758e7cbdd1,0x000f5d6838196807,0x0000d737e7228c91}, {0x000ab6286ec37766,0x000d345fa7a15f83,0x000ef093398aa649,0x0007b19477ec3772,0x00006f52b1e698c1}},
   {{0x00058fbd803738b6,0x000784e86aa49eec,0x000b5149291aaade,0x0009740b1ae617a5,0x000032721221bc45}, {0x00028f0862c51290,0x00093321a4a07e0e,0x00041c88f0a8f79a,0x000e3ae26d166450,0x0000571b80553233}},
   {{0x000ccdec95207114,0x000cfc8b84bfd1b0,0x000fef31455a9e4e,0x000f2b5426bd39a1,0x0000f5f638eaeb93}, {0x0001ed32bf9341bd,0x00007d42d5a9ba2a,0x0006dc7c5d63c132,0x00085102964a8931,0x000017596079a511}},
   {{0x000201ff9e6ed353,0x00053736925ad8a9,0x000581af7b7b5ee4,0x000050da83fbbc99,0x0000076bc4094eeb}, {0x000c98c02dec312a,0x0007838dcb785511,0x0009c08c9270de89,0x00006d8cf4cf9c53,0x000070cb65ed8d3b}},
   {{0x000c10ecfe57bbde,0x000555a0c2b5b12e,0x0001c67bd82c7b65,0x0002cbfdc7d5cd16,0x000032e89868e3a3}, {0x0009444d11a5529a,0x00018427fa1a7aba,0x000a1770ae964ed0,0x000fcc7528392d24,0x0000152ce2cb2c72}},
   {{0x00053a48ec07649b,0x000f959dd4537145,0x00064b11018b4c28,0x0007a23a32b7147b,0x0000871bfa5de6f0}, {0x00012e59e2e3c9b3,0x000514aa90f6b671,0x000539006fbf250e,0x00066fc77aedb8bd,0x0000b0cdf9b0172a}},
   {{0x0009feaf8c511875,0x000c241e4da7edf6,0x00011434505bb67e,0x0002b0f7df0f3208,0x00006facb080b979}, {0x00007e98f6229e49,0x0003c26fba0ff3e0,0x000339d7962d103f,0x000ec0bf33bef7b0,0x0000841357c459bf}},
   {{0x000bb59c34e67058,0x000affdaa84cfa8d,0x000108537c3c7180,0x000e5a795872fca4,0x0000750cc3c132a3}, {0x000c69db7275d7d1,0x000b1e59b2e9b61c,0x000cbb493ffa0168,0x0002d8ba032abc6e,0x0000d86dbd33c908}},
   {{0x0000b67e28ef5ba5,0x00097b18e169ae1e,0x0006bbd202c9a469,0x0001d1becd0e331e,0x000071b360eff5e8}, {0x000ea58101c1d454,0x000dd8880452cd9f,0x0008dd4466651788,0x0001d0699726351f,0x00004bed02323728}},
   {{0x0002b2d33da525d4,0x000dd3144fd8094b,0x000c1061df193678,0x0000f478ab5ba4f4,0x0000343b5fb1ccbe}, {0x0002371638127137,0x000d87611d93a870,0x00021e1d747bf6d2,0x00077cd6729b8cbd,0x0000484d4e14629e}},
   {{0x0006eea60dbac1fd,0x00040a06a2f7830e,0x000ca535b23d8c48,0x000a9ab96714b050,0x0000c8d3645bbd97}, {0x000f9fab12177b4c,0x0003934d5d9c106e,0x000ab360bf79bf46,0x00044e6537a349a6,0x00007c54254600c7}},
   {{0x000a047e5911a766,0x0008047f1ee7b3c7,0x00056ab4261ffa5c,0x000ac8b5aed36f8f,0x0000a0d41b103ff9}, {0x00069f5cc30d3577,0x0000fb72be9668f4,0x0003ad461be9adf8,0x00041aacd926fe90,0x0000e89e3903aca4}},
   {{0x0002de5facf69d43,0x00061775344cf0f8,0x000e36d04363b7e7,0x0009a53894f312b2,0x0000c6cb4fe41d1c}, {0x000c3394008e1f2c,0x0009649f326c85d9,0x0008c5e065e9a85e,0x000ba91c35c60a67,0x000008b94505f86f}},
   {{0x000c02c89f71f0f1,0x0001ef3da3c0de40,0x000125dedad8f3e3,0x0001832ea5096b42,0x00003879cbfb7379}, {0x00014a56b306a0b0,0x000667646c5e6f47,0x000726368359c2ea,0x00031efacf894307,0x00007a5893565ff4}},
   {{0x00061d168754ab0e,0x000c8f429a7624d6,0x0008ce769801fce1,0x000a2ae068a85fa5,0x0000dc35c553d5ec}, {0x000276fa3f660d1d,0x000de8fc7167ea31,0x0008db0aea0184eb,0x000e113f20f21a1d,0x000096d096026c35}},
   {{0x00002b5f8c2a25b9,0x0008759204b6edf4,0x000b4e34c1bb772b,0x000459c0cbeae219,0x00003109d80cfa08}, {0x000ccf78ef59fb59,0x0001f807096354f7,0x000f3ba9b3b438fe,0x000a920e28c65931,0x0000cc31b477ad9d}},
   {{0x0000ba9b733aa5fc,0x000b305af2353c2f,0x000ac82a5dece47c,0x00018a38e3f715a2,0x000097ba641e203f}, {0x000550409c110608,0x0004c6af512dc3af,0x000f2814656ea2c0,0x0004947ac28daff3,0x00007fab43b159ef}},
},
{/* digit=18 [{1,2,3,..,}]*([2^126]*G)  */
   {{0x0001641d4c5105f3,0x000e3d7fbd650989,0x000e6bdb01ae80f8,0x0008606d67225fbe,0x0000b433b59afc4d}, {0x0006db693e856387,0x000273e9862f44e6,0x0005c32ecf7b5925,0x000f506b78515766,0x000002fefd81e362}},
   {{0x000475d0fefb0c3a,0x000aa6d7c35d3754,0x0003798a4d48fb56,0x0008e60070b63336,0x0000e89f3d32fdb9}, {0x00089c86363d14cb,0x0000b7abd27d970b,0x000d5a0218981752,0x000aedebf7d47444,0x00003083bb07ac72}},
   {{0x00041debe949a447,0x0007e46a4fa53897,0x000047bdc638e938,0x0007c9cfe6419ca0,0x0000047f6491aea5}, {0x0008a9041fbab170,0x0008576bdba254e4,0x0002afddcda8e0b2,0x0007bfe807eebcc7,0x00007d3336df4257}},
   {{0x000c244bfe209256,0x00032fdce86762a8,0x00038706391c19ac,0x0004f5fa96a5d5dd,0x00001d587d481d32}, {0x00073a2a37173eaf,0x000763778b65e876,0x000bab43e2384800,0x000fbd20f8441e05,0x0000a11fe133621e}},
   {{0x000772e81685d7b3,0x00018f34a976047b,0x0005f48ef23f27d8,0x0005c3927608e291,0x0000b0b43fad521d}, {0x000fb2663ca72840,0x00041d4db8377613,0x0003b526b7f5729b,0x0003d187b1489858,0x00000b732a6bbadd}},
   {{0x000f4262048e3968,0x0005b83d9de48e02,0x0001e85ad436b50b,0x0008d6778d348147,0x0000b01ea6b5005c}, {0x000afee97015c07d,0x00087e3ba2aed3c7,0x000d3a1d246cdf1a,0x000ff3aa42e50183,0x000054b52698541d}},
   {{0x000cf304e23e9bca,0x0005726e36243f24,0x0000b6d614387f81,0x00077b86a46a033b,0x0000f1bc8462b2d7}, {0x00001ba527de79c6,0x0003e261bbb625c4,0x0007b4bc70e1346d,0x00062eeb96c44b28,0x000058493c7b2545}},
   {{0x00049feb8a24a205,0x0001a52ca53f23f9,0x000fb485317ebfed,0x00005d4b691bbebc,0x0000617ff6bb278a}, {0x00034c5e3c99ebdb,0x000d6784156a241b,0x0005d67dffc64242,0x0000109206482f69,0x0000967ce0f9e27c}},
   {{0x000375121c80b5d3,0x000c731ecca065db,0x00038a07e2e7a563,0x000854b56ffc4e52,0x0000d6c296662ced}, {0x0007d1aaf70b8855,0x0008dd686459e99d,0x000c8ba5bafc3bad,0x000aa34c78bf460c,0x0000a43951968955}},
   {{0x00017a85fe4e3142,0x0000dcb8906ff8b5,0x000061b23e60234d,0x00059cdfe542acf2,0x000087e191f8b4cb}, {0x0007ddc09d877d88,0x000b946789412185,0x000e05ea41c23478,0x0004fe3bf0c056b6,0x00002da4b5430159}},
   {{0x0006791fadb86087,0x000d0b74cdf6f752,0x000b90a34049e832,0x00010c343581ccc2,0x00003639eb90360b}, {0x000331fe1e4a71b6,0x00032072f9194fba,0x0006790326ffd6b9,0x0002ce0e53271c65,0x0000720644551427}},
   {{0x00034a3b23358342,0x000a70ef6860c0f7,0x000e2bb0d9526205,0x0003faab8be71704,0x0000418871e22f38}, {0x00076814082c1576,0x000fc9c20073d717,0x00087e728cc914ac,0x0005fd9186c1ebe5,0x0000fdb3c22c1bcd}},
   {{0x00014a6f2f9f8e93,0x00031fec49d230d0,0x00005a8d9963ece2,0x00029a562025c596,0x0000987444549f89}, {0x000ff6512bf476a1,0x0007f9cf7d9101b6,0x000be56ca598a64d,0x000615c7ec774993,0x00000899785dbb33}},
   {{0x00092fd02eee3ad4,0x0004f0145270b8a0,0x00012b675a86b3d3,0x00040ef23d98c685,0x0000b8bc785a2ebb}, {0x0001f54413f9cdef,0x000e3bab56647d30,0x000bfec23a5e4fb4,0x00020c2d2b252d1c,0x0000cd576bcd1771}},
   {{0x0007d3e83731a34b,0x000e3d836e8e0442,0x00012ca7c2bb9028,0x00073a036acff8b6,0x000088fe5f083d9c}, {0x0006bc6edea4eb34,0x0003088eec77be2a,0x0007106e143b9313,0x000a32b41ff566b1,0x000069e9172a54ef}},
   {{0x0000f0441c23fa36,0x000061989a2eb448,0x000a29ca7b4712eb,0x00028bdccbba0f93,0x0000e205c1536194}, {0x0007957b36416860,0x000d45ac8b4e90db,0x0004e03500432691,0x00051707a759acf6,0x0000514d89c9c972}},
   {{0x000147fa8e67fc38,0x000b2b2085be1701,0x000284e579e2e0b8,0x00066455651824ac,0x000090d4325f4893}, {0x0005e6ec55e68a39,0x000ab339c85a8a7c,0x00022b655bf12e90,0x0006ffa1846b85f9,0x0000a54ce4d9bf4d}},
   {{0x000e83af1a142952,0x000c9285d4f9d7f4,0x000ffdaba916f955,0x000152c57bb0e099,0x00008a430350ab0d}, {0x000ffa2b8a9cef88,0x000e39ec051a0a36,0x00068e6725517407,0x0007fb1c796096ea,0x000053db5fc7b3c7}},
   {{0x0004ba9e864a51ae,0x00088e8a1b8b2147,0x000120a286c26769,0x0005da9c82362694,0x000061e9a496383a}, {0x00050039f84216d6,0x00074d43cd857dd7,0x00012c659ab020d0,0x0002ad3437ae48da,0x0000449c2ec46545}},
   {{0x0004c1c2cf9d7c1c,0x000a2e95e5abcc7c,0x000ae170c1320886,0x000661fb7b9056be,0x00008a5b2519bc0d}, {0x0001432c11d23031,0x00020f03769f4ed8,0x0005398287da6691,0x000d022ac7a5fd84,0x00004dada944bccd}},
   {{0x000c3217ef6b0d15,0x000a2c933f228b84,0x000440b8252a9477,0x000d5e0ef6728afd,0x0000c3bd859bce4b}, {0x00080f5f22c2d3e6,0x000057bb6cc5918b,0x00095a11c368d504,0x000a70566142a126,0x00000ac583b4b19e}},
   {{0x000bb980eab2437e,0x00047e2654c8317c,0x000d8307f8cc08c5,0x0009931e2d6520e6,0x00009f147f437428}, {0x0007d14d2fd6cf16,0x0003cd4fcbb05f9c,0x0007341f7a3ecd06,0x00015c4d83fef08e,0x000043f23a09a631}},
   {{0x00078abe65ab743f,0x000045edc89cd38a,0x0000df568bf7c75b,0x0006814dd8752e53,0x000085c4a77d308c}, {0x00055b2e68acf374,0x000d6b32af854c99,0x0005cf493a544df3,0x000feb0b8ec3f5a2,0x0000d8f27645a622}},
   {{0x000f7aaf0dcbc49e,0x000890bbb45b7bb4,0x0002ca2e57de551f,0x0006eeefd0f3e49f,0x0000ce58709ff5c7}, {0x0000edd167d79ae1,0x0002ea7d7ec13292,0x00030af91039df8a,0x000b59e46206c0bb,0x0000ff5e2f532676}},
   {{0x000a0396ea51d668,0x0005007d7a2611f4,0x0005a9b24506c144,0x00019de0da570575,0x0000fc8cc329f1a3}, {0x0002d4d9433d67d1,0x000f5a7dd2968364,0x0007bde077fa5cb8,0x0006fb476591db9b,0x00003173d2551971}},
   {{0x000599dd5b340fff,0x0006c0fe76c5ea30,0x0008f5adcfc6b529,0x00028c2c6968c8ab,0x0000723c7f6801c9}, {0x000c3219773d4025,0x0002cb51dd474203,0x0002be23cdf7c6aa,0x000e86ed49e37a55,0x00007febee85b5a6}},
   {{0x000bee47bd8e7397,0x00043e63bf75c5ec,0x000fb892379d4499,0x00012fa68bd00f38,0x00005d48ee540533}, {0x00077aadb5cdf33b,0x00058c696769554f,0x000fd674e3396e89,0x0003e47fdddbf2d3,0x0000bb8f6ef49d0e}},
   {{0x0000651cbae2f701,0x000583aaa8eb51b9,0x0001df499efc4bc0,0x0007a57ecd8689dd,0x0000aee99a832f36}, {0x00085b9ae8274c57,0x00050d30b39c95d4,0x000c1ef816c14d44,0x0002ed4afea90bbc,0x0000c5f317b1459a}},
   {{0x00010754ef442271,0x000ecc20f4960121,0x0009853cda17bed6,0x000ce6fcdfe42481,0x00003793299071e2}, {0x0003078dbbe307b4,0x000e36ee99363c1f,0x0003caa206dd1c20,0x00040de3ee4b5742,0x0000ac3793bcefb8}},
   {{0x00038ebed1f8ca0c,0x00078ebb25a29344,0x00069896f3e54665,0x00043d0415af0ec0,0x000013eddb15a5aa}, {0x000204fd49eb8f61,0x000cc74f16707a04,0x000fc0558d0d5bdf,0x000ade2697e28656,0x0000020737111ceb}},
   {{0x000e6900647a82b8,0x00040f40054f5f87,0x000853803908e0ed,0x00025229f633d479,0x0000ed13c9aca28b}, {0x000f6761f460f648,0x000ab6d063363e2e,0x000c4979b53930b9,0x000596b47073ac8f,0x00004380e0edecd5}},
   {{0x0002c6bc4fe3c395,0x00031c7bebdfe3b2,0x000693459ba4a815,0x000b11a23ab6b725,0x00003bc377064922}, {0x000c8ab5afc60db8,0x0004a0b9f2a34645,0x0000fc507aa02235,0x0002e6d2a2954cce,0x0000c2731bbfce1c}},
   {{0x00008ab18a0339d4,0x000cf735436cf396,0x000992b4fac7a658,0x000fd4722c2b07cd,0x0000e83daed340dc}, {0x000c7be2f39ea3e5,0x000f60a56d2e8a34,0x000dd8038ef0c005,0x00007512731f6a6e,0x0000721d7409e3cb}},
   {{0x0001511fbeeee1be,0x00030f1d0c051ea4,0x000c07d35d1ef5e7,0x00049262feefd173,0x0000530a00b6a329}, {0x000b7fef15ebfb03,0x000ca322491a5d55,0x0005b3237549de03,0x0002b6c7b5f60274,0x0000632a3a24ab6e}},
   {{0x000ba890ef59f78e,0x0002e9e52b9a0d3b,0x0006314470dfc644,0x0000b03dc7969972,0x0000f03391893be2}, {0x000735db13839481,0x0002b0dd7d7d0c92,0x0003ed068c1fc29a,0x000bdc5485b69740,0x00003bfaab3bac93}},
   {{0x000c6a90deeaf523,0x00021c641c15410d,0x000c504c4b003fb0,0x000a76e384978c5b,0x00007640487b64a6}, {0x0001bc6222a77da2,0x00073e47eb110599,0x0001b432c62260a5,0x0003e9a7af6613f2,0x00002f3acc9cb495}},
   {{0x00049228e41d155c,0x00077ac059ef5293,0x0008844114d02456,0x00078ef02017554d,0x0000e8055d0659a1}, {0x000d1aff62045490,0x000ec7066759cd77,0x00072c229a0a00a3,0x0006b0471071ef02,0x000009bcf6bd3c4b}},
   {{0x00038a822305177a,0x000ea1645bbf2a26,0x000a7a3c0d51d59d,0x0003ee081142fdc0,0x000017eca6dec706}, {0x00087ed60d9dcec0,0x000120ad24550bb8,0x0007102bad6d28e5,0x000408ebed6308a6,0x000042c31148bffa}},
   {{0x0009ac58aa68e305,0x000bc483513efd09,0x0002d8f0c7a6a3d7,0x000954afcc6b75ba,0x00004dacf966e78b}, {0x000696fa4a9af892,0x000fe6ac98ecf645,0x000a67a203a41193,0x00062621b8b3f622,0x0000d0b1e0fb9dec}},
   {{0x000919240be34e8c,0x0006d1907f3527c8,0x00056702bc7162b3,0x00069bd0188ec1a9,0x0000a132f7e9f937}, {0x00044f90e2025b4c,0x00084c62f14c3ece,0x000e3cc1167aaec6,0x00050ded74141822,0x0000f9b75c43ff9a}},
   {{0x0002b164d348272c,0x0009d959d56d02fa,0x000762916bd99d61,0x000c7ffc4f19db18,0x0000c7cce5109c1a}, {0x000ebaad846bd832,0x000c892028494d59,0x0001f4ca98775a9d,0x000f10e7ec4ae16e,0x00007eb5875da893}},
   {{0x0004d51662cc565f,0x000a1db4138d0028,0x00032a59482353a6,0x000c46e9c7aaaaaa,0x00005528b5f95669}, {0x00002312f23c5ff3,0x000a3affa3a1f322,0x0002ddda0e3e8147,0x000bd4cb423d5c20,0x0000d6414ac9b871}},
   {{0x00082e1a51a168a0,0x000148ae5448586f,0x000233eb8b712c67,0x000ca99a2e4bd176,0x0000188223a78811}, {0x0005e21f7c18de1f,0x0000c27bb286553c,0x00051e9297682e45,0x00034e4ed036b30e,0x0000487211cdc9cb}},
   {{0x00042770c24efc82,0x00049ef737a40d09,0x0004cdd280349fd0,0x0005214d1c9dd251,0x00009c135ff50da9}, {0x0004508f78b0b6f2,0x0002478c143cea6e,0x000e21e65176f5dd,0x0008c3e81484184b,0x00007f7525d07df3}},
   {{0x0000e09748ab1a42,0x00003efe44331fb7,0x000f75af29cba50a,0x000ea85846c7a615,0x0000a7c2c577ee73}, {0x00066a43f0a449a3,0x000b7d90fc3d42e5,0x00061d05745474c3,0x0000924447be3d8b,0x0000e9d1cf16a4ec}},
   {{0x000e453f380a6e68,0x00011b1437c21603,0x00029610a0b86e43,0x0007f6fa4173f2ef,0x0000fa729a8703d5}, {0x0006f6e6c9c217e3,0x0009619195243e18,0x0003d4fb1be1d307,0x000f7162a62a7015,0x00002ed3e35068c2}},
   {{0x000027f9eb1a8b70,0x0007c5b22fe8d785,0x000d6a191bc37eb7,0x000816466b34f0b9,0x000008a89af9a05f}, {0x00028fb7d42c10ab,0x000e99b3f6b819b0,0x000a0ade37fe8c92,0x000a7ba8907cc0a5,0x00003154f52059d1}},
   {{0x000efb6d9790ed61,0x000c96aa793b5066,0x0003e042ea77a0cb,0x00074b0a915f3c22,0x0000c5def0479c58}, {0x000007873b6c1da8,0x00027cd8557a0e83,0x00060f3b155cf85d,0x0000628f7c7c7604,0x00007052acbc6e58}},
   {{0x0002b80907eae66d,0x000f7d721c890921,0x00045ac1c3cb068d,0x000dbad87941aedd,0x0000e8d5c0dddaa0}, {0x0001fdce3502e6ed,0x00007d89a084da42,0x000c24bfbc894420,0x0000eea307ba5ef0,0x0000a212bebf0bde}},
   {{0x000a24bf82ce682c,0x000547f71fe4ea2d,0x000fad8de058d381,0x000faa75a024625f,0x0000d7b05dd6adce}, {0x000f8ed1d9f54ec8,0x000832d3b5cad442,0x0006b2ce28be3d61,0x0004c062220ed0e0,0x00002699a5f9b0da}},
   {{0x00006f571c0c3a75,0x0009bd34180c3ff1,0x000d7d3758f580f5,0x000674febb120e22,0x0000e5782cd39513}, {0x000580c99c82a70a,0x000e75ea8c4c2275,0x000415e70e8359fb,0x000013b3b48db87b,0x0000acf2240b00c6}},
   {{0x000ccf5e4652f1d2,0x000ab56157b29faa,0x00061ec50bd6fdd2,0x000d5284f4fb1f62,0x000044e55ad676bc}, {0x0009305047d320ba,0x0004c181263f881c,0x0008fb8ee1ca983d,0x000963954e9a4427,0x0000d2dbc0fd96e4}},
   {{0x0003aa29268b3de0,0x000ae6e0609a723f,0x000f442520d1ca29,0x0007ed794866aa6c,0x0000b59f3e301af8}, {0x000e5ff7f4a6c51d,0x000191dc2f7ee234,0x00094d81fa8768fd,0x000ce10afc73320a,0x00007f84282d6938}},
   {{0x0003c0e0546063ea,0x0001bd61abc6ae0b,0x0009ac4007fbadcb,0x00010c35d7a2c936,0x00005978d0a4e67d}, {0x000211e4f85eaaca,0x00015acac681290f,0x0008384cde61e2ad,0x00030f0e12522538,0x00007fb68ea6cfde}},
   {{0x000b9363daed4c29,0x000f9606f7897a59,0x000a6d90a80a9aa3,0x000885240c1ea5f6,0x000048364d3e14d5}, {0x000bc6070985182c,0x000d73310895062e,0x00029c2f5a6db5b0,0x00037da4a12175e3,0x00005f25bd350ea2}},
   {{0x000c5242d0a4c230,0x00046bb3cc527915,0x0009e2c92eb5d26e,0x000cf8369a9116c0,0x0000c527f92cf182}, {0x00019382aede0ac3,0x00083cc349399e59,0x000a34361b292220,0x000fe60c9d896299,0x0000c81836df1905}},
   {{0x000b57fa001ec5a8,0x000b20dc5dba4bfe,0x0004a1380e993f5b,0x000a03c788410972,0x0000a0369abb2fe9}, {0x0008d608c927db84,0x000f54655741ea06,0x000b6c7eabf5f37c,0x0009cb07d402a204,0x0000551c295aaf25}},
   {{0x00071e7ed77ee8ba,0x00005309d5c7698b,0x000e780cabddf7bd,0x000ef3c201c22c34,0x0000b04f7d8ec295}, {0x00072944313a8cee,0x000bb2ca4cfe1c94,0x000a7a97ae532e4a,0x000d5aa9738f80d0,0x0000c088c898580f}},
   {{0x0001ecc42ce9e515,0x000d625fdd2a612b,0x000e7f8398f9840f,0x00047fecda78c001,0x000046b3d3b3ce05}, {0x00019a980d309162,0x0007384c20c42717,0x000c786084549710,0x000a4c8f8f94785b,0x00008c7d484477e2}},
   {{0x000176788a2ffe41,0x000518e169a5fce0,0x000f9c93adc506a3,0x000e07fea108617a,0x0000ed2436113fa0}, {0x000aa92a3d694e78,0x000d6f50bc7496ea,0x000114db4c0f43b4,0x000fd44e6aa58c64,0x0000218e8eafc000}},
   {{0x0005dfb185f88448,0x000a9557abfbac81,0x000bfecdfcd7e90c,0x000c49a3d16655af,0x00000f3271f885ca}, {0x0009aa7d0e62f477,0x0000d60a48e57fc3,0x0008f101e88d519d,0x000815e9559ac4d2,0x0000981d9ea3a9ae}},
   {{0x000652c9ac382032,0x000f37657fe55c38,0x0001f541686eaf87,0x0007b5368fc472e2,0x0000afff39d07e59}, {0x000bb07256d4eab9,0x0001f285ab893adb,0x0001caefe2259869,0x000c8aa5f8112a04,0x00005df02e435064}},
   {{0x000356ec7004bf30,0x0004db83c7de4d63,0x00009a7b7230a08f,0x000d2dca27b27087,0x0000d1c4cc4cb9ab}, {0x000c66e7550fee88,0x00071cf7247e8a0b,0x000b5b7e7369cd4c,0x000f7af5562e8492,0x0000fed0da0d802a}},
   {{0x00091c2e48fb8898,0x0002fb8a9d066a70,0x00082a0e226882c1,0x00052d224986631b,0x000044ed736b5181}, {0x000476fd86e27c75,0x0009b4afefdc282f,0x00019e34da04edac,0x00078b3b256ebc61,0x00006a413e95787d}},
},
{/* digit=19 [{1,2,3,..,}]*([2^133]*G)  */
   {{0x000061d5a74be506,0x00047ea16ff582ee,0x000bfc8a2e41781c,0x000e2d80b0c81e99,0x000024f4d696b547}, {0x000545dbdcc9ae4f,0x0005509b1e8e3a83,0x000c935392573dbb,0x000797582960c4a6,0x000001059ae4ae18}},
   {{0x0009f973112795f7,0x0007284e6ee1715c,0x000b66bcde824443,0x000bede5cb4858ec,0x0000c1367361baff}, {0x00015955dbec38e2,0x000c188ad1535466,0x000e0952f51c0782,0x000fa87ba4c53ac6,0x00007e6782a3b21d}},
   {{0x000903d4ed2dbc25,0x00082c3b2d83682f,0x0007e93350eba59c,0x0006d73e9dc84d9c,0x0000f9b21b05eb22}, {0x000d394af267bae5,0x00056e2e15aee33b,0x0008ec500aa86cc2,0x000657ff0bf67d6a,0x0000846aa4549630}},
   {{0x0009740e2c2bf152,0x000589e99704feb0,0x000fbc565627a220,0x000de8cc8d73d0c2,0x000023eed8fe20c8}, {0x0002583a8363b49a,0x000929c2b0a61ee3,0x000dbc85c1a0b6cb,0x0001aba9f7c3d290,0x00008dfbb97bef4c}},
   {{0x0004d4c65c7c2aba,0x000742c5ea84afb3,0x0003c4ab51d4610e,0x0005c3e93f6d1b97,0x00003cdd7ea345ba}, {0x0004983064417ee3,0x000c7d6bdf2b6051,0x000f726c31459b23,0x000549f3b2c3415c,0x0000a82963562d63}},
   {{0x000901fab192c181,0x000e6030164f294f,0x000246ba6ec5fcbf,0x000a0cd2e2fcb7e2,0x0000e7c88b3321a1}, {0x000dd93c92d88c5e,0x000d3106fb5972c7,0x000f60f1441c2148,0x000f30747dd4f5a0,0x0000d9b52b343960}},
   {{0x00049ebb0a5b358f,0x0001ae7e2ed66c83,0x000a462dbb154c5c,0x000b68dad5eccfed,0x00002d6dbe51de66}, {0x000edf38665e5b22,0x00035b7f5723426a,0x000cbb386488a851,0x000878f5cc43b38b,0x00007ad0af3f791d}},
   {{0x000236e846e364f6,0x000c7ea50ca0c16c,0x00026b86d7f33527,0x00070c6481077509,0x0000c2a36096598e}, {0x0005e52f024e9245,0x00044db4afcaa675,0x000831790e0fa07a,0x0000d5c5c3ce7d66,0x0000b4ef350f6cbb}},
   {{0x000afc4b6205969f,0x000206c7854f2c4a,0x000983b4842563f0,0x000754116aced51d,0x0000eb356d989949}, {0x0002c81d1a39bd77,0x000f76934ae98c2a,0x0007904da8f44340,0x000925a48cf91c44,0x0000340185f7f51a}},
   {{0x00000fb7409ab463,0x000650e289b22f8f,0x00088e5d1057e78e,0x0004e1d3e5022ca8,0x0000c87111acdede}, {0x0000e1c7809460b4,0x000231c9abc75b9b,0x000cc1dc9e751c85,0x000a084b944e28c7,0x0000f201ffa5d3cf}},
   {{0x000905c3e6721cea,0x000a30b3674c02fc,0x000810da4d52d70d,0x000d98bdc2e5ca18,0x0000984b273fc69d}, {0x000252784de5ca41,0x0002b852dec463b9,0x000e3de092f1c987,0x000c2f08b03593c2,0x00009d70b01a813d}},
   {{0x0006b2da6dc1d29b,0x00094871e1444280,0x000f49276d303000,0x00004af1feb333aa,0x00005583b9f770bc}, {0x000be7895695f204,0x000149d012b51db0,0x000f61643fc84181,0x0001282409f27205,0x00000d3417515883}},
   {{0x00096f5674198335,0x0002363b7b08d791,0x00056700c6059e25,0x000ec434da18171c,0x0000758ee57028d3}, {0x000771d013b0ea65,0x000b04c5e9b97da2,0x000305d80fddf524,0x00063f2df4faf824,0x00008f5c1bf8a977}},
   {{0x00037f17c696042c,0x000b8a2538dea5af,0x000a42600d4cba22,0x000888611cb9959e,0x0000d105f423b069}, {0x000cf19ddb81e743,0x00092157b8cab1e1,0x0009db885472f2d8,0x000130d86fb008ee,0x000065cd5703f26d}},
   {{0x00002bba2be70539,0x0005eab9a6d6284b,0x000f7a530dcbbf7c,0x0007c7b425559c20,0x000061f2dfaa8876}, {0x000943570dc80c4f,0x000300784120e2fd,0x000567122104d6b6,0x000d768f592bc153,0x00006bc1247e688a}},
   {{0x0004c050f15dde91,0x0007fd5f2b820521,0x000e82b62a47a76a,0x0005eeab254d3062,0x00001a05fe04ec95}, {0x000f46e9d529b36f,0x00009f9e3df67eaf,0x00031769855ab130,0x0007acd463e37199,0x0000d251439bcda4}},
   {{0x000354723d695ead,0x000d46e589b5ca9c,0x00087d08648ce626,0x0009479b5b64c7b1,0x000002e179582207}, {0x000e98f7198111d6,0x00057cf9c3cc8b58,0x0004089b090ca630,0x0000fef691fe72f3,0x00000941af25c7c8}},
   {{0x000c0a222eb51e58,0x00042a9cf09aa09b,0x000159f06c0bb724,0x00060db6a8077f80,0x0000b5c989f5ddc5}, {0x000f316512e1f433,0x00047d08ff6219d2,0x000d20b4e02eac55,0x0004e0d12ab84c07,0x00007d1e11606d4e}},
   {{0x0003e1aab7b19a8c,0x000e1ef8cd45b644,0x0005e03daf08d067,0x000915a3adf3e968,0x0000f15a10f0792b}, {0x000cce5b738a4250,0x00059636b2fdf44b,0x00050d605ebe131d,0x00049d9406884178,0x00009684eaab40d7}},
   {{0x000669c72ba075b6,0x00055a4690158c3c,0x0009f8ba889f78b5,0x000ed6f706aade3e,0x0000d8bd566132d7}, {0x000e63b805f08d67,0x000d53bcc1b525f4,0x00025d8477f48200,0x0000a7de801968b0,0x00004afac04f7cbe}},
   {{0x0002c2b7e63d6900,0x00000223cdb843ed,0x00084d3feefb6bbf,0x0005a44fec3cae28,0x000065ecce6d75e2}, {0x00094ce69f790713,0x000ed44b86666c22,0x000b69d8f0d9a8e5,0x000af72009f23817,0x0000c29f8fef5dfd}},
   {{0x000528febae68c4c,0x000170c5ba219067,0x000dd1aec5b38563,0x000c77940df1191f,0x0000f37825c8fba4}, {0x000f980beb11454b,0x0000b0c1b06677ef,0x00089a1c740a1a99,0x000be038018980f8,0x00009c52aea26c24}},
   {{0x000bcce45650ef47,0x00001aa29ac705fb,0x00004c470ae000f1,0x000c25184b71724f,0x0000cd4fde289bb5}, {0x000b22ae88408697,0x0008efbd06866477,0x00016dfbaa886885,0x000776823cc02e11,0x00006cd5640487d7}},
   {{0x0007598a9d82abfd,0x000b16c170f5e2a3,0x00066b0875f188cc,0x000ad9b168220050,0x0000a22c21397155}, {0x0005d3afbddb4799,0x0003dd715b99151e,0x00097cb2e4b606b8,0x000b65ba73b54bf9,0x0000a1bfe43cecd8}},
   {{0x00028092a67d48a1,0x000df31fa9e21c31,0x00043a34acd6a671,0x0007d3aec3312a0e,0x0000d93563965ef4}, {0x00024898fea73ea3,0x00047035afb25ea0,0x00065b54c8247b36,0x000148858300a652,0x0000286662fa22c7}},
   {{0x000d76bb4ec4c20e,0x00062f3fe3fdb77f,0x000d8c7e8f0a12fa,0x000aa81845bbf541,0x00004d969cb3ec10}, {0x00053b743e232a3f,0x000b47f8a45a4c00,0x000d81c8fdc7a3fa,0x000aff4c4261c520,0x0000d4b3454a00ea}},
   {{0x0008f86d36e30622,0x00078143ff0276d4,0x00076f42e626c527,0x000eac338174deaf,0x0000267aa868407c}, {0x000635172e572d59,0x00072a7330ebfad7,0x0008d8657ab861af,0x000a5210a1c8c741,0x000088821cbb0289}},
   {{0x0002522cccc18ad5,0x000da1a6e0277973,0x000c2354daadf3f8,0x000689a7382c9317,0x0000ce1680d2818b}, {0x000bbfcd9ecbee97,0x000bacae62ac359e,0x0001ac38a4330689,0x000ee8455ce5b4c5,0x0000921dfeb6e238}},
   {{0x000bef8271d1ca55,0x000798aabd183972,0x000a3e5e33e423bc,0x000d6607b09f3f44,0x0000da886aecb444}, {0x0006634a99643755,0x0003199cd0ff6820,0x000a515e9356a2fa,0x00079a5f0faa24db,0x000036e1f5d0321d}},
   {{0x000913a5c04e4ea9,0x000e46f11513d3b9,0x000fd1d94d549dcf,0x000c675e227bf579,0x0000f35afef443f2}, {0x0008d24f1314f53b,0x00081abcd822d263,0x000f48db062baf94,0x000bb1a542de294e,0x00003eb6a05ac5f6}},
   {{0x00010ae1208e16aa,0x000558363e2423c1,0x0004be00b1a4d15b,0x00090c9071684416,0x00008e2482596f46}, {0x00073a290b170cfe,0x000062f191f45487,0x00047aa97a1bef33,0x00014690f418d092,0x0000a06028f28be9}},
   {{0x00022f3dbfb894e2,0x0006ae274b18e131,0x00058aadfbe9b79f,0x00035165a49de5ca,0x0000495775831487}, {0x000ef61bb9390993,0x0009f6d13694111d,0x000fc253b1d6a974,0x00015e1474b4ced3,0x0000a1485e67c5db}},
   {{0x00067b4147c15b45,0x000b2bc61301e796,0x000094381e34f553,0x000a20b32b80f817,0x00005d8bafdc23ea}, {0x0007995f1c0e74e9,0x000e5bba289c5a98,0x0004c82515a9b292,0x000b09b13cd4b2eb,0x00008b5d2446162d}},
   {{0x000bf66683425204,0x00097aa862d1bb47,0x00006abcd08d6894,0x00000dd1f349c7e9,0x000054ce9862d7bf}, {0x0005c9eb55b803b2,0x000a11e3c16dacab,0x00073bf12b03468e,0x0008873c24213dd2,0x000011538eb91587}},
   {{0x0004a2f731dea2d9,0x0001e4ed7b2a198e,0x000a664fed5856cf,0x000290f6a632eb13,0x000032cd90a4da41}, {0x00095d4c0c4ddc0f,0x0007447fc2c9850e,0x000076bcbc0f422f,0x000285f68cbec486,0x00009e7c0c1bd6cd}},
   {{0x0004ddb0f5f27cac,0x000ae80d59ff6599,0x000601023e85461f,0x000bfb3f05481a66,0x0000665427bbc9eb}, {0x0001a697587fd52b,0x0007dd49efceb057,0x000420688935289f,0x0006aeb1becc60ea,0x000022639d9c3a78}},
   {{0x0006220361ecf90e,0x000f455064631a8e,0x0005c2b79001f23d,0x000db504ae9b5d0a,0x0000bc9cdaeb8149}, {0x00064a1934aa7289,0x000e1e9b60f3b331,0x0009cfbfd750eb00,0x0007f5ca91615b9b,0x00007015cc07f45f}},
   {{0x000c4a5bf5151dff,0x0000c07118f2b462,0x0003fa42c21adcc4,0x0001aae60c545b04,0x0000c21aa55d96be}, {0x000c32f4e51ea80e,0x000f459b5d8de84b,0x0008f1b5e3dae45e,0x00017cdb73c7ebc3,0x0000405a74bc8ae6}},
   {{0x000e9c69f1c56bdb,0x000799f196a4bb1a,0x00075092b8c176b9,0x0000331448f31168,0x00005afe3df4f976}, {0x000fd49145813e50,0x0009e2b34226a8da,0x0007ff57f687fc4d,0x000b46f2dfc92d4c,0x000004e3fc1401f1}},
   {{0x000dab61430c9ab7,0x0002b238e9975afd,0x0008042ae0bdd41d,0x0004cb8094743041,0x00001f9addb3dddc}, {0x000c016c52dd907b,0x000c79e2047f7090,0x0001011a6d9bdf44,0x000c7836f1fe801b,0x000063accbd89acd}},
   {{0x000e2351272a95b5,0x000756276ac8cfc7,0x000d7eef70c66771,0x000b3dec0d3709e2,0x0000add2b06ea685}, {0x000d32d14ea5d65e,0x0005ad7dd506363a,0x000b4aac6f8e01f0,0x000465e9ea221375,0x0000d2a2bf9ed353}},
   {{0x00079b5e9d3a7c31,0x000671b7f34b439d,0x000c4ba758e0ee5a,0x0000c7bf3dacf51d,0x0000d3d1773fb331}, {0x00071127747ae836,0x000fb97d6b40a8e6,0x00096140031f4315,0x000767a521cceecd,0x00007246f1256535}},
   {{0x000cc5aef0c31335,0x000d2e16693b702f,0x00029b749247cc45,0x00020fad484e49c7,0x000022cef7e02183}, {0x000f40559ab93b3c,0x0000df181071e56e,0x000330ed0225fba1,0x0002f673bd659515,0x00004be69d5dddb3}},
   {{0x00076680448087c4,0x000f31432dae264c,0x000f9bf47ac30903,0x000d02f851b26600,0x000000ed311acdd6}, {0x00079fef8fd24247,0x000a8a6da98b045e,0x0001e673afdfd974,0x000167d5c9f6410c,0x00006f2e733cb2c5}},
   {{0x000ebb52a6017539,0x000c357c2d491ada,0x0000bfd24b286514,0x000922487696701e,0x000050c547e94478}, {0x0001969e5d32bfe8,0x0001f50d6c3ed1d4,0x000e27f3a30bc147,0x000e0c0f3679fee0,0x0000f64a7dd24a6e}},
   {{0x0009937633dfb1fc,0x0004d77f25472fe5,0x0001ea646ea82c39,0x0004510bdfdf1a66,0x00007ccc59279085}, {0x000796281761e131,0x000f8196885c8217,0x000ffbd70da57596,0x00036fac17e84928,0x0000e6e0a413671d}},
   {{0x000872c4152fcf57,0x00002e77e75461ae,0x0004dff09441c87b,0x00017160799dd5a3,0x000066b4e44f8a6b}, {0x000a51211f1c7924,0x00030be35c3edc06,0x0000c469eea02ae9,0x000f5ca5ca4d6de9,0x0000df4368e96e4f}},
   {{0x000acab4baef62e3,0x0002785b91e87817,0x000e576109f5a220,0x000e036666ebe66c,0x00002ad31f4273bf}, {0x00030a425bcf4d6c,0x0002915056e66283,0x000332156ea95059,0x0002d699811c89e1,0x000089cf1ff4c11b}},
   {{0x000391304e60cc0f,0x000c5625d37575b6,0x00026e562ce811e8,0x00069f130e43fc2d,0x0000bb30b4c508d3}, {0x000f82c485281182,0x0005ad285911634f,0x000358f287c6fe08,0x000c095f2830c099,0x0000e60a95e865e6}},
   {{0x0007d3d9b785dbf2,0x000b8759bce70840,0x000f61239530889a,0x000e3cd228e0e652,0x0000b6d14618879b}, {0x0002c0451a7bbf7f,0x000f86f24a64e690,0x000bc6da030ad99e,0x000abf76d9317a98,0x00004f877f4bb596}},
   {{0x000f62d4c44f1190,0x0006e9b77416b05f,0x000aed63b4555f53,0x0002a9c7c0d0598c,0x0000cd2b7cec358b}, {0x000287b46945fa35,0x0000867c87913f33,0x00037bd08f8785b2,0x0009d7754a7a6196,0x00004d4598c68be7}},
   {{0x0005acbc46d7ce17,0x00071b085877889e,0x0007a50509a515bb,0x0000358ac1a03d0b,0x0000d3e738b62926}, {0x000c2ce2a6cb0ebd,0x0004bf7adc79861c,0x0000163766f2e295,0x00008f91c4d45133,0x00009fd2c812ad59}},
   {{0x0003738b2b836a16,0x00001c0d6622e5a8,0x000c19af1855b41a,0x000acab86fe3177c,0x0000465c2005dd99}, {0x000c23f6974b99e0,0x000ba2717cbe46e5,0x0002be65875a7cf8,0x000c984d2ebc3f06,0x000094b44475f209}},
   {{0x00085edb940cb5af,0x00018cc82f104af2,0x0000526fa6706d79,0x00013fd8c8776c03,0x0000a8e6f7790da9}, {0x0009d34591ee4f0d,0x00067027416677ea,0x0006714575f46e33,0x000fe14bdf98bbea,0x00007c08b47562a1}},
   {{0x000303c1c08ad635,0x000ffc845e7b46cc,0x000f36bf79954343,0x0003a6cb8fbdb548,0x0000b82c392dc827}, {0x00012c4928435d5c,0x0000b933038008f7,0x000da054a071cf0f,0x000b5c074c2d24a8,0x0000b0e720203c46}},
   {{0x000337ac0b7eff35,0x000e75e48b3c0ad7,0x000f13a5f8552225,0x000cbe96f78b0c73,0x0000e70062ed2349}, {0x0005048e7073969a,0x0009233cb3d26b8d,0x000caa20f392d2a2,0x0007074e4f727c4e,0x0000068c99ecccde}},
   {{0x000651fb87a29137,0x0004ccc252f0fcd5,0x0006cd3e4ea3e3c1,0x0002e7077d92df3b,0x0000a41414435a73}, {0x000951aa71ff4939,0x00022bd37cf6a895,0x000cfeefffe980c9,0x0003e8b5bd5e64de,0x000010dc2aa344c4}},
   {{0x0003f26cca9f54d3,0x000b6303f6dbcb40,0x000eee67c928bbdf,0x0001c30c37951ea9,0x0000bd61a5327996}, {0x00038e6395c9a791,0x000d51eb352d09a2,0x0008756316940ca2,0x0000d16d1e5c5ec1,0x0000e19742c2e1b2}},
   {{0x000d90823fc2e6e0,0x0009089591494633,0x000ed7da5a76e29a,0x000d5161069d9c84,0x0000baa11cf5dbca}, {0x000ec64961849da5,0x000f5f3d8c28d01e,0x000a2ee4493b75f1,0x00055807bc4f9f1c,0x0000a26322d50e00}},
   {{0x000d65861a023efa,0x000419e5246e1888,0x000563ec01d72aab,0x000a4309a26348e5,0x0000097196463439}, {0x000d54badb9b5b76,0x0001645a524b567d,0x00038e60873fac1a,0x000f482fe97ef7fe,0x000008748d29f384}},
   {{0x0001794c486094f9,0x0002fbf3a8d6b057,0x0000b0e25869254a,0x0007d7848a8dd131,0x00009ab9f402aa3f}, {0x000c68a6706c02e5,0x000c19790e6c0927,0x00071376c22b5e76,0x0006571c3252606c,0x00003a5769059ef6}},
   {{0x000f852edffcf3a5,0x0003ec0a6f558d63,0x000519b9eb4d2ed0,0x00069a8b3aa8de12,0x0000d38e9c46e0a5}, {0x00028bf303747e2b,0x000c45b5c18d8715,0x0006bf923a208e77,0x00039eed129c88ca,0x0000cbf19806f028}},
   {{0x000f030273231941,0x000b239ca59d9b9b,0x0006695203b055a8,0x000f24a46b23120f,0x00009789f1f597e5}, {0x0009468aaf018013,0x00005b69d59c9c49,0x000f4c07972ee119,0x0000485bd39595ac,0x0000ee11ecebe0cd}},
   {{0x00086ec1ed66f181,0x000bc61fce43ebde,0x000bed74d225d906,0x000ab74cab07d6e8,0x00006e4617f37855}, {0x000aaddb2fbc3dd3,0x000f5aeddf5b6568,0x000cf2fadedb5484,0x000699578f20e86d,0x0000516497c915f5}},
},
{/* digit=20 [{1,2,3,..,}]*([2^140]*G)  */
   {{0x0003fecfa181e695,0x0000e0d69a98ef0a,0x000eab95d9ea02f8,0x00002162e9cf8e66,0x000020f2beb74720}, {0x000540a1df843618,0x0000f1fa6d5d621c,0x000f5f6ff1203772,0x000ef2ee3c7b510f,0x000017a069c2bb2b}},
   {{0x0002fb6b294cda6a,0x000519039f348357,0x0005cbb216ce9bf7,0x0000d980e012f009,0x00000aecc1c7063f}, {0x0001c3af02909e50,0x000f48ce9cdc57c2,0x000e336f8c7d59ec,0x0005f42732b8448a,0x000056e37233f4f8}},
   {{0x000b53189e800ca4,0x0006d45208fd8a10,0x00014ba3750fe0c1,0x000acc5e43c0d3b7,0x000027d200e74189}, {0x000e24fe616e2c00,0x0008ee1854c105de,0x000342a739c25f4c,0x0009524d3222a58f,0x0000807804fa027c}},
   {{0x000653a4f0d56f34,0x00078a28b805c222,0x00073434b961e404,0x000a18ec03f8b04a,0x0000c966787eb712}, {0x0006c42864fee422,0x000a3b0ece5ccc19,0x00031c159c1be93d,0x000655887d9f22c1,0x0000bb6d593fce45}},
   {{0x0009ec9b809b7ceb,0x000b32c72c2c22c4,0x000a0bf368a41486,0x000c68d13b9420fe,0x00003d36eea566da}, {0x000c08a328cc987f,0x000b4a3264616fdd,0x00010dbba0a3bcd2,0x0004c38103c49dd8,0x00009d81a293b78a}},
   {{0x00065ade4d559419,0x000da03840873de8,0x000f18b9bdedafa5,0x000267df414abb4e,0x0000ee9ea438aee5}, {0x000aa1637a55a4a5,0x0003b15f93b9260f,0x0009c3598eb19a51,0x00078e01d7ebd29e,0x000023fc56d69321}},
   {{0x000070cb98fe684f,0x0009224a1458501d,0x000bc6b3fd60fbe9,0x0007cab45761c892,0x00005384859ee6f2}, {0x00071f7b59e763bd,0x00088b5a8e5e4b02,0x000a482923d4606a,0x0004454eda5d9b05,0x0000a7731d1b6fec}},
   {{0x000369390d458714,0x000fc6166d8da3e3,0x000a90403e976403,0x00063775c3368289,0x0000bd17983b2f1d}, {0x000679ed5d2c53a7,0x00088dcf3b87a616,0x0006a694e5ec4bcd,0x0007e53e6d7613b6,0x0000460fc7753fc2}},
   {{0x0009b8295caabee0,0x0005889501e37046,0x0006ed265de024ca,0x0008b26bdadc0607,0x0000cb1236b5a0ef}, {0x000ddbf0972ebf9d,0x000452aca4324065,0x0004aff76f1dd387,0x000d23d88b97cf74,0x00001359afece8e3}},
   {{0x000ba2b91502cf37,0x0007984db75d52a3,0x00030b1c92c3832a,0x00060b94a12dddde,0x0000802eabd531fd}, {0x0007327a37fddab7,0x000b8aafa9733370,0x000e6f91a65d6f2a,0x00030ac525c5b811,0x00006aeb0c9cf465}},
   {{0x0005ff62f93a6750,0x000405f48679e881,0x0008ae884a6ec968,0x0008736dcbb55635,0x0000af61472e19e3}, {0x0004372a5f696be1,0x000a5f22fb707233,0x0006cea90c65e57e,0x000b2a168da30c94,0x000036a8a8775681}},
   {{0x00081dc0f9f44d43,0x000ffc46585aad5e,0x00047d1b1f09a695,0x0008b1a1649164c4,0x0000b4b36c8b79dc}, {0x000177b3b6b234cb,0x00046730d9d020d4,0x00080531d096a250,0x00095c5611b9b8ef,0x0000a904b3c14bb4}},
   {{0x000d9d493a3147a2,0x000c7a5655451192,0x000f072129f30a5d,0x000c1370b1f9cb6e,0x000099585462d87f}, {0x0003effc17db9ba2,0x000cab1644a8d332,0x00049ffbccb18548,0x000683f8a306d44f,0x00008d658f16c2e8}},
   {{0x00060cda99f8c71a,0x000aabf742ff44ba,0x0004b3f9967b7abd,0x000160c6310f9c91,0x0000e430a339412c}, {0x00076d388ace52f4,0x000412d7067d1e67,0x00007cd1b4bc0fa2,0x0002c0c3c286aa8f,0x0000cb8f38ce985b}},
   {{0x000be808c3bff364,0x00021263e57583cc,0x0009bdcd1005a0bd,0x000b6b060d7dda25,0x0000a1c56433a5ca}, {0x000dbb99fe4fc88b,0x00081c97bbb52b7b,0x0002321ae09418e2,0x00064e28274fb4a1,0x0000137007e0c87b}},
   {{0x0001fe1c63c4962c,0x0008d81fdb258053,0x0004c2b6b50541e8,0x000fca1c1291a1fd,0x00000693a1866df4}, {0x000604e0117f203b,0x00025a99b8d0b2c4,0x000212c44245f196,0x0002a7fedc20aac6,0x00001ed4e57020f5}},
   {{0x000f575f8547be3b,0x000cf9e45f98fe48,0x000c501000a7033c,0x0001d99b45d3a918,0x00002a6cd6b561d4}, {0x000b4f557933c6b8,0x000cab0d7ffc60bb,0x000d626b6a7538eb,0x00025a1ea3ab8d8c,0x0000273a484b6016}},
   {{0x00098450168e508a,0x0001f9a94abd8885,0x000b0a6718cbc9bb,0x000ffbd13ac792fa,0x00003995b1a0c9eb}, {0x000668e1239e1525,0x00086bb8dff4e711,0x000f179635689255,0x0002533bfc7dabdb,0x0000b59fe5b03de1}},
   {{0x00020eb34a9f7aec,0x00021751efe47e33,0x000be2f37e5e8cf7,0x000ef6bea003bcd9,0x00000f551a176c08}, {0x0006268038f67254,0x00052d92d3b65660,0x000cbd6861dd38e3,0x000da7c7dfce7cc3,0x0000e549e04a51c5}},
   {{0x000f93b08b193400,0x0004cac6d89d4058,0x000159cc7c2fae6f,0x00001c4bad8a8c8f,0x0000ddba4b3cb0b6}, {0x000c7b51dd95f8c7,0x00075ea5c255da4f,0x0004a8c4c1d163cd,0x0009cdc0707d0627,0x00009d9e0089802e}},
   {{0x0009ebfe6ddd5053,0x0004850bed1a02a2,0x000327d5737064e7,0x0000bc0f6bae65a7,0x0000846f5f228392}, {0x000749160df1b9b3,0x0004fd1da29f87c3,0x000d1743c4cfb289,0x0007c5e0a478ca4e,0x000090c60306edd4}},
   {{0x00053128c0a78de0,0x000a1e85df708f3e,0x0001b6582ccd02bd,0x000bd1d6c75c03a6,0x0000762921cfc0ee}, {0x0000823d85010c02,0x000ae044cf1fd34d,0x000b5e78ad73aaac,0x000f3fdb4159bba3,0x0000287c7f805826}},
   {{0x000f742580b1a014,0x000d20423b794aea,0x000dea144f080415,0x000472a12622cda7,0x00009ea499699d62}, {0x00091ef571f3913f,0x000405b25a8ab429,0x000b79e8f0610f21,0x0005a157adc58530,0x000090e3df6f7a06}},
   {{0x0005deb43e2e0349,0x0003b44024aa5d0a,0x0000c9f7f53fb5a3,0x00065618628c686b,0x0000c69c29d3c563}, {0x0001febbace47b69,0x00090ea5a2ec5a23,0x00063853ebdce028,0x0008a975da1fac94,0x00006812c52e09e7}},
   {{0x000577157151692d,0x0008098e1c44d3fb,0x000399be1eb2721f,0x0008b7f050608732,0x0000a5a5512a979d}, {0x000d55dc6f567809,0x00037dc7a7f4737e,0x000941a03e20d300,0x00083972ce7301f5,0x00001ef52167d30f}},
   {{0x0007fc14092d85f7,0x0005ec49e41a2872,0x0006a4d8172d223c,0x00087d37cf30a2ba,0x0000c08620a2030d}, {0x0004c7dfc588b090,0x00095874bbb00484,0x0004c0495728cd49,0x00058fcc1281eee8,0x0000769b5baec319}},
   {{0x000228bf99c24714,0x000ad91eb110665c,0x0006d7024f2d8a11,0x0005a10594f494d3,0x000082ded8c0dcb2}, {0x000a9d8dadd48854,0x000eb1d2b547c958,0x0000af5507004477,0x000350ca45f6ef2a,0x0000fc739d66f8d6}},
   {{0x000af27786f08a98,0x0005c2c2737f75cd,0x0004e26708700bb2,0x000fef055a71411c,0x000010188c195076}, {0x000d0c9abcd3297f,0x0007048108ebc251,0x000ceed30ae4c896,0x000ceccd146de718,0x00009d4f07bb986b}},
   {{0x0008ed583fa1e08b,0x000e0eabd1fb5ad9,0x0003b11967780d33,0x0008c43330513c90,0x0000a11de9f547bc}, {0x00034da02c2d064f,0x000cb48de23b6843,0x0009089d87ecf360,0x00034b67a1b4740a,0x000028fa43aef367}},
   {{0x00082cbea4570b35,0x000b55ebcee9f2a4,0x000694cd5ee65d68,0x000d32488d0036b9,0x00003edd0e987885}, {0x0003307beb9bc6d2,0x00077f5c6768e37e,0x000f2160fe9abb90,0x000da62396ccd551,0x0000500888c67336}},
   {{0x0009ed9926fce430,0x000704da2930383f,0x0004cb227809dd1c,0x000b3830f6f5968a,0x0000d700c7f73a56}, {0x000ea33ab64a0652,0x0004f338df801825,0x00063f57faab9b73,0x000633f516100d9b,0x0000574395a47a6a}},
   {{0x0000fb6700a1acd0,0x0003fd999681b556,0x000b4e1bae823fd7,0x0000a3da915d1f6c,0x0000d0301186ebe0}, {0x000b0c989fca8cdb,0x000b49da0e0b744f,0x00031d76f970d01d,0x0009695ad8c56479,0x000015737c0a659b}},
   {{0x00033e8a8b484e77,0x00090a26dec7dc99,0x0001f0136b2fdbdf,0x000ddab349e9a49f,0x0000860368ee0fdd}, {0x0002c1cf9ad3e183,0x0007389f4e79d93d,0x0004ff1b66d6c5f1,0x000d8c4a544d91b2,0x0000e12a5ec2e16c}},
   {{0x00074e9a56b872f8,0x000c7cf68ea25435,0x000560ef7a1ad550,0x000a8ae89e37d23f,0x0000c54b9cb49d47}, {0x0000a4a088ac342d,0x000b4576c6d046d4,0x0009689e9ec450c7,0x000717e589e31c1f,0x0000acf260388781}},
   {{0x00037c6c8cb6b42a,0x0003196ef381a892,0x000f078251326fc9,0x00022cb5d56c6db5,0x0000cba2eeb1449e}, {0x000887a633c30000,0x0002d7cbcf7174e0,0x0006cf1becb6cd17,0x00099b309e81dec3,0x00007a18a6d60ae3}},
   {{0x00026799edce57e9,0x00044f001d41b36c,0x000a1f2c652b892f,0x00070a4884ae5d16,0x0000b3294257fcc3}, {0x000daf2bd2e21df5,0x000cb2470a993120,0x0005db32e55298d2,0x000635bb78af6ca0,0x0000c76a331b01f5}},
   {{0x00061fff8a4f29c3,0x0000a68f8d49aae8,0x000b1321c70dc924,0x0004ce660e649f81,0x0000d2c801bb792e}, {0x000f772425218760,0x000c416c79b1f479,0x0003e5bc90bed93b,0x000049a67fbc0526,0x00001e8e630521db}},
   {{0x0006738c6f3431e1,0x0002d326754176f2,0x0008c877ce609cb0,0x0003cba10cff2d81,0x0000f0e75ce886a1}, {0x000ca641158544d7,0x0008fcb71ed0f4fd,0x000aa47555d777e8,0x000b3fcc233737a9,0x0000b4531935527a}},
   {{0x000f68839f05ffea,0x000fcd82574edb59,0x000292d1b8f4f4bd,0x0000862ce3450cee,0x0000a448a1301ccd}, {0x00091b3f7914967f,0x000a2908a5edabce,0x0001042e74537f09,0x000a33b812421ef5,0x0000af5cebddc0b3}},
   {{0x000fd874ca6b39ac,0x000c42efd342730f,0x0005c8edb70fb72e,0x000a512b4735f9d7,0x000011f21588278a}, {0x000f635bf3bfebf3,0x00043bd9601fc459,0x00020cb733a1ff0b,0x0005a399d12823c4,0x0000e9af3e26c291}},
   {{0x0002c72b41c34403,0x0005b3039a5fe0c8,0x0008795a3175239e,0x000c60b1084b8a55,0x000028d0a1e001e5}, {0x0005f2ed3788a049,0x0005d6c11a9f0a49,0x000d692d625d8ff1,0x000fe465155f059e,0x000054fa107df425}},
   {{0x000abf2e98aaa995,0x000046b0f88ad16a,0x00054026a90cd8ba,0x0006d2457f4782c1,0x00004ee0734a2af5}, {0x0009e5445b4147a9,0x00010a52816cbcf8,0x000b62e773d102f2,0x000ad7d808517e39,0x00002e25421f9169}},
   {{0x000d871bb608558c,0x000e36d4ff9bd721,0x000f2763e60e4eba,0x0002464ba1081941,0x0000a2e45bf11ee3}, {0x00072ec2bfd7a5f1,0x000f64d0b12d66d1,0x000be70dc528a8f2,0x00083cd17f1e38da,0x0000d5d7316af939}},
   {{0x000184adf423e315,0x00015edb1a1051b2,0x0005bcab9cb41729,0x0008efd054ca9362,0x00004396860f9899}, {0x000f6c4a54ae57ef,0x000ffe648e9d4e53,0x000faf6bc0ffeb58,0x000b8a0bbdaadc6a,0x000088ae7979a3bf}},
   {{0x0001d44d2359ed9e,0x000313544ce2209f,0x00051e569ac68dd0,0x0000971378da47fd,0x00001abd8610cc80}, {0x00018d9343b6e3a4,0x0008740a1bae23ca,0x0003f3e67480797e,0x000dfc91f0c71753,0x0000489697046e6c}},
   {{0x000105552a82e8de,0x000498460cdc8ca2,0x000037178b2caf78,0x000b576c1b7b62e9,0x0000fc09d2dbb514}, {0x000f9ee9113be5c0,0x000fb3f9271c5f2d,0x00083fc542fbda78,0x000141e09a81af8f,0x00006b138668afb5}},
   {{0x000480f43e3865d4,0x0007dddf47d938f6,0x000205ff772dd77a,0x000ad8b2a8e9714c,0x00006d449d8dd088}, {0x00019ea185d706fc,0x000b07dd7f629266,0x000bc2031e47e02e,0x000ac927f120a78c,0x000018bef01598d4}},
   {{0x0007a9c6bdf22da8,0x000f10dc82df18f3,0x000703651efbc432,0x0001a5452cef8e5d,0x00002887ba159988}, {0x0009ddab920ec1de,0x00030c3e8d3b7cec,0x000a88747d0d7e8c,0x000534645bc3954c,0x0000deaa2e17fd53}},
   {{0x0001d936cc874756,0x00020d2383bd461b,0x000903546d92a52e,0x0001129abccb59d7,0x0000111a7619d14b}, {0x00084feb3d5f6126,0x000d00e828ec0ae5,0x0000870305ea69b8,0x0001fe0c07898554,0x000049cab050c482}},
   {{0x000edcf8bdce214d,0x0001b6af736125ec,0x00038b9e2b5622f7,0x000a763e1227aa70,0x00000efb2747c20f}, {0x000f88b79df975b7,0x0005a999503e817f,0x00038ec46856bf28,0x000f6e44d5351f50,0x000040a52c66c42a}},
   {{0x000bb152cbb1a3f8,0x000d97a834292e38,0x00066bb74c3eb99f,0x0008fc4a4fcbf1dd,0x000080784d74de5e}, {0x0004c1cb4e7a0be1,0x000dad15a72fddc8,0x000ec30e18780510,0x00073e34bcf1af81,0x000041e50a81a610}},
   {{0x000571847be87ae0,0x0007f76a43720d95,0x00007c3d368a6141,0x000332f57e7e87c6,0x000043afaf85252f}, {0x000e1211552a4d28,0x00023b4d4ab4cc14,0x0003816a4b6dee69,0x000a2936ab74c8a0,0x00004001ae4ef394}},
   {{0x0008344d795fb455,0x000d679f55a55bed,0x000ccdffc57326e7,0x000a0479533ce04a,0x00003473caf8993f}, {0x000eb93a13df4c82,0x000677cbe46f7906,0x000e4ccf8a73e51f,0x000dbcb1ab3ae10a,0x00005614508aa5b3}},
   {{0x000f96211a71b27b,0x000abbb7fa3961ef,0x000d7f3efdf71412,0x000d29031ba6b82b,0x00000b9c41619180}, {0x0004552014cdde5e,0x000a427b4bbbeec1,0x000e988f3702c624,0x000d034b15e8c2d3,0x0000e3bcc6e84f7f}},
   {{0x000822a42ac6c853,0x0005edf9f2b79d00,0x000de1e582db0cea,0x000b61a7cad2ab42,0x000046ed5265d6fb}, {0x00029951a2faf097,0x00000c25612eb396,0x000f564902fa8a58,0x000960c0ae04da7c,0x000056629087eea3}},
   {{0x000f5c53d080847c,0x00089241d4f63609,0x000961a63cb081d3,0x0006fbf4fb381077,0x000020c5984eabb6}, {0x000aa7cf902f245a,0x0005ae536b1e3d40,0x000b3134f9cb1273,0x0001aebeda24da99,0x0000fbd9c69fcd01}},
   {{0x000e30ac7088c7d2,0x00001207389f9a16,0x000407a535ab6571,0x000eaafb09547fe7,0x0000322f9d76fdc6}, {0x000f22d7430de4de,0x0006068ca9a9c0f2,0x0008e58681938269,0x00020337f1eff191,0x00003b5b636386f4}},
   {{0x000f9803fbc43419,0x000fcb5eed4e146e,0x00082e41d359f2c7,0x0004c20f35744e74,0x0000a9ac3ed83b22}, {0x000a6fe91fc50ae7,0x000b5613fa7c9161,0x00032f15a89ccc66,0x000d0319268b14c7,0x0000cd6f4e32467e}},
   {{0x0009869ce56b40e9,0x000c302dde98fbf7,0x000ee2cd7f93e094,0x000d425fe0c3a8ed,0x00000f3ffc14268f}, {0x000fd5608241aedd,0x000730b1afe881a7,0x000310d5295ab7ad,0x000c42701270563e,0x00003ffdeb1d9d9f}},
   {{0x0005c91d11a8594e,0x000751cf6db8c8f8,0x000b5dfd02e74d25,0x000c85a29c7ca302,0x0000389cfbf49143}, {0x0006405941768d8b,0x000453bf825dd01b,0x000cd17e24510399,0x000e791c4ee16656,0x0000ea3c2846a037}},
   {{0x000c06ed9a475207,0x000a3f8524044e1a,0x00087648afbfe18a,0x0000d8e615f8e280,0x0000301e47f29d15}, {0x000f9ddb299b9777,0x000b35b7831479f9,0x0007c90e776697a7,0x0000b4a0d674687d,0x0000afffe0403721}},
   {{0x0003e4b28c22cee9,0x000779fd55ae5aef,0x0002a5d6aefb0ecd,0x000356bcea71320d,0x0000cfb5fa191db6}, {0x0000b57f36e1ac55,0x000ce6cafb7d395e,0x00008c4db008fa9a,0x0004773f6cdf7053,0x00001527a37e5ed2}},
   {{0x000ee305bd213110,0x0002909c90d7ba0d,0x0008696d36ed41b2,0x000a80c5f6b7587c,0x0000db8eaa83ce83}, {0x000fe37b24b4b6f6,0x0007f22d1f0dd297,0x00098dbd9fe58afe,0x000527373587368c,0x0000bc226caf454a}},
   {{0x000384ece53c2d04,0x000d1e4606daa12b,0x000ec12b0779d897,0x0001ad653e47b073,0x000062dbbba9756f}, {0x00009f2cafe37b68,0x000f6cce2e1769fe,0x000f607fd273d1eb,0x000c250ac1d5383c,0x0000035f7ff92e10}},
},
{/* digit=21 [{1,2,3,..,}]*([2^147]*G)  */
   {{0x00034c77e6c55202,0x000fbcb9ea58854d,0x00086666dc27df9e,0x000a85205f2369d6,0x00009d1febf2417a}, {0x000819e93470afed,0x000912a27f9e9846,0x0001e65043e6a966,0x00080954d008a2e3,0x0000ba7ced06cb76}},
   {{0x000f541338d6e434,0x00030541d5ccecaf,0x000bc88ca56f7dd7,0x0002c375d426de96,0x00008d94f6bded3a}, {0x000a3bb2ef8279cf,0x000a1b1867f26354,0x000225151d575465,0x0000d7ff99b0ff95,0x00003e19d89e9450}},
   {{0x0003268e32dd620a,0x000ec27849a292a8,0x000378882913ec99,0x000cfe4dd8fdfa2c,0x0000f96f33f8e6f8}, {0x00037e5dc3fa8a51,0x0001a0b03a1dc067,0x000f037b0236bb53,0x000a5323e59f2989,0x00003f9b5a7e9a12}},
   {{0x000f6ce51efb3108,0x0004158df5be0d0d,0x000158e59cb5b2eb,0x00033656459e2936,0x00002aae2b99466e}, {0x0008a39411aa636f,0x0004e4c0a933fb65,0x000f026b77152ecc,0x00011f010c758a49,0x00004837f98bb093}},
   {{0x00002c4c753c45fb,0x000649c840feddfb,0x000f8a3e618ca81b,0x000dbbd46fd09ab0,0x00001162ade97733}, {0x000ad20236e3ab64,0x000572a563267070,0x0007cbc7af88cdaf,0x000271c5fc871999,0x000042cd4528b665}},
   {{0x000f364b71698f58,0x00021f7b605e7807,0x0003b2cbb6ba418d,0x00086f7d20b00fa0,0x000083eca385a543}, {0x000e43ff3437f24a,0x0002048bb33cff0b,0x0009df765e910b43,0x0006f6a963a12832,0x0000c1dd5575e2fe}},
   {{0x00010f924a0a3fcd,0x00041881c3f95576,0x0000dac9938e17bf,0x0009179ba84fafed,0x00004a222c429eeb}, {0x0001dbe13f542b66,0x000d8425d457c79c,0x000ebb7791fc65e0,0x000f608ffb754f1d,0x000038d8fd0fe08a}},
   {{0x000523a626332d5d,0x00028561bb44994f,0x000845ea27bc3883,0x000089305ed4b03d,0x000039d3ee292a1f}, {0x000fdd3e7676b0dc,0x000f3b7060176561,0x00064f9a8620e35f,0x0001f676ce424ff2,0x00004c341a09a268}},
   {{0x000fd2f69beb6e85,0x00031d700d03fb6a,0x00083a14f3a50b99,0x000bef7840b2ad0c,0x000073207bea4085}, {0x00082e309fe7e5b9,0x0003ab40a7e15af8,0x0003056e2957678a,0x000c09872d4bdd54,0x0000c1b26b49df13}},
   {{0x000861cf405ff065,0x000cf86e828b1c30,0x0006933fcebac86b,0x0009479791a97163,0x00000e7c2becaeee}, {0x000a095fa90d7679,0x000b5670ab7bc3d4,0x0007b056dae60eb7,0x0002a987633a6439,0x00003a21f33a0501}},
   {{0x000370babb886433,0x0006f2e21599663c,0x00076167191df36d,0x000bf0e83ba8358b,0x000081eea1da28f3}, {0x000f1ba39966e6ca,0x000847295492b9b2,0x000b26b7f7c464a2,0x0009de6fd5f70a09,0x00009aba1fa9be00}},
   {{0x0001f22369b87ada,0x000892fca556857c,0x000b064663c00e5d,0x000af17ad74cab90,0x00007112386f50fa}, {0x000e1986d9bd5f51,0x000849c3463f7435,0x0007bd4b22dcc7e3,0x000f31cc7df748ca,0x00003cd4c08adec2}},
   {{0x0005df8e32377106,0x000e6bd2f7b00d3b,0x000aa082b0dadb26,0x00066e3f5966abe4,0x000066ec8de950e9}, {0x0001ed5ee5242161,0x000b31dab0b61bfd,0x00086d6bacd93c59,0x000195558a8435d1,0x0000b7d34d2259d1}},
   {{0x000e46022caf46b4,0x000f5a96fe4f5936,0x0008f474e6a45dd8,0x000f15b7925434b9,0x000014104124053e}, {0x0008d1241de97bff,0x0000cd80bef471cf,0x000db0037b8547b6,0x000dfec47d3970c4,0x00001bcd329eef20}},
   {{0x0002e0910caad676,0x000ff531a1e131a9,0x0004fc8401f59195,0x000c6bdbb852e05f,0x00003e297caf3a72}, {0x0000b2e49abad67c,0x000c2d3db0d93c2b,0x000ef1d406ec405f,0x0006fc1c14a5307f,0x0000cd19846e8089}},
   {{0x00031769bb816483,0x0005353120d000f8,0x000cabc62d69eb48,0x000cb1a17d75f44c,0x00004a07f82e749f}, {0x000f787bbfb55541,0x000052e283f82c3a,0x0009213a0b06ed4d,0x0007b44722889fa1,0x000062b085eecf3c}},
   {{0x000cb31e0dd3eca2,0x000cc52f13a5bcae,0x000bac297c6237fb,0x00054aac2b6b0327,0x0000ae1cac5d917f}, {0x00007d47845ae4f6,0x00026e5972e04748,0x0007915bbfec7dd9,0x0007ca63bd25411d,0x00006f85dc539490}},
   {{0x000b888bdbcf0ca3,0x0006af279e9fd981,0x00054e934d75f5da,0x00034ae28bbf2470,0x0000c6ff6e5b1db1}, {0x0007cf4047d26e4d,0x00078049ec37795b,0x000d945aff370f7b,0x0002bbf6712d4dce,0x0000f30b5ecd9564}},
   {{0x0004c624896246e5,0x00069e90bbd19b03,0x000fedb735652c01,0x0006139b38636f87,0x0000e32f8475135a}, {0x000b312cf933c835,0x000dca7f47e60703,0x0009c2415d05bb76,0x0006f8325e4f0c94,0x000069e5622c250d}},
   {{0x000eb3a6568013e8,0x000ea2f243fcbbe9,0x00042734a8dbd203,0x0009841dbd7694b3,0x0000f6d12f8c6afa}, {0x00010a2c9eade291,0x000337dd0f18b986,0x0001c0d46bab4f32,0x00042a4779737b67,0x00000b6a7c6e3e0a}},
   {{0x000ddf33035b41cc,0x000ed9c45895fb19,0x000c857e5d336343,0x0007d4a1fe493854,0x00004d506bf6e4e5}, {0x000c8cbbbc33f758,0x000a1262c77d3cd8,0x0001a28237281f08,0x000e32883f4ea6f1,0x0000895041f1fba2}},
   {{0x000ea499c438edfc,0x0002d1edba44fcdf,0x000ba50f07678dcc,0x000c1b307b3b87e2,0x000013888f003948}, {0x0005ad41140af420,0x0003926ed1a7c213,0x000f6695f8e5104f,0x000120f24430cb88,0x0000ce0637b6d73c}},
   {{0x00001e6fe631e8f0,0x0007d7bdd24bb2db,0x0009ad44f1c5563d,0x0009f98daea3ba36,0x000000c81b68187a}, {0x000a951aae1fd9a7,0x00071d5aed8a5f48,0x00098c622e35626c,0x000503b095276304,0x00006d17634e73aa}},
   {{0x0000ddaeb300f7aa,0x000c4db5e80136d9,0x000d5244c9dcf7df,0x000aa1c45cb26874,0x0000127ee79d48e3}, {0x000cc53575f1dbba,0x0004e0e6161e488a,0x0002650d095037e8,0x000215b7e5928329,0x0000be67d99b4938}},
   {{0x000944b3f8e10652,0x0006130e89243c7f,0x000530136ed908cb,0x000168e8ee8fd56f,0x0000227b7d5f7ffc}, {0x000c893b5cd6dd54,0x0001662796e84f55,0x00018e12c82225e1,0x00051a1c6cead1cb,0x0000381ae0cc4f5a}},
   {{0x00013d37fafa4c8b,0x00015491aac03459,0x00069264c3d91808,0x0000cce347871f3e,0x0000ea9dd3d64f4f}, {0x000d0673eadd3e7c,0x00074573bcd8bda5,0x000a2486c0033c1b,0x000ee6655893795d,0x0000b89ee5c46abb}},
   {{0x000a8f322532e5d5,0x0000227dfc4c8fe0,0x0006726dbb6410ff,0x000dc7119b9d5822,0x0000ec25669ca2b2}, {0x0002e064c3beb017,0x00000acea556af4d,0x00083487a852123d,0x0003ea9e9470faf7,0x00005a7ea04c664b}},
   {{0x0008f356798e4ba6,0x000567d0e0914ad7,0x0002904039214e6e,0x0007496420b488b1,0x00004049e0b5c295}, {0x0005af13ae9841ff,0x0008c0b662a603ef,0x000453458dbe4ca1,0x00072156845c5ffa,0x00008dabf1a00b66}},
   {{0x000f0aacce2793bb,0x000e15ec47c1b650,0x000234fa971db851,0x0006cd8eb78f3e3b,0x00000c60f36ac010}, {0x0007121774eadbd4,0x000f8e3238630542,0x00008697625367fa,0x000ad13541b5c9cd,0x0000ff069e31c507}},
   {{0x00052568776e6676,0x000c523c6bb57414,0x0003a8a876e76142,0x0008367bf307121b,0x00000e7363ef8450}, {0x000450eb7366d800,0x000a4837dbdf5741,0x000d4316fe4ee14c,0x000825a765eb9b69,0x00004548dca8ef43}},
   {{0x0004e4c5ae888eb9,0x0000c6e9ac999c9f,0x0006ac029733abb5,0x00038e4aad3c20ba,0x0000b8dd3d3bba3e}, {0x0004c920bc5d11a2,0x00077c5f88a3a9bb,0x0001d3cb8f20127a,0x0000a62f52b06e16,0x00006c1ff098afaf}},
   {{0x0000d2f7189e71f4,0x00081ecf91e73267,0x000757a21c643874,0x000ce4d5758e57db,0x000027d09f8690a9}, {0x000308f38384a7a9,0x000420732b99846a,0x000845819aac3acb,0x000e030e94100917,0x00005cba11237ce5}},
   {{0x0004f7fb00009c49,0x0006fff28b5f6f3d,0x00097975db8396c2,0x000ed521a9ae431c,0x0000d7ba8b075d9f}, {0x000f09f34f485b64,0x000c24122516338c,0x000d471febc0ddac,0x0008c96450da1205,0x0000c3a6250a28dd}},
   {{0x000d103d1295837c,0x000f7807eb2f69c7,0x000b41491a2893e4,0x00023516e1e1debd,0x0000630745c1e138}, {0x000109e48661ae16,0x000b8a2b2674c892,0x00028d6b58d17e7e,0x000f9da0ec0f87c3,0x0000d8586465079f}},
   {{0x000243e19115ead5,0x000dfbac4fcf6cdf,0x00029f25b1ce1393,0x000a04dc960ed09c,0x00009be4d8eed388}, {0x000e06cd0def72b5,0x000d903427480d46,0x0006d4a3db923db5,0x00099ea7d3aacd93,0x000058519cc5b0b0}},
   {{0x000ebf8827097ef5,0x000b8054f55d3ea8,0x0002ed089259353d,0x000a7c34c89abc6d,0x0000c548b69de096}, {0x000f616994b995dc,0x0005e5845601d587,0x0001fd9f04d1531f,0x0006c9b92ab31e45,0x00008b57bb325adf}},
   {{0x0000fcb1cd5ad73c,0x0005a144da4f6844,0x00062beb8b9c860e,0x00097e6ab286aa84,0x0000c6b9000af467}, {0x0000da420c8a471b,0x0000c7ff7fafac82,0x000b5da7769ae05a,0x000b7a09163f39bf,0x0000d03e590dc73a}},
   {{0x0002b5eb2940d9e2,0x00062b9af5647e86,0x000e3033d3c663d8,0x000bc6b8309031bd,0x000098231b2f42c5}, {0x0000d2c552ad093f,0x000c0f8546954209,0x0001f0d00a4799d1,0x000b451a88b5d6d3,0x00008b4082692f26}},
   {{0x000b1edf1bd72186,0x000aeb24c86eec29,0x00095ea65d491c53,0x000f1572fe588f33,0x0000f3764f7a456e}, {0x000116dcdc348009,0x000631e33955db43,0x000ab286bcdbcd45,0x000d7c5fdb554074,0x000048c7a52618c5}},
   {{0x000aa377378058e6,0x0000a4411154eb81,0x000828ac741c746a,0x000b29410c73bcfb,0x0000439be91fd972}, {0x000b4b043a2fbad0,0x000f82b5e8404bf3,0x00097bd4c39e6dad,0x000ccb4f71640863,0x0000f7de5687f1ee}},
   {{0x000c5a1d2ffbfc15,0x0009fccb64515865,0x000b32558f74211f,0x00012e16368a88c0,0x0000b539dc2ead78}, {0x00083d02f3af6f6c,0x0007d9934ece5794,0x000c9e9835213207,0x000b8990b9650fdc,0x0000a989eca6ee42}},
   {{0x000c829d6f62f995,0x0008fc2a7c0c6a44,0x000a0cb0a8f06a30,0x000363fea2b3a098,0x0000c547b710eee8}, {0x00040e1682afe112,0x000a5b41c0a8461d,0x0000d5d369e0fc77,0x000f6359e4aefde2,0x0000916e52052dd9}},
   {{0x00052e83f883faf0,0x00092b868d35f59e,0x000a19881396f963,0x0001a6c902a9df4c,0x0000fc96822db240}, {0x000758766f1c68d2,0x0003db476c0d4123,0x0001f5d9010fc6de,0x00044ad8b6b57984,0x0000ba8446d1a24f}},
   {{0x000b920ef4a9975b,0x00037330435fa237,0x000b7e7b560bb600,0x00039126f4ab5acf,0x00002ac509833435}, {0x000ee2fb0d1ea67c,0x0009b4c56230f036,0x000838ae6ae779a6,0x0006ef99bff8c8ab,0x0000d83ca9a5b38e}},
   {{0x000bef5e33deed3a,0x000e601892a8bb27,0x000dfbd3ee6356f6,0x000c9d1f3be6cc7a,0x0000ecbc81cd3d1a}, {0x000b909e6e861dcc,0x000393f5f801e4fe,0x000346e5790a247a,0x000c1a41c50acb27,0x0000e29242f061ac}},
   {{0x000214a2f998a912,0x0001b4baf27b04dd,0x000c26722271ee9b,0x000ce55e3027d1e8,0x00001d1645c3820d}, {0x000242c7501779c0,0x0007fa0e8009086f,0x000187129f006140,0x000bd0f23ce47760,0x00005bbdedb0fde9}},
   {{0x000483225d984730,0x00055c658427682f,0x00066ffa1f207fe8,0x00099db6fdd7ba41,0x0000c3140569eed7}, {0x000048f4107e28f1,0x0001312168400db8,0x000a3c06e74ed387,0x00013464489f8f56,0x0000e1c005b22777}},
   {{0x0002a73f37ec3c39,0x000d4d59eba0db33,0x0004d3257c65259b,0x00038f9291709cdb,0x0000a793b264d389}, {0x000e34be43756f0e,0x000dbafb56c9f39f,0x000208b272f76bdc,0x0002c2bf37867a61,0x0000a1d4307e8997}},
   {{0x00053308bdf623a6,0x000a2441fb7d8c59,0x000ddfd955f5accd,0x000be79afa941832,0x0000ad40c5a6fde9}, {0x000ba89aeca8709a,0x00008c248a9d43fa,0x000637a76c64a7cf,0x0001ba7662025272,0x0000ee1c791c2b8d}},
   {{0x00098fd21a843b21,0x000d7d005cb1f0f7,0x0000d8abe56e4ed4,0x000326255f77801f,0x000097b04cf44522}, {0x000b31ffd42c13f0,0x0002b40f933d41f9,0x00060bad45ef7feb,0x000f8927326f425d,0x000027ecdb28c92c}},
   {{0x000e4d14e3352feb,0x000ec3591b9004aa,0x000da7d6008414d2,0x0004ebaed6124eb7,0x0000985b931fd13d}, {0x000d3ab96bf36f90,0x0005bbdf51dfa592,0x0006c177d012dbed,0x0009cfa57963c0df,0x000010ec86987ca2}},
   {{0x00000f6bf926dffa,0x000154bf6bc2ba17,0x000da11f57c9fdbd,0x000e753c18dc8f64,0x00006074b7b7938a}, {0x0000066e84f44a48,0x0008527b954e1427,0x000f38e9a99998d3,0x00001641be8ab2b4,0x0000bb55bbf95c01}},
   {{0x00072b40ea2ab303,0x0000c73d68ddf734,0x000c2e1ebd365a34,0x000719901a716819,0x00002f49e3764061}, {0x00057f101d8b4d66,0x000bc6b47700b73c,0x000d8826a03c8423,0x000637d21d0bc8a4,0x0000004213cabc0e}},
   {{0x00064a1c1c06681f,0x000eff018e50f78c,0x00042b2b316e0a16,0x000f5741cbdf91db,0x00008f4ffcfd0d36}, {0x00071cd4cc5e3e06,0x000a4129e3e0cdcc,0x000b2cbf1d55c7cf,0x0003cb6cdb6ba00f,0x0000aba000624bce}},
   {{0x000db30d232cfc4d,0x000e058a3cef501c,0x000e091499ddcf12,0x00025632d2cf9c87,0x0000c5d7ec7fc976}, {0x000986e0b50d7dd6,0x0007207f112a6447,0x0000ae9f688fdbaf,0x0007dff8c9822ab0,0x0000abfb950cd3d2}},
   {{0x00044878a429f4f8,0x000b5b516609d0a7,0x00069b5df0649712,0x000af23826ba57e7,0x00002335df29fc7a}, {0x000f0675c93d9950,0x000a68677be62389,0x000d9951b59ac367,0x000ccea77985ff21,0x000038956fb85011}},
   {{0x00048cbbb734e37e,0x00014be5b26f608e,0x000b1a0d9c08c0bf,0x00031837bbdd3bf9,0x0000ac7d898f0483}, {0x0004bafbc1a6dea1,0x000f072aafdbc95c,0x00035c41afdd0e2b,0x0001d530373cbc82,0x00004303f220b6f4}},
   {{0x00036210408f237b,0x000a3cd2d1edba06,0x000abb6a2cad3b09,0x00017a9667855a52,0x0000a9157dd5a8b4}, {0x00035074f013efbe,0x000aca38c4a2fe7f,0x000a643451b112c4,0x00080ac1406a609b,0x000053cba344993c}},
   {{0x0006063ded40d232,0x000d34908e254546,0x0003c3c313d5f1f4,0x0006247ebefe6240,0x000074ea0b52672a}, {0x0008d99451d1b71a,0x0002ef79cf79ff81,0x000ce37f580e8264,0x0001fd0165df1373,0x0000744ef509e3a2}},
   {{0x000e7f5cf551396c,0x000dc68c676b73f1,0x000442c36c616898,0x00017ca71c28c78c,0x0000fe5e5591e0a3}, {0x000d8187051f476d,0x000544f034421242,0x00044d0f656fad2a,0x000f4d562068bc0a,0x0000fa2cd6f9e6ed}},
   {{0x000813ad15d15174,0x0001f77d44f50f43,0x00039b35f61214cb,0x000c199399aa29c6,0x00002136d7194c51}, {0x000711b084172219,0x0002c2545a579774,0x00050582d0a5546b,0x0005bbf0624c4111,0x0000ec5c4198bc55}},
   {{0x000dcad771849f1d,0x000431d7bf6f2c87,0x000116eb2b0c932c,0x000bd29aa5cd3e89,0x0000378c25b21ca7}, {0x000a0da9e6e3e319,0x000d268ad5d0c612,0x000c6edb80417a54,0x0007cd70451e4a22,0x0000fbfe01a44282}},
   {{0x0002505ba9384a2d,0x000d94ad69c12fa9,0x0003b35a621b8596,0x000671bf4fcc4998,0x0000e09376142754}, {0x000ccc8f7bffe6d9,0x000ecd94263d2f14,0x000f3ec3027566bf,0x0006ba25b4e9c62d,0x00004f1d7d5ce6ea}},
   {{0x000851aaaca5e9b7,0x0000e6713b9797b7,0x0000a61f6518aa52,0x000b68c357e8c715,0x0000842e7e35c2c2}, {0x000af656868a5489,0x00025068fc818dff,0x000917733d963bd8,0x000327d4da5c8b65,0x000027091000b247}},
},
{/* digit=22 [{1,2,3,..,}]*([2^154]*G)  */
   {{0x000c9a7d298c241d,0x000986807cfd214b,0x00064eadbe3b697b,0x0009c51f1c780245,0x0000de8cdd084814}, {0x000f0a75a4d2604d,0x000e9c1538af946b,0x0005b1fcc27154d7,0x000f81c5cc9230de,0x000088519ea36864}},
   {{0x000dd1a7cb1282c7,0x00064e46973ab828,0x00008d6b2a08d762,0x0003f2fbaf8d40e7,0x00002571fa1bdaeb}, {0x000732ff22dfd98c,0x00064087108d85b1,0x00088207a87ab01a,0x000754eaaafea859,0x0000cc832f929f00}},
   {{0x000950e36ff3bf0c,0x000f30b34638964d,0x000d7585f8ad20f6,0x00019e8d9177b3b5,0x0000f839761af3f0}, {0x000c5b38288c545c,0x000a53116bd1582f,0x0002120ef2f8e4e9,0x000d23391e1b2f33,0x0000f568724ea17d}},
   {{0x0001185ca8d9d1ae,0x000cf987ded2488f,0x000c46124adf2c77,0x0005f37f3039f060,0x00005d70b7651e09}, {0x00086506260e70ff,0x00070750d10582d5,0x000bac36439d75ea,0x0003289cf3d0b175,0x00003a7564e11d01}},
   {{0x00004cd2f52d2a7a,0x000a42df565a182f,0x0009fb2f74fde149,0x000897180c5eeca7,0x0000b491d7bc2ddc}, {0x0006c18c6312c7fe,0x000c8aa41a5799d7,0x0005363a0ca0d5f3,0x0002c191207325d1,0x000082aa2669eb25}},
   {{0x0004700ec3128c2f,0x00019e383f4994ab,0x0003024eb6c76d86,0x000c68ec36b150c0,0x0000b43947843daa}, {0x000764a8dc796230,0x000db440fbb2fc68,0x000c5ee0d5b86995,0x000bd3d66879bfcc,0x0000522894295aa8}},
   {{0x00040a51e6a75c1d,0x00053ea7d817b51a,0x00077459724327c7,0x0001633663018207,0x00006fdbec467fa7}, {0x0009dfb13c90f48c,0x0002a86ef26320c9,0x000f64eebd6ac527,0x000c3206a50bdcfe,0x0000d87b28246fdf}},
   {{0x000a43e3fcd3efca,0x000418088e9ab24a,0x0003d46eadd26c03,0x000a6f05ef4dc9bd,0x00002f99d592a4c6}, {0x000d3552f1da46cd,0x000d4afacdd1ddab,0x000d4057872c3f8c,0x000b94090c4eee92,0x000028bb4209a623}},
   {{0x0000711745edc116,0x000cddc8755850fc,0x0009d1e649dd9ad7,0x0000f96e6931fbb4,0x0000c77a0a3298bd}, {0x000a6296baf7cb10,0x0001ccf72d2262b9,0x000639071cf065f9,0x00032f7203cce979,0x00009ae4885f9cb7}},
   {{0x0003becee8314f30,0x000ddbea298f5e7c,0x00080acec1c068ae,0x00095b08d381f17c,0x00003b56be8e3304}, {0x000b8f29222882d6,0x000664af8bf7aeff,0x000c57d8c95ff38f,0x0004eff0e32d351f,0x0000635be5277b44}},
   {{0x0005276a5177900a,0x00075685875204d1,0x00015796c4e1dbb4,0x0007bebb475622c6,0x00006fa038809186}, {0x0005d562844c6d0a,0x000a63a2477ded7f,0x0003721d6c633cf9,0x0008e656be5c402d,0x0000f312eb889fd6}},
   {{0x00092d2e7417ce17,0x0001270ee7f52427,0x00067a41eff42bc7,0x000a57aff4dc6d5c,0x00007709b7b90882}, {0x000731dbe217f2cb,0x000cabb721773554,0x0001dd0592af2a8c,0x000476a8eee76959,0x0000b2930c9fbba6}},
   {{0x000e0477d930cfc2,0x0001196fd1f4863e,0x0009af7e14c262ad,0x0004f6d4765bc803,0x0000519834b7ba10}, {0x0001b4cd105f961c,0x0005163bca547cd6,0x000a1f17ca5415da,0x00012bb78280a088,0x00004968949e3295}},
   {{0x0009126cecdaa7af,0x000d1b13247b174a,0x00084c1c4fc8c7e0,0x000c3a39c110d234,0x00008eb8758731df}, {0x0000212c00674527,0x000e0b9b926c022f,0x00042daf43f6f69e,0x000de399032da0ef,0x00009f00adef3f80}},
   {{0x000db7181236c972,0x000b1ee0781f6210,0x000e4137274f7685,0x00053e2df7da7ba3,0x0000aae38b1d1a15}, {0x000e222f6dd9d1bb,0x0007ab8b64871688,0x0002edeaa5769544,0x000569978d21274b,0x00002818fa5ce859}},
   {{0x000dddaf176f2c08,0x0004625726581e6a,0x000342ffb01ca460,0x0008d58a404ded85,0x0000cf60f96c4183}, {0x000691cc9071c4aa,0x0003944428039bbc,0x0009c0d81fd58874,0x000f7ef7101c8580,0x00007fb754d2c456}},
   {{0x0003c5cd51805e1f,0x0008c299dca8c95f,0x000eaf500ab4ccd3,0x0008924e03d20b47,0x0000a3165c2c7b80}, {0x0008b54e160e552a,0x0009f019d11f005e,0x0009a4a7adc4972b,0x000fd681a6972e0c,0x000052c258fd7840}},
   {{0x0009ff4c1e99d816,0x000643c617c0f855,0x0008c6ba708e1a7d,0x0007945398fd4324,0x0000ffedd9231283}, {0x00059d2d629d2080,0x00053490530e8a6a,0x000505989a9d141d,0x0004ee42f6fc1838,0x00009bf250d479d9}},
   {{0x000d3b1b38227904,0x000053b8971c223a,0x000f7fa626c5926c,0x000989209efc7e75,0x00005d66a6d5ec2d}, {0x000d663987d2792d,0x000c6eb31d2b4422,0x0002cb9e64a73caa,0x000a84206c2ac1a3,0x00009445c6061aeb}},
   {{0x000a1d5af71013f7,0x00049bedc9466af7,0x0007370a0e68216e,0x0001cc84cba30bd2,0x0000981afbff7042}, {0x0006a679449f0e1f,0x000d1a47edae0249,0x000feca2286cfc4b,0x0008fa4073c936b1,0x00005694612f3f8f}},
   {{0x000b723901515ea5,0x0005249cf038d063,0x0009e50594c6c77a,0x0007c01361e360ab,0x000096cf171f76a3}, {0x00053fa6530ae7aa,0x000d6792a7a6800f,0x000db81c90f5e631,0x0000b9bcc29c24ef,0x0000269e868df9c4}},
   {{0x000f9e12cb7191e8,0x000865b08ea6ec14,0x000332bb978ea1bd,0x000e24bc65aa9b46,0x00004cc22b43f80c}, {0x000e9e9d49d5bf18,0x000599087da40098,0x000f6e357cd4ec1c,0x0004b7bc9d07c5ae,0x000039a02691f8f6}},
   {{0x000eb62c6d8607f9,0x0004daa995e4c5e9,0x000b48317759689f,0x00017ce0464669bb,0x000021474c074024}, {0x000135b2a354c8c4,0x0002412fa4b5cabe,0x000311fe8d51e52d,0x00014bac74109653,0x0000f774535f8645}},
   {{0x000d6715bde48f8d,0x00025189bc7dbcad,0x00009ee8ac970387,0x000ff78d45299ec7,0x00001287ee3545aa}, {0x0008874db1dbf1fd,0x000ac90c88d67d1f,0x000368313ea46588,0x0003ad90ba649a84,0x00005fdcbcf30d54}},
   {{0x0006d43810d5ab00,0x000904d7e5cc90b4,0x000337c336739d8f,0x000c40021c1a580d,0x00000a6116268e67}, {0x000413b379f0a1ff,0x0004f9e2ab9595ef,0x0005f199cfe12660,0x00091277578b852f,0x00005c0032a1cb84}},
   {{0x000643037577dd85,0x0003d9c5fe88f795,0x000bdc13283b82af,0x00039e4c1bea26cd,0x000089fa086ec043}, {0x0009538b13799dff,0x0000e295d034033e,0x0009ddcca85fa8b2,0x000333ef17f73fbd,0x000032bd123cdb66}},
   {{0x00088a7858b044cc,0x00019aa9e39755ef,0x000d855591f0d69c,0x000db195fd9cc340,0x0000774df733785d}, {0x000e9f6d3bd2e1c7,0x0000385dfed05dcc,0x000ed09c4eb30da2,0x0001bceed7f5bbd3,0x0000d42a35cf2a9c}},
   {{0x000e9959890272db,0x00098e713a10cf3d,0x0008227b875f3432,0x000dc7ae13479fe2,0x00008561eaaaefac}, {0x00097a08332aafd7,0x000503809b62a6a2,0x00063036f9b0d8bb,0x000da862fa1cfd0c,0x0000a16eb562d64b}},
   {{0x000f5f678e62ddc9,0x000377fd752b3f5c,0x000437bbe2267c45,0x000074ce361b6b5e,0x00005c595021354e}, {0x0005f85f2b254d9a,0x000c8cb52b4eec72,0x000425fb5844b617,0x0003124d8554f5cf,0x0000b67703ecaf9f}},
   {{0x0004ec13cf482834,0x00055c8a705e4cc3,0x0007d4f84b09daa2,0x00029d91e9d0d05b,0x0000df6ef651b389}, {0x0000763aa21ba469,0x00081293f8fbe16b,0x00020aabfc6b1d17,0x0009797ff5b602d5,0x00004d671be53393}},
   {{0x00098cf4f5792fac,0x0006512152617c7d,0x000c5a6d47c5e0d6,0x00074cdb19a631a7,0x00008511a633a452}, {0x000621ca5a60d998,0x00084f5e48cb0c16,0x000ddee08f7fbab8,0x000f3c2b1e6ca2f7,0x00003bd08cf67867}},
   {{0x0008e8a2ac13e274,0x000f0eb1a9f5f7e4,0x0001f0a624494f6d,0x0008f0adbf84eb98,0x00009badc3293643}, {0x000a541004f7571b,0x00002f1c94ee50be,0x00027bc31bac67d1,0x000e27753d73a1b7,0x00003d01cf2e0686}},
   {{0x0007b1b55fd0b8ba,0x00035eec317351b7,0x0000e72b7a099d18,0x00035e802b1fb767,0x0000dc88b3448e16}, {0x000216af989d9051,0x000019b58d0134e8,0x000e55a93c2e68d2,0x000f4001f81c926f,0x00005f1462a9f296}},
   {{0x000d375ea3d62f2e,0x000221c8977d1915,0x0007b26f6a17765a,0x0007a49559710ae4,0x00000bd29c933507}, {0x000976d08d84858f,0x000479ced5c1615f,0x00034fa56370dfe8,0x000573cbc7503ca7,0x0000bb9f1ed81ac4}},
   {{0x000ec53060dd7ef1,0x000d5e65797995d7,0x000a08235eef2dac,0x000a3d44511af3e2,0x0000e324aa42f4ae}, {0x0007e71e6e676710,0x0000bf52faf7550e,0x0003cc62abccd519,0x000b5df880d31622,0x0000d402c7e2b32e}},
   {{0x000c039306a5a3b6,0x000d36783a1ba40b,0x00053cdd44e0a41f,0x00063841e8d39a02,0x0000480be2727388}, {0x0005e1d2285f3821,0x000fdc0b5c36ee36,0x0000f4d82188d8d8,0x00029a24ef1a481f,0x0000a8f43e1b487d}},
   {{0x000226d77aefb3a4,0x000dde72c2538168,0x000594df1f69a751,0x0004674e04359ae9,0x000075ffd7e114c0}, {0x000c2b13844e95c1,0x0007cd12ef94b5a2,0x000063d0085caf64,0x0003110ecd2a9ff1,0x0000dd2e22933843}},
   {{0x000e09d73d172440,0x00068fc653f138f0,0x00020e21c3ede774,0x0009eaae4459f5dc,0x00000db2ffa6a859}, {0x0002c3930cfd9057,0x000435c112a61168,0x0008bfe954934d07,0x00041a4df063c556,0x000079a440a716c4}},
   {{0x000f21897d6fbdcf,0x0006f0776aac0c23,0x00012e8dbd3a5cd8,0x000e8cdee37f72d7,0x0000b28c70e16f74}, {0x000c728b61301a0c,0x000813724354ffe0,0x0008ffedca628216,0x000de8bff4cb0076,0x000051b3088c3b02}},
   {{0x000147c3902dda59,0x00066e6973b4a5a8,0x00057457e35d2f70,0x00011acac2efcfc2,0x000033f48d517006}, {0x000af884912beb26,0x0005b62edf94c365,0x00032f34b7f5a4de,0x0000746646ba7c0c,0x000032c6af412091}},
   {{0x000f2e3753e43a97,0x0006b4d4e23f58d4,0x000ede6a670e1d21,0x000b60424bf729af,0x0000f4a94d8e10c8}, {0x0000a968d4faa6a0,0x0002b066b690aad9,0x000b6dbfdd9ed0b3,0x00043152fcd37b78,0x0000b64615e8bd2b}},
   {{0x0002048cfb9fad53,0x000cf40b76bd228e,0x000dad7bcbeaa386,0x000f5dfd6681c890,0x0000e553fc336d38}, {0x000db9b9d5f97505,0x000a828c5b0ef27c,0x00047c39b3e85c52,0x000827c90795af52,0x000047831ec0ddd6}},
   {{0x000a2274a82f424f,0x00078e47f89df327,0x000c7392c36919c7,0x000efdf478391943,0x0000101b9ab1316f}, {0x0009e9c1c5009d2d,0x0002ccd18345bcdc,0x000ce77c7fb55ea1,0x000b3d25b5e231a3,0x0000e6b4528a2f2c}},
   {{0x000a3339bb26f5f6,0x000da44d85b610f6,0x000197e541e85db8,0x000ea863697a0894,0x00005e18cc107cb4}, {0x0004f50a471fe6ea,0x00098f13439ca38c,0x00007318bf031747,0x000b3cb3c4a6bac0,0x00008da3ee5bdecc}},
   {{0x000b31c558216b17,0x000bbf79e6c20555,0x0008eed3c90c7810,0x0001262b669f4dfe,0x00000398ec950fac}, {0x000449ef701b2350,0x0003eb94f395a96a,0x000cb74310ceecdb,0x000c64285fc368d0,0x0000d37bb5216a18}},
   {{0x0000d38b880d2dd4,0x000b25930d570511,0x0006235f5a60f177,0x0006b93da34a67f3,0x00007f5e17c58381}, {0x0004b57db394af4c,0x000cb036f789c766,0x00027b47239ba215,0x0004b686d2ca0e2f,0x000042647efb73a8}},
   {{0x000754564488f1d6,0x000894cf85d544bc,0x000e4df63aa92270,0x000ced121a01d553,0x000049c0c51bdb46}, {0x000d64e3cffcb6c1,0x000e40f71d966bf0,0x000c194a0e3bf93f,0x00055465044558bc,0x00006ae33727afdc}},
   {{0x0001adf5ca48f3fb,0x0006322a9b84bfc0,0x000099e4a64352f0,0x0009c01ee54da1c1,0x0000bda54e9aa1b8}, {0x0003df56f6e55fbe,0x000340176f88166a,0x000b7b5ff1ca44a2,0x00049fb36afd88df,0x000034c24386611d}},
   {{0x000bb75861421033,0x000aef34fc4d7eff,0x000c1b1226704ba1,0x000ce94c2a468f10,0x00006b3a610bc6aa}, {0x000c0a775a0d0508,0x0006bce33e32abfc,0x000fe09be066f919,0x0003514e905ef429,0x00009ee25bb28376}},
   {{0x000de22fd29dc766,0x0008d6f172602a3e,0x0004b41267fd32ed,0x000fc7acadcf6828,0x00003422f0907951}, {0x00024f40807e199e,0x000042ad4490562b,0x000b2b1b4fe9ce5d,0x000d0ce2f51b100d,0x0000b361400c4541}},
   {{0x0004a052680813be,0x000c761b08d6bd2c,0x000205558527aa55,0x000bebc9f8a40ea7,0x00003eea570043d0}, {0x0003817a0ff58b3a,0x00047a69e6277b85,0x00069b5d6b67d3f6,0x0003ec6b76bbb9a8,0x00003afeb82f4672}},
   {{0x000416d3e5548920,0x000d430e2a455f24,0x00032a2a08413b53,0x0007b199c56aee90,0x00009432bf6eec36}, {0x00050c6daf0ecc11,0x00054bc920485528,0x00081130749ebce5,0x000597cfb66ba654,0x0000b84f7977f298}},
   {{0x00004818d1d7a0dc,0x00027a6fa5567959,0x0009e5d35d9fabe0,0x000576e40f9c59ba,0x0000b1771c2b6247}, {0x00047cae9a6312bd,0x000f852dd8c5542a,0x000794716a34b355,0x0000942df94de00d,0x000046124aa6c623}},
   {{0x000435d68afe8b4d,0x000f9c0d8ea156b7,0x00018689827f2053,0x00090e42b77e1473,0x0000bc3dd4744794}, {0x0009842c03b0c057,0x00030921bc96951a,0x000202e0a8b1b3bb,0x000d563573b3462b,0x00007e4665db7254}},
   {{0x0000dfcd23e39845,0x000c9bd1423608b7,0x000114ba7ab86e8b,0x0004f25a3e07f857,0x0000ac71689fb0ef}, {0x000a3840139d9af1,0x000866644af088fc,0x000d74f4a72733f8,0x000c7ae122f72a65,0x00003931577b5626}},
   {{0x000d9eb70f8d5a4d,0x000707bbb228d5b5,0x0001c0b32375adde,0x000ba961e88b860c,0x00001f568c4e73ed}, {0x000fc835459df02e,0x000a2fcd9a7e1592,0x000473b0a2beac0f,0x000c47d0a6fdb81b,0x00003224c6fefe8f}},
   {{0x000d00ee87edf5b7,0x0001b0e77cf5680b,0x00042d1b230385f0,0x000d7779ab98c04d,0x00002d191d343816}, {0x000daca0917d9e55,0x0008cf8fed7f1564,0x000bb3896394eab5,0x00098e5209aa8d7f,0x0000564f3ba0e6ac}},
   {{0x0001d05d73654ef8,0x000393d78d74ead2,0x0004973a068d1a9c,0x000329e1e017086d,0x00003da3500c6e6d}, {0x000fca468ae01189,0x0009402da0696a3d,0x000ab8302a1b9a4c,0x0004357b2ff9c7eb,0x00008af07c4244ba}},
   {{0x0007326995f0f9ff,0x000f81b58bc68599,0x000625a2b467fadd,0x0008cc57e4495abd,0x0000dd2d01e23c3b}, {0x000ae28c693f9fa1,0x0009248f79992c38,0x00061f5834862232,0x000cc987bf738e21,0x00005ee2fa7665e8}},
   {{0x000c8455777e1891,0x0000356f2829a1a5,0x000762bd5cc10bee,0x000da87ad95c56da,0x000052e2214f9d91}, {0x0000e727cb23c74a,0x0000090c66df975b,0x0005ffc53fd5d767,0x0002ae15b5b8ad22,0x0000b6dff749aded}},
   {{0x00067816f4cbe9d9,0x0008da574bd7ebd5,0x000a881fa0ed8b24,0x000c6fb1c246fe81,0x0000156480653db9}, {0x0002b085b8628093,0x000125858d7bd7c1,0x00009e92a1facd1f,0x00025f4693747caf,0x0000b69dcba489a4}},
   {{0x0008e9f967365efa,0x00024801f5c90be2,0x00083352f57300eb,0x0002b6f3b8ac6ad5,0x00002cf1f8a6d05b}, {0x0009b744dcc40cc3,0x00057da523fb7c0c,0x00099cc4dfee38c4,0x0009c6849a4dec10,0x000025c377f99f06}},
   {{0x00058ce476cc9ff0,0x000cc6d4cb63e124,0x00072289b580e0b6,0x0006dad561c8b790,0x0000377f264a619e}, {0x000536288e591a5c,0x000cb523ca2b2668,0x000df4533a453a7b,0x000f78ca9536d2c1,0x00008e50f307e972}},
   {{0x000e50f6d3549cf8,0x000f7acd665ed433,0x00011fcb46f33696,0x00085fe95bfdacce,0x000010ee2532f7c9}, {0x0000fe17159bb2cd,0x000da58b357b6545,0x0009fea72f7dfbeb,0x0007445b057e74d6,0x0000485717b62731}},
},
{/* digit=23 [{1,2,3,..,}]*([2^161]*G)  */
   {{0x00042e8ee36860ce,0x000c6113c22d896c,0x000104213daf04df,0x0004e93adbb7b744,0x00005fd5fa1ffd39}, {0x0005d941a4e0551e,0x000d38d101516823,0x0009845236772cfb,0x000a97476071e309,0x00004e879df3a56b}},
   {{0x000afb0285b94916,0x0007be4c705eaaaf,0x000d9caab01a0be8,0x00033f9f1d4f5d2a,0x0000e349a4b237a2}, {0x00012464a1c6a163,0x0005f9383260cf1c,0x0006d5471d99e6b6,0x00089bba3d43665f,0x00006974d052f8cc}},
   {{0x00049a1cfe89d80f,0x000cea9c8371c26c,0x000d066d2b42c026,0x0003edda6c013ada,0x0000b8f722946a4f}, {0x00079ecd850935b3,0x000ca631e1b308b5,0x00019853434c1a74,0x000f259b5fe596ac,0x00009ff21f711f24}},
   {{0x0009e148f9290579,0x000630c853df27f2,0x000e9c5ce7a64ae0,0x0002a4956cd18358,0x0000d9cce836ed09}, {0x00059796e93b7c7b,0x000181bb9e27cc6e,0x0009e29a0e1e4709,0x000644070b3083aa,0x0000f181a75e785e}},
   {{0x0002c658ead09f79,0x00050780d14df53f,0x0001b66bc1335e1d,0x000fc7d9cc20e0cd,0x0000b670a384be0b}, {0x000dc8128efbeedb,0x000bd326a6e5ce53,0x0008e9a630c74e77,0x0002478604e0d2b8,0x0000ab38fcac3dc2}},
   {{0x000e8c85c0a3f1ee,0x00019c87c37f8ed6,0x000e3b78dbcad249,0x000a461dfb62bb9e,0x0000ba8e478abceb}, {0x0008cb0eeaede4b8,0x0007f976deb637d3,0x0006147fb0bc498e,0x00060932944c046b,0x0000b123f36771f9}},
   {{0x000dcc7de79dc241,0x0002458f69cda155,0x0001850dff1168a3,0x000848aac215950d,0x00005c8295bc204c}, {0x000aa367d8184ffe,0x000d50447bdbf661,0x000e4a59ec396228,0x0005e531cd5143bd,0x00003a26e3c4beab}},
   {{0x000a13f1402b9d0c,0x00026c7bc863d3b3,0x0008c3e6e573441c,0x00057d8b301ec457,0x000026fc9c4cadaf}, {0x0001bfd7493cea35,0x000ecaf8145696e7,0x0008c608fd05d4b3,0x0002768aca2a8a6a,0x00003ef07f65725b}},
   {{0x000fbd27824fc56a,0x00077328907707a5,0x000c483493467521,0x000874bbf69fd5e0,0x0000613ddd456aa7}, {0x000c19c5450d8660,0x000c8f84a4817f78,0x000fce23946f4409,0x0004b99f1d192890,0x000016c4168b2ce4}},
   {{0x00023f0c74359787,0x0007b0e30e19bae0,0x000fa6fafb152c88,0x000e602c241645e3,0x000035d95c1f4823}, {0x0007573039553173,0x0009c03b49950319,0x0002746000b4b02a,0x000507d76bf55970,0x00002c5cc53daf57}},
   {{0x0006d1f606241297,0x00042a5e2b5ee8af,0x000082d72b7bc5d6,0x000779c814b0485f,0x00006f267f33e196}, {0x000630fb36eed930,0x00073bf56803626c,0x0002736a055230cd,0x0005f178837949ce,0x0000d792d60aa6c5}},
   {{0x000dbfdd5c7c5d2f,0x0006172b342d0318,0x0008de38ab38f8da,0x0008414569bddc7b,0x000025b588891c94}, {0x000b2842946ad608,0x000d69d1707eb2d5,0x0006a4509854f29a,0x0008372a5159dc2c,0x000099f94c0d7189}},
   {{0x000dc51f4a55b03c,0x000d75e3b2d5cf6a,0x000827b51261762d,0x0004418cc4301204,0x0000d22a11486021}, {0x000d61a247c9569c,0x00031152becace2f,0x000a716d459a5097,0x000dceac835a1163,0x000026455edd87de}},
   {{0x00036e049ce89e7e,0x0008ec890cb527f5,0x0003c2aa11890853,0x000bd2508909abd8,0x0000cd3142bfab73}, {0x000bf59b3f5ab84e,0x000812bea4c66a85,0x000a4541f3c320a6,0x000185cd8dc5386d,0x0000af34eb197c41}},
   {{0x0000129977c97c4f,0x000ad57eb9fa1c78,0x00022c4785ff9bee,0x000414b24d0524c8,0x0000d8eec2b361cd}, {0x000194ef027458c3,0x0008ed1be115fbde,0x00066d6f4b4ff531,0x0000c933f874d948,0x00005c75015e21ad}},
   {{0x000c9d646ac49d20,0x000b83137aa9a6b5,0x000225a3842c77c0,0x00090724d000fc68,0x0000f63cfc82fe1e}, {0x000b01bc6441f959,0x00095c8e448f22d1,0x0007fb1ba7d38f71,0x0008df0b33fa5f78,0x00004dcfda1a9015}},
   {{0x000b3395f6d4a09f,0x000bfe52b826c47c,0x0001b930a6b4f355,0x000f684d100f5df5,0x00004512fad8f668}, {0x00081d5206c4c74f,0x0003db4d2e485467,0x000085c2dd021d4d,0x0000a7594a54c2ca,0x00001dbaca542085}},
   {{0x0009326490a1aca3,0x000c11526b0263c7,0x000979258cb64dd9,0x0008468b772591a2,0x0000f58297078d97}, {0x00070d17c213ba70,0x0005e8a0ced4d66b,0x0000338c1c28febb,0x0006f36b911831c1,0x0000d54e389bf012}},
   {{0x000d4604af206ee4,0x000637e97cb97048,0x00064802e786c88f,0x00011c94375ae1ac,0x000069bcfe2153ec}, {0x000340d470622302,0x0007a5b4a3acfc9b,0x000ef45ace743bb5,0x000188de00b4aa59,0x00009a4ef2379edf}},
   {{0x0002efeb483689bc,0x0005913ac2624024,0x000a6db722575d3f,0x000be2330037c80c,0x00009fcce8358864}, {0x00012ff0149362d4,0x0001dc4ae97184a1,0x0005cf86c95e5758,0x000a2edfa4b1a894,0x0000525a7344b024}},
   {{0x0008b628f3383609,0x000298edf32be76c,0x0008b1aec483ff59,0x000a20d7e8e90a29,0x0000caab339036d9}, {0x000d2fd668927090,0x000cb55a1d415c09,0x0004a43942496b4d,0x0006c193f5fb1ae2,0x00008c750496fa8f}},
   {{0x000d1c2c905d85f7,0x000f9733ae57caea,0x0007cdd94e9d7f78,0x000930b4c9a65cf0,0x0000389359d14b55}, {0x00009b7367e45f70,0x0007cb7e7adcf587,0x000b728181f20306,0x00003382444bffc7,0x00007303b35baac8}},
   {{0x000e4e4d13b7ea1a,0x000440e741801e1e,0x00070ef70e6489b2,0x00089405f2c6107e,0x000016554135dd10}, {0x000befb7af4194e1,0x000c7e89bd9c555e,0x000895856533c1c3,0x000c15635b9b5789,0x00005fb3cd2667f5}},
   {{0x000ed45526f09fd2,0x000c6128240a057f,0x0002bfd8de8a4f10,0x000a317332efc4ff,0x000014e77a0dd35a}, {0x0006d7314faa40ec,0x000b41e5f1863289,0x000a1813e767867e,0x00079509adf8f117,0x0000b6cda7914741}},
   {{0x0001b6d349d51aa0,0x000ee3c7b8e9b752,0x000a096dff56b5a9,0x000024c6f1e5c932,0x000083667c4a3635}, {0x000a13518087f2fd,0x000c0136e45d365e,0x000aec989f1b8eaa,0x000258f8a0e48473,0x000075a324be42c9}},
   {{0x000d00101dae185d,0x000acb7a94bcb7b4,0x000d8cb0b45434e0,0x00049e254339affb,0x0000cc4569fb98ef}, {0x000318a09a512993,0x000682b025d87789,0x000e8579281b4d20,0x000af7c64aa418fa,0x0000e50258fdcd7b}},
   {{0x0004cdb2996864b3,0x0008ef485fa4dce8,0x0004c6a5aa2e6708,0x000d39828b2bb653,0x00001a7ec6bf94b9}, {0x0007766d6bc20da4,0x000c467611901d21,0x0007010634acdb5e,0x00029b2872632873,0x0000d24ee7c6128c}},
   {{0x000ebd3a19fd8680,0x000cdb8ddd3bc072,0x00064d852612e481,0x0004abb4e1d7541a,0x00000ef95acc4c6c}, {0x000d2edaa0a6c469,0x0005b37747901536,0x0003fda106129408,0x0006f1c4af25e834,0x0000ff9d98e8d25d}},
   {{0x000af7c468b8835a,0x000ad30ecea70746,0x000cf4a81977a31c,0x00037a05096b80c2,0x0000a9868340458c}, {0x0009bf3a6bd9d340,0x000b33c5d8546af2,0x000133b5e6a62fe9,0x00084850e6c304b7,0x00004b601597d6e6}},
   {{0x00096df5579bea49,0x0007cceedaf14cd2,0x000bcc5b110e35ac,0x000cf874c4c5fde3,0x00005f9ee8b19412}, {0x00059ee82b6eb0fd,0x0004c5c2aadd2c94,0x00027fcfe2e84576,0x000475a74a84aed3,0x00008c93722d368d}},
   {{0x0005748f83e8a3b0,0x00068d2495f30dbd,0x000496e9ba579aa9,0x000cc2535996a0ae,0x00007afbfe9b7f9b}, {0x000dc6d5b7bd2931,0x000f6022323d3ac1,0x0000a3e763b592cf,0x000acbaa0deb989c,0x00008e78e9f5b197}},
   {{0x000de10296c36eff,0x000192c4da77211c,0x0007836da7ee8967,0x00060ac617d270a5,0x00000cd9c328cb75}, {0x000cbf7e455fe908,0x000afe7334f301fd,0x0007de4ec3fb53cb,0x000fcff81e2ea44e,0x0000adab3ad8b384}},
   {{0x000ee2f53d648293,0x00077261492b129e,0x000cb4a2c7a471e1,0x000c2db4f9adb9e4,0x0000d359f6fc7ba2}, {0x00067860aacd6975,0x000325c2f8a8346c,0x0005df44e92b444c,0x000f31779fa117d8,0x00006782372898dd}},
   {{0x00090f2bbbab3b85,0x000e3b04816b60e6,0x00092e4d24851f8a,0x00036b772046ab9c,0x000018c74a1ccf31}, {0x000b50af9877d4ca,0x00000919cabbff4e,0x0005eb2b614578d9,0x0006e3e218f8c4ac,0x00003ccc547f4201}},
   {{0x000f48e327f83495,0x0006a43cb641025b,0x0000f1085f3e9734,0x0000558c2bafdf50,0x000071678767f063}, {0x00014b9411925a6b,0x0007f1123de55bd9,0x0002b165d7c078d4,0x0007273e6bf83518,0x000011b5e5c6a519}},
   {{0x000a76c1eea7b85f,0x0000a2d4f85ee33e,0x000e115bb2352b46,0x0005a30101d334af,0x0000abc129578917}, {0x000cdc05233f9251,0x000bd77fec557f6b,0x00069b659e0a802d,0x000d74adb47b7580,0x0000c5e12df098fb}},
   {{0x00058c64b8457ee6,0x0008ef7ea9f7869c,0x00060b38fa5360f6,0x000b368576c09ff4,0x0000b70d54882b7f}, {0x00037f13bfae3154,0x00028bdff3693fd2,0x000b516f93379785,0x000d2d57df25f525,0x00006f388f2fa38a}},
   {{0x000465889d8ddbbc,0x000db0f38ee8656c,0x0001212b08830b26,0x000db18320fd5cde,0x000034f30d0a4a2e}, {0x00031a356ab64b81,0x000cc99c5d26abb1,0x000981d947f77f0c,0x00076e56856a37bf,0x00009e76d09838bd}},
   {{0x0008ac396238f398,0x000e2830b366e76c,0x0004eb499c0a482b,0x00086537b8eaff0b,0x0000ecd83bccbfb4}, {0x0002cb7a2f3776f8,0x000474b88adf971b,0x0001fa446b42176a,0x000bd239617df5be,0x0000b32d5094d031}},
   {{0x000d47d53b618c0e,0x000b8a2279231c6b,0x00092d964c424f46,0x000bf19303ffdedd,0x0000971287951b5a}, {0x000a632f815561dd,0x000503c055d18f48,0x00025684f85f48ff,0x000cc2522a142775,0x00000d841a137360}},
   {{0x000a9260b9267c6a,0x00012f07f8634245,0x0000d9e24c78913f,0x0000170a844c8e4d,0x000042ad522dd5f9}, {0x0001749a2c989d55,0x000f91f5e78ebd37,0x0001ea6da928292d,0x000528f93b383e0a,0x0000136fd8d63aee}},
   {{0x00044b1f2c34a996,0x00045f5855ac860c,0x000af37be3b00aca,0x000c084bf6aaa0fa,0x00005f436828a53e}, {0x0005801a11b12e13,0x000cb20ed4751d9a,0x00041e0d578a7ab2,0x0003e9dde1067e9a,0x00000473f5f60502}},
   {{0x000e09d169c7d97d,0x0003ffaef9cddd3a,0x000a448035cd5baa,0x0004dd8cd7440b65,0x0000c13966b17f36}, {0x0002be82b8357c1f,0x0004f9d57c2a077b,0x000ff363e0cb1b4c,0x0009ee8a4ceb3205,0x0000310fa4eba35a}},
   {{0x000b352f97f68c6f,0x000f1b02cf58dbb7,0x0001f96d90c773b4,0x000814fa2e48213c,0x0000fb357b1dee01}, {0x00024cde0f28039c,0x000986a3fbe4b9c9,0x00046db6c0b36c95,0x000afe5faaaea45e,0x0000ae575c3d928a}},
   {{0x0001302a70dab865,0x000921c58cfc7f67,0x000e0cb92fcbd12a,0x0005837bef9acfbe,0x000073da0ba48c1b}, {0x000fcfe0d41d5505,0x0002d155cffe4752,0x0005ae248e7eec0e,0x00044dbfc39fcb54,0x000022cb8d1d065f}},
   {{0x000962a70cbb96cb,0x000a0cd124a9263c,0x0002ae58de034362,0x0005074120db283c,0x00009a38d4aaef6d}, {0x0002a821ff140fd2,0x000000aee7e0b1fd,0x000251949bd162f3,0x000c3d2e17a5d4cb,0x0000aebcb836f7e1}},
   {{0x000b25f937b05271,0x0007db7d9997608e,0x000a53a29f42e1e4,0x000536dba699c4b8,0x0000f921c71f091b}, {0x0009e7b5b26bbd51,0x000d2b61a680cce2,0x0001f1c7e7a8ef5e,0x000ddad5ef8043ba,0x00006ea821728158}},
   {{0x0008a2b599ff0f94,0x00074104fc6b0177,0x000694ff368a923d,0x000f121bfa44dfda,0x0000f7199dc37667}, {0x0008ff6e46f2a79c,0x000d29f8131dc06d,0x000b4ce7c08b5dea,0x000c3d42519a59ab,0x00004f710bd742ae}},
   {{0x000b05778bde41ac,0x000ff4186b5a3d77,0x000c657416474bf7,0x000153448b3f6788,0x000064519dec3c7c}, {0x00038460edfcc4f9,0x0006b8f1aa6bdf07,0x000909f77319aa73,0x000feefb9f8a02ca,0x0000025813a0580b}},
   {{0x000d3cac0c227196,0x000469ca151ed8bf,0x000a1a69cc60209e,0x000f8f1a744ab5d9,0x0000de5048b74937}, {0x00038d8e115ac04c,0x000f5c6b16d21719,0x0008e94e77df7093,0x000093e6aeb6637f,0x0000130388eea2cf}},
   {{0x000be8477f54e6e0,0x000265d60fe51850,0x0009146d69f258a7,0x00030bff7ff0c06c,0x000039aaf90e63a8}, {0x0007a739460342f0,0x000c3f795f8a38f2,0x00081a97e4703148,0x0005941bb5467b96,0x00000931ba5ecaeb}},
   {{0x000719d786f337c0,0x0002e704397dcdb6,0x0005c2fefd9c01cd,0x0002230f4a3f2055,0x000004525097c0af}, {0x000804784db8e765,0x000a43c8aa0654a5,0x0009194223bacf1a,0x000a3fc1ca957cf7,0x00000641053c8cda}},
   {{0x00038749f7144aea,0x000ea3d4acfd7a30,0x000ddd3ef170c963,0x000ba7be14814958,0x00007bde5833e72d}, {0x000da8b6fa687508,0x0001d72e02490769,0x00019ad31fa64e53,0x0009cd7caadf9d26,0x00007882dab27b34}},
   {{0x000b7316c67a7751,0x000adfc5d0b19f6e,0x000b806b2cb10471,0x000e7ea433750ce1,0x00009c5714d67b1a}, {0x0008b7bed03fd3f8,0x000eb1bc194ec0dc,0x0006320b5dd03344,0x000d93266c52a78c,0x0000bc82ce450b6f}},
   {{0x0003501b35f1341b,0x000c75a43e42f8e1,0x000aeb85ce53156d,0x000eb523adf27e4d,0x000081d837a6bedd}, {0x000546e2e4358674,0x0004aba5dd601b0b,0x00010cb9d9020eb9,0x0001cef7d9116182,0x0000c596b319c91f}},
   {{0x000a90f0e0b040d2,0x000225ff897fb228,0x000fa6122baf02d8,0x0005570aac79e600,0x00004828817ae36f}, {0x0001d31113ec3567,0x000da5eff1f8b952,0x000d417159e48861,0x0001b7baa1d412e0,0x00001f86203c3f13}},
   {{0x000a8da3fd19408b,0x000b778d9d99f60d,0x000c51c904aa716d,0x00051b894531f7a8,0x0000560b0e9a59db}, {0x000c992fa34bdad6,0x00043cd4f8bda28f,0x000a9d0d3f024fa1,0x000b55fcf530f723,0x000015ca194428c9}},
   {{0x000483d6f73c51e3,0x0002ba0dc2dd6d2a,0x000b917ffa4cb241,0x00099e20663c411e,0x0000d3a74d01ade2}, {0x000990f4a7a92024,0x000967b15c3d29b3,0x000df9208a9bccf5,0x00092926a3ccdca5,0x00008027c1483f2f}},
   {{0x000377c40b557f08,0x00064d684660d385,0x000183a27e001c36,0x0003289b18ed6be2,0x000079738d8e3210}, {0x000c74bbda948826,0x00084684b299a687,0x0003b3724d1bbcc4,0x0009f84f6f111286,0x0000943d1b48c8ce}},
   {{0x000a3bb098cafb4c,0x000fa0d48cafe044,0x00031b84d27ed230,0x000ed6942b56753a,0x0000bf3dd51bcddb}, {0x0001f1641b1d830b,0x000d1b0c1e272503,0x000ae75dba7ec851,0x00011ffc1c8fe0b5,0x000024c7557b8c52}},
   {{0x00011dc1d4636c38,0x0005e81a993957f8,0x00081adb3f843652,0x0000d39f6bc6d99c,0x000040f8ac3db7d8}, {0x0009811f4387f1af,0x0002c5156880731a,0x000e688677c501cd,0x00011fb5ca4a07df,0x0000123d8f14fcea}},
   {{0x0000e71d607039eb,0x00051d3a45461fbb,0x0003240912b70e21,0x00019a82d2f01d53,0x0000796ff08c80ab}, {0x0007a863c57c4aa3,0x000f87c49a2732d8,0x000630d982aed9ca,0x0000a36fb35eac31,0x000038e8cdf8c3e2}},
   {{0x000618266cde8dbf,0x000f3d72fd3680f1,0x0006e50724e15997,0x000dc0e7b8f13b9b,0x000052139082b7b5}, {0x0001f1d8ce4396ea,0x000007ed21424d43,0x0001aaf6b37a1a68,0x000b661f375696d0,0x0000a1c0c55863aa}},
   {{0x000368b4ed80940f,0x00058a6fcedd3014,0x00097579f67e6d05,0x0007f58c208c49ca,0x0000e3d7a8292359}, {0x00032027e096ae27,0x0006b4b393665e20,0x000dcdffcb1f3e1e,0x000e82b6da26f32f,0x00009422f1dd097b}},
},
{/* digit=24 [{1,2,3,..,}]*([2^168]*G)  */
   {{0x0002cfb9db3b3818,0x000e54df0a4b263a,0x00004e61f9c3a2de,0x000324f28d06e97d,0x0000b1adfbcc2449}, {0x000d9397e053a1bd,0x000696daf7076ec1,0x0000ac7abee2be5c,0x000173b0ba1e1481,0x0000d2ae779c530f}},
   {{0x000d97a205b9d8b0,0x0004056756d40435,0x000f8210e6eb8f06,0x0009ead5e88a8bb6,0x000070ef12dec9fd}, {0x00095053bcc876ae,0x0007c7404ce34d84,0x000a1db5e12a7533,0x0005acf22b49e1b8,0x0000c1f2051f4bfa}},
   {{0x000eb79b6828f364,0x0007c1bd5b9eadba,0x000844b0c9d7a025,0x000fc9ada01e0d1e,0x0000b625175c87ed}, {0x0009fdd9669b6210,0x0006f6f87b981410,0x0000df6bc88a2ca5,0x0003f9fe2eb78817,0x0000cea06f4ffa47}},
   {{0x00081b5c4e83d33c,0x00089efd488b43ed,0x000eb4d0fd9f3587,0x000393564a620f9d,0x00006927bdc6c6a7}, {0x0008df79f9e0f036,0x000e9cd7e1a945c2,0x000a348f12868661,0x0008e01cf4e8d0ff,0x0000bd4c28499853}},
   {{0x000a091289a8619a,0x000fc671b1732618,0x00090c632ef796e5,0x0008fac64e46e590,0x000038062d4be66f}, {0x0004a200573274eb,0x0003f92713946c74,0x000dc0e20d07b67e,0x0005a6891223b26b,0x0000e2d93f29b0a0}},
   {{0x0002e533f36d1411,0x00043dfca442f23e,0x0007c023ae84bb3d,0x000c3ba804a48d6b,0x0000e16a8fa86431}, {0x00052adddd472e03,0x0006dd1ee1271b54,0x000a275997d405ee,0x000b3520fc6f1dff,0x000051ac53cef391}},
   {{0x00014b84444896b8,0x000f794027fb7efa,0x00084487d64974d2,0x00089b6fdcd0e8de,0x0000c45b260ab489}, {0x000bbc2d84634875,0x0006efbc476ca8fc,0x000f443c0d1b2b3f,0x00039bd1d005b7c8,0x000018f2e6790c01}},
   {{0x0006e8c06d75fc1f,0x00064249a89f5603,0x00045e7dd2dcf7bb,0x0002a691dd1d3de2,0x0000578dc4cdbd6e}, {0x0008903df2ce7a06,0x00083c39afac4c02,0x0006404abaee3628,0x0008187c847c3114,0x0000304c0d904e97}},
   {{0x000dca2a91f6791e,0x000fbbaa9efcae51,0x0009c7ac12abe418,0x000739f9d2e2f455,0x000082f4b52dc9f7}, {0x00030274073e81c2,0x000cdbb596fca771,0x00084f70cc0276fa,0x0001dffd819fc9a6,0x00009b47fdde9f7b}},
   {{0x000e103459b19402,0x00093b013e93358d,0x000532ad3ec881c5,0x0006de31574c9349,0x0000db1d445d37b4}, {0x0005b87df239fd84,0x0004d51d24eec644,0x0003c6259c718af7,0x0002f76ea1c4a4f4,0x00000c0e5d7b0be0}},
   {{0x00090f4721b33f2e,0x000b1edf04ea6a45,0x00045efe72124f1f,0x0006d918e53cde97,0x00007e1043345f04}, {0x000a28ee4d0c7e6c,0x0009c7253b1bc3fc,0x00043e643847e339,0x000fc4db59534837,0x0000b6a0a0c0fd12}},
   {{0x00036c327d02dccc,0x0001ba68bcc2fb68,0x0005e912d5ad0098,0x000cfd5b24b44c00,0x0000c83d210411fd}, {0x0007ec1666fba0ca,0x0006747546353652,0x0006da9c26994819,0x0002b25cdcb1a855,0x0000593426821a73}},
   {{0x00014eda714181da,0x000ac067b341ec12,0x00045df1f609ac13,0x00076b5f4b4c97a5,0x00001240501d4d20}, {0x0000c231409ca976,0x0007c0638c436efa,0x000fb46cd254cc1a,0x000a2774e363afdc,0x00002c2adc363942}},
   {{0x0009df056e464833,0x000033736356c67b,0x00051bc52a55abb2,0x00064b7b93c098c5,0x000082b49f9e15fe}, {0x00021ad4dff8d47e,0x0004637df4d69ec2,0x00045650979caf61,0x0007137f13dc64bb,0x00004c589d9f91f0}},
   {{0x000a8ab3fd40e095,0x000e27313ea927b6,0x00055988be455842,0x000bfc3b51d1e21f,0x0000716dd73562bb}, {0x00011e54e8bf3de2,0x0005fb85be3b633c,0x00011cca69a0e77b,0x00090f3651072909,0x00007e764960fa65}},
   {{0x0008b33070d3aab6,0x000b3a2cd5e5e4ac,0x000fc91732643672,0x00013ef2eff79b1c,0x000065ca49bf0a7c}, {0x000da59b3efb9983,0x000cd52f13415a8d,0x000f9a5308a5b922,0x0004d77e9ebbab3c,0x00005986e7c256da}},
   {{0x0006b5cff3513cc7,0x0009c198f7dd3a63,0x000f16f86bb0cf8b,0x0007bf48d4052241,0x000060575d94e13a}, {0x0004e169f7aa1811,0x000fe509ed1c36f7,0x00040a491163a3ec,0x000caa5aead61f3c,0x000058c95fcefe8f}},
   {{0x0001b6e13cda46f1,0x0005242faed0a399,0x0006b59707948241,0x0006dde3ba5bde66,0x0000d52e6bcc26ab}, {0x000a1e78608dd3d1,0x000ada076586768b,0x000dc1afa4930db2,0x000817c9575714e7,0x0000fc7bf7e07c58}},
   {{0x000accdd9eee96cd,0x000b158cec376b47,0x00002c42a0ca277f,0x000e50413fe413e7,0x0000d1764ef947cb}, {0x0007cde7b3ed7397,0x0008ece9e1c0041e,0x00025b21250cb745,0x00081bc556851329,0x0000cff95c4701b0}},
   {{0x0004cbd8088b454e,0x0006ba9e0c8a63ee,0x0002447cbdb7f32f,0x00019ad377d4186b,0x00003e982abb3702}, {0x000c1e4c2a2a5938,0x00048773f24f06cc,0x00085942372c3686,0x000c8f213b4da795,0x0000bbf1d33f5040}},
   {{0x0000973da50c991b,0x000ad22d6ee2726f,0x000fd777148afcd5,0x0007a135fc718b20,0x00009e8e77ead080}, {0x0000f4499a7703de,0x000d818e36f37f5e,0x000807bbe6972930,0x000f4f4b7c77b823,0x00005b82406ab27f}},
   {{0x0008be3bd3790620,0x000d2dce4a92ba8b,0x000952e37d64b7a1,0x000eca040a73c5b2,0x0000a9e252ed438a}, {0x000956bc39d3bcbd,0x000fe32b2d63dd43,0x000417a181a31c9f,0x0002c8067133b85c,0x000008e4790fef44}},
   {{0x0001ae9255c09801,0x00011b4a739f98cb,0x0004a45a14bd8638,0x000b2f4a5c31e11e,0x0000e5d55feacb0d}, {0x0001b068ff5cc292,0x000eeeb8a4f47466,0x000848c24026b389,0x0002b0336b21a458,0x0000e5bf8eca1dc7}},
   {{0x00087d0ad886aac2,0x000a9771b64503c1,0x0004045ab5c16878,0x000aed907dfc6fc7,0x0000c6360bf9800c}, {0x0005bb5b9c972a3d,0x000dac9a6dba2429,0x000a79aa6c9e6f88,0x000ac1c0ffbf2492,0x0000e29d50b11c26}},
   {{0x000f483d309cbe6a,0x000a40bced4f9f0a,0x0008023e35b020d8,0x000932c06e986db3,0x0000d8f2c9dbabc6}, {0x0002e1de7400e938,0x0008d2be5e4d1929,0x0000680bffe3e18a,0x00006368e9771d2e,0x0000c5bec99454db}},
   {{0x000662a74a55d1f0,0x000f046f66d82af9,0x000dc4794e3fbf28,0x000dd8a3a72ab4d4,0x00009779f455c7c2}, {0x000bdafc3d19d8d3,0x000427d6a6dfd893,0x0002e6255d5a7509,0x000aff5cf8fef995,0x0000da67cfc0a9a8}},
   {{0x000f62a2c160dcd0,0x00038f90eaef4c23,0x000a65d5a34e6c5e,0x000a3d35865519a9,0x00007c48aae8fd38}, {0x000aeda50068527a,0x00027c90936ab7e7,0x00079324c2c09ef2,0x00093791ecfeb6e8,0x00000871f6c9b0ec}},
   {{0x000fb68d84d835d2,0x0009661dc1e6b1f0,0x00094f8d7c90caf3,0x000b91f2e5b04675,0x00006897ae285012}, {0x0008a08a4d6755dd,0x000b3991fbdabcf6,0x000bf17e8403ee41,0x000d64a33e343e3b,0x00002c7980e379b3}},
   {{0x0006232d2e11305f,0x000203c07a6f3305,0x00015509d966be49,0x0009a37a8878ffbb,0x0000f221101fa9b5}, {0x000564aabe30129b,0x000f836e64cf6c9f,0x0000c8022c6f2c93,0x000b865fe752628b,0x0000e0267ea1ae8d}},
   {{0x00092f193bc042b7,0x00044237c45822e1,0x0002c4168f085b53,0x00071d30d192bd83,0x0000a76e9e42df62}, {0x00082fab88911b55,0x000464db0eb552a8,0x000a7c3ffc85345e,0x00046953be02a681,0x00001889c8d40ec0}},
   {{0x0001369a5e829e5c,0x000b5607aa419d03,0x0001d84c1cbb4c6f,0x0000edb5ac59a624,0x0000043f2c04829e}, {0x0008f758ea5e1853,0x0009a87cbd9f82a3,0x0008fc6018bda40b,0x0000b36e65e75e2d,0x0000d515f74d3569}},
   {{0x000cf4fda79e5acb,0x0009d630215f534a,0x00085756e68b83b3,0x000cb1ac748b2ed0,0x0000031725995d37}, {0x000841ac5ccc2c46,0x000add9d50696735,0x0001754bd7d7dc96,0x000dd54147e410fd,0x00005296e953399d}},
   {{0x000b2d0bc8fa5bc5,0x0007000c277bf6b5,0x000a08a5d8a5ead6,0x000046d14625e6df,0x00001fdfedce59cf}, {0x000430b289fca32e,0x000ebd9bdc3f6bc9,0x000ea0edee36ff0c,0x000b3e4fe187cb58,0x0000d66af213a900}},
   {{0x000968b5fa9f4d67,0x000dc7a362e700e0,0x00007e7722d4066c,0x0001d0399a9748bd,0x000010989c076a4f}, {0x000df35ce40cbd89,0x000f8743293dd5de,0x000a24e2cab55c5e,0x000cb3e66f11448a,0x00004d874f8f05fb}},
   {{0x000f0e8a518001b4,0x00065d04ef0fa365,0x0008d4d25ee605eb,0x0004721a3915cdba,0x00004c0e1b8f5113}, {0x00024e88b6740dc8,0x00036e1d4f0ccbb0,0x000c4e37289087a5,0x000af2288fa05c1f,0x0000bf395cc2f8b3}},
   {{0x000c9a1deb8568b6,0x000020fb3d321e71,0x000f8fb81a35daea,0x00096a88b6f2662c,0x0000d51afe8f4906}, {0x000ac6e51803a198,0x000f0621908081be,0x0006f463ce3d24b7,0x000ee7f27cfd9ddf,0x0000c6865caf2284}},
   {{0x0008b7db743f4ef2,0x000bc7d11dce32c8,0x000f2ebe83793909,0x000796b398f9222f,0x0000c70ca4505e49}, {0x0009929cb1131b10,0x000825888e79df4d,0x000d8740a7826f29,0x000a8b4d3a112cf1,0x00000384cb6270af}},
   {{0x000125b3ab480953,0x000632d05106cb64,0x0009558453451c25,0x000433a73d577da4,0x00009570c16ef9f4}, {0x000aad3adecf263d,0x00010c76e102d7df,0x000c6a836f1c3d8d,0x00047a8e774a5854,0x0000ad4b6730e92d}},
   {{0x000990ff0d796a03,0x0008af0e8b02be7e,0x0000c00ad5fc6247,0x000a0f5aae8bf403,0x0000d2db93bc004b}, {0x0008a79d85d5ddc0,0x00076bb07f34e48c,0x0009eaed5e907caa,0x00072458db343aa3,0x0000ea6e007adaf5}},
   {{0x000f169d23233f3a,0x0005d7cb637fe00d,0x000a0cf6c3e32279,0x000bdc7f897c0e1d,0x0000651f5d8d1d6b}, {0x000af191a230c767,0x00025daa5e4add61,0x000abcd7ebd52727,0x0008dc5a753636d0,0x00008bdd37ca70bd}},
   {{0x00016c217cd93fe1,0x000dcadce6e2c239,0x0004e42f865b97a4,0x00080ad04ed4eb17,0x0000491ccaacb214}, {0x0008280231963324,0x0007187b479a145a,0x000dcd0ed3c3862d,0x000f1f5f4a88a301,0x0000da2b7ef7ea12}},
   {{0x000ae33b126e48e4,0x0002b494e237f8e7,0x0005acadb404a0b3,0x000fd95beac474c5,0x0000ee5cf3c0bec9}, {0x00033b97df3c8c32,0x0003976808fd336b,0x00045c16abd905fe,0x000b626f436981aa,0x000055c5bfa5dd27}},
   {{0x0005cbfc3dd9b4d7,0x000f8c068a877196,0x0005b029bce23edb,0x0009bd478d472574,0x000046107143efdd}, {0x000f75f1266bf52e,0x000138e49bb67116,0x0006f19e30204672,0x000b2eff43df9f3d,0x0000f1bc7d1c685c}},
   {{0x00027c17078c4322,0x000c977fedb7cddb,0x000290570e1961b9,0x000885fedc2f5cc2,0x0000c3fefca39cbd}, {0x0000a36c2af389a8,0x000d3da71ceacf88,0x000aa846396c610f,0x00090a703977a932,0x0000eb776400586d}},
   {{0x00024542a296e775,0x0002f2837a353f34,0x00009c731c871868,0x0006db2dc710906a,0x00004778ffba1b81}, {0x000bfecaf06defd3,0x000f5592b70b6b33,0x000da6114fe3c105,0x000ad7c937fda461,0x0000c13e6517c266}},
   {{0x000a829855938e83,0x000e6de54b72e363,0x000ccfab92eeb5d9,0x000a258eb93b0e20,0x0000dffbb5f55e61}, {0x0005e431acc093d5,0x000ce964ce617f65,0x000e9b4600cb6cc3,0x00072d1ab283a1e5,0x00005d787c5f1c7e}},
   {{0x000fd47deadbf02f,0x0008bc4590684d2e,0x000f311f011e8021,0x000f52910c762671,0x0000a17ef8e3ab6e}, {0x000fd2593e43bff7,0x000e9be40632af47,0x000e61da35cb5ff3,0x000d0ee46871068e,0x0000764196f208af}},
   {{0x000b3edf0290a8fd,0x0005fb47c387831a,0x0004efb4fcae8196,0x00010ddad7dece18,0x0000cfc53b417491}, {0x000f23c4cb632f9e,0x0005d91f80676698,0x00084180ac42a1ad,0x00026ed116a81d62,0x0000bedf5f9c9013}},
   {{0x0004c9f97e3e0442,0x000ff1d09fc9f227,0x0008e6e234201851,0x00083c36a65f17d1,0x0000ea61e2a552b6}, {0x00091bc575eaa945,0x000168ff522d27d2,0x000f04d6f9e7bc72,0x0007480f7268bfa7,0x0000868c73ffba41}},
   {{0x000c2db7be0eead0,0x0002ff7191359f85,0x000ea90d7511e784,0x0006315a06b1e9c5,0x0000c19e28326fab}, {0x000f0cfe9206c550,0x00043553c06a8af8,0x0005f800489389cb,0x00091d39dbed97f6,0x0000621b037c5089}},
   {{0x000e63596e78cc4c,0x00014c06b4a81c52,0x000e87d035385c8b,0x000fad184ddfdbb0,0x000049dfb67534ba}, {0x000e17059f707727,0x0003ca1db56b7071,0x0008af1903a073a8,0x0000ef934949033b,0x0000d882de443292}},
   {{0x0003f0ab2cf89408,0x0007ef948f519163,0x0002653c872b0b17,0x000a04ad28dc3078,0x0000882984a5b903}, {0x0005d0c6a19d2bbd,0x000bb6f782cbb809,0x0009070644b9e7f0,0x00043baaf739882d,0x000012be0ff5b326}},
   {{0x000d23d0e165dc33,0x00021e2378ce358e,0x000b8a0873d47ce6,0x0000b94e2bb0b9fe,0x0000246e8af129e1}, {0x0004ec703ce2b4df,0x000acbc077cf459f,0x0009940c1e9b4ca1,0x000eb03613b4f20e,0x0000c598bb9f47d1}},
   {{0x000c62b45036099d,0x0001467c65d89744,0x000be1943a9dee74,0x0006233c511525da,0x0000a11055563c6c}, {0x000a52c651a3be27,0x000d184449a6ae00,0x00033bed1cda5111,0x0006b3963c06f4ff,0x00003baaf9a7d3d7}},
   {{0x0000c9d7fc63668b,0x000c5c039cde52fb,0x000b223516886c9d,0x000c12b02bd59955,0x000000cab02e60c7}, {0x00016bc81b69442a,0x0000155c3cee8cb6,0x0009ba2784148670,0x00070fd1093281f4,0x0000d956d9d04a50}},
   {{0x000f28b638a7e819,0x000ec980ddc39561,0x0006f247a54155cd,0x00010022db4a96d2,0x0000d774e4ed787d}, {0x0006e2e078637d27,0x000cee0ae06a1a9e,0x000cfa3541c363e2,0x00098d0493483ee9,0x00006843cb3ef74b}},
   {{0x0006591d4b66947f,0x000714460a8cbaca,0x000768f55b452ce9,0x0002de7830d24643,0x00004197ed96dff1}, {0x000b472400dd0f70,0x000f4b1e70936521,0x0000338ae59f5ca8,0x0003c66feff11b08,0x0000ada31f6a29ca}},
   {{0x0004eb694a2c2152,0x000ae5a57ab42479,0x0006f89fed83a43a,0x0007c2064a543a2a,0x0000c2a3868fd5ec}, {0x00039408439d9b28,0x00018acd1f11d337,0x000e6cc19715ea67,0x00085bc2c1d235e7,0x00001ce6e9739905}},
   {{0x000dfe0d809c7bd0,0x000c8f1050ab04e5,0x000a4176fd7b2580,0x00097c6d91ad78d8,0x0000af556ee4e2e8}, {0x0008b73921de0acb,0x0001cea78400162a,0x000ce217452ac9c2,0x000f793e2a4eeaef,0x0000e61844f1d637}},
   {{0x000f1bc789a283b1,0x000d780836f40491,0x000e5402d72d3ac3,0x00073d9a1c5ea388,0x0000b192421e5cc4}, {0x00099989dc84cacd,0x000ccc6e75b85c0b,0x000191ce2b0a8482,0x00092f939961d03a,0x0000a3bc8663d837}},
   {{0x0000653056e6f8fb,0x0000b4d133a7ca99,0x0006abe4084861c4,0x000302db40327674,0x00007b4d51b9bf8e}, {0x0003211220a255d5,0x000bb2419e6e05b4,0x0000c2feac997152,0x000ade26ff47b663,0x00000518677781fd}},
   {{0x000b8bacf902b0bb,0x000487db303b3283,0x0005011bc8d4b4eb,0x00019b1c89f42d75,0x000043d74bc8d09d}, {0x0006bc98adba3503,0x000c851c19276574,0x000ad72ec364eaf8,0x000c1fe3c7659610,0x0000004512228d40}},
   {{0x00099b7ea7b979b7,0x000476fb3bcd6d2d,0x000cffbfecd78cd7,0x0004f5a1e45a9e86,0x00008a61cf4d3702}, {0x000c8723d502295f,0x0003558cb288d06b,0x0002f8586f137685,0x00009dc9db26a134,0x000033effd03beee}},
   {{0x000c4cdb30cfb3a6,0x00010c9db4c8d7e0,0x000c8d9df6d09b8c,0x00066ce0ba1a4207,0x0000fd495f77c52c}, {0x000169f275264daf,0x0005f57d8362fb0e,0x000ad722280c2b74,0x000c7afdd987f749,0x0000dc229b03398e}},
},
{/* digit=25 [{1,2,3,..,}]*([2^175]*G)  */
   {{0x000ed8452666a58c,0x000026a9c3c2b0d1,0x0009064084bcb6e0,0x0003ff7c57411c26,0x0000fc20755d3556}, {0x0001c505294dba30,0x00068b7dd31ea08b,0x0001eca74a30ba28,0x0002b9d70ba90e99,0x000094e142ce762c}},
   {{0x000783e979f39254,0x000a6f4c89a7b81d,0x0001bf7fa1efd130,0x000a9e125c2144fd,0x0000b2969045b265}, {0x0009634b9db65b69,0x000173599d8aed8e,0x0003563f335c82e3,0x0008ab4aa7a54f40,0x0000df088ad922c3}},
   {{0x000b066bb3fd30a1,0x000adff0354ee5cf,0x00024e36c429169d,0x000e1d709cf85235,0x000036f4fb31155b}, {0x000af011fbba712e,0x0003706ba1a14826,0x000aea73e6ef0f0b,0x00044df9928b3177,0x00002bf6af33eaa2}},
   {{0x0004f124237b64b8,0x000963ecfd078d08,0x000845dd8688ebe9,0x000324d7b8a70cf6,0x000008fc59cdda4a}, {0x0002b2ba3585862b,0x00053df29386a903,0x0001ec29bb66825d,0x000dc805a5a8db43,0x0000b143a98ea1e8}},
   {{0x00094ce12ae381b9,0x000bf6ccda9035ee,0x00006eaca3a7f176,0x0004df363a657e46,0x0000ae5a380d3cd0}, {0x0008d15ed251b464,0x00008aca5e649bec,0x000f20f071f5d6d3,0x000285f47b3b359f,0x0000d65f03537e4b}},
   {{0x000ba24f111661eb,0x00040105eb049e93,0x00024b578edced48,0x000068e6dc9ba1f4,0x0000f8f66b8983e9}, {0x0004df4d7ed8216f,0x00069e2cbecf872d,0x000e73754bf07f37,0x0007075281d89998,0x0000ec85fbc7aab8}},
   {{0x0000deea5ba5b0b7,0x000dd2d052999a3c,0x000b02d42e6a116c,0x000cb63e9775fee9,0x00002b0520111545}, {0x0006f7d31a3b4ea6,0x00082bbd9b32bc50,0x000b12a97e589307,0x00067168bc5f37e4,0x0000b000c06aa73b}},
   {{0x000bf22765fa7d04,0x000fdd6a537013b5,0x00080db9859805be,0x000ce327a5e29d42,0x0000f53916fb76b1}, {0x000f61f33ddf6269,0x000e1085d103714f,0x000809ee34206238,0x000b1c8c50d4b7e5,0x000099f450e15f8e}},
   {{0x0006051e4c79e9bf,0x0002d66a9fea658a,0x000be7b231394cb7,0x0008fd37f31ed5c6,0x00004c88f374aa6f}, {0x000721f4aaa499e0,0x0005e3fb2a6b0fb0,0x00092851d68b3a7d,0x000913a788097d3a,0x000060e7f8ae96f4}},
   {{0x000be731a3a93bc2,0x0005821adc1a82ee,0x000030efd42bbf46,0x0007bba10b6fa4ef,0x000047aa4c7a7b09}, {0x000c632f60c77da5,0x000a7223523e8b8d,0x0004579cf6ffbc26,0x0000f654f6ff1134,0x0000825653ce8025}},
   {{0x000097ebc1aa2b92,0x000317a0333ab2dd,0x000a0db380788939,0x000612fcf55e7137,0x0000648487f992c1}, {0x00013363fcef2614,0x000cceabf129dad0,0x000276be26239c81,0x000ad34ee761de9d,0x000006a7a345eda6}},
   {{0x00067ba4a493b31c,0x0001dbf7f0264bf3,0x00095914b54f20a5,0x0006abf696e06297,0x0000ddab96e4bf23}, {0x000c70aed25ea138,0x000b01cbbbe74ff2,0x0008544c5fa1d09e,0x00031708fc8c8746,0x000047a670de96b3}},
   {{0x000421e64bcb626e,0x000746dee0b5f133,0x00010346caea638c,0x000ed2f6e7680bb3,0x000006f4098b5d4c}, {0x00014527512a30b9,0x000d5589a59a0996,0x000d0c180f3d867f,0x0004ab9e73254f52,0x0000063d8a3c33c7}},
   {{0x000c595d314e7bc2,0x000b267899ededa6,0x0001ed5d32ee7464,0x000612fcef423c0a,0x000017e76ea89cc7}, {0x000ce1fe7cda917f,0x000a9a893f1627cc,0x000c74f6b12d8016,0x000e60ccd6de849f,0x0000a5817e3e3144}},
   {{0x00041640821ee4c9,0x00037bc619921f35,0x00072879f1583eab,0x0007b1e490caf61d,0x000098ad9f4876ae}, {0x0001950a41157f70,0x0006e8da3a7e1e18,0x00026b95fa9d7e1e,0x000a10963784eb84,0x0000ee4ed6e542e2}},
   {{0x0004cc5ac751e7b7,0x00028d4211bdb79d,0x000de4fc693f9647,0x0000641c72d3d2c8,0x0000b69cbf64f44f}, {0x0000ca2f4bf94e19,0x0008612894e23da9,0x00017d60b1a5325f,0x000b5c7a437f6c79,0x0000be7048726c9c}},
   {{0x00080bfe1dc5c055,0x000a9ebeeb57b4d8,0x0000fe6a3d738add,0x000f5a1f0119d3df,0x0000c686e55b6eaa}, {0x0000b50dfd0b7ec5,0x000b1a497c219cb1,0x000546c96bdd0264,0x00042aac0935148c,0x00008a947fac9dbf}},
   {{0x0008d4e49ccd6d74,0x000c48bd5580c0b4,0x000d473b2ff8fb02,0x000af3875235e907,0x0000fab1ac5e2188}, {0x000a3bc97576ec06,0x0007ab7e7d2f030f,0x000305600e8c946e,0x0003b3e0a5c9cc70,0x0000d8260aa28b01}},
   {{0x000304f70bba85cb,0x0000f4a0d3110368,0x00015eec1ad090da,0x000a46c170e87024,0x0000fba35ff3461e}, {0x000019ac1e919380,0x00031afc415f6279,0x000ba0e0fa47638f,0x000c4836c65cbbbc,0x00002160efb034e2}},
   {{0x0001073615cd9e45,0x0007a1243c06e6c5,0x0007b3d8c498ec04,0x0005f0ee5a8809b1,0x0000cd99e615cc56}, {0x00012df7851dafeb,0x0009f79061e281e3,0x0000c590ef156f5b,0x000aa0d0d62b7188,0x0000ec9746fba39f}},
   {{0x000a9c1c8ed1f7a4,0x0005681d5ff21d98,0x000a0794a09e43bb,0x00083695f00f680d,0x000012050d9a61aa}, {0x0007c4e90747e405,0x000b662a3686a89f,0x0008e33536dc05eb,0x000bb98f4de84730,0x00003868fbbefb53}},
   {{0x000d2c3cfdcf7dd0,0x0003723fcab42b09,0x000f57ca341a9fce,0x00055573d905f707,0x000080f9fb1ac8e1}, {0x0008e849ba7a5317,0x00067d9a147f7c08,0x00048c33607d3558,0x000e78f02846abaf,0x0000320fd327ccf0}},
   {{0x0000798b18bd1ff8,0x00002fdd2905aa78,0x0004267cd52c2e30,0x000b5f727ea3d643,0x0000b96d16d95605}, {0x00010494b45706bd,0x000da43d25f87bb3,0x000f30076e7f58b8,0x000d5a19b5e45b87,0x000019448d72d053}},
   {{0x0008cb9d3210a041,0x0003cafb52691ecc,0x000c3489f6bc7d46,0x000e1b2e59b10a67,0x0000769788c75641}, {0x000b82dbd6cb838c,0x0005636d5f228a53,0x00008536e7066d6e,0x00080843aa1c6169,0x0000971da0e26ae9}},
   {{0x000a86bc49a2fac6,0x000fd092e77a01b3,0x0006fb5563b8420b,0x000a86a20573007d,0x0000941b2a21ff40}, {0x00063080658ff2ac,0x00027424ab36140b,0x00051e2998780436,0x000e394253bd5157,0x000075bcd77049c3}},
   {{0x00040907f8f875d6,0x000df6c26bbf92eb,0x00010bbe79c9d754,0x0001e9b58cea6181,0x00002a6b802d45f9}, {0x00041aac6e7394b3,0x00037d57ef10a79c,0x000a6f40c445b6a8,0x000364dc5277eb6e,0x000019fe96bb8633}},
   {{0x000c61f385f63cb6,0x0003c2bdd1270b0f,0x000e942c241250c8,0x000d5d07d153f109,0x00000920d092021a}, {0x0005746724d81a52,0x00023bba3299229f,0x000413032b7ffb89,0x00094c318c51a1de,0x0000a9bfe775c2fd}},
   {{0x000e2393191f4fd2,0x0006b3d6ada1cbcd,0x00076960643093e1,0x00025bf84579f358,0x0000c94a8b3f2366}, {0x000b9c05c437d8e4,0x000398d9f3c86922,0x0007090a23d4ae42,0x0005bdb72c31c12e,0x0000ac3f5f4176a5}},
   {{0x00008fc6b6af9917,0x000fab5cebbd3425,0x000440dd70d5270f,0x0002fd484740d0dd,0x000048ef841e8016}, {0x000fe0edfc6fafb1,0x0005e7300f27a8db,0x000ba4ec9eadfdf0,0x000a976d06555ffe,0x00002c56f83ae25f}},
   {{0x0004203d39b8c34b,0x00058125eddb77f8,0x000e39dc5ed8b1be,0x000789abbf2441f6,0x000000f6ee71a5d6}, {0x0006ecf57d0ea992,0x0007f7e06c43ba45,0x0005b4baadcae0f5,0x0009bde1643de40f,0x0000c324341f161b}},
   {{0x0007f55e126d4682,0x000f56748e098017,0x000a9bdc2ed325f1,0x0004684116004acf,0x0000d8607e65a9fb}, {0x0003e276009d660b,0x000ddd10c5a10e57,0x0009009a03a525d2,0x000448226cb45c3b,0x00006b0cdc18e9d7}},
   {{0x0009976e1337c262,0x000db73d68e5949c,0x000b768d96faadeb,0x0000697e158614f1,0x00002dfa557bcc4f}, {0x000da17be93c6d61,0x00019504f5b9ccd6,0x000694da124866c6,0x0008c61121353c8d,0x0000c6ca5801140b}},
   {{0x000ad8ce964021e7,0x0009932b82b3c245,0x000ef9898b83bffb,0x00048a8aa220c647,0x0000e8d3ac7082c9}, {0x0002091bc2d124af,0x000c15b15ff41faa,0x0007c6fb7bd54c3d,0x000f65486bf3abc8,0x0000b2b0564edeb6}},
   {{0x000c5575b45afb42,0x0009cfb8912d4e77,0x000f6e557e9ded64,0x000f005ec9bbf542,0x0000570dfff82671}, {0x000fb7888e084bd4,0x0008b37fe5b42b3b,0x000649aeea024b23,0x0001d804e7dc0495,0x000098ca2559e7ec}},
   {{0x00066eaaaa07e869,0x000b636085863bc7,0x000c259c80db6fac,0x00049f2add2549bd,0x00005af3c6e941c6}, {0x000928c02e30afbc,0x000c408a88b8b36a,0x0001d9e9d9b5356a,0x0008cd8b67a5f1cf,0x00006542e4865d8d}},
   {{0x0001fe87adfb6cc6,0x0003386781417306,0x00080515acc826fd,0x000082a0e758b13c,0x0000afe3247a1485}, {0x00008b9b6ae8a751,0x000d3acf51e10fcb,0x00061b9d6b8cf388,0x000d0c244a556069,0x0000a6778b87a97f}},
   {{0x000fdc1ecc4c7e38,0x000c96db68ccd840,0x000e216aade9fe47,0x0008be695f89dea3,0x00004f1a6a51594a}, {0x0007d725a7b162b9,0x00091dc817a37ddc,0x000b58d46c5cfda1,0x000f18f0a5d35078,0x00003365b1412978}},
   {{0x000d22526a1fc900,0x00024d70705d2e44,0x0000c45f40d6d10d,0x000079d94b6b10d7,0x0000f201022b216c}, {0x00066c5658fde413,0x000d4e27601dcec9,0x000230be7a8d2bc7,0x000fb58fcce3e1ff,0x0000394ff6b3033f}},
   {{0x000c5098132c9af4,0x000af61e7868d890,0x0002d15aaaac4b0e,0x000b7d1194ded3e8,0x0000550bd2e63ae6}, {0x000318eea5399d41,0x000a81638b803fda,0x0004aa12dd989bff,0x0009444ea124d0a1,0x0000fb1b8994667b}},
   {{0x000796944c44d6a8,0x0009d7e8613795ec,0x000adac4491df144,0x000801115fd62073,0x0000f01732dd9a83}, {0x0009d253aa0a6332,0x000ca9d6d59cec57,0x000ef801006de5e7,0x000a02a132f958b1,0x00009476f97065c1}},
   {{0x00077c0d34c35659,0x00018b9f1e9e336a,0x000e08002ef1105b,0x00009dd3e6d08bf9,0x0000aff2f2256138}, {0x0004f853a80e75d8,0x000debbda681b575,0x00097fd7ade71853,0x0007fa06f041df81,0x0000b332e0892781}},
   {{0x0009be8b9c20cda9,0x000545cd0c9805d9,0x000b9418389f7aad,0x0007f1eef936fe5b,0x00002ca0754405cd}, {0x000db1174a1e0359,0x000783eaea929d65,0x000e4fbf202628cc,0x0008b762d9e24249,0x00004fdfd9c7384f}},
   {{0x000605463428c6ba,0x0001f0b409a565f5,0x00045ae112f7205b,0x0003b25778bb78ff,0x000013045bf65ee5}, {0x00014ff03ef77fee,0x000f1fef8befe00a,0x0009ade22689cd59,0x0006a75578f0ed1e,0x000099f3ec14268b}},
   {{0x0007d91ea1b3c3ec,0x0002f8823a4aa205,0x000ca451e2d1a705,0x000b5cebbb336a2c,0x0000d2466e3e218b}, {0x000f42fc8cb762d2,0x000e5690211f3ac1,0x000d074507e312aa,0x00013fcbb9bd7345,0x000007c4b8266c22}},
   {{0x00025c1375913eca,0x0005c790822099d4,0x00067dbf694e45e9,0x000056208f3087cd,0x00005670fbf60887}, {0x000b64a66f5b8fca,0x0009d86fec286717,0x000ff4952d5a56ae,0x00049b08c3f55fc0,0x000077fefaee57ac}},
   {{0x0002d7c98379d445,0x000b009edc8a2988,0x0006fe464d000bdf,0x000de076f95979e6,0x000004a61164a61b}, {0x000b871effea31ae,0x000d10c21a5456b3,0x0004753bf2d3de26,0x000d8541dbff3183,0x000067ecf4a49269}},
   {{0x0006952151fe690f,0x00038f2adb5f7a17,0x000b62a8d0351580,0x0004e5fe794b15d1,0x0000004ceed9ae45}, {0x000ea7cf0386fac2,0x0002b1fca7510897,0x0007a04ec3b62ff1,0x0007ebf54181df1b,0x0000008e04b1b584}},
   {{0x000148e41dbd7725,0x0002d2942654d147,0x000c544f72b419f7,0x000149169f30d3e9,0x00002a2c22418540}, {0x000ee14634dfb02e,0x0000147869f35da9,0x000933acc5f074ff,0x000ed094ee878da3,0x000065106522fe35}},
   {{0x0009482f1012e7a7,0x000038a566aeb3eb,0x000c00d3b51013cc,0x0000e56d5e924347,0x0000fde089e046bb}, {0x00054fec731b4b3b,0x0003e9fda0620307,0x0001a35bc12a136a,0x0004eecc1064b85a,0x0000f1f5763f46c8}},
   {{0x000a56da16d4b346,0x00097ca21c4fed29,0x0008de4867fba9d0,0x0005e106d7ac006d,0x00000061987d3a2a}, {0x0000f869da28ff0c,0x000783c4599c8b40,0x00028cb0d3133f70,0x00061cd911c9b8ee,0x0000d7e28754e0af}},
   {{0x000f0f272ed91fcd,0x0000ccd4a3735a85,0x00025253c85214f3,0x000c75b81fe5be19,0x00008dc98e161e8b}, {0x000affe585cc3a25,0x000d235bf97a7120,0x000b34581724952e,0x00057d0581e7dc3e,0x0000cbff4f3352ee}},
   {{0x0000a0e87d8cc7b9,0x000361d280d08d32,0x000eec7049beaa7f,0x000056ea0b95719b,0x0000126332eeb7f0}, {0x000c1b48ed3bd6db,0x00022945eb2401fb,0x0008ae25535bb2c1,0x000fb2b404694e9a,0x00006092eed3d6ab}},
   {{0x000143fcc058865e,0x00018e2499224d76,0x00050d3537b0a5af,0x000079aaef94406a,0x000011e4bcd44f0e}, {0x000993aa14a90fa5,0x000c6a0c51d44472,0x00032672d7706e20,0x000382a403292f15,0x00002573bfa71829}},
   {{0x000b6a93b5bdb831,0x000094a723186a7b,0x000eb065f08da65c,0x000685b58d22aa63,0x0000717596c2b15d}, {0x000f0d0b266d88b4,0x00071941945a112d,0x000292cacf688ae9,0x00085c087386e37c,0x00002f3b50d97d69}},
   {{0x000f9986a90fc34e,0x000285ca8a8d6da4,0x00051f762c8f257d,0x0003abe2feabca69,0x00001bc81d154c32}, {0x0008f67251a2a12f,0x0006ce8a70dc1bc6,0x000f84d2e10d8658,0x000c91e648af7ff0,0x00000aa9ebd5a43a}},
   {{0x000be04275968936,0x0005e5bf452b69e3,0x000c698c8b6bb02a,0x000793a875c11af4,0x0000652b5c81ece3}, {0x00055fd4f5c04999,0x000825532b387b37,0x000e96ef76ea1655,0x000f4841c69889a2,0x0000c773c3af1ed8}},
   {{0x0003a409b323abc8,0x000170e1d7912b65,0x00087157ae26605e,0x000615c5d410644a,0x0000f9a78b84bbce}, {0x00044aac407eddd6,0x0008435b964fcf1e,0x00008399981ddd1d,0x000801e73e339efd,0x0000c94bddeee796}},
   {{0x0004ada8545d185d,0x0009a38bb8cb5a30,0x00087e10e82ae44e,0x000fe2928a35e3df,0x00003624f3e715b9}, {0x000209b14be42542,0x000c9dbc2ea5cc44,0x000c37bbe7d0efcb,0x00052bff60336204,0x00001f363f576a58}},
   {{0x0003d1ca85015501,0x0001c8ab10bba150,0x00061c51c2251e0e,0x000f68ce129c9669,0x0000f7246a491910}, {0x00044ee5f2591f26,0x000efe6271572eb7,0x000f3bd683c47d33,0x000855ed6d62c922,0x0000120a64c2b8df}},
   {{0x000c6c07b5d07df4,0x00083ef397833a9a,0x0003a9b4fa92b955,0x000f05a128a134ab,0x00001c18807f1252}, {0x000d08980ba9b1c1,0x000eb532a9ddfc7e,0x000246809ac8dc6d,0x00080faf829cef55,0x000001b784f6b4ee}},
   {{0x00045bbb6f116037,0x000dd1d2801ec099,0x0007534a857b09db,0x0006148ba5202fa9,0x0000fd8ae60317b9}, {0x000a66678308435e,0x000bf3868c4da50b,0x000d7aab09572f77,0x0009fe2cef7bfd2d,0x00007958e090c7c7}},
   {{0x0002e42253466896,0x0000507c70048126,0x000950ee3716da29,0x0001b4d5f911eab7,0x0000fd72969861d2}, {0x000980308b640d30,0x000e887f12a15238,0x0002e93115b0026e,0x000ff720e2166074,0x0000ef6d5415ff77}},
   {{0x00027f0f9c41135f,0x000878a649939691,0x00041875cf21d60c,0x000232756e5d0ce5,0x00001e0f84f91d3c}, {0x000a35906002d609,0x000b761915529bcc,0x000181ec3be2da60,0x000f18cda8bbae61,0x0000f04b823f5806}},
   {{0x0004a7dd4b79bb87,0x000ae2c878c8f160,0x00047b8e8aee806f,0x000053c4144f118d,0x00002edf52c049f9}, {0x000a84e2127015a3,0x00006cb7cef3ebfc,0x0006deec89051d0c,0x000d7456e8fe5829,0x00003b2818871010}},
},
{/* digit=26 [{1,2,3,..,}]*([2^182]*G)  */
   {{0x0009383171b445fe,0x0002a131ad4c0107,0x0003987e89bcf21e,0x000c8eacdfe205c9,0x000063f4153a92e8}, {0x00062a930add43df,0x0002d980f05a7294,0x00006e96862ebb14,0x0006b05f3954e53b,0x0000e1d75ae142cf}},
   {{0x000c6c7af8685c8b,0x000d7f8f01aa5f95,0x00074692ad4c1c8c,0x000068144bbe3225,0x0000800347984a4a}, {0x000c6e52eca3cdb7,0x000b7c04d3997c8f,0x0002bc5cfea1db16,0x0003d2405bc82e8f,0x000063d518064479}},
   {{0x000c1b808bd98d05,0x00041575f2404451,0x00075d270644b1cd,0x0006bd1907eb3373,0x00006c8bebe4a228}, {0x000d2acc4632b46f,0x0009bfd60242c713,0x0005c754617da427,0x0003dd413065b7c9,0x00008239899af17a}},
   {{0x000963f4c8303203,0x0000603203e3f3b7,0x000327afb842c7aa,0x0009b67f22ca0ae7,0x00008e13092c6760}, {0x000fb62757558f1a,0x000157eca8c173b8,0x0003316273cc3e83,0x00023444174474f6,0x000077989cb63c40}},
   {{0x00017a144a081e00,0x000db70e296ae5fd,0x0001f719cd797fb7,0x000c522b472b3048,0x0000e632a98fe6f8}, {0x000d116c5f0c2848,0x000ead987c6289cc,0x0002de6cff51088a,0x0000f8aa2bccda4c,0x000010f9eff7679f}},
   {{0x00094b97ffe4b3ed,0x000115fa5d21b0f3,0x000fbbc750b691d2,0x000affe0bd77479d,0x00002830fdbcaf78}, {0x000249c52434f573,0x000568096dabf78c,0x000f8c0b34b1f754,0x00034c43bf6f948f,0x00004aef03d754e1}},
   {{0x00051f4b7ac7ec57,0x000a750da7d5f8d1,0x0003a0eb8d6ceb95,0x00086331b492b0dc,0x00005157b6a23dd2}, {0x000c74ec5413d62f,0x0006cc5fc4c7e2c4,0x000fa9ddabe329ff,0x000b86935a2aea60,0x0000117f5ae6445c}},
   {{0x00017f4b0166f7a3,0x00079eec74e6ae83,0x000874bfdfbd3e3f,0x0003a3cdb516ace0,0x0000d846019f681f}, {0x000ee5c7c1620b02,0x000d0b63c5010b12,0x00068c51eba68b4d,0x000b5b8c03cd3266,0x0000a6279f76e0bc}},
   {{0x00069b06ae85c104,0x0008ddfdd3a617bd,0x000078bec7294697,0x000a5299a032682c,0x00001c6a658ffd68}, {0x00010240e0239001,0x0001a10d144dcdea,0x0008ab8dcbaeec12,0x000cdd4a600e7405,0x0000333af21cb89c}},
   {{0x000eae03aaba1f19,0x000dab7144cfdf25,0x000ab98bc2cada16,0x00096dd57ee27d71,0x00009088b4d0a6fc}, {0x000c0a03549dbd42,0x000fd158c3ac05d5,0x000edd68542cbdf8,0x0004d01fb6b3b087,0x00002071cf6a6f06}},
   {{0x000721fff2811e50,0x0003fe7fae8cd2d6,0x000f1f7bbdb81b70,0x000b5d3cfb74efd3,0x0000cdbcd7616cde}, {0x000642a566a808ce,0x0003540064d64f39,0x00028fa6f02b7445,0x000bb61abbadca05,0x00004c3074db3fc0}},
   {{0x000b8b0b796d2197,0x000ec4741dd9b32c,0x000edf6f5c3e95f4,0x000b8e1721212568,0x0000a03aee512b9c}, {0x000c376f53a89aa8,0x0001148a28dc0cd3,0x0002ab04f0d8af9b,0x00002d4f86a3f490,0x0000aacb62aff420}},
   {{0x00085ebf62ffd521,0x000e4797bf101069,0x000e30aefe670b54,0x0005e93b405209c5,0x00002c97a205365b}, {0x00046ce1fe32093e,0x00055907a8c91046,0x0006e726b13cb4ff,0x000498ab9f30d1d4,0x00001985e228ba0f}},
   {{0x000dea910a230cd3,0x00039d30f947c573,0x000e2010a24f46a9,0x000e4fc2623fcfab,0x0000f278cb2a3f00}, {0x000c67d50b920eb4,0x000d4e760571ed55,0x00095b709f1cb9a2,0x0003693c50d10908,0x0000207cf07590d4}},
   {{0x0007e81c4127fe1a,0x000c9ae9c5663b02,0x000bfbba5a9f8b9a,0x0006f4bab10851ac,0x0000747d648f6955}, {0x0002b5c2ba97bf75,0x000d6cfa3324cc17,0x00086279d15e0f77,0x0003d35345b79776,0x0000a72348133800}},
   {{0x000139f8f5fcda83,0x00048dee5bfdfd8e,0x0003f9f77f3e558c,0x000969a76cbaf4e3,0x0000a4c97a4a1771}, {0x000e84bf6dce6a73,0x0005e3e6c2d1da27,0x00059a6e9ff373d9,0x00062cc115193cd7,0x0000f9b702593d22}},
   {{0x0004a31317cd0627,0x000da99f8332d976,0x000b11b0b30779d8,0x000ed86807410616,0x0000917ab9fe8aea}, {0x0009cbe28fb1d8e4,0x0002d36eda33b67a,0x00071a86c2e31356,0x0006b6c10b7069a3,0x00004d90fa2a744e}},
   {{0x0000867d6b3e243a,0x000cb9048c486819,0x0007315389fe6cd9,0x00004f1900b02895,0x0000012062fd2cae}, {0x000c8bc9399d0822,0x000a21df12e28107,0x000ef3f7347e8c54,0x000f0af4ba5117b6,0x00002260beaa1362}},
   {{0x000261e1a18cc20d,0x000e5321d63690ea,0x00011b6a02192999,0x0001f51f64d314e3,0x00007401e4d0b54a}, {0x00099836fbca2bae,0x0002afbffc4b1901,0x00086bf4046ad329,0x0009fbc142d3f637,0x0000b5cbc2796703}},
   {{0x000ae6c252bd4796,0x0009b2b5848f9cb0,0x000c9766305e0f88,0x00025c18f6d2b2a5,0x0000f6e149c21622}, {0x000235cde601a897,0x00088373be1fe602,0x000471827d17bbe9,0x0001165af49a5ba8,0x0000e1a0a8588aaa}},
   {{0x0003196270580c34,0x0009b1c98a146c83,0x00034e0a51e23383,0x00028927b2f7b4ae,0x00007ac874618ce7}, {0x000779a100dd467c,0x00068ee50d092b74,0x000608bc9274a433,0x000387a03dcf1383,0x0000d9da6c4889e8}},
   {{0x000199f355116ac9,0x000926d18eed2660,0x0004bc071cc38bb5,0x00057da075f31f2f,0x0000774457fb65dc}, {0x000a9c8c6db88bb2,0x000f2ec98e0406a6,0x000ecaa8b6429d07,0x000a7b6d05e57b05,0x00000f140b19872e}},
   {{0x0000f09ca4946937,0x00008252e909df8c,0x000b14b1248d3a02,0x000d1bdc5c29af57,0x0000e6fa37e2f47a}, {0x000b50649a0c938c,0x0007abe5f41f66e7,0x000359412b72c0d4,0x00047faa6242b8b2,0x0000d35c7754e859}},
   {{0x0006fea87baa6279,0x0001672aa6801253,0x0001e5dc958c1fec,0x0001b8dc29b63760,0x0000e3c3c1d6e9e0}, {0x000127b2bcfe0b0f,0x00013a12f50defc8,0x00079b3973510710,0x000f207ccd6cb148,0x0000792f805e8a82}},
   {{0x0004804a9b46402f,0x000cd10f0850509d,0x0006208aaedddf85,0x0002dba28410dc4b,0x00006229c4729101}, {0x000c41e7727b9b64,0x000b6a444842c5a7,0x000a947ea289e4e4,0x000ebbc49ba1d9e9,0x00004f9e47fc3c8d}},
   {{0x000a1fe611f8b8ef,0x000a0518f427fa77,0x0004ebac3fd2e416,0x00097ad5fffa7011,0x0000e57c4ea4d896}, {0x00053acb1aaf6131,0x000fda585a45fdd0,0x00098503431df210,0x000130218cc10e24,0x0000a38efd16f1d6}},
   {{0x000f2370b1e9e212,0x000cfdbe88aabf86,0x000c1baf9b258514,0x000691fe38a58890,0x0000936a01eddb9b}, {0x000de986dd5b20c8,0x0000f0f98ecfd576,0x0002d2fd7b586bf7,0x000d7b4ccf0f12c4,0x0000717e61d7b35b}},
   {{0x000572235e6fc06c,0x000e4b3e13d58b1e,0x0008a73723477728,0x000289550c294daa,0x00000291d43fbfa5}, {0x000bc67cec5a196b,0x0003ac2e8a7cc6c8,0x0006e1c51deeb31e,0x0001560a93e244fb,0x00009f8b71bde28e}},
   {{0x000a287968a2ab91,0x000936bbcb1fce65,0x000ae3f30e3c5ce6,0x00082be8c835b9e7,0x00006bbee270f72b}, {0x0002017fd42cd227,0x000088b1d2a0665e,0x0002049321e13997,0x000ee4a25cda2979,0x0000aee94a5b9c3b}},
   {{0x000016089821a663,0x00085f98166968c7,0x000cc3645f7c3767,0x000dfca90829fc48,0x000046af04a070ad}, {0x000b232370bf29c0,0x000e42e650ee2057,0x00026ab90f90c73c,0x00087be03386eaa1,0x0000e266e7e975a0}},
   {{0x0008eb90fca65d93,0x0009e6af45b88057,0x000c75a4e7e2989e,0x0006b84438212dca,0x00008c7ca397fef3}, {0x000c494d402676af,0x0006072c7c488650,0x0003a464e26ab5a6,0x0008405e6cb426ce,0x00008f998971b72f}},
   {{0x00084911a335cc88,0x0009ea5913e48c31,0x000b32919563459b,0x0005ac9b920d61c7,0x000005ab8b720242}, {0x00012da8d006086c,0x0009fcf5c0fd2ac5,0x0002138d76ca4846,0x000442efea51d8ac,0x0000b647545f44cd}},
   {{0x000ee8fbd7d90402,0x000e619b9c960429,0x000a7d744ee66a2d,0x0001bb34f9ec25de,0x0000ffea64287172}, {0x000dbd1114344eab,0x00064d0dbc8b4f19,0x000ec7f910430453,0x00014c514b50aa29,0x00005fc22ff6b060}},
   {{0x00063a91ee682e0d,0x00002e85c72760d9,0x000707c2ddf48abc,0x000efe3cadba132e,0x0000e608d3b7645a}, {0x000c28bedafd8830,0x000ebd94de1f05f1,0x000593e413c362ed,0x000eaf8dd0629d13,0x0000a5e736f766d6}},
   {{0x0002311f68cf9d16,0x000761797556bfa9,0x00001c209a4f9ef8,0x000360b0d75a1f56,0x000051c374c69b07}, {0x0000b5888b5cead1,0x00085fa9dbaa4995,0x00015f33a0ef0005,0x000140e51ddc264e,0x0000f8b5ca63ef46}},
   {{0x000c0a3ee9523f07,0x0002275ea978343a,0x0007387f4bb75eab,0x00062dabccf33210,0x000090f925a0ab00}, {0x00063ad1e4f6a5f6,0x000402519a50f1a3,0x00065f1ee06e08b8,0x00085e0091518772,0x0000a80ca34f3ae9}},
   {{0x0009768aaba4864c,0x0001cd52a7d681b2,0x000ad03f1b13cabf,0x0001bff5c363488e,0x0000932ad9641c7c}, {0x000708ecae1e27be,0x00083b0df6485452,0x000cdb8bc9dac426,0x000173433e3f0cdf,0x00006cecce0cc540}},
   {{0x000845e95081181f,0x000f799355d5bd0d,0x000b375a8cc8a791,0x0000db211c0f6dc3,0x0000d95bc6ced51e}, {0x0006a266888523a0,0x0006cb01a06d4a10,0x000b9b3974d142bd,0x00091479bfd289ad,0x0000bdbfb94e9863}},
   {{0x000a2291660f6a6a,0x0005b51c042d29d8,0x000c3ffe87f6abcd,0x0003fa73039deb0a,0x000001be6298c852}, {0x00041030ca1c3287,0x000d4903928e6ea3,0x0009144b0c74114b,0x000b171aa4ff4e9e,0x0000064091fef9a4}},
   {{0x000f521e447f2c48,0x0009e04291f0a3f4,0x0005926de81b8da7,0x00002f5680bc467d,0x00004f21fd5b4a12}, {0x00031814e9df3d85,0x0009e9ab8d341d1e,0x00019aa4a1ca4861,0x000366309ddeec5b,0x00009f72f7e9d329}},
   {{0x0003f41386d5087c,0x000c1d67d64fa2f9,0x00070215840bf739,0x000177f449420566,0x000033c65bf33b1e}, {0x000657c38ca61533,0x000aac791976cdcd,0x0006e1f3997f4519,0x0009329c7c7f29cd,0x00008de9cfbae3c3}},
   {{0x000eba37b793f853,0x0009c067e914e448,0x00014ae87e9f8dbf,0x000e2a90390266f1,0x00009ed75a7fd6a8}, {0x00048487ffba390a,0x000acaf9bc09adb1,0x0007476db67f8cb8,0x0008d5922c38489c,0x0000320fecff2a53}},
   {{0x0003002b2aced2bb,0x0008b16bd430e049,0x00031be70dfba180,0x00044fa31c4644c3,0x0000c04d32f40d2e}, {0x000a0d10f9f142d6,0x0004e7ee5a231805,0x00089b4e32c44a0c,0x000480d1875a4339,0x0000b1949fd6c063}},
   {{0x0009e08be0f44920,0x0003e9d5e5172dfb,0x0009466a83ff0da0,0x00093203dbe9a1f7,0x0000b87bcd015ea9}, {0x000fc83ab1f58ab6,0x000a217edc8aeb64,0x0003b67e56d9598d,0x000853099cff661d,0x000045c0f29f2635}},
   {{0x000dd82eabaf21cb,0x00097241659e253c,0x0009f709182b9602,0x000d9a7cae07ec2d,0x0000e4c720d3b48c}, {0x000bc036f08d6c97,0x00073f10bf406ce5,0x00010ff1236e8a99,0x00049413422d213e,0x0000b26d3ec2cc12}},
   {{0x000d2d0c9469ad61,0x000d20afa05bb240,0x0006ba286c4a11b4,0x00064c3b604acedd,0x000084866004ee28}, {0x000d6ba8d9ce5be6,0x00059f4bfb0d5869,0x00000cf730d8f68c,0x000135569f210b57,0x00001f6653acd37c}},
   {{0x000432b5aff5a48b,0x0008c2ba3a69ff3d,0x0001899ef0d81c4b,0x000afd3e879ae9fa,0x0000ac7e2a0dd6ac}, {0x0003f6c1c664399f,0x00006bcb135dd6d9,0x000ab7cbf4c288de,0x0005ef93031dab9d,0x0000e23feb12abbf}},
   {{0x0002466cdedca850,0x00001a09538c9f1b,0x00011115d140bb71,0x00059eac8ae8515e,0x0000d63ff676f03f}, {0x00055517d234afbb,0x000dce208fc1755e,0x0008a4b5d61c2db4,0x00030efa9859cef2,0x0000dd6d4fce4af0}},
   {{0x000a26d3be01cb1e,0x000b443aa07cd1c4,0x0005035029ba14ff,0x0003ab195cd3a9b2,0x0000379bc075d2a9}, {0x00018e9d4ca8d68a,0x000be0bb412a3efc,0x00045a968083558e,0x00054f3903b94096,0x0000499f0b73ba60}},
   {{0x000573cb8349abe3,0x000500b4fc1c208b,0x0005249903baab3e,0x000e8057e978bacb,0x0000524194efcdf0}, {0x00017257d4bcc42b,0x000b090109ba6271,0x00023e1e0e90a3d9,0x0005988b1bdd5713,0x000078e9bd60eae1}},
   {{0x000b7469e03d2781,0x0005c70e62970794,0x000c978558017860,0x000b5c071792f899,0x00001b393ef05a86}, {0x0006582d8884f278,0x000a3f19ba5f48ef,0x0002062c6bd44737,0x000c540698de4ca4,0x0000975eb80e1ce9}},
   {{0x00057c7d7fe71f3b,0x00000c97ce38d50e,0x000f07b631534219,0x00087ca1bda2de4d,0x0000a12aeaed00eb}, {0x00035d2a9b4f8f67,0x00058ad6d99cabe1,0x00094937c04619d6,0x000099da6683a779,0x0000a778c8bdf94f}},
   {{0x000862320a71b899,0x000c8c2291658c50,0x000f83a99241a2ae,0x000ac7a52be595aa,0x0000fbfee7fa562b}, {0x00058b95c4017e32,0x000ff5120b86eaf6,0x000034d6f1dc7f9d,0x000038b84f13dd4c,0x000083dd7380aea3}},
   {{0x0002609cd85d6a2d,0x00052ae60177197f,0x00012fede6ebbc34,0x00086ae80f031b4e,0x0000e55d0c2d7a21}, {0x000e37f24dcdd5a7,0x00050ed191fb1fb3,0x000023e0d8d602da,0x0000bfa08fb05676,0x00000178c71b59c2}},
   {{0x000a3863fe54cf05,0x000eb2bbb475fad5,0x0009d94d7a4a3ec4,0x000ab2caa5ec2091,0x0000d3b63b5f81e4}, {0x00033d85ad3d2aff,0x000ce1ac7a377fa7,0x000779614fbc586d,0x000429382925de40,0x0000e0ffffcd74a2}},
   {{0x000e67f906151e50,0x000f55e106493f39,0x0007cf7b7cea27f5,0x00062ddca1d4e1c1,0x0000c326d122fe23}, {0x000ac337dd35df39,0x00093396dbdf05f7,0x000b7db1c0c3b763,0x0004a87912f5ac03,0x0000dea4b70ec9ed}},
   {{0x0006e53aae3f639a,0x000c5c278bac475e,0x00090375ffaba0e7,0x000d0976f9e22194,0x0000ebf974745a7e}, {0x000af3ff41ad5d66,0x000c52e9922445f9,0x000cf56aa03c4623,0x000ed322c5bb5cb3,0x0000431181994567}},
   {{0x000f2118be489ac8,0x000d39a1104bec57,0x00064e0072821895,0x0000fde10dc87560,0x0000e526f3fdb20d}, {0x000ca775b645aee2,0x000f600e10ff6e71,0x0009cf6de3d1dcb9,0x00035316b5116218,0x0000c5a3e308bb17}},
   {{0x000cd3e2a6c6fbf0,0x000a4bf97906c186,0x0009d6901a74516f,0x0007435b4b8f4b27,0x0000c4e57b42b573}, {0x000b229b6e386b6e,0x000cb9deac2775fd,0x000712629b46793f,0x0002dd0eec47eacf,0x0000965f3c5abc3b}},
   {{0x000fb83425c65590,0x00060af06fda8dd1,0x000d956df7fc00ee,0x0008a2e98c922533,0x0000f1ef3354fbdc}, {0x0005145b79b8ea2c,0x0004fdbff2882abb,0x000185db740fd294,0x000099aa814ac4d7,0x00004329d7080846}},
   {{0x0007b52ed1be45d6,0x000d84cd2c74c9ba,0x0004139b1891dd20,0x00070ffa4d4a7f82,0x00006c177171873c}, {0x000c1412843c4e0c,0x0006f97eb5bf5e5b,0x0000c95c7d5ac481,0x0006c500f8af5445,0x000091b3fa0f1840}},
   {{0x000340aab9d97f89,0x000700a2d611360c,0x000a6f7e5fb57bd0,0x000a0fb339ae3ca6,0x0000c1fcd2abfeb8}, {0x000cca9c7ea74322,0x000c108076f6972b,0x0005b4ca51b0b924,0x000b2960b2814a2a,0x0000f78f55b81ef3}},
   {{0x000744ac18a414fe,0x000db03d0a86f838,0x000453f55c611eaa,0x000278b4dabc162a,0x00006f2e3daf4efb}, {0x00060179320dc3cc,0x000ecdf6b5a45b7a,0x00040fa90692e382,0x0003177f5e15e02d,0x000087883af243dd}},
   {{0x00053e453544774f,0x000b4adba2bc5110,0x000e371f5834d0ec,0x0003bb5215d7f7ba,0x0000cfd57c05c866}, {0x000383dd6901b1d3,0x000485587dc3ded2,0x000625f623b49fbb,0x000762cd44a08d07,0x0000ee4d65bcde9b}},
},
{/* digit=27 [{1,2,3,..,}]*([2^189]*G)  */
   {{0x000137d0d63d1fae,0x000122a9d89f64e5,0x000436309658fc05,0x000a606889487450,0x00009ae30f9b598d}, {0x00010d1818baf918,0x00060b6a0c202ed7,0x0001a6b44e27e9e0,0x0007db9e28dcfb1c,0x000083acb6556ac5}},
   {{0x000728dc2c6ff707,0x000f55dc22358735,0x000e277f979d6122,0x000cc6b3f5d00319,0x0000ee84e264ded8}, {0x000afb063cd880a6,0x0005d574af6091a8,0x000de7f423f3ea7c,0x000151acfcdc8402,0x00002d07930131aa}},
   {{0x0004e438a5807cef,0x0002f4109a7e8e1b,0x000d59ddaad28389,0x000092d30cc9cbaf,0x000065f36c72d8d8}, {0x000469ea60d32b2d,0x000a6e8191c8df31,0x0005bdeb5ee93df4,0x000a27cc1017c535,0x000026231865616a}},
   {{0x00083f9dec31a21e,0x00028ad9d573b02c,0x0007be365988c8b2,0x00034d73e983aea5,0x0000968734e446f8}, {0x000ea8f5da6309bd,0x0003f1f1ce169137,0x00044092110f3a62,0x0001b4a82a9ea2ca,0x0000f94739f2b46f}},
   {{0x000e006cce85c9b6,0x000644c7c2d39f9b,0x000fa1e60360e70d,0x000b6cccd5beeaae,0x00004cf63c0ec3d2}, {0x0007fa3e1cf6f904,0x000695e044e6fb10,0x00034db9fb7e937c,0x000bd034e8ca78ce,0x0000f8b36c17e210}},
   {{0x00065a434a35ea84,0x00070d4412f61df1,0x0008836c33418e0f,0x0009651af1f8af51,0x00002ceef4d530e1}, {0x000ca0b543a1957f,0x0004986cb1235560,0x00098ed30c33761e,0x00097c76624b1ffe,0x0000772f4c000909}},
   {{0x00040bb4885d4104,0x00005ba5f8d7f4e5,0x00098dfb17287f81,0x0008a2e2d0d865de,0x00009ff51a1fcfbb}, {0x000fa536bc3012e7,0x0001a70d541db6b6,0x0000f49663d31fd7,0x000e071018724f4b,0x00009e7399ff7dbd}},
   {{0x000410ef4f8b16a8,0x000e447b266a56f8,0x0009c87c197241af,0x000b1a8a406b8e6d,0x000003f3e034d42a}, {0x00009a804dbec69c,0x00067bbad05f7f03,0x0008e197fa83b85f,0x000dc106097273ad,0x0000097440f1067a}},
   {{0x000afb63524ff164,0x000e423fc6ce730e,0x0003e4ac0d7f9b51,0x000216e7bd0d3244,0x00000c59ad98d66f}, {0x000136f17c387a48,0x00056b86804d6c33,0x0005a73c95043b8d,0x0009b5f497031267,0x000038fdb3271666}},
   {{0x000b6dd418e7ddd1,0x0003372f19d6c507,0x00027eb4d39888d9,0x0008846eae26be0c,0x00007b53ed40babb}, {0x000021b2b01ae4fe,0x0006ef488682fc27,0x0005e2d8788462e8,0x00029adee096ec21,0x0000b2fea9bb242e}},
   {{0x0005b5fb821fc28e,0x0006fc1e2ad25d98,0x00030ba6289d2e19,0x0001c575b566b890,0x00003fd41b62f41b}, {0x000ac2eb9a96d612,0x000a169443f4b738,0x00003a4407f8567c,0x0004dc6698622df8,0x0000b586236afe2f}},
   {{0x00000c756b95bce4,0x0006216da680bbcc,0x0002142525ec0390,0x0002d239162ee672,0x00003132b63c6a89}, {0x0003ff22f3263bf6,0x000c3cd0a1424bdd,0x000415ccbd5b3733,0x0004e9f92eaa8244,0x000063e8924ed547}},
   {{0x000a25e5236344e0,0x000dbda76ee68058,0x000cc3d2282e8df9,0x000529dcf6efd811,0x00000089cda3b4ab}, {0x000a071bd38a3db5,0x00009f72b92591d3,0x0003edf754ea97fc,0x000ed2bc9fc15bea,0x0000a6297cdf4348}},
   {{0x000ab35ce7c42d4d,0x000eb2feab100d38,0x000111b459fd493e,0x0005c276056b6d82,0x0000a11dae243efc}, {0x00002785545a7fb2,0x000c20d507e6dc74,0x00066fa58bdb2601,0x000c29f21dfeeb70,0x000014369a859ae8}},
   {{0x00009cb06e0956ce,0x000e210cd34b1957,0x00071a5324c9d254,0x00054d151e13f704,0x000019d6791fe730}, {0x000a628db5c7be33,0x0008824dde05f702,0x0009b2e2ec714121,0x000dbaac18233cf2,0x0000a6bd1e8b5342}},
   {{0x0007fa0b311898c7,0x00045d0eac653f74,0x00014d0bce2a272e,0x000ee2dbba5851f9,0x0000a1a966134a43}, {0x00067cea1c8cde9a,0x0008d271abe3e5a3,0x0001615cd9d958ba,0x0000b053ff7eb63d,0x00002280dcf95ae2}},
   {{0x000a5c1cf6401471,0x000d4e83d11856db,0x00024c511ea5a2e3,0x000213f4cd6b6dda,0x0000c0f4671f854d}, {0x000b7a9695653812,0x0000becf1f5b91a6,0x000f5d009dc96624,0x000bd4fb22d21cfc,0x0000a05f641b021d}},
   {{0x000d566d4312483b,0x000cb43e216f8c0e,0x0000444935179a95,0x000a211c185fec17,0x0000306333a04991}, {0x000ecdb0081a726e,0x00056fa89bbbd801,0x00091b6b90149b0c,0x0003a2cfe9065a43,0x0000dc92787b633f}},
   {{0x000c24aae6a8e13d,0x000dcf3897abe408,0x0001a071585833fd,0x000c5e73800e7ed8,0x0000e08e347844ff}, {0x000184ccdeff2e08,0x000a965eaed17094,0x0007c468a49f9387,0x000dd7e35d612977,0x0000c0dcfd1d38c2}},
   {{0x000d9e37a6a308bd,0x000f7c2767d3d6d9,0x0008cbeb66237582,0x000d9db74a8bc6f3,0x000094d3f1b9cb6f}, {0x000735bba21f248e,0x00048cd1efb092a9,0x000b03284272ad0e,0x0002249437b69c05,0x00007f047034948c}},
   {{0x000c04acba2ececf,0x000ff3a73e418a56,0x000e937250c18126,0x0001a87cb34e9d03,0x000077c871439652}, {0x0009183fa7f9f909,0x000bfc9707ad9456,0x000c1c9a3f2e7aa4,0x0005073ed2c9ba26,0x0000109fe96d0197}},
   {{0x00068a9e9adfe1c3,0x000d014e39bb9ae8,0x000fe378f3984403,0x00062885875720f2,0x00003f901e0ea44a}, {0x00025fe3652438c6,0x00063dd1f20bea11,0x000bf7fbdae9ec4e,0x00079bbe740d9ebe,0x0000dbd3ddca2dbe}},
   {{0x0002aecedd36776e,0x0008098590396208,0x0002f7065f612c47,0x000210c493b20103,0x0000bd4d8f32ff9b}, {0x000a0aaaac4cb325,0x0006c5ed40053f23,0x000a27e63ea3aadb,0x00066c5cf17ea4af,0x00006125c1b111fd}},
   {{0x00044a43794f8dcb,0x0009983c5c362663,0x0009d10a0dcca923,0x000df27d6b6bbf3f,0x0000320c5cb31d9b}, {0x00028ff47b50a951,0x0001bef03371620e,0x000100153933e3b0,0x0008d6e081bf8599,0x000083be9a0d3a8c}},
   {{0x000dc5ad6bbe24db,0x000fa38437954e3d,0x000ec2d4cc6c7462,0x0009b1c8193dd765,0x00008df26cd7d3c8}, {0x000e3995a483f8df,0x00068dd3313a98db,0x0000bd37572d8a95,0x000d1575087294ab,0x0000cd892496c259}},
   {{0x00043d77613aa81f,0x000f95fe65848a94,0x000b10288801007f,0x000ee780fc4dbc7f,0x000058280d4d86be}, {0x000d82f7c978c385,0x0000bde44d7b14fd,0x00060252fdf1204c,0x0006a5508a1c8441,0x000091554cb11764}},
   {{0x00037d6a05bd5254,0x000ac7957b3c214a,0x000109bc948d5f09,0x000ce6c247cdcbd7,0x00000f9e4bb70599}, {0x000fa03f46ad2ec6,0x000f63e3f9eec325,0x0003a457700f766c,0x000b934b556668d4,0x00008d30a619ee03}},
   {{0x00081ea77b46a081,0x0007b74806997ddc,0x00033f683cf5a647,0x000c6033a8cb3466,0x0000b867e6ba2363}, {0x00011141f60558ee,0x00024f41450e4392,0x000630e8bcdbcdd6,0x000b429fc04601cc,0x0000a7c66d677038}},
   {{0x000b8a504e99fd8c,0x00018785549a7259,0x0000552e198a8dd1,0x00009d4e459a7c84,0x0000dfcf4d10bb09}, {0x0006db253758da79,0x00035ac997e134a8,0x0000c5b7ee643bb8,0x000b5206400bd753,0x0000f97af88441c8}},
   {{0x0008820fbeee3f97,0x000fd9091afd34fc,0x00031f35c93e5348,0x000924064b9be59a,0x00001f37864c7e3d}, {0x00034e0943aa75e5,0x00085b8ff6e402fb,0x000cf0d19a18c9c5,0x0008a6b80f31b133,0x0000c9682db58351}},
   {{0x0004ca6b709c3de9,0x0001a575b8f0873d,0x0000154bb64a8426,0x0001aad275da1f02,0x00007678cab617cf}, {0x000795f951a95c33,0x000320fccc088779,0x000d8f031dd35b16,0x00085c0270962733,0x0000c5ab10a798dd}},
   {{0x00085c341dca5663,0x000aa8622aa3b6c1,0x0001b6dfb7de7fed,0x00028869e84d9290,0x00000a02b0eac4ad}, {0x0001daa2fd3cf36d,0x00070f89e59fc7c8,0x000496733d131954,0x00012ae2be8184cd,0x00005f449ec63d34}},
   {{0x0001b1b25fe531df,0x00017a1d56467ea4,0x000de501af979743,0x00089b96067f722b,0x000091481c0fc85e}, {0x000e465f8b05bc60,0x000f02e83cdaca8e,0x000dbe33b1844e1c,0x000de2ca82114ab4,0x0000f9f87694eabf}},
   {{0x000b1c038b27fe29,0x000b1ba402df4936,0x0006bdbab63b6359,0x00039bb0c0ea2f65,0x0000c992a89f580c}, {0x0008f152a60aed16,0x000480bf49df600e,0x00042d99aeb089ca,0x0002fa3c233d7d2d,0x000048d3f95ac6bc}},
   {{0x00083a8e1add3f34,0x000a0f64a348dcc3,0x00030dbdbf42c0c6,0x00015deabd176f00,0x0000de501a3bd6c2}, {0x0007c1f4b9a64bc7,0x0002b496cd594a10,0x00088dffba77f0ad,0x000d8e8b78ac6276,0x0000025a2cad7937}},
   {{0x000b2d1d1a8f4e7a,0x0006d354927cfde8,0x000205735f5b3da4,0x000917448606a3d9,0x0000c477cc78177b}, {0x00073d2a883239a8,0x00064c8b8357fb1f,0x0001f4f86e12572f,0x000c6e1d355e9cfb,0x00009b795f959f3e}},
   {{0x00056f1b54398dc7,0x0006cfedeed527be,0x0006d01401890efd,0x000ee3f2f77f1f9c,0x0000ef0e314c96f0}, {0x0006631cc61dab32,0x000dd4866e4f50ca,0x000363b394a39801,0x0006aa46c8d032ae,0x00002c591e54ead6}},
   {{0x000a308de02a53e8,0x000f5389f357954b,0x000f40b662a6c060,0x000ce166cfcde8fb,0x0000e02fc5746340}, {0x000779573adb4ba8,0x000c27b03805e495,0x0008e6fa67b86122,0x000803e3f835120c,0x00003660ea0857d7}},
   {{0x000910521ba473cd,0x000e0ed5389dbad7,0x0007c9bc0b6c50be,0x0008a71e2caf4daa,0x000097b8de55c4e9}, {0x0003e70ab3bbddbe,0x000e4597815aa9f6,0x00015b3d93898aab,0x0007839659af89ac,0x0000df7725c503ce}},
   {{0x0000fabe085116b3,0x0005572853102547,0x000bfd52f04a4337,0x000c741e39187ee2,0x00006166b44ad9eb}, {0x000433cfd4b322cf,0x0006ca79ab5192ad,0x000db15eb726aa81,0x000e63096eacd8c1,0x0000af71e91f476b}},
   {{0x000a640641fad989,0x000799622559dd69,0x0004199dcb799591,0x000eb373c6daa5de,0x00002cadc983d545}, {0x000238b256534e4c,0x0005c595409a1028,0x0005dc59b73e80ce,0x000e7fa90d4c66d0,0x000095f7b90581de}},
   {{0x0007014d856ac253,0x000d7c524dcaf433,0x0000499f5441bd9d,0x000182340b3d855f,0x00009cf84aa05fda}, {0x000b055b2aa95a02,0x0009eddf186004e7,0x0003f6b4329e33f0,0x000b0ee82e74b542,0x000017edeb92aaa2}},
   {{0x0003f3583cbea55b,0x000d0c185d7058b8,0x0005f6992c485ee4,0x000dd4d33ff03b1e,0x00005b9b9cd7f0c0}, {0x000ee8e4e9e8a506,0x000b0269dafd7caa,0x000e791c6462e907,0x0007900ed5cee9fb,0x00008ca325a4d430}},
   {{0x000bdf213b5ba885,0x0009e5ef0ac42b72,0x000b99b0860294c8,0x0009aa4c3230ed19,0x000060fff17bc258}, {0x0008487d67703743,0x000d6a56f685552b,0x000f175d9a373202,0x000810a3e7f90745,0x0000c2f31600080d}},
   {{0x000e9dd7b9520e80,0x00020af037b51130,0x0009c104cc078f9e,0x000e9238cd2ec71e,0x0000f684368c472f}, {0x000b5ed6247e7ef6,0x0008d96dfe21d3f1,0x0009aa2c2b32d33a,0x000e40e6f59cf44a,0x00009cd51695f0f7}},
   {{0x000da0f4b3234da4,0x000574579ebe3f59,0x0002476c7cf0b023,0x000f082d1cbb256d,0x0000f0837e6ddc30}, {0x00075bb906f6e98b,0x00041761e7d19a40,0x00073af10253bb43,0x00031c2e2e645f6e,0x000089a4060bc5f1}},
   {{0x00040c5b8cc037fb,0x000ac405bb47d128,0x0006348b83d093a5,0x000ca6b202c25320,0x0000f5d57fd755a3}, {0x000c90c8c3bef483,0x00032a0a960a89f6,0x0002b42ab23ac762,0x0001f6afbd3d6b55,0x0000ef2245843206}},
   {{0x0009bdac97e65165,0x00007230f49ed74e,0x00074ea498877936,0x0005a256ec1de31e,0x000081dcee58fb64}, {0x00023918f483f148,0x000c5137d13bbaef,0x000743a426d2dddf,0x000e66d4cde50ed2,0x00009a34fc664d97}},
   {{0x000f5b312e08ce5b,0x0007f7f0b2ca13f1,0x000982805a80540b,0x000a03d54bcf7701,0x00008653ffdd33be}, {0x000878702b0b4c9b,0x000eeacb170a8e7b,0x0000c14e52675261,0x000be9561a9d9093,0x000059b30e18ef0a}},
   {{0x0009ea60200ec7db,0x00085bce132b1dc1,0x0003e27e0b6f4a3f,0x00016f08d5de90f1,0x0000aee5ef0cfade}, {0x0006aaae4c6cf389,0x0006413698156f40,0x000d550c6ab4cfe0,0x000d387dcffe87ef,0x0000d4f59c805ff7}},
   {{0x00053b151deb6adc,0x0003f1877749b025,0x0006006e1812399a,0x000e770e90f71fca,0x000032363a7702b6}, {0x0004fbedc36c64d8,0x000127e1ae610228,0x00009d94a86c81e3,0x000bafa576c7e5b9,0x0000b6f7d03018b2}},
   {{0x000ed0756faa38ab,0x000be305bb54eca3,0x000c73061a3790e6,0x0006142784eeda7b,0x0000d56d36a1dd50}, {0x0005949229a8aa9c,0x00068595ec28d657,0x000ab4fe6dcca8f4,0x000f15c14305c106,0x00008c39768e4f43}},
   {{0x0005f36523f2b367,0x0003220d93bbe2a4,0x000f1632b995c649,0x00095488afdab790,0x00009ebbecd8c295}, {0x0003ddb79592f48f,0x000a6f88e998c7bb,0x00001193e67216a7,0x0003fbe91f098bbc,0x00007d928a6a1db8}},
   {{0x0008417e991f600b,0x000d7981a93455e3,0x000b13bde2a91113,0x000f441bc9d64806,0x0000011b6acb755f}, {0x000b518045ec6135,0x000172f5930a6f4c,0x0002e65de522d2d3,0x00066f0acae1af38,0x0000764306777bc9}},
   {{0x000705d1c7193f0d,0x00066be8858e5e12,0x000c6dfc7f0f32f4,0x00095ca85c3d7d96,0x000075b4a218f317}, {0x000f17b342659d41,0x000434f0378f91ac,0x00052129de596ea3,0x0005853515708fce,0x00007387e1e89f2f}},
   {{0x000d2e949dee1686,0x0002de2af23972cf,0x00094066a1ae0522,0x000412a09e75be1d,0x0000cca31c798abf}, {0x000d61d9bc499082,0x000cd5e2bc1eb50b,0x0006f83ac4a9b4a8,0x000b28cb6cc5f794,0x00007da93fd0bffa}},
   {{0x0004c964821c8c54,0x000d683c15f4ea31,0x000f330048de49de,0x000e103a64cf207a,0x00005f1bfec09627}, {0x000062654b9df609,0x000c195c0b33878b,0x000035d8e5e4fdc3,0x000b8c554a37cac2,0x0000087cdaa10f20}},
   {{0x0001c238319ade44,0x000a9e8cfdf836f6,0x0006f3705766f287,0x0004a20882194834,0x00009a7b85356e4f}, {0x000f8a75cedadfd1,0x00057db2a815b9b3,0x000f68f958f56281,0x00008eb0b7d55401,0x00002971e27788a2}},
   {{0x000b696d0ff34fce,0x00013222718cc9f8,0x00095284d20824de,0x00023f9213cf9f0c,0x00002ad741cbc158}, {0x000a6df54043ccfa,0x000b384412b30ee3,0x000c98af016ff479,0x0002fb56c74ee0df,0x000078a169ff2fcd}},
   {{0x000874699c930e9d,0x000779e117a5d8ae,0x00024759f1d33e85,0x00001ca581fcb466,0x0000e5064502bedc}, {0x0005d00caf3155ed,0x000bec73e75fbeec,0x0000b01db672d66a,0x000b78b6b9d8c627,0x0000249ef8420f55}},
   {{0x000d6d473978fe39,0x0001e54b00a16131,0x000dfcfe9cc4e454,0x000befbe05df0557,0x00004b29cdde1ef6}, {0x0000cff9bc7edf24,0x000d93da65f3e453,0x000eb0b488ac236f,0x000038cfaf7d5fc8,0x0000d2de14ca60eb}},
   {{0x000bba760430e540,0x0006da3289abc006,0x000979c5910a2d0d,0x0009449c037a5dd7,0x00004d1f3d3a116d}, {0x00024738a0983cd2,0x0008a883cabb9ff2,0x000a5899528e25b3,0x000bdfc968dba547,0x0000c80b505974ee}},
   {{0x0003b714a953beb9,0x000e8642e7f6ee76,0x000d5e722502e223,0x000315dfe4b64161,0x0000d37c5b16bef5}, {0x000ed70f8330bc73,0x000645a727890115,0x000ceccc2139850e,0x0007f5f7d7faecff,0x0000016a8607fd9f}},
   {{0x000ec644cd8f64c3,0x000ff79d7b51c492,0x000c7525658a2d78,0x000016dced1fc51f,0x0000e658aedbf433}, {0x000942e05da59eb6,0x0002addc37220b61,0x0002e7f87ba3d60a,0x000b6e1c311cd174,0x0000473ffef56b01}},
},
{/* digit=28 [{1,2,3,..,}]*([2^196]*G)  */
   {{0x000604f692ac542f,0x0000327b91d38303,0x000aaf9bdf079ffe,0x0004fa29f63e6315,0x000099ee566e1f34}, {0x000661fd62191997,0x0006648ce41c8a1d,0x00074d9048c883bc,0x000b1aa065118f3c,0x000013889ee7faf8}},
   {{0x0003f8f81a1b3bed,0x0004fe2764a0972b,0x000c4f5f74f3ce14,0x00085b12d0f1cc28,0x0000eee0c0e97f39}, {0x000adc0d39e25c35,0x00007467a0807df4,0x000cf5a584061982,0x0005fff40ebc9361,0x000027729a6922ad}},
   {{0x0000937b1b76ba6f,0x00045d2026dcca6c,0x000d9ae0a1a2eab8,0x000025c1715e1519,0x00001ad919aaac4a}, {0x000dfb807ea7b0ef,0x000e4ed9eb8935b3,0x0006d08abedf5496,0x0007309932e5ff2d,0x0000314874f15bd2}},
   {{0x0006a753f73f449b,0x0007dd44fc79efb2,0x000c0dc4d1d1c94f,0x0000cf99f0fbc53b,0x0000747ea0be698a}, {0x000c3fe228d291e6,0x0004e3c129d65218,0x000acc51635b804b,0x0006689ac859b8d1,0x0000c10697df5d6e}},
   {{0x000438f0876fd4e6,0x000723d2f383c38e,0x0000934cb45f0c30,0x0006edc03cc2ecb1,0x0000a8f24398c9d4}, {0x000431b65ccde7b6,0x0007c7e76a6ff16b,0x0003484d741e2cd1,0x00044a59c8cf8f4e,0x00004426efde3152}},
   {{0x0008e44fc94dea3f,0x000eead6a0b01c0a,0x000113cef34c8cdb,0x000ff9a19c384004,0x0000d32fba505490}, {0x00090f6795dcfb75,0x000333588baf58d1,0x0001fc1c0fef01b0,0x000ac94e6d1d63ca,0x00003173f9740a41}},
   {{0x000402aba16f73bc,0x0003ccf9b9fc2b1d,0x0006ef7bf2fb3101,0x0007446d51e60e44,0x0000731021c791e1}, {0x00047244fee99d47,0x00068ac5c1ea9d3b,0x000ea9af74bca48b,0x00083a00f5f514bb,0x000051f55a6074c2}},
   {{0x000251acb452fdbb,0x0004a0f306506e30,0x0003548d931ee696,0x000f5b00b3e50893,0x00008949a50a4b0e}, {0x00083263c88f3bd1,0x0000cb1d9989208b,0x000d4df03ab147c3,0x0000c5dd6515fd44,0x00007a12f75f72eb}},
   {{0x000796d36cf69db9,0x0008c6670c183b59,0x000070d8e1219eee,0x00090c6e3341f77a,0x0000b70130c3327f}, {0x00024620ae18e0e8,0x0002c6c0a63836a3,0x0002eb0d42021a62,0x000292a51b5817c6,0x00007bfbcdfcc762}},
   {{0x000b505cdd61d649,0x000c38c18857f78a,0x0001475158c7a53f,0x0002d51653ce6f16,0x0000c923aa67a7d5}, {0x00009cb5c18871f5,0x000823b3cc74c247,0x000d1d4c47d53bec,0x00058209264afffd,0x0000555917e740da}},
   {{0x000bbda548f5a0e4,0x0009fbbfbbe1cae8,0x00077afc31910eab,0x000b5c6e57968576,0x00009ea61f1b3ff0}, {0x00054784f7c39221,0x000d10c68eef7865,0x000779ab995d337c,0x0009a858f1e1e5df,0x00004b491b0c5cf6}},
   {{0x000bbe028e3fe894,0x000485aac0eb7a6c,0x0007e5140e7e1fee,0x00021f3f47eda569,0x0000f450137f4549}, {0x0005f8495cd81854,0x00018db2e583db62,0x0005e6de474be0ba,0x0007396ee4fd7cdd,0x0000251437e28101}},
   {{0x00072a0ac6203668,0x000c36d59344686d,0x000eb75b94be3fb9,0x00010bee8b44e7a1,0x00004e39da411a5c}, {0x0001490b38f04092,0x00030c2ade8237cc,0x00090a2d80295194,0x0002ba7b68878311,0x00005627d1443118}},
   {{0x00050aa658a6d877,0x00075f9c73256eb5,0x0008748c91405aaa,0x0000e06147142e5c,0x0000f637e4fc3ede}, {0x000277614ffad2c7,0x000d4afb6791f8ca,0x0008f93fce58fb1b,0x000654a7158c23bf,0x0000f15b3737a4a4}},
   {{0x000add2d842ca726,0x0000ded9630539d4,0x00000be14a71e439,0x000cf5fbb09cbe67,0x00008d69d5538bef}, {0x000536737183bcfe,0x000a5370dff7a45f,0x00012525b7152b7b,0x0003ccef887baabf,0x00007ac7bdeb6d1e}},
   {{0x0004f7881fdad909,0x00057d2cf6ab2591,0x000054de5cf638f5,0x000350290bc03fcc,0x000032811a7a8b06}, {0x000b3309bbd11ff0,0x000fb40449742f00,0x00051d26676108a6,0x0000c1801bb9e0a8,0x0000dd099bebf899}},
   {{0x000aaaaabe329866,0x0009f0d59c2758c5,0x0003073050fe9dd2,0x000b7824951ff48d,0x0000c23f829e6529}, {0x00022180b136a798,0x000df7a2099650bb,0x000bb4da67e2174d,0x0008d9ef00a4b9c0,0x00009a25a186fdde}},
   {{0x000a27ec11ee01d3,0x000ab5f10dfbf728,0x000ec893cf900553,0x000d76e89a83c802,0x0000ca5bdc153f66}, {0x000153797eada9f1,0x0003002562309878,0x0003c69b359c50ab,0x000449246042d932,0x0000b715a6d3c460}},
   {{0x000d4766ae06e0be,0x000dbd42e25fa41d,0x000b25a20cdd7888,0x00027d2f395f7456,0x0000adfe0af6700e}, {0x00052a9699500937,0x000ac27f8d40b09d,0x000df886a3525d9c,0x000ec248235a9467,0x00007e4b0dd735fa}},
   {{0x000b20a517d7061b,0x0002bc2df683115e,0x000c6fc6777fe343,0x000e82b870ddc7cd,0x00001610588bb87d}, {0x00084cad9c4ddbe2,0x000c1d754be23435,0x000e6c894b3164f1,0x00004be731ed3ac1,0x00006327dec6f6b9}},
   {{0x000c6de97b5cd328,0x000e35eceecd9d49,0x000ded7fe40835da,0x000804466350edd9,0x0000aeebb5cfa678}, {0x0002fb75b8ee9ecc,0x000cce3ca11851d4,0x000f4400ed7a17bd,0x0006f380d7511a2e,0x000048990ad475a6}},
   {{0x0007d2a2199e347e,0x00054a39e0518de0,0x0006e51dcbee7555,0x0009eb7691878691,0x0000b1913142a2d8}, {0x000610d37d341eda,0x0000b6d51c2b6679,0x000492dba434fbb4,0x000493454b7ee7d7,0x0000a33a79af9021}},
   {{0x0005054e4bd6d3d2,0x00043ab551d049fc,0x00042d3a609540f0,0x00023b6acc908549,0x000031af02f4d283}, {0x0008cac0992c163c,0x0000c88e3bb49345,0x0008c268c1fef8e7,0x000bff67578da5be,0x0000c8be793a805e}},
   {{0x0007baec61c3855c,0x000c98c1fd3b2926,0x0000b93b8ebff429,0x00095262d886c08c,0x0000a5e00b2eddb8}, {0x0000117c3fed8b79,0x0009f19c01f6cf33,0x0000fbd54d49ac6f,0x0002cedddaa6bd3c,0x000017430691049a}},
   {{0x000981eaff2ef812,0x00050818ae80d67f,0x0002aa892c3654d3,0x00032861d050441b,0x0000db067bf5d099}, {0x0009e86703dcc974,0x0007a133e215e7c7,0x0009a7a5ce66f9b3,0x000b618df119a6e3,0x00007c60de3c76f1}},
   {{0x0005939d860f1b25,0x000ca5ed4d4a6e40,0x000b6bcbd3e9a1db,0x000496ef23619ec9,0x0000ee790cfc34e4}, {0x00034b15bdaf9bbe,0x00066ca295f0f0a8,0x0008e378c02cedda,0x000ea36619aa2bcb,0x00005613245ac987}},
   {{0x00022cc76b23a502,0x000cea6c21ce0bc0,0x000cac3f54a2793a,0x000d561832878089,0x00009176f1beba26}, {0x00061874f6f59eb5,0x00093bdc658e0629,0x000e3040286e9bca,0x0009badca9c4d357,0x0000438b216a16a0}},
   {{0x000063c7672765ab,0x00035547b9bf0a6a,0x000b1a63337a3ce6,0x00096092c099c898,0x00005ab800db5ee6}, {0x0003f5911a5acd6a,0x0006a6201063f196,0x00096210abaee615,0x00038b96d9a649a5,0x0000ed04363bba71}},
   {{0x0007d1ca4a82b765,0x000ea3806be9cf81,0x000dc6bb55586960,0x0007eb2ab67c8909,0x00002ace7a0614fe}, {0x0007618cbbc9b701,0x000a504ca5e1cd98,0x000bde1334f06fd5,0x00026480af14ca6d,0x0000afe4322a48a3}},
   {{0x0002ca6c44b2c6c4,0x0008cef87dfea70d,0x000696377ab72679,0x00069ff10f64dc2e,0x00009b42e688c812}, {0x00044c3cea0b1760,0x0007cb2691820ea4,0x000ba9dcb53a8ddf,0x000d33f3e674ebbb,0x0000d2878a8d8669}},
   {{0x00035d5d019b6a39,0x000db06f1e4604b9,0x00057c111bb5cf88,0x000d7811912d165b,0x0000803fc21a9ebf}, {0x0001c9ec07764a90,0x000eb75bd0554f23,0x000e6c9ded93286e,0x000c9083a9457d8e,0x000046959156087e}},
   {{0x000dd8a58d6cd461,0x00057e6634d214c6,0x0001bc3289cb633b,0x0007e5b1305047f8,0x00002ede0e236a17}, {0x000ca62065a6f4f9,0x000cd7be487b332c,0x00047ed1cc3a47ec,0x000b13e41eb1870f,0x00009e66e5977598}},
   {{0x00044ca63d0ff123,0x00048610a05f6f05,0x000ad7b47e5efc78,0x0000c0c72917b17c,0x0000ff6ea2122cac}, {0x000791bf21db8b7e,0x0000f7d93565cc23,0x0004bdaad7dac70b,0x00016c882cda1d69,0x0000b88bb8cf0235}},
   {{0x00034b4dfdbeb1be,0x0001d4ee4deac4c6,0x00052482122f5ca7,0x0008b13045a368e6,0x0000d9e8a3fe52b1}, {0x0002cb1b961f49a5,0x00012b0096709b7f,0x000507a6d7fee2ec,0x000f1ce50d875422,0x000061bd7119db55}},
   {{0x0009ccc320bbcaff,0x000eef1de48c4c18,0x000a8f128568434c,0x00083b7af1b00e0f,0x00000ba9d0379075}, {0x000400432ff9f60d,0x0005f25dcf33735a,0x000c74cef3dd8e4b,0x0008ad22230f1642,0x00008117623d13fa}},
   {{0x0002876f51fe76eb,0x000b61d625893682,0x0002257188a6811c,0x000bcd13fc7e6546,0x00007df2ca0782fd}, {0x0004e52dd7b205bb,0x000797a2e4143b1d,0x000a91148b695947,0x00067455e4d793ef,0x000047ed447ad2e9}},
   {{0x00098b904c9d9bfb,0x00006b7930481a70,0x0001ee461661e288,0x00046f01a16966b0,0x0000c521308d9547}, {0x000a0fc2477de506,0x000c1dbd51efc909,0x000294905d80bb41,0x000f97485be7ec53,0x0000d465b18e3958}},
   {{0x000f330fb6840fd2,0x00041401e6c816f6,0x000b5b4f8faaeb21,0x000c4b8f83d30fcc,0x00002885739466de}, {0x000367c7bc467dfe,0x0002f842d27a51b4,0x000ea14a6926562e,0x000cd8ffcb66140f,0x0000b394dafd2734}},
   {{0x000e5d211c0be981,0x0001714e81653eea,0x0002bce1cb1e6ed1,0x0004da091086bce5,0x00004b74cc6b75a0}, {0x00011868c060985e,0x000d4dbd7f7c63cf,0x0000942ca071047d,0x00061c6e433b8bce,0x0000cbac448b8fec}},
   {{0x000d0e2ebf3232f7,0x000e552a2edd8f0e,0x000b55fdbfff80f9,0x000c113d9ab43375,0x00003ca7821542e0}, {0x000e0a0e6251b462,0x000c2c0d932d6dac,0x0005da19a89bc6b5,0x000dfb1438cd7709,0x0000f24a939ad48b}},
   {{0x0007e46766561b79,0x00057ed0322a99b4,0x0008e1865736600e,0x000fff76a47cb163,0x000027c1c2e5b135}, {0x00023370cc5df696,0x0001a9d649a92954,0x000efdb2799b37c0,0x000c2765f0043c6a,0x0000cdd99877be95}},
   {{0x0000931390420d28,0x000b8983efa46985,0x00039aead299c40a,0x000192ba05e778af,0x00004274408c3a45}, {0x0000fb991a711a0c,0x0007df52ab176bcd,0x0003c6ed6461592c,0x000066f49302b4da,0x000051fddc7f30d7}},
   {{0x000beb6da50d5311,0x000d96a7b9da94ba,0x0004bdc89521b840,0x0004494305151e40,0x0000bcde201e0d07}, {0x000a78b3b76a59a8,0x000d87791a1bf427,0x00091ed1cf84841c,0x0009436bd314bebf,0x0000e61d34d3f172}},
   {{0x000c4515541b8923,0x0001cc9d9e541d5d,0x000bf610db186ee4,0x000a9f6d9f345ed5,0x0000e7ba65e26acc}, {0x000787aa83694867,0x00071eb5ba539dda,0x000481bc309f9dab,0x000103eafb2033d6,0x00006f4ce311fa62}},
   {{0x00000cff4f066b52,0x0003261dafc2a8fa,0x00038999889ab514,0x00090324339ed7a3,0x0000ff862f1dc214}, {0x000f985b05556e3e,0x000d5467081e2c88,0x000c637eacd96058,0x000cdb9d6a4176ed,0x00001743d0a16a5a}},
   {{0x00072e27eb37726e,0x000d3481a03766fd,0x000f4aa79f7fa264,0x000e21bfbd3bde45,0x0000d1e0148567c3}, {0x000f97982e7abe2a,0x0001a5f633f87621,0x00037bf3a19eedc7,0x00094e469b155e61,0x00000ad13cee14ee}},
   {{0x000d5241c0e651a2,0x0009e2ce227e93e3,0x000b27ecaab1a6e2,0x000f39c7af17974a,0x000045446dedd444}, {0x0002a2156c07613a,0x000e5427549859e2,0x000fd094643deafc,0x000ede70834ccb67,0x000075841e5e7406}},
   {{0x000a6777b0ac93d1,0x000d68f5e0d7ebd6,0x000f5492ba6e37b0,0x000f3a1516c09676,0x0000e4bf888aac05}, {0x0002ce04df0ba2b4,0x000d1062341bcdb4,0x000acac20935d5cf,0x00000e4a30333382,0x000029438c49198b}},
   {{0x0003bc9049d33fa6,0x000a346f67ff1d08,0x000a1d6a358b82dd,0x000ac84c3e2db867,0x00002e6bead7798a}, {0x000980fde46c58c0,0x000969c8d7befc85,0x0007b35eca7f6937,0x000c0c2355792783,0x00006a933d8e0790}},
   {{0x0000e9b077ff55dc,0x0007fb26e680827c,0x0009cb54f5397779,0x0003ee995308741d,0x0000ca3f44a0aac5}, {0x0005c87a07eda0fc,0x000f3d6400c811dc,0x000e5da72c138bcc,0x00017d949680d313,0x000093eed8305406}},
   {{0x000b1574d0b75c00,0x00026386075bfd3d,0x0007b2c169716eb4,0x0002010639605c81,0x00009915109f1e4f}, {0x000a9285cca6c3bc,0x00097505c90035c9,0x0000480c4b25f7d1,0x00001c2b9f7d2063,0x00003c7b8c6ea1a5}},
   {{0x000183c5a1f8e24e,0x0009bdd255f03f99,0x0007f62a6fdb118f,0x000190d9b18b90c2,0x00008f732f8196ec}, {0x0002d910be786ab0,0x000f0ac5a0f5524a,0x00025f6945d32ade,0x000a899b53d4d697,0x000032a76c60510b}},
   {{0x00091a3ebeb15447,0x000bced73ac38403,0x0006cb8b344b7b88,0x000b12624bae7a25,0x0000ceb151b5394c}, {0x00066d05bc1e6a8e,0x000a290f07bfbd6b,0x000937589ec70cec,0x000cfd470644ed7d,0x0000e9e1a3e3f1dc}},
   {{0x0000a84745b98d25,0x0000d556ed40b0d4,0x000148cb9da429a2,0x000936a676eced85,0x0000a22d40d2ed18}, {0x000b9e570e8a4cea,0x000afeae03793bc4,0x0000bd47ebfd1445,0x000531523f2c0c1a,0x00009c0bb3281845}},
   {{0x0004d600a4c3f6b0,0x00092c15ef449ddc,0x000484accbdfaad7,0x000f15ce55a2367f,0x00008653ca7055b1}, {0x0008724538873a39,0x000d1ce1c7e72efa,0x000e332ba09299e5,0x0001b677afab66ad,0x0000be1fdf722dd7}},
   {{0x0005d595758b11cd,0x0002f8654f40a49b,0x0003794470b85289,0x00090be63ef6f452,0x00004957d29e05e6}, {0x0004363646559b01,0x000c39788a8e7d48,0x000ce54a9f4a8273,0x000a9bde406cb834,0x0000e1c2610086fd}},
   {{0x000e228cf6a4a81c,0x00025b488772e150,0x000a9c15b1fa3b6a,0x000a465e6ff110c5,0x00006133b924ad6a}, {0x000d55c9dffa978f,0x000c6f3965f28ac5,0x00032b52fba1d1c1,0x000a070969f4e077,0x0000ceecdb695172}},
   {{0x0000a5f10f2b8f5d,0x000e8c4c2f63b012,0x000f9c213c83a6cd,0x000bd47d47a491f8,0x00009e1cce6a3f1b}, {0x000bc7caba7e3721,0x0008cfd1a2db0d91,0x0004618e5fcdc74c,0x00025df5efa80037,0x0000121696925a79}},
   {{0x0009823f6021c5dd,0x00041ff14423d4c8,0x000cd1396880d5e8,0x00078a9523bc5a6d,0x00001acfdfce13c9}, {0x00064e8bbb66840f,0x000d82b58459b0c1,0x00038e8ecf7f4301,0x000698d29ad4a6a6,0x00005ab896236b78}},
   {{0x00079740e9547505,0x000814f9d2c69dbd,0x00085232e0121de8,0x000776de597b42d9,0x00005b6c3c5a3451}, {0x000e547519cb9fb2,0x000f6428600dbb53,0x00081791af134019,0x000c083a473176e0,0x0000f3e226355fb0}},
   {{0x000301773d273b06,0x00061721ef9ab28c,0x00050dc39ccd2107,0x00045da54cc292b6,0x000062246dec1880}, {0x00052fa6b83c0d12,0x000777e9cd46904b,0x0009725e4a72df26,0x000f22686b43cd89,0x0000b651688f849f}},
   {{0x0009b7902f345331,0x0003fc77c1486047,0x000537c785e354c1,0x00095fa4bb7581a8,0x000088043d7ffe14}, {0x0002f428c1d50261,0x000683d4aaab9ba1,0x00057c4502e0c8a2,0x000fefadba7b8baa,0x000040c9ad6abbda}},
   {{0x000aa4225ac0f182,0x000ae4d1fbf32067,0x000b04824f7b1295,0x000e90f4829111a4,0x0000ce3f19253bd5}, {0x0001d558f2e1b72b,0x0005802aa2439c7a,0x000be9554fe93228,0x000a6d997ca7b4d4,0x00008e821b990547}},
   {{0x00038be67e573e06,0x0008e084c44bfb28,0x000c1c2c505891db,0x00044b3131137396,0x0000aebfa4039584}, {0x000dce9e56e55c19,0x00029caa46d0ac9c,0x0001fe8eb7148ced,0x000f4c9e10c7efb6,0x0000fd835db8f97c}},
},
{/* digit=29 [{1,2,3,..,}]*([2^203]*G)  */
   {{0x000a109081e9387c,0x0006cc935828a36d,0x00040b015fb9780d,0x0006fa15940332e5,0x00009d7b51ca0f46}, {0x000cd41d6d9f6711,0x0008a1a2ac17faad,0x000201e5fba6c1e2,0x00062af66a7833ed,0x00009d9971a090f4}},
   {{0x000f462060b5f619,0x0003ebd057c2f431,0x000e1bf65a56f46b,0x0001fea48dca6c47,0x0000a38783ed1bcf}, {0x00033a9da710718f,0x00063e0aeaf67a5d,0x00029d1875a77998,0x000732da87314d2d,0x0000a0edc3fb687d}},
   {{0x00036216a31e09bd,0x000cf1350e359df3,0x000a0cf52de89e44,0x000537592148714c,0x0000f379672db88a}, {0x000510a2591d61b1,0x0007485b447bc92a,0x000287f7779aa87d,0x000a80e67db604e5,0x0000697c8bf6efe7}},
   {{0x0004849cb198ac73,0x000cdf2646651c89,0x000200678a884a93,0x0004e5fda964ef9b,0x0000c351b8730983}, {0x000ef9fe2c4b44b8,0x0006b326790cafb2,0x00002264a580f6c4,0x0004e2384805210b,0x0000ba6f9e2c2a19}},
   {{0x000975f8fb547385,0x0007d7c3ead3fc87,0x0004a085a3516078,0x000996334116d2b7,0x00003c99a73f62fe}, {0x0005be05b81c51b3,0x00088e0852b78758,0x0004d19a7925bafa,0x0006d446a4fafda8,0x00009a4598288520}},
   {{0x0006ab65eb03c0ee,0x000392bc3fde499b,0x0003a80d2f19b795,0x00019ec86b5b9c6e,0x000043775094d428}, {0x0003650bb3ee8a3e,0x000bd132075fc166,0x000d834f675eb14f,0x000ffcc8ccc9067a,0x0000a6a2475c6e92}},
   {{0x000fd950f8d67583,0x0001108c07dd9d72,0x000e23221cb84e10,0x00042c89114bfda5,0x000058b5fe3194e7}, {0x00077ec95f40e756,0x0000dd73f3d61c05,0x0001b9b66f015545,0x0003c73d55cd67bd,0x00003e86e790f8d6}},
   {{0x00034abd3c095f18,0x000e64b76d7139d9,0x0003e698404b261b,0x000b109d2e6970e7,0x000079fb23bde5fc}, {0x0006c72dfd754907,0x0004f1bcf1c11150,0x0005e70073a97d08,0x0002a6d3201d82bf,0x0000f0ac52fe9823}},
   {{0x000cbc46eb564d4c,0x000bde570e292715,0x000f5fd5d8d6c752,0x000514380247c89e,0x00003c66b47953eb}, {0x000b4010f87de563,0x000f96c603b59666,0x0004fc942ce62c06,0x000c197e7b4c607e,0x00008ac0b77963a9}},
   {{0x00020ee4b049136e,0x0001556a4613cb4d,0x000e081288b63bf1,0x000b153221aef670,0x000062d8c522acb6}, {0x0004a67379e7896c,0x00020afd7fa571f6,0x00041ba6ab25237a,0x000e7e3077bd9838,0x00004ac0244fcd16}},
   {{0x000a86921fea4ca8,0x000773dfdac1548b,0x000685fafd36d081,0x00059989d8d71ff4,0x0000eff66bf452c4}, {0x000aee70b57235e6,0x0000a106712b182f,0x000fcdcb0ee3c39b,0x0004b9f107331fc0,0x000069fb9dd05105}},
   {{0x00001fb319d76820,0x00090a982feeb251,0x00061b344b029312,0x0001fa51c1c9b902,0x0000e008c5bbfd37}, {0x000dd1c0278ca331,0x0006d5aa53b1d866,0x00013a2cf666f76a,0x000836d5cfb77960,0x0000d3a1aadb3521}},
   {{0x000253173faa4851,0x000fb0a76878cedd,0x00011667dc8ee6c4,0x00095acdbccfc92a,0x0000a418ea92c2f6}, {0x000bd9251f73971d,0x00020a2ed89fdb11,0x0003e03193e4b3c8,0x0001aeca44f3f4e7,0x00001e3de1000343}},
   {{0x00004ff50f75f9cd,0x0002ae752b223c56,0x0009a11181d8eddf,0x000d7a3ef074dd3c,0x00000ffc1739cb86}, {0x000ece3037d90f29,0x0005d055856cabd1,0x0004c6dafe3f307d,0x00099fb22f93287e,0x000002aac66c3487}},
   {{0x000e7bf94cdfadef,0x000c8fc6d634b6a1,0x000fb63f86c97e1e,0x000404762ad24da2,0x000081be1ba95928}, {0x00065e4d14b4206e,0x000dafa0db6586d7,0x0007fc76cbecc2e0,0x00024dc28838e0b1,0x000049a602bc37cf}},
   {{0x000131a567193ec5,0x000a95f6e70b76b4,0x0001eebddaf3c305,0x0008314587bd3903,0x0000709def8c1bbe}, {0x00099830eb2b6692,0x000b675b70295705,0x00064ac164d80ce1,0x0003ab638a7da803,0x0000f431d23de1c8}},
   {{0x00012a6f9294dd32,0x000f7b4b0d77e568,0x000e8305cb448d01,0x00063ed3ae606104,0x0000bead645b4d8c}, {0x000434d84fd8b072,0x000fd7a9dee50a85,0x00055bd85537b983,0x000f8bcdcc5f18ef,0x0000041af6241c6c}},
   {{0x000874cb940c71e3,0x0009ab5f4b3a8e52,0x0001b1dc3211935a,0x0006206435049230,0x00003d2646d59958}, {0x000d64bef9114044,0x000a5a3c5ef416b0,0x000352c789d1f25e,0x000427e0f200eb4a,0x00003929f2c8bd0b}},
   {{0x0006667c7196e295,0x00004391be48a565,0x000e0cd6e7992c2f,0x0009bf5aa97cbd9e,0x00001b0310c8dc8c}, {0x0008acfdd9f22cb0,0x0001b585d584237f,0x000416388bb1d81a,0x00074f8d5d85f58c,0x0000d6e5a5a42fe4}},
   {{0x000276638235d4e4,0x0007096e3298e781,0x000175bc81c62bd6,0x000d4d4378660c3f,0x0000d04e18957afd}, {0x000160185a8068c5,0x000142b29a8532a8,0x0000d8a3bdb58e4e,0x00003b98a65b86c7,0x0000f0e6f4ee8a04}},
   {{0x000968469ed23707,0x000c9871ee260812,0x0009c5b0534dc30b,0x000c86ca5ce9487c,0x0000d487b80b3a90}, {0x000ba37dd0e71799,0x0001240418114089,0x000747ba545f8019,0x0005918c3e105898,0x00008c4e13afe1ae}},
   {{0x00036e6e82c9f9e4,0x000c833a1043d446,0x0008aec05711db87,0x0004aa2f431263aa,0x00003ff120d6744a}, {0x000892fae77779bc,0x0008ccdc9f82d3bd,0x000c5b1bcf0fe0cc,0x000a720a5f7fe6f1,0x0000c63a68304929}},
   {{0x000ba0c09dbe19a1,0x000d5b5c73c2c7ea,0x000e50c302f3585a,0x0000ba7ab8924b0a,0x00007fcd27a738b3}, {0x0004d3410b3d5a5a,0x00018a9accf1af41,0x0006a624209c107d,0x00064175dac49f94,0x0000ec3df2b7707d}},
   {{0x00092b73f894ae03,0x0005875f18ce2c24,0x00053cad0f59df3e,0x0002944cb740d28f,0x0000eb585fbf4f01}, {0x0000c8632c7f717e,0x000acf943f4c17da,0x0007c51d2eb8c795,0x0009486ee23fb5f6,0x0000f18757648889}},
   {{0x000bdb20389168b6,0x00088a577d03a6b4,0x000743082c4ecd25,0x0008ccda63782b55,0x0000f678f4d272f0}, {0x00011cf65e58dd88,0x000e5402c0cd5535,0x00037c14cd53b4e3,0x0002a9b7de3e29a0,0x00006b6c51740571}},
   {{0x000da3eb38dff6f0,0x0002ea636be82834,0x000dd37f8be012c5,0x0002db292d238c61,0x0000e54523f8f814}, {0x000b436036a05d8c,0x000e5e93c0ffe31e,0x000821ddf83e3cdf,0x00033a7fd2fe0f50,0x00008e19b0ebf9eb}},
   {{0x000943fb569a5fec,0x000414342d75c8cc,0x000eca000ad0090d,0x0000eac2090b4bca,0x0000a39687fdbd41}, {0x0000df765959d77e,0x0007bc964999e7bb,0x00041545139d7821,0x000107f87f62e8b2,0x00005efb7759ed76}},
   {{0x00011a4e822f0d08,0x0000da8704f83ea0,0x000c6820fbc647ad,0x000bec3b315b3550,0x000063dec3e37e76}, {0x0005d3af017bfc7f,0x0008a76b822901ff,0x000bd0d3b2005443,0x000d0e167fca370b,0x000063dde656f5e3}},
   {{0x000efb32a4c94e9b,0x000de6f8278a22db,0x00003793dafbff0f,0x000d28d0aea0b135,0x0000223802a0f06c}, {0x0003e578ec3fecad,0x0003693e70536570,0x0006734c406c3831,0x000f1dd0b751eb7c,0x00002e8a436959f0}},
   {{0x00090525e9ca895c,0x000dd72072df147d,0x000c6755c2f4dd31,0x000557e16fda8ee6,0x000066827008f196}, {0x00076a30cf43895a,0x000fe3c3097b1f1a,0x000390e0ea9d604d,0x000eff4190830966,0x000050bf75453c85}},
   {{0x000bddef6a702510,0x000b3c6ab16a0696,0x000d08762548b801,0x000c4e37fcf704a4,0x000090b3defdff76}, {0x000cb8969cb91584,0x0004595ece4387e8,0x000d9fbf544a9074,0x00082db85395f40a,0x00009b0f6c58fb0c}},
   {{0x000bc15adf7cccff,0x0005efa1e1b075d9,0x0009bc17e81a3e5d,0x000d429c39e44424,0x000037dccb37ea7f}, {0x0004873907fba12d,0x00097a372904da65,0x00083a6c535daa6d,0x0005be3564cfc662,0x000009fa4f71a939}},
   {{0x0009ec9aeb19a362,0x000ea7bfbfb4688e,0x000c2faa6d913f1c,0x000c12597b9a3c61,0x0000f979bec8a0a9}, {0x0009d0f359679ec3,0x000cd79b0460b596,0x000fab870ebcf523,0x00039ccd6b000810,0x0000f2edcdac373a}},
   {{0x000f9a76f568431c,0x000b42f8898c0d64,0x0000b5bd5f848c27,0x000ee83418ade126,0x00001f3e3242973d}, {0x000319c26c185ddb,0x0007a46f0ac446e9,0x0007f9d576d85b7d,0x000f47927965f224,0x0000519b63760035}},
   {{0x00063a9ab87d59c5,0x0002e9caaa116b61,0x00077387bff9f58c,0x0007f8fac39cde31,0x0000f6557c2d73e7}, {0x000400636a830417,0x000a05ef196c6750,0x0008c79409b1c96c,0x000316834283deb0,0x0000ea096448128c}},
   {{0x000b3b56aa39dff0,0x00029f8e4d8cb510,0x0004c4b9f59b43da,0x000c01a8ce31fd9e,0x0000e20be26c1303}, {0x0007182e8ee47c94,0x000b3db981011818,0x000e14ff6d9687cd,0x0005723a520e4da1,0x000029808bac836d}},
   {{0x000a60d4944b6639,0x000913f91ae5a37c,0x00036e3b1f901f7a,0x00025054e3e76e9e,0x0000aa219cfb9d93}, {0x000e275056a2512b,0x00092e65d95c347f,0x0009fc3eda4d643d,0x000bbde669d39669,0x0000598dee37f8c6}},
   {{0x000c1e5dda9e5c65,0x00027aa9fc95682a,0x0002bea444e0d3c7,0x0009c7c7faaade77,0x0000ef8428cfb000}, {0x000e47a460ff0166,0x000f125281cbcc4c,0x00023aad2da6d12b,0x000e27e4c6784802,0x0000e342afa96256}},
   {{0x000bb0b93a37c047,0x000b6d10bd961400,0x000ac46b762b1bc9,0x000f510251adeb0d,0x0000d33b92eebe4e}, {0x000a94be61fa29a5,0x000eb642223328b2,0x0000d8d374b2be13,0x000004e6d6d06233,0x0000ef80e1f028ca}},
   {{0x00046996d16768e9,0x0009d28bf217174d,0x0004e490d9fc4ff6,0x000979e7705a9415,0x0000d96dd291d2d9}, {0x000d9d8ce5d72c41,0x0004b11c714f77e2,0x000e4a03e9d06c5a,0x00028af2aa513679,0x0000386b3c2130ff}},
   {{0x000e8a6fb283f61f,0x000503abc3fbfe82,0x0004d36227df203e,0x000760fec7c3513a,0x00007d17dc0cf762}, {0x0006e44522055f0a,0x000aefa748dbc395,0x0001dcc14de3012d,0x000f3a2a9fcb63bf,0x000056d9dd05e4e2}},
   {{0x00086b68bcec9c2f,0x0008780b9f06b861,0x000d292817cf24df,0x000e11d46b45eac0,0x0000ff42bc5f7b10}, {0x0003c404d289427b,0x000904848ec41226,0x00040800c3d5f189,0x000b1f61f97010d0,0x00004c5f529e00fe}},
   {{0x0003f8fde94fdcb0,0x0009c7c2f05ecc54,0x0002692e1e96af73,0x000ae9aa5e003688,0x00009c75b68950d4}, {0x0003df2b5932a7a7,0x000e6e0979ad62f6,0x000e696312658252,0x00066aba19343fb5,0x000018c7501c25b6}},
   {{0x0002d69ea40dc3a4,0x00026ecc018f26a4,0x00070f04adc84ad2,0x0002ece5c36c7b32,0x00006ba6d4790fa7}, {0x000d1c593e58a8e2,0x0000f20c088c6c37,0x0006e86daa239473,0x000038a3be4263cb,0x0000c417d369126d}},
   {{0x000f9c58b6f8efae,0x0009577185365b70,0x00039c92b671a2fa,0x0003c1f3ced3c6b5,0x000056f1bda83120}, {0x0006ec49ff3c8eb5,0x0001f3491cea8b09,0x0009437942deae43,0x000842d465c6eb17,0x0000d267e6670586}},
   {{0x000116db07159d03,0x000f918962109d3d,0x000961579ae07a67,0x000dd65fc84d87bb,0x00000009e494c1f8}, {0x000af22e31328195,0x000ca23ab4ff8a8c,0x0005dd687cffa197,0x0007a208103a4420,0x00007b796c35ded6}},
   {{0x0003a6ca1779ad79,0x000da57c09c50b9c,0x000b4a57ea33cfe2,0x00052d9ea293153d,0x000019596961ebeb}, {0x000b9a6e546c8792,0x00044295c8d6118d,0x000ec806b8e996df,0x000035bd99048455,0x00004f291ca365c1}},
   {{0x00023bb440e22296,0x000213ef4d04cca5,0x00011ec39324673a,0x0008d34f3adf343e,0x0000136d7f23c596}, {0x0002899b053a9270,0x0001ae067ecd7a7b,0x000779cd93eaa266,0x0005ea8549b9c802,0x000061d7940c5338}},
   {{0x000a883f06d18bd9,0x0003227008433e0b,0x0001a9e4d4ba6de5,0x0000ed2966b66859,0x00003f675680f4fa}, {0x000711b4347237bd,0x000f1794608e5a02,0x000f73d8cbc041e2,0x0004f685af10f570,0x00002d4d4f88b756}},
   {{0x0007a89b3e93ce7b,0x0004ad3a2c1bd7d2,0x0005b218af7b5a87,0x000754029e68a025,0x0000533837f3af76}, {0x0005a73579fab2e2,0x0001ccd74385d1b0,0x0005e9115b41055a,0x00074e9236927444,0x0000972a7c515202}},
   {{0x000334ef678e68a2,0x000079b057ed6c08,0x000ccb69a4e4160f,0x0007721cfe11b852,0x0000fd1823a41c8f}, {0x000072f3298f0557,0x00098ec74a6edf7f,0x000b4d0418c0566f,0x0008507549e0195b,0x0000c3930bb0208d}},
   {{0x00041fcaaa2902bc,0x000924f69ad3e071,0x0003f9ffd539ad79,0x0002f6e6453f9481,0x000058d3c48f75bc}, {0x0006fad5dc64e964,0x00097240e354b332,0x000a1e7a93aafcaa,0x00089fdd1b0903ac,0x0000ceb97675211b}},
   {{0x0003e49e32a858e7,0x000e3e907badeca8,0x000b9b4944c32892,0x000e1b65b42ab62e,0x0000fde3ee28eaba}, {0x000ab09caf549579,0x000e55f5d5d513b5,0x00003e2c0bfb028b,0x000843028a065020,0x00000793aacf7476}},
   {{0x0002e79c81710a00,0x000627ccadd45e94,0x000cf6d0c557e4a3,0x00080c72a2bc564b,0x00009ee5f4326d7b}, {0x000dbe9d4292f19b,0x0005b3f16b186b70,0x000fbb42a56f74c2,0x000040123db0f735,0x0000606bdf71ae10}},
   {{0x0005d4d044573ac0,0x0006556b0ba41eb1,0x0000df6f77dc3cf8,0x000e8c97af9a33c6,0x0000b1ef85ca716c}, {0x000f884c96958bee,0x0003556909632922,0x000a000617c32fa9,0x00065b4d7f667cea,0x0000aaf7c1815473}},
   {{0x000de4687032d585,0x00030e2c79e01eb4,0x00004ef23c54f3d8,0x0001b3b7818df45d,0x00005faa9c8b73d4}, {0x0004f6f89b95355d,0x0009e7415c84ced6,0x0000ebad34860d2e,0x0005be8fdb9bd205,0x0000b53e0cd3685a}},
   {{0x000c0319feb65939,0x000fdaccff17b830,0x000555c10dd87f30,0x0000649303ebab9f,0x00004603695b87e7}, {0x00011c32e83358c6,0x00048efb0178f883,0x000ba8652508dd9b,0x000be51ca237062d,0x00002aac5a36047a}},
   {{0x000d2a08b1ea7b31,0x00039e8b14859a61,0x000052f99d495ab6,0x000eea28740f8487,0x000078ebe5bc2974}, {0x000bcca5b36d17fa,0x00030af86eea030b,0x000f8e9e0b5e4cce,0x000e75151a022068,0x00004348796a9eb3}},
   {{0x0002309eef1a7522,0x00074f2aa1edbe59,0x000007dd25d7162d,0x000d228ebfb5ed0f,0x000055e14b2e89ed}, {0x000e0720303b6972,0x0005d05720ffba85,0x00028ebb6c5d17e2,0x000112e2b58d6e51,0x0000c80242df754e}},
   {{0x000ca5fabfae1ca1,0x000c0a21459b919f,0x00066a4d2937afaa,0x0003318e0ca91c1f,0x000094cc7f333ec1}, {0x000143a8aa116906,0x000ca9b59e08ad25,0x00050860abe40ad8,0x00034bd7d60d9be7,0x0000c53b00926bf4}},
   {{0x000415d1356eb809,0x00030578ded8b572,0x0008fb38bb8bf9da,0x000b2192658e365e,0x0000b70ce22eaf8c}, {0x000018a829a81803,0x0003881ed2957c00,0x0003cea8384329f9,0x0005364c343ea25f,0x00008f8655f97586}},
   {{0x000a0d01d3ec517a,0x0001b12321aea661,0x000a925989874465,0x000fea684ca591ec,0x00009bb9dc9bdcb3}, {0x000435578b4c2405,0x000b110cafdc14c5,0x00038846b5ed62a3,0x000160b7512f371b,0x000071bb70b00e38}},
   {{0x000b95b2da705d20,0x0006b1a08f98b556,0x000ecfbe53ef8ada,0x0005cd85302ca7dd,0x0000e53057394310}, {0x0004d5521a9255d9,0x000162f3802a6055,0x00047787563a32fa,0x000da0a5c8c5b0cd,0x00007f458eafad42}},
   {{0x0007080eb6b242d6,0x0002db71e246832d,0x00031139dd30bd02,0x000e531027991bbe,0x00008797e91a62e4}, {0x000e20a6b4e185ab,0x000d92d9b707423f,0x000f7811b82f2c67,0x00095c75c817684c,0x0000d53005eb45bb}},
},
{/* digit=30 [{1,2,3,..,}]*([2^210]*G)  */
   {{0x00049be9d8e68fd9,0x00028b044320e5f6,0x000c33398db0f053,0x000fae66fde9b3e0,0x00002f4209bf6c8c}, {0x000afcc1a739d4b6,0x000f428ab8dee9d1,0x000c6f1d009aea75,0x000aa4b4375fb5ea,0x0000420b560d08f7}},
   {{0x000499c6254dc41f,0x00038a837e7e9eae,0x0000524a77e29392,0x0005f184aec08c09,0x000082b921a7d6f5}, {0x000962e1402cec5e,0x00071a2f30e7493c,0x000b879cb9f17ca1,0x00045edcd783e8e9,0x0000a3d8c153a6f1}},
   {{0x00015e75e0dee6e5,0x00028c628aa2dede,0x00061bb9374f2487,0x0002e083e9c4fe78,0x00006d4822ab187b}, {0x00017cfc59826f90,0x00092408169eb664,0x0009ef885ca26096,0x00038fedf69d06c7,0x00000031f8adc7d1}},
   {{0x00046e60ebcf7262,0x00014231470e103c,0x0007c21094482b83,0x0006ef4f6dfaca48,0x0000e0ace9782e66}, {0x000a9d31f8d1f420,0x0001574944d23246,0x0007f334b1b1e83f,0x000d8113dfa63aa5,0x0000cf8daed9f025}},
   {{0x0008ea800ee11c1c,0x0003f5e3dd7530d7,0x0008c43c5eb053cd,0x000662db65b13ed5,0x00003ad49be7d151}, {0x0008e41b64279905,0x000d207eae1e99fd,0x000abb71e12cf15b,0x000d0dd9ad4f1b1a,0x0000143e74d57545}},
   {{0x0006336c88bdee1c,0x00059876767c3026,0x00073199625f2930,0x000950dc078571c6,0x000088690b3ad552}, {0x0002c2d852705b44,0x00040e09552d274f,0x0006575d1b0bf8d4,0x0006513628beeb98,0x000007be238bf864}},
   {{0x0003049a639fc6b8,0x0009060036250e5e,0x000cc1646e75c35d,0x0007398cf35bd85d,0x0000bcaced2ec262}, {0x000cf1db55367425,0x0006ca9e068be22e,0x0007909c5013dd89,0x000505c7f411cb8a,0x0000757ac98d61dd}},
   {{0x0001f0d1e935abb5,0x0003c54de37a85de,0x0009cebb5defd10b,0x0004be68d9e39236,0x00004d5ef9bc6132}, {0x00041ba74f17e266,0x000818c1dde44d63,0x000d918fdc0a0e3c,0x000a1346d7758187,0x0000687601562ca3}},
   {{0x0003e9cf36658f0c,0x000bb1f8057ec731,0x0006a835ac433ef1,0x00094bc53262461b,0x00008f053993c863}, {0x0008cdfe983c4a11,0x0001f3b7b931ff39,0x000b9045bbf5e816,0x00046b83193c46b7,0x0000e4ebf5db4a6e}},
   {{0x0002a6043a24fe7c,0x000e3fb3492bf994,0x0002fde0529c1191,0x00032cdf66244990,0x0000792a7ad2713c}, {0x0008ad8b737982c6,0x0009421e60e32fd8,0x00083591a7e3a031,0x000455a9b0de4473,0x0000df141eee310a}},
   {{0x000a039e6d6f4714,0x000ed198d12eaec1,0x000eee5ac14b2ba0,0x0004ceabc1a1603a,0x000001f483720b96}, {0x00037964fd03f663,0x0009ad8f3f122ee4,0x000380f183fdb4e4,0x000d163ef267f629,0x0000e8e9670bda64}},
   {{0x000180c207674f17,0x0006c3ae8fdbbc19,0x000aeb71e112e09a,0x0001c7296675546a,0x00009432af25101b}, {0x000558fde2ddec64,0x000f1357753fd5eb,0x000e1158a81392d1,0x00099167a76b973a,0x000016fbbff8a899}},
   {{0x000fdfd0d4a9dcf2,0x0008744ddf129e65,0x0008568667bc29e4,0x000fe29c1a92d93c,0x000073c69058e98d}, {0x000e418cdfaa6b88,0x0002d061c69f69fc,0x000f75e27606bd82,0x000a1ec2d495a06a,0x0000ed3d505ed873}},
   {{0x00028416ab25b6a0,0x00072b1a4523af55,0x000c99e03c6c0ffc,0x00091bab18827b21,0x000060e864890346}, {0x000f90f93c7f3988,0x000b02f8d10b5207,0x000d0f9e39f4a96c,0x0004f55d71cd793a,0x00004f435d37c3a5}},
   {{0x000c55b8e33787f1,0x0005963846734b03,0x00051b9f0ef42f97,0x0007c2ef7304f750,0x00008aca1dc841c8}, {0x00020a72d4bfe80d,0x000c353e732c56f1,0x00037ca16fd823b3,0x00096a41bccfe475,0x0000f6c9c74eb5a9}},
   {{0x00032c7904fc3fa4,0x000587e3636aee73,0x00091d9aa14a23f4,0x000540838659c3f0,0x0000a995e5df12d8}, {0x0003becf3a5598a7,0x000741eaa99520a5,0x00004e03c56534b1,0x0002682ed3dca4bf,0x000016c563b48d56}},
   {{0x00077a41d6178e77,0x000ff8a1ff8e27ba,0x00013f63de4c80c3,0x0006f3050110990a,0x0000bf33522161d4}, {0x000218e10b365bbb,0x00035fd7ea750aff,0x000b3a9258102180,0x0004e555a3fd8aa4,0x0000829e7604b3db}},
   {{0x00075a54d53e5fb8,0x0002552717e36bdc,0x000a42ec204a5dc0,0x00038206af502fe9,0x0000867e8fba630e}, {0x0005c6ebec9889bd,0x0001fb47c98dbf84,0x0000c2a1254f491f,0x00008ad3091fba79,0x00007f6fd79920f7}},
   {{0x000ac30acde5e173,0x00003852b4d7a569,0x00009ae54d0f996d,0x000061b51d4bb546,0x0000fa37d173daed}, {0x000868434b8fb41f,0x000caefb64f162a8,0x00048e1f299a2acb,0x000068c75c1a5e64,0x0000a99951b32b5a}},
   {{0x0006e892f3b26e7d,0x00000a8752476d95,0x00082dda3f470986,0x0002ef6ad1517924,0x000064110e3d17d8}, {0x0008d2cfad414e41,0x00081ed02b241492,0x000821bf12b155f5,0x0005da381a141bcb,0x00002e3c7705f81f}},
   {{0x0005de59fff83814,0x00021bbec894e49c,0x0004d88c41105323,0x00031b60d051cc45,0x0000f6db89c5f8e5}, {0x0003fd6ca563a441,0x000548da8ab934fe,0x00074f0a17f5c221,0x000a0a7445016d94,0x00007d34d61db7d8}},
   {{0x00039101c474019d,0x0009052ceefb8e9d,0x000622c2bcaff262,0x000a0529cf3e32c1,0x00004b95e3db9071}, {0x000a61f1594438c2,0x0005e4aadedffbbc,0x000e149401eb6e6a,0x000a9c653027f468,0x000021d322affabd}},
   {{0x000a9f6b7cb179a6,0x000d57934dcced8e,0x00009180ddc7b764,0x0002dd9cb139405e,0x0000629a6c0147dc}, {0x0005e4e9f5a915e1,0x00075204441ebfc5,0x0000c5f53b1db9d3,0x0005b1e82d68cf93,0x00007d3a142dbb60}},
   {{0x00044ea308780f21,0x00012845f5e4dd59,0x00024d7a3dc8de76,0x00011e5beaba7d76,0x0000e709afd404df}, {0x0004376021704560,0x000ac8f94b649536,0x00080ca68bf204b3,0x0005744e53af7c56,0x0000526074ae0c67}},
   {{0x000cef8ecd92af61,0x000a5cd1745a95d8,0x00025c3e4e6b9fa7,0x000aae2d546d3da3,0x0000f57691daae93}, {0x000f3fe9d2e1a33d,0x000edc063d35e891,0x00013a327d430093,0x00018f1da59b1255,0x0000c2134f42536f}},
   {{0x000fe2c5c2102869,0x000d8cab658caa51,0x0003572923f68aae,0x000becca23a00bf9,0x0000a626f3a0efda}, {0x0003bf3199d78e38,0x0006f1bbc345fe2b,0x00059802cb7a2af7,0x00051bbd19827a1e,0x000023bbc163487a}},
   {{0x00039f299d0a4221,0x0005e456c6fb8561,0x0001f8bd69ac3df6,0x000f879ddf65c670,0x000049f321e4758d}, {0x000f714721b7ebaf,0x000741a3312ab1ec,0x000c4d581e17df09,0x0001b2eb2fd6ecd5,0x0000d0299707fcea}},
   {{0x000a63e7882f14f1,0x0004f7c6cadce29f,0x00082bed0c9f6dc3,0x00052c36f22d6fb8,0x0000a45755be118e}, {0x0007c277c4608cf7,0x0001e68012c29f2c,0x000729b0e7ccbdf3,0x000dbf8cb0aedd61,0x0000ca2ca9f67d75}},
   {{0x000ecb16f640f620,0x000b39f51946f58f,0x00088af44e274b92,0x0009e57f4dfc0462,0x0000a91f32aeac32}, {0x000274bd6aaba315,0x000fbf6884f943ad,0x000f91e20719a163,0x000d52185d29f6da,0x0000ec1cc3377e49}},
   {{0x000de963b54a0599,0x00055fbcfdb338f4,0x000bb8da60e0015e,0x0007ac877d23d94d,0x00008724aa327a61}, {0x000885bfdb6558ef,0x0009d7899a9630f0,0x0002dc112f9f7a28,0x000458e2ae8ac887,0x0000a0642cb63c3c}},
   {{0x0006981e7dfc8d6c,0x000f5fb5b94a1529,0x000ddfd3767cd444,0x000dc64ec71cf10e,0x00007e5eeb45a8ed}, {0x0008e3d81d950286,0x000210b0e35d02ac,0x000881fe30088f17,0x000faa8c041fabe1,0x00002cf71b9399e7}},
   {{0x000dea7e0f222c2d,0x000ba2e651425043,0x00016cd30309d42a,0x000eebc4fe9ddd92,0x00006539c7ddf87f}, {0x000a57c432ac7d72,0x0000127fda1003c5,0x0000698de72692cf,0x0003b1cc28c85f28,0x0000331fb469ec28}},
   {{0x000fa322867e6332,0x0001ea9cc815d34b,0x0005e2fa578709a8,0x000fb597fe696487,0x00005cc064fbe98b}, {0x000151c493a65c5a,0x0000b31824649eb0,0x0004618e25fb5d94,0x000ab5c9e6f130f0,0x00008ecec23989c8}},
   {{0x000c88bb96209bd8,0x000b33e1c9e0cd6a,0x0008d8eac65fa8cd,0x000963247d22f54a,0x00003895ce00d33f}, {0x000ca59b56cd3d1b,0x000b2af38232a8ad,0x000080a9f10c8350,0x000b397b161fb3a5,0x0000e7f5c64eaf65}},
   {{0x000403997403a113,0x0006e21b96af2c75,0x000983ec294626cf,0x000df7131de7c46a,0x0000780dd3a82cc3}, {0x0000e462baf8e3b1,0x000d41d299aee28a,0x0007a2408abe68aa,0x000981503eb8f964,0x00004c61ed66c750}},
   {{0x0004414c53352e78,0x000b9337d46e88b3,0x0005f2bc85a34889,0x000a39e12c1560f9,0x0000a3f844254807}, {0x0009e975224da68d,0x0007f3eb00e9680d,0x0006bc37560cd6e8,0x0004c16875a98e9a,0x0000c80f9251fd55}},
   {{0x00034156ac774075,0x000ed54206816c4b,0x00007a458a1e5ea8,0x000bf9041bfa1446,0x0000dbc7e7ae6d7f}, {0x000851b31590a478,0x000995ee6df8646a,0x000b43fc0039e85b,0x000e04519fa231d7,0x00004bc8be8a99a0}},
   {{0x0002936f20df03ab,0x0001d608d4722b9d,0x00049202a2405438,0x0007b6c6b6ba0491,0x000021c3831e670e}, {0x0003059d6fdee104,0x000338488e71ddd9,0x000fcfb259da47ad,0x00095459cc1dfda0,0x00002abde10a4696}},
   {{0x00015fc17eab9fe8,0x000453e7097214cc,0x00032112cd6e863e,0x0004d7a9a7765c64,0x00008660001db077}, {0x000175a2c088eaef,0x000d9230b8d43729,0x0005f437913afbca,0x0008115476815191,0x0000086431bc8d22}},
   {{0x0001955c298b9743,0x0000c8711e043746,0x000969d18905fb5f,0x00094e487abf3afe,0x000092167c29f6a4}, {0x0000d2d28c511da9,0x000c266a262dfc7a,0x00063fdf0f127c7d,0x000f4669c4bb95fd,0x00000016589c913e}},
   {{0x000a73c11aa600d6,0x000d3fb5ab5274d2,0x000b700682f5379b,0x0009a7849e53a47f,0x00008dd39e5a04aa}, {0x000cf572ecaa9c3c,0x000b2824826bb9b0,0x00031a3c4ba0e103,0x0006a1a0c2198b46,0x00005ff84acba896}},
   {{0x000be22ac95aff87,0x000b45a46d092d6e,0x000ee4f8d1c9bb6d,0x000feed19062da53,0x0000b9042d12b97e}, {0x000f080830cf6bdb,0x0009bec8a6c60f87,0x0002f01aa4861d19,0x000bd523a0daa120,0x00000111675a25af}},
   {{0x000d6cf1afb20d91,0x000030671bc56d00,0x00085ea9b1369500,0x0001ac813ab0dc24,0x0000f2bed06aeef6}, {0x00082176d799e206,0x0006d271c2de850c,0x0004f591093415f3,0x000420fafb06e96c,0x000088a52e024e9e}},
   {{0x0005ba3e2a9a6db4,0x000d18f9268b3049,0x000b0f04f4601303,0x00036d7e3b0dad7e,0x0000ea4725084569}, {0x0008798d33fd3e7b,0x00093b4337088caf,0x000fd50ad1ccd8a8,0x0004deeeffe3e887,0x0000e240a571b29c}},
   {{0x000fd98ca0e7ebd0,0x000ae748616eec4f,0x0007baa99f586783,0x000c9ca5b00d8fc7,0x0000acada29b4f34}, {0x000d67d0fe723ac6,0x0004d9c36c1e36da,0x0004bea411d8e53a,0x0004e084dd342d1f,0x00004fd5e364bc9e}},
   {{0x0001f9057908805e,0x000c7ed480dd96f0,0x000fd2dd0b5b9ea3,0x000a26566c5dc23e,0x0000d2fe3064e9df}, {0x000e8926e9197e27,0x00093b502a5d4575,0x0001f213f11719c0,0x000456b64c7bece8,0x000041b9241c5f5c}},
   {{0x0007b6849a5f4f41,0x00028fc45b7d78ac,0x000f5f355f91d70a,0x0000d929b05544b0,0x00001f06bcefef93}, {0x000d25d038d05e1c,0x0004facc1d51db84,0x0008ee00b04838ee,0x000a1edda3ce869e,0x00003412058836ed}},
   {{0x000b91364d9c2f41,0x00039010a8ffae80,0x000359d417468bac,0x000acccfd2003737,0x0000a0f5ab825efe}, {0x000ad2f659d0ce0a,0x000ac785cff17c25,0x0002192c74011bcb,0x0000e7728b99127e,0x0000549d8e1b3ccb}},
   {{0x00088d8c85438b17,0x000d4c25cb278055,0x0004bfdf45680332,0x0005666cd1bc961a,0x000079ff428e06f6}, {0x000e998f059987ad,0x0001fc686de78bbe,0x0003cfdb2f6ce8cf,0x000a3628ad3c4a95,0x00001d426d9f205d}},
   {{0x000f13fc781a2419,0x000e475362a8b3c0,0x000a911843e89360,0x0007f43cd05863c8,0x0000bd0c9b87fa8a}, {0x0004d538a912a4b1,0x0008acf518fd97ee,0x00067e1e0de5e15f,0x0002565a055bf8c4,0x00000be4b4b2587e}},
   {{0x00014f2668621c9c,0x0000eb9c92c1d90c,0x000d47b3cd5518f5,0x000174ce6a0100d6,0x0000be980de26716}, {0x0003f10ddd83683c,0x000cd9cac73c500d,0x00083d5503b6cb35,0x00098693730c8b60,0x0000f1597689f0a1}},
   {{0x000cf5343ad73b3b,0x000f9f035a9484bf,0x000eeac691b528c1,0x00023f9294edf733,0x00006283e84317f3}, {0x000c9590a5f25b1e,0x00047844ee22c3fd,0x000dde4deefaf8aa,0x0003befe269ba5db,0x00003347161a5613}},
   {{0x00042198d9ea9f87,0x000b83fc1ab5c118,0x000f22cda090de5d,0x000893d04c37b10b,0x0000de20ec965618}, {0x000588eecdaecabd,0x000cb8342743754c,0x000a938ec6ca4b0e,0x000ccaa6f08bddf4,0x0000182de8a61493}},
   {{0x000c53ec8a4186a5,0x000b446d8e33d652,0x00037663cb3e878d,0x00048ab88453c05f,0x0000cd9daab04077}, {0x000197f586d5e720,0x0008c443ca59a1f5,0x00065242447500be,0x00067d78ef35b2e2,0x00009c5d26f6dd77}},
   {{0x000a79aa74d3f7b3,0x000d9f5ea4597175,0x000d1746d0428fd8,0x000278211cb97ca5,0x0000636393a171d1}, {0x000f95510350bf49,0x0008d0aae782cf2d,0x000688809b381743,0x0000061748c0e43e,0x00008021fc067a5a}},
   {{0x000a70c0e367a98a,0x00046f62b7c29076,0x000fe0343bea1bc1,0x00014e8645a68c30,0x0000caffa79099dc}, {0x0009964457bf9c43,0x000add2ead83f446,0x000c6f3eb0db6407,0x00056c38d56cadb2,0x0000b512e7423763}},
   {{0x0000e1ffce104080,0x00035a5e257de43b,0x00062e5b389ddc00,0x000161b0ae0d1203,0x00007f983c7b0519}, {0x0004d155d5231e7b,0x000c5b4f9513c2e9,0x000d0b0b5cff22ae,0x000cd5002588dd6a,0x0000967d1acc1d0d}},
   {{0x0006bc6cf777b6c0,0x000d4c6d19598dac,0x000f5cc850062bdb,0x00014f53da71b50e,0x00007012c7d4006f}, {0x000f962ac47800d1,0x000bb102ed754617,0x000b8c9d353365f2,0x0001c9a422efcb4a,0x000095cb26b44af3}},
   {{0x0006e2905f2c4ce9,0x000b0856966c3a92,0x000527015bd2bdec,0x000230cd16ab3a85,0x0000f81609ed486c}, {0x0006b2cda350002f,0x00000a1b7d36d8b9,0x0001d79bcbd05469,0x000e4dec90ebf5e7,0x0000241b6f9f8964}},
   {{0x00086432fe3cd4c0,0x000bb4bc633c7c83,0x000139f1fe0f33ac,0x000f49b4a9ecec3d,0x00005ce69cddc4a1}, {0x0001b16f5f98aaf9,0x0005df23e0efa19d,0x000cdfdd345bb71d,0x0000c9a3789fcd46,0x0000b8e29795ee04}},
   {{0x000b246ae0a6828c,0x0003b078d5aa9c69,0x000b4fbdbba533d2,0x00085bba2e42c07b,0x0000fb4879b30353}, {0x000d30b3281705b5,0x000bf04fe0818c3d,0x000604edf7e361c6,0x000e472b21649c3f,0x0000dbf6a40352ff}},
   {{0x0007c234b54d9bf9,0x0000a511c3d9c41b,0x000b2b7581374e68,0x000a958863bf16c1,0x00000e78507ae9e6}, {0x000f98d5d86f1749,0x0002f5e96fe4ab4b,0x000c5d344d74e0bd,0x000846fafde39fca,0x00000946dbd4d91b}},
   {{0x0002358fe1a838c8,0x0004e20ac9d8f5b4,0x000ce5a0b05aae6c,0x000d720e193bd8a1,0x0000f710571cdabf}, {0x000dd48182caaac9,0x0009740745cf8d8f,0x000b93e6d8c4aeef,0x000010e3c6c30af3,0x000091241f3a6f42}},
   {{0x0008eeae457a4773,0x000bbe6ddc05a015,0x000c41671d19857d,0x000d588326522418,0x0000ffdfc7e6c2c0}, {0x000525426ee7cda3,0x0009af02c3a83a3a,0x0003bbfc8341b086,0x0006917023bf4272,0x0000d15002a44452}},
},
{/* digit=31 [{1,2,3,..,}]*([2^217]*G)  */
   {{0x000324c85edfa308,0x000407d4f3da5ef7,0x000b50c862597655,0x00096bb52f5bc0dc,0x0000f6927b0c832a}, {0x000e1ba55f2f94c5,0x0008e44b45fad08e,0x000aa455d6a996f9,0x0001f79133cb8da8,0x0000d0721ecc58dc}},
   {{0x000a92079e5fb67e,0x000a90aa725e6ba7,0x000f5d837e1331fe,0x000e207080ccf57d,0x00004cae01e5ff72}, {0x0003ee60412a77db,0x000c2f449025d924,0x000ef5a3106ff7ca,0x0007a80e75f7cd23,0x0000c957822bddef}},
   {{0x000230cb0ce1c552,0x0004ebbfb6078cf7,0x00016363b5b534d0,0x000e82ce1ef1130e,0x00007e0aa7ad4999}, {0x000ac2d79362c410,0x000091bb6cb0ce1d,0x00023df2467920c9,0x000f281e648d6322,0x0000f7d9eefe32e8}},
   {{0x000f39afa8338349,0x0002163285626943,0x00070fc102295172,0x000e6cf1d63dd541,0x0000f5fa5903ecc2}, {0x0008725e77d9a3b0,0x000a6384ebe0b66c,0x00045e24a11235ce,0x0003b106a8c11858,0x0000137b286ebd09}},
   {{0x000e1ce44ace1509,0x0008b381e97cc589,0x000c5a4b8e0f8d3d,0x0009f8c9e99b1162,0x00000d262f88d0ec}, {0x00054c9283e13c98,0x00072edc7085fbc8,0x000dcbecb2d04fde,0x000a5e857d776547,0x0000dbdf5921a76f}},
   {{0x00006950de1e5786,0x000789f72bc6d015,0x00039eca52e1463e,0x000f2f9fa684411b,0x000073c8530dc037}, {0x000a600747f91da5,0x000179cb78e9d0d6,0x000b5cef5b08d43e,0x000fd5bfc0c64427,0x0000c1d160af60a2}},
   {{0x000ae5328c8e13bb,0x000402eddcd1f98c,0x000ce06ad375f10c,0x0001ef24eb8b7f5c,0x00004669f4630a2e}, {0x000f9d05bbd8699b,0x000937976d13d593,0x0007e28d35528a4c,0x0005768923e0951c,0x00009293790ef6bb}},
   {{0x0007d6ac42bd6d29,0x00082b1f96aedb56,0x00043b28e6df8646,0x00023f7efe5b1a48,0x000061bbb05f379b}, {0x000f5f070a6a26b8,0x000cb28e6e39b6ca,0x0005fc8d370686c0,0x000dc900da06cf89,0x000004d88113363f}},
   {{0x000877b207f16700,0x00084e615291be22,0x000a3c2bf9b0dd18,0x0006e8625ae8dc97,0x00008584ef7439b8}, {0x00090a5dcd898ffc,0x000f6058ee3dde71,0x00087b1c126286c3,0x000db47db0b2175f,0x0000c334771d02a6}},
   {{0x000e9542f770fb1d,0x000f7cd7535ed99d,0x00009cefc97c1c61,0x0004f803b6c4483f,0x0000725af162a63b}, {0x000d24fc01e20ecf,0x0003aae7121f0c95,0x00077b7ecdfd3749,0x0004ad8d6ddb72ec,0x0000e079d3bf353a}},
   {{0x000e70a2e6ac8d23,0x0002e06e5c053066,0x000e59b8c9c6b5a4,0x0009ae22d3c6f5ed,0x00000d6a5c42ccec}, {0x0007c224fc0a9ef0,0x000395c16cededec,0x000de0fde190ff08,0x000433be12ec8f94,0x0000d131ab8852d3}},
   {{0x000e07e857012919,0x0008894061a842ac,0x000f4a48594793ed,0x000f4ca0e83ed6d7,0x0000eec726a89eef}, {0x000ba590c9d8005a,0x00077e79b9d190ac,0x000506a1e5feca45,0x000fa6efbe54271d,0x000032b2c8ec439c}},
   {{0x000c17373dd0b4ea,0x0003a4a054c61671,0x0008b53f137a2821,0x000b9de1760a1b4e,0x00006c0422599f93}, {0x0004b34cf671e3ce,0x0001eda9b9941878,0x000ab384881bbecd,0x000c2c58831979b2,0x0000f54feb8d2e03}},
   {{0x0007ca7fb8088fa5,0x0006fddc96c5cf19,0x0007771760142724,0x00071d52d2550a30,0x000034698989d0cf}, {0x00037b83a2aaac68,0x0002daf38d9b6ce9,0x000bf2899e9f91dc,0x000c15a598ad83c8,0x0000e706aca35536}},
   {{0x0007495f688dc983,0x0006e24c4afc40dc,0x00018775c26490cd,0x000f4ab651ec841f,0x000093ea6c3e4fda}, {0x00033437f338e0d8,0x000ae053e7b51e1f,0x0009e14d539fb832,0x0006dfc6e702da61,0x000059cacd24deef}},
   {{0x0009ce74462007dd,0x00047cb5f5b763b9,0x0005edde7b8ab48a,0x000fd9cec673d2f5,0x00001567f755cfae}, {0x0001b6b0887bcec5,0x000e9178f3c24638,0x0006266cb694497c,0x0004130e6525e31e,0x0000931de26b97d6}},
   {{0x000df7c0e58d4939,0x000fc8b73f1287f8,0x000a0c34db1ae5ec,0x0001a03368f784de,0x0000bd0a121159a9}, {0x00088b7cc863c683,0x000e0d1f4d65b00d,0x000a855933a1cc11,0x000ee8ba38e0e70a,0x00007f13e98adc4a}},
   {{0x0008667bc947badd,0x000d5a36ee2e10d3,0x00077fcac738e07c,0x00070cf93470cdc5,0x0000ee1b616f7824}, {0x0005e672e793d12f,0x000df0f186da36a2,0x000e07af7d6aa6ca,0x000cd3574d0fd980,0x00007cdc47eaa8a5}},
   {{0x0006d9dab15247f0,0x0000493a537f28af,0x000a334e77c789c1,0x0002777ac9b11023,0x0000236ac0912c9c}, {0x000bd251d7a51446,0x000a913ec4eca7e5,0x000f0abca098b9c2,0x0000f8d639dacad3,0x000042da81b02396}},
   {{0x0005c054f7269b13,0x0007b287c3857d2e,0x000a46f21fcf3077,0x000a35e0edc84ff2,0x000054417577f43f}, {0x0007899fd703431a,0x000576dd587af132,0x000c8352da438d7a,0x00024dc5c34c57e9,0x0000728edabfcc5a}},
   {{0x0008abc42531689f,0x0007110963efaed7,0x00017d9b30a51a0e,0x00028a6776fa0ad7,0x0000356c23a6dd34}, {0x0003fff8d3a3dace,0x00095d94491f2990,0x0004a56a4409597f,0x0004616cd7a5ffbf,0x000050964756adab}},
   {{0x00051265c3427b0b,0x000c2282c9bda97b,0x0002c5c456401405,0x000aec8629f8d722,0x00001c02c1798d50}, {0x000ed75d9635bc92,0x00074e24552fbea2,0x000f1d066226790c,0x000c2e1c33f2a365,0x0000a43463e8dfcc}},
   {{0x000453adb4837611,0x000555d5672b8cc3,0x0003efc87e7cc608,0x000eaf177ed6cbde,0x00009f2f36879234}, {0x00043175c0b800bd,0x0008bb6da6e29aaf,0x0004ec75e1f1e7c8,0x0008c19cfb4715b9,0x0000590dd6015311}},
   {{0x0009da11f17a34c7,0x0008b35a145614e4,0x00050363b5420ab3,0x000b6e476372412f,0x0000b15d62433fab}, {0x00040b1e274e49c4,0x000456b1860aa0ef,0x000afe5a45cf5074,0x000e9a96583fbf66,0x00004240511347e3}},
   {{0x000434311b2d595d,0x00091ec8df579925,0x00073dd05f136749,0x0000296cb12c613e,0x0000248c0344dac1}, {0x0004f13a77739f5e,0x000a43d2af42cf15,0x000e4a1cfbf4288c,0x0008f2ca64c9b632,0x0000e8c07a9a8a20}},
   {{0x00049996fe8393f2,0x000fc91f3a32e10d,0x0002f63c80f809a3,0x000d3d41096d1c80,0x000089e146277750}, {0x000167e9889feea9,0x000250993909ed06,0x000508ac6d5c9c0e,0x000e82b6fca0d856,0x00001826047df1b8}},
   {{0x000877a9a4a27515,0x00027ae6fead4f2c,0x000aa194171bd007,0x000aa7e8df8dcc06,0x0000a074b4cb3bee}, {0x0005934c1cec8edc,0x000deabc03bdd6d6,0x0008a8415a6ecb49,0x0006dfeade91c2de,0x0000fb0efe029113}},
   {{0x00045ee23ab3495c,0x00074b77463d11af,0x0005d06f4a132df8,0x000435c923c15c81,0x00003ceb3f5cd61a}, {0x000291de88fb1da6,0x0003bda12179af52,0x000fef720ea05797,0x00084550d7218cd2,0x0000c0899c9ee1d8}},
   {{0x0007504752ddad71,0x000f91a68a979815,0x00058fb99d60bd74,0x0001e46047a3a9f6,0x0000f5d86d66f851}, {0x000bc424b5a6d88f,0x00022abefa7db8a4,0x000c9c51069eb2c3,0x000b42a5bf39e813,0x0000571960bc48aa}},
   {{0x000fbcf704e23c66,0x0001c8aaa65b7e8c,0x0005e3c83c71b7d2,0x0004ff4041b2bd24,0x00009b9883532185}, {0x00027a3963bfeec0,0x000ade7da7cb89d2,0x00068a9b199947aa,0x0003681d9ee9dbee,0x0000a08f003698ec}},
   {{0x000409478ef24870,0x000502cfec26e9ea,0x000dcf328c8d2d41,0x000937c52f9a6eb7,0x0000ed489e385b6a}, {0x000986bbef3366e9,0x00005dddddb89b94,0x000dddbe20de59c7,0x000a406fdb748cea,0x0000b9784bc1266e}},
   {{0x00055021a93507a4,0x00074d3c06cf142b,0x000ec3f40b4cd118,0x0003c29f70e76a91,0x000084e81ad8e755}, {0x00087b5272e9d6ec,0x000506ff514a830f,0x000192a8eea1c93e,0x000359a7cc2adcc4,0x000077e27e302f45}},
   {{0x000ab36d2b713c5b,0x00001f7b0cd39cdb,0x000af826b86274ea,0x000ea2c84680f309,0x0000fcc837abc72d}, {0x000fe9dd6529b73d,0x000793a88002a8bd,0x0001d45b9708aa22,0x000f559c7a9a54c9,0x0000f1a38bccd004}},
   {{0x0009a26b8bad853a,0x00029723eae72e8c,0x000ca28302d52cea,0x000410654d6d8156,0x00003317d153a8dc}, {0x00062fefd4ddedab,0x000a055d792ba086,0x000c6e944ed2a153,0x000cf2c035c16abf,0x00006bc5834b0171}},
   {{0x00052b383d102b6b,0x00065646b848e271,0x0006e6d37fe695a4,0x00015df5bb09d891,0x00004269d64bd170}, {0x00056a10a1d22850,0x000146d26d728d81,0x0005434a7feef6c5,0x000e319dac57c84c,0x0000282e5be59d39}},
   {{0x000f181721c486d5,0x00006c58824eedff,0x000570031301baf1,0x000e683136a6aa00,0x00005aaf78c6cddd}, {0x000937159c639522,0x00046bc25baf2682,0x000e52dc33a3bd27,0x0006c8ccdf8657b7,0x0000dd8c0881d78e}},
   {{0x0003274f5531461d,0x00008d95499b2055,0x00080f9d28b4a128,0x00075812c8763a1a,0x00001dbe32c1ddec}, {0x000210d30c34169a,0x0002d8baa533af12,0x00038f254ba74a95,0x000f5a9d133c6ea4,0x0000431531ac01be}},
   {{0x0005e22f669d7ec1,0x0004257fb5151529,0x000a3fdb3ca374f6,0x000da87a8406ffea,0x000006ae448ef3f2}, {0x0000a9033c8e9a1f,0x000181ad58858f9b,0x0000aed14234645e,0x000d454d0832241c,0x000010a7d3f6a942}},
   {{0x000deee40d5c9be3,0x000f8a84ed987c11,0x000d58dddb2bae7f,0x000fa363e97139aa,0x0000d8727966f6d1}, {0x000ca818569ff132,0x000b7a600f72483a,0x0006f2b868b89a5f,0x000c0b2cbc27c3c0,0x0000213071383ad9}},
   {{0x0008b1e48ac28403,0x0004bcba9477b535,0x000946b431831129,0x000819aa58f990a6,0x0000098baf9cab41}, {0x000c1584198da522,0x000bf46bfd1b66c4,0x00036a908ab4fc17,0x0008380f0a4c3cbf,0x0000ae9e34b78cf7}},
   {{0x000529e3fa11b1f7,0x0007274af2b4f411,0x00030793b21e4367,0x0000f30c20958ec2,0x000010ea88586e84}, {0x00021fcc5dc67cf9,0x0006f8405718fc0b,0x000e49eb708d5164,0x000a1f4955c21fcf,0x0000722a5d5e6dd4}},
   {{0x00050e2c861baa5c,0x000cd505ac3ec9ef,0x0007c063fc0c21a5,0x0009c0ef6b9a338b,0x00006370339ef477}, {0x00099c7638167c3f,0x0005895db30c22df,0x000854989fe6ffe7,0x000aa43b822d33a4,0x0000ef031de20563}},
   {{0x0009f82d57c667f8,0x000e4c0b76f116b0,0x000118aecc70312c,0x0001333f04a9e6c9,0x00002fcb419b409d}, {0x000b385ab45d44d1,0x0002517b83a31a8a,0x000e81b52fba0722,0x000affa05f50dd58,0x0000d8db55331ce5}},
   {{0x000b8d4e344a8732,0x000dde36d53e3097,0x00075e7507d8d116,0x0004ea4db22f5878,0x0000dc5e37363e14}, {0x00032e6e799eb95b,0x000eb899e6ecc05f,0x000ab23d5e9e5f4d,0x0000e60dc3bd681f,0x000072b8ab823af6}},
   {{0x0007ae02cecc84ab,0x0007cbdb871c8db2,0x000c46f58600016d,0x000d3892a44b13d7,0x0000891972873a77}, {0x000bbbddafd60884,0x00062bd20d39cfc6,0x000c410721a74014,0x000ea14c747abd98,0x0000c91e765fdf68}},
   {{0x000e5ca08819a786,0x0009695879217c95,0x000bbcc7dcf48b72,0x000148a91c7c5fde,0x0000f28740550e05}, {0x0005ac226cd44ecc,0x00060fea250ef83b,0x00006ebc588ae32a,0x000780aac5047a1d,0x00007e550b59434f}},
   {{0x0001cf25c727bd2e,0x00003cf915b061ab,0x0009d39202e4badb,0x000dfd3b4dadecf6,0x000061b1ca7d14c1}, {0x00079ccbd6bd51f4,0x00014045ec3090b4,0x000ef0e628024e40,0x000bc08ab29ca325,0x0000f2e941689e4e}},
   {{0x00040ec0ccced589,0x000b7da44f9845eb,0x0001812c625cd4b9,0x000650b3e0645887,0x00009f80d55a6cef}, {0x00040c9ce6dc1532,0x0007b86655215713,0x00007014d138d511,0x000b918cdb45bc4e,0x0000f34bb38a4b60}},
   {{0x0004fd22ae8921e6,0x000e292ba1e2f44a,0x000c180b2b039288,0x000c873da50174b1,0x0000b70ab667693d}, {0x000abc9e70574810,0x000f9c80dc417e9b,0x0002946824581dde,0x0006e50c890da951,0x0000b5629d33f473}},
   {{0x000c79eb06f5b41e,0x000d6e2434692340,0x0005a71a9a42e84c,0x000fb619a2013504,0x0000fbfb416b27b6}, {0x000ea239d33cd6f3,0x00087a6c0af825eb,0x000ce6f969caedb8,0x00015a23dc7e9ad9,0x0000897f9fd81e0b}},
   {{0x000b1f88e5d788e9,0x000851d490eef51c,0x00058cb3c1aec7ba,0x000d30965991e0cc,0x0000f306e8d2fc3a}, {0x000006e5040a0acd,0x00032b476f2e5fed,0x000ea7a23ca9d504,0x000b62d19c06e8be,0x00002865801dedab}},
   {{0x000293f6967469a8,0x00090d8a8ed8db92,0x000c771222894d83,0x00026a07c9e406bb,0x0000671c6f1aea3a}, {0x000f8d6d7de9853b,0x000601f2bcc7e42d,0x0009d50cf2e3ce34,0x00098f2a601dfc89,0x0000fc913dfab1b5}},
   {{0x000909fe61f7908e,0x000ebbbc7b2981c4,0x00004b338192e304,0x000d60e3ed8738c1,0x0000dbe9e48583f5}, {0x000e9be2db30660f,0x000ed0eb7d8e0c06,0x0002e096eda3e613,0x000246e8fa3e9732,0x0000ebd91e9c336e}},
   {{0x000ccc4df655a499,0x000bceb202108f13,0x00056b6eaa9e00df,0x000946f4631d0fc6,0x00003a058ce68c0d}, {0x000904a67bd3448e,0x000a1394fd5c6846,0x000225f524a3d4e1,0x000e99e102c1a5db,0x00003455bbbdc4f5}},
   {{0x000985b4b9ad1ce1,0x00064bb7f7936b36,0x000b1a416a981853,0x000ee75c25e1d048,0x0000381dd534c81b}, {0x0000d617a4a76209,0x0005a9b8944cd2a3,0x00097c33ac841292,0x0004e6ac1c6fbe7a,0x000041e541e23866}},
   {{0x00099e84a34f239b,0x000c090402d54174,0x0003aa83215fdb83,0x000db1075f46bf43,0x000061e15b013215}, {0x00059d4a127f89a5,0x000bb7e816daaabe,0x00018b6925d541e0,0x0000265aba0659a6,0x0000532773367266}},
   {{0x000a0fc95f57552b,0x000fbcacb0c9af53,0x00021be013294764,0x000145753ff58dc8,0x00000309532506f1}, {0x000bdf505c2e54da,0x000c86e8dd2259bb,0x0007e1e53158f27a,0x00050d2c5b7ffb39,0x0000e03f65c1fc1e}},
   {{0x0004ebd9c95f0f98,0x0001a4640771a978,0x0005561c45ed9deb,0x0007ddb1244af703,0x00007332f3afee85}, {0x0006e9e2b9e0d888,0x0003d6a0604909e1,0x000592f4852d910f,0x000677d07ed477a9,0x00005cb917ba365d}},
   {{0x0001c934c8998d19,0x0000e30ea58ff851,0x000029db02186a3f,0x000759c0189626b2,0x0000137a6d992ceb}, {0x0007f37748bc82c0,0x000180469f8c2fe1,0x000891aa287c2e93,0x000d8d850f71cdbf,0x0000ca1b89b75ec3}},
   {{0x00043aa5e1cd3cd7,0x00082a887c28516c,0x000ea1f9f8939780,0x0008f69059c699dd,0x0000737d6fafe686}, {0x000746a60f1524b3,0x00058a052aa76d93,0x000923ea536985e5,0x000a1111b1d322ed,0x0000429759f55852}},
   {{0x0006ec3092e9f414,0x000622256bbdbeca,0x000ad487d3a238c6,0x000d93982958ea70,0x0000ac8aaf9a5610}, {0x00001b15e4ccab05,0x00024de14bfb3fa1,0x00031899d9bf430f,0x00017d510f5cc665,0x000090005fc3a8ce}},
   {{0x000912f24544cb60,0x000ad79ac2e3c437,0x00058a2129987b71,0x00060613e3d9ddc0,0x00000075aacd2de9}, {0x000508b6cac83696,0x0007954f6c8980ab,0x000c532a487842be,0x000bc847ad663d6b,0x00007813de7d8a91}},
   {{0x00061cec3427239e,0x000fe56934d95dcb,0x0001915915f3c7ce,0x000da6e079e0fbe3,0x000040896be901aa}, {0x00067910492d25f2,0x0009c74082768d46,0x00087aacc8aeb30c,0x0003d4c943749592,0x00003d4708d99fe0}},
   {{0x0009cf2d0c051995,0x0002aae784548cda,0x00072a182502fbc2,0x00037270bda9dff5,0x0000f9b71b8b158b}, {0x0003a592b82dd077,0x00052523032ee0f3,0x000505a327630273,0x00009f0fe1a721c4,0x0000b6e3e8367964}},
},
{/* digit=32 [{1,2,3,..,}]*([2^224]*G)  */
   {{0x0007bc035d0b34a2,0x000b6327c0a7e341,0x0000362d1440b386,0x0009436fb7262dac,0x0000c41114d00cdf}, {0x000cef1ad95a0b12,0x000847d543622ba5,0x000e486c9c09b37a,0x00029706d6cdd201,0x00000477abf62ff9}},
   {{0x000dcb3292a92874,0x000637b092c7a004,0x0006c0605ddc15cf,0x0007afc83a846480,0x0000a68df707db99}, {0x0004e4505bf7dd0a,0x0008eccf7f8c9c13,0x000b5f8afa4e63d3,0x0001cc06e6517f41,0x0000a8b93434d7bc}},
   {{0x00035b51e706ad97,0x000453a9ebdf126f,0x000608d90b99cebb,0x000858375389afbf,0x00006113c5036c89}, {0x0008eb097e2b5aa3,0x000c33b9130480de,0x000cc066c7e1022c,0x0009000bdab6056c,0x00003cbb144e2edf}},
   {{0x00064717af715d2e,0x0003f0134a96c417,0x0001ec956e2f7f59,0x0003034c1873efa4,0x00004e7b4f757821}, {0x000ff9788d5374a6,0x000320823d5be5c8,0x000ee8fe22b915e6,0x0006518a6bc755b2,0x0000657624d47112}},
   {{0x000f101dace5aca9,0x000181a6a267157a,0x0009c8609c4fdbcf,0x000a654addf340c4,0x00007e49f5379604}, {0x000e790937e2ad5c,0x0007726e17f19be8,0x000bbc0dc846e250,0x0006d57f38007a0b,0x0000f036040711e1}},
   {{0x00000e07442f1d58,0x0000e6e0e3abd6f8,0x000c64047475607d,0x00083d02807f16b7,0x0000858e1e427498}, {0x000120b8231ee10a,0x000ac38a1ece5859,0x000aa73a41b80e7e,0x0003ac2b72525ac6,0x00007cdea3e24442}},
   {{0x000c007f8ae7c38d,0x000b6d7401925ed0,0x000e36db36db07a5,0x000045ee5e9c2a5f,0x00005b9d57b46e95}, {0x00032e78eba20f2f,0x000e81b9a35254ac,0x00098a658ef11ca8,0x000666405e373eff,0x0000fe5a101723eb}},
   {{0x0007b11e51732d26,0x0007c538fc0e5747,0x00039eec5dfd6eb2,0x000c56fc43b0cc3b,0x0000af127792b36c}, {0x000852d06c425aef,0x000b6c221b9b70b0,0x000826d9c6df92f8,0x0009c27c8d4f9ece,0x000059aba7ca4935}},
   {{0x000d8d5da64309d0,0x000691b307045c8e,0x0009b580861a6de5,0x0008a7d6b52f6a2f,0x0000eee419498c95}, {0x0009aab771e4caa3,0x000d48bc21becddd,0x000b504f583965df,0x000290d2affce3b3,0x00000847a21861c8}},
   {{0x0002cf152bfda056,0x00090197b98cd2eb,0x000a1726fe0e4c4e,0x000e3cbd35076cf8,0x0000c06085b8db11}, {0x000c4d74463ba14f,0x00021030238c15c0,0x00027536d9d292f8,0x000c1d2311ee8b37,0x0000eea86f0aeaed}},
   {{0x0008cd366131e2e7,0x000f10fe2682b9d1,0x000160289f31d974,0x00079946e49e0fe4,0x0000c48ec0b78e92}, {0x00011d8d1989aa7f,0x0009fbf926f98181,0x00045474ab34fa0a,0x000755eb5fe2f5a2,0x000080a6ebc2c7ca}},
   {{0x0006054afa05dd8e,0x00011caf119ea7f9,0x00064bb5926dfcf2,0x0002b8020ef2e305,0x0000f4dca5141cb0}, {0x000838a65d306723,0x0004cd657e86cda7,0x000d595c88b08d53,0x0008361c5b439546,0x00009b58725725cb}},
   {{0x00010593de9abe37,0x00012cdc03be8ea6,0x000edce8c4043488,0x0004a12b261245cf,0x00008c318b53f523}, {0x000cf16fde24c99d,0x0004d2c2ff5d510b,0x000960fb42a77cb7,0x00042acc895c2b27,0x000030ce97680eda}},
   {{0x00053931a62cc262,0x000630c0e052fda8,0x000c633f323c69b9,0x000d488227df15bf,0x0000ac788483bae7}, {0x00078f9187d073d8,0x0009167f807d4878,0x0006e6d8f6c2be91,0x000a42f65861d833,0x00008b8974d4e528}},
   {{0x0001177ff57d0517,0x00078b6a19610952,0x000d76ad42ff3803,0x000c178c0aba74a3,0x0000c76480395a7e}, {0x000d75f48879bc89,0x000fc8ce6bc17532,0x000896c16ea7eacb,0x000fed382176b48e,0x0000a30e0b2bc750}},
   {{0x0002c2e421d3aa42,0x000cc84fa840c37e,0x00054e41cf926407,0x000643f8abc03d14,0x00006605ecd5f7af}, {0x00041a6d6a5eabf5,0x0003d16b668e2423,0x0000101021edb84f,0x000d8c8836edb804,0x0000b337ce7e45e1}},
   {{0x0005c77c055dc14a,0x0004e1d89cdfd207,0x000fdcbaf2a0ffa2,0x000866ece815ea6f,0x000034288799b648}, {0x00099cf884655fb3,0x0006064d3e412776,0x0001e1cb7fa5b5bd,0x000d66d1f680c644,0x0000fd61e66e70a7}},
   {{0x000a2dccc78cf662,0x00044fdbff77666b,0x0008d4668b301817,0x000a2a6d4dd0db16,0x000059455d03dab3}, {0x00064c5cde3acec5,0x0004c3adb276f585,0x000303f657714192,0x000f7b027d725d8a,0x00005deb6ca36f38}},
   {{0x000b657b1fa70fbf,0x000ee8073a00fd5b,0x000a02500fa07f50,0x00040d072e3aa7bc,0x000068f895e89757}, {0x00020605cae2a6aa,0x0007628748423011,0x000e47bd301bd721,0x0004f59d4238917c,0x000066663c218954}},
   {{0x00005d73272d8383,0x0009ca6295c5864d,0x0002fda32e22924f,0x0005445189593f6c,0x000030d7189e184b}, {0x000a62cbde1f7140,0x0004e5cb1a6379ef,0x0001c833235771c9,0x0008542f4826b864,0x00000a894fbc8cee}},
   {{0x000a39b36194d408,0x0004f7612601b4b9,0x000cf2f58e857a7c,0x00048774209dd24e,0x00002b9e66dda033}, {0x0006934e4e8b9dd4,0x000d642377d7c1e3,0x0003ae43bd2372c9,0x000f6f11dc94c70e,0x0000c57761e44474}},
   {{0x000cd0a1058a3184,0x000538053a9adcda,0x000c68de2369cf3f,0x000d9f86c3de5031,0x0000653a5767c4b6}, {0x000dd5aaa4e5c975,0x000167ab3c741688,0x00065c2835be80aa,0x00009120cefe7cbc,0x00007f95f1356867}},
   {{0x00014e24415503b6,0x0005ecbb17e9a391,0x000dec966c08ff7c,0x000f62beff674dd7,0x0000d4690afb3376}, {0x000e32eea74237b0,0x000ecd57508eff6f,0x000cc40fec436d17,0x000b4415aa28e1ed,0x0000d769c04581bb}},
   {{0x000b6de34eaacda9,0x00079ba0f1dec240,0x000438e55d9e116e,0x0002d73be45ec779,0x00001787c9e26f75}, {0x000532bf129ac2fd,0x00078a36e22c897f,0x0009fb8f3d307b7c,0x000b27c194067574,0x000014f95d0e57fd}},
   {{0x000d0296ae550430,0x000f44a87de1fe51,0x000e4fee28931e98,0x000d92e57f1cc609,0x0000d063b674e072}, {0x00098b9ed0e4316a,0x000a906aca4670a9,0x000da97c7e74a736,0x000d934cf0fbf24f,0x000040f65cbde178}},
   {{0x000360416df4285e,0x000af0c56ae21625,0x000c5cfc3b0c9bab,0x00005593032b19cf,0x0000497e5c3e9752}, {0x0006bb4164bda960,0x0009a0b74da11209,0x0003826ba1ee4241,0x0006608fc3624340,0x0000c8f0069dc09e}},
   {{0x000e981c27253c98,0x000b12b36a458667,0x000b7bb4605a6aef,0x00027b262c4b369c,0x0000394f37591f70}, {0x000c79c5f109d0fe,0x00057b8cc60a747b,0x000f09e68cad88a7,0x000eaba0c5a66b58,0x0000753d452d6127}},
   {{0x00074a15b0ec6f5e,0x00037289b2b8c44b,0x000d6fc7347989fe,0x0000aa945f848458,0x0000c362a70d61c7}, {0x00098a7b3a8ad418,0x000ffb63db51070c,0x0004c35f473a20fb,0x000dca6d2c2173f4,0x0000a56149e1acc9}},
   {{0x00078819ac6e0f4f,0x000eb413b5ed98f1,0x00000b0fd360fdea,0x0002d21625b8f4a3,0x00001f4d76b4b322}, {0x0005109587f76b89,0x000c9317fdb59d6f,0x00068b0958b4ee08,0x0009b8f8089bb78c,0x00005570e9ae808d}},
   {{0x000c36f35d33ae72,0x000330bb5a94a395,0x000afe84b200ea12,0x00076a00c789bd0b,0x000043ef52d29192}, {0x000c577e23ae233d,0x000ed460d1ec3934,0x000fa76a4b93807a,0x000490e72a53b1f8,0x00008914cb193ca4}},
   {{0x00084943fb42622f,0x000b600907d52e12,0x00095ec633b2700a,0x000fbd0370fb091a,0x00008f30be321b6d}, {0x000f8d269e55f156,0x00016c1323e9f2b2,0x000e5eef61fead85,0x00007e9a366010d9,0x00004d487b143161}},
   {{0x0006b86d23ddc820,0x000c7e0143f04c07,0x0007af2c503fd344,0x000a4fa95362ff31,0x0000add3db7e18b7}, {0x0003e3f8260e01bc,0x000494a1cc919c67,0x000f2e433fbeb49e,0x0001ead1351bf292,0x0000755e7ed45114}},
   {{0x0005139296077453,0x0000726f2b28c9a9,0x000c6f9dd0ca0742,0x000fc09b2790e74b,0x000045bbb58ddcaf}, {0x000a38cbe0f27a29,0x000bd41fcb56c65e,0x000e2c75767c24d7,0x000c489c25f0a7a9,0x00003f5cdb0a6f16}},
   {{0x000a9d7c5ee30a1e,0x0004d909b7292ca5,0x000deff48d159363,0x0000c2a04ce9f3da,0x0000c464752907c3}, {0x0005ff39e49af6a5,0x000a1f3d01bc89d6,0x000ced843f2d6238,0x000fd7c095561e0b,0x00001789e1318a13}},
   {{0x000f929763231dff,0x000cf7cbddefd633,0x000265da846df9f7,0x0006d111c889c0cb,0x0000ce1ad119f433}, {0x0000df6fc6a0a7e8,0x0007eda425dc8d11,0x00034aabedd431b9,0x0007fc4dc4aeab18,0x00004deb1250439b}},
   {{0x000f1693c2a59987,0x00040947190d8796,0x0005970149b9247b,0x0006ede5b9d9a511,0x0000e9dd70deb156}, {0x00078f7cbcd5e64a,0x0006fbd4c03294ad,0x000c222ae0359ac1,0x0008119b11baaf7c,0x00006a6e2855a78e}},
   {{0x000053f24cea1a04,0x0009f36214918392,0x000399ee9c97bce4,0x000ad13eb1db3435,0x000073f78f02ce81}, {0x0002fe0f63d3d0d4,0x00006fab62fc41d7,0x000158383e620b88,0x000f6c52096bc993,0x00001a21357cf896}},
   {{0x000e2fac7dcfcabd,0x000dc546e0071b5e,0x000b02e07650acfd,0x00003cf081b749b1,0x0000a9e41a1c9eca}, {0x000a727175a54ab2,0x0000ca5d8d10013b,0x000fd96a9ca0cd19,0x00094065ea52c095,0x0000c591b9fdc5c3}},
   {{0x000d4e42bad4d5f9,0x00006ef0059b6fb4,0x000122294fa4c359,0x0001d0da10218af5,0x0000a78a81b38575}, {0x0000579a98e84e7f,0x000f5997e5b504f2,0x00021e1e4fe1242b,0x00039cf77a273bca,0x0000cc8b1f084119}},
   {{0x000a30292d0487a1,0x000c194b91fee20e,0x0006b0e8f1442dbe,0x0003180f7a4afebb,0x0000700ef747889c}, {0x000ffc370f1fc62b,0x0005b9c79ccaf5bb,0x000f6340d3b31d4b,0x00010a38bc2aaba7,0x00000b08ab55725e}},
   {{0x0005701ae3400501,0x00060cf0c56944f0,0x000e19a51ba4b301,0x00052e4aa29f83fb,0x0000b9ed428c71d7}, {0x000e54eeb4819f5f,0x000cae18b75b1666,0x000e27b0b616cdfe,0x000e4c212ed5be3e,0x0000bf2831a34c7d}},
   {{0x000ec85e0e60d843,0x000fedb7ee78d685,0x0003c4d6e68037e2,0x000a6a2b65bdcd00,0x00003e7363ac3e29}, {0x0003a6108d0756c9,0x000b9faf134b995b,0x000337823d727f85,0x0008b46ac6edf71d,0x00009b9aa509439b}},
   {{0x000b104e2b4e075d,0x0004737c4926722e,0x000a9b82d4998729,0x0006f4e1e4c0e446,0x00000cb319827a00}, {0x0000f7dd7808c569,0x000ec1f89772f3de,0x000bd31aab5c54d8,0x000caac00a114aad,0x0000afaaaa6b95f6}},
   {{0x0005e2104cf667af,0x000aad3935d79470,0x00009267cfc2a811,0x00053a660b02806d,0x000019ed11ae780e}, {0x0007c09067b6269c,0x00029caef599f022,0x000efeebc967b853,0x000ae5555b924368,0x0000d6d34f68497b}},
   {{0x000d5d36cceb3707,0x0009378d7bf91dd8,0x000b67a622aeac57,0x000f66ed65017d70,0x00000c8e44f87c53}, {0x000095086a34d092,0x0006c7134907d1fc,0x000fdd315e0fca25,0x0009adc24fa29c80,0x0000c4acd03f8749}},
   {{0x00075173b5a9ba6e,0x000532e51a51baaf,0x000154897b9cbe1f,0x000c9ff88edae35e,0x00004309c3d57b66}, {0x0005805f67f37466,0x000a436401fff555,0x000499a5385fc37b,0x00055b7f86e2cad9,0x0000270b2a44cbc9}},
   {{0x00064f5974ad33b0,0x0007fe7b2df1afae,0x000b03f7304d8597,0x00040a2a3db3ff4a,0x0000b87878a87027}, {0x0003f015a0617323,0x000e732a19016d26,0x000155018c25430c,0x00078ec7ebab3ddb,0x0000a86f69393a9b}},
   {{0x000e368da9f3804c,0x000de164349c349a,0x00062baa5470f07f,0x000df3152f4cc985,0x000074a9e86eb290}, {0x000aa3543471a24c,0x000df8194511d3a1,0x000dcd44d239446b,0x00082cfec2dd0081,0x0000a3d7f10842ac}},
   {{0x000b085fdaf45207,0x000fd549daf21f3d,0x000ad5c42bb6d3e7,0x00051185969d8a19,0x0000052b13e4bfd1}, {0x0000d1b682b90604,0x00036c34452c1189,0x0003805b4a71d388,0x00023e6438055b78,0x000032412778725b}},
   {{0x000f96e4901bbed5,0x0000a432a2bbf20c,0x000a9cd7d6419c71,0x00024907a0fbb9df,0x000089111e450daa}, {0x0009a337b60554e1,0x0007dde283a41980,0x0003bfd35ea5f888,0x000a531d71380250,0x000051bb0af685d2}},
   {{0x0008f7443b30ca81,0x000ac993458340b0,0x0001110ade10b5bb,0x0006c5d8a546d6b5,0x0000dd50e6638e0b}, {0x0009d54cff2b821f,0x000c57281760292e,0x00024d6e33882555,0x000da0234838f837,0x00002c679e112ddc}},
   {{0x00088156d2a57687,0x0001ac1e7e2d40ee,0x0004ff4437f227bd,0x00054ad87ba134d0,0x00006e2ff3e3614e}, {0x0008d6fa3177ec75,0x0000d328fff536b8,0x000ba158ebf731d5,0x000188258caea249,0x0000ab8ff4c52938}},
   {{0x000605635edc56d2,0x00095e940d7933e1,0x000866dcb5a69d34,0x000def4c4fd00103,0x00000a38f576893c}, {0x000e790fac3a15b2,0x000e5a4f8e6bfbf3,0x0003aca866ed7ea2,0x0003f78663eb4fbc,0x00002061ea5280d5}},
   {{0x000dfe6f546783f8,0x0009da0a641e2480,0x000de8965d38bc6d,0x0005cf7b093cd12e,0x00009654db52cb45}, {0x000bf9a26e1adee2,0x0004173294d4413c,0x0008083fe291f376,0x000340e079725764,0x00005f504d3408cc}},
   {{0x0008e5ec3a0ee43c,0x0009a79898ff635a,0x000c63d5670aaebc,0x000cffdee9f5475d,0x0000e987967bfb34}, {0x0006b195e26310aa,0x0003982a8ca8f9f8,0x000352fe49e43548,0x000570853bcb81c2,0x00004eac8b0e474b}},
   {{0x0007512c1ad8cf84,0x000e59e0b697c1b9,0x000e85df0193b4e9,0x000afd539d271601,0x0000fb265b40d44e}, {0x0007dcde51e1ae29,0x000653d8b096321e,0x0006049988e3a8ca,0x000aa6fde46cb052,0x00001099ad8c9072}},
   {{0x000f91c93aa96b8d,0x000aafca2e132617,0x0003287230fc8716,0x000521d7106f5e95,0x00001c9c40bf62e6}, {0x000fe8642b7c094a,0x000c7543c021b9ba,0x000befd5d1873439,0x000aff41baa5de5c,0x0000363fc5ef21e8}},
   {{0x000320df862eaacc,0x000262c647dcefe6,0x00046d42814419c6,0x000f8e4e06707c4e,0x0000b6c83500a178}, {0x0003a45d30f917c7,0x00092879afee0f99,0x000500063d4c4b04,0x00060546142a1e70,0x0000c9b41c415d9d}},
   {{0x000fc2f2f8ba2c73,0x000f4c67aa28bc00,0x0007869720966eb2,0x000b9fe3f7b5165a,0x0000bfb7557ba2fb}, {0x0004f235a2b96204,0x00072faf46be131c,0x000172323bff3ed2,0x0002465b4473d17e,0x000021e8878739f6}},
   {{0x000587a25a416322,0x0004835b6c930fa8,0x000ebb8dbc081412,0x00029c0b18a9f559,0x000064e335796edb}, {0x0005ccdc87c51e26,0x000af01e6214af24,0x0003882ce16b3015,0x000e045b31c5600a,0x0000961bb955ec11}},
   {{0x0005b8deff7a3a0d,0x0007e1df73263b82,0x000604a1fbec3373,0x00049898ad747c99,0x0000154c9356a3bd}, {0x000506f1cc7a906c,0x0001ac560e8fac33,0x0003e394473bb539,0x000433a428fcbe26,0x000011828d5dc387}},
   {{0x0004be13e4b12ff9,0x00089d88667c3cd0,0x0008120cfc3aad9f,0x000532352ddcf824,0x000085a892eba389}, {0x000b21b3bb85fa06,0x00002dfc6269fbb4,0x000e2aceaf95375e,0x000d1f9b4fb06c7e,0x0000785426e909c4}},
   {{0x00017c8d8ceb147d,0x000de70a5554659b,0x0006bc6349b649ee,0x00032e9b7fa0b5ac,0x000099fe2c7ed6e7}, {0x000e7628d3abba2e,0x0006c797b79930e6,0x00096464d18fee6e,0x000e117c9d360dc6,0x00003baeb4907bfd}},
   {{0x000db47f23206d55,0x000fcd2601522bf5,0x0008ff89a2f6d341,0x000457c7b876533f,0x0000157c30c878fa}, {0x000c5c52d4fb936f,0x000bf6518cdc7517,0x000847a64ef22f7a,0x000a88eeb483e6bf,0x0000508455982e0f}},
},
{/* digit=33 [{1,2,3,..,}]*([2^231]*G)  */
   {{0x00059d8df7304d44,0x000bbf210e8eab96,0x0003fbd60b71bcf1,0x0004de69a2438bd7,0x0000595cd1f9d11b}, {0x000329a4835859dc,0x000cbdbb6e569c0d,0x000928a4e4a0f0d2,0x00015406038e5edf,0x000094296224f5ad}},
   {{0x0003462f23f2d925,0x000d10b940789121,0x0006cde206cab71b,0x0004bc1bdd0a6317,0x00004c9b20d3e4d5}, {0x000d8aa9f2ac02f8,0x0006a06eedb03cd2,0x00008643403f8e61,0x000db947f68e1693,0x000031469c612dd3}},
   {{0x000df248f9813540,0x000c3588a2598521,0x000a0992c587e23e,0x000407cbedf281d7,0x00006930a5538961}, {0x0000debbe5bbe21a,0x00048491817f0932,0x000065160a7ffa5b,0x0002a946c8b4d909,0x0000c4f39939ff6d}},
   {{0x000a1583ae9c1bde,0x0008037ce2407aa7,0x000ab38b4e0af6d9,0x0008ca054342d928,0x00008b75007ea1c9}, {0x00086afe02358f2b,0x00063a921228efce,0x0001c67fc31b8b85,0x000d58552a19120a,0x00004069ea593aea}},
   {{0x000d6e27fa03cb3d,0x000a3fdd7d883232,0x000cbfc5ddb938e5,0x00080e34c1d2cd2c,0x00002f45c137f3a5}, {0x00020b57883e6142,0x00089e7c5f265926,0x00067e1e35fd27e6,0x000aaef39e45a915,0x0000cc71d2d64d8a}},
   {{0x00090cde36d07576,0x000179a293824a90,0x000b48ddff722d7b,0x000f439b7fb04c04,0x000028ad2a84be16}, {0x000bfb520226040e,0x00007104b6c4cd3f,0x00003c1886c34ecb,0x000aaf50c0754ec9,0x0000c336b090d23c}},
   {{0x00062a21e206ee56,0x00002c49a633473d,0x000f6b2c3f1e2748,0x0006ea27ab956ce9,0x00001830b48c2b60}, {0x0006846e78e815f7,0x000edc02082a67cd,0x0002ec365fe40139,0x0006aae2bbbfcb95,0x00004c11642db983}},
   {{0x000439e558df0194,0x000a6c712b279f51,0x000185a24230da4b,0x000f50118919e355,0x0000dcefcddc4b78}, {0x0000fb2a47d4c5ab,0x000f030e009ea7d9,0x000eed27355ac9ab,0x000faf4d2fc35974,0x000072d824d8bea8}},
   {{0x0001a744513e2cae,0x000158240b2cce72,0x000baa4500b41861,0x000c2425199968d5,0x0000b1757ee0b0e8}, {0x0003e283dfac6d55,0x000df8a237f56ebc,0x000f61499b2431e2,0x00036adacb5e2352,0x0000558a2a8306c9}},
   {{0x000f923cbb13d1b0,0x00025bfb9bfed213,0x0001144a998799f4,0x0005ee1ae8ddc970,0x0000b8b3bb64c559}, {0x000ef2e3ecebb211,0x000b2671f9a70ea9,0x0006f1d1f17cb6c4,0x00027637ef464f72,0x000071b94847943a}},
   {{0x000ae2d7ef0329c3,0x000261c4402a51a4,0x000d45bbc0850922,0x00085134a61d35af,0x00008f096fe6035a}, {0x0008b74a1dec0270,0x00074fc7dcbac746,0x000a06353e8cf10e,0x000d66ea35ff40f4,0x0000b4c0dfa8b77d}},
   {{0x0008552de7e5c194,0x000981c0256c779b,0x000d4743dfab2860,0x00093b24f58eeeab,0x0000e8ef838bb6cc}, {0x0000d264cb1bf3d1,0x000963dedf61ee65,0x000b70ced4c1f9d0,0x000e1e9ef7c9d7bf,0x0000ec0507e2641d}},
   {{0x0005cc7cde450794,0x000a116ac9e4cd7e,0x00070315cde173c9,0x0008fb117a8494c1,0x000038fd905d1d8e}, {0x000c506c7d9630b4,0x000bb47d4d755145,0x0009a80e86457a87,0x000abe931646bf0d,0x000053add2c0ef3a}},
   {{0x0001109a607419d5,0x00026b6bca80c994,0x000c431f3faa71e6,0x000479e4158c1307,0x000094abebce92bc}, {0x000a691eb78399f1,0x00052f42cba46dfe,0x0007c04f048aafb3,0x00091addcd65af07,0x0000a29a366f8844}},
   {{0x00040e51c21f2bf8,0x000c25057aee023a,0x000ab072ef99a513,0x000bcf23fe7e25bc,0x0000568d2e1c0e32}, {0x00094ebd3f69d9f8,0x000287affab19045,0x000e330f4181a973,0x000fc164d68d76b6,0x00007a6dafc475a7}},
   {{0x000b2b5ef7d92893,0x0007e97f015a549d,0x0000493b62480d4a,0x00033131d5590bc4,0x0000a55b52e9f780}, {0x0008115309eadb09,0x000a02e5c62540eb,0x0006a3d5adea7de5,0x000d60d4d631f0cc,0x0000d5e9d7d23e8d}},
   {{0x000bef5206d3ffce,0x00029d808bd4f297,0x0004cf5ba23d5e03,0x000a896a4f6912d2,0x00004d8163be9cda}, {0x000e9efd3082e8e5,0x000bb192f3600e0d,0x0008eee0a4fe1246,0x00091acf9001504b,0x0000219da8241da3}},
   {{0x000a5c1f7ea25aaa,0x000f5bb07d5f7bf6,0x000e78671d165e6b,0x0002194353936189,0x00003fcac89cbac4}, {0x0006fd4f0baa8abc,0x000122c1c2e5dfab,0x000d858495a4adac,0x000180acd75e3140,0x0000e263fead9b39}},
   {{0x00003d307032c722,0x000e590968c8cb68,0x000e978f07f40d5c,0x00051c86de86bddc,0x00005547c4f568f7}, {0x00085fd65fb2a9eb,0x000e6eb9179cb1e6,0x000504442ce69336,0x00006b015d1c2712,0x00007df465d6911a}},
   {{0x00004a3315980cd1,0x0002ea3bebf7b8d8,0x00053c504693bc49,0x0004a22578aeee22,0x000058de498dd247}, {0x000f5c7cfda83685,0x000328d7177e1331,0x000c1e46ed2d7bbb,0x000be88f61133af3,0x0000836ce7e230e7}},
   {{0x0004f1994f834cbc,0x0003829ed7828308,0x000e58243d35653d,0x00022ce542f16f59,0x00002b52f65c470a}, {0x000221b18f23d962,0x000c1f5252b4e3b6,0x000d61402cb05aba,0x0003e4aa00938b87,0x0000f186cdd61193}},
   {{0x000ece59a29a5c5b,0x00068b6c8402e042,0x000d92684b19b3c0,0x000372197667c719,0x000056246239bc66}, {0x0006e653c04fa024,0x000c4eaa39aa0cb9,0x000a1633f83a7176,0x000f72e033561dea,0x00005a9d0868533d}},
   {{0x0002c1d3dc090bc7,0x000f3a59c167e054,0x000e7fc4d82c996e,0x000b7973f735e80e,0x0000b179393ec35d}, {0x0009e25f8c5dbfdc,0x000d5f327b04b641,0x0008dfca84d9d7a1,0x000669d79f6f9b29,0x00007c5dff24de93}},
   {{0x000588d04c82bdd5,0x0004a8319dfd1b7a,0x000eb95806800553,0x000a818e8a55b5d8,0x0000ea886dadd5bc}, {0x0000a01252a0b4d7,0x000dc5eaa0a1e853,0x000e995631bffb4f,0x000d86bad828b1d8,0x0000de96ef605f9c}},
   {{0x0002d0cd77d970c2,0x0003b33ef9cb4abb,0x000211fe903cfb93,0x0001c690547c018b,0x0000fe64809c56ed}, {0x0005624c2ac98ccf,0x000f2a393e33cb7d,0x0006605212a1372b,0x0003e8d8d1ec1c29,0x00003d31b05a37ac}},
   {{0x000e9df5ece6e7ce,0x000e2facfb55a29a,0x000a233a50603ac8,0x0000b7efe85b7add,0x000061891a09d75f}, {0x000a3d299bf1603d,0x00092184255af555,0x0009a3e021f43afc,0x000a390cdaf34131,0x00003b117efd3903}},
   {{0x000da1365d1d131c,0x0007037ad03ee095,0x0002cd8dd86f1636,0x0000e59f37389e46,0x0000103fa05967a6}, {0x0004344f4b478f01,0x0008d117c98d57c3,0x0001fc12ece91edd,0x000ccaf01777b023,0x00001ae47f2c207b}},
   {{0x000cf8d20f8a2425,0x000da22e1ad8d983,0x000c4feb37aff5b1,0x0003e118fd11d07f,0x0000d53ae9100f1c}, {0x0007905ec0418032,0x0006f440488850fb,0x000628d8f85e3c97,0x00032bee67faedac,0x0000e86515086685}},
   {{0x000aaa46a67a6b02,0x0005925cec4115ac,0x000c6701ef4cdee2,0x0003d829ee565ae4,0x0000a04ca671c7d6}, {0x0005018ef0543fbf,0x0004e1b0d81deb10,0x00015d333f709a4f,0x0000aa6b906ee629,0x00004a8741386f1f}},
   {{0x0002fa74d82f4c2b,0x000fb804efb3b6b8,0x000c3425e90725a5,0x00043e0c82ec46ad,0x00007b80581d7878}, {0x000d91cdd1fc74cd,0x000b1783a6c4df46,0x00004cbbadc1c62c,0x00076389d1b9f31a,0x000087f6f7365e40}},
   {{0x000cfc1317f4a765,0x000b41036bce02b4,0x000e72a568d2703e,0x000b0f48206cc6a5,0x00007be9ed21f53f}, {0x0004571ef0b17acc,0x000e19181b380937,0x000935d0e74b2655,0x00093608f80ea889,0x00000d9e94351529}},
   {{0x00060411e84e0e5b,0x0002fea34c931968,0x00073a732a5db84d,0x0007c049d5bb1970,0x00008d2fe571bcfd}, {0x0005f36f3eb82fab,0x000c4dff8b584577,0x00074c1108cb20cc,0x0008996659b65f83,0x00008b4a422e30c7}},
   {{0x000c3ea6fe8208b7,0x0003b86e78fe75e3,0x000d93a1abd74b9e,0x000aad9be2e81bd7,0x0000ed06e284d0a5}, {0x0005a586be8b800c,0x00011846db28721f,0x000e88ed3428299d,0x000e10d5cb8e6b5b,0x00003186b23dc034}},
   {{0x0002c9e8977d99b6,0x000123f531e7a631,0x000d3b1d4be94433,0x000b732232c0c218,0x000017aae8c41247}, {0x0003fc4282aec3b3,0x000fc7b8f8234015,0x00004f94cc6063d2,0x00034638f10e5833,0x00001efae751e676}},
   {{0x0006c6d40a9b97c5,0x0002ff666256badb,0x00084b2e314702c6,0x000a408eb954f151,0x0000184a526e4b6c}, {0x0005337003c32ea4,0x000ce05974c7fff0,0x0000dd71a5aa374d,0x0007ec5a7638544b,0x000059cd2801eb94}},
   {{0x0008161459c2b92c,0x0007b5ee8ef5a6e2,0x000b063102f020fa,0x00052ff132ec2d30,0x00003e1589a7c6a4}, {0x00053feaa3f451a6,0x000362d9acacdc5f,0x00027e58b3a3c7f2,0x00099ecec2f8926b,0x00008466ee837427}},
   {{0x0004dd41fa266138,0x000b3dc29d639832,0x00012d657a2dc6da,0x000d1579675faad7,0x000013994bea1fd8}, {0x000b722fd4f75534,0x000bb3a36b205ccb,0x000559df55135ff8,0x000f3004be28af69,0x00000b65beddd41b}},
   {{0x000f2a43734e5205,0x0002d09bdcbad98b,0x000945b355e3abbe,0x0004aa27c76553bc,0x0000331c09416ef1}, {0x000fe2976b60c80e,0x000a9ace16f8518f,0x0002b97842285593,0x0001b5cb1f64ccbe,0x00008f2c0da8b242}},
   {{0x0007174c1df065c4,0x000b1f6578fa617d,0x0003b54a8afeeb5a,0x000ce2d6ff132926,0x00005c558090990d}, {0x000b6c0ecc8c1778,0x0004d982ecaa42ea,0x00007ef8e799ea9b,0x000c2c765da244b6,0x0000ab226ceb2a3f}},
   {{0x00041e57ea973dc8,0x000fa0888f2e7457,0x000fd9cf15c00ca6,0x000871fcdce3cf45,0x0000a741ef1d507f}, {0x0001c2f196b4cec3,0x0003997ea61847c5,0x000b18a2b70d08e4,0x000514630da15c15,0x00003b6c6785f610}},
   {{0x000e4f807ac97946,0x00005a06cb79c662,0x000d954e51eccf05,0x0001c2bff08623e7,0x0000ef2c5fb84cf7}, {0x00063d2679784532,0x0005fd654af8b2c0,0x000bdaa37a0cf379,0x0007e05cb242ea7e,0x000006e0b10d8674}},
   {{0x000ae5fd5ecfefc4,0x000882bff8fc481d,0x00032459607084fd,0x0000364040a01aea,0x0000c64698114de4}, {0x000ab4ed65abfc39,0x000e83541ec79eb8,0x000695012e01cb91,0x0009ebff029adbfd,0x0000ae28483cc756}},
   {{0x0004c9ea66d80a18,0x0003f5f5f911a561,0x000ba4fc1680a3e4,0x0001c08c07b14dce,0x000091c285c21307}, {0x0007ceb799ece3c0,0x000941e07e27cac6,0x000e4312329b910a,0x000cbe66bdb409f2,0x00006f8b1377ac9e}},
   {{0x000fafd385470908,0x000f05e3415d5981,0x000e31b2719ab8b9,0x000b427c28c194c7,0x000043be0aaefbcb}, {0x000ed43a6db836ca,0x000361a45c05f3b1,0x000c1a3772a1330e,0x000e32af19f3c595,0x000085f39d0e4b5e}},
   {{0x0008e6d4ae528342,0x00095423dcb03da1,0x000374aef5a403b3,0x0001119b555e0af2,0x0000ad599c43e8ca}, {0x0002fb9014b3bf81,0x0004e66d50071b3a,0x0003401027309268,0x0004ddf79f1426c4,0x0000827cf819fddf}},
   {{0x00005f6f10ff9276,0x0000c3739fc6c836,0x000c1c2ccd387145,0x000ac50d163450ca,0x0000b52129702ec1}, {0x000c4f96e3cb4a55,0x0001278abff70606,0x0008e3a45e47d3f4,0x00015ff25a8d5ebe,0x00003ea9e97f6102}},
   {{0x000106e39cbb688c,0x000233386d32477a,0x000b9b421532401d,0x00033ece564f64b1,0x0000a9b838941dad}, {0x0002b4e2093913eb,0x0001b9bc8112b142,0x000e7b2c7533d2f9,0x0007c58fa017beeb,0x00002767c4b7af19}},
   {{0x000ff87aedbae9f1,0x000926880a54c925,0x0004d0e717daf0eb,0x000cf58284ddf59c,0x0000581cf93416f8}, {0x000a8873ac1f4527,0x00098b6aeffe3eec,0x000fb8dc3b417fce,0x00040035918046ee,0x00003d318ac72209}},
   {{0x000400f728693e5f,0x000a439927ede800,0x000ea9910e87d814,0x000b68a3e94d3b57,0x0000f8a35b71245f}, {0x00053d77f200d34a,0x00076f653ce10438,0x000a06379470f1e6,0x000c28e1ac05bd59,0x000014052c2a3930}},
   {{0x000fab526bc27979,0x000609f167716b72,0x0003e48d113670d1,0x000677701700521e,0x000078fe40247adf}, {0x000fb92d41c5dd45,0x000777b27da555ec,0x0003fb6065ff8e24,0x000a3c9751827201,0x0000768d7e57f547}},
   {{0x000eaa360017a5ff,0x0003ac64ce9bbb24,0x0003dde076b18e6e,0x0007e9d225c65510,0x0000c3672af6592f}, {0x000ad77d06283a1a,0x000044d59d999606,0x00040e7c2542fc65,0x000f550bb57c492a,0x0000c948f1448db9}},
   {{0x0009682b04465c31,0x000a5468bd156d4c,0x000318d7ee3d062f,0x000c95951729ac5f,0x0000fc87df6aeb6f}, {0x00046a80591f6528,0x0006d89621aa63d1,0x00031348ca861b8f,0x0006d9d9f5f15ace,0x0000f663391c40da}},
   {{0x00078acb591ffa38,0x0004ccdfebcecfa7,0x0004ea6b3027ca9c,0x0002543e8e05a544,0x0000aab4e6a278d8}, {0x000f04fb474d6b85,0x0003b45b38552437,0x00047ecaa6597ffd,0x000bfc6b0aea4eca,0x000068aae83d5c7e}},
   {{0x0006e64c73b23834,0x0007917d87620e96,0x000a05dab49eb344,0x0002369e1078218d,0x000043d8baa416b7}, {0x00063a5ea7610d6e,0x0004ee1ca979163b,0x000baa132e47e418,0x000b63ce648b6580,0x0000bf53de2ee0d5}},
   {{0x000fcb4d3c8c1cab,0x0002ad04b3098d3b,0x000e7d3950d914ef,0x0000e7a5ef64153d,0x0000de1666fd6b85}, {0x000ca6ed449ab198,0x0002689a2672dbe1,0x000cb7a538902b32,0x0003ff31674b7eda,0x0000e9faf6f75252}},
   {{0x00035da9a85788bc,0x000dfd0626d46ba5,0x00073dc64d21f03a,0x00097d499f8c47e8,0x0000da8564dc18ec}, {0x0007a5cde92c68ca,0x0000d3323cc43e8d,0x00080ff7c78e035a,0x000da99ef26275f8,0x00004ee3dffc73ee}},
   {{0x0003507af4e18f85,0x0004b672f3285882,0x0009d3186967ec9b,0x00039c4ded19d955,0x0000e2ab3debcdce}, {0x0006e4d11c226dff,0x000297723014abad,0x000885719f9783f4,0x000dbeaa49a0cf1a,0x0000c0c1a5b80da9}},
   {{0x000ec49571d92ac3,0x000e1692517f8bba,0x0004ea4af569e85f,0x0005ad5333b014a1,0x00002f2a62f42e5c}, {0x000ce3a06d89b85d,0x00095ff77a0898c2,0x000f795a2b90741a,0x0001985530defc01,0x00006e5ba0c54b3c}},
   {{0x000845112e4c9366,0x000d5d0be17b7d8e,0x000262bc9ae419f7,0x0002bd4583fc8c22,0x0000b842ac7f1bfe}, {0x000f4e9440d68277,0x000e7f81fb1433ce,0x0004fbb925f69f4d,0x000158816cf6f623,0x00006ae3fc449e7e}},
   {{0x000f6c2e9740b335,0x000cf962d6a14e89,0x000d10d15677bc85,0x0001cd1c6d8a7f68,0x0000f9a72245257b}, {0x000b9164ad859617,0x00077657ab4a7096,0x000461d7e5f8c47f,0x000ee26e57d7d0f7,0x0000eb6094df0ce5}},
   {{0x0001dfd341905477,0x0003805dd1500b1e,0x000df44e68a394f4,0x0007189a9eb24d97,0x00008ca06bff7675}, {0x00034626ffeec228,0x0009b6cdd8fb6f0b,0x00005be479d91bce,0x0000e32c83363ca1,0x00001ba76c186971}},
   {{0x00024cb28c682c67,0x00081612575b3d1b,0x000e66e9827f2522,0x0001fe4587c779e8,0x0000b0c03e9b05eb}, {0x000d03015b548e76,0x000fd8b36af7fdf0,0x000310c40a8be76d,0x000aebecdab04a4f,0x0000287223f547ec}},
   {{0x00060558b399320d,0x0005f01e4646678e,0x000261a5e61fe3fa,0x000449f482866b03,0x0000fcf45b92c2f2}, {0x0009a512f684b432,0x0004a7220a668fab,0x000afa58ff796c65,0x0000ddfd90707ef5,0x0000c421d976fdbe}},
   {{0x000cda3af2ebc2fd,0x000cfb4efe24c4f4,0x000cd10b1a0af843,0x000e0383b857c19c,0x0000dc9d1ec614d3}, {0x000c8bb62771deb1,0x000a81c5aa817bde,0x0002391ae829277a,0x0004ca6af18dd683,0x0000740f316d71a8}},
},
{/* digit=34 [{1,2,3,..,}]*([2^238]*G)  */
   {{0x000e99aeeaf8c495,0x000d1e24d7288928,0x0002b156cee7aa73,0x000a1cfc5007c2e7,0x0000fcf57c63d408}, {0x0009e39b6057604e,0x0000e2868bbf9f71,0x000103e2d7d343c0,0x000ea14cca254b7e,0x00006eb38aad131b}},
   {{0x000624f8be762b49,0x0000758e3413b33e,0x000d805fa2a9ee4d,0x000fd7068e636967,0x0000848949c0db8b}, {0x000d7e5d23a84178,0x000d73e29da55308,0x000ee471f892f3b1,0x000089495c139e3d,0x0000631594e5757e}},
   {{0x0002a3cde918dcce,0x000346fdcf4be0c8,0x000cb1b2d2e7b599,0x000e06a2c5024932,0x0000a613a9e5657a}, {0x0005f6cf1fdc9f70,0x0008879fe682c2eb,0x0001cbc7fb6eae8b,0x0000e6253dfee059,0x000000da7133e129}},
   {{0x000e2ea1f095615b,0x000664e68c331083,0x0008818be0a28ad7,0x0000ccbbfc02523d,0x0000585113ba3585}, {0x0005f0b30df8aa1c,0x000b8ab7e3ac7d93,0x0002f00cbaddda07,0x000f6bd2c3429955,0x000033ed1dee909d}},
   {{0x000195d80e877662,0x00087ddf4ac022c2,0x000e749349e99e6d,0x000240e9642e4e65,0x0000610ffa31f1ff}, {0x00047d4751c8159a,0x00050f3a93634d1d,0x000477c33697b498,0x000ff26318ca4687,0x000090cb5663441e}},
   {{0x000384836f024cb1,0x00072601616858bb,0x0007e07f185be1f7,0x000f025c59587cdc,0x000091be071bf1d8}, {0x0009fa5cca5e55cb,0x000c47d04eacbf16,0x0007d05db3864ba3,0x000e5ce15e367f8d,0x000048a876e56549}},
   {{0x000c656580e40a2f,0x000b828068bcef89,0x0007990c9f194ed8,0x00064884528045a4,0x000053fc7d84e1a4}, {0x000ae9b78593e7d5,0x0002f1db65d7bec5,0x000a3d39b2cac4ee,0x0003ef58c1eb2404,0x00003b7d63453f8f}},
   {{0x0000d483e07113c9,0x0008ed8b63ae2dc4,0x000684c2b6e4a5d3,0x00026bc582a94b79,0x000032b33d4f22da}, {0x000f6510dbbf08dd,0x000894c23a52f534,0x0005bdc9b211d07c,0x0005573eeece0fee,0x0000f178169c7015}},
   {{0x00046350a712229b,0x000759273f8cd429,0x00013bc8393cbe44,0x00078b50b095ef8f,0x0000b74197337989}, {0x00009a256dbe6e72,0x00063a5d39ec9d73,0x0001f9a31e578ec5,0x000eb41961151b85,0x0000da7715e05709}},
   {{0x000301753dfabf0f,0x0007c8e39259867f,0x0005d9958728d207,0x000be06c75a0cd81,0x000084867a706603}, {0x000b13d70e35b1c7,0x0007a9b03e2cc865,0x0001f31210241446,0x000a7c746041daac,0x0000c9017addf028}},
   {{0x0006de90a482873d,0x0000e77e54d4abc9,0x0007d88e74265d6b,0x000de298c38e79a5,0x0000461d7676ce82}, {0x0009ec564a7e489c,0x000ce0def5f2817a,0x0005d494ecc5675c,0x000149da00e78598,0x0000626833fdb035}},
   {{0x000905a83cdd60ed,0x0004d1170184abe7,0x00023642a50602fb,0x000aff989886cdb0,0x0000568d09176e1f}, {0x00022c70259217fd,0x0008f43141e45b19,0x00095f86e93831cd,0x0008280fca35870c,0x0000ec2057b268ae}},
   {{0x000a599f98a759a3,0x0002c7c23c1dc44e,0x000c4f68755a0a7a,0x000478a5ffb6e694,0x0000563cce242848}, {0x0003517e7b1fbe12,0x00092f7338e0812b,0x000d048db8a7dc97,0x0003b8011ecee952,0x0000eea4056e86ea}},
   {{0x00068a7ba772b34e,0x00007f4e2541d8cb,0x000ec14dbe16ed34,0x0008bdbb32f6a60f,0x0000ee376f819169}, {0x000aa1783674c027,0x0006e843022ae9a7,0x000a4990f65832f9,0x000215b9f3a8da5b,0x00009a59c3b6b8e3}},
   {{0x0004d2ebd19bb161,0x0000a3262d869cdc,0x0009c0b47c6c7cfd,0x000128c4ce14d096,0x0000fa352b723e56}, {0x00055b8973db6d32,0x0000c8e5b7bf383d,0x000bb571f7183685,0x000dd2a7714596e6,0x000059df31f4d5b2}},
   {{0x0008925913cc16df,0x000cf1a26f5a568f,0x000f499ae18bc5b6,0x000e83efa413bef5,0x00008835dedb3f0a}, {0x0000bd865a40ab05,0x0008c94b377eb6e6,0x000084a696559643,0x000de06cd8562592,0x0000ce433b99f23e}},
   {{0x000f04f6ad651437,0x000766e14af6e8e8,0x00095c0c71151182,0x000a15cd390a1082,0x00001e29ee4d21eb}, {0x000fc0963717b46b,0x000e306ad4a2a588,0x000c22b2202be02f,0x000848e31558c604,0x0000b4d4bd6c2f3c}},
   {{0x000f49620efd6628,0x000045952d1454a4,0x0009784c292ba6d2,0x000643adb8ea1ecc,0x00001cc10cacb353}, {0x00070ad4b4d7f6ce,0x0005a4a1dcd240b5,0x00047e7975c9f1d9,0x0009f421379f8131,0x00005c6097c0bd49}},
   {{0x000afa6328e5e200,0x000a5481555040dc,0x000bfc978f7b5244,0x0005b1b9a4f11847,0x0000ea0e79fd2582}, {0x00096eb646c7ecfb,0x0002946dea9da50f,0x000abcf69eb81149,0x0006e77af04677df,0x0000e3a06907713f}},
   {{0x000523d42e06189e,0x00006e3aff13860d,0x000b20650bf07794,0x00000c2b616dcac1,0x000066dd6d201313}, {0x000fd67ff99abde3,0x000097aac50dd4a0,0x00046b2d7c990355,0x0002aed22ecf8b7c,0x0000333b1e86abf9}},
   {{0x000113c6c491c14e,0x0007a0dd3f8811cc,0x000d932ed0597668,0x000b6d15b4d9e729,0x0000982aad982c38}, {0x00053478be0dcf0e,0x000d85ca53f26f92,0x0003ca77f700080a,0x000983f813115644,0x000092d6943cc51f}},
   {{0x0008af885dfe9aef,0x00045d2a86cad2a0,0x000dff020d825d9a,0x000c3f3c53988d39,0x000038b135b330cd}, {0x0008ae062a7150b5,0x000dbc340e9b0c91,0x000bbf02ef31fd8d,0x0002395fa0e7ae4d,0x0000847fb2aaeba6}},
   {{0x00047dcdccbac8b2,0x0007e6f485c86b16,0x00038ecdfb642aa7,0x0003fe673f376570,0x0000ce5e8661a49d}, {0x0003788c98c44004,0x000db1fa5279ea22,0x000becfd78104a8c,0x0004ae7cf7cc7a06,0x0000942431708f97}},
   {{0x00065e784d6365d8,0x000f0f759fb8c0da,0x000e81930bcb7443,0x0008aab5c712b17a,0x00000428dffcc6e0}, {0x000afefa4faf8433,0x000dcfa9855ff19d,0x0003ac7ceced8538,0x00071df0ac409cbe,0x000058c1fb6b82da}},
   {{0x000c0e5fd349961a,0x0000e421c2fcafa9,0x000a28d382b2cfa5,0x000e7d8a80db17f3,0x00008aba539fd138}, {0x0002d1d6e96eb8db,0x00001baf96225201,0x00064f56c65d8dea,0x000da1a7735447b2,0x0000eebef3fcb6c8}},
   {{0x0006d98ce7852541,0x0002ab64a161fc34,0x000794addd50e8d7,0x000ef6b03567c749,0x00005a76065852c7}, {0x000a222961f23d6a,0x0007d3ecc0b059f3,0x00082fde4378e443,0x000f34274be4345a,0x0000e509af378b9c}},
   {{0x000ee46577f44a13,0x000c8611deeb4a61,0x000f7b884e09b748,0x000a6b90481b2cf5,0x0000562667891acf}, {0x000c518bf8d21e6b,0x00010205a76d37f4,0x0004073c022d9653,0x00056687fb85e195,0x0000ceafe5015b3a}},
   {{0x000def7be42a5821,0x000055046be6efec,0x000e8dba9d3fc608,0x0001ffb9af13c809,0x0000e6c984774149}, {0x0004925d30c31f70,0x000aac2a21223b57,0x0000859e7b7eb72b,0x000942776a0dacef,0x00006fec31421900}},
   {{0x000bc10f8c22049d,0x0006b75ebf692464,0x00036326b9bfbcce,0x000cfa07a88e2a43,0x0000a05261d2bc2a}, {0x0005bdceba7efc8d,0x000955dbbf2ec29f,0x00075f127471237c,0x000325d72773f229,0x0000c744e8ed4d0b}},
   {{0x000ed16a56edb730,0x00072c007e7038a7,0x00080b40064357e3,0x000be1a167d15b50,0x00007b4116423de4}, {0x0001e3274c898834,0x0000e882e7edb2d9,0x00003e4823c16282,0x0003316d6b36ba75,0x00008434e8e4ea34}},
   {{0x000f24f2c7ae0b94,0x0000d939b44a79f4,0x000595eb1c46fbf8,0x0009c736fefae856,0x000017b66ac0d5f2}, {0x00032b2c5ceec209,0x000f51a1cae25f23,0x0000286e6d69661f,0x000992cede7e529b,0x0000d06252a7276b}},
   {{0x00094b07e50122b3,0x000b1af07ca53247,0x0003fc97bdd744f8,0x000d9d00a12f08d6,0x00009650f1aa6626}, {0x00047f71fa38477c,0x000914dc124f101b,0x0006eb58a3d815f1,0x0008865569ae95b2,0x00003cde18955fb1}},
   {{0x000f37bf9539a488,0x0005f408c1a554e9,0x000580cbbb0100e0,0x000c56021d9811ea,0x0000af52d3606e50}, {0x0009d47dbbf698b0,0x000a03dc1c73dfbd,0x0006a5df82961a1e,0x00007a203d38f8e7,0x00008a53a686def7}},
   {{0x000fb481bee45d41,0x00062c68803626ee,0x0002f2469b3cee34,0x000162363c5315c4,0x00009d84d2e91378}, {0x000c3c51c4d349f6,0x0003b63d59c522d7,0x000abceae6596584,0x0009d56f198c56b8,0x0000fb1fb1bc2855}},
   {{0x000fd0607bf8fe31,0x00082467734b8bbf,0x000f7f0d346259c5,0x000ff1c8953cea35,0x0000f0bece2e65b0}, {0x000b4b3f3c72914e,0x00045cb53389f7d5,0x0006b6d4629e8ea9,0x000fdd6a36562683,0x0000849f911ca174}},
   {{0x0002fbbf4737f217,0x000af209f5ac7ec6,0x000f9adbed8dba5a,0x000767b4b5d7a9a5,0x000007d28f8161dc}, {0x000460bcaa999eab,0x000c6c92e4cc7711,0x000d4bf2dba7b174,0x0002788c4bab6618,0x00008f0c9819b8bd}},
   {{0x000ea9a324b47379,0x0002a2a83bca024b,0x00032dcedfba9e42,0x0008b9de635643a2,0x00009619367b571c}, {0x000f35754b7032b4,0x0009e442d54ae8c9,0x00090c65af936b3b,0x000fdae263f0f082,0x000089897812e2c7}},
   {{0x000d55a13d4f95eb,0x0004fd9b8500adc5,0x00073f43d737cff8,0x000475771c557b8a,0x0000ed617a5918bc}, {0x00054017dfd8ab26,0x000dda2870aa6624,0x000a7e545ae7b89a,0x000e4bbb555f5323,0x0000791e2481e057}},
   {{0x00036ad324fa34d3,0x00071cbeae288601,0x000dd3299ea11144,0x000c33d23a4270be,0x0000d5c3a7ff1c35}, {0x000db678d0412d2e,0x00021cdc6b9ab0f6,0x00028a982d92625e,0x000e7db2ae5ccc4e,0x0000a251c3727a3c}},
   {{0x0008932790691bf5,0x0008b6b736ae9d65,0x000d63b6eed61058,0x00088f212c2f04c0,0x0000cf06fd6163d4}, {0x0003facd9588e411,0x00021b93257e9736,0x0007acace1f9bf76,0x000ecf99d1ffc466,0x0000cf4a1aa1a061}},
   {{0x0008a49dc1818d01,0x000993621ab040e4,0x0009ef6390643ff3,0x0008544768640ce3,0x0000fc099ea14d86}, {0x000b9c3eccd28fd0,0x00027eec54ab9130,0x000b475b6d743cbd,0x000d1f052b146fe5,0x000058d9a82900a7}},
   {{0x000229291262b72f,0x0008cb0edf0365e0,0x00020684296f924f,0x00071f6cfa59c8fe,0x000060370054eafa}, {0x000699e18d7dd96b,0x00021bab24955f30,0x0008be949381e878,0x0008eee1669b46dd,0x000040606f5d6aae}},
   {{0x000b839fc6751a47,0x00048ba800ef2812,0x0001a28751619621,0x000348d398d5ca4c,0x000020c00eed53d8}, {0x0009eb0d820007cf,0x000fb39b5825c269,0x0001f6984880ee65,0x0009998069469447,0x00007d16ea9d3dda}},
   {{0x00075b2c0519a238,0x000dcf6952e328d6,0x000294a8a9ebf94f,0x0003f5728bb767a2,0x00005512b4e7e0af}, {0x0008ba899b16a0de,0x000bda7548a71895,0x0006be61595c2430,0x00074bd30d1b10a1,0x00003ebbb9865bfb}},
   {{0x0003cfe18549fdb7,0x000edfcdb792a327,0x000aba56cf6e200b,0x000aa1e4a76e1883,0x00003ec66f6f9ef6}, {0x000add7d1b9a305c,0x0008f7ae1b9d8d17,0x000cc094aa959c5b,0x0009b8c86435226b,0x0000c5616c597d42}},
   {{0x000da01e6a33f7ce,0x0006bd4e70ada6da,0x000c15b7cc6217a0,0x000853f619a81809,0x0000a06b329ee80c}, {0x00011cea5f5e7b9c,0x000fb87c65f41748,0x00016ab5466dfc30,0x000f6f8ea7bd6933,0x000012c4acbddcc0}},
   {{0x0008d1a1e407dd9b,0x000be1afa997e430,0x00077b7a5e8a3587,0x000d523a296c12ab,0x00005ad49e5173c0}, {0x000b2b27006085ab,0x000fd7bf6ec240f9,0x0003066a6a88ff33,0x0006e1e78603b14e,0x00003f99fc365e48}},
   {{0x0003f5eb2e636456,0x000724c8423207b5,0x00014d5cfbe57e54,0x000aca7779c21672,0x000017969cd629a3}, {0x00068cd8a7017a0a,0x000a1e9b7ee8d176,0x00016177677b4d19,0x000a71b8fd0e939c,0x00008c4f4f075968}},
   {{0x00071cc67b3de77b,0x000db34f79052960,0x0007100c9ae3c0b8,0x000b41b7e440c28a,0x0000b8c3c1c9b4b9}, {0x000e8eac51b35836,0x000f3525e6426d71,0x000f509f37591f5a,0x000c9b973a2f7b13,0x000018487aab619a}},
   {{0x000e5f79d61718a7,0x000c0592d28c3a72,0x0003c35cf00413bc,0x0006ed0d9b11d396,0x00007623bd0290a4}, {0x000273bdcdd2a50c,0x000a4601846edeef,0x000c6e9294a741f9,0x0002cc73b89e510e,0x0000b0231a04b7f2}},
   {{0x000500d084bae24a,0x0006943d2693bbe1,0x000def8112f0ae8d,0x00094f0cffb5f27c,0x0000a0c030ac63fb}, {0x0000d61a0f442dea,0x000687b139d36eef,0x000d8bc28f92e181,0x00012f7ae6deb70a,0x000089e38dd60514}},
   {{0x000b865d2fdca23e,0x0007ec8ef89581ee,0x0009056145a15ee0,0x00019a968fa10a01,0x0000ff5b8f0680ee}, {0x000cabbcb1c8a0ef,0x000cc8c838f9f0c0,0x0004a14c02e1ee9c,0x0008e41587d8b88a,0x00006f278971ff69}},
   {{0x000ef1c89ee6256c,0x000dab353b45ed38,0x000e903b3f44ee1f,0x0001ded115c0c770,0x000078ec0a2418f3}, {0x0003324b7dccbc61,0x0003063bbc256c00,0x000edd805d96dd1f,0x0002f123aa82dd5c,0x000023aae4f8f7eb}},
   {{0x000fcf5a26262cd2,0x000ce060ebd51723,0x000eaa3af1f7f4d5,0x000ccfd19c5c01b2,0x0000ccb9b14b790a}, {0x0001cad52324aa65,0x00062247df541f9c,0x000c96f826320052,0x0003840732fe42ba,0x00002fe771f51a1c}},
   {{0x000a13db1001684e,0x000dc1709f75546c,0x000db8672b56b4ee,0x000cfa466545a9d5,0x0000d971c90fe8f3}, {0x0008691e3a07b296,0x000c84b696b94e7d,0x000c7e9ae7570d9e,0x0008447c5fa0677b,0x00008b44cb0282c4}},
   {{0x00034b3bf44da801,0x00094ab32e66519d,0x00078a000283834f,0x0002f65e60879762,0x0000e62960e72731}, {0x000b27be6901c550,0x000824fdbc1f9b87,0x000acc27d80e7853,0x000b5abbbc09512f,0x00006394239ac143}},
   {{0x0004a40376c1944a,0x0003c3da151135bb,0x000148a3b7cb6269,0x0002ee0fd29161b7,0x00006f9d9edee2ea}, {0x0002ca2880dd2123,0x0003761139a915dc,0x0000f8785903c381,0x0000fefaa7b46d6c,0x00006ce2871c01c6}},
   {{0x000b028e10d9c12f,0x0001132f33d3c683,0x000a31b587573baa,0x000e1197a9b1f667,0x0000d3ed11be4ffa}, {0x000aa9a0cb2748e2,0x00083d6fdf1683dc,0x0007539418239f01,0x000b369a67b49c72,0x0000beec455e321c}},
   {{0x00056063f8b84cec,0x0002cd38c86f8801,0x0008953dd7641708,0x000428454f1ca759,0x0000939e1110e8e7}, {0x000c2b35a914f2f1,0x0003d74b8f9c9b1a,0x0001b2fb039e35ed,0x000ba2c0debdb278,0x0000585638f3d997}},
   {{0x000646e9e2fce99d,0x00004e80857f9c4b,0x00043b52a68a2108,0x00084236d54e4436,0x0000e8d6d63dd8eb}, {0x000156342146a0a4,0x00021eaa36227032,0x0001387878ba826f,0x000d36e27a58bd86,0x00003b6c03c50281}},
   {{0x000afbbb54dde39a,0x000a3b6f2d5f6326,0x000f158e1744e5e8,0x00018ea8b2a99acf,0x000093c8fa18f879}, {0x000f956de058c5cc,0x0001d36f9e7a2182,0x000e31e67216235d,0x0003e6ece0c0dbd2,0x000096449c0b23ac}},
   {{0x0002874170693bd8,0x000d245e63357e9a,0x000427344a28e14f,0x000df8d757f6b356,0x000022e45572cf8e}, {0x0006ee2e6a285cd9,0x000119df3af02b7a,0x00045b8445866f21,0x000e48b0dde2ddf8,0x000086c3726a10e5}},
   {{0x0000c2af7172277b,0x000e5cccb2447368,0x000438ca757b94f0,0x0003fd0dff72672d,0x0000ad1ce127f466}, {0x000ed9dd8f71caef,0x0005a61fdaa69813,0x0006d1637f43272a,0x000977ceff0119bd,0x0000ebc4f9220361}},
   {{0x0007a952f41deff1,0x000ad63b89b702b3,0x0003ff9510e44a59,0x000af4573257dc14,0x00009c02205e752b}, {0x0003069c4b7d692e,0x00031d1502ac46c2,0x0002208462e6392c,0x000b628057b1a21b,0x000051ff946ec1b5}},
},
{/* digit=35 [{1,2,3,..,}]*([2^245]*G)  */
   {{0x000cb51566c5c43e,0x00085597f0466e85,0x00094d94acff9c91,0x00027cb354e90c49,0x00000a3933301479}, {0x000fac10dc1eb2bf,0x00013ff319fa8427,0x00096527488cfd8c,0x000745f2d4e68401,0x0000a2e067e57aaa}},
   {{0x0002a7f3e5f9f11f,0x0009e6cb3b8eb6d9,0x000f800bd9afe153,0x000e185d1a6dd7dd,0x00006c13cc1baf17}, {0x000c58e325fc3ee3,0x0000731dc3b215f6,0x000a3d3e77109540,0x000e2ce68e7c07af,0x0000f8417a1c4c7a}},
   {{0x0004772813b230d7,0x000ea7344427ec23,0x0007fc56a634d0f5,0x000f76a1548ab1d7,0x0000fab17513e06a}, {0x00010a74f7c4f830,0x0004220a67d9b62c,0x0001209a0a7d2edc,0x0009f01c40417092,0x0000b9815a0face5}},
   {{0x000589b319540c33,0x00097283d6f82842,0x000ae9fcb18490f5,0x000ba072731f84da,0x0000db6d960f3683}, {0x00063bb146110697,0x000e9788bf05c85c,0x0007460d2b19436a,0x000db1205459df34,0x00003f6e095511a7}},
   {{0x000938eb6357f373,0x0008fbd8aa62dc7f,0x000a979fcc5d00f7,0x000a999878dcb92c,0x00007e83eda1b023}, {0x000e2731560bf3d1,0x00090d0fae616b23,0x0009414bd1086e45,0x000ea1682483169a,0x0000b956bc100ea9}},
   {{0x000bb91c31b9c38e,0x000a68ef57b57b85,0x0003bab6f0c5aa90,0x000684fedeb169af,0x0000610ad740d373}, {0x00070df02ba8e15d,0x0005bca7f771f138,0x0002c036c0337edb,0x000e8114acf747b6,0x0000921d57786b94}},
   {{0x00064392c422f7ac,0x00022d348898dbc8,0x0005bfcd1fb63536,0x000e10c3084668c4,0x0000357c9e3eb315}, {0x000b5405b2e5b8ce,0x00010102b9a4b173,0x0000fb1997e94693,0x00062a37c890eb7b,0x0000c225a84b61b6}},
   {{0x000a3c8ee3c76cb3,0x0003a32a1f6ef306,0x00063e9563cf1162,0x000c26b6d5ab6468,0x0000b8a4cbe8c005}, {0x00029a59ce6bb278,0x000184d4b16fdcd5,0x00023798dc4afaa5,0x000fab30624a2679,0x00005e56df6eb307}},
   {{0x000893c2bf296984,0x000497ce76030281,0x0009a558f91fc19a,0x000f7735a5dca3ad,0x00000ceb3fa8d50b}, {0x0006060bc9ba369d,0x0006897888c21baf,0x000a34c07927e103,0x0009800936bf1986,0x00004cf10c2934ae}},
   {{0x0005334859dd614c,0x000a58d0c8ee3a3e,0x000cd51d59c475b5,0x000325a3080d1f07,0x00009c0d0a7788b4}, {0x0008691c234296f5,0x000444887fb61ac9,0x000ea9cf22a0a83a,0x0002f5065114270c,0x0000230a6e8f2480}},
   {{0x000bf0f72e3d5c1e,0x00056f21439ef7a2,0x000e303343771744,0x0002f91edcbf259c,0x00000030a795ce20}, {0x0009ebf1202e9ca6,0x000c15e6e5916f2d,0x000dac4f8e79dde6,0x00004d952072aff1,0x0000c8d087f1b9b4}},
   {{0x000c73dbce913af4,0x000b058a07cbad0f,0x000f00c8a909e587,0x0006abd300da84d4,0x000025cd048f5446}, {0x000b9be90e9d8bf9,0x000aae431b0eb59c,0x0001aecff991616d,0x000c3b43aa117a53,0x00001af92d3e9f4d}},
   {{0x000c292e93fda293,0x0007b97d91bc9b1e,0x000ace1e676bb6c1,0x000ae34509d95faf,0x0000653fe47ee855}, {0x0000b280f680e752,0x000bceb6c26c7318,0x0006d423675eefd1,0x0001d884cdf29fb6,0x0000d70a9978b582}},
   {{0x000e20720445c36d,0x0001898771747a3e,0x0009f73e971d1ac8,0x0000803fc539f794,0x000005cf3d8682e3}, {0x000e20b7b1c7129b,0x000fa69e61f28758,0x000544c2dffadcc1,0x000e53005d3a2f59,0x0000e16f5c24fff5}},
   {{0x00065b8aad581350,0x0009037aa5be73cf,0x0006fd6a0622c211,0x0008cf79373b3f64,0x0000e029db50d397}, {0x000c43794fba0377,0x0006f20797a68bdf,0x00030d38eaefbd68,0x000463cfa5382bbd,0x0000627cfbfc85d7}},
   {{0x0000fef4e4ca4631,0x00072566cc63b233,0x000780900bcef728,0x00027dc161d2cacf,0x000035dc5396b548}, {0x000052e27bf1bc68,0x000f87dfa06c638f,0x0003321da10a224e,0x000c8f6973586d6d,0x0000b0c5738a6152}},
   {{0x0004f2a346060743,0x000870f7047a07ef,0x000a0e30680fe7fe,0x0002220d1a8152e1,0x00002cf43d8b8da5}, {0x000a95f5f02ffe6f,0x0003906ad3eabf89,0x000c8e55e3d9eb9a,0x000dab112c17bb79,0x0000dcd1a7589c81}},
   {{0x000178bb95560983,0x000f501c38867043,0x00067b9124090a1d,0x0000c8459800ff9b,0x0000e5c030453262}, {0x0003c4b70dceecab,0x0004681f648e4b9d,0x00033345cbb2d3c1,0x00097a4981d8376e,0x0000626289bbcf22}},
   {{0x000c6598baebdcf4,0x000935df01e5766a,0x0005876d81a28ae0,0x000800771283da37,0x0000865a96da07b9}, {0x0001bcd237936b24,0x000b2041749425dd,0x0000a2147332f4f4,0x00020390923d6837,0x000097f5dfc1c842}},
   {{0x0004cbd32be5e0fc,0x000657a013759dc7,0x000d872b17475bcb,0x00063c838477c950,0x0000ec6787abfe1d}, {0x0006014d8578c70c,0x0007b8bb6b8b9b00,0x000fb3806c9ad99a,0x000ab2a799008e11,0x0000fe814368d44c}},
   {{0x00015822f4fb344d,0x000f783fa6eba2ee,0x0002c7749b882344,0x00015a922d323d65,0x00008474a998eb0a}, {0x000154d5d1c00d06,0x0008ae3e7aace43c,0x00025ddf87fd581d,0x000738cb44c61925,0x00007a033ec18ae9}},
   {{0x000fec19ef2d2e4a,0x000e35a0ea7f113f,0x000714c0a1bf6767,0x0009edb7fff75e03,0x000023c422eaa23e}, {0x0006b2d540f83afd,0x000d85ea46a7dd5f,0x0002a1208c2c2c27,0x000f7a1b6b424667,0x000013599f87e634}},
   {{0x0004b5cd7b32c6ee,0x00000af61814cf91,0x0008a1bbb61a5a64,0x000aa4adc3df8b20,0x0000f627fd796d79}, {0x0002ffcc4c86bc81,0x000af61539fe4423,0x0008b9533e6f9231,0x0008850d04f25a95,0x000080cf93459e8c}},
   {{0x00095959884aaf7a,0x000267b348a68968,0x000147c87b1959be,0x0001f7f6250e573c,0x0000e0efb3b7d0c6}, {0x000745eca8c325e7,0x00067cff3f70ed00,0x0009ad41d3c91169,0x0007ef03acbc6531,0x0000b01a02160b1c}},
   {{0x000b29363a1483f9,0x0000ea248f96ea32,0x0003157e589eabe7,0x00046d0c6231d334,0x00003a375e66f3c5}, {0x00093436a2afe69a,0x00004166c88ee76e,0x000872093c4f8910,0x000a60848efd0d4f,0x0000e0eb3eb2fe0e}},
   {{0x000790d9d79046e6,0x000d0cee0976af89,0x000071eca4d650f2,0x000bfe43935d9a43,0x00006fcd2c9883b0}, {0x0005eb5696605f18,0x0007254cd38d0e66,0x000d950cfe77e5d0,0x0009b510ee050a43,0x00006ddebdb532e6}},
   {{0x0004a3dfddf74157,0x0008cf6e8d5a6ad9,0x000957f75f7fa130,0x00044754831d1de9,0x0000de2850245817}, {0x00070789e2aeb6b4,0x0004b67a53c26f1d,0x0009defc3ba2b9ff,0x00022bf6963767df,0x000079deed34d380}},
   {{0x000b89b3a8631e8d,0x000daa213746d2ed,0x0000c5f118de855d,0x0005e3e2056cb7b0,0x0000eaefbd0fc9b8}, {0x0009a8dd150892d4,0x0005e18b798503f3,0x000375f1a37b8468,0x00098df6296dd8b7,0x000072cd4b1f78e8}},
   {{0x000f651e9f05de9b,0x00087ce98ba915df,0x00038024cd404506,0x0005eed466a7ae9b,0x0000910e70195a6b}, {0x00056eab3aa8f0df,0x00068eee74a6ae1c,0x0004c4620bab2a50,0x0001f31dca11e24b,0x0000d896e2f3c47d}},
   {{0x000ae53308fbd93d,0x000d32c36fdaeb45,0x000a4838546cd5a2,0x00095f9a3d4e90ba,0x0000d55e62f6dbe9}, {0x0006aa02a81ede7f,0x000409274ea7a140,0x000414f866860dd1,0x000326dfdcb0c280,0x0000f410b1112f94}},
   {{0x000cc3849ad467b6,0x000baa7335f15a33,0x00053a360efb48b6,0x0009cbb4fb54a4b1,0x000004aa9d315246}, {0x000c486754e48e96,0x0004d7471e8e5e9d,0x0003b37b6693cb45,0x000f079b2fd7cd8d,0x00003345e172f09f}},
   {{0x000ba6b23a5d8961,0x00056fe4364e9910,0x00033c6771fe19e3,0x000fd05e1da8c39a,0x00005b4488b39fd9}, {0x00092541a1f22bff,0x000fbb8163e81f43,0x000e5658e920a8a6,0x00039a4fd1b24907,0x00002c4f79da6ec8}},
   {{0x000c3d04aa38d1b5,0x000c65d9510e1abb,0x00060dec03b0db35,0x000b32c754ac783e,0x00003272fd83a099}, {0x000494f07a8e1078,0x0006ea8191fa5fb0,0x0004ad5444a89e13,0x00097b2113b7f63c,0x00008a2e909ecb98}},
   {{0x0005de3b44a3f84f,0x000327c6c69017d5,0x000232390acb2f34,0x000bf64208816810,0x00002e8a6205c733}, {0x000aab69c2d76521,0x0003dd95c5bca774,0x00081f110fb5307e,0x0008c9905c73c249,0x0000baae31cb3945}},
   {{0x000185bcbea62e7d,0x000e1af630591def,0x00021851ce8ac9ea,0x000f5a398a8cfd99,0x0000959c3f20abe2}, {0x000952520e40ae55,0x0002b7a24aa1a4f1,0x00092b2bc320789e,0x00068ad59e692773,0x00008f6c66769186}},
   {{0x000b2bbc55d2d8b9,0x000764f6ca56ce1d,0x00087761441d58bb,0x0009ece650b6808f,0x000005e16bb84c34}, {0x0005140f661acacd,0x000ffb2270afed41,0x000402cba3b8784e,0x0002196bc280ac8a,0x000053f7146d9379}},
   {{0x0008ee5e5681e833,0x0005c6ac9e4ac03c,0x0006b1a386212610,0x000cbd6503a53f93,0x0000d45e2d4a82fe}, {0x000c43976e8ae983,0x000b8fb4b00e69a5,0x000386c89b53b2ee,0x000ce4c167471272,0x00000ca34a27268b}},
   {{0x000d86c783417303,0x00088525e2487f1e,0x0004fbf388ef5beb,0x0003828bc489fdb7,0x00008a92a0ec1a0b}, {0x000ba3f22433ccf6,0x0006429f05a97a77,0x000189afcde8362d,0x00014f1f6a30ea61,0x000093b5505b9ef1}},
   {{0x0006bc0cd1797a18,0x000e74b7af2d5026,0x000f9483eea17b47,0x0008c956c4025c3d,0x0000cbb9da0237b1}, {0x000fd9c4d8424cff,0x0000bb1c350691cb,0x0008206a3db7048f,0x0006cdaeaf641f02,0x0000986f3fa15bdf}},
   {{0x00043b5224c08dca,0x0003e1b50c912621,0x000a8c84f2bbb09b,0x000ca8216ed709ac,0x00006210d9e52850}, {0x000f67a09cb54d69,0x000fc00919a46d8d,0x00013285791eef6d,0x00028b00f613810f,0x0000acede4888d50}},
   {{0x0001b7190b771c33,0x00048a6426be844d,0x000b802ff563b71e,0x000a40fefa2e83bd,0x0000410cbabdb5b4}, {0x0002d2630da84dd0,0x0009ee1cc29a555b,0x000547792d0711ae,0x000b35cf3e8c602f,0x00003d7d5dedc678}},
   {{0x0002fa8ced806b84,0x0004297f1478071a,0x000fcdbbf222e613,0x0003b89c16fd5dab,0x00004912ebf521b5}, {0x00036742496c27c5,0x000bcffc26b0ac94,0x000debf2c8ea3176,0x00083266e224ac13,0x000024cc2364372a}},
   {{0x000e1d89f6f1b18b,0x000494cce35bd706,0x0008e31fc2552f00,0x000046dc8326c2a8,0x00005468b2da9552}, {0x0003e883ff90f2ba,0x000e8f0a5423ce68,0x00056e32877947bd,0x0004ac30a1b28bed,0x0000ee3525462013}},
   {{0x000367d3567962f6,0x000f2188bffb7e98,0x000f130a1379ed61,0x00073413bba348fa,0x0000c1f75e1f04ed}, {0x00066423b4a79fce,0x000c74ef44931895,0x00011eca1f20bc83,0x000dcea36d425d91,0x00005b5c318e09a8}},
   {{0x000b25d13221bc57,0x0001fb3eeaf73360,0x0003a95a1707baad,0x00009f67279ed874,0x0000450a876069e8}, {0x000bd53e5d0338fe,0x000e4b883bbc32b6,0x00063ecd01e77f7a,0x000e46b0da12cc10,0x00002697b59a315b}},
   {{0x000a5bdda85d5347,0x000f8f980eea2771,0x0000385e753e78c1,0x000b623df1cf8490,0x0000d3b14f739387}, {0x00074b0cb8f2bd25,0x0006327fa993170e,0x000f32bab2d50b48,0x000ab87dbe8c9af6,0x00005e906b113b93}},
   {{0x00022fc8fe280d19,0x000522e114ab747f,0x0000b68b0cd8e0de,0x0004b1cab7dbebe1,0x0000dc63a9d3480d}, {0x000bc3b4be1495fb,0x0007e359122d78d4,0x00009cbdc25eb3db,0x00002e8f8ac05b08,0x0000f4187bc837c7}},
   {{0x000a0691416a6a5e,0x000863ef881c84ce,0x000038a5d8f860c7,0x00006661311f8a38,0x000078c2ec1dc612}, {0x0002e815ad735813,0x000029604097494d,0x000612cbab4cc9e0,0x00039ecf558aecf3,0x00005beef7ace36c}},
   {{0x000c7cfdbcf41b9d,0x0009dea997c01845,0x00002f6d85703662,0x000161bb925afee4,0x00000a1b1af1dd72}, {0x000b37503c41c4b1,0x000af391d0429f47,0x0003b8b0aa023829,0x0000e54f5045c350,0x000023c2688a8c01}},
   {{0x000c0cc36ba06eee,0x00045dd2cc0c324e,0x00033e91fface311,0x0002afd364f3bef3,0x0000f8aff7408e83}, {0x000ad042d05841bb,0x000e856a21e21e9b,0x000dd627e42f0e3d,0x000710f3270bcb4a,0x000009a81598322e}},
   {{0x00026a10fee104a6,0x0007d703f65d86e3,0x000bc4833ad7788f,0x00093a1e76543047,0x0000cee582b8b9b8}, {0x000a167e8f55a7b8,0x000659e4190d9cd2,0x0000c2e9defbee3c,0x000547b3ee7185d4,0x000044cc9c62380b}},
   {{0x0008ecd66926e04d,0x000eb110c1ba323f,0x0006a7f070001e38,0x000826bdbcac12fc,0x000065e1d58dcec0}, {0x0004141be76ca2da,0x000c4892f33ad2cd,0x0007139d27895cf5,0x0004c0f56d230d36,0x000091abd3f7012c}},
   {{0x000488387eb36bff,0x0001a14b8fb434fa,0x000b9c95fc5f0710,0x000194a0f0e579ad,0x0000e6ea8cc18888}, {0x0005065edfa9284e,0x00014b8c8d657b9b,0x000e8aafd6c510bd,0x000a06f7b8ebefcb,0x0000db3af9976b1d}},
   {{0x000779d6295d4269,0x0006afa3ad7b28ff,0x0008e26040c4f6ac,0x0000e15c44d0548b,0x0000b32a66e1b005}, {0x0003366f0476ce2b,0x0002f602c7b41f94,0x0004f28097554d95,0x000bea0e35aca652,0x0000688122aad4ed}},
   {{0x0000c8f508efb637,0x0007fabcefc7e8cd,0x00041ab4f9eb5b5c,0x000b2285621f5fb4,0x00009e6c047276a2}, {0x000792ce37a1f698,0x000a83542b6074a4,0x000c20bd3cbd252c,0x00060bf85f65d5b3,0x0000dea6143cfabc}},
   {{0x0001446de6736294,0x000e303c2d2145e2,0x000c868c757f7aa1,0x00067660e99b7f98,0x0000e42f66dcb641}, {0x00084dc910778965,0x000f72c9885b6028,0x0009a5187a0d690c,0x0007eeaeb4da333b,0x0000f789598653c8}},
   {{0x000dd4752b16dba7,0x0005c524c1b12192,0x000383693deefc0e,0x000d97d65ea76ee4,0x00009401711a61b8}, {0x000ace9f21a15cb6,0x00038fee9aeba5f9,0x00077016c73d2616,0x000e066ca844b3e6,0x0000c122b07b7eae}},
   {{0x000dce715f096905,0x0001ddfc0fc9b782,0x000d89fc6508b9b1,0x000b0f4015ab4b65,0x0000e79dab826d5b}, {0x00021f06c775aa2e,0x000b57c7eca164f0,0x0002fa506df09d8c,0x000ec5ba761367ef,0x0000d4ca4773b81e}},
   {{0x000de3610bbb8b54,0x0002c641ada3262e,0x000831ccc0737ce8,0x0006350c94288ae9,0x000087fc1cec065e}, {0x0007ab3b8bb36591,0x000e755e4120b13d,0x000eb0244dea5df3,0x0000a3a9a1857385,0x0000a1b8ea3b7cfe}},
   {{0x000711967b0867ce,0x0007bd3645203b83,0x00030f0e38d5e0d0,0x000bae72dccc1ed9,0x0000fbbcec89f20b}, {0x000fcab0263ad100,0x000dfcd18f8a99cf,0x000f10617d8199e6,0x00084864e2773fe9,0x0000079e8e108704}},
   {{0x000989f8a3422839,0x000c183012e61169,0x0006a90018097799,0x0007fc5ce966cb8a,0x00003b3afef972ac}, {0x0003a2a2db3d5ba7,0x000219bf4fdce689,0x000396673263dc46,0x0002b61852dfc9e0,0x0000ac70895aaf36}},
   {{0x000ce4d5c2f342bb,0x000a052d7aaebb9c,0x00061bcd0bf80907,0x00044ce7f3d3cd21,0x000025b0834b9627}, {0x0008ea56c3a1ddad,0x000a36c92317c5b1,0x0001c4afefe4ec7e,0x000019e787b890ad,0x0000ccd9a92dede8}},
   {{0x000dddadb58da1f8,0x000f38cae6ee9ac6,0x0005c4a4322bbc12,0x0000c746f8bced81,0x0000105a92d79648}, {0x000dbf37a859d51f,0x00054041196b0dc3,0x0001067c9e3ec7ce,0x000dd7e9f64b250d,0x000023213222d1f8}},
   {{0x000619c76497ee80,0x0006c717370e8b5c,0x000cf68e15d2b0ac,0x00079298204cb64f,0x0000bdec21162bc6}, {0x000ccefa63b10110,0x0007e0de1ac56973,0x0000e0c8bf9e3fa9,0x000cb45efb693e3d,0x000037248e9d2d4f}},
},
{/* digit=36 [{1,2,3,..,}]*([2^252]*G)  */
   {{0x0002dc91ec34f9e7,0x0004c38106038080,0x0000cb4f3d8772d3,0x000128cf06d66c53,0x0000be5ed0e3475c}, {0x0003c1931e82b100,0x0007c9ff6b4ccb9e,0x000a1b45ec63d285,0x000bcab92118c692,0x0000aec44147285b}},
   {{0x0009ae71e29a3efb,0x000f9c93302efc18,0x000aae10ecbe906e,0x0009f820107914ce,0x00007a23f35668e1}, {0x00075c2efd2119d3,0x000eccadc9c8e9d8,0x000a1711303198c6,0x00003835591bf64d,0x0000cf0bbf86d443}},
   {{0x0005bb72b7247593,0x000182d4c63aae48,0x0007d6f2c945353e,0x00010952159d07de,0x000089caef37ec5b}, {0x000bb53db65ef147,0x000e6d99de434a8e,0x000f2405f2dc2cb7,0x0008a3116fa3ed83,0x00003429bba31420}},
   {{0x000d590b01e6e274,0x000da180b2dcb618,0x000aea4a9047e2cc,0x0003a491b299b504,0x000012c9e1edfa40}, {0x0008a36794075521,0x0006e332b8e388d2,0x00068de1949c5013,0x000b972a1b6fcce6,0x000078851bc85122}},
   {{0x0003752fb85fa4ca,0x000d983c8ce9b1e1,0x000f74daed61257c,0x000bbb343da670d2,0x000035aa2405f846}, {0x000235d4421fc835,0x00007363473b5e74,0x0004aa158f6df8ee,0x00022de4d7f52a3c,0x00000d05aabebc6d}},
   {{0x000e735a64785f45,0x000b0f29cd078c56,0x000e35067bc56637,0x00027003b2bb803e,0x00000235a102c919}, {0x000b6d8f2c4aa658,0x00010396023b191a,0x000f805bac347583,0x00080f00400ba5f0,0x0000881065bdec0f}},
   {{0x000e522cc1b5e838,0x0001060b8bfbc370,0x000b256dfde2d4ad,0x0009972d364df067,0x0000f12502f60138}, {0x000a0dc7783920a0,0x000dc0bc866a503f,0x000064ba6e80014a,0x000ba53f89b744d3,0x00003511dcdcba5d}},
   {{0x000d46d95a7b1a29,0x0005ac6341fb197d,0x0004c2ece9c4e7ad,0x000f89b26eca2948,0x0000211e48a6e7f4}, {0x0007f6ec78ef1f42,0x000fe65745861499,0x0003eede82b2c090,0x000017f7286a6e1c,0x00005f92e472f60e}},
   {{0x000564631890a36e,0x000f77feea5b805c,0x0003c3030703ef5f,0x000738589f747caf,0x00000e5daec34dd3}, {0x000a4c3c9c9f1554,0x000675393962fe24,0x00020bf297e4bf17,0x000c3af7183de2af,0x0000a1bd7b6395a8}},
   {{0x000969946191d3d6,0x000d1b87f257a83b,0x000107588281fc8d,0x000fe8518e2c1354,0x0000372def7fb2ba}, {0x000bb480d8972cae,0x000676167a3fdaf4,0x000310cf43f2dd4b,0x0000a93eace32d84,0x00003bcefb0c4270}},
   {{0x000691ed785e73d3,0x0005fea604675fe5,0x000c6514aa5db5ab,0x000664d2e23d41df,0x00005e8048f103c3}, {0x000118f1adaa0f81,0x000574ce1a5a3f8b,0x0006646b828ec3b4,0x00040fd8cacc6e2c,0x0000343d185ebd0e}},
   {{0x000f844caaa358cb,0x0003e924182ae5d7,0x000875d9a1a1db7e,0x000ec8264cd42d9c,0x000037b515fb42ee}, {0x000d4097b165fbe5,0x00099206eff34d4d,0x000b7e17efc322ed,0x000a002dee410259,0x00005a481c0d236c}},
   {{0x0005312c23fc9759,0x000575d6297b8c88,0x0008edd391571580,0x000e521078868ef7,0x000056b31e093c45}, {0x00075d5ff7b33a68,0x00098c7e673f4702,0x0002f2598c8d5dc3,0x000974c19227b47e,0x0000b37b634cc14a}},
   {{0x0007ed68b11888c9,0x000df03e25dcd066,0x00087a24a5e0e8c3,0x000322a4e5d0dcb9,0x0000f40ac3c3e920}, {0x000de9534e0f63a7,0x0001fb6328f95463,0x00064f1b7a128bf9,0x000e34d91ccd7cda,0x0000ef1ec28347bd}},
   {{0x000240fa36a27378,0x0005e3621bc1a857,0x000fb689735dc136,0x00019cfa3a6453d4,0x00000f1a43a49293}, {0x000274bf8cb0ba05,0x00063078c5ebfc18,0x00001d0efb0b5376,0x00009cab0d49241e,0x00000d7c67d872ab}},
   {{0x00070af3aeac968f,0x0008d4b63266b4e3,0x000ac5664e4f7fee,0x000cbec4acd4c2e3,0x00008910bd3beb38}, {0x000e50cc9c0726e3,0x0009a97b40bf1c3a,0x0005a5a1b1530956,0x0004cd40884b7ffd,0x0000890896b1f831}},
   {{0x000515ca5618c937,0x000b07d942d158e1,0x000f767a8e665432,0x000110432181bfb6,0x000053794e8aa604}, {0x000eb7ce8c0dbccf,0x0002698673a309af,0x00046db0031e0261,0x000b276d98e5577d,0x0000c21fb8d8d985}},
   {{0x0000116b0843e0bb,0x0007b9b04531c904,0x000d7d83053b1b3a,0x0007e82d1649f085,0x0000b3bcc887b742}, {0x0001100c93dce831,0x000191922a2a7726,0x000149ce87e79da6,0x000c83487a2b02f3,0x000047e1384ee92e}},
   {{0x00083d3af077f30f,0x00031658b53a484c,0x0007aec53ea78f84,0x00077ca12076c202,0x000034714e483c81}, {0x0005d15c2376c840,0x00093d1aa78337ef,0x000852a908315b65,0x000bd43a75c484ef,0x0000ba0c58a16086}},
   {{0x0008d7a529a6d482,0x000da2f192032968,0x0002e2df99c7f250,0x0001bbf23042fb68,0x0000b7587e7cd812}, {0x0000233e0182a650,0x0007e3e1128a30fc,0x000fb098fb82ecf8,0x0006a77168286193,0x000043e21ae85e9e}},
   {{0x00049d666c834ea0,0x000847414287ab5b,0x0009a2a473be43e1,0x000f3cf40fb85921,0x0000e6559e9cc58d}, {0x000fe8e0c6615b48,0x000cd6459d70fe1d,0x000de038614abc8f,0x000c7bfbe0fa8e05,0x0000e63ef6969035}},
   {{0x00001b453b31e91a,0x0003a436b4d81164,0x0007afd660cba7ad,0x0004c3f151f9a010,0x0000faca8d0bf0ee}, {0x0005c1d9ee9761ca,0x000b50c0588f75fe,0x00004804c3497a16,0x0000b89ee2bebd03,0x00008fb9a6162c99}},
   {{0x00032fe392511143,0x000c9ac73366d14d,0x000a7495c36bf25b,0x00048b99562c66db,0x000024d301b76ad3}, {0x000620cd670407e5,0x000193733a019f46,0x000c324e00ea8d4f,0x0007cd8396d532b0,0x0000b211a0e53c31}},
   {{0x0007d205ffe7b376,0x000ab747d2da090d,0x0004fc5193b7f3ef,0x00071e42cb525fb5,0x0000e220933566a9}, {0x00060dfb486d440d,0x00056fe13465ddc1,0x000e4c1517fcfec4,0x0002b4b3da7e4e76,0x00006fa48a2a8d30}},
   {{0x0004f265872cd88f,0x000b378b90a1c630,0x000f0bc1c806c1d3,0x000d5b4553e725ca,0x0000f59e604ab9d8}, {0x0000f327a0b85dd7,0x000a23ecc217a455,0x000d62213dec5720,0x0009549b88b74169,0x0000212f245cb365}},
   {{0x0004111b5cae787e,0x00073dfd31242076,0x00075aefb13cb7f5,0x0007744dca77da11,0x0000b75466cdfaae}, {0x0006f3bdb6cff322,0x000a41fcda9a74d7,0x00025028b7440f37,0x000f28fbb3ac92b5,0x00000fbf8f7c1975}},
   {{0x00092e1df83097f7,0x000be54b08009826,0x000ce2f2f28738f6,0x0001946c703717a2,0x0000913b93cb0814}, {0x00045931fe896366,0x000f978834a60492,0x00014a5a17b98443,0x000f4bb1c6ab0151,0x00000deb3845fba5}},
   {{0x00054c601a982e6c,0x00007491cd264caa,0x000bd6b051dd35e1,0x000723d73c315f7c,0x0000ab0077612494}, {0x0009b1f6565e15ae,0x0008ac8fb0260465,0x000a0de37bf30f52,0x0001141c21641ba8,0x00009c7a367da5e5}},
   {{0x0009ca552f03ad8b,0x0008524e35c0db84,0x000c3c789c7e8dbe,0x000261f1a2bbaccf,0x0000f733e7e4c26f}, {0x000fbf5b8444823a,0x0007cbf8483b882f,0x000bef640b7224e8,0x0008ccb3023b8b65,0x0000abfec9274d5f}},
   {{0x0001510079ea1bd1,0x000cc05d5d26a40e,0x000e68d4f1ad9add,0x00003fcb3f2eab13,0x0000cff1ae2740f8}, {0x000b749d4cee1172,0x000b2036d909e0e7,0x0004d4c388e9f275,0x0000fcae34e31d8f,0x00002b37f69f7513}},
   {{0x000f1fdb40146044,0x00094941507883e0,0x000792efea8ce991,0x00015b42375b7541,0x0000f59bf5cd7d45}, {0x000324f923a277d8,0x000ce50f3406ac4f,0x00039bc51d9bc9b7,0x00008f46fa87d18a,0x00002588530dccc1}},
   {{0x0003c9f82e4c6346,0x0003da4464f85ced,0x0001dca258efb831,0x00012b8706381b7a,0x0000cd15a3cba2a4}, {0x000a8fdbfcd8fb51,0x000f5e54cd229347,0x000d8932f31db2ee,0x0001afb4aeb11ef8,0x00001e7c1ed44441}},
   {{0x000050cdc9a151e9,0x0007abb0a8592653,0x0005691e79edbfc0,0x00019a026c81c7fd,0x0000c1b2342ff390}, {0x0001c8b7f8474b9c,0x00064176181964a8,0x000e0375a90657c0,0x00047c790b333155,0x0000676c62776ebc}},
   {{0x0003247b7d6dee80,0x0007796593135162,0x000ab35ed0948d92,0x00040899700161e9,0x00006cc32b48ddde}, {0x000d664061ef338c,0x00020202e9ed6f2f,0x0009ba99b1606fa0,0x000f6895388bc192,0x00004428c5ede81d}},
   {{0x00028aef91b0b2ab,0x0003403dfd3fce20,0x000ffe8edce870a2,0x000bffb6ec2c870a,0x0000205fb46d84d0}, {0x000ffe744cefa48d,0x0007d19876d7bf5d,0x000b72863b6fc37a,0x00074eeecfa84c08,0x00007205ff5f5763}},
   {{0x0000d328887de41e,0x000ba69ea5348033,0x00056ea175de0df0,0x000a7733f427533c,0x0000b1f606a252b1}, {0x0004396e30ea15cb,0x0001114941255047,0x0006bb38f575816a,0x0000f70e1ce55bfe,0x0000901a94946ae3}},
   {{0x0000f08d8fc35489,0x0000473bfd08e5af,0x000fe655a5010b5d,0x0009fd093d288053,0x00009f2630bac130}, {0x0007bafb4e3b76fc,0x000bf840784bd867,0x0000092ce14e51dd,0x00020e726c750cbf,0x000083d306cb5283}},
   {{0x000671577d4715c5,0x00091b703235c445,0x00069e986d30019f,0x000c27d07ccb2ed6,0x00007c824b046dbf}, {0x000532fd8f92a230,0x00049bb98fd2f0eb,0x000e6199a4a557fd,0x0001eda57acea7c1,0x0000c6638208b94b}},
   {{0x000be8ff83a92661,0x0006f101bd459b42,0x000bd9cebc7741c9,0x00074485770c1107,0x0000f50250a9b2e0}, {0x000eec81477b6547,0x000da5efe59af762,0x00046a897c65b900,0x000d7c18c9614895,0x0000e8025b4330b4}},
   {{0x00065ef12045cf9f,0x000eaccce8bdae40,0x000cf65256fcb2ca,0x0003112fa0ba4ef2,0x0000683125ebb72c}, {0x000a4eae312410e0,0x00076cd8e830a01d,0x000fb3f0767e2867,0x0009a5abd9575298,0x00005f11e11eef64}},
   {{0x000faef9d3472c26,0x0007677d1345ba47,0x00015afee3adff69,0x000461e761fa04dd,0x00004f1f61b19e69}, {0x0001fab9bfb9093f,0x000eb1133dfefa69,0x000cc710d3df8ae8,0x000e78dd5f896758,0x0000bb88d5106c7f}},
   {{0x0001b4ce88c50d10,0x0007a8771c4f8e01,0x000278ee47532e80,0x00072a64c78a48e2,0x0000b283e8338450}, {0x000f29149e692749,0x00078868b21c98a6,0x000a8908eb96e966,0x00029ca8f0adc2b1,0x00000afcff7afeb8}},
   {{0x000a383210b08568,0x00025ef048899915,0x00064d509a5a8060,0x000f6f000e9af97c,0x00001382d0c38996}, {0x000ba5381927e27e,0x00016af50182490e,0x000ad62ce46c63b3,0x000735984c5fd9d3,0x00004fa1871d8ae8}},
   {{0x000d0bcd7466b255,0x000a8b235c654ec9,0x0003c168884ddbe1,0x0007470e2645ee16,0x000070bd00e50eba}, {0x000b629128bfa0f9,0x000cdc1d3b68fa51,0x0006778b192fce1b,0x0002baae7361dcb6,0x0000c7d249de561d}},
   {{0x00028bf0bbc6229b,0x000e2fd91497a40b,0x00083df051c83c05,0x000c9caf9f5154f0,0x0000ac38b3d9ee66}, {0x000b7e3ec0dfcfd2,0x000e6b0a8416f71d,0x00012aa66f2ecda8,0x00027232fddd8678,0x0000896ef106e6f4}},
   {{0x000186a0fe9a745f,0x000c59ca70dbff27,0x0001cac4908249fc,0x000f568425a2e644,0x00004a0885bdce5f}, {0x000b7317d7ead588,0x00059898d1046e2c,0x0002c9a89f96cf7d,0x0005bc2fe67c9d4f,0x00009895a509c7bf}},
   {{0x000b8e5573cecfa3,0x000ea15f03e6dc7c,0x00008442066497ea,0x0002b03bc0de693f,0x000023b9b36dcd53}, {0x000390a0115a3c12,0x000b0d65ca0ecfed,0x000530c789414c40,0x0008f2441406bd2f,0x00009369a44a3343}},
   {{0x00084f5903fa2711,0x0002a9da921e9968,0x000b01e54e6da0fd,0x00014e96f2f2695d,0x0000ee3e9bd78762}, {0x000181ce27a94979,0x0003fe215e04a26e,0x0002cabca36d254e,0x000613b2f32a6c25,0x0000948148810b57}},
   {{0x000fe6940d9cae17,0x000fa1a10f094c4d,0x00091b64b0586957,0x00053b5a287b5734,0x00007862d5dafd4a}, {0x000856e503491266,0x000111c5268fbf94,0x000b650a62be30bd,0x0009fcb0393f19cb,0x000039531fed78cf}},
   {{0x0006a11b29353593,0x00067f8c126e0255,0x00060167fda38aa9,0x0001cd17dbe6c209,0x00007bbabb680190}, {0x00079e02c9477784,0x00053a1a1dc6b6e9,0x0009faf0cd69a517,0x0005f083ed50959d,0x0000dd9c0965d5fa}},
   {{0x000304d64f16ea85,0x00062e718623a0c4,0x00067f03e8b1cac1,0x000c00bb5765467c,0x000059cf5ae1bd88}, {0x00077bb0e2af19ae,0x0000c1228c920748,0x0006e89201f717ec,0x00080390bcb80032,0x0000c6e2c5d2f312}},
   {{0x000ea7d3fca4752b,0x00087211f62a426a,0x000e7b6b5f12c094,0x00027c74beecd87b,0x000077eaf4ce6d7a}, {0x0002781fda78fd37,0x000fb64eeabe154c,0x000fe2bc4848a83a,0x000c2a11287ef04f,0x0000b6d88c726b6f}},
   {{0x000b947ce417d99b,0x0002db916cc4805f,0x0002733234b93dcc,0x00086dc2e65bb321,0x0000cc1bade1ea98}, {0x00030114bc5ee855,0x0004718ee1e40e22,0x000bcf1f1a561be7,0x000489262fd2d4a6,0x00000e6a5a4e5231}},
   {{0x000001fa00b500bb,0x000bad7dcdf5ca96,0x000446a855c098cf,0x000c61f64e2d2e8c,0x0000ae9bcf2471f3}, {0x00026838435a2c5b,0x000b9bad46434ec2,0x000ccf4e38ceaed6,0x00021e39f8fb47cc,0x0000d4f3fa4cce3b}},
   {{0x000b110a3db32927,0x000a4536c66ad79f,0x00049e6a9e28a37d,0x0008e2b79ce87b8e,0x00000ccfe8e6dcec}, {0x000e4e03ba464b2d,0x000ddca9a3982193,0x0002c12ab0f39d60,0x0000f6ad7932aff8,0x00008ff50ee61e7e}},
   {{0x0001058fa28a7e00,0x00050bf5ec74ea96,0x000229666c726cf2,0x000799e74d55c8db,0x0000bd9abbfa57f5}, {0x000ef074dfc47b3a,0x00026c52f91d7479,0x000a8bde2d9c65fc,0x00027fee0283fe36,0x000032a8b5f1d4b7}},
   {{0x0007c6112e832330,0x0002dcc9bf286a67,0x000780f610fbb351,0x00089c562e8ea50d,0x0000db8b22b1dc4e}, {0x000d1fb89be01445,0x00067a57113b0a6f,0x00009c91c8c77d24,0x00024bf639075dff,0x0000b47b17fa0608}},
   {{0x000a2b016287b52d,0x000000cd8eb058ae,0x000d58573a134352,0x0008ad9148b4d0c5,0x0000d2b6170f91c6}, {0x00039291da3b3b75,0x0008b8c4ac10a61b,0x00017d5835f946d7,0x000e5df105d4a572,0x0000061da3d75e6d}},
   {{0x000940dec1b49919,0x0000a6f485ae3113,0x0001a2ee0f12195e,0x00096e17507fb273,0x00005057a8efe9e1}, {0x000c9112e1301367,0x0005c3c60d15a3c2,0x00000ee2b97dfbb3,0x0008b85af3c581b3,0x00007f25d9164bac}},
   {{0x0004f986d840cd64,0x0000a634288cdb1c,0x000c8a161471d62c,0x000ae24ec2f85ece,0x00001f37cbd3a6f4}, {0x000a20f4b7099851,0x000bdfa8985b6793,0x0008e64467a7bd33,0x0007c11c6a3fbd93,0x000090426193a8d4}},
   {{0x0008667cc36975fb,0x0007ed5f1dfb1684,0x0003baa9402acf16,0x00066fb2d41ad461,0x000056fbb934f684}, {0x0000d0de9e405698,0x000eb5489fefce61,0x000f18b977b99c65,0x000eda8c88ad1b3d,0x00001b7d9bedd0e9}},
   {{0x00018c0c716cc0a1,0x000075691c49d852,0x000356ac6f4b5ff9,0x000a7a94fd666bce,0x00007c728955b327}, {0x0005085da6be7de9,0x000da301d34ef93d,0x000f448e8ff71530,0x000ff9bcd96442d8,0x0000283d331bed18}},
   {{0x000dd992a8498705,0x000af15763354d33,0x0009be0e5a716964,0x000632af5e3a9b17,0x0000b9d6b1bd3b13}, {0x000d7d4a52f313bc,0x000fa37a46603b8b,0x0003e218fc9dd959,0x000a3b700359620b,0x0000e1481a487b28}},
   {{0x000b43a43228d831,0x00003ad63f99ab41,0x000a5122924ae1c3,0x0002b47e525f1a46,0x00004af860fdd26d}, {0x000ef613f714aa18,0x000d6b78795ed6ba,0x000a9d694f51865a,0x00052753e21fcee6,0x00002ceb1de0a37b}},
}
};

#endif /* IFMA_ECPRECOMP7_P256_H */
