#!/bin/sh
#
# This script file generates necessary defines for ffmpeg compilation
# As it has got a little bit tricky it must be carefully checked
# which codecs are checked by ffmpeg.m4 file

source_path=ffmpeg
result_file="include/configff.h"

gendefine() {
    prune="$1"
    shift
    for i in "$@"
    do
	#test $prune -eq 1 && 
        echo "#define CONFIG_"`echo $i | tr a-z A-Z`" $prune"
        #echo "#define ENABLE_"`echo $i | tr a-z A-Z`" $prune"
    done
}

prune() {
    pattern="$1"
    shift
    echo "$@" | sed "s%\\<$pattern\\>%%g"
}

haspattern() {
    pattern="$1"
    shift
    echo "$@" | grep $pattern >/dev/null
}

createlist() {

ENCODER_LIST=`sed -n 's/^[^#]*ENC.*(.*, *\(.*\)).*/\1_encoder/p' "$source_path/libavcodec/allcodecs.c"`
DECODER_LIST=`sed -n 's/^[^#]*DEC.*(.*, *\(.*\)).*/\1_decoder/p' "$source_path/libavcodec/allcodecs.c"`
HWACCEL_LIST=`sed -n 's/^[^#]*HWACCEL.*(.*, *\(.*\)).*/\1_hwaccel/p' "$source_path/libavcodec/allcodecs.c"`
PARSER_LIST=`sed -n 's/^[^#]*PARSER.*(.*, *\(.*\)).*/\1_parser/p' "$source_path/libavcodec/allcodecs.c"`
BSF_LIST=`sed -n 's/^[^#]*BSF.*(.*, *\(.*\)).*/\1_bsf/p' "$source_path/libavcodec/allcodecs.c"`
MUXER_LIST=`sed -n 's/^[^#]*_MUX.*(.*, *\(.*\)).*/\1_muxer/p' "$source_path/libavformat/allformats.c"`
DEMUXER_LIST=`sed -n 's/^[^#]*DEMUX.*(.*, *\(.*\)).*/\1_demuxer/p' "$source_path/libavformat/allformats.c"`
OUTDEV_LIST=`sed -n 's/^[^#]*_MUX.*(.*, *\(.*\)).*/\1_muxer/p' "$source_path/libavdevice/alldevices.c"`
INDEV_LIST=`sed -n 's/^[^#]*DEMUX.*(.*, *\(.*\)).*/\1_demuxer/p' "$source_path/libavdevice/alldevices.c"`
PROTOCOL_LIST=`sed -n 's/^[^#]*PROTOCOL.*(.*, *\(.*\)).*/\1_protocol/p' "$source_path/libavformat/allformats.c"`

#echo $BSF_LIST
DETECT_ENCODER="png flashsv zmbv"
PRUNE_ENCODER="\
 libamr_nb\
 libamr_wb\
 libdirac\
 libfaac\
 libgsm\
 libgsm_ms\
 libmp3lame\
 libschroedinger\
 libtheora\
 libvorbis\
 libx264\
 libxvid\
 oggvorbis\
 snow\
 "
DETECT_DECODER="\
 libfaad\
 libopenjpeg\
 mpeg4aac\
 dxa\
 flashsv\
 png\
 tscc\
 zmbv\
 "
PRUNE_DECODER="\
 libamr_nb\
 libamr_wb\
 libdirac\
 libgsm\
 libgsm_ms\
 libschroedinger\
 libspeex\
 libvorbis\
 libxvid\
 mpeg_xvmc\
 oggvorbis\
 snow\
 xvmc\
 h264_vdpau\
 mpeg_vdpau\
 mpeg1_vdpau\
 vc1_vdpau\
 wmv3_vdpau\
 "
DETECT_HWACCEL=
PRUNE_HWACCEL="h263_vaapi mpeg2_vaapi mpeg4_vaapi vc1_vaapi wmv3_vaapi"
DETECT_PARSER=
PRUNE_PARSER=
DETECT_BSF=
PRUNE_BSF=
DETECT_MUXER="oss"
PRUNE_MUXER="libnut ogg"
DETECT_DEMUXER="oss"
PRUNE_DEMUXER="libnut ogg avisynth vc1t"
DETECT_PROTOCOL=
PRUNE_PROTOCOL=
DETECT_OUTDEV="oss dv1394 libdc1394"
PRUNE_OUTDEV="alsa bktr audio_beos"
DETECT_INDEV="oss dv1394 libdc1394"
PRUNE_INDEV="alsa bktr audio_beos jack vfwcap x11_grab_device"

for i in $DETECT_ENCODER $PRUNE_ENCODER; do
    ENCODER_LIST=`prune ${i}_encoder $ENCODER_LIST`
    haspattern $i $DETECT_ENCODER || ENCODER_PRUNE="$ENCODER_PRUNE ${i}_encoder"
done

for i in $DETECT_DECODER $PRUNE_DECODER; do
    DECODER_LIST=`prune ${i}_decoder $DECODER_LIST`
    haspattern $i $DETECT_DECODER || DECODER_PRUNE="$DECODER_PRUNE ${i}_decoder"
done

for i in $DETECT_HWACCEL $PRUNE_HWACCEL; do
    HWACCEL_LIST=`prune ${i}_hwaccel $HWACCEL_LIST`
    haspattern $i $DETECT_HWACCEL || HWACCEL_PRUNE="$HWACCEL_PRUNE ${i}_hwaccel"
done

for i in $DETECT_PARSER $PRUNE_PARSER; do
    PARSER_LIST=`prune ${i}_parser $PARSER_LIST`
    haspattern $i $DETECT_PARSER || PARSER_PRUNE="$PARSER_PRUNE ${i}_parser"
done

for i in $DETECT_BSF $PRUNE_BSF; do
    BSF_LIST=`prune ${i}_bsf $BSF_LIST`
    haspattern $i $DETECT_BSF || BSF_PRUNE="$BSF_PRUNE ${i}_bsf"
done

for i in $DETECT_MUXER $PRUNE_MUXER; do
    MUXER_LIST=`prune ${i}_muxer $MUXER_LIST`
    haspattern $i $DETECT_MUXER || MUXER_PRUNE="$MUXER_PRUNE ${i}_muxer"
done

for i in $DETECT_DEMUXER $PRUNE_DEMUXER; do
    DEMUXER_LIST=`prune ${i}_demuxer $DEMUXER_LIST`
    haspattern $i $DETECT_DEMUXER || DEMUXER_PRUNE="$DEMUXER_PRUNE ${i}_demuxer"
done

for i in $DETECT_PROTOCOL $PRUNE_PROTOCOL; do
    PROTOCOL_LIST=`prune ${i}_protocol $PROTOCOL_LIST`
    haspattern $i $DETECT_PROTOCOL || PROTOCOL_PRUNE="$PROTOCOL_PRUNE ${i}_protocol"
done

for i in $DETECT_OUTDEV $PRUNE_OUTDEV; do
    OUTDEV_LIST=`prune ${i}_muxer $OUTDEV_LIST`
    haspattern $i $DETECT_OUTDEV || OUTDEV_PRUNE="$OUTDEV_PRUNE ${i}_muxer"
done

for i in $DETECT_INDEV $PRUNE_INDEV; do
    INDEV_LIST=`prune ${i}_demuxer $INDEV_LIST`
    haspattern $i $DETECT_INDEV || INDEV_PRUNE="$INDEV_PRUNE ${i}_demuxer"
done

cat <<_ACEOF
/*
 * This file is generated by the script: admin/gendefs.sh
 * Do not modify it by hand!
 */

#define ENABLE_VHOOK 0
_ACEOF

gendefine 1 $DECODER_LIST
gendefine 0 $DECODER_PRUNE

gendefine 1 $DEMUXER_LIST
gendefine 0 $DEMUXER_PRUNE

gendefine 1 $HWACCEL_LIST
gendefine 0 $HWACCEL_PRUNE

gendefine 1 $PARSER_LIST
gendefine 0 $PARSER_PRUNE

gendefine 1 $BSF_LIST
gendefine 0 $BSF_PRUNE

gendefine 1 $ENCODER_LIST
gendefine 0 $ENCODER_PRUNE

gendefine 1 $MUXER_LIST
gendefine 0 $MUXER_PRUNE

gendefine 1 $PROTOCOL_LIST
gendefine 0 $PROTOCOL_PRUNE

gendefine 1 $OUTDEV_LIST
gendefine 0 $OUTDEV_PRUNE

gendefine 1 $INDEV_LIST
gendefine 0 $INDEV_PRUNE

echo

}

echo -n "Creating list of $result_file, wait..."
createlist >$result_file
echo "done"
