/*
* luainternals.c
* Code quoted from MIT-licensed Lua 5.1.4 internals
* See copyright notice in lua.h
*/

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <lua.h>
#include <lauxlib.h>

#ifdef __cplusplus
}
#endif /* __cplusplus */

#include "luainternals.h"

/*
* BEGIN COPY-PASTE FROM Lua 5.1.4 llimits.h
*/

/* chars used as small naturals (so that `char' is reserved for characters) */
typedef unsigned char lu_byte;

/*
* END COPY-PASTE FROM Lua 5.1.4 llimits.h
*/

/*
* BEGIN COPY-PASTE FROM Lua 5.1.4 lobject.c
*/

int luaO_log2 (unsigned int x) {
  static const lu_byte log_2[256] = {
    0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
    6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
  };
  int l = -1;
  while (x >= 256) { l += 8; x >>= 8; }
  return l + log_2[x];

}

/*
* END COPY-PASTE FROM Lua 5.1.4 lobject.c
*/
