use std::path::PathBuf;

xflags::xflags! {
    src "src/flags.rs"

    /// Chewing command-line tools.
    cmd chewing-cli {
        /// Create a new dictionary file suitable for system dictionary.
        cmd init-database {
            /// Choose the underlying database implementation, must be one of 'trie', 'cdb', or 'sqlite'.
            optional -t,--db_type db_type: String
            /// Name of the phrase dictionary.
            optional -n,--name name: String
            /// Copyright information of the dictionary.
            optional -c,--copyright copyright: String
            /// License information of the dictionary.
            optional -l,--license license: String
            /// Version of the dictionary.
            optional -r,--version version: String
            /// Keep single word frequency.
            optional -k,--keep_word_freq
            /// Read the dictionary source as CSV with header.
            optional --csv
            /// Path to the dictionary source file.
            required tsi_src: PathBuf
            /// Path to the output file.
            required output: PathBuf
        }
        /// Display information about the dictionary.
        cmd info {
            /// Location of the dictionary file.
            required path: PathBuf
            /// Output in JSON format.
            optional -j,--json
        }
        /// Dump the dictionary entries into tsi.src formatted stream.
        cmd dump {
            /// Location of the dictionary file.
            required path: PathBuf
            /// Output CSV format.
            optional --csv
        }
    }
}

impl InitDatabase {
    pub fn db_type_or_default(&self) -> String {
        self.db_type.clone().unwrap_or("trie".to_string())
    }
    pub fn name_or_default(&self) -> String {
        self.name.clone().unwrap_or("我的詞庫".to_string())
    }
    pub fn copyright_or_default(&self) -> String {
        self.copyright.clone().unwrap_or("Unknown".to_string())
    }
    pub fn license_or_default(&self) -> String {
        self.license.clone().unwrap_or("Unknown".to_string())
    }
    pub fn version_or_default(&self) -> String {
        self.version.clone().unwrap_or("1.0.0".to_string())
    }
}

// generated start
// The following code is generated by `xflags` macro.
// Run `env UPDATE_XFLAGS=1 cargo build` to regenerate.
#[derive(Debug)]
pub struct ChewingCli {
    pub subcommand: ChewingCliCmd,
}

#[derive(Debug)]
pub enum ChewingCliCmd {
    InitDatabase(InitDatabase),
    Info(Info),
    Dump(Dump),
}

#[derive(Debug)]
pub struct InitDatabase {
    pub tsi_src: PathBuf,
    pub output: PathBuf,

    pub db_type: Option<String>,
    pub name: Option<String>,
    pub copyright: Option<String>,
    pub license: Option<String>,
    pub version: Option<String>,
    pub keep_word_freq: bool,
    pub csv: bool,
}

#[derive(Debug)]
pub struct Info {
    pub path: PathBuf,

    pub json: bool,
}

#[derive(Debug)]
pub struct Dump {
    pub path: PathBuf,

    pub csv: bool,
}

impl ChewingCli {
    #[allow(dead_code)]
    pub fn from_env_or_exit() -> Self {
        Self::from_env_or_exit_()
    }

    #[allow(dead_code)]
    pub fn from_env() -> xflags::Result<Self> {
        Self::from_env_()
    }

    #[allow(dead_code)]
    pub fn from_vec(args: Vec<std::ffi::OsString>) -> xflags::Result<Self> {
        Self::from_vec_(args)
    }
}
// generated end
