/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.zeroc.Ice.Current;
import com.zeroc.IceGrid.AdapterInfo;
import com.zeroc.IceGrid.AdapterObserver;
import com.zeroc.IceGridGUI.Coordinator;
import javax.swing.SwingUtilities;

class AdapterObserverI
implements AdapterObserver {
    private final Coordinator _coordinator;
    private final boolean _trace;

    AdapterObserverI(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._trace = coordinator.traceObservers();
    }

    @Override
    public synchronized void adapterInit(AdapterInfo[] adapters, Current current) {
        if (this._trace) {
            if (adapters.length == 0) {
                this._coordinator.traceObserver("adapterInit (no adapter)");
            } else {
                String names = "";
                for (AdapterInfo info : adapters) {
                    names = names + " " + info.id;
                }
                this._coordinator.traceObserver("adapterInit for adapters" + names);
            }
        }
        SwingUtilities.invokeLater(() -> this._coordinator.adapterInit(adapters));
    }

    @Override
    public void adapterAdded(AdapterInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("adapterAdded for adapter " + info.id);
        }
        SwingUtilities.invokeLater(() -> this._coordinator.adapterAdded(info));
    }

    @Override
    public void adapterUpdated(AdapterInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("adapterUpdated for adapter " + info.id);
        }
        SwingUtilities.invokeLater(() -> this._coordinator.adapterUpdated(info));
    }

    @Override
    public void adapterRemoved(String id, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("adapterRemoved for adapter " + id);
        }
        SwingUtilities.invokeLater(() -> this._coordinator.adapterRemoved(id));
    }
}

