"use strict";
const createLanguageServicePlugin_1 = require("@volar/typescript/lib/quickstart/createLanguageServicePlugin");
const vue = require("@vue/language-core");
const common_1 = require("./lib/common");
const collectExtractProps_1 = require("./lib/requests/collectExtractProps");
const getComponentDirectives_1 = require("./lib/requests/getComponentDirectives");
const getComponentEvents_1 = require("./lib/requests/getComponentEvents");
const getComponentNames_1 = require("./lib/requests/getComponentNames");
const getComponentProps_1 = require("./lib/requests/getComponentProps");
const getComponentSlots_1 = require("./lib/requests/getComponentSlots");
const getElementAttrs_1 = require("./lib/requests/getElementAttrs");
const getElementNames_1 = require("./lib/requests/getElementNames");
const getImportPathForFile_1 = require("./lib/requests/getImportPathForFile");
const getPropertiesAtLocation_1 = require("./lib/requests/getPropertiesAtLocation");
const windowsPathReg = /\\/g;
const project2Service = new WeakMap();
module.exports = (0, createLanguageServicePlugin_1.createLanguageServicePlugin)((ts, info) => {
    const vueOptions = getVueCompilerOptions();
    vue.writeGlobalTypes(vueOptions, ts.sys.writeFile);
    const languagePlugin = vue.createVueLanguagePlugin(ts, info.languageServiceHost.getCompilationSettings(), vueOptions, id => id);
    addVueCommands();
    return {
        languagePlugins: [languagePlugin],
        setup: language => {
            project2Service.set(info.project, [language, info.languageServiceHost, info.languageService]);
            info.languageService = (0, common_1.createVueLanguageServiceProxy)(ts, language, info.languageService, vueOptions);
            // #3963
            const timer = setInterval(() => {
                if (info.project['program']) {
                    clearInterval(timer);
                    info.project['program'].__vue__ = { language };
                }
            }, 50);
        },
    };
    function getVueCompilerOptions() {
        if (info.project.projectKind === ts.server.ProjectKind.Configured) {
            const tsconfig = info.project.getProjectName();
            return vue.createParsedCommandLine(ts, ts.sys, tsconfig.replace(windowsPathReg, '/')).vueOptions;
        }
        else {
            return vue.createParsedCommandLineByJson(ts, ts.sys, info.languageServiceHost.getCurrentDirectory(), {})
                .vueOptions;
        }
    }
    // https://github.com/JetBrains/intellij-plugins/blob/6435723ad88fa296b41144162ebe3b8513f4949b/Angular/src-js/angular-service/src/index.ts#L69
    function addVueCommands() {
        const projectService = info.project.projectService;
        projectService.logger.info('Vue: called handler processing ' + info.project.projectKind);
        const session = info.session;
        if (!session) {
            projectService.logger.info('Vue: there is no session in info.');
            return;
        }
        if (!session.addProtocolHandler) {
            // addProtocolHandler was introduced in TS 4.4 or 4.5 in 2021, see https://github.com/microsoft/TypeScript/issues/43893
            projectService.logger.info('Vue: there is no addProtocolHandler method.');
            return;
        }
        if (session.handlers.has('_vue:projectInfo')) {
            return;
        }
        session.addProtocolHandler('_vue:projectInfo', ({ arguments: args }) => {
            return session.handlers.get('projectInfo')?.({ arguments: args });
        });
        session.addProtocolHandler('_vue:documentHighlights-full', ({ arguments: args }) => {
            return session.handlers.get('documentHighlights-full')?.({ arguments: args });
        });
        session.addProtocolHandler('_vue:encodedSemanticClassifications-full', ({ arguments: args }) => {
            return session.handlers.get('encodedSemanticClassifications-full')?.({ arguments: args });
        });
        session.addProtocolHandler('_vue:quickinfo', ({ arguments: args }) => {
            return session.handlers.get('quickinfo')?.({ arguments: args });
        });
        session.addProtocolHandler('_vue:collectExtractProps', ({ arguments: args }) => {
            return {
                response: collectExtractProps_1.collectExtractProps.apply(getRequestContext(args[0]), args),
            };
        });
        session.addProtocolHandler('_vue:getImportPathForFile', ({ arguments: args }) => {
            return {
                response: getImportPathForFile_1.getImportPathForFile.apply(getRequestContext(args[0]), args),
            };
        });
        session.addProtocolHandler('_vue:getPropertiesAtLocation', ({ arguments: args }) => {
            return {
                response: getPropertiesAtLocation_1.getPropertiesAtLocation.apply(getRequestContext(args[0]), args),
            };
        });
        session.addProtocolHandler('_vue:getComponentDirectives', ({ arguments: args }) => {
            return {
                response: getComponentDirectives_1.getComponentDirectives.apply(getRequestContext(args[0]), args),
            };
        });
        session.addProtocolHandler('_vue:getComponentEvents', ({ arguments: args }) => {
            return {
                response: getComponentEvents_1.getComponentEvents.apply(getRequestContext(args[0]), args),
            };
        });
        session.addProtocolHandler('_vue:getComponentNames', ({ arguments: args }) => {
            return {
                response: getComponentNames_1.getComponentNames.apply(getRequestContext(args[0]), args) ?? [],
            };
        });
        session.addProtocolHandler('_vue:getComponentProps', ({ arguments: args }) => {
            return {
                response: getComponentProps_1.getComponentProps.apply(getRequestContext(args[0]), args),
            };
        });
        session.addProtocolHandler('_vue:getComponentSlots', ({ arguments: args }) => {
            return {
                response: getComponentSlots_1.getComponentSlots.apply(getRequestContext(args[0]), args),
            };
        });
        session.addProtocolHandler('_vue:getElementAttrs', ({ arguments: args }) => {
            return {
                response: getElementAttrs_1.getElementAttrs.apply(getRequestContext(args[0]), args),
            };
        });
        session.addProtocolHandler('_vue:getElementNames', ({ arguments: args }) => {
            return {
                response: getElementNames_1.getElementNames.apply(getRequestContext(args[0]), args),
            };
        });
        projectService.logger.info('Vue specific commands are successfully added.');
    }
    function getRequestContext(fileName) {
        const fileAndProject = info.session.getFileAndProject({
            file: fileName,
            projectFileName: undefined,
        });
        const service = project2Service.get(fileAndProject.project);
        if (!service) {
            throw 'No RequestContext';
        }
        return {
            typescript: ts,
            languageService: service[2],
            languageServiceHost: service[1],
            language: service[0],
        };
    }
});
//# sourceMappingURL=index.js.map