//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_MATERIAL_OVERRIDE_SCHEMA_H
#define PXR_IMAGING_HD_MATERIAL_OVERRIDE_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"
#include "pxr/imaging/hd/schemaTypeDefs.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_MATERIAL_OVERRIDE_SCHEMA_TOKENS \
    (materialOverride) \
    (interfaceValues) \

TF_DECLARE_PUBLIC_TOKENS(HdMaterialOverrideSchemaTokens, HD_API,
    HD_MATERIAL_OVERRIDE_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------

// The MaterialOverride schema allows overrides to be made to the material's
// public UI. Overrides can be applied to both material or geometry scene
// index prim locations.
//
// The following is an example of a material override. The data source to
// author an override on the public UI name "globalSpecularKface" would look
// like this:
//
// ds at: materialOverride/interfaceValues/globalSpecularKface/value = 0.666
//
// There needs to be an interface mapping defined for "globalSpecularKface",
// which could look like this:
//
// ds at: material/<renderContext>/interfaceMappings/
// globalSpecularKface/[0]/nodePath = MaterialLayer
//
// ds at: material/<renderContext>/interfaceMappings/
// globalSpecularKface/[0]/inputName = specularKface
//
// The above means that the "globalSpecularKface" public UI name will map to
// the node parameter "specularKface", and for example, this node parameter
// may already have a data source for its value:
//
// ds at: material/<renderContext>/nodes/MaterialLayer/parameters/
// specularKface/value = 0.222
//
// After resolving the material override, the data source of the node
// parameter's value is replaced by the overriding value data source.
//
// ds at: material/<renderContext>/nodes/MaterialLayer/parameters/
// specularKface/value = 0.666
//
// Note that the MaterialOverride schema does not specify a render context
// token because material overrides are high-level and do not need to know
// about implementation details--they just need to specify an overriding data
// source. By contrast, the contents of a material network do specify a render
// context token in order to define the material nodes and interface mappings
// --you can imagine that a Renderman vs Storm implementation of a material
// network would be quite different.
//
// See also the Material schema documentation for ASCII art diagram.
//

class HdMaterialOverrideSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdMaterialOverrideSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "materialOverride" from the parent container and constructs a
    /// HdMaterialOverrideSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdMaterialOverrideSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    /// Maps interface names (ie. public UI names) to overriding data sources
    /// that follow the MaterialNodeParameter schema.
    HD_API
    HdMaterialNodeParameterContainerSchema GetInterfaceValues() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdContainerDataSourceHandle &interfaceValues
    );

    /// \class HdMaterialOverrideSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetInterfaceValues(
            const HdContainerDataSourceHandle &interfaceValues);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdContainerDataSourceHandle _interfaceValues;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif