/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.legacy;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Objects;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.legacy.LegacyNumericType;
import org.apache.solr.legacy.LegacyNumericUtils;

@Deprecated
public final class LegacyNumericRangeQuery<T extends Number>
extends MultiTermQuery {
    final int precisionStep;
    final LegacyNumericType dataType;
    final T min;
    final T max;
    final boolean minInclusive;
    final boolean maxInclusive;
    static final long LONG_NEGATIVE_INFINITY = NumericUtils.doubleToSortableLong((double)Double.NEGATIVE_INFINITY);
    static final long LONG_POSITIVE_INFINITY = NumericUtils.doubleToSortableLong((double)Double.POSITIVE_INFINITY);
    static final int INT_NEGATIVE_INFINITY = NumericUtils.floatToSortableInt((float)Float.NEGATIVE_INFINITY);
    static final int INT_POSITIVE_INFINITY = NumericUtils.floatToSortableInt((float)Float.POSITIVE_INFINITY);

    private LegacyNumericRangeQuery(String field, int precisionStep, LegacyNumericType dataType, T min, T max, boolean minInclusive, boolean maxInclusive) {
        super(field, MultiTermQuery.CONSTANT_SCORE_REWRITE);
        if (precisionStep < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.precisionStep = precisionStep;
        this.dataType = Objects.requireNonNull(dataType, "LegacyNumericType must not be null");
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    public static LegacyNumericRangeQuery<Long> newLongRange(String field, int precisionStep, Long min, Long max, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Long>(field, precisionStep, LegacyNumericType.LONG, min, max, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Long> newLongRange(String field, Long min, Long max, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Long>(field, 16, LegacyNumericType.LONG, min, max, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Integer> newIntRange(String field, int precisionStep, Integer min, Integer max, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Integer>(field, precisionStep, LegacyNumericType.INT, min, max, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Integer> newIntRange(String field, Integer min, Integer max, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Integer>(field, 8, LegacyNumericType.INT, min, max, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Double> newDoubleRange(String field, int precisionStep, Double min, Double max, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Double>(field, precisionStep, LegacyNumericType.DOUBLE, min, max, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Double> newDoubleRange(String field, Double min, Double max, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Double>(field, 16, LegacyNumericType.DOUBLE, min, max, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Float> newFloatRange(String field, int precisionStep, Float min, Float max, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Float>(field, precisionStep, LegacyNumericType.FLOAT, min, max, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Float> newFloatRange(String field, Float min, Float max, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Float>(field, 8, LegacyNumericType.FLOAT, min, max, minInclusive, maxInclusive);
    }

    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        if (this.min != null && this.max != null && ((Comparable)this.min).compareTo(this.max) > 0) {
            return TermsEnum.EMPTY;
        }
        return new NumericRangeTermsEnum(terms.iterator());
    }

    public boolean includesMin() {
        return this.minInclusive;
    }

    public boolean includesMax() {
        return this.maxInclusive;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public int getPrecisionStep() {
        return this.precisionStep;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.getField().equals(field)) {
            sb.append(this.getField()).append(':');
        }
        return sb.append(this.minInclusive ? (char)'[' : '{').append(this.min == null ? "*" : this.min.toString()).append(" TO ").append(this.max == null ? "*" : this.max.toString()).append(this.maxInclusive ? (char)']' : '}').toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof LegacyNumericRangeQuery) {
            LegacyNumericRangeQuery q = (LegacyNumericRangeQuery)((Object)o);
            return Objects.equals(q.min, this.min) && Objects.equals(q.max, this.max) && this.minInclusive == q.minInclusive && this.maxInclusive == q.maxInclusive && this.precisionStep == q.precisionStep;
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.precisionStep;
        hash = 31 * hash + Objects.hashCode(this.min);
        hash = 31 * hash + Objects.hashCode(this.max);
        hash = 31 * hash + Boolean.hashCode(this.minInclusive);
        hash = 31 * hash + Boolean.hashCode(this.maxInclusive);
        return hash;
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    private final class NumericRangeTermsEnum
    extends FilteredTermsEnum {
        private BytesRef currentLowerBound;
        private BytesRef currentUpperBound;
        private final ArrayDeque<BytesRef> rangeBounds;

        NumericRangeTermsEnum(TermsEnum tenum) {
            super(tenum);
            this.rangeBounds = new ArrayDeque();
            switch (LegacyNumericRangeQuery.this.dataType) {
                case LONG: 
                case DOUBLE: {
                    long maxBound;
                    long minBound;
                    if (LegacyNumericRangeQuery.this.dataType == LegacyNumericType.LONG) {
                        minBound = LegacyNumericRangeQuery.this.min == null ? Long.MIN_VALUE : ((Number)LegacyNumericRangeQuery.this.min).longValue();
                    } else {
                        assert (LegacyNumericRangeQuery.this.dataType == LegacyNumericType.DOUBLE);
                        long l = minBound = LegacyNumericRangeQuery.this.min == null ? LONG_NEGATIVE_INFINITY : NumericUtils.doubleToSortableLong((double)((Number)LegacyNumericRangeQuery.this.min).doubleValue());
                    }
                    if (!LegacyNumericRangeQuery.this.minInclusive && LegacyNumericRangeQuery.this.min != null) {
                        if (minBound == Long.MAX_VALUE) break;
                        ++minBound;
                    }
                    if (LegacyNumericRangeQuery.this.dataType == LegacyNumericType.LONG) {
                        maxBound = LegacyNumericRangeQuery.this.max == null ? Long.MAX_VALUE : ((Number)LegacyNumericRangeQuery.this.max).longValue();
                    } else {
                        assert (LegacyNumericRangeQuery.this.dataType == LegacyNumericType.DOUBLE);
                        long l = maxBound = LegacyNumericRangeQuery.this.max == null ? LONG_POSITIVE_INFINITY : NumericUtils.doubleToSortableLong((double)((Number)LegacyNumericRangeQuery.this.max).doubleValue());
                    }
                    if (!LegacyNumericRangeQuery.this.maxInclusive && LegacyNumericRangeQuery.this.max != null) {
                        if (maxBound == Long.MIN_VALUE) break;
                        --maxBound;
                    }
                    LegacyNumericUtils.splitLongRange(new LegacyNumericUtils.LongRangeBuilder(){

                        @Override
                        public final void addRange(BytesRef minPrefixCoded, BytesRef maxPrefixCoded) {
                            NumericRangeTermsEnum.this.rangeBounds.add(minPrefixCoded);
                            NumericRangeTermsEnum.this.rangeBounds.add(maxPrefixCoded);
                        }
                    }, LegacyNumericRangeQuery.this.precisionStep, minBound, maxBound);
                    break;
                }
                case INT: 
                case FLOAT: {
                    int maxBound;
                    int minBound;
                    if (LegacyNumericRangeQuery.this.dataType == LegacyNumericType.INT) {
                        minBound = LegacyNumericRangeQuery.this.min == null ? Integer.MIN_VALUE : ((Number)LegacyNumericRangeQuery.this.min).intValue();
                    } else {
                        assert (LegacyNumericRangeQuery.this.dataType == LegacyNumericType.FLOAT);
                        int n = minBound = LegacyNumericRangeQuery.this.min == null ? INT_NEGATIVE_INFINITY : NumericUtils.floatToSortableInt((float)((Number)LegacyNumericRangeQuery.this.min).floatValue());
                    }
                    if (!LegacyNumericRangeQuery.this.minInclusive && LegacyNumericRangeQuery.this.min != null) {
                        if (minBound == Integer.MAX_VALUE) break;
                        ++minBound;
                    }
                    if (LegacyNumericRangeQuery.this.dataType == LegacyNumericType.INT) {
                        maxBound = LegacyNumericRangeQuery.this.max == null ? Integer.MAX_VALUE : ((Number)LegacyNumericRangeQuery.this.max).intValue();
                    } else {
                        assert (LegacyNumericRangeQuery.this.dataType == LegacyNumericType.FLOAT);
                        int n = maxBound = LegacyNumericRangeQuery.this.max == null ? INT_POSITIVE_INFINITY : NumericUtils.floatToSortableInt((float)((Number)LegacyNumericRangeQuery.this.max).floatValue());
                    }
                    if (!LegacyNumericRangeQuery.this.maxInclusive && LegacyNumericRangeQuery.this.max != null) {
                        if (maxBound == Integer.MIN_VALUE) break;
                        --maxBound;
                    }
                    LegacyNumericUtils.splitIntRange(new LegacyNumericUtils.IntRangeBuilder(){

                        @Override
                        public final void addRange(BytesRef minPrefixCoded, BytesRef maxPrefixCoded) {
                            NumericRangeTermsEnum.this.rangeBounds.add(minPrefixCoded);
                            NumericRangeTermsEnum.this.rangeBounds.add(maxPrefixCoded);
                        }
                    }, LegacyNumericRangeQuery.this.precisionStep, minBound, maxBound);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid LegacyNumericType");
                }
            }
        }

        private void nextRange() {
            assert (this.rangeBounds.size() % 2 == 0);
            this.currentLowerBound = this.rangeBounds.removeFirst();
            assert (this.currentUpperBound == null || this.currentUpperBound.compareTo(this.currentLowerBound) <= 0) : "The current upper bound must be <= the new lower bound";
            this.currentUpperBound = this.rangeBounds.removeFirst();
        }

        protected final BytesRef nextSeekTerm(BytesRef term) {
            while (this.rangeBounds.size() >= 2) {
                this.nextRange();
                if (term != null && term.compareTo(this.currentUpperBound) > 0) continue;
                return term != null && term.compareTo(this.currentLowerBound) > 0 ? term : this.currentLowerBound;
            }
            assert (this.rangeBounds.isEmpty());
            this.currentUpperBound = null;
            this.currentLowerBound = null;
            return null;
        }

        protected final FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
            while (this.currentUpperBound == null || term.compareTo(this.currentUpperBound) > 0) {
                if (this.rangeBounds.isEmpty()) {
                    return FilteredTermsEnum.AcceptStatus.END;
                }
                if (term.compareTo(this.rangeBounds.getFirst()) < 0) {
                    return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
                }
                this.nextRange();
            }
            return FilteredTermsEnum.AcceptStatus.YES;
        }
    }
}

