#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-EYXoemxXY7jVJjoceGpiD
key:                  postgrest-10.0.0-EYXoemxXY7jVJjoceGpiD
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  fe9c8811934d539dbe3fa9b4d9e8d748
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-EYXoemxXY7jVJjoceGpiD
depends:
    HTTP-4000.4.1-8FfNLm2ZwrO6ImYKxGq8XQ
    Ranged-sets-0.5.0-GuObAVwrfwbClueUGt3399
    aeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf
    auto-update-0.1.6-Luw2FWFJd1vHOd5jEfKz9t base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-A6Av13j1PriHVZgHNthY8h
    cassava-0.5.4.1-IlL8GBkt7ZLwaUFuWaj0P
    configurator-pg-0.2.10-C4Z6LClp1Tz44XjpLewUrL containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-XHTPzGYQ146hY1b6mRqdU
    gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hasql-1.5.0.5-H1dFKLsRNs74rHQFYgDoaZ
    hasql-dynamic-statements-0.3.1.1-3yTQN4EGOJNFBuO26auo4f
    hasql-notifications-0.2.0.5-2e28fle8UgQ1VfQqKD4ULi
    hasql-pool-0.5.2.2-9qKkG3b2PTOnkLZaHuIPS
    hasql-transaction-1.0.1.1-1rpHYUBe2Pb2OZhcijpFIX
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-75PPyaYnKWt41SOfuGm1SN
    insert-ordered-containers-0.2.5.3-7oXPMsW0cdB1m8mo7BwZiT
    interpolatedstring-perl6-1.0.2-Jsch6qZNU3VDa99rNmLoDG
    jose-0.10-IFOB5i4ZaJivDk5qx61x5 lens-5.3.1-HP4sFfbh3y9B4laWgY1DEm
    lens-aeson-1.2.3-4hWEVRkL0S61v7qgPvbKyt mtl-2.2.2
    network-3.1.4.0-18zdZgmnDKE1J4Hp557YCB
    network-uri-2.6.4.2-95fWnkSq4twGVejB9ewxKe
    optparse-applicative-0.18.1.0-ImNwmQfwdUdQZElVvxe6u parsec-3.1.16.1
    protolude-0.3.5-8dslaRqjC6ADNKPrc0gvwF
    regex-tdfa-1.3.2.4-6komq1p5pxY9JApKLJtftx
    retry-0.9.3.1-37HIM5RXVDqF7QH0eQ7XMX
    scientific-0.3.8.0-DLDr5nembSsHeUMWxBP2Rn
    swagger2-2.8.10-2F8oxSkgD7lHXAdFu50AQx text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-BdnqkwZm9bx6ocoMK9HG74
    vault-0.3.1.5-3Au2iFbDEFy22Bet4kLhma
    vector-0.13.2.0-B5pfN7kp2sVHpMWItbJQ58
    wai-3.2.4-4DSUxPBVo3aDU1FL8Kb4AX
    wai-cors-0.2.7-As8l6LEF1Z2DgVODnBCRlD
    wai-extra-3.1.17-7sOIMyXdW19GMJAKYRA1MK
    wai-logger-2.5.0-FHT0Ms4P7UY2ZAKEDo42zW
    warp-3.3.30-L8efBONiiYN1bELlbKsQBo

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

